package zpplet.machine;

import zpplet.ZUserConfig;
import zpplet.data.ZDictionary4;
import zpplet.data.ZObjectTree4;
import zpplet.header.ZHeader4;
import zpplet.ops.ZInstruction4;
import zpplet.system.ZScreen;

public class ZMachine4
		extends ZMachine3
	{

	public ZMachine4(byte[] mem, ZScreen screen)
		{
		super(mem, screen);
		}
	
	protected void initStructures()
		{
		hd = new ZHeader4(m);
		objs = new ZObjectTree4(this);
		zd = new ZDictionary4(this);
		zi = new ZInstruction4(this);
		}
	
	protected void initWindows()
		{
		makeTwoWindows();
		
		// init windows
		w[0].moveTo(1, 1);
		w[0].resize(s.getChars(), s.getLines());
		w[0].moveCursor(1, w[0].getLines());
		
		w[1].moveTo(1, 1); 
		w[1].resize(0, 0);
		}

	public int unpackSAddr(int addr)
		{
		return addr * 4;
		}

	public int unpackRAddr(int addr)
		{
		return addr * 4;
		}

	public void setHeaderFlags()
		{
		ZHeader4 header = (ZHeader4)this.hd;

		header.setRevision(STANDARDS_VERSION_MAJOR, STANDARDS_VERSION_MINOR);
		if (header.isFixedForced())
			ZUserConfig.normalfont = ZUserConfig.fixedfont;
		
		// screen model flags
		header.setBoldAvailable(true);
		header.setItalicAvailable(true);
		header.setFixedFontAvailable(true);
		header.setTimedInputAvailable(true);
		header.setSoundAvailable(media != null);

		header.setInterpreterInfo(ZUserConfig.interpreter, INTERPRETER_VERSION);
		header.setScreenDimensions(s.getLines(), s.getChars());
		}
	
	public void updateStatusLine()
		{} // not available anymore

	public void resize()
		{
		super.resize();
		((ZHeader4)hd).setScreenDimensions(s.getLines(), s.getChars());
		}
	}