package zpplet.system;

import java.awt.*;

class ZCursor
		extends Thread
	{
	private Color color;
	private boolean visible, showing;
	int top, left, width, height;
	private Component parent;

	ZCursor(Component parent)
		{
		super();
		this.parent = parent;
		color = Color.BLACK;
		visible = false;
		setDaemon(true);
		start();
		}

	public void run()
		{
		showing = true;
		while (true)
			try
				{
				refresh();
				if (visible)
					{
					sleep(showing ? 500 : 300);
					showing = !showing;
					}
				else
					sleep(Long.MAX_VALUE);
				}
			catch (InterruptedException e)
				{
				showing = true;
				}
		}

	synchronized void setVisible(boolean value)
		{
		visible = value;
		interrupt();
		}
	
	boolean isVisible()
		{
		return visible;
		}

	synchronized private void refresh()
		{
		if (visible && showing && parent.isFocusOwner())
			draw(parent.getGraphics());
		else
			parent.repaint(left, top, width, height);
		Toolkit.getDefaultToolkit().sync();
		}
	
	synchronized void draw(Graphics g)
		{
		g.setColor(color);
		g.fillRect(left, top, width, height);
		}

	void paint(Graphics g)
		{
		if (visible && showing && parent.isFocusOwner())
			draw(g);
		}

	synchronized void setBounds(int left, int top, int width, int height)
		{
		this.left = left;
		this.top = top;
		this.width = width;
		this.height = height;
		}
	
	void move(int left, int top)
		{
		if ((left == this.left) && (top == this.top))
			return;
		
		boolean v = visible;
		if (v) setVisible(false);

		this.left = left;
		this.top = top;

		if (v) setVisible(true);
		}

	void setColor(Color color)
		{
		this.color = color;
		}
	}