//---------------------------------------------------------------------------

#ifndef zclassH
#define zclassH

#include "vmclass.h"

struct STACK
{
int return_pc;
unsigned char local_count;
unsigned char result_var;
unsigned char args;
unsigned short stack_count;
unsigned short local[15];
unsigned short stack[40];
};

struct object
{
unsigned short num;
unsigned short parent;
unsigned short sibling;
unsigned short child;
};


class ZMACHINE : public VM
{
public:
  void run_story();

private:
  void prepare_header();
  void adjust_screen_size();
  void main_loop();
  void var_opcode();
  void short_opcode();
  void long_opcode();
  unsigned char get_var_args(unsigned short *argv);
  unsigned short read_var(unsigned char var);
  unsigned short pop_stack();
  unsigned short read_stack();
  unsigned short read_local(unsigned char num);
  unsigned short read_global(unsigned char num);
  void call(unsigned short routine,unsigned char argc,unsigned short *argv,bool write_result,bool int_call);
  void write_var(unsigned short value, unsigned char var);
  void push_stack(unsigned short value);
  void write_stack(unsigned short value);
  void write_local(unsigned short value, unsigned char num);
  void write_global(unsigned short value, unsigned char num);
  void branch(bool result);
  void ret_routine(unsigned short result);
  unsigned short prop_addr(unsigned short obj,unsigned char prop);
  unsigned short obj_props(unsigned short obj);
  int obj_address(unsigned short obj);
  void do_print(String text);
  object read_obj(unsigned short obj);
  void write_obj(object obj);
  void parse_text(String input,unsigned short parse,unsigned short dictionary,bool skip_unknown);
  bool word_sep(char letter, char separator[], unsigned char sep_count);
  int get_text_length(WideString text);
  void save_to_stream(TMemoryStream *game);
  bool restore_from_stream(TStream *game);
  void init_exe();
  void update_status();
  void toggle_script();
  String read_text(int address,bool jump);
  String uni_to_zscii(WideString in);
  WideString zscii_to_uni(String in);
  unsigned char v2_args(unsigned short *argv);
  void toggle_recording(bool start);
  void check_playback(wchar_t *buffer,int limit);
  void split_window(unsigned char lines);
  unsigned char translate_term_char(unsigned int keycode);
  TColor color_from_srgb(unsigned short color);

  void Z_call(unsigned short routine,unsigned char argc,unsigned short *argv);
  void Z_add(short a, short b);
  void Z_je(unsigned char argc, unsigned short num[]);
  void Z_sub(short a, short b);
  void Z_jz(unsigned short a);
  void Z_storew(unsigned short array, unsigned short index, unsigned short value);
  void Z_ret(unsigned short result);
  void Z_loadw(unsigned short array, unsigned short index);
  void Z_jump(short offset);
  void Z_put_prop(unsigned short obj, unsigned char prop, unsigned short value);
  void Z_store(unsigned char var, unsigned short value);
  void Z_test_attr(unsigned short obj, unsigned char attr);
  void Z_print();
  void Z_new_line();
  void Z_loadb(unsigned short array, unsigned short index);
  void Z_and(unsigned short a, unsigned short b);
  void Z_print_num(short num);
  void Z_inc_chk(unsigned char var,short value);
  void Z_print_char(char zscii);
  void Z_rtrue();
  void Z_insert_obj(unsigned short obj, unsigned short dest);
  void Z_push(unsigned short value);
  void Z_pull(unsigned char var);
  void Z_set_attr(unsigned short obj, unsigned char attr);
  void Z_jin(unsigned short a, unsigned short b);
  void Z_print_obj(unsigned short obj);
  void Z_get_parent(unsigned short a);
  void Z_get_prop(unsigned short obj, unsigned char prop);
  void Z_get_child(unsigned short a);
  void Z_get_sibling(unsigned short a);
  void Z_inc(unsigned char var);
  void Z_jl(short a, short b);
  void Z_rfalse();
  void Z_ret_popped();
  void Z_read(int argc,unsigned short text, unsigned short parse,unsigned short time,unsigned short routine);
  void Z_dec_chk(unsigned char var,short value);
  void Z_test(unsigned short bitmap, unsigned short flags);
  void Z_jg(short a, short b);
  void Z_mul(short a, short b);
  void Z_storeb(unsigned short array, unsigned short index, unsigned char value);
  void Z_clear_attr(unsigned short obj, unsigned char attr);
  void Z_print_ret();
  void Z_or(unsigned short a, unsigned short b);
  void Z_get_prop_addr(unsigned short obj, unsigned char prop);
  void Z_get_next_prop(unsigned short obj, unsigned char prop);
  void Z_div(short a, short b);
  void Z_mod(short a, short b);
  void Z_random(short range);
  void Z_get_prop_len(unsigned short address);
  void Z_dec(unsigned char var);
  void Z_print_addr(unsigned short address);
  void Z_remove_obj(unsigned short obj);
  void Z_print_paddr(unsigned short address);
  void Z_load(unsigned char var);
  void Z_not(unsigned short num);
  void Z_nop();
  void Z_save(bool aux_file=false,unsigned short table=0,unsigned short bytes=0,unsigned short name=0);
  void Z_restore();
  void Z_restart();
  void Z_pop();
  void Z_catch();
  void Z_throw(unsigned short result, unsigned short frame);
  void Z_quit();
  void Z_show_status();
  void Z_verify();
  void Z_split_window(unsigned char lines);
  void Z_set_window(unsigned char window);
  void Z_call_2s(unsigned short routine,unsigned short argv);
  void Z_erase_window(short window);
  void Z_buffer_mode(bool flag);
  void Z_set_text_style(unsigned char style);
  void Z_set_cursor(unsigned short line,unsigned short column);
  void Z_call_1s(unsigned short routine);
  void Z_read_char(bool timer,unsigned short time,unsigned short routine);
  void Z_output_stream(short stream,unsigned short table);
  void Z_scan_table(unsigned char argc,unsigned short x,unsigned short table,unsigned short len,unsigned char form);
  void Z_call_vs2();
  void Z_sound_effect(unsigned char argc,unsigned char sound,unsigned char effect,unsigned short volume,unsigned short routine);
  void Z_input_stream(unsigned char stream);
  void Z_call_1n(unsigned short routine);
  void Z_call_vn(unsigned short routine,unsigned char argc,unsigned short *argv);
  void Z_check_arg_count(unsigned char arg);
  void Z_call_2n(unsigned short routine,unsigned short argv);
  void Z_copy_table(unsigned short src,unsigned short dest,short size);
  void Z_call_vn2();
  void Z_tokenise(unsigned char argc,unsigned short text,unsigned short parse,unsigned short dictionary,bool flag);
  void Z_encode_text(unsigned short zscii_text,unsigned short length,unsigned short from,unsigned short coded_text);
  void Z_print_table(unsigned char argc,unsigned short text_add,unsigned short width,unsigned short height,unsigned short skip);
  void Z_log_shift(short num,short places);
  void Z_art_shift(short num,short places);
  void Z_save_undo();
  void Z_restore_undo();
  void Z_ext();
  void Z_set_font(unsigned char font);
  void Z_set_color(unsigned char foreground,unsigned char background);
  void Z_set_true_color(short foreground,short background);
  void Z_check_unicode(unsigned short char_number);
  void Z_print_unicode(unsigned short char_number);

  int dict;
  int frame_count;
  STACK stack[500];
  unsigned int op_base;
  int pack;
  bool int_result;
  char alpha[3][26];
  bool stream1,stream2,stream3,stream4;
  String stream3_text[16];
  int stream3_level;
  unsigned short stream3_loc[16];
  wchar_t unicode_table[96];
  int unicode_table_size;
  TFileStream *scriptf,*recordf,*playf;
  int last_split,max_split;
  bool split_before;
  int upper_win;
  bool old_moring;
  bool playback;
  String output;
  bool buffering;
  bool fixed_font1,fixed_font2,fixed_font3;
  unsigned short sound_routine;
  int upper_stream;
  bool mouse_active;
};

//---------------------------------------------------------------------------
#endif
