


/*
 * GtkScare is a runner for Adrift text adventure games.
 * This program is released under GNU GPL. See the file COPYING.TXT for
 * details.
 * Copyright (c) 2004 Pallav Nawani
 *
 */


/*! 
*
* \file config.c
* 	No description yet
* 
*/


#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gtk/gtk.h"

#include "interface.h"
#include "support.h"
#include "rogue.h"
#include "config.h"


extern Gtk_sdata *idata;



//==///////////////////////////////////////////////////////////////////
//
/// Read configuration data from user's home directory.
///
/// \param
///	
/// \return
///	
//==///////////////////////////////////////////////////////////////////
void Config_data:: rg_read_config( )
{
   char *homedir;
   char *fname;

   FILE *fptr;
   
   homedir = getenv("HOME");
   fname = (char *)malloc(strlen(homedir)+strlen(".gtkscarerc")+2);
   sprintf(fname, "%s/.gtkscarerc", homedir);
   
   fptr = fopen(fname, "rb");
   if(NULL == fptr)
      return;

   // Read previous filenames
   if(fread(prevfiles,
   	 sizeof(char),
	 CONFIG_STR_NUM*CONFIG_STR_MAX,
	 fptr) != CONFIG_STR_NUM*CONFIG_STR_MAX)
   {
      fclose(fptr);
      return;
   }

   // Read the number of files opened
   if(fread(&num_prev_files, sizeof(int), 1, fptr) != 1)
   {
      fclose(fptr);
      return;
   }


   // Read verbosity status
   if(fread(&verbosity, sizeof(int), 1, fptr) != 1)
   {
      fclose(fptr);
      return;
   }

   // Read text background color
   if(fread(&bgcol, sizeof(GdkColor), 1, fptr) != 1)
   {
      fclose(fptr);
      return;
   }

   // Read text foreground color
   if(fread(&fgcol, sizeof(GdkColor), 1, fptr) != 1)
   {
      fclose(fptr);
      return;
   }
   
   fclose(fptr);

}




//==///////////////////////////////////////////////////////////////////
//
/// Write configuration data to user's home directory.
///
/// \param
///	
/// \return
///	
//==///////////////////////////////////////////////////////////////////
void  Config_data:: write_config()
{
   char *homedir;
   char *fname;

   FILE *fptr;
   
   homedir = getenv("HOME");
   fname = (char *)malloc(strlen(homedir)+strlen(".gtkscarerc")+2);
   sprintf(fname, "%s/.gtkscarerc", homedir);
   
   fptr = fopen(fname, "wb");
   if(NULL == fptr)
      return;

   // Read previous filenames
   if(fwrite(prevfiles,
   	 sizeof(char),
	 CONFIG_STR_NUM*CONFIG_STR_MAX,
	 fptr) != CONFIG_STR_NUM*CONFIG_STR_MAX)
   {
      fclose(fptr);
      return;
   }

   // Read the number of files opened
   if(fwrite(&num_prev_files, sizeof(int), 1, fptr) != 1)
   {
      fclose(fptr);
      return;
   }


   // Read verbosity status
   if(fwrite(&verbosity, sizeof(int), 1, fptr) != 1)
   {
      fclose(fptr);
      return;
   }

   // Read text background color
   if(fwrite(&bgcol, sizeof(GdkColor), 1, fptr) != 1)
   {
      fclose(fptr);
      return;
   }

   // Read text foreground color
   if(fwrite(&fgcol, sizeof(GdkColor), 1, fptr) != 1)
   {
      fclose(fptr);
      return;
   }
   
   fclose(fptr);

}



//==///////////////////////////////////////////////////////////////////
//
/// Saves the notes to a text file in the user directory so that they
/// can be loaded when rogue starts again
///
/// \param
///	fname:	Full path for the text file.
/// \return
///	
//==///////////////////////////////////////////////////////////////////
void rg_save_notes(Gtk_sdata *idata)
{

   char *fname;
   char *homedir;
   char *buf;

   FILE *fptr;
   
   GtkTextBuffer *tbuf;
   GtkTextIter giter;
   GtkTextIter giterstart;
   
   homedir = getenv("HOME");
   fname = (char *)malloc(strlen(homedir)+strlen(".rogue_notes")+2);
   sprintf(fname, "%s/.rogue_notes", homedir);

   fptr = fopen(fname, "wa");
   free(fname);
   if(NULL == fptr) {
      return;
   }

   tbuf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(idata->notesw));
   gtk_text_buffer_get_start_iter(tbuf, &giterstart);
   gtk_text_buffer_get_end_iter(tbuf, &giter);
   buf = gtk_text_buffer_get_text(tbuf, &giterstart, &giter, FALSE);
   fprintf(fptr, "%s", buf);
   fclose(fptr);
      
}




//==///////////////////////////////////////////////////////////////////
//
/// Opens the notest file and shows it in the notes widget.
///
/// \param
///	fname:	Full path for the text file.
/// \return
///	
//==///////////////////////////////////////////////////////////////////
void rg_load_notes(Gtk_sdata *idata)
{

   char *fname;
   char *homedir;
   char *buf;
   int done;

   FILE *fptr;

   GtkWidget *info;
   GtkTextBuffer *tbuf;
   GtkTextIter giter;
 
   homedir = getenv("HOME");
   fname = (char *)malloc(strlen(homedir)+strlen(".rogue_notes")+2);
   sprintf(fname, "%s/.rogue_notes", homedir);
   buf = (char *)malloc(strlen(fname) + 256);

   fptr = fopen(fname, "ra");

   if(NULL == fptr) {
      sprintf(buf, "Could not open the notes file %s\n", fname);
      info = create_about_dlg("Oops!", buf);
      gtk_widget_show(info);
      free(buf);
      free(fname);
      return;
   }

   tbuf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(idata->notesw));
   gtk_text_buffer_get_end_iter(tbuf, &giter);

   while(!feof(fptr)) {
      done = fread(buf, 1, 255, fptr);
      gtk_text_buffer_insert(tbuf, &giter, buf, done);
      if(done < 255)
	 break;
   }

   free(fname);
   free(buf);
   fclose(fptr);


}



//==///////////////////////////////////////////////////////////////////
//
/// Apply the configuration values to Rogue
///
/// \param
///	idata: Holds all the Rogue data.
/// \return
///	
//==///////////////////////////////////////////////////////////////////
void rg_apply_config(Gtk_sdata *idata)
{

  GtkCheckMenuItem *menuitem;

   // Apply verbosity values
   menuitem = (GtkCheckMenuItem *)lookup_widget(idata->mwin,
  	 "verbose_mode");

   gtk_check_menu_item_set_active(menuitem,
  	 idata->cdata.verbosity);

   // Apply foreground color
   gtk_widget_modify_text(GTK_WIDGET(idata->textw),
	 GTK_STATE_NORMAL,
	 &(idata->cdata.fgcol));
   gtk_widget_modify_text(GTK_WIDGET(idata->notesw),
	 GTK_STATE_NORMAL,
	 &(idata->cdata.fgcol));

   // Apply background color
   gtk_widget_modify_base(GTK_WIDGET(idata->textw),
	 GTK_STATE_NORMAL,
	 &(idata->cdata.bgcol));
   gtk_widget_modify_base(GTK_WIDGET(idata->notesw),
	 GTK_STATE_NORMAL,
	 &(idata->cdata.bgcol));

   // Restore previous gamefile name
   strcpy(idata->name, idata->cdata.prevfiles[0]);

}



//==///////////////////////////////////////////////////////////////////
//
///
///
/// \param
///	
/// \return
///	
//==///////////////////////////////////////////////////////////////////


/*  End of file config.c  */

