




/*
 * GtkScare is a runner for Adrift text adventure games.
 * This program is released under GNU GPL. See the file COPYING.TXT for
 * details.
 * Copyright (c) 2004 Pallav Nawani
 *
 */




#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <ctype.h>

#include "gtk/gtk.h"
#include "gdk/gdkkeysyms.h"

#include "callbacks.h"
#include "debug_callbacks.h"
#include "interface.h"
#include "support.h"
#include "rogue.h"

extern Gtk_sdata *idata;



gboolean
on_debug_kill_event (GtkWidget *widget,
      GdkEventKey *event,
      gpointer user_data)
{

   idata->debugger = NULL;
   return FALSE;
}



void
on_dbg_gamebutton_clicked (GtkButton *button,
      gpointer user_data)
{
   GtkTextView *tview;
   GtkTextBuffer *tbuf;
   GtkTextIter giter;

   tview = (GtkTextView *)lookup_widget(GTK_WIDGET(button),
	 "debugtextview");
   tbuf = gtk_text_view_get_buffer(tview);
   gtk_text_buffer_get_end_iter(tbuf, &giter);
   gtk_text_buffer_insert_with_tags_by_name(tbuf,
	 &giter, "game\n", -1,
	 "userinput", NULL);

   sc_run_game_debugger_command(idata->rgame.scare.sgame, "game");
   if(idata->debuglog != NULL)
      fprintf(idata->debuglog, "game\n");

}


void
on_dbg_playerbutton_clicked (GtkButton *button,
      gpointer user_data)
{

   GtkTextView *tview;
   GtkTextBuffer *tbuf;
   GtkTextIter giter;

   tview = (GtkTextView *)lookup_widget(GTK_WIDGET(button),
	 "debugtextview");
   tbuf = gtk_text_view_get_buffer(tview);
   gtk_text_buffer_get_end_iter(tbuf, &giter);
   gtk_text_buffer_insert_with_tags_by_name(tbuf,
	 &giter, "player\n", -1,
	 "userinput", NULL);

   sc_run_game_debugger_command(idata->rgame.scare.sgame, "player");
   if(idata->debuglog != NULL)
      fprintf(idata->debuglog, "player\n");


}


void
on_dbg_roombutton_clicked (GtkButton *button,
      gpointer user_data)
{

   GtkTextView *tview;
   GtkTextBuffer *tbuf;
   GtkTextIter giter;

   tview = (GtkTextView *)lookup_widget(GTK_WIDGET(button),
	 "debugtextview");
   tbuf = gtk_text_view_get_buffer(tview);
   gtk_text_buffer_get_end_iter(tbuf, &giter);
   gtk_text_buffer_insert_with_tags_by_name(tbuf,
	 &giter, "rooms *\n", -1,
	 "userinput", NULL);

   sc_run_game_debugger_command(idata->rgame.scare.sgame, "rooms *");
   if(idata->debuglog != NULL)
      fprintf(idata->debuglog, "rooms *\n");


}


void
on_dbg_objectbutton_clicked (GtkButton *button,
      gpointer user_data)
{

   GtkTextView *tview;
   GtkTextBuffer *tbuf;
   GtkTextIter giter;

   tview = (GtkTextView *)lookup_widget(GTK_WIDGET(button),
	 "debugtextview");
   tbuf = gtk_text_view_get_buffer(tview);
   gtk_text_buffer_get_end_iter(tbuf, &giter);
   gtk_text_buffer_insert_with_tags_by_name(tbuf,
	 &giter, "objects *\n", -1,
	 "userinput", NULL);

   sc_run_game_debugger_command(idata->rgame.scare.sgame, "objects *");
   if(idata->debuglog != NULL)
      fprintf(idata->debuglog, "objects *\n");


}


void
on_dbg_npcbutton_clicked (GtkButton *button,
      gpointer user_data)
{

   GtkTextView *tview;
   GtkTextBuffer *tbuf;
   GtkTextIter giter;

   tview = (GtkTextView *)lookup_widget(GTK_WIDGET(button),
	 "debugtextview");
   tbuf = gtk_text_view_get_buffer(tview);
   gtk_text_buffer_get_end_iter(tbuf, &giter);
   gtk_text_buffer_insert_with_tags_by_name(tbuf,
	 &giter, "npcs *\n", -1,
	 "userinput", NULL);

   sc_run_game_debugger_command(idata->rgame.scare.sgame, "npcs *");
   if(idata->debuglog != NULL)
      fprintf(idata->debuglog, "npcs *\n");


}


void
on_dbg_taskbutton_clicked (GtkButton *button,
      gpointer user_data)
{

   GtkTextView *tview;
   GtkTextBuffer *tbuf;
   GtkTextIter giter;

   tview = (GtkTextView *)lookup_widget(GTK_WIDGET(button),
	 "debugtextview");
   tbuf = gtk_text_view_get_buffer(tview);
   gtk_text_buffer_get_end_iter(tbuf, &giter);
   gtk_text_buffer_insert_with_tags_by_name(tbuf,
	 &giter, "tasks *\n", -1,
	 "userinput", NULL);

   sc_run_game_debugger_command(idata->rgame.scare.sgame, "tasks *");
   if(idata->debuglog != NULL)
      fprintf(idata->debuglog, "tasks *\n");


}


void
on_dbg_eventbutton_clicked (GtkButton *button,
      gpointer user_data)
{

   GtkTextView *tview;
   GtkTextBuffer *tbuf;
   GtkTextIter giter;

   tview = (GtkTextView *)lookup_widget(GTK_WIDGET(button),
	 "debugtextview");
   tbuf = gtk_text_view_get_buffer(tview);
   gtk_text_buffer_get_end_iter(tbuf, &giter);
   gtk_text_buffer_insert_with_tags_by_name(tbuf,
	 &giter, "events *\n", -1,
	 "userinput", NULL);

   sc_run_game_debugger_command(idata->rgame.scare.sgame, "events *");
   if(idata->debuglog != NULL)
      fprintf(idata->debuglog, "events *\n");


}


void
on_dbg_variablebutton_clicked (GtkButton *button,
      gpointer user_data)
{

   GtkTextView *tview;
   GtkTextBuffer *tbuf;
   GtkTextIter giter;

   tview = (GtkTextView *)lookup_widget(GTK_WIDGET(button),
	 "debugtextview");
   tbuf = gtk_text_view_get_buffer(tview);
   gtk_text_buffer_get_end_iter(tbuf, &giter);
   gtk_text_buffer_insert_with_tags_by_name(tbuf,
	 &giter, "variables *\n", -1,
	 "userinput", NULL);

   sc_run_game_debugger_command(idata->rgame.scare.sgame, "variables *");
   if(idata->debuglog != NULL)
      fprintf(idata->debuglog, "variables *\n");


}


void
on_dbg_helpbutton_clicked (GtkButton *button,
      gpointer user_data)
{
   GtkTextView *tview;
   GtkTextBuffer *tbuf;
   GtkTextIter giter;

   tview = (GtkTextView *)lookup_widget(GTK_WIDGET(button),
	 "debugtextview");
   tbuf = gtk_text_view_get_buffer(tview);
   gtk_text_buffer_get_end_iter(tbuf, &giter);
   gtk_text_buffer_insert_with_tags_by_name(tbuf,
	 &giter, "help\n", -1,
	 "userinput", NULL);


   sc_run_game_debugger_command(idata->rgame.scare.sgame, "help");
   if(idata->debuglog != NULL)
      fprintf(idata->debuglog, "help\n");

}


void
on_dbg_closebutton_clicked (GtkButton *button,
      gpointer user_data)
{

   idata->debugger = NULL;
   gtk_widget_destroy((GtkWidget *)user_data);

}


void
on_debugentry_activate (GtkEntry *entry,
      gpointer user_data)
{

   GtkTextView *tview;
   GtkTextBuffer *tbuf;
   GtkTextIter giter;

   const gchar *text;
   gchar *instext;

   text  = gtk_entry_get_text(entry);
   instext = (gchar *)malloc(strlen(text)+2);
   if(NULL == instext)
      return;
   sprintf(instext, "%s\n", text);

   tview = (GtkTextView *)lookup_widget(GTK_WIDGET(entry),
	 "debugtextview");
   tbuf = gtk_text_view_get_buffer(tview);
   gtk_text_buffer_get_end_iter(tbuf, &giter);
   gtk_text_buffer_insert_with_tags_by_name(tbuf,
	 &giter, instext, -1,
	 "userinput", NULL);
   
   sc_run_game_debugger_command(idata->rgame.scare.sgame, text);
   if(idata->debuglog != NULL)
      fprintf(idata->debuglog, "%s\n", text);

   gtk_entry_set_text(entry, "");
   free(instext);

}


gboolean
on_debugentry_key_press_event (GtkWidget *widget,
      GdkEventKey *event,
      gpointer user_data)
{
  return FALSE;
}

