


/*
 * Rogue is a runner for Text adventure games.
 * This program is released under GNU GPL. See the file COPYING.TXT for
 * details.
 * Copyright (c) 2004 Pallav Nawani
 *
 */


/*
 * DO NOT EDIT THIS FILE - it is generated by Glade.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "debug_callbacks.h"
#include "interface.h"
#include "support.h"
#include "rogue.h"
#include "rogue_image.h"



#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  gtk_object_set_data_full (GTK_OBJECT (component), name, \
    gtk_widget_ref (widget), (GtkDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  gtk_object_set_data (GTK_OBJECT (component), name, widget)




GtkWidget*
create_main_win (Gtk_sdata *idata)
{
  GtkWidget *main_win;
  GtkWidget *vbox1;
  GtkWidget *vbox2;
  GtkWidget *vbox3;
  GtkWidget *hbox1;
  GtkWidget *menubar1;
  guint tmp_key;
  GtkWidget *game1;
  GtkWidget *game1_menu;
  GtkWidget *open_game;
  GtkWidget *restart_game;
  GtkWidget *separator1;
  GtkWidget *restore_game;
  GtkWidget *save_game_as;
  GtkWidget *quit_game;
  GtkWidget *separator2;
  GtkWidget *exit;
  GtkWidget *options;
  GtkWidget *options_menu;
  GtkWidget *set_display_font_color;
  GtkWidget *set_input_font_color;
  GtkWidget *set_font;
  GtkWidget *separator3;
  GtkWidget *clear_screen;
  GtkWidget *verbose_mode;
  GtkWidget *game_options;
  GtkWidget *game_options_menu;
  GtkWidget *undo1;
  GtkWidget *game_info;
  GtkWidget *open_game_info;
  GtkWidget *log_input;
  GtkWidget *separator4;
  GtkWidget *enable_debugger;
  GtkWidget *debugger_console;
  GtkWidget *help1;
  GtkWidget *help1_menu;
  GtkWidget *usual_commands;
  GtkWidget *about_gtkscare;
  GtkWidget *scrolledwindow1;
  GtkWidget *scrolledwindow2;
  GtkWidget *showtext;
  GtkWidget *textentry;
  GtkWidget *statusbar;
  GtkAccelGroup *accel_group;
  GtkTooltips *tooltips;
  GtkWidget *text_label;
  GtkWidget *infotext;
  GtkWidget *shortcuts;

  GError *gr;
  GtkTextIter giter;
  GtkTextBuffer *tbuf;
  GdkPixbuf *gp;

  tooltips = gtk_tooltips_new ();
  accel_group = gtk_accel_group_new ();

  main_win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (main_win), "main_win", main_win);
  //gtk_container_set_border_width (GTK_CONTAINER (main_win), 2);
  gtk_window_set_title (GTK_WINDOW (main_win), "R O G U E");

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (main_win), vbox1);

  menubar1 = gtk_menu_bar_new ();
  gtk_widget_ref (menubar1);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "menubar1", menubar1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menubar1);
  gtk_box_pack_start (GTK_BOX (vbox1), menubar1, FALSE, FALSE, 0);

  game1 = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (game1)->child),
                                   "_Game");
  gtk_widget_ref (game1);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "game1", game1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (game1);
  gtk_container_add (GTK_CONTAINER (menubar1), game1);

  game1_menu = gtk_menu_new ();
  gtk_widget_ref (game1_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "game1_menu", game1_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (game1), game1_menu);
  gtk_menu_set_accel_group(GTK_MENU(game1_menu), accel_group);

  open_game = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (open_game)->child),
                                   "_Open Game...");
  gtk_widget_ref (open_game);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "open_game", open_game,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (open_game);
  gtk_container_add (GTK_CONTAINER (game1_menu), open_game);
  gtk_widget_add_accelerator (open_game, "activate", accel_group,
                              GDK_o, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
  gtk_tooltips_set_tip (tooltips, open_game, "Open a new game", NULL);


  restart_game = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (restart_game)->child),
                                   "R_estart Game");
  gtk_widget_ref (restart_game);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "restart_game", restart_game,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (restart_game);
  gtk_container_add (GTK_CONTAINER (game1_menu), restart_game);
  gtk_widget_add_accelerator (restart_game, "activate", accel_group,
                              GDK_e, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
  gtk_tooltips_set_tip (tooltips, restart_game,
	"Restarts current game from the beginning", NULL);

  separator1 = gtk_menu_item_new ();
  gtk_widget_ref (separator1);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "separator1", separator1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator1);
  gtk_container_add (GTK_CONTAINER (game1_menu), separator1);
  gtk_widget_set_sensitive (separator1, FALSE);

  restore_game = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (restore_game)->child),
                                   "_Restore Game...");
  gtk_widget_ref (restore_game);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "restore_game", restore_game,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (restore_game);
  gtk_container_add (GTK_CONTAINER (game1_menu), restore_game);
  gtk_widget_add_accelerator (restore_game, "activate", accel_group,
                              GDK_r, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
  gtk_tooltips_set_tip (tooltips, restore_game, "Load a saved game", NULL);

  save_game_as = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (save_game_as)->child),
                                   "_Save Game as...");
  gtk_widget_ref (save_game_as);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "save_game_as", save_game_as,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (save_game_as);
  gtk_container_add (GTK_CONTAINER (game1_menu), save_game_as);
  gtk_widget_add_accelerator (save_game_as, "activate", accel_group,
                              GDK_s, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
  gtk_tooltips_set_tip (tooltips, save_game_as, "Save current game", NULL);

  /*
   * Note: Earlier there were two menu items with names
   * save_game_as & save_game. It turned out that because of the way
   * scare implements the saving function, these became the same.
   * so I changed one to quit game.
   */

  quit_game = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (quit_game)->child),
                                   "_Quit Game");
  gtk_widget_ref (quit_game);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "quit_game", quit_game,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (quit_game);
  gtk_container_add (GTK_CONTAINER (game1_menu), quit_game);
  gtk_widget_add_accelerator (quit_game, "activate", accel_group,
                              GDK_q, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
  gtk_tooltips_set_tip (tooltips, quit_game, "Quits current game", NULL);

  separator2 = gtk_menu_item_new ();
  gtk_widget_ref (separator2);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "separator2", separator2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator2);
  gtk_container_add (GTK_CONTAINER (game1_menu), separator2);
  gtk_widget_set_sensitive (separator2, FALSE);

  exit = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (exit)->child),
                                   "E_xit");
  gtk_widget_ref (exit);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "exit", exit,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (exit);
  gtk_container_add (GTK_CONTAINER (game1_menu), exit);
  gtk_widget_add_accelerator (exit, "activate", accel_group,
                              GDK_x, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
  gtk_tooltips_set_tip (tooltips, exit, "Exits Rogue", NULL);

  options = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (options)->child),
                                   "_Options");
  gtk_widget_ref (options);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "options", options,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (options);
  gtk_container_add (GTK_CONTAINER (menubar1), options);

  options_menu = gtk_menu_new ();
  gtk_widget_ref (options_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "options_menu", options_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (options), options_menu);
  gtk_menu_set_accel_group(GTK_MENU(options_menu), accel_group);

  set_display_font_color
     = gtk_menu_item_new_with_label("Set font color");
  gtk_widget_ref (set_display_font_color);
  gtk_object_set_data_full(GTK_OBJECT (main_win),
	"set_font_color", set_display_font_color,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (set_display_font_color);
  gtk_container_add (GTK_CONTAINER (options_menu), set_display_font_color);
  gtk_tooltips_set_tip (tooltips, set_display_font_color,
	"Set the color for the text",
	NULL);
  

  set_input_font_color = gtk_menu_item_new_with_label ("Set background color");
  gtk_widget_ref (set_input_font_color);
  gtk_object_set_data_full(GTK_OBJECT (main_win),
	"set_background_color", set_input_font_color,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (set_input_font_color);
  gtk_container_add (GTK_CONTAINER (options_menu), set_input_font_color);
  gtk_tooltips_set_tip (tooltips, set_input_font_color,
	"Set the background color for the text",
	NULL);
  

  set_font = gtk_menu_item_new_with_label ("Set font");
  gtk_widget_ref (set_font);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "set_font", set_font,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (set_font);
  gtk_container_add (GTK_CONTAINER (options_menu), set_font);
  gtk_tooltips_set_tip (tooltips, set_font,
	"Select the font for game text",
	NULL);
  

  separator3 = gtk_menu_item_new ();
  gtk_widget_ref (separator3);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "separator3", separator3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator3);
  gtk_container_add (GTK_CONTAINER (options_menu), separator3);
  gtk_widget_set_sensitive (separator3, FALSE);

  clear_screen = gtk_menu_item_new_with_label ("Clear screen");
  gtk_widget_ref (clear_screen);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "clear_screen", clear_screen,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (clear_screen);
  gtk_container_add (GTK_CONTAINER (options_menu), clear_screen);
  gtk_widget_add_accelerator (clear_screen, "activate", accel_group,
                              GDK_c, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
  gtk_tooltips_set_tip (tooltips, clear_screen,
	"Clears the Rogue screen",
	NULL);
  

  verbose_mode = gtk_check_menu_item_new_with_label ("Verbose mode");
  gtk_widget_ref (verbose_mode);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "verbose_mode", verbose_mode,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (verbose_mode);
  gtk_container_add (GTK_CONTAINER (options_menu), verbose_mode);
  gtk_widget_add_accelerator (verbose_mode, "activate", accel_group,
                              GDK_v, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
  gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(verbose_mode),
	TRUE);
  gtk_tooltips_set_tip (tooltips, verbose_mode,
	"Sets the game to verbose mode",
	NULL);
  

  
  game_options = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (game_options)->child),
                                   "_Game Options");
  gtk_widget_ref (game_options);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "game_options", game_options,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (game_options);
  gtk_container_add (GTK_CONTAINER (menubar1), game_options);
  gtk_tooltips_set_tip (tooltips, game_options, "These are the options that control running of the game", NULL);

  game_options_menu = gtk_menu_new ();
  gtk_widget_ref (game_options_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "game_options_menu", game_options_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (game_options), game_options_menu);
  gtk_menu_set_accel_group(GTK_MENU(game_options_menu), accel_group);

  undo1 = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (undo1)->child),
                                   "_Undo");
  gtk_widget_ref (undo1);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "undo1", undo1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (undo1);
  gtk_container_add (GTK_CONTAINER (game_options_menu), undo1);
  gtk_tooltips_set_tip (tooltips, undo1, "Undoes the last command", NULL);
  gtk_widget_add_accelerator (undo1, "activate", accel_group,
                              GDK_u, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  game_info = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (game_info)->child),
                                   "Game _Info");
  gtk_widget_ref (game_info);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "game_info", game_info,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (game_info);
  gtk_container_add (GTK_CONTAINER (game_options_menu), game_info);
  gtk_tooltips_set_tip (tooltips, game_info,
	"Shows the game readme file (if any)",
	NULL);
 
  gtk_widget_add_accelerator (game_info, "activate", accel_group,
                              GDK_i, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  open_game_info = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (open_game_info)->child),
                                   "Open Info Fi_le");
  gtk_widget_ref (open_game_info);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "open_game_info", open_game_info,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (open_game_info);
  gtk_container_add (GTK_CONTAINER (game_options_menu), open_game_info);
  gtk_tooltips_set_tip (tooltips, open_game_info,
	"Open readme file",
	NULL);
 
  gtk_widget_add_accelerator (open_game_info, "activate", accel_group,
                              GDK_l, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);


  log_input = gtk_check_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (log_input)->child),
                                   "Start/Stop Lo_gging");
  gtk_widget_ref (log_input);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "log_input", log_input,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (log_input);
  gtk_container_add (GTK_CONTAINER (game_options_menu), log_input);
  gtk_tooltips_set_tip (tooltips, log_input,
	"Start/Stop input logging",
	NULL);
 
  gtk_widget_add_accelerator (log_input, "activate", accel_group,
                              GDK_g, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);


 
  separator4 = gtk_menu_item_new ();
  gtk_widget_ref (separator4);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "separator4", separator4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator4);
  gtk_container_add (GTK_CONTAINER (game_options_menu), separator4);
  gtk_widget_set_sensitive (separator4, FALSE);


  enable_debugger = gtk_check_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (enable_debugger)->child),
                                   "Enable _debugger");
  gtk_widget_ref (enable_debugger);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "enable_debugger", enable_debugger,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (enable_debugger);
  gtk_container_add (GTK_CONTAINER (game_options_menu), enable_debugger);
  gtk_tooltips_set_tip (tooltips, enable_debugger, "Enables the scare built in debugger", NULL);
  gtk_widget_add_accelerator (enable_debugger, "activate", accel_group,
                              GDK_d, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
  gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (enable_debugger), TRUE);

  
  debugger_console = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (debugger_console)->child),
                                   "De_bugger console");
  gtk_widget_ref (debugger_console);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "debugger_console", debugger_console,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (debugger_console);
  gtk_container_add (GTK_CONTAINER (game_options_menu), debugger_console);
  gtk_tooltips_set_tip (tooltips, debugger_console,
	"Opens debugger console",
	NULL);
  gtk_widget_add_accelerator (debugger_console, "activate", accel_group,
                              GDK_b, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);



  help1 = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (help1)->child),
                                   "_Help");
  gtk_widget_ref (help1);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "help1", help1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (help1);
  gtk_container_add (GTK_CONTAINER (menubar1), help1);

  help1_menu = gtk_menu_new ();
  gtk_widget_ref (help1_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "help1_menu", help1_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (help1), help1_menu);
  gtk_menu_set_accel_group(GTK_MENU(help1_menu), accel_group);

  usual_commands = gtk_menu_item_new_with_label ("Useful commands");
  gtk_widget_ref (usual_commands);
  gtk_object_set_data_full(GTK_OBJECT (main_win),
	"usual_commands", usual_commands,
	(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (usual_commands);
  gtk_container_add (GTK_CONTAINER (help1_menu), usual_commands);
  gtk_widget_add_accelerator (usual_commands, "activate", accel_group,
                              GDK_h, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);


  shortcuts = gtk_menu_item_new_with_label ("Rogue Shortcuts");
  gtk_widget_ref (shortcuts);
  gtk_object_set_data_full(GTK_OBJECT (main_win),
	"shortcuts", shortcuts,
	(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (shortcuts);
  gtk_container_add (GTK_CONTAINER (help1_menu), shortcuts);
  gtk_widget_add_accelerator (shortcuts, "activate", accel_group,
                              GDK_t, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
 


  about_gtkscare = gtk_menu_item_new_with_label ("About Rogue");
  gtk_widget_ref (about_gtkscare);
  gtk_object_set_data_full (GTK_OBJECT (main_win),
	"about_gtkscare", about_gtkscare,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (about_gtkscare);
  gtk_container_add (GTK_CONTAINER (help1_menu), about_gtkscare);
  gtk_widget_add_accelerator (about_gtkscare, "activate", accel_group,
                              GDK_a, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
 
  // Add toolbar
  make_toolbar(idata, main_win, vbox1);
  
  // Make a horizontal box, and pack it in to the main vbox
  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);
  
  // Create a vbox, and pack it into the hbox
  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox3);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "vbox3", vbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox3);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox3, TRUE, TRUE, 0);

  //Create a scrolled window1, and pack it into previously created hbox
  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (main_win),
	"scrolledwindow1", scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox3), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
	GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
  
  
  // Create another vbox, and pack it into the hbox
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox2);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox2, TRUE, TRUE, 0);


  // Add a label into Vbox2
  text_label = gtk_label_new ("Game Notes");
  gtk_widget_ref (text_label);
  gtk_object_set_data_full(GTK_OBJECT (main_win),
	"text_label", text_label,
	(GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_show (text_label);
  gtk_box_pack_start (GTK_BOX (vbox2), text_label, FALSE, TRUE, 0);
  gtk_label_set_line_wrap (GTK_LABEL (text_label), TRUE);
  gtk_misc_set_padding (GTK_MISC (text_label), 10, 6);

  // Create another scrolled window2, and pack it into vbox2
  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow2);
  gtk_object_set_data_full (GTK_OBJECT (main_win),
	"scrolledwindow2", scrolledwindow2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow2);
  gtk_box_pack_start (GTK_BOX (vbox2), scrolledwindow2, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2),
	GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
  
  // Add text view widget to scrolled window 2. This widget is used to
  // display information
  infotext = gtk_text_view_new ();
  gtk_widget_show (infotext);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), infotext);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (infotext), TRUE);
  gtk_text_view_set_justification (GTK_TEXT_VIEW (infotext), GTK_JUSTIFY_LEFT);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (infotext), GTK_WRAP_WORD);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (infotext), TRUE);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (infotext), 4);
  gtk_widget_set_size_request(GTK_WIDGET(infotext), 160, 320);
  gtk_widget_ref (infotext);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "infotext", infotext,
                            (GtkDestroyNotify) gtk_widget_unref);

  // Add text view widget to scrolled window1 This window is where the
  // game play takes place.
  showtext = gtk_text_view_new ();
  gtk_widget_show (showtext);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), showtext);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (showtext), FALSE);
  gtk_text_view_set_justification (GTK_TEXT_VIEW (showtext), GTK_JUSTIFY_LEFT);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (showtext), GTK_WRAP_WORD);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (showtext), FALSE);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (showtext), 4);

  tbuf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (showtext));
  gtk_text_buffer_create_tag (tbuf, "sbold",
	"weight", PANGO_WEIGHT_BOLD,
	"justification", GTK_JUSTIFY_CENTER,
	NULL);
  
  gtk_text_buffer_create_tag (tbuf, "sbig",
	"size", PANGO_SCALE*20, NULL);

  gtk_text_buffer_get_end_iter(tbuf, &giter);
  gtk_text_buffer_insert_with_tags_by_name(tbuf, &giter,
	"\n\n\n ", -1, "sbold", NULL);

  /* create the Rogue logo pixbuf */
  gr = NULL;
  gp = gdk_pixbuf_new_from_xpm_data((const char **)gtk_scare_xpm);
  idata->gp = gp;

  if(NULL != gp) {
     gtk_text_buffer_get_end_iter(tbuf, &giter);
     gtk_text_buffer_insert_pixbuf(tbuf, &giter, gp);
  }

  /* output some info */
  gtk_text_buffer_get_end_iter(tbuf, &giter);
  gtk_text_buffer_insert_with_tags_by_name(tbuf, &giter,
	"\n\nWelcome to Rogue v0.5\n", -1, "sbold", "sbig", NULL);
  
  gtk_text_buffer_get_end_iter(tbuf, &giter);
  gtk_text_buffer_insert_with_tags_by_name(tbuf, &giter,
	"Rogue is a runner for Interactive fiction games.",
	-1, "sbold", NULL);

  gtk_text_buffer_get_end_iter(tbuf, &giter);
  gtk_text_buffer_insert_with_tags_by_name(tbuf, &giter,
	"\nRogue is Copyright (c) Pallav Nawani 2004-2005.\n",
	-1, "sbold", NULL);

  gtk_text_buffer_insert_with_tags_by_name(tbuf, &giter,
	"http://www.ironcode.com\n",
	-1, "sbold", NULL);
  
  gtk_widget_set_size_request(GTK_WIDGET(showtext), 480, 380);
  gtk_widget_ref (showtext);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "showtext", showtext,
                            (GtkDestroyNotify) gtk_widget_unref);

  textentry = gtk_entry_new ();

  /* Tap the GtkEventKey */
  gtk_signal_connect(GTK_OBJECT (textentry), "key_press_event",
                      GTK_SIGNAL_FUNC(on_key_press),
                      (gpointer)idata);


  gtk_widget_ref (textentry);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "textentry", textentry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (textentry);
  gtk_box_pack_start (GTK_BOX (vbox1), textentry, FALSE, FALSE, 0);
  gtk_entry_set_text (GTK_ENTRY (textentry), "Enter commands here");

  // Add callback to check the activation of gtk_entry
  gtk_signal_connect (GTK_OBJECT (textentry), "activate",
                      GTK_SIGNAL_FUNC (on_textentry),
                      (gpointer)idata);

  statusbar = gtk_statusbar_new ();
  gtk_widget_ref (statusbar);
  gtk_object_set_data_full (GTK_OBJECT (main_win), "statusbar",
	statusbar, (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_show (statusbar);
  gtk_box_pack_start (GTK_BOX (vbox1), statusbar, FALSE, FALSE, 1);

  gtk_signal_connect (GTK_OBJECT (main_win), "destroy",
                      GTK_SIGNAL_FUNC (gtk_main_quit),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (open_game), "activate",
                      GTK_SIGNAL_FUNC (on_open_game_activate),
                      idata);
  gtk_signal_connect (GTK_OBJECT (restart_game), "activate",
                      GTK_SIGNAL_FUNC (on_restart_game_activate),
                      idata);
  gtk_signal_connect (GTK_OBJECT (restore_game), "activate",
                      GTK_SIGNAL_FUNC (on_restore_game_activate),
                      idata);
  gtk_signal_connect (GTK_OBJECT (save_game_as), "activate",
                      GTK_SIGNAL_FUNC (on_save_game_as_activate),
                      idata);
  gtk_signal_connect (GTK_OBJECT (quit_game), "activate",
                      GTK_SIGNAL_FUNC (on_quit_game_activate),
                      idata);
  gtk_signal_connect (GTK_OBJECT (exit), "activate",
                      GTK_SIGNAL_FUNC (on_exit_activate),
                      idata);
  gtk_signal_connect (GTK_OBJECT (set_display_font_color), "activate",
                      GTK_SIGNAL_FUNC (on_set_display_font_color_activate),
                      idata);
  gtk_signal_connect (GTK_OBJECT (set_input_font_color), "activate",
                      GTK_SIGNAL_FUNC (on_set_background_color_activate),
                      idata);
  gtk_signal_connect (GTK_OBJECT (set_font), "activate",
                      GTK_SIGNAL_FUNC (on_set_font_activate),
                      idata);
  gtk_signal_connect (GTK_OBJECT (clear_screen), "activate",
                      GTK_SIGNAL_FUNC (on_clear_screen_activate),
                      idata);
  gtk_signal_connect (GTK_OBJECT (verbose_mode), "activate",
                      GTK_SIGNAL_FUNC (on_verbose_mode_activate),
                      idata);
 
  gtk_signal_connect (GTK_OBJECT (undo1), "activate",
                      GTK_SIGNAL_FUNC (on_undo_activate),
                      idata);

  gtk_signal_connect (GTK_OBJECT (game_info), "activate",
                      GTK_SIGNAL_FUNC (on_gameinfo_activate),
                      idata);
  
  gtk_signal_connect (GTK_OBJECT (open_game_info), "activate",
                      GTK_SIGNAL_FUNC (on_open_gameinfo_activate),
                      idata);
  
  gtk_signal_connect (GTK_OBJECT (log_input), "activate",
                      GTK_SIGNAL_FUNC (on_log_input_activate),
                      idata);
  
  gtk_signal_connect (GTK_OBJECT (enable_debugger), "activate",
                      GTK_SIGNAL_FUNC (on_enable_debugger_activate),
                      idata);
 
  gtk_signal_connect (GTK_OBJECT (debugger_console), "activate",
                      GTK_SIGNAL_FUNC (on_debugger_console_activate),
                      idata);
 
  gtk_signal_connect (GTK_OBJECT (usual_commands), "activate",
                      GTK_SIGNAL_FUNC (on_usual_commands_activate),
                      NULL);

  gtk_signal_connect (GTK_OBJECT (shortcuts), "activate",
                      GTK_SIGNAL_FUNC (on_shortcuts_activate),
                      NULL);

  gtk_signal_connect (GTK_OBJECT (about_gtkscare), "activate",
                      GTK_SIGNAL_FUNC (on_about_gtkscare_activate),
                      idata);

  gtk_window_add_accel_group (GTK_WINDOW (main_win), accel_group);

  // Collect the pointers to the useful widgets for later use.
  idata->textw = showtext;
  idata->notesw= infotext;
  idata->sbar  = statusbar;
  idata->entry = textentry;
  idata->mverb = verbose_mode;
  idata->log_menu_item = (GtkCheckMenuItem *)log_input;

  return main_win;
}



/*
 *
 * Creates a confirmation dialog, which is used to prompt
 * user to confirm their actions
 *
 *
 */
GtkWidget* create_confirmation_dlg(Gtk_sdata *idata, char *prompt)
{
  GtkWidget *confirmation_dlg;
  GtkWidget *dialog_vbox1;
  GtkWidget *dlg_text_label;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbox1;
  GtkWidget *dlg_yes_butn;
  GtkWidget *dlg_no_butn;

  confirmation_dlg = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (confirmation_dlg),
	"confirmation_dlg", confirmation_dlg);
  gtk_window_set_title (GTK_WINDOW (confirmation_dlg), "Please Confirm!");
  gtk_window_set_position (GTK_WINDOW (confirmation_dlg), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (confirmation_dlg), TRUE);
  gtk_window_set_policy (GTK_WINDOW (confirmation_dlg), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (confirmation_dlg)->vbox;
  gtk_object_set_data (GTK_OBJECT (confirmation_dlg),
	"dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  dlg_text_label = gtk_label_new (prompt);
  gtk_widget_ref (dlg_text_label);
  gtk_object_set_data_full(GTK_OBJECT (confirmation_dlg),
	"dlg_text_label", dlg_text_label,
	(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dlg_text_label);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), dlg_text_label, FALSE, TRUE, 0);
  gtk_label_set_line_wrap (GTK_LABEL (dlg_text_label), TRUE);
  gtk_misc_set_padding (GTK_MISC (dlg_text_label), 30, 14);

  dialog_action_area1 = GTK_DIALOG (confirmation_dlg)->action_area;
  gtk_object_set_data (GTK_OBJECT (confirmation_dlg), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbox1 = gtk_hbox_new (TRUE, 3);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (confirmation_dlg), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), hbox1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox1), 2);

  dlg_yes_butn = gtk_button_new_with_label ("Yes");
  gtk_widget_ref (dlg_yes_butn);
  gtk_object_set_data_full (GTK_OBJECT (confirmation_dlg), "dlg_yes_butn", dlg_yes_butn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dlg_yes_butn);
  gtk_box_pack_start (GTK_BOX (hbox1), dlg_yes_butn, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (dlg_yes_butn), 2);

  dlg_no_butn = gtk_button_new_with_label ("No");
  gtk_widget_ref (dlg_no_butn);
  gtk_object_set_data_full (GTK_OBJECT (confirmation_dlg), "dlg_no_butn", dlg_no_butn,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dlg_no_butn);
  gtk_box_pack_start (GTK_BOX (hbox1), dlg_no_butn, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (dlg_no_butn), 2);

  idata->curw = confirmation_dlg;

  gtk_signal_connect_after (GTK_OBJECT (confirmation_dlg), "destroy_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      idata);
  gtk_signal_connect_after (GTK_OBJECT (confirmation_dlg), "delete_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      idata);

  // Hook into destroy event etc to do some cleanup
  /*
  gtk_signal_connect_while_alive (GTK_OBJECT (confirmation_dlg),
	"destroy_event",
	GTK_SIGNAL_FUNC (on_widget_delete),
	idata,
	GTK_OBJECT(confirmation_dlg));

  gtk_signal_connect_while_alive (GTK_OBJECT (confirmation_dlg),
	"delete_event",
	GTK_SIGNAL_FUNC (on_widget_delete),
	idata,
	GTK_OBJECT(confirmation_dlg));

   */
  gtk_signal_connect (GTK_OBJECT (dlg_yes_butn), "clicked",
                      GTK_SIGNAL_FUNC (on_dlg_yes_butn_clicked),
                      idata);
  gtk_signal_connect (GTK_OBJECT (dlg_no_butn), "clicked",
                      GTK_SIGNAL_FUNC (on_dlg_no_butn_clicked),
                      idata);

  return confirmation_dlg;
}


/*
 *
 *
 * Creates a File Selection dialog
 * Mode can have values of 0 and 1. Any other value will crash
 * the program.
 *
 *
 */
GtkWidget* create_fileselection (Gtk_sdata *idata, int mode)
{
  GtkWidget *fileselection;
  GtkWidget *fsel_ok_butn;
  GtkWidget *fsel_cancel_butn;

  char *heading[2] = {
     "Select file to open",
     "Save as"
  };

  fileselection = gtk_file_selection_new (heading[mode]);
  gtk_object_set_data (GTK_OBJECT (fileselection),
	"fileselection", fileselection);
  gtk_container_set_border_width (GTK_CONTAINER (fileselection), 10);
  gtk_window_set_modal (GTK_WINDOW (fileselection), TRUE);

  fsel_ok_butn = GTK_FILE_SELECTION (fileselection)->ok_button;
  gtk_object_set_data (GTK_OBJECT (fileselection),
	"fsel_ok_butn", fsel_ok_butn);
  gtk_widget_show (fsel_ok_butn);
  GTK_WIDGET_SET_FLAGS (fsel_ok_butn, GTK_CAN_DEFAULT);

  fsel_cancel_butn = GTK_FILE_SELECTION (fileselection)->cancel_button;
  gtk_object_set_data (GTK_OBJECT (fileselection),
	"fsel_cancel_butn", fsel_cancel_butn);
  gtk_widget_show (fsel_cancel_butn);
  GTK_WIDGET_SET_FLAGS (fsel_cancel_butn, GTK_CAN_DEFAULT);

  idata->curw = fileselection;
  gtk_signal_connect_after(GTK_OBJECT (fileselection), "delete_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);
  gtk_signal_connect_after(GTK_OBJECT (fileselection), "destroy_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);
  /*
  gtk_signal_connect(GTK_OBJECT (fileselection), "delete_event",
                      GTK_SIGNAL_FUNC (on_widget_delete),
                      idata);
  */
  gtk_signal_connect(GTK_OBJECT (fsel_ok_butn), "clicked",
                      GTK_SIGNAL_FUNC (on_fsel_ok_butn_clicked),
                      idata);
  gtk_signal_connect(GTK_OBJECT (fsel_cancel_butn), "clicked",
                      GTK_SIGNAL_FUNC (on_fsel_cancel_butn_clicked),
                      idata);

  return fileselection;
}




/*
 *
 * Creates a gtk color selection dialog to allow you to select the
 * color
 *
 *
 */
GtkWidget* create_colorseldlg (Gtk_sdata *idata)
{
  GtkWidget *colorseldlg;
  GtkWidget *colorsel_ok;
  GtkWidget *colorsel_cancel;
  GtkWidget *help_button1;

  colorseldlg = gtk_color_selection_dialog_new ("Select Color");
  gtk_object_set_data (GTK_OBJECT (colorseldlg), "colorseldlg", colorseldlg);
  gtk_container_set_border_width (GTK_CONTAINER (colorseldlg), 10);
  gtk_window_set_modal (GTK_WINDOW (colorseldlg), TRUE);

  colorsel_ok = GTK_COLOR_SELECTION_DIALOG (colorseldlg)->ok_button;
  gtk_object_set_data (GTK_OBJECT (colorseldlg), "colorsel_ok", colorsel_ok);
  gtk_widget_show (colorsel_ok);
  GTK_WIDGET_SET_FLAGS (colorsel_ok, GTK_CAN_DEFAULT);

  colorsel_cancel = GTK_COLOR_SELECTION_DIALOG (colorseldlg)->cancel_button;
  gtk_object_set_data (GTK_OBJECT (colorseldlg), "colorsel_cancel", colorsel_cancel);
  gtk_widget_show (colorsel_cancel);
  GTK_WIDGET_SET_FLAGS (colorsel_cancel, GTK_CAN_DEFAULT);

  help_button1 = GTK_COLOR_SELECTION_DIALOG (colorseldlg)->help_button;
  gtk_object_set_data (GTK_OBJECT (colorseldlg), "help_button1", help_button1);
  gtk_widget_show (help_button1);
  GTK_WIDGET_SET_FLAGS (help_button1, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (colorseldlg), "delete_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (colorseldlg), "destroy_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (colorsel_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_colorsel_ok_clicked),
                      idata);
  gtk_signal_connect (GTK_OBJECT (colorsel_cancel), "clicked",
                      GTK_SIGNAL_FUNC (on_colorsel_cancel_clicked),
                      idata);

  idata->curw = colorseldlg;
  return colorseldlg;
}



/*
 *
 * This creates a dialog used to select the font
 *
 */
GtkWidget* create_fontseldlg (Gtk_sdata *idata)
{
  GtkWidget *fontseldlg;
  GtkWidget *fontsel_ok;
  GtkWidget *fontsel_cancel;
  GtkWidget *fontsel_apply;

  fontseldlg = gtk_font_selection_dialog_new ("Select Font");
  gtk_object_set_data (GTK_OBJECT (fontseldlg), "fontseldlg", fontseldlg);
  gtk_container_set_border_width (GTK_CONTAINER (fontseldlg), 4);
  gtk_window_set_modal (GTK_WINDOW (fontseldlg), TRUE);
  gtk_window_set_policy (GTK_WINDOW (fontseldlg), FALSE, TRUE, TRUE);

  fontsel_ok = GTK_FONT_SELECTION_DIALOG (fontseldlg)->ok_button;
  gtk_object_set_data (GTK_OBJECT (fontseldlg), "fontsel_ok", fontsel_ok);
  gtk_widget_show (fontsel_ok);
  GTK_WIDGET_SET_FLAGS (fontsel_ok, GTK_CAN_DEFAULT);

  fontsel_cancel = GTK_FONT_SELECTION_DIALOG (fontseldlg)->cancel_button;
  gtk_object_set_data (GTK_OBJECT (fontseldlg), "fontsel_cancel", fontsel_cancel);
  gtk_widget_show (fontsel_cancel);
  GTK_WIDGET_SET_FLAGS (fontsel_cancel, GTK_CAN_DEFAULT);

  fontsel_apply = GTK_FONT_SELECTION_DIALOG (fontseldlg)->apply_button;
  gtk_object_set_data (GTK_OBJECT (fontseldlg), "fontsel_apply", fontsel_apply);
  gtk_widget_show (fontsel_apply);
  GTK_WIDGET_SET_FLAGS (fontsel_apply, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (fontseldlg), "delete_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (fontseldlg), "destroy_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (fontsel_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_fontsel_ok_clicked),
                      idata);
  gtk_signal_connect (GTK_OBJECT (fontsel_cancel), "clicked",
                      GTK_SIGNAL_FUNC (on_fontsel_cancel_clicked),
                      idata);
  gtk_signal_connect (GTK_OBJECT (fontsel_apply), "clicked",
                      GTK_SIGNAL_FUNC (on_fontsel_apply_clicked),
                      idata);

  idata->curw = fontseldlg;
  return fontseldlg;
}


/*
 *
 * Creates a dialog that shows some information
 *
 */
GtkWidget* create_about_dlg (char *boxname, char *blurb)
{
  GtkWidget *about_dlg;
  GtkWidget *dialog_vbox2;
  GtkWidget *label2;
  GtkWidget *dialog_action_area2;
  GtkWidget *button3;

  about_dlg = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (about_dlg), "about_dlg", about_dlg);
  gtk_window_set_title (GTK_WINDOW (about_dlg), boxname);
  gtk_window_set_policy (GTK_WINDOW (about_dlg), TRUE, TRUE, FALSE);

  dialog_vbox2 = GTK_DIALOG (about_dlg)->vbox;
  gtk_object_set_data (GTK_OBJECT (about_dlg), "dialog_vbox2", dialog_vbox2);
  gtk_widget_show (dialog_vbox2);

  label2 = gtk_label_new (blurb);
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (about_dlg), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), label2, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);
  gtk_label_set_line_wrap (GTK_LABEL (label2), TRUE);
  gtk_misc_set_padding (GTK_MISC (label2), 20, 20);
  gtk_label_set_use_markup (GTK_LABEL(label2), TRUE);

  dialog_action_area2 = GTK_DIALOG (about_dlg)->action_area;
  gtk_object_set_data (GTK_OBJECT (about_dlg), "dialog_action_area2", dialog_action_area2);
  gtk_widget_show (dialog_action_area2);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area2), 10);

  button3 = gtk_button_new_with_label (" I see! ");
  gtk_widget_ref (button3);
  gtk_object_set_data_full (GTK_OBJECT (about_dlg), "button3", button3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button3);
  gtk_box_pack_start (GTK_BOX (dialog_action_area2), button3, FALSE, FALSE, 0);

  gtk_signal_connect (GTK_OBJECT (about_dlg), "delete_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (about_dlg), "destroy_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (button3), "clicked",
                      GTK_SIGNAL_FUNC (on_button3_clicked),
                      about_dlg);

  return about_dlg;
}




/*
 *
 *
 * Creates a nifty little window to show hints.
 *
 */
GtkWidget* create_hint_window (Gtk_sdata *idata)
{
  GtkWidget *hint_window;
  GtkWidget *vbox1;
  GtkWidget *label1;
  GtkWidget *scrolledwindow1;
  GtkWidget *htreeview;
  GtkWidget *hbuttonbox1;
  GtkWidget *hintbutton;
  GtkWidget *solbutton;
  GtkWidget *closebutton;
  GtkWidget *scrolledwindow2;
  GtkWidget *hintview;
  GtkListStore *store;
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  GtkTreeSelection *select;

  hint_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (hint_window), "Choose your hint..");
  gtk_window_set_position (GTK_WINDOW (hint_window), GTK_WIN_POS_CENTER);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (hint_window), TRUE);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (hint_window), vbox1);

  label1 = gtk_label_new ("This is a list of hints you can currently choose from.");
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);
  gtk_label_set_line_wrap (GTK_LABEL (label1), TRUE);
  gtk_misc_set_padding (GTK_MISC (label1), 2, 6);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow1), 7);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  store = gtk_list_store_new (2, G_TYPE_UINT, G_TYPE_STRING);
  htreeview = gtk_tree_view_new_with_model(GTK_TREE_MODEL(store));

  gtk_widget_show (htreeview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), htreeview);
  gtk_container_set_border_width (GTK_CONTAINER (htreeview), 4);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (htreeview), FALSE);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (htreeview), TRUE);
  gtk_tree_view_set_enable_search (GTK_TREE_VIEW (htreeview), FALSE);

  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes ("Number",
	renderer, "text", 0, NULL);
  gtk_tree_view_column_set_visible(column, FALSE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (htreeview), column);
  
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes ("Hint",
	renderer, "text", 1, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (htreeview), column);

  select = gtk_tree_view_get_selection (GTK_TREE_VIEW (htreeview));
  gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE); 

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbuttonbox1, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox1), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox1), 0);

  hintbutton = gtk_button_new_with_mnemonic ("Show Hint");
  gtk_widget_show (hintbutton);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), hintbutton);
  GTK_WIDGET_SET_FLAGS (hintbutton, GTK_CAN_DEFAULT);
  gtk_button_set_relief (GTK_BUTTON (hintbutton), GTK_RELIEF_HALF);

  solbutton = gtk_button_new_with_mnemonic ("Show Solution");
  gtk_widget_show (solbutton);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), solbutton);
  GTK_WIDGET_SET_FLAGS (solbutton, GTK_CAN_DEFAULT);
  gtk_button_set_relief (GTK_BUTTON (solbutton), GTK_RELIEF_HALF);

  closebutton = gtk_button_new_with_mnemonic ("Close");
  gtk_widget_show (closebutton);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), closebutton);
  GTK_WIDGET_SET_FLAGS (closebutton, GTK_CAN_DEFAULT);
  gtk_button_set_relief (GTK_BUTTON (closebutton), GTK_RELIEF_HALF);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow2);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow2, FALSE, FALSE, 0);

  hintview = gtk_text_view_new ();
  gtk_widget_show (hintview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), hintview);
  gtk_widget_set_usize (hintview, 320, 60);
  gtk_container_set_border_width (GTK_CONTAINER (hintview), 2);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (hintview), FALSE);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (hintview), GTK_WRAP_WORD);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (hintview), FALSE);
  gtk_text_view_set_pixels_above_lines (GTK_TEXT_VIEW (hintview), 2);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (hintview), 5);
  gtk_text_view_set_right_margin (GTK_TEXT_VIEW (hintview), 2);
  gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (hintview)),
	"Hints will be displayed here", -1);

  
  gtk_signal_connect (GTK_OBJECT (hint_window), "delete_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (hint_window), "destroy_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (hintbutton), "clicked",
                      GTK_SIGNAL_FUNC (on_hintbutton_clicked),
                      idata);
  gtk_signal_connect (GTK_OBJECT (solbutton), "clicked",
                      GTK_SIGNAL_FUNC (on_solbutton_clicked),
                      idata);
  gtk_signal_connect_object(GTK_OBJECT (closebutton), "clicked",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      hint_window);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (hint_window, hint_window, "hint_window");
  GLADE_HOOKUP_OBJECT (hint_window, vbox1, "vbox1");
  GLADE_HOOKUP_OBJECT (hint_window, label1, "label1");
  GLADE_HOOKUP_OBJECT (hint_window, scrolledwindow1, "scrolledwindow1");
  GLADE_HOOKUP_OBJECT (hint_window, htreeview, "htreeview");
  GLADE_HOOKUP_OBJECT (hint_window, hbuttonbox1, "hbuttonbox1");
  GLADE_HOOKUP_OBJECT (hint_window, hintbutton, "hintbutton");
  GLADE_HOOKUP_OBJECT (hint_window, solbutton, "solbutton");
  GLADE_HOOKUP_OBJECT (hint_window, closebutton, "closebutton");
  GLADE_HOOKUP_OBJECT (hint_window, scrolledwindow2, "scrolledwindow2");
  GLADE_HOOKUP_OBJECT (hint_window, hintview, "hintview");
  GLADE_HOOKUP_OBJECT_NO_REF (hint_window, ((GtkWidget *)store), "store");

  return hint_window;
}





/*
 *
 * This is the real about dialogbox.
 *
 *
 */
GtkWidget* create_aboutdlg (Gtk_sdata *idata)
{
  GtkWidget *aboutdlg;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *image1;
  GtkWidget *label1;
  GtkWidget *dialog_action_area1;
  GtkWidget *okbutton1;

  aboutdlg = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (aboutdlg), "About Rogue");
  gtk_window_set_destroy_with_parent (GTK_WINDOW (aboutdlg), TRUE);

  dialog_vbox1 = GTK_DIALOG (aboutdlg)->vbox;
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 6);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox1), 8);

  image1 = gtk_image_new_from_pixbuf (idata->gp);
  gtk_widget_show (image1);
  gtk_box_pack_start (GTK_BOX (vbox1), image1, TRUE, TRUE, 0);

  label1 = gtk_label_new_with_mnemonic ("<i><big><big><b>R O G U E v0.5</b></big></big>\n<b>Rogue</b> is an interpreter for Interactive fiction games. It uses  Scare, Agility and Tads toolkits internally.\n\nRogue logo was designed by Gaurav Nawani.\n<small>Rogue is copyright Pallav Nawani 2004-2005.</small>\nhttp://www.ironcode.com\n</i>");
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, TRUE, TRUE, 0);
  gtk_label_set_use_markup (GTK_LABEL(label1), TRUE);
  gtk_label_set_line_wrap (GTK_LABEL (label1), TRUE);
  gtk_misc_set_padding (GTK_MISC (label1), 6, 5);
  gtk_label_set_justify(GTK_LABEL(label1),GTK_JUSTIFY_CENTER);

  dialog_action_area1 = GTK_DIALOG (aboutdlg)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1),
	GTK_BUTTONBOX_END);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (aboutdlg), okbutton1,
	GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (aboutdlg), "delete_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);
  gtk_signal_connect_object(GTK_OBJECT (okbutton1), "clicked",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      aboutdlg);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (aboutdlg, aboutdlg, "aboutdlg");
  GLADE_HOOKUP_OBJECT_NO_REF (aboutdlg, dialog_vbox1, "dialog_vbox1");
  GLADE_HOOKUP_OBJECT (aboutdlg, vbox1, "vbox1");
  GLADE_HOOKUP_OBJECT (aboutdlg, image1, "image1");
  GLADE_HOOKUP_OBJECT (aboutdlg, label1, "label1");
  GLADE_HOOKUP_OBJECT_NO_REF (aboutdlg, dialog_action_area1, "dialog_action_area1");
  GLADE_HOOKUP_OBJECT (aboutdlg, okbutton1, "okbutton1");

  return aboutdlg;

}




/*
 *
 * This window is used to display a readme file.
 *
 */
GtkWidget* create_game_text_window (char *string)
{
  GtkWidget *game_text_window;
  GtkWidget *scrolledwindow1;
  GtkWidget *game_info_textview;

  game_text_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (game_text_window, "game_text_window");
  gtk_window_set_title (GTK_WINDOW (game_text_window), string);
  gtk_window_set_position (GTK_WINDOW (game_text_window), GTK_WIN_POS_CENTER);
  gtk_window_set_default_size (GTK_WINDOW (game_text_window), 600, 400);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (game_text_window), TRUE);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow1, "scrolledwindow1");
  gtk_widget_show (scrolledwindow1);
  gtk_container_add (GTK_CONTAINER (game_text_window), scrolledwindow1);

  game_info_textview = gtk_text_view_new ();
  gtk_widget_set_name (game_info_textview, "game_info_textview");
  gtk_widget_show (game_info_textview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), game_info_textview);
  gtk_container_set_border_width (GTK_CONTAINER (game_info_textview), 4);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (game_info_textview), FALSE);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (game_info_textview), GTK_WRAP_WORD);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (game_info_textview), 8);
  gtk_text_view_set_right_margin (GTK_TEXT_VIEW (game_info_textview), 8);
  gtk_text_view_set_indent (GTK_TEXT_VIEW (game_info_textview), 8);

  gtk_signal_connect (GTK_OBJECT (game_text_window), "delete_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (game_text_window), "destroy_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (game_text_window, game_text_window, "game_text_window");
  GLADE_HOOKUP_OBJECT (game_text_window, scrolledwindow1, "scrolledwindow1");
  GLADE_HOOKUP_OBJECT (game_text_window, game_info_textview, "game_info_textview");

  return game_text_window;
}





/*
 *
 *
 * Creates the debugger console
 *
 *
 */
GtkWidget* create_debug_window (void)
{
  GtkWidget *debug_window;
  GtkWidget *vbox1;
  GtkWidget *scrolledwindow1;
  GtkWidget *debugtextview;
  GtkWidget *hbox1;
  GtkWidget *dbg_gamebutton;
  GtkWidget *dbg_playerbutton;
  GtkWidget *dbg_roombutton;
  GtkWidget *dbg_objectbutton;
  GtkWidget *dbg_npcbutton;
  GtkWidget *dbg_taskbutton;
  GtkWidget *dbg_eventbutton;
  GtkWidget *dbg_variablebutton;
  GtkWidget *dbg_helpbutton;
  GtkWidget *dbg_closebutton;
  GtkWidget *debugentry;

  GtkTextBuffer *tbuf;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  debug_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (debug_window, "debug_window");
  gtk_window_set_title (GTK_WINDOW (debug_window), "Debug Console");
  gtk_window_set_position (GTK_WINDOW (debug_window), GTK_WIN_POS_CENTER);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox1, "vbox1");
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (debug_window), vbox1);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow1, "scrolledwindow1");
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);

  debugtextview = gtk_text_view_new ();
  gtk_widget_set_name (debugtextview, "debugtextview");
  gtk_widget_show (debugtextview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), debugtextview);
  gtk_widget_set_usize (debugtextview, 450, 300);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (debugtextview), FALSE);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (debugtextview), GTK_WRAP_WORD);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (debugtextview), 5);

  tbuf = gtk_text_view_get_buffer((GtkTextView *)debugtextview);

  gtk_text_buffer_create_tag (tbuf, "debuginfo",
	 "foreground", "DarkRed", NULL);
  gtk_text_buffer_create_tag (tbuf, "userinput",
	 "foreground", "DarkBlue", NULL);
 

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox1, "hbox1");
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox1), 2);

  dbg_gamebutton = gtk_button_new_with_mnemonic ("Game");
  gtk_widget_set_name (dbg_gamebutton, "dbg_gamebutton");
  gtk_widget_show (dbg_gamebutton);
  gtk_box_pack_start (GTK_BOX (hbox1), dbg_gamebutton, FALSE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, dbg_gamebutton, "Information about the game being debugged", NULL);

  dbg_playerbutton = gtk_button_new_with_mnemonic ("Player");
  gtk_widget_set_name (dbg_playerbutton, "dbg_playerbutton");
  gtk_widget_show (dbg_playerbutton);
  gtk_box_pack_start (GTK_BOX (hbox1), dbg_playerbutton, FALSE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, dbg_playerbutton, "Information about the player", NULL);

  dbg_roombutton = gtk_button_new_with_mnemonic ("Rooms");
  gtk_widget_set_name (dbg_roombutton, "dbg_roombutton");
  gtk_widget_show (dbg_roombutton);
  gtk_box_pack_start (GTK_BOX (hbox1), dbg_roombutton, FALSE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, dbg_roombutton, "Information on all the rooms in the game", NULL);

  dbg_objectbutton = gtk_button_new_with_mnemonic ("Objects");
  gtk_widget_set_name (dbg_objectbutton, "dbg_objectbutton");
  gtk_widget_show (dbg_objectbutton);
  gtk_box_pack_start (GTK_BOX (hbox1), dbg_objectbutton, FALSE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, dbg_objectbutton, "Information on all the objects in the game", NULL);

  dbg_npcbutton = gtk_button_new_with_mnemonic ("Npcs");
  gtk_widget_set_name (dbg_npcbutton, "dbg_npcbutton");
  gtk_widget_show (dbg_npcbutton);
  gtk_box_pack_start (GTK_BOX (hbox1), dbg_npcbutton, FALSE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, dbg_npcbutton, "Information on all the Npcs in the game", NULL);

  dbg_taskbutton = gtk_button_new_with_mnemonic ("Tasks");
  gtk_widget_set_name (dbg_taskbutton, "dbg_taskbutton");
  gtk_widget_show (dbg_taskbutton);
  gtk_box_pack_start (GTK_BOX (hbox1), dbg_taskbutton, FALSE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, dbg_taskbutton, "Information on all the tasks in the game", NULL);

  dbg_eventbutton = gtk_button_new_with_mnemonic ("Events");
  gtk_widget_set_name (dbg_eventbutton, "dbg_eventbutton");
  gtk_widget_show (dbg_eventbutton);
  gtk_box_pack_start (GTK_BOX (hbox1), dbg_eventbutton, FALSE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, dbg_eventbutton, "Information on all the events in the game", NULL);

  dbg_variablebutton = gtk_button_new_with_mnemonic ("Variables");
  gtk_widget_set_name (dbg_variablebutton, "dbg_variablebutton");
  gtk_widget_show (dbg_variablebutton);
  gtk_box_pack_start (GTK_BOX (hbox1), dbg_variablebutton, FALSE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, dbg_variablebutton, "Information on all the variables in the game", NULL);

  dbg_helpbutton = gtk_button_new_with_mnemonic ("Help");
  gtk_widget_set_name (dbg_helpbutton, "dbg_helpbutton");
  gtk_widget_show (dbg_helpbutton);
  gtk_box_pack_start (GTK_BOX (hbox1), dbg_helpbutton, FALSE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, dbg_helpbutton, "General debugger help", NULL);

  dbg_closebutton = gtk_button_new_with_mnemonic ("Close");
  gtk_widget_set_name (dbg_closebutton, "dbg_closebutton");
  gtk_widget_show (dbg_closebutton);
  gtk_box_pack_start (GTK_BOX (hbox1), dbg_closebutton, FALSE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, dbg_closebutton, "Closes the debug console", NULL);

  debugentry = gtk_entry_new_with_max_length (256);
  gtk_widget_set_name (debugentry, "debugentry");
  gtk_widget_show (debugentry);
  gtk_box_pack_start (GTK_BOX (vbox1), debugentry, FALSE, FALSE, 0);
  gtk_entry_set_activates_default (GTK_ENTRY (debugentry), TRUE);

  gtk_signal_connect (GTK_OBJECT (debug_window), "destroy_event",
                      GTK_SIGNAL_FUNC (on_debug_kill_event),
                      NULL);

  gtk_signal_connect (GTK_OBJECT (debug_window), "delete_event",
                      GTK_SIGNAL_FUNC (on_debug_kill_event),
                      NULL);

  gtk_signal_connect (GTK_OBJECT (debug_window), "delete_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (debug_window), "destroy_event",
                      GTK_SIGNAL_FUNC (gtk_widget_destroy),
                      NULL);

  gtk_signal_connect (GTK_OBJECT (dbg_gamebutton), "clicked",
                      GTK_SIGNAL_FUNC (on_dbg_gamebutton_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (dbg_playerbutton), "clicked",
                      GTK_SIGNAL_FUNC (on_dbg_playerbutton_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (dbg_roombutton), "clicked",
                      GTK_SIGNAL_FUNC (on_dbg_roombutton_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (dbg_objectbutton), "clicked",
                      GTK_SIGNAL_FUNC (on_dbg_objectbutton_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (dbg_npcbutton), "clicked",
                      GTK_SIGNAL_FUNC (on_dbg_npcbutton_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (dbg_taskbutton), "clicked",
                      GTK_SIGNAL_FUNC (on_dbg_taskbutton_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (dbg_eventbutton), "clicked",
                      GTK_SIGNAL_FUNC (on_dbg_eventbutton_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (dbg_variablebutton), "clicked",
                      GTK_SIGNAL_FUNC (on_dbg_variablebutton_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (dbg_helpbutton), "clicked",
                      GTK_SIGNAL_FUNC (on_dbg_helpbutton_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (dbg_closebutton), "clicked",
                      GTK_SIGNAL_FUNC (on_dbg_closebutton_clicked),
                      debug_window);
  gtk_signal_connect (GTK_OBJECT (debugentry), "activate",
                      GTK_SIGNAL_FUNC (on_debugentry_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (debugentry), "key_press_event",
                      GTK_SIGNAL_FUNC (on_debugentry_key_press_event),
                      NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (debug_window, debug_window, "debug_window");
  GLADE_HOOKUP_OBJECT (debug_window, vbox1, "vbox1");
  GLADE_HOOKUP_OBJECT (debug_window, scrolledwindow1, "scrolledwindow1");
  GLADE_HOOKUP_OBJECT (debug_window, debugtextview, "debugtextview");
  GLADE_HOOKUP_OBJECT (debug_window, hbox1, "hbox1");
  GLADE_HOOKUP_OBJECT (debug_window, dbg_gamebutton, "dbg_gamebutton");
  GLADE_HOOKUP_OBJECT (debug_window, dbg_playerbutton, "dbg_playerbutton");
  GLADE_HOOKUP_OBJECT (debug_window, dbg_roombutton, "dbg_roombutton");
  GLADE_HOOKUP_OBJECT (debug_window, dbg_objectbutton, "dbg_objectbutton");
  GLADE_HOOKUP_OBJECT (debug_window, dbg_npcbutton, "dbg_npcbutton");
  GLADE_HOOKUP_OBJECT (debug_window, dbg_taskbutton, "dbg_taskbutton");
  GLADE_HOOKUP_OBJECT (debug_window, dbg_eventbutton, "dbg_eventbutton");
  GLADE_HOOKUP_OBJECT (debug_window, dbg_variablebutton, "dbg_variablebutton");
  GLADE_HOOKUP_OBJECT (debug_window, dbg_helpbutton, "dbg_helpbutton");
  GLADE_HOOKUP_OBJECT (debug_window, dbg_closebutton, "dbg_closebutton");
  GLADE_HOOKUP_OBJECT (debug_window, debugentry, "debugentry");
  GLADE_HOOKUP_OBJECT_NO_REF (debug_window, tooltips, "tooltips");

  return debug_window;
}




//==///////////////////////////////////////////////////////////////////
//
/// Create a toolbar for use in Rogue. The toolbar is added into
/// the vbox supplied.
///
/// \param
///	window1: Top level gtk window
///	vbox1:   The vbox to which the toolbar is added.
/// \return
///	
//==///////////////////////////////////////////////////////////////////
void make_toolbar(Gtk_sdata *idata, GtkWidget *window1, GtkWidget *vbox1)
{

   GtkWidget *toolbar1;
   gint tmp_toolbar_icon_size;
   GtkWidget *tmp_image;
   GtkWidget *toolbar_open;
   GtkWidget *toolbar_load;
   GtkWidget *toolbar_save;
   GtkWidget *toolbar_restart;
   GtkWidget *toolbar_quit;
   GtkWidget *separatortoolitem1;
   GtkWidget *toolbar_undo;
   GtkWidget *toolbar_clear;
   GtkWidget *toolbar_game_info;
   GtkWidget *toggletoolbar_log;
   GtkWidget *toolbar_increase_font_size;
   GtkWidget *toolbar_font_size_decrease;
   GtkTooltips *tooltips;

   tooltips = gtk_tooltips_new ();
   
   toolbar1 = gtk_toolbar_new ();
   gtk_widget_set_name (toolbar1, "toolbar1");
   gtk_widget_show (toolbar1);
   gtk_box_pack_start (GTK_BOX (vbox1), toolbar1, FALSE, FALSE, 0);
   gtk_toolbar_set_style (GTK_TOOLBAR (toolbar1), GTK_TOOLBAR_BOTH);
   tmp_toolbar_icon_size = gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar1));

   tmp_image = gtk_image_new_from_stock ("gtk-new",
   	 (GtkIconSize)tmp_toolbar_icon_size);
   gtk_widget_show (tmp_image);
   toolbar_open = (GtkWidget*) gtk_tool_button_new (tmp_image, "Open");
   gtk_widget_set_name (toolbar_open, "toolbar_open");
   gtk_widget_show (toolbar_open);
   gtk_container_add (GTK_CONTAINER (toolbar1), toolbar_open);
   gtk_tool_item_set_tooltip (GTK_TOOL_ITEM (toolbar_open), tooltips, "Open a new game", NULL);

   tmp_image = gtk_image_new_from_stock ("gtk-open",
   	 (GtkIconSize)tmp_toolbar_icon_size);
   gtk_widget_show (tmp_image);
   toolbar_load = (GtkWidget*) gtk_tool_button_new (tmp_image, "Restore");
   gtk_widget_set_name (toolbar_load, "toolbar_load");
   gtk_widget_show (toolbar_load);
   gtk_tool_item_set_homogeneous (GTK_TOOL_ITEM (toolbar_load), FALSE);
   gtk_container_add (GTK_CONTAINER (toolbar1), toolbar_load);
   gtk_tool_item_set_tooltip (GTK_TOOL_ITEM (toolbar_load), tooltips, "Restore a saved game", NULL);

   tmp_image = gtk_image_new_from_stock ("gtk-save",
   	 (GtkIconSize)tmp_toolbar_icon_size);
   gtk_widget_show (tmp_image);
   toolbar_save = (GtkWidget*) gtk_tool_button_new (tmp_image, "Save");
   gtk_widget_set_name (toolbar_save, "toolbar_save");
   gtk_widget_show (toolbar_save);
   gtk_tool_item_set_homogeneous (GTK_TOOL_ITEM (toolbar_save), FALSE);
   gtk_container_add (GTK_CONTAINER (toolbar1), toolbar_save);
   gtk_tool_item_set_tooltip (GTK_TOOL_ITEM (toolbar_save), tooltips, "Save game to disk", NULL);

   tmp_image = gtk_image_new_from_stock ("gtk-refresh",
   	 (GtkIconSize)tmp_toolbar_icon_size);
   gtk_widget_show (tmp_image);
   toolbar_restart = (GtkWidget*) gtk_tool_button_new (tmp_image, "Restart");
   gtk_widget_set_name (toolbar_restart, "toolbar_restart");
   gtk_widget_show (toolbar_restart);
   gtk_tool_item_set_homogeneous (GTK_TOOL_ITEM (toolbar_restart), FALSE);
   gtk_container_add (GTK_CONTAINER (toolbar1), toolbar_restart);
   gtk_tool_item_set_tooltip (GTK_TOOL_ITEM (toolbar_restart), tooltips, "Restart the current game", NULL);

   tmp_image = gtk_image_new_from_stock ("gtk-stop",
   	 (GtkIconSize)tmp_toolbar_icon_size);
   gtk_widget_show (tmp_image);
   toolbar_quit = (GtkWidget*) gtk_tool_button_new (tmp_image, "Quit");
   gtk_widget_set_name (toolbar_quit, "toolbar_quit");
   gtk_widget_show (toolbar_quit);
   gtk_container_add (GTK_CONTAINER (toolbar1), toolbar_quit);
   gtk_tool_item_set_tooltip (GTK_TOOL_ITEM (toolbar_quit), tooltips, "Quit current game", NULL);

   separatortoolitem1 = (GtkWidget*) gtk_separator_tool_item_new ();
   gtk_widget_set_name (separatortoolitem1, "separatortoolitem1");
   gtk_widget_show (separatortoolitem1);
   gtk_container_add (GTK_CONTAINER (toolbar1), separatortoolitem1);

   tmp_image = gtk_image_new_from_stock ("gtk-undo",
   	 (GtkIconSize)tmp_toolbar_icon_size);
   gtk_widget_show (tmp_image);
   toolbar_undo = (GtkWidget*) gtk_tool_button_new (tmp_image, "Undo");
   gtk_widget_set_name (toolbar_undo, "toolbar_undo");
   gtk_widget_show (toolbar_undo);
   gtk_container_add (GTK_CONTAINER (toolbar1), toolbar_undo);
   gtk_tool_item_set_tooltip (GTK_TOOL_ITEM (toolbar_undo), tooltips, "Undo last turn", NULL);

   tmp_image = gtk_image_new_from_stock ("gtk-clear",
   	 (GtkIconSize)tmp_toolbar_icon_size);
   gtk_widget_show (tmp_image);
   toolbar_clear = (GtkWidget*) gtk_tool_button_new (tmp_image, "Clear");
   gtk_widget_set_name (toolbar_clear, "toolbar_clear");
   gtk_widget_show (toolbar_clear);
   gtk_container_add (GTK_CONTAINER (toolbar1), toolbar_clear);
   gtk_tool_item_set_tooltip (GTK_TOOL_ITEM (toolbar_clear), tooltips, "Clears the text screen", NULL);

   tmp_image = gtk_image_new_from_stock ("gtk-dialog-info",
   	 (GtkIconSize)tmp_toolbar_icon_size);
   gtk_widget_show (tmp_image);
   toolbar_game_info = (GtkWidget*) gtk_tool_button_new (tmp_image, "Game Info");
   gtk_widget_set_name (toolbar_game_info, "toolbar_game_info");
   gtk_widget_show (toolbar_game_info);
   gtk_tool_item_set_homogeneous (GTK_TOOL_ITEM (toolbar_game_info), FALSE);
   gtk_container_add (GTK_CONTAINER (toolbar1), toolbar_game_info);
   gtk_tool_item_set_tooltip (GTK_TOOL_ITEM (toolbar_game_info), tooltips, "Information about the game", NULL);

   toggletoolbar_log = (GtkWidget*) gtk_toggle_tool_button_new ();
   gtk_tool_button_set_label (GTK_TOOL_BUTTON (toggletoolbar_log), "Log");
   tmp_image = gtk_image_new_from_stock ("gtk-harddisk",
   	 (GtkIconSize)tmp_toolbar_icon_size);
   gtk_widget_show (tmp_image);
   gtk_tool_button_set_icon_widget (GTK_TOOL_BUTTON (toggletoolbar_log), tmp_image);
   gtk_widget_set_name (toggletoolbar_log, "toggletoolbar_log");
   gtk_widget_show (toggletoolbar_log);
   gtk_tool_item_set_homogeneous (GTK_TOOL_ITEM (toggletoolbar_log), FALSE);
   gtk_container_add (GTK_CONTAINER (toolbar1), toggletoolbar_log);

   tmp_image = gtk_image_new_from_stock ("gtk-zoom-in",
   	 (GtkIconSize)tmp_toolbar_icon_size);
   gtk_widget_show (tmp_image);
   toolbar_increase_font_size = (GtkWidget*) gtk_tool_button_new (tmp_image, "Font +");
   gtk_widget_set_name (toolbar_increase_font_size, "toolbar_increase_font_size");
   gtk_widget_show (toolbar_increase_font_size);
   gtk_tool_item_set_homogeneous (GTK_TOOL_ITEM (toolbar_increase_font_size), FALSE);
   gtk_container_add (GTK_CONTAINER (toolbar1), toolbar_increase_font_size);
   gtk_tool_item_set_tooltip (GTK_TOOL_ITEM (toolbar_increase_font_size), tooltips, "Increase font size", NULL);

   tmp_image = gtk_image_new_from_stock ("gtk-zoom-out",
   	 (GtkIconSize)tmp_toolbar_icon_size);
   gtk_widget_show (tmp_image);
   toolbar_font_size_decrease = (GtkWidget*) gtk_tool_button_new (tmp_image, "Font -");
   gtk_widget_set_name (toolbar_font_size_decrease, "toolbar_font_size_decrease");
   gtk_widget_show (toolbar_font_size_decrease);
   gtk_container_add (GTK_CONTAINER (toolbar1), toolbar_font_size_decrease);

   g_signal_connect ((gpointer) toolbar_open, "clicked",
         G_CALLBACK (on_toolbar_open_clicked),
         idata);
   g_signal_connect ((gpointer) toolbar_load, "clicked",
         G_CALLBACK (on_toolbar_load_clicked),
         idata);
   g_signal_connect ((gpointer) toolbar_save, "clicked",
         G_CALLBACK (on_toolbar_save_clicked),
         idata);
   g_signal_connect ((gpointer) toolbar_restart, "clicked",
         G_CALLBACK (on_toolbar_restart_clicked),
         idata);
   g_signal_connect ((gpointer) toolbar_quit, "clicked",
         G_CALLBACK (on_toolbar_quit_clicked),
         idata);
   g_signal_connect ((gpointer) toolbar_undo, "clicked",
         G_CALLBACK (on_toolbar_undo_clicked),
         idata);
   g_signal_connect ((gpointer) toolbar_clear, "clicked",
         G_CALLBACK (on_toolbar_clear_clicked),
         idata);
   g_signal_connect ((gpointer) toolbar_game_info, "clicked",
         G_CALLBACK (on_toolbar_game_info_clicked),
         idata);
   g_signal_connect ((gpointer) toggletoolbar_log, "toggled",
         G_CALLBACK (on_toggletoolbar_log_toggled),
         idata);
   g_signal_connect ((gpointer) toolbar_increase_font_size, "clicked",
         G_CALLBACK (on_toolbar_increase_font_size_clicked),
         idata);
   g_signal_connect ((gpointer) toolbar_font_size_decrease, "clicked",
         G_CALLBACK (on_toolbar_font_size_decrease_clicked),
         idata);

   /* Store pointers to all widgets, for use by lookup_widget(). */
   GLADE_HOOKUP_OBJECT (window1, toolbar1, "toolbar1");
   GLADE_HOOKUP_OBJECT (window1, toolbar_open, "toolbar_open");
   GLADE_HOOKUP_OBJECT (window1, toolbar_load, "toolbar_load");
   GLADE_HOOKUP_OBJECT (window1, toolbar_save, "toolbar_save");
   GLADE_HOOKUP_OBJECT (window1, toolbar_restart, "toolbar_restart");
   GLADE_HOOKUP_OBJECT (window1, toolbar_quit, "toolbar_quit");
   GLADE_HOOKUP_OBJECT (window1, separatortoolitem1, "separatortoolitem1");
   GLADE_HOOKUP_OBJECT (window1, toolbar_undo, "toolbar_undo");
   GLADE_HOOKUP_OBJECT (window1, toolbar_clear, "toolbar_clear");
   GLADE_HOOKUP_OBJECT (window1, toolbar_game_info, "toolbar_game_info");
   GLADE_HOOKUP_OBJECT (window1, toggletoolbar_log, "toggletoolbar_log");
   GLADE_HOOKUP_OBJECT (window1, toolbar_increase_font_size, "toolbar_increase_font_size");
   GLADE_HOOKUP_OBJECT (window1, toolbar_font_size_decrease, "toolbar_font_size_decrease");
   GLADE_HOOKUP_OBJECT_NO_REF (window1, tooltips, "tooltips");

   // Store to logging toggle button
   idata->log_toolbar = toggletoolbar_log;


}





//==///////////////////////////////////////////////////////////////////
//
/// Create a simple text window used to display shortcuts.
/// \param
///	none
/// \return
///	A pointer to the newly created window
//
//==///////////////////////////////////////////////////////////////////
GtkWidget* create_shortcut_window (void)
{
   GtkWidget *shortcut_window;
   GtkWidget *scrolledwindow1;
   GtkWidget *textview1;
   GtkTextBuffer *tbuf;
   GtkTextIter giter;

   int i;
   char *shorts_text[] = {
      "\tCTRL-O:  ", "Opens a new game.\n",
      "\tCTRL-E:  ", "Restarts the current game.\n",
      "\tCTRL-R:  ", "Restore/Load a savegame.\n",
      "\tCTRL-S:  ", "Save game to disk.\n",
      "\tCTRL-Q:  ", "Quit the current game.\n",
      "\tCTRL-X:  ", "Exit Rogue.\n",
      "\tCTRL-C:  ", "Clear the text screen.\n",
      "\tCTRL-V:  ", "Toggle verbose mode (Works only with Adrift).\n",
      "\tCTRL-U:  ", "Undo a single turn.\n",
      "\tCTRL-I:  ", "Show game information.\n",
      "\tCTRL-L:  ", "Load a textfile/walkthrough manually.\n",
      "\tCTRL-G:  ", "Start/Stop session logging.\n",
      "\tCTRL-D:  ", "Enable the Scare debugger.\n",
      "\tCTRL-B:  ", "Show the Scare debugging window.\n"
   };

   int num = 14;
   
   shortcut_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_widget_set_name (shortcut_window, "shortcut_window");
   gtk_window_set_title (GTK_WINDOW (shortcut_window), "Keyboard Shortcuts");

   scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
   gtk_widget_set_name (scrolledwindow1, "scrolledwindow1");
   gtk_widget_show (scrolledwindow1);
   gtk_container_add (GTK_CONTAINER (shortcut_window), scrolledwindow1);
   gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow1), 2);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrolledwindow1),
  	 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

   textview1 = gtk_text_view_new ();
   gtk_widget_set_name (textview1, "textview1");
   gtk_widget_show (textview1);
   gtk_container_add (GTK_CONTAINER (scrolledwindow1), textview1);
   gtk_widget_set_size_request (textview1, 300, 400);
   gtk_container_set_border_width (GTK_CONTAINER (textview1), 6);

   gtk_text_view_set_editable (GTK_TEXT_VIEW (textview1), FALSE);
   gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (textview1), GTK_WRAP_WORD);
   gtk_text_view_set_left_margin (GTK_TEXT_VIEW(textview1), 4);
   gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (textview1), FALSE);
   
   tbuf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview1));
  
  gtk_text_buffer_create_tag (tbuf, "red_bold",
	"weight", PANGO_WEIGHT_BOLD,
	"foreground", "DarkRed", NULL);
  
  gtk_text_buffer_create_tag (tbuf, "text_big",
	"size", PANGO_SCALE*14,
	NULL);

  gtk_text_buffer_create_tag (tbuf, "centered_text",
	"justification", GTK_JUSTIFY_CENTER,
	NULL);
  
  gtk_text_buffer_create_tag (tbuf, "black_normal",
	 "foreground", "black",
	 "weight", PANGO_WEIGHT_NORMAL,
	 NULL);

  gtk_text_buffer_get_end_iter(tbuf, &giter);
  
  gtk_text_buffer_insert_with_tags_by_name(tbuf, &giter,
	"Keyboard Shortcuts\n\n", -1, "red_bold", "centered_text", "text_big", NULL);
  
  for( i = 0; i < num; i++)
  {
     gtk_text_buffer_insert_with_tags_by_name(tbuf, &giter,
	   shorts_text[i*2], -1, "red_bold", NULL);

     gtk_text_buffer_insert_with_tags_by_name(tbuf, &giter,
	   shorts_text[i*2 + 1], -1, "black_normal", NULL);
  }

   g_signal_connect ((gpointer) shortcut_window, "delete_event",
         G_CALLBACK (gtk_widget_destroy),
         NULL);
   g_signal_connect ((gpointer) shortcut_window, "destroy_event",
         G_CALLBACK (gtk_widget_destroy),
         NULL);

   /* Store pointers to all widgets, for use by lookup_widget(). */
   GLADE_HOOKUP_OBJECT_NO_REF (shortcut_window,
  	 shortcut_window, "shortcut_window");
   GLADE_HOOKUP_OBJECT (shortcut_window, scrolledwindow1,
  	 "scrolledwindow1");
   GLADE_HOOKUP_OBJECT (shortcut_window, textview1, "textview1");

   return shortcut_window;

}



//==///////////////////////////////////////////////////////////////////
//
/// Create a simple text window used to display command help.
/// \param
///	none
/// \return
///	A pointer to the newly created window
//
//==///////////////////////////////////////////////////////////////////
GtkWidget* create_command_help_window (void)
{
   GtkWidget *shortcut_window;
   GtkWidget *scrolledwindow1;
   GtkWidget *textview1;
   GtkTextBuffer *tbuf;
   GtkTextIter giter;

   int i;
   char *shorts_text[] = {
      "\tquit:\n",		"\t\tQuit the current game.\n",
      "\tload/restore:\n",	"\t\tLoads a save game.\n",
      "\trestart:\n",		"\t\tRestart the game from beginning.\n",
      "\tundo:\n",		"\t\tUndo a single turn.\n",
      "\tsave\n",		"\t\tSave game to disk.\n",
      "\thelp, hint:\n", 	"\t\tShow game information/help.\n",
      "\te, w, n, s:\n",	"\t\tmove East, West, North, South respectively.\n",
      "\tne, nw, sw, sw:\n",	"\t\tmove NorthEast, NorthWest, SouthEast, SouthWest.\n",
      "\tup, down, in, out\n",	"\t\tMove up, down, in, out respectively.\n",
      "\tverbose:\n",		"\t\tSet the game to verbose mode.\n",
      "\texamine, or x:\n",	"\t\tExamine something. Eg. x room, x Anand.\n",
      "\tlook, or l:\n",	"\t\tLook at something/somebody. Eg. look at Anita, look under bed, look behind panel.\n",
      "\tget:\n",		"\t\tTake something. Eg. get book, get knife.\n",
      "\tdrop:\n",		"\t\tDrop something. Eg. drop pen.\n",
      "\ttalk\n",		"\t\tTalk to someone. Eg. talk to Amisha. All games don't work this way, though.\n",
      "\task:\n",		"\t\tAsk about something/somebody. Eg. ask Amisha about Amisha\n",
      "\ttell:\n",		"\t\tTell someone about something/somebody. Eg. tell Amisha about clock.\n",
      "\tgive:\n",		"\t\tGive something to someone. Eg. give wine to Ramesh.\n",
      "\tOpen/Close:\n",	"\t\tOpen/close doors, cabinets etc. Eg. open cabinet, close door\n",
      "\tShow:\n",		"\t\tShow something to someone. Eg. show photo to Anand\n",
      "\tOpen:\n",		"\t\tOpen doors, cabinets etc. Eg. open cabinet\n",
      "\tdebug:\n", 		"\t\tEnable the Scare debugger (Adrift games only!).\n"
   };

   int num = 22;
   
   shortcut_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_widget_set_name (shortcut_window, "shortcut_window");
   gtk_window_set_title (GTK_WINDOW (shortcut_window), "Command Help");

   scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
   gtk_widget_set_name (scrolledwindow1, "scrolledwindow1");
   gtk_widget_show (scrolledwindow1);
   gtk_container_add (GTK_CONTAINER (shortcut_window), scrolledwindow1);
   gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow1), 2);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrolledwindow1),
  	 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

   textview1 = gtk_text_view_new ();
   gtk_widget_set_name (textview1, "textview1");
   gtk_widget_show (textview1);
   gtk_container_add (GTK_CONTAINER (scrolledwindow1), textview1);
   gtk_widget_set_size_request (textview1, 300, 400);
   gtk_container_set_border_width (GTK_CONTAINER (textview1), 6);

   gtk_text_view_set_editable (GTK_TEXT_VIEW (textview1), FALSE);
   gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (textview1), GTK_WRAP_WORD);
   gtk_text_view_set_left_margin (GTK_TEXT_VIEW(textview1), 4);
   gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (textview1), FALSE);
   
   tbuf = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview1));
  
  gtk_text_buffer_create_tag (tbuf, "red_bold",
	"weight", PANGO_WEIGHT_BOLD,
	"foreground", "DarkRed", NULL);
  
  gtk_text_buffer_create_tag (tbuf, "text_big",
	"size", PANGO_SCALE*14,
	NULL);

  gtk_text_buffer_create_tag (tbuf, "centered_text",
	"justification", GTK_JUSTIFY_CENTER,
	NULL);
  
  gtk_text_buffer_create_tag (tbuf, "black_normal",
	 "foreground", "black",
	 "weight", PANGO_WEIGHT_NORMAL,
	 NULL);

  gtk_text_buffer_get_end_iter(tbuf, &giter);
  
  gtk_text_buffer_insert_with_tags_by_name(tbuf, &giter,
	"Useful Commands\n\n", -1, "red_bold", "centered_text", "text_big", NULL);
  
  for( i = 0; i < num; i++)
  {
     gtk_text_buffer_insert_with_tags_by_name(tbuf, &giter,
	   shorts_text[i*2], -1, "red_bold", NULL);

     gtk_text_buffer_insert_with_tags_by_name(tbuf, &giter,
	   shorts_text[i*2 + 1], -1, "black_normal", NULL);
  }

   g_signal_connect ((gpointer) shortcut_window, "delete_event",
         G_CALLBACK (gtk_widget_destroy),
         NULL);
   g_signal_connect ((gpointer) shortcut_window, "destroy_event",
         G_CALLBACK (gtk_widget_destroy),
         NULL);

   /* Store pointers to all widgets, for use by lookup_widget(). */
   GLADE_HOOKUP_OBJECT_NO_REF (shortcut_window,
  	 shortcut_window, "shortcut_window");
   GLADE_HOOKUP_OBJECT (shortcut_window, scrolledwindow1,
  	 "scrolledwindow1");
   GLADE_HOOKUP_OBJECT (shortcut_window, textview1, "textview1");

   return shortcut_window;

}

