/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/

//#include "afx.h"
#include "Kernel.h"
#include "OutputStream.h"
#include "UndoCache.h"

#ifndef _ADVMAIN
#define _ADVMAIN

class CAdvMain : public CObject
{
public:
	void PrintObjects();

	int Load( const wchar_t *filename); // This Function Executes an adventure
	int Reset(){ return 1; }; //Resets the Adventure

	void Restart();
	int PreInput();
	int ProcessInput( CString player_input );
	void DescribeRoom();
	~CAdvMain();
	CAdvMain();

	//Game Data 

	int Finished;

	CParser *parser;			//Parser
	CAdvMap GameMap;		//Descriptions and Connection Tables
	CFlagTable Flags;		//Flags
	CObjectList *Objects;	//Object List
	CMessageList SysMsg, UserMsg; //Messages System and User
	CKernel *Kernel;	//System Kernel Processes Game 'Logic'
	CObjectDef *p_CurrentObject; //Current Object Definition
	COutputStream OutStream;
	int Debugable;
	int status;
	CUndoCache *undoCache;


protected:
	void DebugMode();
	void SavePosition();
};

#endif //_ADVMAIN