/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
#ifndef _PARSER_OBJECT
#define _PARSER_OBJECT


#include "cvocab.hpp"

class CParser : public CObject
{
	//Public Data Interface

public:
	int lastadjective;
	int lastnoun;
	CParser( void); //Constructor
	~CParser( void );//destructor

	int noun1, noun2, adjective1, adjective2, preposition, verb, adverb; //current input
	int _noun1, _noun2, _adjective1, _adjective2, _preposition, _verb, _adverb; //stored input

	
	bool againAvailable; //is there a stored command available?
	bool storeInput; //input is not stored if again was in last input

	bool first_input;
	CVocab *vocabulary;
	//Public Call Interface

	int parse( wchar_t *player_input );
	void InitVocab( CArchive & );
	bool Again();
	
	wchar_t * getNoun1(void);
	wchar_t * getNoun2(void);
	wchar_t * getAdjective1(void);
	wchar_t * getAdjective2(void);
	wchar_t * getVerb(void);
	wchar_t * getAdVerb(void);

private:
	int previous_verb;
	wchar_t *tokens[10];
	int token_count;

	wchar_t ptr_noun1[32],ptr_noun2[32],ptr_adjective1[32],ptr_adjective2[32],ptr_verb[32],ptr_adverb[32];

	void reset();
};

#endif


