# This file just contains the grammar routines, conveniently stored out 
# of the way

my %grammar = 
    ((map {$_, [['Answer', 'fwd', 'topic', "'to'", 'creature']]} ('answer', 'say', 'shout', 'speak')),
     'ask', [['Ask', 'fwd', 'creature', "'about'", 'topic'], ['AskFor', 'fwd', 'creature', "'for'", 'noun'], ['AskTo', 'fwd', 'creature', "'to'", 'topic'], ['AskTo', 'fwd', "'that'", 'creature', 'topic']],
     (map {$_, [['Attack', 'fwd', 'noun']]} ('attack', 'break', 'crack', 'destroy', 'fight', 'hit', 'kill', 'murder', 'punch', 'smash', 'thump', 'torture', 'wreck')),
     'blow', [['Blow', 'fwd', 'held']],
     (map {$_, [['Mild', 'fwd'], ['Mild', 'fwd', 'topic']]} ('bother', 'curses', 'darn', 'drat')),
     (map {$_, [['Burn', 'fwd', 'noun'], ['Burn', 'fwd', 'noun', "'with'", 'held']]} ('burn', 'light')),
     (map {$_, [['Buy', 'fwd', 'noun']]} ('buy', 'purchase')),
     (map {$_, [['Climb', 'fwd', 'noun'], ['Climb', 'fwd', "'up'", 'noun'], ['Climb', 'fwd', "'over'", 'noun']]} ('climb', 'scale')),
     (map {$_, [['Close', 'fwd', 'noun'], ['Close', 'fwd', "'up'", 'noun'], ['SwitchOff', 'fwd', "'off'", 'noun']]} ('close', 'cover', 'shut')),
     'consult', [['Consult', 'fwd', 'noun', "'about'", 'topic'], ['Consult', 'fwd', 'noun', "'on'", 'topic']],
     (map {$_, [['Cut', 'fwd', 'noun']]} ('cut', 'chop', 'prune', 'slice')),
     'dig', [['Dig', 'fwd', 'noun'], ['Dig', 'fwd', 'noun', "'with'", 'held']],
     (map {$_, [['Drink', 'fwd', 'noun']]} ('drink', 'sip', 'swallow')),
     (map {$_, [['Drop', 'fwd', 'multiheld'], ['Insert', 'fwd', 'multiexcept', "'in'", 'noun'], ['Insert', 'fwd', 'multiexcept', "'into'", 'noun'], ['Insert', 'fwd', 'multiexcept', "'down'", 'noun'], ['PutOn', 'fwd', 'multiexcept', "'on'", 'noun'], ['PutOn', 'fwd', 'multiexcept', "'onto'", 'noun'], ['ThrowAt', 'fwd', 'held', "'at'", 'noun'], ['ThrowAt', 'fwd', 'held', "'against'", 'noun'], ['ThrowAt', 'fwd', 'held', "'on'", 'noun'], ['ThrowAt', 'fwd', 'held', "'onto'", 'noun']]} ('drop', 'discard', 'throw')),
     'eat', [['Eat', 'fwd', 'held']],
     'empty', [['Empty', 'fwd', 'noun'], ['Empty', 'fwd', "'out'", 'noun'], ['Empty', 'fwd', 'noun', "'out'"], ['EmptyT', 'fwd', 'noun', "'to'", 'noun'], ['EmptyT', 'fwd', 'noun', "'into'", 'noun'], ['EmptyT', 'fwd', 'noun', "'on'", 'noun'], ['EmptyT', 'fwd', 'noun', "'onto'", 'noun']],
     (map {$_, [['GoIn', 'fwd'], ['Enter', 'fwd', 'noun']]} ('enter', 'cross')),
     (map {$_, [['Examine', 'fwd', 'noun']]} ('examine', 'x', 'check', 'describe', 'watch')),
     (map {$_, [['Exit', 'fwd'], ['Exit', 'fwd', 'noun']]} ('exit', 'out', 'outside')),
     'fill', [['Fill', 'fwd', 'noun']],
     'get', [['Exit', 'fwd', "'out'"], ['Exit', 'fwd', "'off'"], ['Exit', 'fwd', "'up'"], ['Take', 'fwd', 'multi'], ['Enter', 'fwd', "'in'", 'noun'], ['Enter', 'fwd', "'into'", 'noun'], ['Enter', 'fwd', "'on'", 'noun'], ['Enter', 'fwd', "'onto'", 'noun'], ['GetOff', 'fwd', "'off'", 'noun'], ['Remove', 'fwd', 'multiinside', "'from'", 'noun']],
     (map {$_, [['Give', 'fwd', 'held', "'to'", 'creature'], ['Give', 'rev', 'creature', 'held'], ['Give', 'fwd', "'over'", 'held', "'to'", 'creature']]} ('give', 'feed', 'offer', 'pay')),
     (map {$_, [['VagueGo', 'fwd'], ['Go', 'fwd', 'noun=ADirection'], ['Enter', 'fwd', 'noun'], ['Enter', 'fwd', "'into'", 'noun'], ['Enter', 'fwd', "'in'", 'noun'], ['Enter', 'fwd', "'inside'", 'noun'], ['Enter', 'fwd', "'through'", 'noun']]} ('go', 'run', 'walk')),
     (map {$_, [['GoIn', 'fwd']]} ('in', 'inside')),
     'insert', [['Insert', 'fwd', 'multiexcept', "'in'", 'noun'], ['Insert', 'fwd', 'multiexcept', "'into'", 'noun']],
     (map {$_, [['Inv', 'fwd'], ['InvTall', 'fwd', "'tall'"], ['InvWide', 'fwd', "'wide'"]]} ('inventory', 'inv', 'i')),
     (map {$_, [['Jump', 'fwd'], ['JumpOver', 'fwd', "'over'", 'noun']]} ('jump', 'hop', 'skip')),
     (map {$_, [['Kiss', 'fwd', 'creature']]} ('kiss', 'embrace', 'hug')),
     'leave', [['VagueGo', 'fwd'], ['Go', 'fwd', 'noun=ADirection'], ['Exit', 'fwd', 'noun'], ['Enter', 'fwd', "'into'", 'noun'], ['Enter', 'fwd', "'in'", 'noun'], ['Enter', 'fwd', "'inside'", 'noun'], ['Enter', 'fwd', "'through'", 'noun']],
     (map {$_, [['Listen', 'fwd'], ['Listen', 'fwd', 'noun'], ['Listen', 'fwd', "'to'", 'noun']]} ('listen', 'hear')),
     'lock', [['Lock', 'fwd', 'noun', "'with'", 'held']],
     (map {$_, [['Look', 'fwd'], ['Examine', 'fwd', "'at'", 'noun'], ['Search', 'fwd', "'inside'", 'noun'], ['Search', 'fwd', "'in'", 'noun'], ['Search', 'fwd', "'into'", 'noun'], ['Search', 'fwd', "'through'", 'noun'], ['Search', 'fwd', "'on'", 'noun'], ['LookUnder', 'fwd', "'under'", 'noun'], ['Consult', 'fwd', "'up'", 'topic', "'in'", 'noun'], ['Examine', 'fwd', 'noun=ADirection'], ['Examine', 'fwd', "'to'", 'noun=ADirection']]} ('look', 'l')),
     'no', [['No', 'fwd']],
     (map {$_, [['Open', 'fwd', 'noun'], ['Unlock', 'fwd', 'noun', "'with'", 'held']]} ('open', 'uncover', 'undo', 'unwrap')),
     'peel', [['Take', 'fwd', 'noun'], ['Take', 'fwd', "'off'", 'noun']],
     'pick', [['Take', 'fwd', "'up'", 'multi'], ['Take', 'fwd', 'multi', "'up'"]],
     'pray', [['Pray', 'fwd']],
     (map {$_, [['Unlock', 'fwd', 'noun', "'with'", 'held'], ['Unlock', 'fwd', "'apart'", 'noun', "'with'", 'held'], ['Unlock', 'fwd', "'open'", 'noun', "'with'", 'held'], ['Unlock', 'fwd', 'noun', "'apart'", "'with'", 'held'], ['Unlock', 'fwd', 'noun', "'open'", "'with'", 'held']]} ('pry', 'prise', 'prize', 'lever', 'jemmy', 'force')),
     (map {$_, [['Pull', 'fwd', 'noun']]} ('pull', 'drag')),
     (map {$_, [['Push', 'fwd', 'noun'], ['PushDir', 'fwd', 'noun', 'noun'], ['Transfer', 'fwd', 'noun', "'to'", 'noun']]} ('push', 'clear', 'move', 'press', 'shift')),
     'put', [['Insert', 'fwd', 'multiexcept', "'in'", 'noun'], ['Insert', 'fwd', 'multiexcept', "'inside'", 'noun'], ['Insert', 'fwd', 'multiexcept', "'into'", 'noun'], ['PutOn', 'fwd', 'multiexcept', "'on'", 'noun'], ['PutOn', 'fwd', 'multiexcept', "'onto'", 'noun'], ['Wear', 'fwd', "'on'", 'held'], ['Drop', 'fwd', "'down'", 'multiheld'], ['Drop', 'fwd', 'multiheld', "'down'"]],
     'read', [['Examine', 'fwd', 'noun'], ['Consult', 'fwd', "'about'", 'topic', "'in'", 'noun'], ['Consult', 'fwd', 'topic', "'in'", 'noun']],
     'remove', [['Disrobe', 'fwd', 'held'], ['Take', 'fwd', 'multi'], ['Remove', 'fwd', 'multiinside', "'from'", 'noun']],
     (map {$_, [['Rub', 'fwd', 'noun']]} ('rub', 'clean', 'dust', 'polish', 'scrub', 'shine', 'sweep', 'wipe')),
     'search', [['Search', 'fwd', 'noun']],
     (map {$_, [['Set', 'fwd', 'noun'], ['SetTo', 'fwd', 'noun', "'to'", 'special']]} ('set', 'adjust')),
     (map {$_, [['Disrobe', 'fwd', 'held']]} ('shed', 'disrobe', 'doff')),
     (map {$_, [['Show', 'rev', 'creature', 'held'], ['Show', 'fwd', 'held', "'to'", 'creature']]} ('show', 'display', 'present')),
     (map {$_, [['Strong', 'fwd'], ['Strong', 'fwd', 'topic']]} ('shit', 'damn', 'fuck', 'sod')),
     'sing', [['Sing', 'fwd']],
     (map {$_, [['Enter', 'fwd', "'on'", "'top'", "'of'", 'noun'], ['Enter', 'fwd', "'on'", 'noun'], ['Enter', 'fwd', "'in'", 'noun'], ['Enter', 'fwd', "'inside'", 'noun']]} ('sit', 'lie')),
     (map {$_, [['Sleep', 'fwd']]} ('sleep', 'nap')),
     (map {$_, [['Smell', 'fwd'], ['Smell', 'fwd', 'noun']]} ('smell', 'sniff')),
     'sorry', [['Sorry', 'fwd']],
     (map {$_, [['Squeeze', 'fwd', 'noun']]} ('squeeze', 'squash')),
     'stand', [['Exit', 'fwd'], ['Exit', 'fwd', "'up'"], ['Enter', 'fwd', "'on'", 'noun']],
     (map {$_, [['Swim', 'fwd']]} ('swim', 'dive')),
     'swing', [['Swing', 'fwd', 'noun'], ['Swing', 'fwd', "'on'", 'noun']],
     'switch', [['Switchon', 'fwd', 'noun'], ['Switchon', 'fwd', 'noun', "'on'"], ['Switchoff', 'fwd', 'noun', "'off'"], ['Switchon', 'fwd', "'on'", 'noun'], ['Switchoff', 'fwd', "'off'", 'noun']],
     (map {$_, [['Take', 'fwd', 'multi'], ['Disrobe', 'fwd', "'off'", 'worn'], ['Remove', 'fwd', 'multiinside', "'from'", 'noun'], ['Remove', 'fwd', 'multiinside', "'off'", 'noun'], ['Inv', 'fwd', "'inventory'"]]} ('take', 'carry', 'hold')),
     'taste', [['Taste', 'fwd', 'noun']],
     'tell', [['Tell', 'fwd', 'creature', "'about'", 'topic'], ['AskTo', 'fwd', 'creature', "'to'", 'topic']],
     'think', [['Think', 'fwd']],
     (map {$_, [['Tie', 'fwd', 'noun'], ['Tie', 'fwd', 'noun', "'to'", 'noun']]} ('tie', 'attach', 'fasten', 'fix')),
     (map {$_, [['Touch', 'fwd', 'noun']]} ('touch', 'feel', 'fondle', 'grope')),
     'transfer', [['Transfer', 'fwd', 'noun', "'to'", 'noun']],
     (map {$_, [['Turn', 'fwd', 'noun'], ['Switchon', 'fwd', 'noun', "'on'"], ['Switchoff', 'fwd', 'noun', "'off'"], ['Switchon', 'fwd', "'on'", 'noun'], ['Switchoff', 'fwd', "'off'", 'noun']]} ('turn', 'rotate', 'screw', 'twist', 'unscrew')),
     'wave', [['WaveHands', 'fwd'], ['Wave', 'fwd', 'noun']],
     (map {$_, [['Wear', 'fwd', 'held']]} ('wear', 'don')),
     (map {$_, [['Yes', 'fwd']]} ('yes', 'y')),
     'unlock', [['Unlock', 'fwd', 'noun', "'with'", 'held']],
     (map {$_, [['Wait', 'fwd']]} ('wait', 'z')),
     (map {$_, [['Wake', 'fwd'], ['Wake', 'fwd', "'up'"], ['WakeOther', 'fwd', 'creature'], ['WakeOther', 'fwd', 'creature', "'up'"], ['WakeOther', 'fwd', "'up'", 'creature']]} ('wake', 'awake', 'awaken'))
     );


# Put any extra grammar lines here.

push @{$grammar{unlock}}, ['Unlock', 'fwd', 'noun'];
$grammar{talk} = [['TalkTo', 'fwd', 'creature'], ['TalkTo', 'fwd', "'to'", 'creature']];
$grammar{use} = [['Use', 'fwd', 'noun']];

$grammar{fire} = [['Staple', 'fwd', "'stapler'", "'at'", 'noun']];
$grammar{paint} = [['Paint', 'fwd', 'noun']]; 
push @{$grammar{look}}, ['Search', 'fwd', "'out'", 'noun'];
$grammar{stab} = $grammar{sacr} = $grammar{sacrifice} = $grammar{kill};

sub get_grammar { 
    my $gramfil = shift; 
    #print "\$gramfil == '$gramfil'\n";
    if ($gramfil ne '') {
	my $FH;
	open $FH, $gramfil or print "* * * No such file '$gramfil' * * *\n";
	my $txt = join ("", <$FH>);
	#print "\nevalling grammar text ''$txt''\n\n";
	eval $txt;
    } 
    return %grammar; 
}


my %n_objs = ();

# If the action can take at least than that many objects, return 1
#
sub get_n_objs {
    my ($act, $n) = @_;
    if (!%n_objs) {
	foreach my $verb (keys %grammar) {
	    foreach my $gl (@{$grammar{$verb}}) {
		my @line = @$gl;
		my $act = shift @line;
		shift @line; # remove fwd / reverse
		my $count = 0;
		foreach my $token (@line) {
		    if ($token !~ /^\'.*\'$/) {
			++ $count;
		    }
		}
		$n_objs{$act}{$count} = 1;
	    }
	}
    }
    if ($n_objs{$act}{2} || $n == 0) { return 1; }
    if ($n < 2 && $n_objs{$act}{1}) { return 1; }
    return 0;
}

1;

