/*
   Header file for Windows specific Glk features.
   Glk API version 0.61, WinGlk release 1.20.
*/

#ifndef WINGLK_H_
#define WINGLK_H_

#ifdef __cplusplus
extern "C" {
#endif

/* Function to be implemented in the Glk program. */
int winglk_startup_code(const char* cmdline);

/* Windows Glk specific functions. */
strid_t winglk_stream_open_resource(const char* name, const char* type, glui32 rock);
void winglk_app_set_name(const char* name);
void winglk_window_set_title(const char* title);
void winglk_set_resource_directory(const char* dir);
const char* winglk_get_initial_filename(const char* cmdline, const char* title, const char* filter);
void winglk_set_gui(unsigned int id);

/* Unofficial Glk extensions. */
void sglk_set_basename(char *s);

/* Windows Glk specific events. */
#define winglk_evtype_GuiInput (0x80000000)

#ifdef __cplusplus
}
#endif

#endif /* WINGLK_H_ */
