#define UNIX
#pragma lint -1
#pragma noroot

#if STACKDEBUG
#pragma debug 24
#endif

#if OPTIMIZE
#pragma optimize 9
#endif

#include "allint.h"  /* TUU */
#include <string.h> /* TUU */
/* #include <stdio.h> already in allint.h TUU */


long _seed = 1L;

#ifndef UNIX
MyInt rand(void)
{
    _seed *= 397204094L;
    return (_seed & 0x7FFF);
}

void srand(long n)
{
   _seed = n;
}
#endif

int getch(void)
{
#ifdef UNIX
    return getchar();
#else
    int ch;
    if ((ch = bdos(1) & 0xFF) == '\r') { bdos(6,'\n'); ch = '\n'; }
    return (ch);
#endif
}

void waitch(void)
{
#ifndef UNIX
    bdos(7);
#else        /* TUU */
  getchar(); /* TUU */
#endif
}

void putch(int ch,FILE *fp)
{
#ifdef UNIX
    if (ch=='\r')   /* TUU */
      ch='\n';
    putc(ch,fp);
#else
    aputc(ch,fp);
#endif
}

MyInt advsave(char *hdr,MyInt hlen,char *save,MyInt slen)
{
    char fname[50];
    FILE *fd;

    trm_str("File name? ");
    trm_get(fname);

    /* add the extension */
    strcat(fname,".sav");

    /* create the data file */
    if ((fd = fopen(fname,"w")) == 0)
	return (0);

    /* write the header */
    if (fwrite(hdr,1,hlen,fd) != hlen) {
	fclose(fd);
	return (0);
    }
/** WAS TUU
    if (write(fd,hdr,hlen) != hlen) {
	close(fd);
	return (0);
    }
****/

    /* write the data */
    if (fwrite(save,1,slen,fd) != slen) {
	fclose(fd);
	return (0);
    }
/* WAS TUU
    if (write(fd,save,slen) != slen) {
	close(fd);
	return (0);
    }
***/

    /* close the file and return successfully */
    fclose(fd);
    return (1);
}

MyInt advrestore(char *hdr,MyInt hlen,char *save,MyInt slen)
{
    char fname[50],hbuf[50],*p;
    FILE *fd;

    if (hlen > 50)
	error("save file header buffer too small");

    trm_str("File name? ");
    trm_get(fname);

    /* add the extension */
    strcat(fname,".sav");

    /* create the data file */
    if ((fd = fopen(fname,"r")) == 0)
	return (0);

    /* read the header */
    if (fread(hbuf,1,hlen,fd) != hlen) {
	fclose(fd);
	return (0);
    }

    /* compare the headers */
    for (p = hbuf; hlen--; )
	if (*hdr++ != *p++) {
	    trm_str("This save file does not match the adventure!\n");
	    return (0);
	}

    /* read the data */
    if (fread(save,1,slen,fd) != slen) {
	fclose(fd);
	return (0);
    }

    /* close the file and return successfully */
    fclose(fd);
    return (1);
}
