/*
 * Decompiled with CFR 0.152.
 */
package mdh.aiee;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;
import mdh.aiee.Actor;
import mdh.aiee.Aiee;
import mdh.aiee.CmdAsk;
import mdh.aiee.CmdFunction;
import mdh.aiee.CmdGuard;
import mdh.aiee.CmdRoomExit;
import mdh.aiee.Command;
import mdh.aiee.Entity;
import mdh.aiee.FileUtil;
import mdh.aiee.Global;
import mdh.aiee.Item;
import mdh.aiee.Player;
import mdh.aiee.Props;
import mdh.aiee.Room;
import mdh.aiee.Stuff;
import mdh.aiee.Thing;
import mdh.aiee.Usable;

public class Adventure
implements Serializable {
    private static Adventure ADV_ = new Adventure();
    private static final int CMD_Ask = 0;
    private static final int CMD_Close = 1;
    private static final int CMD_Drop = 2;
    private static final int CMD_Go = 3;
    private static final int CMD_Hint = 4;
    private static final int CMD_Help = 5;
    private static final int CMD_Inv = 6;
    private static final int CMD_Kill = 7;
    private static final int CMD_Look = 8;
    private static final int CMD_Log = 9;
    private static final int CMD_Open = 10;
    private static final int CMD_Put = 11;
    private static final int CMD_Quit = 12;
    private static final int CMD_Ready = 13;
    private static final int CMD_Restart = 14;
    private static final int CMD_Restore = 15;
    private static final int CMD_Save = 16;
    private static final int CMD_Score = 17;
    private static final int CMD_Take = 18;
    private static final int CMD_Use = 19;
    private static final int CMD_Version = 20;
    private static final int CMD_Wait = 21;
    private static final int CMD_Give = 22;
    private static final int CMD_Say = 23;
    private static final String[] COMMAND_NAME = new String[]{"ask", "close", "drop", "go", "hint", "help", "inv", "kill", "look", "log", "open", "put", "quit", "ready", "restart", "restore", "save", "score", "take", "use", "version", "wait", "give", "say"};
    private static HashMap COMMANDS = new HashMap();
    private static HashMap PREPOSITIONS;
    private static final String[] HELPMENU;
    private static final int HELP_COMMANDS = 0;
    private transient Aiee env_;
    private Random rnd_ = new Random();
    private String start_;
    private Command grue_;
    private Command intro_;
    private HashMap stuff_ = new HashMap();
    private HashMap functions_ = new HashMap();
    private ArrayList daemons_ = new ArrayList(8);
    private int turn_ = 1;
    private int scoreBase_;
    private int hints_;
    private Props vars_ = new Props();
    private boolean silent_;
    private String lastCommand_;

    public static Adventure getAdv() {
        return ADV_;
    }

    protected static void setAdv(Adventure adv) {
        ADV_ = adv;
    }

    public Adventure() {
        if (ADV_ != null) {
            throw new IllegalStateException("Duplicate Adventure");
        }
        this.reset();
    }

    public void addDaemon(Stuff st) {
        this.daemons_.add(st);
    }

    public void addFunction(CmdFunction func) {
        this.functions_.put(func.id(), func);
    }

    public void addScore(int s) {
        this.scoreBase_ += s;
    }

    public void addStuff(Stuff st) {
        this.stuff_.put(st.id(), st);
    }

    private boolean commandIntercept() {
        int rc;
        int rc2;
        Player pl = this.getPlayer();
        if (pl.getCommand() != null && (rc2 = pl.getCommand().doEval(this, pl)) == 2) {
            return true;
        }
        Room room = this.getPlayerRoom();
        int len = room.countContents();
        for (int i = 0; i < len; ++i) {
            int rc3;
            Actor actor;
            Thing th = room.findContents(i);
            if (!(th instanceof Actor) || (actor = (Actor)th).getObserve() == null || (rc3 = actor.getObserve().doEval(this, actor)) != 2) continue;
            return true;
        }
        return room != null && room.getCommand() != null && (rc = room.getCommand().doEval(this, room)) == 2;
    }

    public int computeScore() {
        int score = this.scoreBase_;
        Iterator e = this.stuff_.values().iterator();
        while (e.hasNext()) {
            Object o = e.next();
            if (!(o instanceof Item)) continue;
            Item it = (Item)o;
            int p = it.getPoints();
            String itloc = String.valueOf(it.loc());
            if (p == 0 || !itloc.equals(String.valueOf(it.getPointsLoc()))) continue;
            score += p;
        }
        this.vars_.set("_score", score);
        return score;
    }

    public int d(int s) {
        return this.rnd_.nextInt(s) + 1;
    }

    public int d(int n, int s) {
        int t = 0;
        for (int i = 0; i < n; ++i) {
            t += this.rnd_.nextInt(s) + 1;
        }
        return t;
    }

    public void die() {
        this.printlnRaw("* * *  YOU HAVE DIED  * * *");
        this.quit();
    }

    private Thing findContents(Stuff start, String prompt, String name) {
        ArrayList list = new ArrayList(1);
        this.findContentsInside(start, list, name);
        return this.selectContents(list, prompt, name);
    }

    private void findContentsInside(Stuff cont, ArrayList list, String name) {
        if (cont == null) {
            return;
        }
        int len = cont.countContents();
        for (int i = 0; i < len; ++i) {
            Item it;
            Thing th = cont.findContents(i);
            if (th.matchesName(name)) {
                list.add(th);
            }
            if (!(th instanceof Item) || (it = (Item)th).getCapacity() <= 0 || it.getClosed()) continue;
            this.findContentsInside(th, list, name);
        }
    }

    private Thing findContentsPlayer(String prompt, String name) {
        ArrayList list = new ArrayList(1);
        this.findContentsInside(this.getPlayer(), list, name);
        this.findContentsInside(this.getPlayerRoom(), list, name);
        return this.selectContents(list, prompt, name);
    }

    public void gameover() {
        this.printlnRaw("* * *  GAME OVER  * * *");
        this.quit();
    }

    public Aiee getEnv() {
        return this.env_;
    }

    public CmdFunction getFunction(String id) {
        if (id == null) {
            return null;
        }
        return (CmdFunction)this.functions_.get(id);
    }

    public Command getGrue() {
        return this.grue_;
    }

    public Command getIntro() {
        return this.intro_;
    }

    public int getMaxscore() {
        return this.vars_.getInt("_maxscore");
    }

    public boolean getSilent() {
        return this.silent_;
    }

    public String getStart() {
        return this.start_;
    }

    public Player getPlayer() {
        return (Player)this.stuff_.get("player");
    }

    public Room getPlayerRoom() {
        Player pl = this.getPlayer();
        Room room = (Room)pl.findLoc();
        return room;
    }

    public Stuff getStuff(String id) {
        if (id == null) {
            return null;
        }
        return (Stuff)this.stuff_.get(id);
    }

    public int getTurn() {
        return this.turn_;
    }

    public int getVarInt(String varname) {
        return this.vars_.getInt(this.replaceVars(varname));
    }

    public String getVarString(String varname) {
        return this.vars_.getString(this.replaceVars(varname));
    }

    private void ignoring(String text1, String text2) {
        if (text2 == null || text2.length() == 0) {
            if (text1.length() > 0) {
                this.printlnRaw(Global.join("(ignoring '", text1, "')"));
            }
        } else if (text1.length() > 0) {
            if (text2.length() == 0) {
                this.printlnRaw(Global.join("(ignoring '", text1, "')"));
            } else {
                this.printlnRaw(Global.join(new String[]{"(ignoring '", text1, " ", text2, "')"}));
            }
        }
    }

    public void intro() {
        this.printlnRaw("");
        if (this.intro_ != null) {
            this.intro_.doEval(this, null);
            this.printlnRaw("");
        }
        this.setSilent(true);
        Iterator stit = this.stuff_.values().iterator();
        while (stit.hasNext()) {
            Object o = stit.next();
            if (!(o instanceof Entity)) continue;
            Entity en = (Entity)o;
            int len = en.countContents();
            for (int i = 0; i < len; ++i) {
                Item it;
                Thing th = en.findContents(i);
                if (!(th instanceof Item) || (it = (Item)th).getReady() == null) continue;
                en.doReady(it);
            }
        }
        this.setSilent(false);
        this.plMove(this.getStuff(this.start_));
    }

    private void nextTurn() {
        this.computeScore();
        int len = this.daemons_.size();
        for (int i = 0; i < len; ++i) {
            Stuff st = (Stuff)this.daemons_.get(i);
            if (this.getDebug()) {
                System.err.println("daemon " + st.id());
            }
            if (st instanceof Thing) {
                this.vars_.set("_here", ((Thing)st).loc());
            } else if (st instanceof Room) {
                this.vars_.set("_here", st.id());
            } else {
                this.vars_.set("_here", "");
            }
            if (st instanceof Entity) {
                this.vars_.set("_who", st.id());
            } else {
                this.vars_.remove("_who");
            }
            st.getTurn().doEval(this, st);
        }
        ++this.turn_;
    }

    public String num(int n, String s) {
        StringBuffer sb = new StringBuffer(s.length() + 3);
        sb.append(n);
        sb.append(' ');
        sb.append(s);
        if (n != 1) {
            sb.append('s');
        }
        return sb.substring(0);
    }

    public void plMove(Stuff dest) {
        this.env_.showImage(null);
        if (dest == null) {
            throw new IllegalArgumentException("You cannot move the player to room 'null'");
        }
        if (!(dest instanceof Room)) {
            throw new IllegalArgumentException("You can only move the player to a room, not '" + dest.id() + "'");
        }
        Room room = (Room)dest;
        Player pl = this.getPlayer();
        pl.moveto(room);
        this.vars_.set("_here", room.id());
        this.vars_.set("_plroom", room.id());
        if (dest != null) {
            if (this.getDebug()) {
                System.err.println("Before ENTER: light=" + room.containsLight());
            }
            if (room.getEnter() != null) {
                room.getEnter().doEval(this, room);
            }
            boolean light = room.containsLight();
            if (this.getDebug()) {
                System.err.println("After ENTER: light=" + light);
            }
            if (light) {
                this.env_.title(room.getName());
                if (!room.getVisited()) {
                    room.setVisited(true);
                    this.scoreBase_ += room.getPoints();
                    this.doLook("", "");
                } else {
                    String s = room.listContents("You see here: ");
                    if (s != null) {
                        this.printlnRaw(s);
                    }
                }
            } else {
                this.env_.title("Darkness");
                this.doLook("", "");
            }
        }
    }

    public Stuff removeStuff(String id) {
        return (Stuff)this.stuff_.remove(id);
    }

    public String replaceAll(String text) {
        text = this.replaceVars(text);
        text = this.replaceEscapes(text);
        return text;
    }

    public String replaceEscapes(String text) {
        if (text == null) {
            return null;
        }
        int i = text.indexOf(92);
        if (i < 0) {
            return text;
        }
        int len = text.length();
        StringBuffer sb = new StringBuffer(len);
        sb.append(text.substring(0, i));
        block11: while (i < len) {
            char c = text.charAt(i);
            if (c != '\\') {
                sb.append(c);
                ++i;
                continue;
            }
            int escape = i > len - 2 ? 0 : (int)text.charAt(i + 1);
            switch (escape) {
                case 92: {
                    sb.append('\\');
                    i += 2;
                    continue block11;
                }
                case 116: {
                    sb.append('\t');
                    i += 2;
                    continue block11;
                }
                case 110: {
                    sb.append('\n');
                    i += 2;
                    continue block11;
                }
                case 117: {
                    int n;
                    if (i > len - 6) break;
                    try {
                        n = Integer.parseInt(text.substring(i + 2, i + 6), 16);
                        sb.append((char)n);
                        i += 6;
                        continue block11;
                    }
                    catch (NumberFormatException e) {
                        break;
                    }
                }
                case 120: {
                    int n;
                    if (i > len - 4) break;
                    try {
                        n = Integer.parseInt(text.substring(i + 2, i + 4), 16);
                        sb.append((char)n);
                        i += 4;
                        continue block11;
                    }
                    catch (NumberFormatException e) {
                        break;
                    }
                }
            }
            throw new IllegalArgumentException("Unknown escape code " + text.substring(i));
        }
        return sb.substring(0);
    }

    public String replaceVars(String text) {
        int end;
        if (text == null) {
            return null;
        }
        int i = text.indexOf("$(");
        if (i < 0) {
            return text;
        }
        StringBuffer sb = new StringBuffer(text.length());
        sb.append(text.substring(0, i));
        while (true) {
            if ((end = text.indexOf(41, i)) < 0) {
                throw new IllegalArgumentException("Illegal text var: " + text);
            }
            String varname = text.substring(i + 2, end);
            String value = this.vars_.getString(varname);
            if (value != null) {
                sb.append(value);
            } else {
                sb.append("$(Undefined ").append(varname).append(')');
            }
            i = text.indexOf("$(", end + 1);
            if (i < 0) break;
            sb.append(text.substring(end + 1, i));
        }
        sb.append(text.substring(end + 1));
        return sb.substring(0);
    }

    public void reset() {
        this.start_ = null;
        this.intro_ = null;
        this.stuff_.clear();
        this.functions_.clear();
        this.daemons_.clear();
        this.vars_.clear();
        this.turn_ = 1;
        this.hints_ = 0;
        this.scoreBase_ = 0;
        this.vars_.set("_score", 0);
        Player pl = new Player();
        this.addStuff(pl);
    }

    private Thing selectContents(ArrayList list, String prompt, String name) {
        if (list.size() == 0) {
            this.printlnRaw(Global.join("You can't see a '", name, "' here."));
            return null;
        }
        if (list.size() == 1) {
            Thing th = (Thing)list.get(0);
            if (!th.equalsName(name)) {
                this.printlnRaw(Global.join("(assuming you mean ", th.theName(), ")"));
            }
            return th;
        }
        String[] options = new String[list.size()];
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            options[i] = ((Thing)list.get(i)).getName();
        }
        int opt = this.menu(prompt, options, true);
        if (opt < 0) {
            return null;
        }
        return (Thing)list.get(opt);
    }

    public void setGrue(Command g) {
        this.grue_ = g;
    }

    public void setIntro(Command i) {
        this.intro_ = i;
    }

    public void setMaxscore(int m) {
        this.vars_.set("_maxscore", m);
    }

    public void setSilent(boolean s) {
        this.silent_ = s;
    }

    public void setStart(String s) {
        this.start_ = s;
    }

    public void setVarInt(String varname, int value) {
        this.vars_.set(this.replaceVars(varname), value);
    }

    public void setVarString(String varname, String value) {
        this.vars_.set(this.replaceVars(varname), value);
    }

    private String[] tokenize(String line) {
        String[] tokens = new String[4];
        StringTokenizer st = new StringTokenizer(line, " \t");
        if (!st.hasMoreTokens()) {
            return null;
        }
        tokens[0] = st.nextToken();
        tokens[1] = "";
        tokens[2] = "";
        tokens[3] = "";
        int word = 1;
        StringBuffer sb = new StringBuffer(line.length());
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (word == 1 && PREPOSITIONS.containsKey(s)) {
                if (sb.length() == 0) {
                    this.printlnRaw(Global.join("I don't understand, ", s, " what?"));
                    return null;
                }
                tokens[word++] = sb.substring(0);
                tokens[word++] = s;
                sb.setLength(0);
                continue;
            }
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(s);
        }
        tokens[word] = sb.substring(0);
        return tokens;
    }

    public boolean getDebug() {
        return this.env_ != null ? this.env_.getDebug() : false;
    }

    public String input(String prompt) {
        if (this.silent_) {
            return null;
        }
        return this.env_.input(prompt);
    }

    public int menu(String prompt, String[] options, boolean cancel) {
        if (this.silent_) {
            return -1;
        }
        return this.env_.menu(prompt, options, cancel);
    }

    public void println(String s) {
        this.printlnRaw(this.replaceAll(s));
    }

    public void printlnRaw(String s) {
        if (!this.silent_) {
            this.env_.println(s);
        }
    }

    public void quit() {
        this.doInv("", "");
        this.doScore("", "");
        this.env_.loggerStop();
        this.env_.quit();
    }

    public void setDebug(boolean on) {
        this.env_.setDebug(on);
    }

    protected void setEnvironment(Aiee env) {
        this.env_ = env;
    }

    public boolean yesno(String prompt) {
        if (this.silent_) {
            return false;
        }
        return this.env_.yesno(prompt);
    }

    public boolean doCommand(String line) {
        if (line == null || line.length() == 0) {
            return false;
        }
        if (line.equals(".")) {
            line = this.lastCommand_;
        } else {
            this.lastCommand_ = line;
        }
        String[] tokens = this.tokenize(line);
        if (tokens == null) {
            return false;
        }
        String cmd = tokens[0];
        String text1 = tokens[1];
        String prep = tokens[2];
        String text2 = tokens[3];
        if (this.getDebug()) {
            System.out.println("cmd='" + cmd + "' text1='" + text1 + "' text2='" + text2 + "'");
        }
        if (!COMMANDS.containsKey(cmd)) {
            this.printlnRaw(Global.join("I don't know how to '", cmd, "'.  Type 'help' for instructions."));
            return false;
        }
        int cmdnum = (Integer)COMMANDS.get(cmd);
        Room room = this.getPlayerRoom();
        this.vars_.set("_who", "player");
        this.vars_.set("_here", room == null ? "null" : room.id());
        this.vars_.set("_turn", this.turn_);
        this.vars_.set("_cmd", COMMAND_NAME[cmdnum]);
        this.vars_.set("_text1", text1);
        this.vars_.set("_arg1", "");
        this.vars_.set("_name1", "");
        this.vars_.set("_prep", prep);
        this.vars_.set("_text2", text2);
        this.vars_.set("_arg2", "");
        this.vars_.set("_name2", "");
        this.computeScore();
        boolean tookTurn = false;
        switch (cmdnum) {
            case 0: {
                tookTurn = this.doAsk(text1, text2);
                break;
            }
            case 1: {
                tookTurn = this.doOpen(1, text1, text2);
                break;
            }
            case 2: {
                tookTurn = this.doDrop(text1, text2);
                break;
            }
            case 3: {
                text2 = text1;
                text1 = cmd;
                this.vars_.set("_text1", text1);
                this.vars_.set("_text2", text2);
                tookTurn = this.doGo(text1, text2);
                break;
            }
            case 4: {
                return this.doHint(text1, text2);
            }
            case 5: {
                return this.doHelp(text1, text2);
            }
            case 6: {
                return this.doInv(text1, text2);
            }
            case 7: {
                tookTurn = this.doKill(text1, text2);
                break;
            }
            case 9: {
                return this.doLog(text1, text2);
            }
            case 8: {
                tookTurn = this.doLook(text1, text2);
                break;
            }
            case 10: {
                tookTurn = this.doOpen(10, text1, text2);
                break;
            }
            case 11: {
                tookTurn = this.doPut(text1, text2);
                break;
            }
            case 12: {
                return this.doQuit(text1, text2);
            }
            case 13: {
                tookTurn = this.doReady(text1, text2);
                break;
            }
            case 14: {
                return this.doRestart(text1, text2);
            }
            case 15: {
                return this.doRestore(text1, text2);
            }
            case 16: {
                return this.doSave(text1, text2);
            }
            case 17: {
                return this.doScore(text1, text2);
            }
            case 18: {
                tookTurn = this.doTake(text1, text2);
                break;
            }
            case 19: {
                tookTurn = this.doUse("Use", text1, "Use on", text2);
                break;
            }
            case 20: {
                return this.doVersion(text1, text2);
            }
            case 21: {
                tookTurn = this.doWait(text1, text2);
                break;
            }
            case 22: {
                tookTurn = this.doGive(text1, text2);
                break;
            }
            case 23: {
                tookTurn = this.doAsk(text2, text1);
                break;
            }
            default: {
                throw new IllegalStateException("Unimplemented command " + line);
            }
        }
        if (!tookTurn) {
            return false;
        }
        this.nextTurn();
        return true;
    }

    public boolean doAsk(String text1, String text2) {
        if (text1.length() == 0) {
            this.printlnRaw("Ask what?");
            return false;
        }
        if (text2.length() == 0) {
            this.printlnRaw(Global.join("Ask '", text1, "' of whom?"));
            return false;
        }
        Thing th = this.findContentsPlayer("Ask whom?", text1);
        if (th == null) {
            return false;
        }
        if (!(th instanceof Actor)) {
            this.printlnRaw(Global.join(th.theName(), " does not respond."));
            return false;
        }
        Actor target = (Actor)th;
        this.vars_.set("_arg1", target.id());
        this.vars_.set("_name1", target.getName());
        if (this.commandIntercept()) {
            return false;
        }
        CmdAsk ask = target.findAsk(text2);
        if (ask != null) {
            ask.doEval(this, target);
            return true;
        }
        this.printlnRaw(Global.join(target.theName(), " does not respond."));
        return true;
    }

    public boolean doDrop(String text1, String text2) {
        int rc;
        if (text1.length() == 0) {
            this.printlnRaw("Drop what?");
            return false;
        }
        if (text2.length() > 0) {
            this.printlnRaw("You can only drop one thing at a time.");
            return false;
        }
        Thing th = this.findContents(this.getPlayer(), "Drop what?", text1);
        if (th == null) {
            return false;
        }
        if (!(th instanceof Item)) {
            this.printlnRaw("You can't drop that!");
            return false;
        }
        Item it = (Item)th;
        this.vars_.set("_arg1", it.id());
        this.vars_.set("_name1", it.getName());
        if (this.commandIntercept()) {
            return false;
        }
        if (it.getDrop() != null && (rc = it.getDrop().doEval(this, it)) == 2) {
            return true;
        }
        it.moveto(this.getPlayerRoom());
        this.printlnRaw("Dropped.");
        return true;
    }

    public boolean doGive(String text1, String text2) {
        int rc;
        if (text1.length() == 0) {
            this.printlnRaw("Give what?");
            return false;
        }
        if (text2.length() == 0) {
            this.printlnRaw(Global.join("Give '", text1, "' to whom?"));
            return false;
        }
        Thing th = this.findContents(this.getPlayer(), "Give what?", text1);
        if (th == null) {
            return false;
        }
        if (!(th instanceof Item)) {
            this.printlnRaw("You can't give that to anyone!");
            return false;
        }
        Item it = (Item)th;
        this.vars_.set("_arg1", it.id());
        this.vars_.set("_name1", it.getName());
        th = this.findContentsPlayer("Give to whom?", text2);
        if (th == null) {
            return false;
        }
        if (!(th instanceof Actor)) {
            this.printlnRaw(Global.join("You can't give anything to ", th.theName(), "."));
            return false;
        }
        Actor target = (Actor)th;
        if (target.weighContents() + it.weighTotal() > 1000) {
            this.printlnRaw(Global.join(target.theName(), " can't carry any more."));
            return false;
        }
        this.vars_.set("_arg2", target.id());
        this.vars_.set("_name2", target.getName());
        if (this.commandIntercept()) {
            return false;
        }
        if (it.getPut() != null && (rc = it.getPut().doEval(this, it)) == 2) {
            return true;
        }
        if (target.getGive() != null && (rc = target.getGive().doEval(this, target)) == 2) {
            return true;
        }
        it.moveto(target);
        this.printlnRaw(Global.join(new String[]{target.theName(), " takes ", it.theName(), "."}));
        return true;
    }

    public boolean doGo(String text1, String text2) {
        String destid;
        int dir;
        if (text2.length() > 0) {
            this.printlnRaw(Global.join("(ignoring '", text2, "')"));
        }
        if ((dir = Global.getDir(text1)) < 0) {
            this.printlnRaw(Global.join("You don't know how to go ", text1, "."));
            return false;
        }
        String dirabbv = Global.DIR_ABBV[dir];
        this.vars_.set("_arg1", dirabbv);
        this.vars_.set("_name1", Global.DIR_NAME[dir]);
        Room room = this.getPlayerRoom();
        if (room == null) {
            this.printlnRaw("You can't go anywhere from nowhere.");
            return false;
        }
        CmdRoomExit cmdExit = room.getExit(dir);
        Room dest = null;
        if (cmdExit != null && (destid = cmdExit.getRoom()) != null && (dest = (Room)this.getStuff(destid)) == null) {
            throw new IllegalArgumentException("Unknown room '" + destid + "': " + cmdExit);
        }
        if (!(room.getGrue() <= 0 || room.containsLight() || dest != null && dest.containsLight())) {
            if (this.grue_ != null) {
                this.vars_.set("_grue", room.getGrue());
                int rc = this.grue_.doEval(this, room);
                if (rc == 2) {
                    return false;
                }
            } else {
                int roll = this.d(100);
                if (this.getDebug()) {
                    System.err.println("grue " + room.getGrue() + "%: " + roll);
                }
                if (roll <= room.getGrue()) {
                    this.printlnRaw("You are set upon by dozens of hungry grues and devoured!");
                    this.die();
                    return false;
                }
                this.printlnRaw("You feel something hairy and loathesome brush against your legs!");
            }
        }
        if (cmdExit != null) {
            int len = room.countContents();
            for (int i = 0; i < len; ++i) {
                int rc;
                Actor act;
                CmdGuard cmd;
                Thing th = room.findContents(i);
                if (!(th instanceof Actor) || (cmd = (act = (Actor)th).getGuard(dirabbv)) == null || (rc = cmd.doEval(this, act)) != 2) continue;
                return true;
            }
            int rc = cmdExit.doEval(this, room);
            if (rc == 2) {
                return true;
            }
            if (dest != null) {
                this.plMove(dest);
            }
            return true;
        }
        this.printlnRaw(Global.join("You can't go ", Global.DIR_NAME[dir], "."));
        this.commandIntercept();
        return false;
    }

    public boolean doHelp(String text1, String text2) {
        this.ignoring(text1, text2);
        int opt;
        while ((opt = this.menu("Help Subject:", HELPMENU, true)) >= 0) {
            String filename;
            switch (opt) {
                case 0: {
                    filename = "help/commands.hlp";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown help option " + opt);
                }
            }
            this.printlnRaw(FileUtil.readFileString(filename));
        }
        return false;
    }

    public boolean doHint(String text1, String text2) {
        this.ignoring(text1, text2);
        Room room = this.getPlayerRoom();
        if (room == null) {
            this.printlnRaw("There are no hints for nowhere.");
            return false;
        }
        int nhints = room.countHints();
        if (nhints == 0) {
            this.printlnRaw("There are no hints for this room.");
            return false;
        }
        int hint = room.getHintRequests();
        Command cmd = room.getHint(hint % nhints);
        cmd.doEval(this, room);
        room.setHintRequests(hint + 1);
        ++this.hints_;
        return false;
    }

    public boolean doInv(String text1, String text2) {
        String s;
        int plMaxHits;
        int rc;
        this.ignoring(text1, text2);
        Player pl = this.getPlayer();
        if (pl.getInv() != null && (rc = pl.getInv().doEval(this, pl)) == 2) {
            return false;
        }
        int plHits = pl.getHits();
        if (plHits != (plMaxHits = pl.getMaxHits())) {
            this.printlnRaw(Global.join(new String[]{"You have ", this.num(plHits, "hit point"), " out of ", String.valueOf(plMaxHits), "."}));
        }
        if ((s = pl.listContents("You are carrying: ", true)) == null) {
            s = "You are not carrying anything.";
        }
        this.printlnRaw(s);
        return false;
    }

    public boolean doKill(String targetname, String itemname) {
        Usable it;
        if (itemname.length() == 0) {
            this.printlnRaw("With what?");
            return false;
        }
        Thing th = this.findContentsPlayer("With what?", itemname);
        if (th == null) {
            return false;
        }
        if (!(th instanceof Item) || ((Item)th).getUse() == null) {
            this.printlnRaw(Global.join("You can't attack with ", th.theName(), "."));
            return false;
        }
        if (th instanceof Item && ((Item)(it = (Item)th)).getReadyType() != null && !((Item)it).getIsReady()) {
            this.printlnRaw(Global.join("You must ready ", th.theName(), " before you can attack with it."));
            return false;
        }
        it = (Usable)th;
        this.vars_.set("_arg1", it.id());
        this.vars_.set("_name1", it.getName());
        Thing target = this.findContentsPlayer("Kill what?", targetname);
        if (target == null) {
            return false;
        }
        if (!(target instanceof Actor)) {
            this.printlnRaw(Global.join("You cannot attack ", target.aName(), "."));
            return false;
        }
        this.vars_.set("_arg2", target.id());
        this.vars_.set("_name2", target.getName());
        if (this.commandIntercept()) {
            return false;
        }
        it.getUse().doEval(this, it);
        return true;
    }

    public boolean doLog(String text1, String text2) {
        if (this.env_.isLogging()) {
            this.ignoring(text1, text2);
            this.env_.loggerStop();
            this.printlnRaw("Logging ended.");
        } else {
            this.ignoring(text2, null);
            String filename = text1.length() == 0 ? "default.log" : text1;
            this.printlnRaw(Global.join("Logging to ", filename, "."));
            this.env_.loggerStart(filename);
        }
        return false;
    }

    public boolean doLook(String text1, String text2) {
        this.ignoring(text2, null);
        if (text1.length() > 0) {
            return this.doLookItem(text1);
        }
        return this.doLookRoom();
    }

    public boolean doLookItem(String text1) {
        boolean light;
        Room room = this.getPlayerRoom();
        if (this.getDebug()) {
            System.err.println("room=" + room);
        }
        boolean bl = light = room == null ? false : room.containsLight();
        if (this.getDebug()) {
            System.err.println("light=" + light);
        }
        if (!light) {
            this.printlnRaw("It's too dark to see.");
            return false;
        }
        Thing th = this.findContentsPlayer("Look at what?", text1);
        if (th == null) {
            return false;
        }
        this.vars_.set("_arg1", th.id());
        this.vars_.set("_name1", th.getName());
        boolean nothing = true;
        if (th.getLook() != null) {
            nothing = false;
            int rc = th.getLook().doEval(this, th);
            if (rc == 2) {
                return false;
            }
        }
        if (th instanceof Item) {
            Item it = (Item)th;
            if (it.getCloseable() && it.getClosed()) {
                if (nothing) {
                    nothing = false;
                    this.printlnRaw(Global.join(it.theName(), " is closed."));
                } else {
                    this.printlnRaw("It is closed.");
                }
            }
            if (it.getCapacity() > 0 && !it.getClosed()) {
                String s;
                if (nothing) {
                    nothing = false;
                    s = it.listContents(Global.join(it.theName(), " contains: "));
                    if (s == null) {
                        s = Global.join(it.theName(), " is empty.");
                    }
                } else {
                    s = it.listContents("It contains: ");
                    if (s == null) {
                        s = "It is empty.";
                    }
                }
                this.printlnRaw(s);
            }
        }
        if (nothing) {
            this.printlnRaw(Global.join("You see nothing unusual about ", th.theName(), "."));
        }
        return false;
    }

    public boolean doLookRoom() {
        Room room = this.getPlayerRoom();
        if (this.getDebug()) {
            System.err.println("room=" + room);
        }
        if (room == null) {
            this.printlnRaw("You're floatin' in th' void.");
            return false;
        }
        boolean light = room.containsLight();
        if (this.getDebug()) {
            System.err.println("light=" + light);
        }
        if (light) {
            String s;
            boolean nothing = true;
            Command cmdLook = room.getLook();
            if (cmdLook != null) {
                nothing = false;
                cmdLook.doEval(this, room);
            }
            if ((s = room.listContents("You see here: ")) != null) {
                this.printlnRaw(s);
                nothing = false;
            }
            if (nothing) {
                this.printlnRaw("You see nothing unusual here.");
            }
        } else {
            Command cmdDark = room.getDark();
            if (cmdDark != null) {
                cmdDark.doEval(this, room);
            } else {
                this.printlnRaw("It is dark.");
            }
        }
        return false;
    }

    public boolean doOpen(int cmd, String text1, String text2) {
        int rc;
        boolean close;
        String verbed;
        String verb;
        if (cmd == 1) {
            verb = "close";
            verbed = "closed";
            close = true;
        } else {
            verb = "open";
            verbed = "opened";
            close = false;
        }
        if (text1.length() == 0) {
            this.printlnRaw(Global.join(verb, " what?"));
            return false;
        }
        if (text2.length() > 0) {
            this.printlnRaw(Global.join("You can only ", verb, " one thing at a time."));
            return false;
        }
        Thing th = this.findContentsPlayer(Global.join(verb, " what?"), text1);
        if (th == null) {
            return false;
        }
        if (!(th instanceof Item)) {
            this.printlnRaw(Global.join(new String[]{"You can't ", verb, " ", th.theName(), "."}));
            return false;
        }
        Item it = (Item)th;
        if (!it.getCloseable()) {
            this.printlnRaw(Global.join(new String[]{"You can't ", verb, " ", th.theName(), "."}));
            return false;
        }
        if (it.getClosed() == close) {
            this.printlnRaw(Global.join(new String[]{th.theName(), " is already ", verbed, "."}));
            return false;
        }
        this.vars_.set("_arg1", it.id());
        this.vars_.set("_name1", it.getName());
        if (this.commandIntercept()) {
            return false;
        }
        Command intercept = close ? it.getClose() : it.getOpen();
        if (intercept != null && (rc = intercept.doEval(this, it)) == 2) {
            return true;
        }
        it.setClosed(close);
        this.printlnRaw(Global.join(verbed, "."));
        if (!close) {
            String s = it.listContents(Global.join(it.theName(), " contains: "));
            if (s == null) {
                s = Global.join(it.theName(), " is empty.");
            }
            this.printlnRaw(s);
        }
        return true;
    }

    public boolean doPut(String text1, String text2) {
        int rc;
        if (text1.length() == 0) {
            this.printlnRaw("Put what?");
            return false;
        }
        if (text2.length() == 0) {
            this.printlnRaw("Put into what?");
            return false;
        }
        Thing th = this.findContents(this.getPlayer(), "Put what?", text1);
        if (th == null) {
            return false;
        }
        if (!(th instanceof Item)) {
            this.printlnRaw("You can't put that anywhere!");
            return false;
        }
        Item it = (Item)th;
        this.vars_.set("_arg1", it.id());
        this.vars_.set("_name1", it.getName());
        th = this.findContentsPlayer("Put into what?", text2);
        if (th == null) {
            return false;
        }
        if (!(th instanceof Item)) {
            this.printlnRaw(Global.join("You can't put anything in ", th.theName(), "."));
            return false;
        }
        Item cont = (Item)th;
        if (cont.getCapacity() == 0) {
            this.printlnRaw(Global.join("You can't put anything in ", cont.theName(), "."));
            return false;
        }
        if (cont.getClosed()) {
            this.printlnRaw(Global.join("You can't put anything in ", cont.theName(), ", it's closed."));
            return false;
        }
        if (cont.weighContents() + it.weighTotal() > cont.getCapacity()) {
            this.printlnRaw(Global.join("You can't fit that in ", cont.theName(), "."));
            return false;
        }
        this.vars_.set("_arg2", cont.id());
        this.vars_.set("_name2", cont.getName());
        if (this.commandIntercept()) {
            return false;
        }
        if (it.getPut() != null && (rc = it.getPut().doEval(this, it)) == 2) {
            return true;
        }
        it.moveto(cont);
        this.printlnRaw("Done.");
        return true;
    }

    public boolean doQuit(String text1, String text2) {
        this.ignoring(text1, text2);
        if (this.yesno("Are you sure you want to quit?")) {
            this.printlnRaw("* * *  YOU HAVE QUIT  * * *");
            this.quit();
        }
        return false;
    }

    public boolean doReady(String text1, String text2) {
        if (text1.length() == 0) {
            this.printlnRaw("Ready what?");
            return false;
        }
        if (text2.length() > 0) {
            this.printlnRaw("You can only ready one thing at a time.");
            return false;
        }
        Player pl = this.getPlayer();
        Thing th = this.findContents(pl, "Ready what?", text1);
        if (th == null) {
            return false;
        }
        if (!(th instanceof Item)) {
            this.printlnRaw("You can't ready that!");
            return false;
        }
        if (!th.loc().equals(pl.id())) {
            this.printlnRaw("You must take it out first.");
            return false;
        }
        Item it = (Item)th;
        if (it.getReady() == null) {
            this.printlnRaw("You can't ready that!");
            return false;
        }
        this.vars_.set("_arg1", it.id());
        this.vars_.set("_name1", it.getName());
        if (this.commandIntercept()) {
            return false;
        }
        if (it.getIsReady()) {
            int rc;
            if (it.getRemove() != null && (rc = it.getRemove().doEval(this, it)) == 2) {
                return true;
            }
            it.setIsReady(false);
            this.printlnRaw("Removed.");
        } else {
            Item olditem = pl.findEquipped(it.getReadyType());
            if (olditem != null) {
                this.printlnRaw(Global.join("You already have ", olditem.aName(), " ready."));
                return false;
            }
            int rc = pl.doReady(it);
            if (rc == 3) {
                this.printlnRaw("You can't ready that.");
                return false;
            }
            if (rc == 2) {
                return true;
            }
            this.printlnRaw("Readied.");
        }
        return true;
    }

    public boolean doRestart(String text1, String text2) {
        this.ignoring(text1, text2);
        this.reset();
        this.env_.loadGame(this.env_.getFilename());
        return false;
    }

    public boolean doRestore(String text1, String text2) {
        this.ignoring(text2, null);
        String filename = text1.length() == 0 ? "default.sav" : text1;
        this.env_.restore(filename);
        return false;
    }

    public boolean doSave(String text1, String text2) {
        this.ignoring(text2, null);
        String filename = text1.length() == 0 ? "default.sav" : text1;
        this.env_.save(filename);
        return false;
    }

    public boolean doScore(String text1, String text2) {
        int rc;
        this.ignoring(text1, text2);
        boolean builtin = true;
        Player pl = this.getPlayer();
        if (pl.getScore() != null && (rc = pl.getScore().doEval(this, pl)) == 2) {
            builtin = false;
        }
        if (builtin) {
            int score = this.vars_.getInt("score");
            int maxscore = this.vars_.getInt("_maxscore");
            if (maxscore == 0) {
                this.printlnRaw(Global.join(new String[]{"Your score is ", String.valueOf(score), ", in ", this.num(this.turn_, "turn"), "."}));
            } else {
                this.printlnRaw(Global.join(new String[]{"Your score is ", String.valueOf(score), " out of a possible ", String.valueOf(maxscore), ", in ", this.num(this.turn_, "turn"), "."}));
            }
        }
        if (this.hints_ > 0) {
            this.printlnRaw(Global.join("You asked for ", this.num(this.hints_, "hint"), "."));
        }
        return false;
    }

    public boolean doTake(String text1, String text2) {
        int rc;
        if (text1.length() == 0) {
            this.printlnRaw("Take what?");
            return false;
        }
        if (text2.length() > 0) {
            this.printlnRaw("You can only take one thing at a time.");
            return false;
        }
        Thing th = this.findContents(this.getPlayerRoom(), "Take what?", text1);
        if (th == null) {
            return false;
        }
        if (!(th instanceof Item)) {
            this.printlnRaw(Global.join("You can't take ", th.theName(), "."));
            return false;
        }
        Item it = (Item)th;
        this.vars_.set("_arg1", it.id());
        this.vars_.set("_name1", it.getName());
        if (this.commandIntercept()) {
            return false;
        }
        if (it.getTake() != null && (rc = it.getTake().doEval(this, it)) == 2) {
            return true;
        }
        Player pl = this.getPlayer();
        if (it.weighTotal() + pl.weighContents() > 1000) {
            this.printlnRaw(Global.join("You can't take ", it.theName(), "."));
            return true;
        }
        it.moveto(pl);
        this.printlnRaw("Taken.");
        return true;
    }

    public boolean doUse(String verb1, String text1, String verb2, String text2) {
        Usable it;
        if (text1.length() == 0) {
            this.printlnRaw(Global.join(verb1, " what?"));
            return false;
        }
        Thing th = this.findContentsPlayer(verb1 + " what?", text1);
        if (th == null) {
            return false;
        }
        if (!(th instanceof Usable) || ((Usable)th).getUse() == null) {
            this.printlnRaw(Global.join(new String[]{"You can't ", verb1, " ", th.theName(), " for anything."}));
            return false;
        }
        if (th instanceof Item && ((Item)(it = (Item)th)).getReadyType() != null && !((Item)it).getIsReady()) {
            this.printlnRaw(Global.join("You must ready ", th.theName(), " before you can use it."));
            return false;
        }
        it = (Usable)th;
        this.vars_.set("_arg1", it.id());
        this.vars_.set("_name1", it.getName());
        if (text2.length() == 0) {
            Object target = null;
        } else {
            Thing target = this.findContentsPlayer(Global.join(verb2, " what?"), text2);
            if (target == null) {
                return false;
            }
            this.vars_.set("_arg2", target.id());
            this.vars_.set("_name2", target.getName());
        }
        if (this.commandIntercept()) {
            return false;
        }
        it.getUse().doEval(this, it);
        return true;
    }

    public boolean doVersion(String text1, String text2) {
        this.ignoring(text1, text2);
        this.printlnRaw("Aiee! v0.2");
        this.printlnRaw("Copyright 2003 by Mark Hughes <kamikaze@kuoi.asui.uidaho.edu>");
        this.printlnRaw("");
        return false;
    }

    public boolean doWait(String text1, String text2) {
        this.ignoring(text1, text2);
        return true;
    }

    private boolean doFIXME(String line) {
        this.printlnRaw(Global.join("FIXME: unimplemented command ", line));
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("Adventure: start=").append(this.start_);
        sb.append(" maxscore=").append(this.vars_.getInt("_maxscore")).append('\n');
        Iterator it = this.stuff_.keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            Stuff st = (Stuff)this.stuff_.get(id);
            sb.append(st).append('\n');
        }
        return sb.substring(0);
    }

    static {
        COMMANDS.put("a", Global.makeInt(0));
        COMMANDS.put("ask", Global.makeInt(0));
        COMMANDS.put("c", Global.makeInt(1));
        COMMANDS.put("close", Global.makeInt(1));
        COMMANDS.put("d", Global.makeInt(2));
        COMMANDS.put("down", Global.makeInt(3));
        COMMANDS.put("drop", Global.makeInt(2));
        COMMANDS.put("e", Global.makeInt(3));
        COMMANDS.put("east", Global.makeInt(3));
        COMMANDS.put("help", Global.makeInt(5));
        COMMANDS.put("hint", Global.makeInt(4));
        COMMANDS.put("i", Global.makeInt(6));
        COMMANDS.put("inv", Global.makeInt(6));
        COMMANDS.put("k", Global.makeInt(7));
        COMMANDS.put("kill", Global.makeInt(7));
        COMMANDS.put("l", Global.makeInt(8));
        COMMANDS.put("log", Global.makeInt(9));
        COMMANDS.put("look", Global.makeInt(8));
        COMMANDS.put("n", Global.makeInt(3));
        COMMANDS.put("ne", Global.makeInt(3));
        COMMANDS.put("north", Global.makeInt(3));
        COMMANDS.put("northeast", Global.makeInt(3));
        COMMANDS.put("northwest", Global.makeInt(3));
        COMMANDS.put("nw", Global.makeInt(3));
        COMMANDS.put("o", Global.makeInt(10));
        COMMANDS.put("open", Global.makeInt(10));
        COMMANDS.put("p", Global.makeInt(11));
        COMMANDS.put("put", Global.makeInt(11));
        COMMANDS.put("quit", Global.makeInt(12));
        COMMANDS.put("r", Global.makeInt(13));
        COMMANDS.put("ready", Global.makeInt(13));
        COMMANDS.put("remove", Global.makeInt(13));
        COMMANDS.put("restart", Global.makeInt(14));
        COMMANDS.put("restore", Global.makeInt(15));
        COMMANDS.put("s", Global.makeInt(3));
        COMMANDS.put("save", Global.makeInt(16));
        COMMANDS.put("score", Global.makeInt(17));
        COMMANDS.put("se", Global.makeInt(3));
        COMMANDS.put("south", Global.makeInt(3));
        COMMANDS.put("southeast", Global.makeInt(3));
        COMMANDS.put("southwest", Global.makeInt(3));
        COMMANDS.put("sw", Global.makeInt(3));
        COMMANDS.put("t", Global.makeInt(18));
        COMMANDS.put("take", Global.makeInt(18));
        COMMANDS.put("u", Global.makeInt(19));
        COMMANDS.put("up", Global.makeInt(3));
        COMMANDS.put("use", Global.makeInt(19));
        COMMANDS.put("version", Global.makeInt(20));
        COMMANDS.put("w", Global.makeInt(3));
        COMMANDS.put("wait", Global.makeInt(21));
        COMMANDS.put("west", Global.makeInt(3));
        COMMANDS.put("z", Global.makeInt(21));
        COMMANDS.put("g", Global.makeInt(22));
        COMMANDS.put("give", Global.makeInt(22));
        COMMANDS.put("say", Global.makeInt(23));
        PREPOSITIONS = new HashMap();
        PREPOSITIONS.put("in", Boolean.TRUE);
        PREPOSITIONS.put("on", Boolean.TRUE);
        PREPOSITIONS.put("to", Boolean.TRUE);
        PREPOSITIONS.put("about", Boolean.TRUE);
        PREPOSITIONS.put("with", Boolean.TRUE);
        HELPMENU = new String[]{"Commands"};
    }
}

