/*
 * Decompiled with CFR 0.152.
 */
package mdh.aiee;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import mdh.aiee.Aiee;
import mdh.aiee.Global;

public class AieeSwing
extends Aiee
implements ActionListener {
    private static final Color TEXT_BGCOLOR = new Color(0xEEEEEE);
    private static final Color TEXT_FGCOLOR = Color.black;
    private JFrame frame_;
    private JLabel display_;
    private JTextArea output_;
    private JScrollPane outputScroll_;
    private int outputLines_;
    private JTextField input_;
    private Vector inputQueue_ = new Vector(8);
    private HashMap audioCache_ = new HashMap();
    private HashMap imageCache_ = new HashMap();

    public void initDisplay() {
        this.frame_ = new JFrame("Aiee! v0.2");
        this.frame_.setDefaultCloseOperation(3);
        JPanel cont = (JPanel)this.frame_.getContentPane();
        this.display_ = new JLabel(new ImageIcon("images/aiee.png"));
        this.display_.setHorizontalAlignment(0);
        cont.add((Component)this.display_, "North");
        this.output_ = new JTextArea(this.getRows(), this.getColumns());
        this.output_.setEditable(false);
        this.output_.setBackground(TEXT_BGCOLOR);
        this.output_.setForeground(TEXT_FGCOLOR);
        this.output_.setFont(new Font("Monospaced", 0, 12));
        this.outputScroll_ = new JScrollPane(this.output_, 22, 31);
        cont.add((Component)this.outputScroll_, "Center");
        this.input_ = new JTextField(this.getColumns());
        this.input_.setFont(new Font("Monospaced", 0, 12));
        this.input_.addActionListener(this);
        cont.add((Component)this.input_, "South");
        this.frame_.pack();
        this.frame_.show();
        this.input_.requestFocus();
        super.initDisplay();
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() != this.input_) {
            throw new IllegalStateException("Unknown action event " + ae.getActionCommand());
        }
        String s = this.input_.getText();
        this.input_.setText("");
        this.inputQueue_.add(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String input(String prompt) {
        this.output_.append(prompt);
        this.scrollDown();
        String line = null;
        while (true) {
            Vector vector = this.inputQueue_;
            synchronized (vector) {
                int len = this.inputQueue_.size();
                if (len > 0) {
                    line = (String)this.inputQueue_.remove(len - 1);
                }
            }
            if (line != null) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                System.err.println(e + " in AieeSwing.input()");
                line = null;
                break;
            }
        }
        this.outputLines_ = 0;
        if (line != null) {
            this.log(Global.join(prompt, line));
            this.println(line);
            this.outputLines_ = 0;
        }
        return line;
    }

    public Icon loadImage(String src) {
        if (src == null) {
            return null;
        }
        Icon icon = (Icon)this.imageCache_.get(src);
        if (icon == null) {
            icon = new ImageIcon(src);
            this.imageCache_.put(src, icon);
        }
        return icon;
    }

    public AudioClip loadSound(String src) {
        if (!(src.endsWith(".wav") || src.endsWith(".au") || src.endsWith(".mid"))) {
            this.print("ERROR: Unsupported sound format: " + src + "\n");
            return null;
        }
        AudioClip clip = (AudioClip)this.audioCache_.get(src);
        if (clip == null) {
            try {
                clip = Applet.newAudioClip(new URL("file:" + src));
            }
            catch (MalformedURLException e) {
                this.print("ERROR: Invalid sound filename: " + src + "\n");
                return null;
            }
            this.audioCache_.put(src, clip);
        }
        return clip;
    }

    public void playSound(String src, int control) {
        AudioClip clip = this.loadSound(src);
        if (control == 2) {
            if (clip != null) {
                clip.stop();
            }
        } else if (control == 0) {
            clip.play();
        } else {
            clip.loop();
        }
    }

    public void print(String text) {
        ++this.outputLines_;
        if (this.outputLines_ >= this.getRows() - 1) {
            String oldtext = this.output_.getText();
            this.input("[MORE]");
            this.output_.setText(oldtext);
        }
        this.output_.append(text);
    }

    public void quit() {
        this.setPlaying(false);
        this.title("GAME OVER");
    }

    public void scrollDown() {
        JScrollBar bar = this.outputScroll_.getVerticalScrollBar();
        bar.setValue(bar.getMaximum());
        int len = this.output_.getText().length();
        this.output_.setSelectionStart(len - 1);
        this.output_.setSelectionEnd(len - 1);
        this.output_.repaint();
    }

    public void showImage(String src) {
        Icon icon = this.loadImage(src);
        this.display_.setIcon(icon);
        this.scrollDown();
    }

    public void start() {
        this.inputQueue_.clear();
        this.run();
    }

    public void title(String s) {
        this.frame_.setTitle("Aiee!: " + s);
        s = "\n[" + s + "]";
        this.println(s);
        this.log(s);
    }
}

