/*
 * Decompiled with CFR 0.152.
 */
package mdh.aiee;

import mdh.aiee.Adventure;
import mdh.aiee.Command;
import mdh.aiee.Global;
import mdh.aiee.Stuff;
import mdh.aiee.Thing;

public class CmdSet
extends Command {
    public static final byte SET = 0;
    public static final byte ADD = 1;
    public static final byte SUB = 2;
    public static final byte MUL = 3;
    public static final byte DIV = 4;
    public static final byte MOD = 5;
    public static final byte APP = 6;
    public static final byte PRE = 7;
    public static final byte NAME = 8;
    public static final byte ANAME = 9;
    public static final byte THENAME = 10;
    public static final byte INPUT = 11;
    public static final String[] OP_NAME = new String[]{"=", "+", "-", "*", "/", "%", "app", "pre", "name", "aname", "thename", "input"};
    private String var_;
    private byte op_ = 0;
    private String text_;

    public CmdSet(String var, String op, String text) {
        super("set");
        this.var_ = var;
        this.setOp(op);
        this.text_ = text;
    }

    protected int eval(Adventure adv) {
        String a = adv.getVarString(this.var_);
        String b = adv.replaceAll(this.text_);
        switch (this.op_) {
            case 0: {
                adv.setVarString(this.var_, b);
                break;
            }
            case 1: {
                int anum = this.atoi(a);
                int bnum = this.atoi(b);
                adv.setVarInt(this.var_, anum + bnum);
                break;
            }
            case 2: {
                int anum = this.atoi(a);
                int bnum = this.atoi(b);
                adv.setVarInt(this.var_, anum - bnum);
                break;
            }
            case 3: {
                int anum = this.atoi(a);
                int bnum = this.atoi(b);
                adv.setVarInt(this.var_, anum * bnum);
                break;
            }
            case 4: {
                int anum = this.atoi(a);
                int bnum = this.atoi(b);
                adv.setVarInt(this.var_, anum / bnum);
                break;
            }
            case 5: {
                int anum = this.atoi(a);
                int bnum = this.atoi(b);
                adv.setVarInt(this.var_, anum % bnum);
                break;
            }
            case 6: {
                adv.setVarString(this.var_, Global.join(a, b));
                break;
            }
            case 7: {
                adv.setVarString(this.var_, Global.join(b, a));
                break;
            }
            case 8: {
                Stuff st = adv.getStuff(b);
                adv.setVarString(this.var_, st.getName());
                break;
            }
            case 9: {
                Stuff st = adv.getStuff(b);
                if (st instanceof Thing) {
                    adv.setVarString(this.var_, ((Thing)st).aName());
                    break;
                }
                adv.setVarString(this.var_, st.getName());
                break;
            }
            case 10: {
                Stuff st = adv.getStuff(b);
                if (st instanceof Thing) {
                    adv.setVarString(this.var_, ((Thing)st).theName());
                    break;
                }
                adv.setVarString(this.var_, st.getName());
                break;
            }
            case 11: {
                String s = adv.input(b);
                adv.setVarString(this.var_, s);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operator: " + this.op_ + " in " + this);
            }
        }
        if (adv.getDebug()) {
            System.err.println("set " + this.var_ + "='" + a + "' " + OP_NAME[this.op_] + " '" + b + "'");
        }
        return 0;
    }

    private int atoi(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Not a number: '" + s + "' in " + this);
        }
    }

    public void setOp(String text) {
        this.op_ = (byte)-1;
        for (int i = 0; i < OP_NAME.length; ++i) {
            if (!text.equals(OP_NAME[i])) continue;
            this.op_ = (byte)i;
            break;
        }
        if (this.op_ < 0) {
            throw new IllegalArgumentException("Unknown operator: '" + text + "' in " + this);
        }
    }

    protected void toString2(StringBuffer sb) {
        sb.append(" var=\"").append(this.var_).append('\"');
        if (this.op_ != 0) {
            sb.append(" op=\"").append(OP_NAME[this.op_]).append('\"');
        }
        sb.append('>').append(this.text_);
    }
}

