/*
 * Decompiled with CFR 0.152.
 */
package mdh.aiee;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import mdh.aiee.Actor;
import mdh.aiee.Adventure;
import mdh.aiee.CmdAbort;
import mdh.aiee.CmdAsk;
import mdh.aiee.CmdCall;
import mdh.aiee.CmdContinue;
import mdh.aiee.CmdDamage;
import mdh.aiee.CmdDebug;
import mdh.aiee.CmdDo;
import mdh.aiee.CmdFunction;
import mdh.aiee.CmdGameover;
import mdh.aiee.CmdGuard;
import mdh.aiee.CmdIf;
import mdh.aiee.CmdIfHasitem;
import mdh.aiee.CmdIfHaslight;
import mdh.aiee.CmdIfIstype;
import mdh.aiee.CmdIfTest;
import mdh.aiee.CmdImg;
import mdh.aiee.CmdLight;
import mdh.aiee.CmdMoveto;
import mdh.aiee.CmdOutput;
import mdh.aiee.CmdRandom;
import mdh.aiee.CmdRoomExit;
import mdh.aiee.CmdScore;
import mdh.aiee.CmdSet;
import mdh.aiee.CmdSound;
import mdh.aiee.CmdText;
import mdh.aiee.Command;
import mdh.aiee.Entity;
import mdh.aiee.Global;
import mdh.aiee.Item;
import mdh.aiee.Player;
import mdh.aiee.Room;
import mdh.aiee.Stuff;
import mdh.leastxml.LeastParser;
import mdh.leastxml.XMLException;
import mdh.leastxml.XMLNode;

public class Parser {
    private static final boolean DEBUG = true;
    private File file_;
    private boolean gotAdv_;
    private boolean gotPlayer_;

    public Parser(String filename) throws IOException, XMLException {
        this.file_ = new File(filename).getAbsoluteFile();
        LeastParser parser = new LeastParser();
        XMLNode root = parser.parse(this.file_);
        this.parseRoot(root);
    }

    private void assertEmpty(XMLNode node, Properties props) throws XMLException {
        if (!props.isEmpty()) {
            throw new XMLException("Unknown attributes " + props + " in " + node);
        }
    }

    private boolean getBoolean(XMLNode node, Properties props, String key, String defvalue) throws XMLException {
        String s = props.getProperty(key, defvalue);
        props.remove(key);
        if (s.equals("true") || s.equals("1")) {
            return true;
        }
        if (s.equals("false") || s.equals("0")) {
            return false;
        }
        throw new XMLException("Illegal boolean: '" + s + "' in " + node);
    }

    private String getContents(XMLNode node) throws XMLException {
        StringBuffer sb = new StringBuffer();
        int nodelen = node.size();
        for (int j = 0; j < nodelen; ++j) {
            Object o = node.getChild(j);
            if (o instanceof String) {
                String s = (String)o;
                int slen = s.length();
                if (slen == 0) {
                    sb.append('\n');
                    continue;
                }
                if (s.charAt(slen - 1) == '\n') {
                    sb.append(s.substring(0, slen - 1)).append(' ');
                    continue;
                }
                sb.append(s);
                continue;
            }
            sb.append(o);
        }
        return XMLNode.unescape(sb.toString());
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    private int getInt(XMLNode node, Properties props, String key, String defvalue) throws XMLException {
        try {
            String s = props.getProperty(key, defvalue);
            props.remove(key);
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new XMLException("Illegal value for '" + key + "': " + node);
        }
    }

    private String getString(XMLNode node, Properties props, String key) throws XMLException {
        String value = props.getProperty(key);
        props.remove(key);
        if (value == null) {
            throw new XMLException("Missing property '" + key + "': " + node);
        }
        return value;
    }

    private String getString(XMLNode node, Properties props, String key, String defvalue) throws XMLException {
        String value = props.getProperty(key, defvalue);
        props.remove(key);
        return value;
    }

    private String isID(String s) throws XMLException {
        if (s == null) {
            return null;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '(': 
                case ')': {
                    throw new XMLException("Illegal ID '" + s + "'");
                }
            }
        }
        return s;
    }

    private String isRef(String s) throws XMLException {
        if (s == null) {
            return null;
        }
        int mode = 97;
        int len = s.length();
        block16: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (mode) {
                case 97: {
                    switch (c) {
                        case '\"': 
                        case '\'': 
                        case '(': 
                        case ')': {
                            throw new XMLException("Illegal ID '" + s + "'");
                        }
                        case '$': {
                            mode = 36;
                        }
                    }
                    continue block16;
                }
                case 36: {
                    switch (c) {
                        case '(': {
                            mode = 40;
                            continue block16;
                        }
                    }
                    throw new XMLException("Illegal ID '" + s + "'");
                }
                case 40: {
                    switch (c) {
                        case '\"': 
                        case '$': 
                        case '\'': 
                        case '(': {
                            throw new XMLException("Illegal ID '" + s + "'");
                        }
                        case ')': {
                            mode = 97;
                        }
                    }
                }
            }
        }
        return s;
    }

    private void parseRoot(XMLNode root) throws XMLException {
        int rootlen = root.size();
        if (rootlen == 0) {
            throw new XMLException("Empty document!");
        }
        for (int i = 0; i < rootlen; ++i) {
            Object o = root.getChild(i);
            if (o instanceof XMLNode) {
                if (this.gotAdv_) {
                    throw new XMLException("Multiple root elements!");
                }
                XMLNode node = (XMLNode)o;
                if (node.getName().equals("adventure")) {
                    this.parseAdventure(node);
                    continue;
                }
                throw new XMLException("Illegal element " + node);
            }
            if (((String)o).trim().length() == 0) continue;
            throw new XMLException("Illegal characters " + o);
        }
    }

    private void parseAdventure(XMLNode advnode) throws XMLException {
        Properties props = advnode.parseAttrs();
        String start = this.isID(this.getString(advnode, props, "start"));
        int maxscore = this.getInt(advnode, props, "maxscore", "100");
        this.assertEmpty(advnode, props);
        Adventure adv = Adventure.getAdv();
        adv.setStart(start);
        adv.setMaxscore(maxscore);
        this.gotAdv_ = true;
        int len = advnode.size();
        for (int i = 0; i < len; ++i) {
            Object o = advnode.getChild(i);
            if (o instanceof XMLNode) {
                XMLNode node = (XMLNode)o;
                String tagname = node.getName();
                if (tagname.equals("room")) {
                    this.parseRoom(node);
                    continue;
                }
                if (tagname.equals("item")) {
                    this.parseItem(node);
                    continue;
                }
                if (tagname.equals("actor")) {
                    this.parseActor(node);
                    continue;
                }
                if (tagname.equals("function")) {
                    this.parseFunction(node);
                    continue;
                }
                if (tagname.equals("grue")) {
                    this.parseGrue(node);
                    continue;
                }
                if (tagname.equals("intro")) {
                    this.parseIntro(node);
                    continue;
                }
                if (tagname.equals("player")) {
                    this.parsePlayer(node);
                    continue;
                }
                throw new XMLException("Illegal element " + node);
            }
            if (((String)o).trim().length() == 0) continue;
            throw new XMLException("Illegal characters " + o);
        }
    }

    private void parseActor(XMLNode actornode) throws XMLException {
        Properties props = actornode.parseAttrs();
        String id = this.isID(this.getString(actornode, props, "id"));
        String name = this.getString(actornode, props, "name");
        String locid = this.isID(this.getString(actornode, props, "loc", null));
        String article = this.getString(actornode, props, "article", null);
        String gender = this.getString(actornode, props, "gender", null);
        this.assertEmpty(actornode, props);
        if (Adventure.getAdv().getStuff(id) != null) {
            throw new XMLException("Duplicate id '" + id + "': " + actornode);
        }
        Actor actor = new Actor(id, name);
        actor.setArticle(article);
        actor.setGender(gender);
        int len = actornode.size();
        for (int i = 0; i < len; ++i) {
            Object o = actornode.getChild(i);
            if (o instanceof XMLNode) {
                XMLNode node = (XMLNode)o;
                String tagname = node.getName();
                if (tagname.equals("alias")) {
                    this.parseActorAlias(node, actor);
                    continue;
                }
                if (tagname.equals("ask")) {
                    this.parseActorAsk(node, actor);
                    continue;
                }
                if (tagname.equals("die")) {
                    this.parseEntityDie(node, actor);
                    continue;
                }
                if (tagname.equals("give")) {
                    this.parseActorGive(node, actor);
                    continue;
                }
                if (tagname.equals("look")) {
                    this.parseActorLook(node, actor);
                    continue;
                }
                if (tagname.equals("guard")) {
                    this.parseActorGuard(node, actor);
                    continue;
                }
                if (tagname.equals("hurt")) {
                    this.parseActorHurt(node, actor);
                    continue;
                }
                if (tagname.equals("invisible")) {
                    this.parseActorInvisible(node, actor);
                    continue;
                }
                if (tagname.equals("observe")) {
                    this.parseActorObserve(node, actor);
                    continue;
                }
                if (tagname.equals("turn")) {
                    this.parseActorTurn(node, actor);
                    continue;
                }
                throw new XMLException("Illegal element " + node + " on " + actor);
            }
            if (((String)o).trim().length() == 0) continue;
            throw new XMLException("Illegal characters " + o);
        }
        Adventure.getAdv().addStuff(actor);
        if (locid != null) {
            Stuff loc = Adventure.getAdv().getStuff(locid);
            if (loc == null) {
                throw new XMLException("Undefined loc '" + locid + "': " + actornode);
            }
            actor.moveto(loc);
        }
    }

    private void parseEntityDie(XMLNode node, Entity entity) throws XMLException {
        if (entity.getDie() != null) {
            throw new XMLException("Duplicate die in entity '" + entity.id() + "': " + node);
        }
        Command cmd = new Command("die");
        this.parseRoutine(node, cmd);
        entity.setDie(cmd);
    }

    private void parseActorAlias(XMLNode node, Actor actor) throws XMLException {
        Properties props = node.parseAttrs();
        String name = this.getString(node, props, "name");
        this.assertEmpty(node, props);
        actor.addAlias(name);
    }

    private void parseActorAsk(XMLNode node, Actor actor) throws XMLException {
        Properties props = node.parseAttrs();
        String subject = this.getString(node, props, "subject", null);
        this.assertEmpty(node, props);
        CmdAsk ask = new CmdAsk(subject);
        this.parseRoutine(node, ask);
        actor.addAsk(ask);
    }

    private void parseActorGuard(XMLNode node, Actor actor) throws XMLException {
        Properties props = node.parseAttrs();
        String dir = this.getString(node, props, "dir");
        this.assertEmpty(node, props);
        CmdGuard cmd = new CmdGuard(dir);
        this.parseRoutine(node, cmd);
        actor.setGuard(dir, cmd);
    }

    private void parseActorGive(XMLNode node, Actor actor) throws XMLException {
        if (actor.getGive() != null) {
            throw new XMLException("Duplicate give in actor '" + actor.id() + "': " + node);
        }
        Command cmd = new Command("give");
        this.parseRoutine(node, cmd);
        actor.setGive(cmd);
    }

    private void parseActorHurt(XMLNode node, Actor actor) throws XMLException {
        if (actor.getHurt() != null) {
            throw new XMLException("Duplicate hurt in actor '" + actor.id() + "': " + node);
        }
        Command cmd = new Command("hurt");
        this.parseRoutine(node, cmd);
        actor.setHurt(cmd);
    }

    private void parseActorInvisible(XMLNode node, Actor actor) throws XMLException {
        actor.setVisible(false);
    }

    private void parseActorLook(XMLNode node, Actor actor) throws XMLException {
        if (actor.getLook() != null) {
            throw new XMLException("Duplicate look in actor '" + actor.id() + "': " + node);
        }
        Command cmd = new Command("look");
        this.parseRoutine(node, cmd);
        actor.setLook(cmd);
    }

    private void parseActorObserve(XMLNode node, Actor actor) throws XMLException {
        if (actor.getObserve() != null) {
            throw new XMLException("Duplicate observe in actor '" + actor.id() + "': " + node);
        }
        Command cmd = new Command("observe");
        this.parseRoutine(node, cmd);
        actor.setObserve(cmd);
    }

    private void parseActorTurn(XMLNode node, Actor actor) throws XMLException {
        if (actor.getTurn() != null) {
            throw new XMLException("Duplicate turn in actor '" + actor.id() + "': " + node);
        }
        Command cmd = new Command("turn");
        this.parseRoutine(node, cmd);
        actor.setTurn(cmd);
    }

    private void parseFunction(XMLNode node) throws XMLException {
        Properties props = node.parseAttrs();
        String id = this.isID(this.getString(node, props, "id"));
        if (Adventure.getAdv().getFunction(id) != null) {
            throw new XMLException("Duplicate function: " + node);
        }
        CmdFunction cmd = new CmdFunction(id);
        this.parseRoutine(node, cmd);
        Adventure.getAdv().addFunction(cmd);
    }

    private void parseGrue(XMLNode node) throws XMLException {
        if (Adventure.getAdv().getGrue() != null) {
            throw new XMLException("Duplicate grue: " + node);
        }
        Command cmd = new Command("grue");
        this.parseRoutine(node, cmd);
        Adventure.getAdv().setGrue(cmd);
    }

    private void parseIntro(XMLNode intronode) throws XMLException {
        if (Adventure.getAdv().getIntro() != null) {
            throw new XMLException("Duplicate intro: " + intronode);
        }
        Command cmd = new Command("intro");
        this.parseRoutine(intronode, cmd);
        Adventure.getAdv().setIntro(cmd);
    }

    private void parseItem(XMLNode itemnode) throws XMLException {
        Properties props = itemnode.parseAttrs();
        String id = this.isID(this.getString(itemnode, props, "id"));
        String name = this.getString(itemnode, props, "name");
        String locid = this.isID(this.getString(itemnode, props, "loc", null));
        boolean light = this.getBoolean(itemnode, props, "light", "false");
        String article = this.getString(itemnode, props, "article", null);
        this.assertEmpty(itemnode, props);
        if (Adventure.getAdv().getStuff(id) != null) {
            throw new XMLException("Duplicate id '" + id + "': " + itemnode);
        }
        Item item = new Item(id, name);
        item.setLight(light);
        item.setArticle(article);
        int len = itemnode.size();
        for (int i = 0; i < len; ++i) {
            Object o = itemnode.getChild(i);
            if (o instanceof XMLNode) {
                XMLNode node = (XMLNode)o;
                String tagname = node.getName();
                if (tagname.equals("alias")) {
                    this.parseItemAlias(node, item);
                    continue;
                }
                if (tagname.equals("close")) {
                    this.parseItemClose(node, item);
                    continue;
                }
                if (tagname.equals("container")) {
                    this.parseItemContainer(node, item);
                    continue;
                }
                if (tagname.equals("drop")) {
                    this.parseItemDrop(node, item);
                    continue;
                }
                if (tagname.equals("look")) {
                    this.parseItemLook(node, item);
                    continue;
                }
                if (tagname.equals("invisible")) {
                    this.parseItemInvisible(node, item);
                    continue;
                }
                if (tagname.equals("points")) {
                    this.parseItemPoints(node, item);
                    continue;
                }
                if (tagname.equals("open")) {
                    this.parseItemOpen(node, item);
                    continue;
                }
                if (tagname.equals("put")) {
                    this.parseItemPut(node, item);
                    continue;
                }
                if (tagname.equals("ready")) {
                    this.parseItemReady(node, item);
                    continue;
                }
                if (tagname.equals("remove")) {
                    this.parseItemRemove(node, item);
                    continue;
                }
                if (tagname.equals("take")) {
                    this.parseItemTake(node, item);
                    continue;
                }
                if (tagname.equals("turn")) {
                    this.parseItemTurn(node, item);
                    continue;
                }
                if (tagname.equals("use")) {
                    this.parseItemUse(node, item);
                    continue;
                }
                if (tagname.equals("weight")) {
                    this.parseItemWeight(node, item);
                    continue;
                }
                throw new XMLException("Illegal element " + node + " on " + item);
            }
            if (((String)o).trim().length() == 0) continue;
            throw new XMLException("Illegal characters " + o);
        }
        Adventure.getAdv().addStuff(item);
        if (locid != null) {
            Stuff loc = Adventure.getAdv().getStuff(locid);
            if (loc == null) {
                throw new XMLException("Undefined loc '" + locid + "': " + itemnode);
            }
            item.moveto(loc);
        }
    }

    private void parseItemAlias(XMLNode node, Item item) throws XMLException {
        Properties props = node.parseAttrs();
        String name = this.getString(node, props, "name");
        this.assertEmpty(node, props);
        item.addAlias(name);
    }

    private void parseItemContainer(XMLNode node, Item item) throws XMLException {
        Properties props = node.parseAttrs();
        int capacity = this.getInt(node, props, "capacity", String.valueOf(1000));
        boolean closeable = props.containsKey("closed");
        boolean closed = this.getBoolean(node, props, "closed", "false");
        String locked = this.isID(this.getString(node, props, "locked", null));
        this.assertEmpty(node, props);
        if (capacity < 0 || capacity > 9999) {
            throw new XMLException("Illegal capacity in item " + item.id() + ": " + node);
        }
        item.setCapacity(capacity);
        item.setCloseable(closeable);
        item.setClosed(closed);
        item.setLocked(locked);
    }

    private void parseItemClose(XMLNode node, Item item) throws XMLException {
        if (item.getClose() != null) {
            throw new XMLException("Duplicate close in item '" + item.id() + "': " + node);
        }
        Command cmd = new Command("close");
        this.parseRoutine(node, cmd);
        item.setClose(cmd);
    }

    private void parseItemDrop(XMLNode node, Item item) throws XMLException {
        if (item.getDrop() != null) {
            throw new XMLException("Duplicate drop in item '" + item.id() + "': " + node);
        }
        Command cmd = new Command("drop");
        this.parseRoutine(node, cmd);
        item.setDrop(cmd);
    }

    private void parseItemLook(XMLNode node, Item item) throws XMLException {
        if (item.getLook() != null) {
            throw new XMLException("Duplicate look in item '" + item.id() + "': " + node);
        }
        Command cmd = new Command("look");
        this.parseRoutine(node, cmd);
        item.setLook(cmd);
    }

    private void parseItemInvisible(XMLNode node, Item item) throws XMLException {
        item.setVisible(false);
    }

    private void parseItemOpen(XMLNode node, Item item) throws XMLException {
        if (item.getOpen() != null) {
            throw new XMLException("Duplicate open in item '" + item.id() + "': " + node);
        }
        Command cmd = new Command("open");
        this.parseRoutine(node, cmd);
        item.setOpen(cmd);
    }

    private void parseItemPoints(XMLNode pointsnode, Item item) throws XMLException {
        if (item.getPoints() != 0) {
            throw new XMLException("Duplicate points in item '" + item.id() + "': " + pointsnode);
        }
        Properties props = pointsnode.parseAttrs();
        item.setPoints(this.getInt(pointsnode, props, "value", ""));
        item.setPointsLoc(this.isID(this.getString(pointsnode, props, "loc", "player")));
        this.assertEmpty(pointsnode, props);
    }

    private void parseItemPut(XMLNode node, Item item) throws XMLException {
        if (item.getPut() != null) {
            throw new XMLException("Duplicate put in item '" + item.id() + "': " + node);
        }
        Command cmd = new Command("put");
        this.parseRoutine(node, cmd);
        item.setPut(cmd);
    }

    private void parseItemReady(XMLNode node, Item item) throws XMLException {
        Properties props = node.parseAttrs();
        String type = this.isID(this.getString(node, props, "type"));
        String elements = this.isID(this.getString(node, props, "elements", "p"));
        int len = elements.length();
        for (int i = 0; i < len; ++i) {
            int elem = "paefw".indexOf(elements.charAt(i));
            if (elem >= 0) continue;
            throw new XMLException("Unknown element " + elements.charAt(i) + " in item '" + item.id() + "': " + node);
        }
        int armor = this.getInt(node, props, "armor", "0");
        this.assertEmpty(node, props);
        if (armor < 0) {
            throw new XMLException("Illegal armor in item " + item.id() + ": " + node);
        }
        Command cmd = new Command("ready");
        this.parseRoutine(node, cmd);
        item.setReady(cmd);
        item.setReadyType(type);
        item.setElements(elements);
        item.setArmor(armor);
    }

    private void parseItemRemove(XMLNode node, Item item) throws XMLException {
        if (item.getRemove() != null) {
            throw new XMLException("Duplicate remove in item '" + item.id() + "': " + node);
        }
        Command cmd = new Command("remove");
        this.parseRoutine(node, cmd);
        item.setRemove(cmd);
    }

    private void parseItemTake(XMLNode node, Item item) throws XMLException {
        if (item.getTake() != null) {
            throw new XMLException("Duplicate take in item '" + item.id() + "': " + node);
        }
        Command cmd = new Command("take");
        this.parseRoutine(node, cmd);
        item.setTake(cmd);
    }

    private void parseItemTurn(XMLNode node, Item item) throws XMLException {
        if (item.getTurn() != null) {
            throw new XMLException("Duplicate turn in item '" + item.id() + "': " + node);
        }
        Command cmd = new Command("turn");
        this.parseRoutine(node, cmd);
        item.setTurn(cmd);
    }

    private void parseItemUse(XMLNode node, Item item) throws XMLException {
        if (item.getUse() != null) {
            throw new XMLException("Duplicate use in item '" + item.id() + "': " + node);
        }
        Command cmd = new Command("use");
        this.parseRoutine(node, cmd);
        item.setUse(cmd);
    }

    private void parseItemWeight(XMLNode node, Item item) throws XMLException {
        Properties props = node.parseAttrs();
        int weight = this.getInt(node, props, "value", String.valueOf(100));
        this.assertEmpty(node, props);
        if (weight < 0 || weight > 9999) {
            throw new XMLException("Illegal weight in item " + item.id() + ": " + node);
        }
        item.setWeight(weight);
    }

    private void parsePlayer(XMLNode plnode) throws XMLException {
        if (this.gotPlayer_) {
            throw new XMLException("Duplicate player: " + plnode);
        }
        Player pl = Adventure.getAdv().getPlayer();
        int len = plnode.size();
        for (int i = 0; i < len; ++i) {
            Object o = plnode.getChild(i);
            if (o instanceof XMLNode) {
                XMLNode node = (XMLNode)o;
                String tagname = node.getName();
                if (tagname.equals("command")) {
                    this.parsePlayerCommand(node, pl);
                    continue;
                }
                if (tagname.equals("die")) {
                    this.parseEntityDie(node, pl);
                    continue;
                }
                if (tagname.equals("inv")) {
                    this.parsePlayerInv(node, pl);
                    continue;
                }
                if (tagname.equals("score")) {
                    this.parsePlayerScore(node, pl);
                    continue;
                }
                if (tagname.equals("turn")) {
                    this.parsePlayerTurn(node, pl);
                    continue;
                }
                throw new XMLException("Illegal element " + node);
            }
            if (((String)o).trim().length() == 0) continue;
            throw new XMLException("Illegal characters " + o);
        }
        this.gotPlayer_ = true;
    }

    private void parsePlayerCommand(XMLNode node, Player pl) throws XMLException {
        if (pl.getCommand() != null) {
            throw new XMLException("Duplicate command in player: " + node);
        }
        Command cmd = new Command("command");
        this.parseRoutine(node, cmd);
        pl.setCommand(cmd);
    }

    private void parsePlayerInv(XMLNode node, Player pl) throws XMLException {
        if (pl.getInv() != null) {
            throw new XMLException("Duplicate inv in player: " + node);
        }
        Command cmd = new Command("inv");
        this.parseRoutine(node, cmd);
        pl.setInv(cmd);
    }

    private void parsePlayerScore(XMLNode node, Player pl) throws XMLException {
        if (pl.getScore() != null) {
            throw new XMLException("Duplicate score in player: " + node);
        }
        Command cmd = new Command("score");
        this.parseRoutine(node, cmd);
        pl.setScore(cmd);
    }

    private void parsePlayerTurn(XMLNode node, Player pl) throws XMLException {
        if (pl.getTurn() != null) {
            throw new XMLException("Duplicate turn in player: " + node);
        }
        Command cmd = new Command("turn");
        this.parseRoutine(node, cmd);
        pl.setTurn(cmd);
    }

    private void parseRoom(XMLNode roomnode) throws XMLException {
        Properties props = roomnode.parseAttrs();
        String id = this.isID(this.getString(roomnode, props, "id"));
        String name = this.getString(roomnode, props, "name");
        boolean light = this.getBoolean(roomnode, props, "light", "true");
        int grue = this.getInt(roomnode, props, "grue", "0");
        this.assertEmpty(roomnode, props);
        if (Adventure.getAdv().getStuff(id) != null) {
            throw new XMLException("Duplicate id '" + id + "': " + roomnode);
        }
        Room room = new Room(id, name);
        room.setLight(light);
        room.setGrue(grue);
        int len = roomnode.size();
        for (int i = 0; i < len; ++i) {
            Object o = roomnode.getChild(i);
            if (o instanceof XMLNode) {
                XMLNode node = (XMLNode)o;
                String tagname = node.getName();
                if (tagname.equals("command")) {
                    this.parseRoomCommand(node, room);
                    continue;
                }
                if (tagname.equals("dark")) {
                    this.parseRoomDark(node, room);
                    continue;
                }
                if (tagname.equals("enter")) {
                    this.parseRoomEnter(node, room);
                    continue;
                }
                if (tagname.equals("exit")) {
                    this.parseRoomExit(node, room);
                    continue;
                }
                if (tagname.equals("hint")) {
                    this.parseRoomHint(node, room);
                    continue;
                }
                if (tagname.equals("look")) {
                    this.parseRoomLook(node, room);
                    continue;
                }
                if (tagname.equals("points")) {
                    this.parseRoomPoints(node, room);
                    continue;
                }
                if (tagname.equals("turn")) {
                    this.parseRoomTurn(node, room);
                    continue;
                }
                throw new XMLException("Illegal element " + node);
            }
            if (((String)o).trim().length() == 0) continue;
            throw new XMLException("Illegal characters " + o);
        }
        Adventure.getAdv().addStuff(room);
    }

    private void parseRoomCommand(XMLNode cmdnode, Room room) throws XMLException {
        if (room.getCommand() != null) {
            throw new XMLException("Duplicate command in room '" + room.id() + "': " + cmdnode);
        }
        Command cmd = new Command("command");
        this.parseRoutine(cmdnode, cmd);
        room.setCommand(cmd);
    }

    private void parseRoomDark(XMLNode node, Room room) throws XMLException {
        if (room.getDark() != null) {
            throw new XMLException("Duplicate dark in room '" + room.id() + "': " + node);
        }
        Command cmd = new Command("dark");
        this.parseRoutine(node, cmd);
        room.setDark(cmd);
    }

    private void parseRoomEnter(XMLNode enternode, Room room) throws XMLException {
        if (room.getEnter() != null) {
            throw new XMLException("Duplicate enter in room '" + room.id() + "': " + enternode);
        }
        Command cmd = new Command("enter");
        this.parseRoutine(enternode, cmd);
        room.setEnter(cmd);
    }

    private void parseRoomExit(XMLNode exitnode, Room room) throws XMLException {
        Properties props = exitnode.parseAttrs();
        String dir = this.getString(exitnode, props, "dir");
        int d = Global.getDir(dir);
        if (d < 0) {
            throw new XMLException("Unknown direction " + dir + " in room '" + room.id() + "': " + exitnode);
        }
        boolean visible = this.getBoolean(exitnode, props, "visible", "false");
        String dest = this.isID(this.getString(exitnode, props, "room", null));
        this.assertEmpty(exitnode, props);
        CmdRoomExit cmd = new CmdRoomExit(d, visible, dest);
        this.parseRoutine(exitnode, cmd);
        room.setExit(d, cmd);
    }

    private void parseRoomHint(XMLNode node, Room room) throws XMLException {
        Command cmd = new Command("hint");
        this.parseRoutine(node, cmd);
        room.addHint(cmd);
    }

    private void parseRoomLook(XMLNode looknode, Room room) throws XMLException {
        if (room.getLook() != null) {
            throw new XMLException("Duplicate look in room '" + room.id() + "': " + looknode);
        }
        Command cmd = new Command("look");
        this.parseRoutine(looknode, cmd);
        room.setLook(cmd);
    }

    private void parseRoomPoints(XMLNode pointsnode, Room room) throws XMLException {
        if (room.getPoints() != 0) {
            throw new XMLException("Duplicate points in room '" + room.id() + "': " + pointsnode);
        }
        Properties props = pointsnode.parseAttrs();
        room.setPoints(this.getInt(pointsnode, props, "value", ""));
        this.assertEmpty(pointsnode, props);
    }

    private void parseRoomTurn(XMLNode node, Room room) throws XMLException {
        if (room.getTurn() != null) {
            throw new XMLException("Duplicate turn in room '" + room.id() + "': " + node);
        }
        Command cmd = new Command("turn");
        this.parseRoutine(node, cmd);
        room.setTurn(cmd);
    }

    private void parseRoutine(XMLNode cmdnode, Command cmd) throws XMLException {
        int len = cmdnode.size();
        for (int i = 0; i < len; ++i) {
            Object o = cmdnode.getChild(i);
            if (o instanceof XMLNode) {
                XMLNode node = (XMLNode)o;
                String tagname = node.getName();
                Command child = null;
                if (tagname.equals("abort")) {
                    child = this.parseAbort(node);
                } else if (tagname.equals("call")) {
                    child = this.parseCall(node);
                } else if (tagname.equals("continue")) {
                    child = this.parseContinue(node);
                } else if (tagname.equals("damage")) {
                    child = this.parseDamage(node);
                } else if (tagname.equals("debug")) {
                    child = this.parseDebug(node);
                } else if (tagname.equals("do")) {
                    child = this.parseDo(node);
                } else if (tagname.equals("gameover")) {
                    child = this.parseGameover(node);
                } else if (tagname.equals("if")) {
                    child = this.parseIf(node);
                } else if (tagname.equals("img")) {
                    child = this.parseImg(node);
                } else if (tagname.equals("light")) {
                    child = this.parseLight(node);
                } else if (tagname.equals("moveto")) {
                    child = this.parseMoveto(node);
                } else if (tagname.equals("output")) {
                    child = this.parseOutput(node);
                } else if (tagname.equals("random")) {
                    child = this.parseRandom(node);
                } else if (tagname.equals("score")) {
                    child = this.parseScore(node);
                } else if (tagname.equals("set")) {
                    child = this.parseSet(node);
                } else if (tagname.equals("sound")) {
                    child = this.parseSound(node);
                } else if (tagname.equals("text")) {
                    child = this.parseText(node);
                } else {
                    throw new XMLException("Illegal element " + node);
                }
                if (child == null) continue;
                cmd.addCommand(child);
                continue;
            }
            if (((String)o).trim().length() == 0) continue;
            throw new XMLException("Illegal characters " + o);
        }
    }

    private Command parseAbort(XMLNode node) throws XMLException {
        return new CmdAbort();
    }

    private Command parseCall(XMLNode node) throws XMLException {
        Properties props = node.parseAttrs();
        String id = this.isRef(this.getString(node, props, "function"));
        this.assertEmpty(node, props);
        return new CmdCall(id);
    }

    private Command parseContinue(XMLNode node) throws XMLException {
        return new CmdContinue();
    }

    private Command parseDamage(XMLNode node) throws XMLException {
        Properties props = node.parseAttrs();
        String target = this.isRef(this.getString(node, props, "target", "player"));
        String damage = this.isRef(this.getString(node, props, "value"));
        String element = this.isRef(this.getString(node, props, "element", "p"));
        this.assertEmpty(node, props);
        return new CmdDamage(target, damage, element);
    }

    private Command parseDebug(XMLNode node) throws XMLException {
        Properties props = node.parseAttrs();
        boolean on = this.getBoolean(node, props, "on", null);
        this.assertEmpty(node, props);
        return new CmdDebug(on);
    }

    private Command parseDo(XMLNode node) throws XMLException {
        Properties props = node.parseAttrs();
        boolean silent = this.getBoolean(node, props, "silent", "false");
        this.assertEmpty(node, props);
        String text = this.getContents(node);
        return new CmdDo(silent, text);
    }

    private Command parseGameover(XMLNode node) throws XMLException {
        Properties props = node.parseAttrs();
        boolean die = this.getBoolean(node, props, "die", "false");
        this.assertEmpty(node, props);
        return new CmdGameover(die);
    }

    /*
     * WARNING - void declaration
     */
    private Command parseIf(XMLNode cmdnode) throws XMLException {
        CmdIf ifcmd = new CmdIf();
        int len = cmdnode.size();
        for (int i = 0; i < len; ++i) {
            Object o = cmdnode.getChild(i);
            if (o instanceof XMLNode) {
                void var8_8;
                Command child;
                XMLNode node = (XMLNode)o;
                String tagname = node.getName();
                if (tagname.equals("test")) {
                    child = this.parseIfTest(node, ifcmd);
                } else if (tagname.equals("hasitem")) {
                    child = this.parseIfHasitem(node, ifcmd);
                } else if (tagname.equals("haslight")) {
                    child = this.parseIfHaslight(node, ifcmd);
                } else if (tagname.equals("istype")) {
                    child = this.parseIfIstype(node, ifcmd);
                } else if (tagname.equals("then")) {
                    child = this.parseIfThen(node, ifcmd);
                } else if (tagname.equals("else")) {
                    child = this.parseIfElse(node, ifcmd);
                } else {
                    throw new XMLException("Illegal element " + node);
                }
                ifcmd.addCommand((Command)var8_8);
                continue;
            }
            if (((String)o).trim().length() == 0) continue;
            throw new XMLException("Illegal characters " + o);
        }
        return ifcmd;
    }

    private Command parseIfTest(XMLNode node, CmdIf ifcmd) throws XMLException {
        Properties props = node.parseAttrs();
        String var = this.isRef(this.getString(node, props, "var"));
        String op = this.getString(node, props, "op", "eq");
        String text = this.getContents(node);
        this.assertEmpty(node, props);
        return new CmdIfTest(var, op, text);
    }

    private Command parseIfHasitem(XMLNode node, CmdIf ifcmd) throws XMLException {
        Properties props = node.parseAttrs();
        String owner = this.isRef(this.getString(node, props, "owner", null));
        String item = this.isRef(this.getString(node, props, "item"));
        boolean ready = this.getBoolean(node, props, "ready", "false");
        this.assertEmpty(node, props);
        return new CmdIfHasitem(owner, item, ready);
    }

    private Command parseIfHaslight(XMLNode node, CmdIf ifcmd) throws XMLException {
        Properties props = node.parseAttrs();
        String item = this.isRef(this.getString(node, props, "item", null));
        this.assertEmpty(node, props);
        return new CmdIfHaslight(item);
    }

    private Command parseIfIstype(XMLNode node, CmdIf ifcmd) throws XMLException {
        Properties props = node.parseAttrs();
        String item = this.isRef(this.getString(node, props, "item"));
        String type = this.isID(this.getString(node, props, "type"));
        this.assertEmpty(node, props);
        return new CmdIfIstype(item, type);
    }

    private Command parseIfThen(XMLNode node, CmdIf ifcmd) throws XMLException {
        Command cmd = new Command("then");
        this.parseRoutine(node, cmd);
        return cmd;
    }

    private Command parseIfElse(XMLNode node, CmdIf ifcmd) throws XMLException {
        Command cmd = new Command("else");
        this.parseRoutine(node, cmd);
        return cmd;
    }

    private Command parseImg(XMLNode node) throws XMLException {
        Properties props = node.parseAttrs();
        String src = this.getString(node, props, "src");
        this.assertEmpty(node, props);
        return new CmdImg(src);
    }

    private Command parseLight(XMLNode node) throws XMLException {
        Properties props = node.parseAttrs();
        String item = this.isRef(this.getString(node, props, "item", null));
        boolean light = this.getBoolean(node, props, "on", "true");
        this.assertEmpty(node, props);
        return new CmdLight(light, item);
    }

    private Command parseMoveto(XMLNode node) throws XMLException {
        Properties props = node.parseAttrs();
        String item = this.isRef(this.getString(node, props, "item", null));
        String loc = this.isRef(this.getString(node, props, "loc"));
        this.assertEmpty(node, props);
        return new CmdMoveto(item, loc);
    }

    private Command parseOutput(XMLNode textnode) throws XMLException {
        String text = this.getContents(textnode);
        return new CmdOutput(text);
    }

    private Command parseRandom(XMLNode node) throws XMLException {
        Properties props = node.parseAttrs();
        String var = this.isRef(this.getString(node, props, "var"));
        if (var.startsWith("_")) {
            throw new XMLException("Cannot randomize system var '" + var + "': " + node);
        }
        int n = this.getInt(node, props, "n", "1");
        int range = this.getInt(node, props, "range", "");
        this.assertEmpty(node, props);
        return new CmdRandom(var, n, range);
    }

    private Command parseScore(XMLNode node) throws XMLException {
        Properties props = node.parseAttrs();
        int score = this.getInt(node, props, "value", "");
        this.assertEmpty(node, props);
        return new CmdScore(score);
    }

    private Command parseSet(XMLNode node) throws XMLException {
        Properties props = node.parseAttrs();
        String var = this.isRef(this.getString(node, props, "var"));
        if (var.startsWith("_")) {
            throw new XMLException("Cannot set system var '" + var + "': " + node);
        }
        String op = this.getString(node, props, "op", "=");
        this.assertEmpty(node, props);
        String text = this.getContents(node);
        return new CmdSet(var, op, text);
    }

    private Command parseSound(XMLNode node) throws XMLException {
        Properties props = node.parseAttrs();
        String src = this.getString(node, props, "src");
        String s = this.isID(this.getString(node, props, "control", "play"));
        int control = Global.indexOf(s, CmdSound.CONTROL_NAMES);
        if (control < 0) {
            throw new XMLException("Unknown control '" + s + "': " + node);
        }
        this.assertEmpty(node, props);
        return new CmdSound(src, control);
    }

    private Command parseText(XMLNode textnode) throws XMLException {
        String text = this.getContents(textnode);
        return new CmdText(text);
    }

    private void parseFIXME(XMLNode node) throws XMLException {
        System.err.println("WARNING: Ignoring <" + node.getName() + ">");
    }
}

