/*
 * Decompiled with CFR 0.152.
 */
package mdh.aiee;

import java.util.ArrayList;
import mdh.aiee.CmdRoomExit;
import mdh.aiee.Command;
import mdh.aiee.Global;
import mdh.aiee.Stuff;

public class Room
extends Stuff {
    private boolean visited_;
    private int grue_;
    private ArrayList hints_;
    private int hintRequests_;
    private Command command_;
    private Command dark_;
    private Command enter_;
    private CmdRoomExit[] exit_ = new CmdRoomExit[10];

    public Room(String id, String name) {
        super(id, name);
    }

    public void addHint(Command cmd) {
        if (this.hints_ == null) {
            this.hints_ = new ArrayList(1);
        }
        this.hints_.add(cmd);
    }

    public int countHints() {
        return this.hints_ == null ? 0 : this.hints_.size();
    }

    public Command getCommand() {
        return this.command_;
    }

    public Command getDark() {
        return this.dark_;
    }

    public Command getEnter() {
        return this.enter_;
    }

    public CmdRoomExit getExit(int d) {
        return this.exit_[d];
    }

    public int getGrue() {
        return this.grue_;
    }

    public Command getHint(int i) {
        return (Command)this.hints_.get(i);
    }

    public int getHintRequests() {
        return this.hintRequests_;
    }

    public boolean getVisited() {
        return this.visited_;
    }

    public void setCommand(Command c) {
        this.command_ = c;
    }

    public void setDark(Command d) {
        this.dark_ = d;
    }

    public void setEnter(Command e) {
        this.enter_ = e;
    }

    public void setExit(int d, CmdRoomExit exit) {
        if (this.exit_[d] != null) {
            throw new IllegalStateException("Duplicate exit " + Global.DIR_ABBV[d] + " for " + this);
        }
        this.exit_[d] = exit;
    }

    public void setGrue(int g) {
        this.grue_ = g;
    }

    public void setHintRequests(int h) {
        this.hintRequests_ = h;
    }

    public void setVisited(boolean v) {
        this.visited_ = v;
    }

    protected void toString2(StringBuffer sb) {
        if (this.visited_) {
            sb.append(" visited");
        }
        if (this.grue_ > 0) {
            sb.append(" grue=").append(this.grue_);
        }
        if (this.command_ != null) {
            sb.append('\n').append(this.command_);
        }
        if (this.dark_ != null) {
            sb.append('\n').append(this.dark_);
        }
        if (this.enter_ != null) {
            sb.append('\n').append(this.enter_);
        }
        for (int d = 0; d < 10; ++d) {
            CmdRoomExit e = this.exit_[d];
            if (e == null) continue;
            sb.append('\n').append(e);
        }
        if (this.getPoints() != 0) {
            sb.append("\n<points value=\"").append(this.getPoints()).append("\"/>");
        }
        int len = this.countHints();
        for (int i = 0; i < len; ++i) {
            sb.append(this.getHint(i));
        }
    }
}

