/*
 * Decompiled with CFR 0.152.
 */
package mdh.leastxml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Stack;
import java.util.StringTokenizer;
import mdh.leastxml.XMLException;
import mdh.leastxml.XMLNode;

public class LeastParser {
    private static final boolean DEBUG = false;
    private static final int TEXT = 0;
    private static final int TAG = 1;
    public static final char TOK_START_TAG = '<';
    public static final char TOK_EMPTY_TAG = '/';
    public static final char TOK_END_TAG = '>';
    public static final char TOK_ATTR = '=';
    public static final char TOK_PI = '?';
    public static final char TOK_COMMENT = '!';
    public static final char TOK_NL = '$';
    public static final char TOK_TEXT = '\"';
    public static final String INDENT = "  ";
    private int line_ = 1;

    public static void main(String[] args) throws IOException, XMLException {
        boolean tokenize = false;
        boolean quiet = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-tok")) {
                tokenize = true;
                continue;
            }
            if (args[i].equals("-quiet")) {
                quiet = true;
                continue;
            }
            LeastParser.usage();
        }
        LeastParser parser = new LeastParser();
        XMLNode root = parser.parse(System.in);
        if (tokenize) {
            parser.tokenize(System.out, root);
        } else if (!quiet) {
            System.out.print(root);
            System.out.flush();
        }
    }

    private static void usage() {
        System.err.println("Usage: mdh.leastxml.LeastParser [OPTIONS]\nLeastParser will read an XML document from stdin, and then echo it to stdout.\nThe following options are supported:\n\n-quiet\n    Suppress echo--the document is only parsed to see if it is well-formed.\n-tok\n    Prints out a tokenized form of the document.  This is mostly useful for\n    debugging complex XML documents, but you might also pipe it to Unix shell\n    tools to let them work with your documents.\n\n    The tokenized form is indented to indicate child nodes, with a token type\n    character at the start of the line:\n    <    start tag, followed by tag name\n    /    empty tag, followed by tag name\n    >    end tag, followed by tag name\n    =    attributes for previous tag, followed by key=value\n    \"    text, contains text and ends with \"\n    $    newline\n");
        System.exit(1);
    }

    public XMLNode parse(char[] data) throws XMLException {
        return this.parse(new String(data, 0, data.length));
    }

    public XMLNode parse(char[] data, int offset, int len) throws XMLException {
        return this.parse(new String(data, offset, len));
    }

    public XMLNode parse(BufferedReader in) throws IOException, XMLException {
        String s;
        StringBuffer sb = new StringBuffer(1024);
        while ((s = in.readLine()) != null) {
            sb.append(s).append('\n');
        }
        return this.parse(sb.toString());
    }

    public XMLNode parse(File file) throws IOException, XMLException {
        return this.parse(new BufferedReader(new FileReader(file)));
    }

    public XMLNode parse(InputStream in) throws IOException, XMLException {
        return this.parse(new BufferedReader(new InputStreamReader(in)));
    }

    private int indexOf(String s, char target, int start) {
        int len = s.length();
        for (int i = start; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                ++this.line_;
                continue;
            }
            if (c != target) continue;
            return i;
        }
        return -1;
    }

    private int indexOf(String s, String target, int start) {
        int tarlen = target.length();
        if (tarlen == 0) {
            return -1;
        }
        char t0 = target.charAt(0);
        int len = s.length();
        for (int i = start; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                ++this.line_;
                continue;
            }
            if (c != t0 || !s.regionMatches(i, target, 0, tarlen)) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public XMLNode parse(String dataString) throws XMLException {
        int mode = 0;
        int len = dataString.length();
        int nodeStart = 0;
        Stack<XMLNode> stack = new Stack<XMLNode>();
        stack.push(new XMLNode());
        int i = 0;
        block9: while (i < len) {
            switch (mode) {
                case 0: {
                    i = this.indexOf(dataString, '<', nodeStart);
                    if (i < 0) break block9;
                    this.parseTextNode(stack, dataString, nodeStart, i);
                    mode = 1;
                    nodeStart = i + 1;
                    break;
                }
                case 1: {
                    i = this.indexOf(dataString, '>', nodeStart);
                    if (i < 0) {
                        throw new XMLException("Incomplete node " + dataString.substring(nodeStart, len) + " at line " + this.line_);
                    }
                    String text = dataString.substring(nodeStart, i).trim();
                    if (text.length() == 0) {
                        throw new XMLException("Element with no text at line " + this.line_);
                    }
                    char c0 = text.charAt(0);
                    switch (c0) {
                        case '/': {
                            this.parseCloseTag(stack, text);
                            break;
                        }
                        case '!': {
                            if (!dataString.regionMatches(nodeStart + 1, "--", 0, 2)) break;
                            i = this.indexOf(dataString, "-->", nodeStart);
                            if (i < 0) {
                                throw new XMLException("Incomplete comment " + dataString.substring(nodeStart, len) + " at line " + this.line_);
                            }
                            i += 2;
                            break;
                        }
                        case '?': {
                            break;
                        }
                        default: {
                            this.parseTag(stack, text);
                        }
                    }
                    mode = 0;
                    nodeStart = i + 1;
                }
            }
        }
        if (mode == 1) {
            throw new XMLException("Incomplete node " + dataString.substring(nodeStart, len) + " at line " + this.line_);
        }
        if (nodeStart < len) {
            this.parseTextNode(stack, dataString, nodeStart, len);
        }
        if (stack.size() != 1) {
            throw new XMLException("Unclosed tag <" + ((XMLNode)stack.peek()).getName() + "> at line " + this.line_);
        }
        return (XMLNode)stack.pop();
    }

    private void parseCloseTag(Stack stack, String text) throws XMLException {
        XMLNode node;
        text = text.substring(1);
        Object o = stack.pop();
        if (o instanceof XMLNode && ((node = (XMLNode)o).getName() == null || !node.getName().equals(text))) {
            String s = node.toString();
            if (s.length() > 80) {
                s = s.substring(0, 80) + "...";
            }
            throw new XMLException("Mismatched close tag </" + text + "> at line " + this.line_ + ", start tag is \"" + s + "\"");
        }
    }

    private XMLNode parseTag(Stack stack, String text) throws XMLException {
        String attrs;
        String name;
        int i;
        boolean empty = text.endsWith("/");
        if (empty) {
            text = text.substring(0, text.length() - 1);
        }
        int len = text.length();
        for (i = 0; i < len && text.charAt(i) > ' '; ++i) {
        }
        if (i < len) {
            name = text.substring(0, i).trim();
            attrs = text.substring(i + 1).trim();
            if (attrs.length() == 0) {
                attrs = null;
            }
        } else {
            name = text;
            attrs = null;
        }
        XMLNode elem = new XMLNode(name);
        elem.setAttrs(attrs);
        XMLNode parent = (XMLNode)stack.peek();
        parent.add(elem);
        if (!empty) {
            stack.push(elem);
        }
        return elem;
    }

    private void parseTextNode(Stack stack, String dataString, int nodeStart, int nodeEnd) {
        if (nodeStart == nodeEnd) {
            return;
        }
        String text = dataString.substring(nodeStart, nodeEnd);
        XMLNode parent = (XMLNode)stack.peek();
        StringTokenizer st = new StringTokenizer(text, "\r\n", true);
        boolean nl = false;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.charAt(0) == '\r') {
                nl = true;
                continue;
            }
            if (tok.charAt(0) == '\n') {
                if (nl) {
                    parent.add("\n");
                }
                nl = true;
                continue;
            }
            if (nl) {
                parent.add("\n");
                nl = false;
            }
            parent.add(tok);
        }
        if (nl) {
            parent.add("\n");
        }
    }

    public void tokenize(PrintStream out, XMLNode root) throws XMLException {
        this.tokenize(out, -1, root);
    }

    private void tokenize(PrintStream out, int indent, Object o) throws XMLException {
        String indentText;
        if (indent <= 0) {
            indentText = "";
        } else {
            StringBuffer sb = new StringBuffer(indent * INDENT.length());
            for (int i = 0; i < indent; ++i) {
                sb.append(INDENT);
            }
            indentText = sb.toString();
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.charAt(0) == '\n') {
                out.println(indentText + '$');
            } else {
                out.println(indentText + '\"' + s + '\"');
            }
        } else {
            String name;
            XMLNode node = (XMLNode)o;
            char type = '<';
            int size = node.size();
            if (size == 0) {
                type = '/';
            }
            if ((name = node.getName()) != null) {
                out.println(indentText + type + name);
                String attrs = node.getAttrs();
                if (attrs != null) {
                    out.println(indentText + '=' + attrs);
                }
            }
            int len = size;
            for (int i = 0; i < len; ++i) {
                this.tokenize(out, indent + 1, node.getChild(i));
            }
            if (name != null && size != 0) {
                out.println(indentText + '>' + name);
            }
        }
    }
}

