unit IMFOBJS;

interface

Type
TobjType = (Clss, Room, Door, Obj, Other);
TVerbType= (Verb, Extend);
TActPlace= (last, replace, first);

PinFunct = ^TinFunct;
TinFunct = Record
	Name : Pchar;
	Vars : Pchar;
	Code : TStringList;
	cmt  : TstringList;
end;

PAction = ^Taction;
TAction = Record
	VMod : Pchar;
	Act  : Pchar;
end;

Pgrammar = ^Tgrammar;
TGrammar = Record
	Verb   	: Pchar;
	VerbType: TverbType;
	ActPlace: TactPlace;
	Synonym	: TstringList;
	action 	: Tlist;
end;

PinfObj = ^TinfObj;
TinfObj = Record
	ObjType : TobjType;
	ObjName	: Pchar;
	ShortName: Pchar;
	Belongs_to: Pchar;
	Names	: Pchar;
	ObjCmt  : TstringList;
	Prperty: Tlist;
	Attribute: TstringList

end;

TInfScript = Class(Tobject)
	Title 	 : Pchar;
	Headline : Pchar;
	Debug	 : Boolean;
	switches : Pchar;
	Global	 : TstringList;
	Constant : TstringList;
	Prperty: TstringList;
	Attrib   : TstringList;
	IncParse : TstringList;
	IncVerb  : TstringList;
	IncGrammar: TstringList;
	MainComment : TstringList;
	Objs	 : TStringList;
	Words    : TStringList;
        Constructor Create;
        Procedure Free;
        Destructor Destroy; override;

        Procedure SetTitle(pc : pchar);
        Procedure SetHeadline(pc : pchar);
        Procedure SetSwitches(pc : pchar);
        Procedure SetDebug(b : boolean);

        Function GetTitle: pchar;
        Function GetHeadline: pchar;
        Function GetSwitches: pchar;
        Function GetDebug: boolean;


end;
{-----------------------------------------------------------------}
{-----------------------------------------------------------------}
implementation

Constructor TinfScript.Create
begin
     Global.Create;
     Constant.Create;
     Prperty.Create;
     Attrib.Create;
     IncParse.Create;
     IncVerb.Create;
     IncGrammar.Create;
     MainComment.Create;
     Objs.Create;
     Words.Create;
     DisposeStr(Title);
     DisposeStr(Headline);
     DisposeStr(switches);
end;

Procedure TinfScript.Free;
begin
     if self<>nil then Destroy;
end;

Destructor TinfScript.Destroy;
begin
     Global.Free;
     Constant.Free;
     Prperty.Free;
     Attrib.Free;
     IncParse.Free;
     IncVerb.Free;
     IncGrammar.Free;
     MainComment.Free;
     Objs.Free;
     Words.Free;
end;
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
Procedure Tinfscript.SetTitle(pc : pchar);
begin
     disposeStr(Title);
     newstr(pc^);
end;
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
Procedure Tinfscript.SetHeadline(pc : pchar);
begin
     disposeStr(HeadLine);
     newstr(pc^);
end;
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
Procedure Tinfscript.SetSwitches(pc : pchar);
begin
     disposeStr(Switches);
     newstr(pc^);
end;
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
Procedure Tinfscript.SetDebug(b : boolean);
begin
     Debug:=b;
end;
{-----------------------------------------------------------------}
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
{-----------------------------------------------------------------}
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
Function Tinfscript.GetTitle: pchar;
begin
     GetTitle:=Title;
end;
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
Function Tinfscript.GetHeadline: pchar;
begin
     GetHeadline:=Headline;
end;
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
Function Tinfscript.GetSwitches: pchar;
begin
     GetSwitches:=Switches;
end;
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
Function Tinfscript.GetDebug: boolean;
begin
     GetDebug:=Debug;
end;
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
{-----------------------------------------------------------------}
{--                                                             --}
{-----------------------------------------------------------------}
end.
