/************************************************************************
*
* Program GINA System
* Header ginas.h
* Version 0.1, October 1994.
* Version 0.3, May 1995.
*
* Copyright 1994, 1995, Jeff Standish.  (jestandi@cs.indiana.edu)
* All rights reserved.
* Permission is hereby granted for unrestricted non-commercial use,
* provided full attribution of source code origin is included.
*
* Version 0.1:
* Takes definitions from ginalisp.h, and adds objects and vocabulary.
*
* Version 0.3:
* Definition of IDNODE changed to allow it to also store strings, and to
* remove the dependence upon accessing id's via id numbers.
*
************************************************************************/


/* if _ANSI_ is defined, then the ANSI standard for function headers is
   used, otherwise normal function declaration formatting is used */
#define _ANSI_

#define TYPEjunk	0
#define TYPElisthead	1
#define TYPEfuncname	2
#define TYPEidname	3
#define TYPEnumber	4
#define TYPEstring	5
#define TYPEobject	6
#define TYPEclass	7

#define MAXFUNC		93
#define ACTIONnum	13
#define CLASSnum	23
#define FINDOBJECTnum	37
#define OBJECTnum	61
#define QUOTEnum	71
#define SETnum		78
#define SPAWNnum	85

#define QUEUESIZE	64

#define MAXBIND		12
#define MAXBINDOBJ	4

#define VOCABnoun	1
#define VOCABverb	2
#define VOCABprep	4
#define VOCABconjunct	8
#define VOCABarticle	16
#define VOCABadj	32
#define VOCABplural	128


	/* nodes for the symbol table, used for both symbols and strings */
struct idnodestruct {
    struct idnodestruct *left, *right;
    char  *name;
    char  inuse;
};

typedef struct idnodestruct IDNODE;


	/* the structure of a LISP "cons" node */
struct nodestruct {
    char type, inuse;
    union {
	struct {
	    struct nodestruct *car;
	    struct nodestruct *cdr;
	} ptr;
	int    number;
	IDNODE *idptr;
	struct objectstruct *objptr;
    } value;
};

typedef struct nodestruct NODEZ;


	/* BLOCK is used for the allocation of arrays of cons NODEZ,
	 * this uses arrays, making the allocation of large numbers of
	 * nodes simpler, along with garbage collection, since it removes
	 * the need for a <next> pointer in each node and allows a
	 * quick scan to see which ones are in use, and which are free */
#define BLOCKSIZE 64

struct blockstruct {
    int    nextcheck;
    NODEZ  nodelist[BLOCKSIZE];
    struct blockstruct *nextblock;
};

typedef struct blockstruct BLOCK;


	/* data structure for keeping an array of function pointers to
	   the built-in functions, along with a necessary number of
	   arguments and the name under which they are invoked */
struct funcdatastruct {
    char  *name;
    int   argnum;
    NODEZ *(*funcptr)();
};

typedef struct funcdatastruct FUNCDATA;


	/* structure used by object and class definitions */
struct objectstruct {
    IDNODE *idptr;
    NODEZ  *properties, *classes, *methods;
    struct objectstruct *parent, *sibling, *child;
};

typedef struct objectstruct OBJECT;


	/* structure for action definitions */
struct actionstruct {
    IDNODE *idptr;
    NODEZ  *words, *before, *after;
    struct actionstruct *next;
};

typedef struct actionstruct ACTION;


	/* contains information on active daemons */
struct daemonstruct {
    IDNODE *idptr;
    NODEZ  *variables;
    OBJECT *objectptr;
    struct daemonstruct *next;
};

typedef struct daemonstruct DAEMON;


	/* structure for resolving ambiguous object references within
	 * the built-in parser */
struct parsystruct {
    NODEZ  *obarray[MAXBINDOBJ];
    struct parsystruct *next;
};

typedef struct parsystruct PARSY;




/************************************************************************
*
* Prototypes for all defined functions.
*
************************************************************************/


	/* ginamain.c */
#ifdef _ANSI_
int    main(int, char **);
void   game_loop(void);
NODEZ  *sentence_to_list(void);
NODEZ  *parser(OBJECT *, NODEZ *);
NODEZ  *matcher(OBJECT *, NODEZ *);
void   bind_search(int);
void   object_search(int, OBJECT *);
int    which_object(int, NODEZ *);
PARSY  *eliminate_parsy(PARSY *, OBJECT *, int);
int    object_vs_sentence(OBJECT *, NODEZ *);
int    count_parsy(PARSY *);
int    count_parsy_objs(PARSY *, int);
int    is_parsy_seen(NODEZ *, PARSY *, int);
void   print_sentence(NODEZ *);
void   split_words(void);
void   match_actions(OBJECT *);
int    is_integer(char *);
int    str2int(char *);
void   int2str(int, char *);
int    dummy_word(char *);
int    match_word(char *, OBJECT *);
void   evaluate_daemons(void);
void   set_seed(void);
int    match_plurality(char *, char *);
int    same_string(char *, char *);
int    has_suffix(char *, char *);
char   *new_suffix(char *, char *, char *, int);
#else
char   *new_suffix();
NODEZ  *sentence_to_list();
NODEZ  *parser();
NODEZ  *matcher();
PARSY  *eliminate_parsy();
#endif


	/* ginalisp.c */
#ifdef _ANSI_
void   gina_lisp(char *, int);
NODEZ  *evaluate(NODEZ *, int *);
NODEZ  *eval_user_func(NODEZ *, NODEZ *, NODEZ *);
NODEZ  *eval_binding_list(NODEZ *, NODEZ *, NODEZ *);
NODEZ  *eval_bind_list_rec(NODEZ *);
int    is_equal_tree(NODEZ *, NODEZ *);
NODEZ  *constructor(NODEZ *, NODEZ *);
NODEZ  *quoter(NODEZ *);
OBJECT *good_ob_ptr(NODEZ *);
NODEZ  *obj_to_node(OBJECT *);
NODEZ  *obj_to_idname(OBJECT *);
NODEZ  *make_findobj(OBJECT *);
NODEZ  *assign_binding(IDNODE *, NODEZ *, NODEZ *);
void   assign_global(IDNODE *, NODEZ *);
NODEZ  *find_binding(IDNODE *);
NODEZ  *find_function(IDNODE *);
int    argument_minimum(int, char *, NODEZ *);
int    argument_check(int, char *, NODEZ *);
int    argument_num(NODEZ *);
void   screen_print(NODEZ *);
void   dump_tree(NODEZ *, FILE *);
void   print_tree(NODEZ *, FILE *);
int    pretty_print_tree(NODEZ *, int, int);
int    pretty_indent(int);
int    is_funcall(NODEZ *);
int    tree_length(NODEZ *);
void   load_file(char *);
NODEZ  *parse_lisp(void);
int    find_function_num(char *);
void   get_character(void);
void   get_token(void);
void   warning_mesg(char *);
#else
NODEZ  *evaluate();
NODEZ  *eval_user_func();
NODEZ  *eval_binding_list();
NODEZ  *eval_bind_list_rec();
NODEZ  *constructor();
NODEZ  *quoter();
OBJECT *good_ob_ptr();
NODEZ  *obj_to_node();
NODEZ  *obj_to_idname();
NODEZ  *make_findobj();
NODEZ  *assign_binding();
NODEZ  *find_binding();
NODEZ  *find_function();
NODEZ  *parse_lisp();
int    tree_length();
#endif


	/* ginafunc.c */
#ifdef _ANSI_
NODEZ *action_function(NODEZ *, int *);
NODEZ *add_function(NODEZ *, int *);
NODEZ *add1_function(NODEZ *, int *);
NODEZ *and_function(NODEZ *, int *);
NODEZ *append_function(NODEZ *, int *);
NODEZ *append_func_rec1(NODEZ *, NODEZ *, int *);
NODEZ *append_func_rec2(NODEZ *, NODEZ *, NODEZ *);
NODEZ *atomq_function(NODEZ *, int *);
NODEZ *begin_function(NODEZ *, int *);
NODEZ *car_function(NODEZ *, int *);
NODEZ *cdr_function(NODEZ *, int *);
NODEZ *child_function(NODEZ *, int *);
NODEZ *class_function(NODEZ *, int *);
NODEZ *classq_function(NODEZ *, int *);
NODEZ *collect_function(NODEZ *, int *);
NODEZ *cond_function(NODEZ *, int *);
NODEZ *cons_function(NODEZ *, int *);
NODEZ *delprop_function(NODEZ *, int *);
NODEZ *destroy_function(NODEZ *, int *);
NODEZ *div_function(NODEZ *, int *);
NODEZ *dumpids_function(NODEZ *, int *);
NODEZ *dumpstate_function(NODEZ *, int *);
NODEZ *equalq_function(NODEZ *, int *);
NODEZ *eval_function(NODEZ *, int *);
NODEZ *exit_function(NODEZ *, int *);
NODEZ *findobject_function(NODEZ *, int *);
NODEZ *function_function(NODEZ *, int *);
NODEZ *getprop_function(NODEZ *, int *);
NODEZ *ginalisp_function(NODEZ *, int *);
NODEZ *great_function(NODEZ *, int *);
NODEZ *greateq_function(NODEZ *, int *);
NODEZ *hasprop_function(NODEZ *, int *);
NODEZ *if_function(NODEZ *, int *);
NODEZ *killdaemon_function(NODEZ *, int *);
NODEZ *length_function(NODEZ *, int *);
NODEZ *less_function(NODEZ *, int *);
NODEZ *lesseq_function(NODEZ *, int *);
NODEZ *let_function(NODEZ *, int *);
NODEZ *list_function(NODEZ *, int *);
NODEZ *listq_function(NODEZ *, int *);
NODEZ *load_function(NODEZ *, int *);
NODEZ *loadobjects_function(NODEZ *, int *);
NODEZ *loop_function(NODEZ *, int *);
NODEZ *member_function(NODEZ *, int *);
NODEZ *method_function(NODEZ *, int *);
NODEZ *mod_function(NODEZ *, int *);
NODEZ *move_function(NODEZ *, int *);
NODEZ *mul_function(NODEZ *, int *);
NODEZ *nequalq_function(NODEZ *, int *);
NODEZ *nth_function(NODEZ *, int *);
NODEZ *nullq_function(NODEZ *, int *);
NODEZ *numberq_function(NODEZ *, int *);
NODEZ *object_function(NODEZ *, int *);
NODEZ *objectname_function(NODEZ *, int *);
NODEZ *objectq_function(NODEZ *, int *);
NODEZ *or_function(NODEZ *, int *);
NODEZ *parent_function(NODEZ *, int *);
NODEZ *parser_function(NODEZ *, int *);
NODEZ *pluralof_function(NODEZ *, int *);
NODEZ *pprinttree_function(NODEZ *, int *);
NODEZ *print_function(NODEZ *, int *);
NODEZ *printtree_function(NODEZ *, int *);
NODEZ *quote_function(NODEZ *, int *);
NODEZ *random_function(NODEZ *, int *);
NODEZ *read_function(NODEZ *, int *);
NODEZ *readsentence_function(NODEZ *, int *);
NODEZ *return_function(NODEZ *, int *);
NODEZ *samestringq_function(NODEZ *, int *);
NODEZ *saveobjects_function(NODEZ *, int *);
NODEZ *set_function(NODEZ *, int *);
NODEZ *setprop_function(NODEZ *, int *);
NODEZ *showaction_function(NODEZ *, int *);
NODEZ *showclass_function(NODEZ *, int *);
NODEZ *showfunc_function(NODEZ *, int *);
NODEZ *showobject_function(NODEZ *, int *);
NODEZ *sibling_function(NODEZ *, int *);
NODEZ *spawn_function(NODEZ *, int *);
NODEZ *str2sym_function(NODEZ *, int *);
NODEZ *stringq_function(NODEZ *, int *);
NODEZ *sub_function(NODEZ *, int *);
NODEZ *sub1_function(NODEZ *, int *);
NODEZ *subclassofq_function(NODEZ *, int *);
NODEZ *sym2str_function(NODEZ *, int *);
NODEZ *terminate_function(NODEZ *, int *);
void  func_warning(char *, char *, NODEZ *);
#else
NODEZ *action_function();
NODEZ *add_function();
NODEZ *add1_function();
NODEZ *and_function();
NODEZ *append_function();
NODEZ *append_func_rec1();
NODEZ *append_func_rec2();
NODEZ *atomq_function();
NODEZ *begin_function();
NODEZ *car_function();
NODEZ *cdr_function();
NODEZ *child_function();
NODEZ *class_function();
NODEZ *classq_function();
NODEZ *collect_function();
NODEZ *cond_function();
NODEZ *cons_function();
NODEZ *delprop_function();
NODEZ *destroy_function();
NODEZ *div_function();
NODEZ *dumpids_function();
NODEZ *dumpstate_function();
NODEZ *equalq_function();
NODEZ *eval_function();
NODEZ *exit_function();
NODEZ *findobject_function();
NODEZ *function_function();
NODEZ *getprop_function();
NODEZ *ginalisp_function();
NODEZ *great_function();
NODEZ *greateq_function();
NODEZ *hasprop_function();
NODEZ *if_function();
NODEZ *killdaemon_function();
NODEZ *length_function();
NODEZ *less_function();
NODEZ *lesseq_function();
NODEZ *let_function();
NODEZ *list_function();
NODEZ *listq_function();
NODEZ *load_function();
NODEZ *loadobjects_function();
NODEZ *loop_function();
NODEZ *member_function();
NODEZ *method_function();
NODEZ *mod_function();
NODEZ *move_function();
NODEZ *mul_function();
NODEZ *nequalq_function();
NODEZ *nth_function();
NODEZ *nullq_function();
NODEZ *numberq_function();
NODEZ *object_function();
NODEZ *objectname_function();
NODEZ *objectq_function();
NODEZ *or_function();
NODEZ *parent_function();
NODEZ *parser_function();
NODEZ *pluralof_function();
NODEZ *pprinttree_function();
NODEZ *print_function();
NODEZ *printtree_function();
NODEZ *quote_function();
NODEZ *random_function();
NODEZ *read_function();
NODEZ *readsentence_function();
NODEZ *return_function();
NODEZ *saveobjects_function();
NODEZ *samestringq_function();
NODEZ *set_function();
NODEZ *setprop_function();
NODEZ *showaction_function();
NODEZ *showclass_function();
NODEZ *showfunc_function();
NODEZ *showobject_function();
NODEZ *sibling_function();
NODEZ *spawn_function();
NODEZ *str2sym_function();
NODEZ *stringq_function();
NODEZ *sub_function();
NODEZ *sub1_function();
NODEZ *subclassofq_function();
NODEZ *sym2str_function();
NODEZ *terminate_function();
#endif

	/* ginaobj.c */
#ifdef _ANSI_
OBJECT *find_object(IDNODE *, OBJECT *);
OBJECT *find_class(IDNODE *);
int    is_subclass(NODEZ *, IDNODE *);
NODEZ  *make_class_list(NODEZ *);
NODEZ  *find_property(OBJECT *, IDNODE *);
NODEZ  *find_prop_rec(OBJECT *, IDNODE *);
NODEZ  *find_method(OBJECT *, IDNODE *);
NODEZ  *find_meth_rec(OBJECT *, IDNODE *);
NODEZ  *assemble_object(OBJECT *, int);
NODEZ  *assemble_classlist(NODEZ *);
NODEZ  *assemble_action(ACTION *);
void   destroy_object(OBJECT *);
void   dump_state(char *);
void   dump_state_rec(NODEZ *, OBJECT *, FILE *);
void   save_objects(OBJECT *, char *);
void   save_objects_rec(OBJECT *, NODEZ *, FILE *);
NODEZ  *save_spawner(DAEMON *);
NODEZ  *save_spawner_rec(NODEZ *, NODEZ *);
#else
OBJECT *find_object();
OBJECT *find_ob_rec();
OBJECT *find_class();
NODEZ  *make_class_list();
NODEZ  *find_property();
NODEZ  *find_prop_rec();
NODEZ  *find_method();
NODEZ  *find_meth_rec();
NODEZ  *assemble_object();
NODEZ  *assemble_classlist();
NODEZ  *assemble_action();
NODEZ  *save_spawner();
NODEZ  *save_spawner_rec();
#endif


	/* ginamem.c */
#ifdef _ANSI_
void   initialize_memory(void);
NODEZ  *new_node(void);
ACTION *new_action(void);
ACTION *find_action(IDNODE *);
void   new_block(void);
DAEMON *new_daemon(void);
void   free_daemon(DAEMON *);
OBJECT *new_object(void);
void   free_object(OBJECT *);
IDNODE *find_idstring(char *);
IDNODE *new_idnode(void);
void   dump_idnodes(void);
void   dump_id_recurse(IDNODE *, int);
PARSY  *new_parsy(void);
void   free_parsy(PARSY *);
char   *new_string(char *);
void   collect_garbage(int);
void   mark_list(NODEZ *);
void   mark_object(OBJECT *);
void   mark_action(ACTION *);
void   mark_daemon(DAEMON *);
void   new_line(void);
void   flush_outbuf(void);
void   print_string(char *);
#else
NODEZ  *new_node();
ACTION *new_action();
ACTION *find_action();
DAEMON *new_daemon();
OBJECT *new_object();
OBJECT *find_ob_rec();
OBJECT *find_class();
NODEZ  *make_class_list();
IDNODE *find_idstring();
IDNODE *new_idnode();
PARSY  *new_parsy();
char   *new_string();
#endif


