/* cncurses.c: CSCR allegro interface
    This wraps various curses.h functions for use with 
    cscr, and adds a screen capture facility

    (Unix version)

    By L. Ross Raszewski <lraszewski@justice.loyola.edu>

    Uses curses.h
   

*/
#define __file_exists(x) (!access(x,F_OK))
#include <stdarg.h>
#include <unistd.h>
#include <curses.h>
#include "cscr.h"

struct mouse_info_s mouse_info;
int VHORIZ_REZ;
int VVERT_REZ;
unsigned char OPT_AO_FF_OUTPUT[]= {
        0,   173, 155, 156, 15 , 157, '|', 21,
        0,     0, 166, 174, 170, '-',   0,   0,
        248, 241, 253,   0, '\'', 230, 20, 249,
        0,     0, 167, 175, 172,  171,  0, 168,
        0,     0,   0,   0, 142, 143,  146, 128,
        0,   144,   0,   0,  0,   0,   0,   0,  
        0,   165,   0,   0,  0,  0,  163,  0,   
        0,   0,   0,   0,154,  0,   0,   225, 
        133, 160, 131,  0, 132, 134, 145, 135,  
        130, 130, 136, 137, 141, 161, 140, 139, 
        0,   164, 149, 161, 147, 0, 148, 246,   
        237, 163, 151, 150, 129, 0, 0, 152,     
         };
static char c_printscanbuf[4096];
static const int dtou_color[] =
{ 
  COLOR_BLACK,
  COLOR_BLUE,
  COLOR_GREEN,
  COLOR_CYAN,
  COLOR_RED,
  COLOR_MAGENTA,
  COLOR_YELLOW,
  COLOR_WHITE
};
static chtype key_remap(chtype c)
{
 if (c==127) return 8;
 else if (c==8) return 127;
 else if (c==0) return 17;
 else
 if (c==27 && cscr_kbhit())
   {
    c=getch();
    if (c >= 265 && c <=276) return c+30;
    else if (c==9) return 482;
    else if (c==331) return 479;
    else if (c==79)
      { c = getch();
        if (c==72) return 262;
	else if (c==70) return KEY_END;
	else if (c==97) return 480;
	else if (c==98) return 481;
	else if (c==100) return 443;
	else if (c==99) return 444;
      }
    else if (c==91)
      { int z; c=getch(); z=getch();
        if (c==49) 
	  { if (z==94)
	    return 447;
	    getch();
	    if (z==53) return 289;
	    else if (z==55) return 290;
	    else if (z==56) return 291;
	    else if (z==57) return 292;
	  }
	else if (c==52) return 448;
	else if (c==50) return 477;
	else if (c==51) return 467;
        
      }

  return c; 
  }
return c;
}
void  cscr_charpos_to_pxl(int *x, int *y)
{

}
void  cscr_wake_mouse()
{

}
void  cscr_sleep_mouse()
{

}
int cscr_query_mouse()
{
 return 0;
}


int cscr_version()
{
 return CSCR_UNIX;
}
void cscr_start()   // CHECK
{   int j,k,i;
    initscr();
    cbreak();
    noecho();
    nonl(); 
    intrflush(stdscr, FALSE); 
    keypad(stdscr, TRUE);
    meta(stdscr, TRUE);
    scrollok(stdscr, FALSE);
    start_color();
    i=1;
    for(j=0;j<8;j++)
     for(k=0;k<8;k++)
      init_pair(i++,dtou_color[k],dtou_color[j]);
}
void cscr_end()     // FIX LATER
{
  endwin();
}
unsigned int cscr_getcols()   // CHECK
{
 return COLS;
}
unsigned int cscr_getlines()  // CHECK
{
 return LINES;
}
void cscr_clear() // CHECK
{
  clear();
}
void cscr_moveyx(int y, int x) // CHECK
{
 move(y,x);
}
int cscr_addstr(char *s)    // check
{
 return addstr(s);
}
void cscr_refresh()  // check
{
refresh();
}
chtype cscr_getch() // check
{
 return key_remap(getch());
}
chtype cscr_color(int f, int b)
{
 int p,a;
 a=0;
 if (f >= 8) { a = A_BOLD; f -= 8; }
 if (b >= 8) { a |= A_BLINK; b -=8; }

 p=f + (8*b) + 1;
 return COLOR_PAIR(p) | a;

}
chtype cscr_bkgd(chtype i)
{
 return bkgd(i);
}
void cscr_exit()
{
    clear();
    refresh();
    endwin();
}
void cscr_addch(chtype c)
{

 addch(c);
}
void cscr_attron(chtype a)
{
 attron(a);
}
void cscr_attrset(chtype x)
{
 attrset(x);
}
void cscr_attroff(chtype x)
{
 attroff(x);
}

void cscr_clrtoeol()
{
 clrtoeol();
}

void cscr_mvaddch(int y, int x, chtype c)
{
 mvaddch(y,x,c);
}

int cscr_printw(char *fmt, ...)
{
 va_list args;
 int retval=ERR;
 va_start(args,fmt);

	vsprintf(c_printscanbuf, fmt, args);
	va_end(args);
        if (cscr_addstr(c_printscanbuf) == ERR)
		return (retval);
	retval = (strlen(c_printscanbuf));
	return (retval);

}


int cscr_kbhit()
{
 int x; 
 nodelay(stdscr,TRUE);
 x=getch();
 if (x!=ERR)
  ungetch(x);
 nodelay(stdscr,FALSE);
 return x!=ERR;
}
void cscr_blinkey()
{
}
void cscr_screencap()
{
   int i,j;
 FILE *f;
 char s[13];
 static int n=0;
 do {
  sprintf(s,"scr%05d.txt",n);
  n++;
  }
 while(__file_exists(s) && n < 100000);
 if (n>99999) return;
 f=fopen(s,"w");
 for(i=0;i<LINES;i++)
 {
  for(j=0;j<COLS;j++)
   putc(stdscr->_line[i].text[j] & A_CHARTEXT,f);
  putc('\n',f);
 }
 fclose(f);
}
int _set_screen_lines(int x)
{
 return x;
}
void cscr_suspend()
{
 clear();
 refresh();
}
void cscr_resume()
{
 clear();
 refresh();
}
unsigned char cscr_color_to_8bit(chtype c)
{
 int cp = c >> 24;
 unsigned char fg = (cp - 1 ) % 8;
 unsigned char bg = (cp - 1 ) / 8;
 if (c & A_BOLD) fg |= 8;
 if (c & A_BGBRITE) bg |= 8;
 return fg | (bg << 4 );
}
