/* gtmessag.c: The message line at the bottom of the screen
        for GlkDOS, curses.h/allegro implementation of the Glk API
    Designed by L. Ross Raszewski <lraszewski@justice.loyola.edu>
    
    based upon GlkTerm by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/index.html
*/

#include "gtpref.h"
#include "gtoption.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cscr.h"
#include "glk.h"
#include "glkdos.h"

/* Nothing fancy here. We store a string, and print it on the bottom line.
    If pref_messageline is FALSE, none of these functions do anything. */

static char *msgbuf = NULL;
static int msgbuflen = 0;
static int msgbuf_size = 0;
static int msg_tick = 0;

void gli_msgline_tick(char *msg)
{
  gli_msgline(msg);
  msg_tick=1;
}
void gli_msgline_untick()
{
 if (msg_tick)
  gli_msgline(NULL);
}
void gli_msgline_warning(char *msg)
{
    char buf[256];
    
    if (!glk_preferences[pref_messageline])
        return;
        
    sprintf(buf, "Glk library error: %s", msg);
    gli_msgline(buf);
}
extern int lastmore;
void gli_msgline(char *msg)
{
    int len;
    lastmore=0;
    msg_tick=0;
    if (!glk_preferences[pref_messageline])
        return;
        
    if (!msg) 
        msg = "";
    
    len = strlen(msg);
    if (!msgbuf) {
        msgbuf_size = len+80;
        msgbuf = (char *)malloc(msgbuf_size * sizeof(char));
    }
    else if (len+1 > msgbuf_size) {
        while (len+1 > msgbuf_size)
            msgbuf_size *= 2;
        msgbuf = (char *)realloc(msgbuf, msgbuf_size * sizeof(char));
    }

    if (!msgbuf)
        return;
    
    strcpy(msgbuf, msg);
    msgbuflen = len;
    
    gli_msgline_redraw();
}

void gli_msgline_redraw()
{
    if (!glk_preferences[pref_messageline])
        return;
        
    if (msgbuflen == 0) {
        cscr_moveyx(content_box.bottom, 0);
        cscr_clrtoeol();
    }
    else {
        int ix, len;
        
        cscr_moveyx(content_box.bottom, 0); 
        cscr_addch(' ');
        cscr_addch(' ');
        cscr_attron(A_REVERSE);
        if (msgbuflen > content_box.right-3)
            len = content_box.right-3;
        else
            len = msgbuflen;
        for (ix=0; ix<len; ix++) {
            cscr_addch(msgbuf[ix]);
        }
        cscr_attrset(0);
        cscr_clrtoeol();
    }
}
