
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <jni.h>
#include "glk.h"

#define PACKAGE "org/ifarchive/glk/"

static  JavaVM *jvm;
static  JNIEnv *env;
static char    *cpath;
static char    *argclass = NULL;
static char    *exclass = PACKAGE "Glk";
static jclass    classLib, classProg;
static jmethodID midLib, midProg;

/* Forward declaration */
static int find_classes(void);

/************************************************************************
 * Start of code that's specific to xglk. On other systems, this would 
 * have to be replaced by some other way of finding what class to run.
 ************************************************************************/
#include "glkstart.h"
glkunix_argumentlist_t glkunix_arguments[] = {
    { "", glkunix_arg_ValueFollows, "class: The Java class to load"},
    { NULL, glkunix_arg_End, NULL }
};

/* If a class argument was specified, store it in argclass. Convert it
 * from dot-separated form (eg "org.raif-pool.Xyzzy") to slash-separated
 * form (eg "org/raif-pool/Xyzzy"), which the JVM requires. */
int glkunix_startup_code(glkunix_startup_t *data)
{
	char *s;
	int ok;

	if (data->argc > 1)
	{
		argclass = malloc(1 + strlen(data->argv[1]));
		if (!argclass)
		{
			fprintf(stderr, "Out of memory.\n");
			return FALSE;	
		}
		/* Replace dots in the classname with slashes, as Java requires. */
		strcpy(argclass, data->argv[1]);
		while (  (s = strchr(argclass, '.')) ) *s = '/';
		exclass = argclass;
	}
	/* Check if the required classes can be loaded. */	
	ok = find_classes();
	if (ok) return ok;
        (*jvm)->DestroyJavaVM(jvm);
	return FALSE;
}
/************************************************************************
 * End of code that's specific to xglk.
 ************************************************************************/

int find_classes(void)
{	
	/* Check that we have the library and program classes 
	 * available to us before starting anything */
        classProg = (*env)->FindClass(env, exclass);
	if (!classProg)
	{
		fprintf(stderr, "Can't find %s class\n", exclass);
		return FALSE;
	}
        midProg = (*env)->GetStaticMethodID(env, classProg, "glkMain", "()V");
	if (!midProg)
	{
		fprintf(stderr, "Can't find %s.glkMain() method\n", exclass);
		return FALSE;
	}
       	classLib = (*env)->FindClass(env, PACKAGE "Glk");
	if (!classLib)
	{
		fprintf(stderr, "Can't find %s class\n", PACKAGE "Glk");
		return FALSE;
	}

        midLib = (*env)->GetStaticMethodID(env, classLib, "init", "()Z");
	if (!midLib)
	{
		fprintf(stderr, "Can't find %s.init() method\n", PACKAGE "Glk");
		return FALSE;
	}
        return TRUE;
}

int glkunix_jni_hook(void)
{
	char *ecp;
	int cplen;

        JDK1_1InitArgs vm_args; /* JDK 1.1 VM initialization arguments */

        vm_args.version = 0x00010001; /* New in 1.1.2: VM version */
        /* Get the default initialization arguments and set the class
         *          * path */
        JNI_GetDefaultJavaVMInitArgs(&vm_args);

	cplen = 15 + 2 * strlen(vm_args.classpath);
	ecp = getenv("CLASSPATH");
	if (ecp) cplen += strlen(ecp) + 1;

	cpath = malloc(cplen);
	if (!cpath)
	{
		fprintf(stderr, "Out of memory.\n");
		return FALSE;
	}
	strcpy(cpath, ".:jniglk.jar:");
	if (ecp)
	{
		strcat(cpath, ecp);
		strcat(cpath, ":");
	}
	strcat(cpath, vm_args.classpath);
	vm_args.classpath = cpath;

        /* load and initialize a Java VM, return a JNI interface
         *          * pointer in env */
        if (JNI_CreateJavaVM(&jvm, &env, &vm_args))
	{
		fprintf(stderr, "Can't create Java VM.\n");
		return FALSE;
	}
        return TRUE;              
}




void jniglk_main()
{
	/* Re-find the classes (you can't trust the IDs to be persistent) */
	if (!find_classes()) return;
	/* Invoke the library's init() method */
        if (! ((*env)->CallStaticBooleanMethod(env, classLib, midLib)))
	{
		fprintf(stderr, "init() method failed.\n");
		return;
	}
        /* invoke the selected glkMain method. */
        (*env)->CallStaticVoidMethod(env, classProg, midProg);
}


void glk_main()
{
	jniglk_main();
        (*jvm)->DestroyJavaVM(jvm);
	glk_exit();
}

	
