
package org.ifarchive.glk;
/** The Event is passed to Glk.select(). It will be populated when 
 * select() returns.
 * <p>Most of the time, you only get the events that you request. However,
 * there are some events which can arrive at any time. This is why you must
 * always call Glk.select() in a loop, and continue the loop until you get
 * the event you really want.</p>
 * 
 * @version 1.0
 * @author John Elliott
 * @see Glk#select(org.ifarchive.glk.Event)
 * @see Glk#selectPoll(org.ifarchive.glk.Event)
 */
public class Event
{
	/** No event. This is a placeholder, and Glk.select() never returns it.*/
	public static final int evtype_None        = 0;
	/** An event that repeats at fixed intervals. */
	public static final int evtype_Timer       = 1;
	/** A keystroke event in a window. */
	public static final int evtype_CharInput   = 2;
	/** A full line of input completed in a window. */
	public static final int evtype_LineInput   = 3;
	/** A mouse click in a window. */
	public static final int evtype_MouseInput  = 4; 
	/** An event signalling that the sizes of some windows have changed. */
	public static final int evtype_Arrange     = 5;
	/** An event signalling that graphics windows must be redrawn. */
	public static final int evtype_Redraw      = 6;
	/** A sound has completed playing. val1 is the sound's resource ID
	 * and val2 is the value you passed to SoundChannel.play()
	 * as "notify". 
	 * @see SoundChannel#play(int,int,int)*/
	public static final int evtype_SoundNotify = 7;
	/** The selection of a hyperlink in a window. */
	public static final int evtype_Hyperlink   = 8;

	/** The type of the event. This can be one of evtype_*, or
	 * a negative number for implementation-defined events. */
	public int    type  = evtype_None;
	/** The window that spawned the event, if relevant. */
	public Window win   = null;
	/** The meaning of this field depends on the type of the Event. */
	public long   val1  = 0;
	/** The meaning of this field depends on the type of the Event. */
	public long   val2  = 0;
	/** The dispatch ID of the window that spawned the event. */
	int           winid = 0;
}
