
package org.ifarchive.glk;

/** The InterruptListener is called if the Glk library is asked to shut down.
 * 
 * <!-- Next two paras come from the Glk spec -->
 * <p>Most platforms have some provision for interrupting a program --
 * command-period on the Macintosh, control-C in Unix, possibly a window
 * manager menu item, or other possibilities. This can happen at any time,
 * including while execution is nested inside one of your own functions,
 * or inside a Glk library function.</p>
 * 
 * <p>If you need to clean up critical resources, you can specify an interrupt
 * handler function.</p>
 *
 * <p>In Java, do this by implementing the InterruptListener interface, and
 * calling Glk.setInterruptHandler().
 *
 * @see Glk#setInterruptHandler
 * @author John Elliott
 * @version 1.0 */

public interface InterruptListener
{
	/** This function is called when Glk receives an interrupt.  

	<p>This handler will be called before the process is shut down.</p>
	<p>You should not try to interact with the player in your interrupt
	handler. Do not call Glk.select() or Glk.selectPoll(). Anything you
	print to a window may not be visible to the player.</p>
	*/
	public void interrupt();
}
