
package org.ifarchive.glk;

import java.io.Reader;

/** This is a Reader that works on a Glk stream. 
 * The GLK stream must be open for input.
 * @author John Elliott
 * @version 1.0
 */
public class StreamReader extends Reader
{
	Stream m_s;

	/** Create a StreamReader. The underlying stream must have been
	 * opened in read mode. */
	public StreamReader(Stream s)
	{
		m_s = s;
	}

	/** Returns the GLK stream associated with this StreamReader */
	public Stream getStream()
	{
		return m_s;
	}

	/** Close the stream. */
	public void close()
	{
		m_s.close();
	}


	/** Read characters from the stream into a portion of an array.
	 * 
	 * @param cbuf Destination buffer
	 * @param off Offset at which to start storing characters
	 * @param len Maximum number of characters to read
	 * @return The number of characters read, or -1 if the end
	 *        of the stream has been reached
	 * @see java.io.Reader#read(char,int,int)
	 */	
	public int read(char cbuf[], int off, int len) 
	{
		int count  = 0;
		while (len > 0)
		{
			int c = m_s.getChar();
			if (c == -1) return -1;	
			cbuf[off++] = (char)c;
			--len;
		}

		return count;
	}
}
