!----------------------------------------------------------------------------
routine DoWalkthru
{
    "The solution to \BDistress\b was included with the IFComp 2005 download.
    The file name is \"distress.sol\" and it's plain-text (open using your
    text editor of choice). The walkthrough has been divided into five
    distinct sections.\n"
    "The first is a very verbose solution, guiding you through from the
    beginning to the end. It's useful for two reasons. One, it may be easier
    to keep from seeing too many spoilers as you read down through it (unlike
    the next two sections, where the solution is given command-by-command).
    Also, it explains what might prompt a player to take the actions needed
    to solve the game, by pointing out some of the clues and hints.\n"
    "The second section is one possible -- but nearly ideal -- solution. It
    could be one result of the instructions provided by the first section.
    The list of commands can be cut and pasted into a new file (for instance,
    \"typical.rec\") and then replayed by starting over and typing PLAYBACK.\n"
    "The third section is much like the second, except that the commands show
    a speed run -- the player already knows everything there is to know, and
    the commands are a minimum to reach the ending. This can also be used
    to auto-play the game via PLAYBACK, if saved (for instance, as \"speed.rec\").\n"
    "In the fourth section, you will find some commentary on the game itself,
    the design decisions, how some aspects of it work, etc. It's interesting,
    maybe -- but best unread until after you have finished.\n"
    "The fifth and final section includes an all-text map of the game."
}

!----------------------------------------------------------------------------
routine DoXyzzy
{
    print "" : indent : indent : "\"Do not seek the treasure!\" -- Pete"
}

!----------------------------------------------------------------------------
routine DoPlugh
{
    print "" : indent : indent : "\"We thought you was a toad!\" -- Delmar"
}

!----------------------------------------------------------------------------
routine DoAbout
{
    "Well, since you asked...\n"

    Font(PROP_OFF)
    print "\_\_+------------------------+"
    print "\_\_| Distress (Version "; this_version; ") |"
    print "\_\_| An entry in IFComp '05 |"
    print "\_\_| Written by Mike Snyder |"
    print "\_\_| sidneymerk@hotmail.com |"
    print "\_\_| At: www.sidneymerk.com |"
    print "\_\_+------------------------+"
    Font(PROP_ON)
    "\nThis is not the game I originally intended to enter this year. For
    several months, I was hard at work on a graphic-intensive story with
    interesting and active characters, more puzzles, and a detailed plot.
    Ultimately, it doesn't really fit with the competition's two-hour theme.
    That, and I became skeptical about completing it by the deadline."
    "\nThat's how \BDistress\b came about. I still wanted to take part in this
    year's competition, so I went back to one of my many undeveloped (but
    less ambitious) ideas. I had a title, a theme, and an ending. The rest,
    as they say, is history."
    "\nThrough design and development, I had to make some interesting -- if
    odd -- decisions. What happens to the suspense and the discovery when you
    can just wait until something happens? I had to disable some versions of
    the Hugo library's \"wait\" command, and put restrictions on others. The
    game can easily end in your demise, and the \"winning\" ending (you'll
    know it, because you don't die) should be much more rewarding as a result.
    Otherwise, where is the urgency and the sense of consequences?"
    "\nAll in all, I think these kinds of decisions were right for this story.
    I hope, in the end, that you'll agree."
    "\n\_\_\_\_--- Mike"
}

!----------------------------------------------------------------------------
routine DoRead
{
    !If the object doesn't have a custom "read" handler, then we send it
    !on to "look" instead, as was the default in the Hugo libraries.
    return Perform(&DoLook, object)
}

!----------------------------------------------------------------------------
routine DoPush
{
    if not CheckReach(object):  return false

    PrintMessage(3,14,object)
    return true
}

!----------------------------------------------------------------------------
routine DoPull
{
    if not CheckReach(object):  return false

    PrintMessage(3,14,object)
    return true
}

!----------------------------------------------------------------------------
routine DoCut
{
    if (xobject = nothing) {
        print "You can't "; word[1]; MatchPlural(object,"that ","those ");
        "with your bare hands."
    } else {
        if (xobject is sharp) {
            if not (xobject.after) {
                if not (object.after) {
                    print "You "; word[1]; " "; The(object); " using ";
                    print The(xobject); "."
                }
            }
        } else {
            print CThe(xobject); MatchPlural(xobject,"isn't ","aren't ");
            print "sharp enough to "; word[1]; " "; The(object); "."
        }
    }
    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoRip
{
    !In the absence of a different "before" handler, use the DoCut for this
    return perform (&DoCut, Object, XObject)
}

!----------------------------------------------------------------------------
routine DoStabReverse
{
    !We specified the command backwards, so swap objects and perform DoStab.
    return perform (&DoStab, XObject, object)
}

!----------------------------------------------------------------------------
routine DoStab
{
    if (xobject = nothing) {
        print "You "; word[1]; " your finger at "; The(object); ", ";
        "but nothing happens."
    } else {
        if (xobject is sharp) {
            if not (xobject.after) {
                if not (object.after) {
                    print "You "; word[1]; " "; The(object); " using ";
                    print The(xobject); ". Nothing happens."
                }
            }
        } else {
            print CThe(xobject); MatchPlural(xobject,"isn't ","aren't ");
            print "sharp enough to affect "; The(object); "."
        }
    }
    return true !To increment move counter
}

!----------------------------------------------------------------------------
!Indicates we tried to "wrap xobject using object" so we need to turn it
!around to be "wrap object with xobject" to make things work easier.
!
routine DoWrapReverse
{
    return perform(&DoWrap,xobject,object)
}

!----------------------------------------------------------------------------
routine DoWrap
{
    if not CheckReach(object): return false

    if (xobject = nothing) {
        PrintMessage(1,1,object)
    } else {
        if (object is cuttable) or (object is rippable) {
            if not (xobject.after) {
                if not (object.after) {
                    PrintMessage(3,6) !Nothing is to be gained by that.
                }
            }
        } else {
            PrintMessage(3,17,object) !Can't be used to wrap anything.
        }
    }
    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoUnWrap
{
    if not CheckReach(object):  return false

    !We'll rely on "object.before" if UNWRAP should work.

    if (xobject = nothing) {
        print CThe(object); " doesn't seem to be wrapped ";
        if (object is cuttable) or (object is rippable) {
            "around ";
        } else {
            "with ";
        }
        "anything."
    } else {
        print CThe(object); MatchPlural(object,"isn't ","aren't ");
        print "wrapped ";
        if (object is cuttable) or (object is rippable) {
            "around ";
        } else {
            if (xobject is cuttable) or (xobject is rippable) {
                "with ";
            } else {
                "to ";
            }
        }
        print the(xobject); "."
    }
    
    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoTieReverse
{
    return Perform(&DoTie, xobject, object)
}

!----------------------------------------------------------------------------
routine DoTie
{
    if not CheckReach(object):  return false

    if (xobject = nothing) {
        PrintMessage(1,1,object)
    } else {
        if not (xobject.after) {
            if not (object.after) {
                PrintMessage(3,14,object)
            }
        }
    }
    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoUnTie
{
    if not CheckReach(object):  return false

    !We'll rely on "object.before" if UNTIE should work.

    if (xobject = nothing) {
        print CThe(object); " doesn't seem to be tied ";
        if (object is cuttable) or (object is rippable) {
            "to ";
        } else {
            "with ";
        }
        "anything."
    } else {
        print CThe(object); MatchPlural(object,"isn't ","aren't ");
        print "tied ";
        if (object is cuttable) or (object is rippable) {
            "around ";
        } else {
            if (xobject is cuttable) or (xobject is rippable) {
                "with ";
            } else {
                "to ";
            }
        }
        print the(xobject); "."
    }
    
    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoTouchReverse
{
    !We specified the command backwards, so swap objects and perform DoTouch.
    return perform (&DoTouch, XObject, object)
}

!----------------------------------------------------------------------------
routine DoTouch
{
    if not CheckReach(object): return false

    if (xobject = nothing) or not (xobject.after) {
        if not (object.after) {
            if (xobject = nothing) {
                print "Fiddling with "; The(object, true); " ";
                "like that probably isn't the best use of ";
                print player.pronoun #3; " time at the moment."
            } else {
                PrintMessage(3,15) !Nothing happens.
            }
        }
    }
    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoChisel
{
    if (xobject = nothing) {
        PrintMessage(1,3,object)
    } else {
        if (xobject is sharp) {
            if not (xobject.after) {
                if not (object.after) {
                    PrintMessage(3,6) !Nothing is to be gained by that.
                }
            }
        } else {
            PrintMessage(3,17,xobject) !Can't be used to chisel anything.
        }
    }
    return true !To increment move counter
}

!----------------------------------------------------------------------------
!Not exactly the same as what's in VerbStub -- searching self results in an
!inventory check, and changes where made to searching the NPCs. Actually, we
!handle searching the NPC's in before or after code, anyway.
!
routine DoSearch
{
    if object = player {
        perform(&DoInventory)
    } elseif object is container and child(object) {
		Perform(&DoLookIn, object)
    } else {
        if not (object.after) {
            CThe(player)
            MatchPlural(player, "doesn't", "don't")
            " find anything new."
        }
	}
	return true
}

!----------------------------------------------------------------------------
routine DoPry
{
    if not CheckReach(object): return false

    if (xobject = nothing) {
        PrintMessage(1,3,object)
    } else {
        if not (xobject.after) {
            if not (object.after) {
                PrintMessage(3,14,object)
            }
        }
    }
    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoThrowAt
{
    if (xobject = nothing) {
        PrintMessage(1,4,object)
    } else {
        if not (xobject.after) {
            if not (object.after) {
                PrintMessage(3,8) !No point in that.
            }
        }
    }
	return true
}

!----------------------------------------------------------------------------
!MPS -- took from HugoLib.h to make slight customizations. Main thing was it
!looks odd when you "undo" in a dark location, because you're told that it's
!too dark to see anything which appears to be the "result" of the undo. So
!we are going to make a special condition for that.
!
replace DoUndo
{
    !Because of an apparent HUGO quirk where "und" gets changed to 3 if
    !we are undoing after a "wait", use a couple temp vars. Seems to work,
    !if they are declared before und. I have no idea why... but there.

    local junk1, junk2, und : und = undo_counter
    junk1 = 0 : junk2 = 0 !To fix weird "wait/undo" quirk.

    !* This is glitchy, so don't use it.
    !* if (GetCommandHist(1,1) = nothing) {
    !*     print "(Nothing to undo)"
    !*     return false
    !* }

    !The command history feature is too glitchy. Not going to use it.
    !* print "(Attempting to undo \""; PrintCommandHist(1); "\")"

    if (not UNDO_OFF) {
        if (und < max_undo) {
            if (undo) {
                und++ : undo_counter = und
                print "(Undo of the ";
                if (und = 2) { "second "; }
                if (und = 3) { "third "; }
                if (und = 4) { "fourth "; }
                if (und = 5) { "fifth "; }
                print "most recent turn successful)"
                PrintStatusline
                if not FindLight(location) { print "" }
                DescribePlace(location)
                return true
            } else {
                VMessage(&DoUndo)
                return false
            }
        } else {
            "(Undo available for the five most recent turns only)"
            return false
        }
    } else {
        !VMessage(&DoUndo)
        "(Nothing to undo)"
        return false
    }
}

!----------------------------------------------------------------------------
!* routine DoCommandHist
!* {
!*     local i : local which = 0
!*     "The last five commands were: ";
!*     for (i=1; i<=max_undo; i++) {
!*         if (GetCommandHist(i,1) ~= "") {
!*             if (which > 0) { ", "; }
!*             which ++ !Increment the counter.
!*             print "("; number(which); ") ";
!*             print PrintCommandHist(i);
!*         }
!*     }
!*     if (which = 0) { "N/A" } else { print "" }
!* }

!----------------------------------------------------------------------------
!There was a problem handling all the grammar for "remove" so I'm using
!this is a work-around -- a front-end for the other routines!
!
! * cuttable "from" xobject               DoUnwrap
! * rippable "from" xobject               DoUnwrap
! * multi "from"/"outof"/"offof" parent   DoGet
! * multi "from"/"outof"/"offof" xobject  DoGet
! * (undersuit)                           DoTakeOff
! * multi                                 DoGet
!
routine DoRemove
{
    if (object = undersuit) and (xobject = nothing,player) {
        return perform(&DoTakeOff,undersuit)
    } elseif (object is cuttable or object is rippable) {
        return perform(&DoUnwrap, object, xobject)
    !} elseif (xobject ~= nothing) and (parent(object) = xobject) {
    !    return perform(&DoGet, object, xobject)
    !} elseif (xobject ~= nothing) and (object.found_in = xobject) {
    !    return perform(&DoGet, object, xobject)
    !} elseif (xobject ~= nothing) {
    !    ParseError(14,object)
    } else {
        return perform(&DoGet, object, xobject)
    }
}

!----------------------------------------------------------------------------
routine DoJump
{
    if (object = nothing) {
        "Save your energy."
    } else {
        if not (object.after) {
            PrintMessage(3,6)
        }
    }
    return true !To increment move counter
}

!----------------------------------------------------------------------------
!Give a different response for the general "listen" now.
!
replace DoListen
{
    local r
    if (object = nothing) {
        !!! VMessage(&DoListen, 1)  ! "Be a little more specific..."
        !!! return false
        r = random(5)
        select (r)
        case 1 {
            "Wind whistles around and through distant rocks."
        }
        case 2 {
            "The low rumble of thunder can be heard for a moment."
        }
        case 3 {
            if (creature is alive) {
                if (creature in location) {
                    "You hear the grunting and panting of the creature."
                } else {
                    "You hear metallic, inhuman noises in the distance."
                }
            } else {
                if (location = SiriusDream) {
                    "You hear the harsh snapping and popping of burning wreckage."
                } else {
                    !It should be impossible to be anywhere else and the creature
                    !is dead, but just in case...
                    "Only the wind."
                }
            }
        }
        case 4 {
            "For the moment, all is silent."
        }
        case 5 {
            "At this instant, all you hear is the pounding of your heart."
        }

    } elseif (not object.after) {
        if (object.type = direction) {
            "All you hear in that direction now is ";
            r = random(3)
            select (r)
            case 1 {
                "the distant whistling of the wind."
            }
            case 2 {
                "silence."
            }
            case 3 {
                "a distant rumble of thunder."
            }
        } else {
            VMessage(&DoListen, 2)   ! "Not making any sound..."
        }
    }
    return true
}

!----------------------------------------------------------------------------
!Because we're limiting player's ability to wait.
!
replace DoWaitUntil
{
    "You can't tell the time. You have no way to wait so precisely."
    return false !So MAIN and turns don't take effect!!
}

!----------------------------------------------------------------------------
!Because we're limiting player's ability to wait.
!
replace DoWaitForChar
{
    if (object = creature, fake_creature, dead_creature) {
        if (creature is alive) {
            "It's larger than you, stronger than you, hungrier than
            you, less rational than you -- don't hurry the
            confrontation."
        } else {
            "No need."
        }
    } elseif (object = huchess, covegn) {
        if (object.found_in = location) {
            print capital object.pronouns #1; "'s already here, ";
            if (object is alive) { "unconscious." } else { "dead." }
        } else {
            "If you did that, you might be waiting a very long time."
        }
    } else {
        print "You can't wait for "; The(object); "."
    }
    return false !So MAIN and turns don't take effect!!
}

!----------------------------------------------------------------------------
replace DoWait
{
    if (object ~= 0) {
        Perform(&DoWaitUntil) !Channel it through that.
        return false !Don't advance turns.
    } elseif (creature in location) {
        "And be a sitting duck? ";
        if (huchess.found_in = location) {
            "Even if it's not here for you, why tempt fate?"
        } else {
            "This thing doesn't share your desire to do nothing."
        }
        return false !Don't advance turns.
    } elseif (total_waits >= max_waits) {
        "You've had enough of waiting around to die. Nothing is gained by
        being idle at this point." : return false !Don't advance turns.
    } elseif (waited_last_turn) {
        !"No, you just finished waiting around. Now is no time to become lethargic."
        "You just finished waiting around. ";
        if (creature.misc #7) {
            "A creature is out there. You might be willing to wait longer,
            but it may not, and to do so is a bad idea."
        } else {
            "Something is out there, coming closer. To hurry it along seems
            like a bad idea."
        }
        return false !Don't advance turns.
    } else {
        select (++total_waits)
        case 1 {
            "You take a moment to rest, and time passes..."
        }
        case 2 {
            "Once again, you wait. Time passes..."
        }
        case 3 {
            "Waiting gets you nowhere. Nevertheless, you wait again,
            and time passes..."
        }
        case 4 {
            "You could be using your time more effectively, yet you
            take another moment to rest. Time passes..."
        }
        case 5 {
            "After this, you just can't justify waiting around to die.
            For the last time, you rest..."
        }
        if (location = WestRoom,CrashSite,NorthRoom,RockSite) {
            if (total_waits = 2) {
                if (creature.misc #7) {
                    "\nA creature is out there. It doesn't seem rational, and it
                    doesn't show mercy. Yes, inevitably you may have to face it.
                    But not now. Not yet. To just wait is to give up hope."
                } else {
                    "\nSomething is out there, in the darkness, and it doesn't
                    sound friendly. You are far from Home and unprepared. Better
                    to avoid it this soon, whatever it is, if you can. To just
                    wait for something to happen is to give up all hope."
                }
            } elseif (total_waits = 3,4,5) {
                "\nEven if you can waste time in other ways, to do so would
                be a mistake. You can be brave, without being foolish."
            }
        }
    }

    local count !Because we use it just below here.

    !---------------------------------------------------------------
    ! The rest of this is the orginal VERBLIB.H "DoWait" procedure.
    !---------------------------------------------------------------

    count = WAIT_TURN_COUNT
    !!! VMessage(&DoWait) ! "Time passes..."

	event_flag = 0
    while (--count) {
        main !Run the things that happen during each turn.
		system(32) !(PAUSE_100TH_SECOND)  ! potential updating
		if event_flag
			if not KeepWaiting
                return
	}
	event_flag = 0
    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoRepair
{
    if not CheckReach(object): return false

    if not (xobject.after) {
        if not (object.after) {
            if (xobject = nothing) {
                print CThe(object); " can't be "; word[1]; "ed."
            } else {
                PrintMessage(3,17,xobject) !Can't be used to fix anything.
            }
        }
    }
    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoHelp
{
    did_see_help = true
    "\n\B\UGeneral Advice:\u\b\n"
    indent
    "You'll most likely feel the urge to wait around while things happen
    around you. Don't -- at least, not often. This may seem contrary to what
    you've come to expect, but you'll just have to trust that it's
    counter-productive to surviving this encounter -- even if it's possible
    to waste time in other ways. Equate it to fast-forwarding a mystery to
    find out who-dun-it -- only you won't, and you will have missed all that
    happens in between for no good reason.\n"
    indent
    "If you feel stuck, give thought to what's at hand. Have you checked out
    what's nearby? Do you understand what things are, and why you may or may
    not use those things? Read responses again, to be sure you've picked up
    on built-in cues.\n"
    indent
    "Also, be sure to \BSAVE\b sometimes. The consequence of a splintered
    path forward is that you can put yourself on a no-win plot branch. It's
    designed to be short enough that, even should this happen, catching up
    again won't take long -- and you're likely to know what went wrong.
    You'll always get an ending -- you can't do anything that prevents this
    -- it may just be an ending where you don't survive the night.\n"
    indent
    "You may not survive the first time -- or the second -- but don't make
    the mistake of thinking every seemingly detrimental occurrence is cause
    for an immediate do-over. It may be something intentional, and at any
    rate, going forward may help you improve next time."
    indent
    "\n\B\USpecific Advice:\u\b\n"
    indent
    "If you can, use the general advice above as your guide through this
    encounter. If you feel that the only way forward is a nudge in the right
    direction, three options are available to you:\n"
    indent
    "Type \BHINT\b for a clue. What you've already done and what remains to
    be done is evaluated, and the most appropriate hint is given. At times,
    you may be trying to focus on the wrong thing. This is a good way to
    redirect your efforts, and get that forward nudge.\n"
    indent
    "Type \BHINT OBJECT\b (where \"object\" is something you're holding) to
    get some advice about specific things. This will sometimes go beyond
    what \"you\" as the PC might realistically know, in order to help \"you\"
    as the player get that nudge. Sorry -- hints for scenery, characters, and
    other unheld objects are not available.\n"
    indent
    "Type \BWALKTHRU\b for information about finding and using the complete
    solution to surviving this encounter. Obviously, this may be a last
    resort, but if inclined, use it. When you finish, you might find it
    interesting to check out the walkthrough anyway. Note that typing
    WALKTHRU only gives some information about it -- no hints, tips, or
    spoilers are shown just by typing the command."
}

!----------------------------------------------------------------------------
routine DoHint
{
    if not (did_see_help) {
        "Hints aren't enabled until you have asked for help. Type \BHELP\b to
        see some useful information first, if you feel stuck or uncertain."
        return
    }

    !And now, we try to figure out what the player needs help on.
    if (object ~= nothing) and Contains(player,object) {
        DoHintAbout
    } else {
        DoHintGeneral
    }
}

!----------------------------------------------------------------------------
routine DoTouchOpt
{
    if (terminal in player) {
        if (object >= 1) and (object <= 5) {
            term_option = object !Menu item.
            Perform(&DoTouch,term_screen,xobject)
        } else {
            if (object = 6) {
                "No need. That option is to exit."
            } else {
                "That won't work."
            }
        }
    } else {
        "Nothing to touch."
    }
    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoSwing
{
    if (xobject = nothing) {
        if (not object.after) {
            PrintMessage(3,18,object) !You can't swing the object
        }
    } else {
        if not (xobject.after) {
            if not (xobject.after) {
                print "It does no good to try "; word[1]; "ing ";
                print The(object); " at "; The(xobject); "."
            }
        }
    }
    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoClimb
{
    if not (object.after) {
        if Contains(player,object) {
            PrintMessage(3,18,object) !You can't climb the object.
        }
    }
    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoWake
{
    if (object = nothing, u_obj) {
        "As it happens, you aren't asleep."
    } else {
        if not (object.after) {
            PrintMessage(3,18,object) !You can't wake the object.
        }
    }
    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoPoint
{
    if (xobject = nothing) {
        PrintMessage(1,4,object)
    } else {
        if PlayerHas(object) {
            if not (xobject.after) {
                if not (object.after) {
                    print "You "; word[1]; " "; The(object); " at ";
                    print The(xobject); ", but it accomplishes nothing."
                }
            }
        } else {
            PrintMessage(3,13,object)
        }
    }
}

!----------------------------------------------------------------------------
routine DoMenuOn
{
    if (allow_menus) {
        "The \"animated menu\" option is already on."
    } else {
        "The \"animated menu\" option is now on."
        allow_menus = true
    }
}

!----------------------------------------------------------------------------
routine DoMenuOff
{
    if (allow_menus) {
        "The \"animated menu\" option is now off."
        allow_menus = false
    } else {
        "The \"animated menu\" option is already off."
    }
}

!----------------------------------------------------------------------------
routine DoChase
{
    if (object = nothing) or (not object.after) {
        "You can't. If you want to leave here, try going in a direction."
    }
    return true !To increment move counter
}
