/*
	HETEMP.C

	Win32 DirectShow tempfile manager for the Hugo Engine

	Copyright (c) 1999-2006 by Kent Tessman
*/

#include <windows.h>
#include "hewin32.h"

#define TRANSFER_BLOCK_SIZE 4096


/* CreateResourceCache

	The supplied FILE structure describes a file that is opened
	and positioned; we just have to read length bytes from it
	and write the resource to hTempFile.  (For clarification,
	this function used to be called CreateTemporaryFile.)

	In any case, it returns with the original file pointer CLOSED.
*/

int CreateResourceCache(char *tempfilename, FILE *file, long length)
{
	char temppath[MAX_PATH];
	unsigned char buf[TRANSFER_BLOCK_SIZE];
	size_t bytesread;
	DWORD byteswritten;
	long pos = 0, totalbytes = 0;
	HANDLE hTempFile;

	if ((!GetTempPath(MAX_PATH, temppath)) ||
		!GetTempFileName(temppath, "~hu", 0, tempfilename))
	{
		goto Error;
	}

	hTempFile = CreateFile(
		(LPTSTR)tempfilename,		// filename 
		GENERIC_READ | GENERIC_WRITE,	// open for read-write 
		0,				// do not share 
		NULL,				// no security 
		CREATE_ALWAYS,			// overwrite existing file
		FILE_ATTRIBUTE_NORMAL,		// normal file 
		NULL);				// no attr. template 

	if (hTempFile==INVALID_HANDLE_VALUE) goto Error;

	do 
	{
		bytesread = fread(buf, 1, TRANSFER_BLOCK_SIZE, file);
		if (ferror(file))
		{
			CloseHandle(hTempFile);
			goto Error;
		}

		WriteFile(hTempFile, buf, bytesread, &byteswritten, NULL);
		totalbytes += bytesread;
	}
	while (bytesread==TRANSFER_BLOCK_SIZE && totalbytes < length);

	fclose(file);
	CloseHandle(hTempFile);

	return TRUE;

Error:
	fclose(file);
	MessageBox(wndMain,
		"Unable to create resource cache file.",
		"Hugo Engine",
		MB_ICONEXCLAMATION);
	return FALSE;
}
