/*
 * Decompiled with CFR 0.152.
 */
package iageserver;

import iageserver.AdminListen;
import iageserver.data;
import iageserver.mainframe;
import iageserver.player;
import iageserver.serverlisten;
import iageserver.startupclass;
import iageserver.vdu;
import java.io.File;

public class Server {
    public serverlisten SL = null;
    public String serverstarted = "";
    public boolean serverispublic = false;
    public int serverport = 1111;
    public String server_regip = "";
    public boolean serverisrunning = false;
    public AdminListen theAdminThread;
    public static String spassword = "password";
    public boolean useGUI = false;

    public void parseArgs(String[] args) {
        String gamefile = "";
        try {
            if (args.length == 0) {
                mainframe frame = new mainframe(this);
            } else {
                int i = 0;
                boolean noGuiFound = false;
                while (i < args.length) {
                    if (args[i].equalsIgnoreCase("-nogui")) {
                        noGuiFound = true;
                    }
                    ++i;
                }
                if (!noGuiFound) {
                    mainframe frame = new mainframe(this);
                }
                i = 0;
                while (i < args.length) {
                    if (args[i].indexOf("/") != -1 || args[i].indexOf("\\") != -1) {
                        gamefile = args[i];
                    }
                    if (args[i].equalsIgnoreCase("-nogui")) {
                        vdu.consolemode = true;
                    }
                    if (args[i].toLowerCase().startsWith("-pass:")) {
                        int colpos = args[i].indexOf(":");
                        spassword = args[i].substring(colpos + 1, args[i].length());
                    }
                    if (args[i].toLowerCase().startsWith("-port:")) {
                        int colpos = args[i].indexOf(":");
                        this.serverport = Integer.parseInt(args[i].substring(colpos + 1, args[i].length()));
                    }
                    if (args[i].equalsIgnoreCase("--help") || args[i].equalsIgnoreCase("-help")) {
                        vdu.consolemode = true;
                        vdu.println(data.internalversion);
                        vdu.println();
                        vdu.println();
                        vdu.println("Usage: <java> -jar iageserver.jar [OPTIONS] [IAGE game file]");
                        vdu.println();
                        vdu.println("  --help, -help     Display this help and exit.");
                        vdu.println("  -nogui            Start IAGE server in console only mode.");
                        vdu.println("  -port:<port>      Start IAGE server on the specified TCP port.");
                        vdu.println("  -pass:<password>  Set the server password for remote access.");
                        System.exit(0);
                    }
                    ++i;
                }
            }
            if (!gamefile.equals("")) {
                startupclass.startup(gamefile);
                this.startServer();
            }
            vdu.println(data.internalversion);
            vdu.println();
            this.theAdminThread = new AdminListen(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startServer() {
        if (data.canstartenginenow) {
            vdu.println("Starting engine...");
            this.SL = new serverlisten(this.serverport);
            this.serverispublic = false;
            this.serverisrunning = true;
        } else {
            vdu.println("Bad data - unable to start server.");
        }
    }

    public void stopServer() {
        this.SL.stop();
        this.SL = null;
        int i = 1;
        player p = null;
        while (i <= data.oplayers.getCount()) {
            p = (player)data.oplayers.get(i);
            vdu.Transmit("The server operative stopped the server. You have been disconnected.", p);
            p.quit(true);
            ++i;
        }
        vdu.println("Server stopped at user request.");
        this.serverisrunning = false;
    }

    public void killAdminThread() {
        this.theAdminThread.killThread();
    }

    public void loadGameFile(String filename) {
        startupclass.startup(new File("").getAbsolutePath() + File.separator + filename);
    }
}

