/*
 * Decompiled with CFR 0.152.
 */
package iageserver;

import iageserver.character;
import iageserver.constant;
import iageserver.data;
import iageserver.game;
import iageserver.iagecode;
import iageserver.iagecollection;
import iageserver.interpreter;
import iageserver.item;
import iageserver.location;
import iageserver.message;
import iageserver.namevaluepair;
import iageserver.parsestring;
import iageserver.processor;
import iageserver.serverlistenthread;
import iageserver.vdu;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;

public class player {
    public String Name = "";
    public String DisplayName = "";
    public long Score = 0L;
    public long Turns = 0L;
    public long CurrentLocation = 0L;
    public String IPAddress = "";
    public int Index = 0;
    public byte State = ST_NORMAL;
    public item StateItem = null;
    public long WeightCarried = 0L;
    public long ItemsCarried = 0L;
    public long SizeCarried = 0L;
    public long LastNoun = 0L;
    public String LastNounText = "";
    public boolean CanSee = true;
    public String LastCommand = "";
    public iagecollection LocationsSeen = new iagecollection();
    public boolean VerboseMode = true;
    public Socket PlayerSocketHandle = null;
    public DataInputStream socket_inputstream = null;
    public PrintWriter socket_outputstream = null;
    public serverlistenthread serverthread = null;
    public boolean OutputToPlayer = false;
    public long HitPoints = 0L;
    public long DamageIndicator = 0L;
    public long Money = 0L;
    public long ChanceOfHitting = 60L;
    public iagecollection NameValues = new iagecollection();
    public String CP1 = "";
    public String CP2 = "";
    public String CP3 = "";
    public String CP4 = "";
    public String CP5 = "";
    public String CP6 = "";
    public String CP7 = "";
    public String CP8 = "";
    public String CP9 = "";
    public String CP10 = "";
    public String CP11 = "";
    public String CP12 = "";
    public String CP13 = "";
    public String CP14 = "";
    public String CP15 = "";
    public String CP16 = "";
    public String CP17 = "";
    public String CP18 = "";
    public String CP19 = "";
    public String CP20 = "";
    public String CP21 = "";
    public String CP22 = "";
    public String CP23 = "";
    public String CP24 = "";
    public String CP25 = "";
    public String CP26 = "";
    public String CP27 = "";
    public String CP28 = "";
    public String CP29 = "";
    public String CP30 = "";
    public int AskProgramCounter = 0;
    public String UserResponseToAsk = "";
    public boolean WaitingForAskResponse = false;
    public iagecode AskCode = null;
    public String AskCodeSource = "";
    public interpreter AskInterpreter = null;
    public boolean LastParserAskedQuestion = false;
    public parsestring LastParser = null;
    public int LastQReplacesNoun = 0;
    public static byte ST_NORMAL = 1;
    public static byte ST_SITTING = (byte)2;
    public static byte ST_LYING = (byte)3;
    public static byte ST_STOODON = (byte)4;
    public static byte ST_INSIDE = (byte)5;
    public boolean TextOnly = false;

    public void quit(boolean doitquietly) {
        interpreter ti = new interpreter(this, null);
        ti.runcode(data.ogame.OnQuit, "Game.OnQuit");
        if (!doitquietly) {
            vdu.TransmitAll(processor.smake(message.getMessage(constant.MSG_PLAYERQUIT), this.Name));
        }
        vdu.println("Connection " + Integer.toString(this.Index) + " - " + this.Name + " (" + this.IPAddress + ") has quit.");
        vdu.Transmit("QUIT: DIE|", this);
        item.MoveAll((long)this.Index + location.PLAYERBASE, this.CurrentLocation);
        if (!doitquietly) {
            vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERDROPSTHEIROBJECTS), this.Name), this, this.CurrentLocation);
        }
        try {
            this.serverthread.isFinished = true;
            this.serverthread = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        int i = 1;
        player p = null;
        while (i <= data.oplayers.getCount()) {
            p = (player)data.oplayers.get(i);
            if (p.Index == this.Index) {
                data.oplayers.remove(i);
                break;
            }
            ++i;
        }
        vdu.updateconnectionlist();
    }

    public void MarkLocationAsSeen(long locid) {
        this.LocationsSeen.add(new Long(locid));
    }

    public boolean HasSeenLocation(long locid) {
        int i = 1;
        while (i <= this.LocationsSeen.getCount()) {
            Long id = (Long)this.LocationsSeen.get(i);
            if (id == locid) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void showscore() {
        interpreter ti = new interpreter(this, null);
        ti.runcode(data.ogame.OnScore, "Player(" + Integer.toString(this.Index) + ").OnScore");
    }

    public void showstatus() {
        vdu.Transmit(processor.smake(message.getMessage(constant.MSG_STATUS), Long.toString(this.HitPoints), Long.toString(this.DamageIndicator), Long.toString(this.ChanceOfHitting)), this);
    }

    public void SaveState(String password, String identifier) {
        if (!data.ogame.AllowPersist) {
            vdu.Transmit("You cannot save your position in this game.", this);
            return;
        }
        if (data.ogame.SinglePlayerGame) {
            vdu.Transmit("Saving state for single player game...", this);
        } else {
            vdu.Transmit("Saving state for multi-player game...", this);
        }
        String filenamepath = data.gamepath + "." + this.Name + "_" + identifier + ".state";
        File fh = new File(filenamepath);
        if (fh.exists()) {
            vdu.Transmit("File exists, checking security...", this);
            try {
                FileInputStream in = new FileInputStream(fh);
                String rl = data.readline(in);
                rl = data.readline(in);
                rl = data.readline(in);
                data.isencrypted = true;
                rl = data.decrypt(rl);
                if (!password.equals(rl)) {
                    vdu.Transmit("Security check failed - incorrect password. Save state failed.", this);
                    return;
                }
                vdu.Transmit("Security check passed...", this);
            }
            catch (IOException e) {
                vdu.println("Unable to check security in file: " + filenamepath);
                vdu.Transmit("Unable to read file, save state failed.", this);
                e.printStackTrace();
            }
        }
        try {
            int ic;
            FileOutputStream out = new FileOutputStream(fh);
            this.writelineunencrypted(out, "IAGE 2 SAVE");
            this.writelineunencrypted(out, "1");
            this.writeline(out, password);
            if (data.ogame.SinglePlayerGame) {
                this.writeline(out, "1");
            } else {
                this.writeline(out, "0");
            }
            this.writeline(out, "PLAYER");
            this.writeline(out, "Name = " + this.Name);
            this.writeline(out, "CanSee = " + data.booleanToString(this.CanSee));
            this.writeline(out, "ChanceOfHitting = " + Long.toString(this.ChanceOfHitting));
            this.writeline(out, "CurrentLocation = " + Long.toString(this.CurrentLocation));
            this.writeline(out, "DamageIndicator = " + Long.toString(this.DamageIndicator));
            this.writeline(out, "DisplayName = " + this.DisplayName);
            this.writeline(out, "HitPoints = " + Long.toString(this.HitPoints));
            this.writeline(out, "ItemsCarried = " + Long.toString(this.ItemsCarried));
            this.writeline(out, "Money = " + Long.toString(this.Money));
            this.writeline(out, "Score = " + Long.toString(this.Score));
            this.writeline(out, "SizeCarried = " + Long.toString(this.SizeCarried));
            this.writeline(out, "Turns = " + Long.toString(this.Turns));
            this.writeline(out, "WeightCarried = " + Long.toString(this.WeightCarried));
            this.writeline(out, "CP1 = " + this.CP1);
            this.writeline(out, "CP2 = " + this.CP2);
            this.writeline(out, "CP3 = " + this.CP3);
            this.writeline(out, "CP4 = " + this.CP4);
            this.writeline(out, "CP5 = " + this.CP5);
            this.writeline(out, "CP6 = " + this.CP6);
            this.writeline(out, "CP7 = " + this.CP7);
            this.writeline(out, "CP8 = " + this.CP8);
            this.writeline(out, "CP9 = " + this.CP9);
            this.writeline(out, "CP10 = " + this.CP10);
            this.writeline(out, "CP11 = " + this.CP11);
            this.writeline(out, "CP12 = " + this.CP12);
            this.writeline(out, "CP13 = " + this.CP13);
            this.writeline(out, "CP14 = " + this.CP14);
            this.writeline(out, "CP15 = " + this.CP15);
            this.writeline(out, "CP16 = " + this.CP16);
            this.writeline(out, "CP17 = " + this.CP17);
            this.writeline(out, "CP18 = " + this.CP18);
            this.writeline(out, "CP19 = " + this.CP19);
            this.writeline(out, "CP20 = " + this.CP20);
            this.writeline(out, "CP21 = " + this.CP21);
            this.writeline(out, "CP22 = " + this.CP22);
            this.writeline(out, "CP23 = " + this.CP23);
            this.writeline(out, "CP24 = " + this.CP24);
            this.writeline(out, "CP25 = " + this.CP25);
            this.writeline(out, "CP26 = " + this.CP26);
            this.writeline(out, "CP27 = " + this.CP27);
            this.writeline(out, "CP28 = " + this.CP28);
            this.writeline(out, "CP29 = " + this.CP29);
            this.writeline(out, "CP30 = " + this.CP30);
            int i = 1;
            namevaluepair nv = null;
            while (i <= this.NameValues.getCount()) {
                nv = (namevaluepair)this.NameValues.get(i);
                this.writeline(out, "NV " + nv.Name + " " + nv.Value);
                ++i;
            }
            this.writeline(out, "END");
            if (!data.ogame.SinglePlayerGame) {
                vdu.Transmit("Save successful.", this);
                return;
            }
            location l = null;
            item im = null;
            character cc = null;
            this.writeline(out, "");
            this.writeline(out, "LOCATIONS");
            this.writeline(out, "");
            i = 1;
            while (i <= data.olocations.getCount()) {
                l = (location)data.olocations.get(i);
                this.writeline(out, "ID = " + Long.toString(l.ID));
                this.writeline(out, "Name = " + l.Name);
                this.writeline(out, "ImagePath = " + l.ImagePath);
                this.writeline(out, "Description = " + l.Description);
                this.writeline(out, "IsDark = " + data.booleanToString(l.IsDark));
                this.writeline(out, "CustomProperties = " + l.CustomProperties);
                this.writeline(out, "N = " + Long.toString(l.N));
                this.writeline(out, "S = " + Long.toString(l.S));
                this.writeline(out, "E = " + Long.toString(l.E));
                this.writeline(out, "W = " + Long.toString(l.W));
                this.writeline(out, "U = " + Long.toString(l.U));
                this.writeline(out, "D = " + Long.toString(l.D));
                this.writeline(out, "NE = " + Long.toString(l.NE));
                this.writeline(out, "NW = " + Long.toString(l.NW));
                this.writeline(out, "SE = " + Long.toString(l.SE));
                this.writeline(out, "SW = " + Long.toString(l.SW));
                ic = 1;
                while (ic <= l.NameValues.getCount()) {
                    nv = (namevaluepair)l.NameValues.get(ic);
                    this.writeline(out, "NV " + nv.Name + " " + nv.Value);
                    ++ic;
                }
                if (i < data.olocations.getCount()) {
                    this.writeline(out, "BREAK");
                }
                ++i;
            }
            this.writeline(out, "");
            this.writeline(out, "END");
            this.writeline(out, "");
            this.writeline(out, "ITEMS");
            this.writeline(out, "");
            i = 1;
            while (i <= data.oitems.getCount()) {
                im = (item)data.oitems.get(i);
                this.writeline(out, "ID = " + Long.toString(im.ID));
                this.writeline(out, "Name = " + im.Name);
                this.writeline(out, "CurrentLocation = " + Long.toString(im.CurrentLocation));
                this.writeline(out, "Weight = " + Long.toString(im.Weight));
                this.writeline(out, "Description = " + im.Description);
                this.writeline(out, "CustomProperties = " + im.CustomProperties);
                this.writeline(out, "UserBooleans = " + im.UserBooleans);
                this.writeline(out, "NounID = " + Long.toString(im.NounID));
                this.writeline(out, "IsLightSource = " + data.booleanToString(im.IsLightSource));
                this.writeline(out, "IsLit = " + data.booleanToString(im.IsLit));
                this.writeline(out, "IsWorn = " + data.booleanToString(im.IsWorn));
                this.writeline(out, "IsWeapon = " + data.booleanToString(im.IsWeapon));
                this.writeline(out, "HasSurface = " + data.booleanToString(im.HasSurface));
                this.writeline(out, "CanBeLaidOn = " + data.booleanToString(im.CanBeLaidOn));
                this.writeline(out, "CanBeStoodOn = " + data.booleanToString(im.CanBeStoodOn));
                this.writeline(out, "CanBeSatOn = " + data.booleanToString(im.CanBeSatOn));
                this.writeline(out, "CanBeGotIn = " + data.booleanToString(im.CanBeGotIn));
                this.writeline(out, "DefaultExamine = " + im.DefaultExamine);
                this.writeline(out, "IsContainer = " + data.booleanToString(im.IsContainer));
                this.writeline(out, "IsEdible = " + data.booleanToString(im.IsEdible));
                this.writeline(out, "EdibleHitPoints = " + Long.toString(im.EdibleHitPoints));
                this.writeline(out, "IsWearable = " + data.booleanToString(im.IsWearable));
                this.writeline(out, "IsReadable = " + data.booleanToString(im.IsReadable));
                this.writeline(out, "ReadableText = " + im.ReadableText);
                this.writeline(out, "Size = " + Long.toString(im.Size));
                this.writeline(out, "DamageIndicator = " + Long.toString(im.DamageIndicator));
                this.writeline(out, "Invisible = " + data.booleanToString(im.Invisible));
                this.writeline(out, "IsFixed = " + data.booleanToString(im.IsFixed));
                this.writeline(out, "CanOpenClose = " + data.booleanToString(im.CanOpenClose));
                this.writeline(out, "OpenCloseState = " + data.booleanToString(im.OpenCloseState));
                this.writeline(out, "FixedMessage = " + im.FixedMessage);
                this.writeline(out, "IsSubItem = " + data.booleanToString(im.IsSubItem));
                this.writeline(out, "SubItemOf = " + Long.toString(im.SubItemOf));
                ic = 1;
                nv = null;
                while (ic <= im.NameValues.getCount()) {
                    nv = (namevaluepair)im.NameValues.get(ic);
                    this.writeline(out, "NV " + nv.Name + " " + nv.Value);
                    ++ic;
                }
                if (i < data.oitems.getCount()) {
                    this.writeline(out, "BREAK");
                }
                ++i;
            }
            this.writeline(out, "");
            this.writeline(out, "END");
            this.writeline(out, "");
            this.writeline(out, "CHARACTERS");
            this.writeline(out, "");
            i = 1;
            while (i <= data.ocharacters.getCount()) {
                cc = (character)data.ocharacters.get(i);
                this.writeline(out, "ID = " + Long.toString(cc.ID));
                this.writeline(out, "Name = " + cc.Name);
                this.writeline(out, "CurrentLocation = " + Long.toString(cc.CurrentLocation));
                this.writeline(out, "Description = " + cc.Description);
                this.writeline(out, "NounID = " + Long.toString(cc.NounID));
                this.writeline(out, "TimerInterval = " + Long.toString(cc.TimerInterval));
                this.writeline(out, "DefaultExamine = " + cc.DefaultExamine);
                this.writeline(out, "HitPoints = " + Long.toString(cc.HitPoints));
                this.writeline(out, "DamageIndicator = " + Long.toString(cc.DamageIndicator));
                this.writeline(out, "AutoAttack = " + data.booleanToString(cc.AutoAttack));
                this.writeline(out, "AttackWhenAttacked = " + data.booleanToString(cc.AttackWhenAttacked));
                this.writeline(out, "Money = " + Long.toString(cc.Money));
                ic = 1;
                while (ic <= cc.NameValues.getCount()) {
                    nv = (namevaluepair)cc.NameValues.get(ic);
                    this.writeline(out, "NV " + nv.Name + " " + nv.Value);
                    ++ic;
                }
                if (i < data.ocharacters.getCount()) {
                    this.writeline(out, "BREAK");
                }
                ++i;
            }
            this.writeline(out, "");
            this.writeline(out, "END");
            this.writeline(out, "");
            this.writeline(out, "FLAGS");
            this.writeline(out, "");
            i = 1;
            while (i <= data.maxflags - 1) {
                this.writeline(out, "Index = " + Integer.toString(i));
                this.writeline(out, "Value = " + data.oflags[i].Value);
                if (i < data.maxflags) {
                    this.writeline(out, "BREAK");
                }
                ++i;
            }
            this.writeline(out, "");
            this.writeline(out, "END");
            vdu.Transmit("Save successful.", this);
            game.displaylocation(this);
        }
        catch (IOException e) {
            vdu.println("Unable to write to file: " + filenamepath);
            vdu.Transmit("Unable to write to file, save state failed.", this);
            e.printStackTrace();
        }
    }

    public boolean RestoreState(String password, String identifier) {
        if (!data.ogame.AllowPersist) {
            vdu.Transmit("You cannot restore your position in this game.", this);
            return false;
        }
        String filenamepath = data.gamepath + "." + this.Name + "_" + identifier + ".state";
        File fh = new File(filenamepath);
        if (!fh.exists()) {
            vdu.Transmit("File does not exist - restore state failed.", this);
            return false;
        }
        vdu.Transmit("Found state file, checking security...", this);
        try {
            FileInputStream in = new FileInputStream(fh);
            data.fileeof = false;
            String buff = data.readline(in);
            if (!buff.equalsIgnoreCase("IAGE 2 SAVE")) {
                vdu.Transmit("Bad file format - restore state failed.", this);
                return false;
            }
            buff = data.readline(in);
            data.isencrypted = true;
            buff = data.decrypt(data.readline(in));
            if (!buff.equals(password)) {
                vdu.Transmit("Incorrect password - restore state failed.", this);
                return false;
            }
            vdu.Transmit("Security check passed, restoring position...", this);
            while (!data.fileeof) {
                buff = data.decrypt(data.readline(in));
                if (buff.trim().equalsIgnoreCase("PLAYER")) {
                    this.restoreplayer(in);
                }
                if (buff.trim().equalsIgnoreCase("LOCATIONS")) {
                    this.restorelocations(in);
                }
                if (buff.trim().equalsIgnoreCase("ITEMS")) {
                    this.restoreitems(in);
                }
                if (buff.trim().equalsIgnoreCase("FLAGS")) {
                    this.restoreflags(in);
                }
                if (!buff.trim().equalsIgnoreCase("CHARACTERS")) continue;
                this.restorecharacters(in);
            }
            vdu.Transmit("Restore successful.", this);
            game.displaylocation(this);
            return true;
        }
        catch (IOException e) {
            vdu.Transmit("Unable to read from file - restore state failed.", this);
            e.printStackTrace();
            return false;
        }
    }

    private void restoreplayer(FileInputStream in) {
        String buff = data.decrypt(data.readline(in));
        while (buff.indexOf("END") == -1 && !data.fileeof) {
            if (data.comparebuff(buff, "Name")) {
                this.Name = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CanSee")) {
                this.CanSee = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "ChanceOfHitting")) {
                this.ChanceOfHitting = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "CurrentLocation")) {
                this.CurrentLocation = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "DamageIndicator")) {
                this.DamageIndicator = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "DisplayName")) {
                this.DisplayName = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "HitPoints")) {
                this.HitPoints = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "ItemsCarried")) {
                this.ItemsCarried = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "Money")) {
                this.Money = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "Score")) {
                this.Score = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "SizeCarried")) {
                this.SizeCarried = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "Turns")) {
                this.Turns = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "WeightCarried")) {
                this.WeightCarried = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "CP1")) {
                this.CP1 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP2")) {
                this.CP2 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP3")) {
                this.CP3 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP4")) {
                this.CP4 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP5")) {
                this.CP5 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP6")) {
                this.CP6 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP7")) {
                this.CP7 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP8")) {
                this.CP8 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP9")) {
                this.CP9 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP10")) {
                this.CP10 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP11")) {
                this.CP11 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP12")) {
                this.CP12 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP13")) {
                this.CP13 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP14")) {
                this.CP14 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP15")) {
                this.CP15 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP16")) {
                this.CP16 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP17")) {
                this.CP17 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP18")) {
                this.CP18 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP19")) {
                this.CP19 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP20")) {
                this.CP20 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP21")) {
                this.CP21 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP22")) {
                this.CP22 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP23")) {
                this.CP23 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP24")) {
                this.CP24 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP25")) {
                this.CP25 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP26")) {
                this.CP26 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP27")) {
                this.CP27 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP28")) {
                this.CP28 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP29")) {
                this.CP29 = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CP30")) {
                this.CP30 = data.getpropvalue_string(buff);
            }
            if (buff.trim().startsWith("NV")) {
                parsestring ps = new parsestring(buff, this, " ");
                String valname = (String)ps.vwords.get(2);
                String newval = (String)ps.vwords.get(3);
                this.setNameValue(valname, newval);
            }
            buff = data.decrypt(data.readline(in));
        }
    }

    private void restorelocations(FileInputStream in) {
        location l = null;
        String buff = data.decrypt(data.readline(in));
        while (buff.indexOf("END") == -1 && !data.fileeof) {
            if (data.comparebuff(buff, "ID")) {
                int i = 1;
                long findid = data.getpropvalue_long(buff);
                while (i <= data.olocations.getCount()) {
                    l = (location)data.olocations.get(i);
                    if (l.ID == findid) break;
                    ++i;
                }
            }
            if (data.comparebuff(buff, "Name")) {
                l.Name = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "ImagePath")) {
                l.ImagePath = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "Description")) {
                l.Description = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "IsDark")) {
                l.IsDark = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "N")) {
                l.N = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "S")) {
                l.S = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "E")) {
                l.E = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "W")) {
                l.W = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "U")) {
                l.U = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "D")) {
                l.D = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "NE")) {
                l.NE = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "NW")) {
                l.NW = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "SE")) {
                l.SE = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "SW")) {
                l.SW = data.getpropvalue_long(buff);
            }
            if (buff.trim().startsWith("NV")) {
                parsestring ps = new parsestring(buff, new player(), " ");
                String valname = (String)ps.vwords.get(2);
                String newval = (String)ps.vwords.get(3);
                l.setNameValue(valname, newval);
            }
            buff = data.decrypt(data.readline(in));
        }
    }

    private void restoreitems(FileInputStream in) {
        item im = null;
        String buff = data.decrypt(data.readline(in));
        while (buff.indexOf("END") == -1 && !data.fileeof) {
            if (data.comparebuff(buff, "ID")) {
                int i = 1;
                long findid = data.getpropvalue_long(buff);
                while (i <= data.oitems.getCount()) {
                    im = (item)data.oitems.get(i);
                    if (im.ID == findid) break;
                    ++i;
                }
            }
            if (data.comparebuff(buff, "Name")) {
                im.Name = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CurrentLocation")) {
                im.CurrentLocation = data.getpropvalue_long(buff);
            }
            if (im != null && im.CurrentLocation > location.PLAYERBASE && im.CurrentLocation < location.CONTAINERBASE) {
                im.CurrentLocation = location.PLAYERBASE + (long)this.Index;
            }
            if (data.comparebuff(buff, "Weight")) {
                im.Weight = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "Description")) {
                im.Description = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "UserBooleans")) {
                im.UserBooleans = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "NounID")) {
                im.NounID = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "IsLightSource")) {
                im.IsLightSource = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "IsLit")) {
                im.IsLit = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "IsWorn")) {
                im.IsWorn = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "IsWeapon")) {
                im.IsWeapon = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "HasSurface")) {
                im.HasSurface = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "CanBeLaidOn")) {
                im.CanBeLaidOn = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "CanBeStoodOn")) {
                im.CanBeStoodOn = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "CanBeGotIn")) {
                im.CanBeGotIn = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "CanBeSatOn")) {
                im.CanBeSatOn = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "DefaultExamine")) {
                im.DefaultExamine = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "IsContainer")) {
                im.IsContainer = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "IsEdible")) {
                im.IsEdible = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "EdibleHitPoints")) {
                im.EdibleHitPoints = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "IsWearable")) {
                im.IsWearable = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "IsReadable")) {
                im.IsReadable = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "ReadableText")) {
                im.ReadableText = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "Size")) {
                im.Size = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "DamageIndicator")) {
                im.DamageIndicator = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "Invisible")) {
                im.Invisible = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "IsFixed")) {
                im.IsFixed = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "CanOpenClose")) {
                im.CanOpenClose = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "FixedMessage")) {
                im.FixedMessage = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "IsSubItem")) {
                im.IsSubItem = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "SubItemOf")) {
                im.SubItemOf = data.getpropvalue_long(buff);
            }
            if (buff.trim().startsWith("NV")) {
                parsestring ps = new parsestring(buff, new player(), " ");
                String valname = (String)ps.vwords.get(2);
                String newval = (String)ps.vwords.get(3);
                im.setNameValue(valname, newval);
            }
            buff = data.decrypt(data.readline(in));
        }
    }

    private void restorecharacters(FileInputStream in) {
        character cc = null;
        String buff = data.decrypt(data.readline(in));
        while (buff.indexOf("END") == -1 && !data.fileeof) {
            if (data.comparebuff(buff, "ID")) {
                int i = 1;
                long findid = data.getpropvalue_long(buff);
                while (i <= data.ocharacters.getCount()) {
                    cc = (character)data.ocharacters.get(i);
                    if (cc.ID == findid) break;
                    ++i;
                }
            }
            if (data.comparebuff(buff, "Name")) {
                cc.Name = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "CurrentLocation")) {
                cc.CurrentLocation = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "Description")) {
                cc.Description = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "NounID")) {
                cc.NounID = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "TimerInterval")) {
                cc.TimerInterval = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "DefaultExamine")) {
                cc.DefaultExamine = data.getpropvalue_string(buff);
            }
            if (data.comparebuff(buff, "HitPoints")) {
                cc.HitPoints = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "DamageIndicator")) {
                cc.DamageIndicator = data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "AutoAttack")) {
                cc.AutoAttack = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "AttackWhenAttacked")) {
                cc.AttackWhenAttacked = data.getpropvalue_boolean(buff);
            }
            if (data.comparebuff(buff, "Money")) {
                cc.Money = data.getpropvalue_long(buff);
            }
            if (buff.trim().startsWith("NV")) {
                parsestring ps = new parsestring(buff, new player(), " ");
                String valname = (String)ps.vwords.get(2);
                String newval = (String)ps.vwords.get(3);
                cc.setNameValue(valname, newval);
            }
            buff = data.decrypt(data.readline(in));
        }
    }

    private void restoreflags(FileInputStream in) {
        int flagindex = 1;
        String buff = data.decrypt(data.readline(in));
        while (buff.indexOf("END") == -1 && !data.fileeof) {
            if (data.comparebuff(buff, "index")) {
                flagindex = (int)data.getpropvalue_long(buff);
            }
            if (data.comparebuff(buff, "Value")) {
                data.oflags[flagindex].Value = data.getpropvalue_string(buff);
            }
            buff = data.decrypt(data.readline(in));
        }
    }

    private void writeline(FileOutputStream out, String s) {
        s = data.encrypt(s);
        byte[] ba = s.getBytes();
        try {
            out.write(ba);
            byte[] bb = new byte[]{13, 10};
            out.write(bb);
        }
        catch (Exception e) {
            e.printStackTrace();
            vdu.println("Error writing to file - " + e.getMessage());
        }
    }

    private void writelineunencrypted(FileOutputStream out, String s) {
        byte[] ba = s.getBytes();
        try {
            out.write(ba);
            byte[] bb = new byte[]{13, 10};
            out.write(bb);
        }
        catch (Exception e) {
            e.printStackTrace();
            vdu.println("Error writing to file - " + e.getMessage());
        }
    }

    public String getNameValue(String valname) {
        int ic = 1;
        namevaluepair nv = null;
        while (ic <= this.NameValues.getCount()) {
            nv = (namevaluepair)this.NameValues.get(ic);
            if (nv.Name.equalsIgnoreCase(valname)) {
                return nv.Value;
            }
            ++ic;
        }
        return "0";
    }

    public void setNameValue(String valname, String newval) {
        int ic = 1;
        namevaluepair nv = null;
        while (ic <= this.NameValues.getCount()) {
            nv = (namevaluepair)this.NameValues.get(ic);
            if (nv.Name.equalsIgnoreCase(valname)) {
                nv.Value = newval;
                return;
            }
            ++ic;
        }
        nv = new namevaluepair();
        nv.Name = valname;
        nv.Value = newval;
        this.NameValues.add(nv);
    }

    public void askParserQuestion(parsestring p, int nounToReplace) {
        this.LastParser = p;
        this.LastQReplacesNoun = nounToReplace;
        this.LastParserAskedQuestion = true;
    }
}

