package iageclient;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;
import java.util.*;

public class iageconnector {

	// Private members
	private Socket Con;
	private DataInputStream in;
	private PrintWriter out;
	private Label location;
	private Label score;
	private Displayer txttextonly;
	private PreOutput outputter;
	private boolean needsupdate;
	public gameframe formref;
	private listenthread lp;
	private boolean isconnected = false;
	public String cumulativeoutput = "";
	public String transcriptoutput = "";
	public byte turnsonscreen = 0;
	
	// Constants
	static String Version = "Version 020709";
	static String CopyrightMessage = "<b>Internet Adventure Game Engine Client</b><br>" + Version + "<br><i>Copyright(c)2000-2002, R.Rawson-Tetley</i><br><br>";
	
	// How many milliseconds to wait between parsing buffer chunks. 
	// This simulates older computers and actually makes games nicer
	// to play.
	static long delayValue = 0;
	
	public iageconnector (Displayer TextOnlyReference,
						  Label LocationReference, 
						  Label ScoreReference, 
						  Label StatusReference,
						  gameframe FormReference,
						  String IPAddress, 
						  String salias) {

		txttextonly = TextOnlyReference;
	    location = LocationReference;
	    score = ScoreReference;
	    formref = FormReference;

		// Create our outputter
		outputter = new PreOutput(txttextonly, StatusReference);
		outputter.start();
	
	    // Attempt to connect to the IP specified
	    try {
			OutputText(CopyrightMessage);
			
			// Parse the IP address - if there is a :xxxx on the
			// end, connect on that port, otherwise assume the
			// default of 1111
			int sep = IPAddress.indexOf(":");
			int port = 1111;
			
			if (sep != -1) {
				port = Integer.parseInt(IPAddress.substring(sep + 1, IPAddress.length()));
				IPAddress = IPAddress.substring(0, sep);
			}
			
			Con = new Socket(IPAddress, port);
			
			
			out = new PrintWriter(Con.getOutputStream(), true);
			in = new DataInputStream(Con.getInputStream());
			isconnected = true;
	    }
		catch(Exception e) {
			OutputText("Error attempting connection to " + IPAddress + ": " + e.getMessage());
			e.printStackTrace();
			formref.setTitle("IAGE Client (disconnected)");
			formref.allowConnect();
			return;
	    }
	    
	    // Inform of successful connect
	    OutputText("Successfully connected to " + IPAddress);
	    formref.setTitle("IAGE Client (connected to " + IPAddress + ")");
	    formref.disallowConnect();
	
	    // Start our listen process
	    lp = new listenthread(Con, in, out, this);
	
	    // Transmit startup request code
	    Send("setalias " + salias + ". run_on_start", true);
	    
	}

	/** Output to screen - will be picked up by updater prog */
	public void OutputText(String s) {
		
		outputter.Output(s);
		formatForTranscript(s);

	}
	
  
	/** Look for special strings, process them and output them */
	public void PreProcessAndOutput(String s) {
	
		String rs = s; // Latest version of string
		int start;
		int end;
		String firstpart;
		String secondpart;
		String paramvalue;
		String curfindstring;
		boolean hastitle = false;
		String titletext = "";
		final int seplen = 1; // Length of special command separator - at present |<br>
		
		boolean foundsomething = true;
	
		// Keep looping round parsing bits until we are sure
		// we have done everything
		while (foundsomething) {
	
			foundsomething = false;
	
			// SETSCREEN
			curfindstring = "SETSCREEN: ";
			if (rs.indexOf(curfindstring) > 0) {
				
				start = rs.indexOf(curfindstring);
				end = rs.indexOf("|", start);
				paramvalue = rs.substring(start + curfindstring.length(), end);
				
				// Manipulate screen
	                        
				
				
				// Remove from text
				firstpart = rs.substring(0, start);
				secondpart = rs.substring(end + seplen, rs.length()); 
				rs = firstpart + secondpart;
				foundsomething = true;
				
			}
			
			// TITLE
			curfindstring = "TITLE: ";
			if (rs.indexOf(curfindstring) > 0) {
				
				start = rs.indexOf(curfindstring);
				end = rs.indexOf("|", start);
				paramvalue = rs.substring(start + curfindstring.length(), end);
				
				// Set the title
				location.setText(paramvalue);
				
				// Remove from text
				firstpart = rs.substring(0, start);
				secondpart = rs.substring(end + seplen, rs.length());
				rs = firstpart + secondpart;
				
				hastitle = true;
				titletext = secondpart;
	            foundsomething = true;
			}
					
			// IMAGE
			curfindstring = "IMAGE: ";
			if (rs.indexOf(curfindstring) > 0) {
				
				start = rs.indexOf(curfindstring);
				end = rs.indexOf("|", start);
				paramvalue = rs.substring(start + curfindstring.length(), end);
					
				// Remove from text
				firstpart = rs.substring(0, start);
				secondpart = rs.substring(end + seplen, rs.length());
				rs = firstpart + secondpart;
				foundsomething = true;
				
			}
			
			
			// MIDI
			curfindstring = "MIDI: ";
			if (rs.indexOf(curfindstring) > 0) {
				
				start = rs.indexOf(curfindstring);
				end = rs.indexOf("|", start);
				paramvalue = rs.substring(start + curfindstring.length(), end);
				
				// Play MIDI
				try {
	
					URL img = new URL(paramvalue);
	
					// Play the tune
	                //AudioClip mc = Applet.getAudioClip(img);
	                //mc.play();
	
				}
				catch(MalformedURLException e) {
					OutputText("Bad URL: " + e.getMessage());
				}
	            catch(IOException e) {
	                    OutputText("Could not use MIDI: " + paramvalue);
	            }
	
	
				// Remove from text
				firstpart = rs.substring(0, start);
				secondpart = rs.substring(end + seplen, rs.length()); 
				rs = firstpart + secondpart;
				foundsomething = true;
	
			}
	
			// MOVIE
			curfindstring = "MOVIE: ";
			if (rs.indexOf(curfindstring) > 0) {
	
				start = rs.indexOf(curfindstring);
				end = rs.indexOf("|", start);
				paramvalue = rs.substring(start + curfindstring.length(), end);
	
				// Play Movie
	
	
				// Remove from text
				firstpart = rs.substring(0, start);
				secondpart = rs.substring(end + seplen, rs.length()); 
				rs = firstpart + secondpart;
				foundsomething = true;
				
			}
			
			
			// SOUND
			curfindstring = "SOUND: ";
			if (rs.indexOf(curfindstring) > 0) {
				
				start = rs.indexOf(curfindstring);
				end = rs.indexOf("|", start);
				paramvalue = rs.substring(start + curfindstring.length(), end);
				
				// Play sound
				try {
	
					URL img = new URL(paramvalue);
	
					// Play the tune
	                //AudioClip so = Applet.getAudioClip(img);
	                //so.play();
	
				}
				catch(MalformedURLException e) {
					OutputText("Bad URL: " + e.getMessage());
				}
	            catch(IOException e) {
	                OutputText("Could not use sound: " + paramvalue);
	            }
	
				// Remove from text
				firstpart = rs.substring(0, start);
				secondpart = rs.substring(end + seplen, rs.length()); 
				rs = firstpart + secondpart;
				foundsomething = true;
				
			}
			
			// URL
			curfindstring = "URL: ";
			if (rs.indexOf(curfindstring) > 0) {
				
				start = rs.indexOf(curfindstring);
				end = rs.indexOf("|", start);
				paramvalue = rs.substring(start + curfindstring.length(), end);
				
				// Open browser with URL
				
				
				// Remove from text
				firstpart = rs.substring(0, start);
				secondpart = rs.substring(end + seplen, rs.length()); 
				rs = firstpart + secondpart;
				foundsomething = true;
				
			}
			
			// SCORE
			curfindstring = "SCORE: ";
			if (rs.indexOf(curfindstring) > 0) {
				
				start = rs.indexOf(curfindstring);
				end = rs.indexOf("|", start);
				paramvalue = rs.substring(start + curfindstring.length(), end);
				
				// Set the score
				score.setText(paramvalue);
				
				// Remove from text
				firstpart = rs.substring(0, start);
				secondpart = rs.substring(end + seplen, rs.length()); 
				rs = firstpart + secondpart;
				foundsomething = true;
				
			}
			
			// QUIT THE CLIENT
			curfindstring = "QUIT: DIE";
			if (rs.indexOf(curfindstring) > 0) {
				
				start = rs.indexOf(curfindstring);
				end = rs.indexOf("|", start);
				paramvalue = rs.substring(start + curfindstring.length(), end);
				
				// Kill everything
				this.Kill();
				
				// Remove from text
				firstpart = rs.substring(0, start);
				secondpart = rs.substring(end + seplen, rs.length()); 
				rs = firstpart + secondpart;
				foundsomething = true;
				
			}
		}
	
		// If there's anything left, output it
		if (rs.length() > 4) {
			OutputText(rs);
		}
	}
	
	/** Close connection from server */
	public void Kill() {
		// Tell the server this player quit
		Send("quit", true);
		// Tell the listening thread that it's work is done
		lp.isFinished = true;
		isconnected = false;
		// Clear our socket references to be picked up
		// for garbage collection
		out = null;
		in = null;
		Con = null;
		// Show we are disconnected
		formref.setTitle("IAGE Client (disconnected)");
		formref.allowConnect();
		// Kill off the preoutputter's thread
		outputter.stopThread();
	}

	/** Transmit text down the pipe and echo to screen */
	public void Send(String s, boolean BeQuiet) {

		if (!isconnected) return;
		
		// Display on screen
		if (!BeQuiet) {
			OutputText("<br><br>--> " + s);
		}
		out.write(s + ".getscore");
		out.flush();
	}
	  
	public synchronized String getOutput() {
		return cumulativeoutput;
	}
	
	public synchronized void setOutput(String s) {
		cumulativeoutput = s;
	}

	public synchronized boolean getNeedsUpdate() {
		return needsupdate;
	}
	
	public synchronized void setNeedsUpdate(boolean b) {
		needsupdate = b;
	}
	
	/*** Takes the text passed in, strips all HTML and formatting
	     and converts it to plain text. It then stores it in
	     the transcriptoutput variable so it can be saved to a file
	     or used in a scrollback window */
	public void formatForTranscript(String s) {
		
		String mess = new String(s);
		
		// Strip html formatting from the string
	 	mess = replace(mess, "&nbsp;", " ");
	 	mess = replace(mess, "<br>", "\n");
	 	mess = removehtml(mess);
	 	
	 	transcriptoutput = transcriptoutput + mess;
		
	}
	
	private String replace(String findin, String find, String replacewith) {
	
		String sb = findin;
		int i = 0;
			
		while (i <= sb.length() - find.length()) {
			if (sb.substring(i, i + find.length()).equalsIgnoreCase(find)) {
				
				StringBuffer nsb = new StringBuffer(sb);
				sb = stringbuffreplace(nsb, i, i + find.length(), replacewith).toString();
				
			}
			i++;
		}
		return sb.toString();
	}
	
	/** Because the string buffer replace method does not exist in 1.1 (which
	  * most browsers support, I have had to implement my own version of it). */
	private StringBuffer stringbuffreplace(StringBuffer sb, int start, int end, String replacewith) {
	
		String thebuff = sb.toString(); // convert buff to string
		String firstchunk = thebuff.substring(0, start); // get left side before replace
		String secondchunk = thebuff.substring(end, sb.length()); // get right side after replace
		String output = firstchunk + replacewith + secondchunk; // build new string
		sb = new StringBuffer(output); // return it
		return sb;
		
	}
	
	/*** Finds < in strings and throws away everything upto and including the >
	   */
	private String removehtml(String s) {
		
		int i = 0;
		boolean oktoadd = true;
		String output = "";
		
		while (i <= s.length() - 1) {
		
			if (s.substring(i, i + 1).equals("<")) {
				oktoadd = false;
			}
			if (s.substring(i, i + 1).equals(">")) {
				i++;
				oktoadd = true;
			}
			if (oktoadd && i <= s.length() - 1)
				output = output + s.substring(i, i + 1);
				
			i++;				
		}
		
		return output;
		
	}
	
	

}
