package iagecompiler;


/**
 * Collection class used to hold lines of code as 
 * individual strings.
 */
public class iagecode {

  // Used to group lines of code together nicely.
  // Same as iagecollection but for strings

  private String[] obs = new String[0];
  private int numincollection = 0;

  /** Adds a line to the collection */
  public int add(String o) {
    // Adds the specified object to the collection
    if (numincollection == 0) {
      obs = new String[2];
      obs[1] = o;
      numincollection = 1;
      return 1;
    }
    else
    {
      numincollection = numincollection + 1;
      // Create a new array with one more bound than the previous
      String[] ob2 = new String[numincollection + 1];
      // Add in all references from the main array
      int i = 0;
      while (i < numincollection) {
        ob2[i] = obs[i];
        i++;
      }
      // Add our new object
      ob2[i] = o;
      // Assign the new array to the old array
      obs = ob2;
      // return
      return i;
    }
  }

  /** Retrieves a line from the collection */
  public String get(int index) {
    // Returns the object with that index
    return obs[index];
  }
  
  public void set(int index, String ob) {
  	obs[index] = ob;
  }

  /** Removes a line from the collection.
    * Note that when a line is removed, the remainder are 
    * re-ordered and reindexed.
    */
  public void remove(int index) {
    // Removes the object with that index and re-orders
    int i = index;
    while (i < numincollection) {
      obs[i] = obs[i + 1];
      i++;
    }
    numincollection--;
  }

  /** Returns the number of lines in the collection */
  public int getCount() {
    return numincollection;
  }

}