package iagecompiler;


import java.io.*;

/** Routines to import from z inform source */
public class importz extends importer {

	public String ObjectName = "";
	public String ObjectAlias = "";
	public String Description = "";
	public String InitialDescription = "";
	public String Article = "";
	
	public iagecollection Nouns = new iagecollection();
	
	public String North = "";
	public String South = "";
	public String East = "";
	public String West = "";
	public String Up = "";				 // Anything having any one of these is a location
	public String Down = "";
	public String NorthEast = "";
	public String NorthWest = "";
	public String SouthEast = "";
	public String SouthWest = "";
	
	public boolean IsStatic = false;
	public boolean IsScenery = false;
	public boolean HasLight = false;
	public boolean IsOpenable = false;
	public boolean IsContainer = false;
	public boolean IsOpen = false;
	public boolean IsEnterable = false;
	public boolean IsTransparent = false;
	public boolean IsEdible = false;
	public boolean IsWearable = false;
	public boolean IsWorn = false;
	public boolean IsSwitchable = false;
	public boolean IsAnimate = false;     // NPC flag
	public boolean IsDoor = false;
	public boolean IsLockable = false;
	public boolean IsLocked = false;
	
	public long LastIAGEItemImported = 0;
	public long LastIAGELocationImported = 0;
	public long LastIAGENPCImported = 0;
	public boolean LastObjectWasNPC = false;
	public int ObjectContainedType = 0; // 0 = limbo, 1 = location, 2 = object, 3 = NPC
	public long ObjectContainer = 0;
	
	public boolean HadFirstObjYet = false;
	public iagecollection ObjectWords = new iagecollection();

	public importz() {
		super();
	}

	public void parse(FileInputStream in) {
	
		String nword = "";
		HadFirstObjYet = false;
		ObjectWords.add("Object");
		ObjectWords.add("Nearby");
	
		while (!fileeof) {

			// Read a word at a time and see if we hit one of our
			// "trigger" words.
			nword = readnextword(in);
			
			// If it is a Class definition, then add that to the list of
			// things that qualify as an object.
			if (nword.equalsIgnoreCase("Class")) {
				nword = readnextword(in);
				ObjectWords.add(nword);
				nword = readnextword(in);
			}
			
			// If it is an "Object", then we should save our
			// last object if we have one and reset our
			// variables ready for a new one.
			if (IsObjectWord(nword)) {
				
				//System.out.println("Found object");
				
				if (HadFirstObjYet) saveobj();
				clearvars();	
				HadFirstObjYet = true;		
				
				// The next thing we should be expecting is:
				// -> object is in the last location
				// -> -> object is in the last object
				
				// then..
				// <<alias>> the object's alias
				
				nword = readnextword(in);
				
				if (nword.equals("->")) {
					// This object is inside something!
					
					nword = readnextword(in);
					if (nword.equals("->")) {
						
						// It's the last object!
						ObjectContainedType = 2;
						ObjectContainer = LastIAGEItemImported;
						
						// move to the next word - it is it's alias
						nword = readnextword(in);
						
					}
					else
					{
						// It's the last location!
						ObjectContainedType = 1;
						ObjectContainer = LastIAGELocationImported;
					}
				}
			
				// When we plop out here, nword should now be holding
				// the object's alias.
				ObjectAlias = nword;
				
				// Now we should have the object's name following it's alias
				ObjectName = readstringnows(in);
				
				//System.out.println("Alias: " + ObjectAlias + " - Name: " + ObjectName);
				
				// Pull out our next word and keep on going
				nword = readnextword(in);
			
			}
			
			// Now, we should watch for object attributes:
			// =====================================================
			
			// Initial Description
			if (nword.equalsIgnoreCase("initial")) {
				InitialDescription = readstringnows(in);
			}
			
			// Description
			if (nword.equalsIgnoreCase("description")) {
				Description = readstringnows(in);	
			}
			
			// Nouns
			if (nword.equalsIgnoreCase("name")) {
				boolean lastnoun = false;
			
				// Keep getting and adding nouns until we find one with a comma
				// in it
				while (!lastnoun) {
					
					nword = readnextword(in);
					
					// Throw away delimiters
					if (nword.length() > 1) {
						nword = nword.substring(1, nword.length() - 1);
						
						// If there is still a delimter on the end, throw that as well
						// because there must have been a comma
						if (nword.indexOf("\"") != -1 || nword.indexOf("'") != -1) {
							nword = nword.substring(0, nword.length() - 1);
							lastnoun = true;
						}
						
						Nouns.add(nword);
					}
					else
					{
						// Something has gone a bit awry - drop out
						lastnoun = true;
					}
				}
			}
			
			
			// Compass directions
			if (nword.equalsIgnoreCase("n_to")) {
				nword = readnextword(in);
				North = nword;				
			}
			if (nword.equalsIgnoreCase("s_to")) {
				nword = readnextword(in);
				South = nword;				
			}
			if (nword.equalsIgnoreCase("e_to")) {
				nword = readnextword(in);
				East = nword;				
			}
			if (nword.equalsIgnoreCase("w_to")) {
				nword = readnextword(in);
				West = nword;				
			}
			if (nword.equalsIgnoreCase("u_to")) {
				nword = readnextword(in);
				Up = nword;				
			}
			if (nword.equalsIgnoreCase("d_to")) {
				nword = readnextword(in);
				Down = nword;				
			}
			if (nword.equalsIgnoreCase("ne_to")) {
				nword = readnextword(in);
				NorthEast = nword;				
			}
			if (nword.equalsIgnoreCase("nw_to")) {
				nword = readnextword(in);
				NorthWest = nword;				
			}
			if (nword.equalsIgnoreCase("se_to")) {
				nword = readnextword(in);
				SouthEast = nword;				
			}
			if (nword.equalsIgnoreCase("sw_to")) {
				nword = readnextword(in);
				SouthWest = nword;				
			}
			
			if (nword.equalsIgnoreCase("article")) {
				Article = readstringnows(in);
			}
			
			
			
			// Object Attributes
			if (nword.equalsIgnoreCase("static")) {
				IsStatic = true;
			}			
			if (nword.equalsIgnoreCase("scenery")) {
				IsScenery = true;
			}			
			if (nword.equalsIgnoreCase("light")) {
				HasLight = true;
			}			
			if (nword.equalsIgnoreCase("openable")) {
				IsOpenable = true;
			}			
			if (nword.equalsIgnoreCase("open")) {
				IsOpen = true;
			}		
			if (nword.equalsIgnoreCase("container")) {
				IsContainer = true;
			}			 	
			if (nword.equalsIgnoreCase("enterable")) {
				IsEnterable = true;
			}
			if (nword.equalsIgnoreCase("transparent")) {
				IsTransparent = true;
			}			
			if (nword.equalsIgnoreCase("edible")) {
				IsEdible = true;
			}			
			if (nword.equalsIgnoreCase("wearable")) {
				IsWearable = true;
			}			
			if (nword.equalsIgnoreCase("worn")) {
				IsWorn = true;
			}		
			if (nword.equalsIgnoreCase("switchable")) {
				IsSwitchable = true;
			}				
			if (nword.equalsIgnoreCase("animate")) {
				IsAnimate = true;
			}			
			if (nword.equalsIgnoreCase("door")) {
				IsDoor = true;
			}		
			if (nword.equalsIgnoreCase("lockable")) {
				IsLockable = true;
			}			
			if (nword.equalsIgnoreCase("locked")) {
				IsLocked = true;
			}				
		}
		
		// Save the last object
		saveobj();
		
		// Consolidate location paths
		domap();

	}	
	
	/*** Saves the object to IAGE according to what properties
	   * have been set */
	private void saveobj() {
		
		int ObjectType = 1; // 1 = item, 2 = npc, 3 = location
		
		// Determine what kind of object we are dealing with first:
		// =========================================================
		
		if (IsAnimate) {
			ObjectType = 2;	
		}
		if (!North.equals("") ||
			!South.equals("") ||
			!East.equals("") ||
			!West.equals("") ||
			!Up.equals("") ||
			!Down.equals("") ||
			!NorthEast.equals("") ||
			!NorthWest.equals("") ||
			!SouthEast.equals("") ||
			!SouthWest.equals("")) {		
			ObjectType = 3;		
		}

		// Sorted - we have our object type now - lets do it!
		// ===================================================
		
		// Location
		if (ObjectType == 3) {
			
			//System.out.println("Saving Location " + ObjectName);
			
			location l = new location();
			
			l.ID = data.olocations.getCount() + 1;
			l.Name = ObjectName;
			l.Description = Description;
			l.IsDark = !HasLight;
			
			// Store alias in imagepath - we can use this for looking up
			// directions.
			l.ImagePath = ObjectAlias;
			
			// Store our directional paths in the iagecode for later
			if (!North.equals("")) {
				l.OnInput.add("n " + North);	
			}
			if (!South.equals("")) {
				l.OnInput.add("s " + South);	
			}
			if (!East.equals("")) {
				l.OnInput.add("e " + East);	
			}
			if (!West.equals("")) {
				l.OnInput.add("w " + West);	
			}
			if (!Up.equals("")) {
				l.OnInput.add("u " + Up);	
			}
			if (!Down.equals("")) {
				l.OnInput.add("d " + Down);	
			}
			if (!NorthEast.equals("")) {
				l.OnInput.add("ne " + NorthEast);	
			}
			if (!NorthWest.equals("")) {
				l.OnInput.add("nw " + NorthWest);	
			}
			if (!SouthEast.equals("")) {
				l.OnInput.add("se " + SouthEast);	
			}
			if (!SouthWest.equals("")) {
				l.OnInput.add("sw " + SouthWest);	
			}
			
			// Remember the last location
			LastIAGELocationImported = l.ID;
			
			// Append it into our list
			data.olocations.add(l);
			
		}
		
		// NPC	
		if (ObjectType == 2) {
		
			//System.out.println("Saving NPC " + ObjectName);
		
			character cc = new character();
			
			cc.ID = data.ocharacters.getCount() + 1;
			
			cc.Name = ObjectName;
			cc.Description = InitialDescription;
			cc.DefaultExamine = Description;
		
			// Work out where it is supposed to be
			if (ObjectContainedType == 1) {
				// It's a location
				cc.CurrentLocation = ObjectContainer;
			}
		
			// Sort out nouns for this NPC now
			int i = 1;
			String no = "";
			noun n = null;
			while (i <= Nouns.getCount()) {
				no = (String) Nouns.get(i);
				n = new noun();
				n.ID = cc.ID + 3000;
				n.Text = no;
				data.onouns.add(n);
				i++;
			}
			cc.NounID = cc.ID + 3000;
		
			LastIAGENPCImported = cc.ID;
			data.ocharacters.add(cc);
			LastObjectWasNPC = false;	
		}
		
		// Item
		if (ObjectType == 1) {
			
			//System.out.println("Saving item " + ObjectName);
			
			item im = new item();
			
			im.ID = data.oitems.getCount() + 1;
			
			if (Article.equals("")) {
				if (ObjectName.substring(0, 1).equalsIgnoreCase("a") ||
				    ObjectName.substring(0, 1).equalsIgnoreCase("e") ||
				    ObjectName.substring(0, 1).equalsIgnoreCase("i") ||
				    ObjectName.substring(0, 1).equalsIgnoreCase("o") ||
				    ObjectName.substring(0, 1).equalsIgnoreCase("u")) 
				    Article = "an";
				else
					Article = "a";
			}
					
			im.Name = Article + " " + ObjectName;
			im.Description = InitialDescription;
			im.DefaultExamine = Description;
			im.IsFixed = IsStatic;
			im.FixedMessage = "That's fixed in place.";
			im.IsFixed = IsScenery;
			im.IsLit = HasLight;
			im.CanOpenClose = IsOpenable;
			im.OpenCloseState = IsOpen;
			im.CanBeGotIn = IsEnterable;
			im.IsEdible = IsEdible;
			im.IsWearable = IsWearable;
			im.IsWorn = IsWorn;
			im.IsLightSource = IsSwitchable;
			im.IsContainer = IsContainer;
			
			if (IsLocked) im.UserBooleans = "locked";
			
			// Work out where it is supposed to be
			if (ObjectContainedType == 1) {
				// It's a location
				im.CurrentLocation = ObjectContainer;
			}
			if (ObjectContainedType == 2) {
				// It's another object
				im.CurrentLocation = location.CONTAINERBASE + ObjectContainer;
			}
			if (ObjectContainedType == 3) {
				// It's an NPC
				im.CurrentLocation = location.NPCBASE + ObjectContainer;
			}
			
			// Sort out nouns for this item now
			int i = 1;
			String no = "";
			noun n = null;
			while (i <= Nouns.getCount()) {
				no = (String) Nouns.get(i);
				n = new noun();
				n.ID = im.ID + 1000;
				n.Text = no;
				data.onouns.add(n);
				i++;
			}
			im.NounID = im.ID + 1000;
			
			LastIAGEItemImported = im.ID;
			data.oitems.add(im);
			LastObjectWasNPC = false;
		}

		
		
		
	}
	
	/*** Clears vars ready for a new object */
	private void clearvars() {
		
		ObjectName = "";
		ObjectAlias = "";
		Description = "";
		InitialDescription = "";
		Article = "";
		
		Nouns = new iagecollection();
		
		North = "";
		South = "";
		East = "";
		West = "";
		Up = "";
		Down = "";
		NorthEast = "";
		NorthWest = "";
		SouthEast = "";
		SouthWest = "";
		
		IsStatic = false;
		IsScenery = false;
		HasLight = false;
		IsOpenable = false;
		IsContainer = false;
		IsOpen = false;
		IsEnterable = false;
		IsTransparent = false;
		IsEdible = false;
		IsWearable = false;
		IsWorn = false;
		IsSwitchable = false;
		IsAnimate = false;   
		IsDoor = false;
		IsLockable = false;
		IsLocked = false;
		
	}

	public boolean IsObjectWord(String s) {
		
		int i = 1;
		String word = "";
		while (i <= ObjectWords.getCount()) {
			word = (String) ObjectWords.get(i);
			if (word.equalsIgnoreCase(s)) {
				return true;
			}
			i++;	
		}
		return false;
	}
	
	/*** Makes a second pass through the imported locations and
	   * sorts out the map. */
	public void domap() {
	
		location l = null;
		location fnd = null;
		int i = 1;
		int j = 1;
		int k = 1;
		boolean foundloc = false;
		String mappos = "";
		
		while (i <= data.olocations.getCount()) {
			l = (location) data.olocations.get(i);
			j = 1;
			while (j <= l.OnInput.getCount()) {
				mappos = l.OnInput.get(j);
				int spos = mappos.indexOf(" ");
				if (spos != -1) {
				
					// We have something with a space in it - break into direction
					String dir = mappos.substring(0, spos);
					String localias = mappos.substring(spos + 1, mappos.length());
					
					// If there is a comma on the end of localias - remove it
					if (localias.endsWith(",")) localias = localias.substring(0, localias.length()-1);
					
					//System.out.println("direction: " + dir + ", alias: " + localias);
				
					// Find the location with this alias
					k = 1;
					foundloc = false;
					while (k <= data.olocations.getCount()) {
						fnd = (location) data.olocations.get(k);
						if (fnd.ImagePath.equalsIgnoreCase(localias)) {
							foundloc = true;
							break;
						}
						k++;	
					}
					
					// We got our location that this direction is pointing at!
					// see which direction it is:
					if (foundloc) {
				
						// See which one it is
						if (dir.equals("n")) {
							l.N = fnd.ID;
						}
						if (dir.equals("s")) {
							l.S = fnd.ID;
						}
						if (dir.equals("e")) {
							l.E = fnd.ID;
						}
						if (dir.equals("w")) {
							l.W = fnd.ID;
						}
						if (dir.equals("u")) {
							l.U = fnd.ID;
						}
						if (dir.equals("d")) {
							l.D = fnd.ID;
						}
						if (dir.equals("ne")) {
							l.NE = fnd.ID;
						}
						if (dir.equals("nw")) {
							l.NW = fnd.ID;
						}
						if (dir.equals("se")) {
							l.SE = fnd.ID;
						}
						if (dir.equals("sw")) {
							l.SW = fnd.ID;
						}
							
					}						
				
				}
				j++;
			}
			i++;	
		}
		
		// Make a final pass through, destroying the code for all locations
		// and clearing the ImagePath.
		i = 1;
		while (i <= data.olocations.getCount()) {
			l = (location) data.olocations.get(i);
			l.ImagePath = "";
			l.OnInput = new iagecode();
			i++;	
		}
		
	}
}