package iageinteractive;

import java.awt.*;
import java.awt.event.*;

public class tester extends Frame {

	private TextArea txtoutput = new TextArea();	
	private TextField txtinput = new TextField();
	private BorderLayout borderLayout = new BorderLayout();
	
	private long ctx = 0;
	private long thr = 0;
	private long ems = 0;
	
	
	public tester() {
	    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
	    try {
	      Init();
	    }
	    catch(Exception e) {
	      e.printStackTrace();
	    }
	 }
	 
	public void Init() {
		
		this.setTitle("Test NPC");
		
		this.setLayout(borderLayout);
		txtoutput.setEditable(false);
		txtoutput.append("Internet Adventure Game Engine Interaction Compiler " + vdu.versionno + "\nCopyright(c)2001, R.Rawson-Tetley.\n");	
		txtinput.addKeyListener(new tester_txtinput_keyAdapter(this));
		
		this.add(txtoutput, BorderLayout.CENTER);
		this.add(txtinput, BorderLayout.SOUTH);
		
		// always start the NPC in the first emotional state
		ems = 1;
		
	}
	
	public void outputText(String thetext) {
		txtoutput.append(thetext + "\n\n");	
	}
	
	public void parseInput(String theinput) {
		
		int x = 1; int y = 1; int z = 1; int i = 1;
		talkrouter tr = null; thread th = null; context ct = null; 
		iagecollection ic = null; String ts = null;
		boolean stopLooping = false;
		
		theinput = theinput.toLowerCase();
		
		
		// CONTEXTS:
		
		x = 1;
		while (x <= data.contexts.getCount()) {
			ct = (context) data.contexts.get(x);
			// See if we are in this context first:
			if (ct.ID == ctx) {
				// Enumerate talkrouters within this context
				y = 1;
				while (y <= ct.talkrouters.getCount()) {
					tr = (talkrouter) ct.talkrouters.get(y);
					// Enumerate possible word matches in talk router:
					z = 1;
					while (z <= tr.wordconditions.getCount()) {
						// Now enumerate each word collection in the router
						ic = (iagecollection) tr.wordconditions.get(z);
						i = 1;
						boolean ismatch = true;
						// See if all conditions can match for this set
						while (i <= ic.getCount()) {
							ts = (String) ic.get(i);
							if (theinput.indexOf(ts) != -1) {
								ismatch = ismatch && true;
							}
							else {ismatch = false;}
							i++;
						}
						// If we got a complete match, set the
						// relevant thread and break out now.
						if (ismatch) {
							stopLooping = true;
							thr = tr.callsthreadID;
							break;
						}
						z++;	
					}
					if (stopLooping) break;
					y++;	
				}		
			}
			if (stopLooping) break;
			x++;
		}	
		
		
		// TALK ROUTERS:
		
		stopLooping = false;
		x = 1;
		while (x <= data.talkrouters.getCount()) {
			tr = (talkrouter) data.talkrouters.get(x);
			// Enumerate possible word matches in talk router:
			z = 1;
			while (z <= tr.wordconditions.getCount()) {
				// Now enumerate each word collection in the router
				ic = (iagecollection) tr.wordconditions.get(z);
				i = 1;
				boolean ismatch = true;
				// See if all conditions can match for this set
				while (i <= ic.getCount()) {
					ts = (String) ic.get(i);
					if (theinput.indexOf(ts) != -1) {
						ismatch = ismatch && true;
					}
					else {ismatch = false;}
					i++;
				}
				// If we got a complete match, set the
				// relevant thread and break out now.
				if (ismatch) {
					stopLooping = true;
					thr = tr.callsthreadID;
					break;
				}
				z++;	
			}			
			if (stopLooping) break;
			x++;	
		}
		
		// THREADS:
		
		stopLooping = false;
		x = 1;
		while (x <= data.threads.getCount()) {
			th = (thread) data.threads.get(x);
			
			// See if we are in this particular thread
			if (th.ID == thr) {
			
				// Enumerate conditions
				threadconditions thc = null;
				y = 1;
				while (y <= th.conditions.getCount()) {
					thc = (threadconditions) th.conditions.get(y);
					
					// Enumerate emotional states in the
					// condition to see if we can do anything
					z = 1;
					ic = thc.emotionalstates;
					while (z <= ic.getCount()) {
						Long tl = (Long) ic.get(z);
						if (tl.longValue() == ems) {
							// We have an emotional state match!
							// Do what the thread says:
							
							// Speech
							if (!thc.speech.equals("")) {
								outputText("NPC: " + thc.speech);
							}
							
							// Action
							if (!thc.action.equals("")) {
								outputText("NPC " + thc.action);
							}
							
							// If there is a follow on context, set it
							if (thc.followoncontextid != 0) {
								ctx = thc.followoncontextid;
							}
							else
							{
								// Otherwise clear it
								ctx = 0;
							}
							
							// If there is a follow on thread, set it
							if (thc.followonthreadid != 0) {
								thr = thc.followonthreadid;
							}
							else
							{
								// Otherwise clear it	
								thr = 0;
							}
							
							// If there is an emotion switch, switch it
							if (thc.emotionchangeid != 0) {
								ems = thc.emotionchangeid;
							}
							
							stopLooping = true;
							break;
							
						}		
						if (stopLooping) break;			
						z++;	
					}
					if (stopLooping) break;
					y++;	
				}
			}
			if (stopLooping) break;
			x++;	
		}
		
	}
	
	
	public void txtinput_keyPressed(KeyEvent e) {
		
		if (e.getKeyCode() == KeyEvent.VK_ENTER) {
			outputText("> " + txtinput.getText());
			parseInput(txtinput.getText());
			txtinput.setText("");
		}
	}
	
  /**Overridden so frame can destroy itself when window is closed*/
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      	dispose();
    }
  }
	
}

class tester_txtinput_keyAdapter extends java.awt.event.KeyAdapter {
  tester adaptee;

  tester_txtinput_keyAdapter(tester adaptee) {
    this.adaptee = adaptee;
  }

  public void keyPressed(KeyEvent e) {
    adaptee.txtinput_keyPressed(e);
  }
  
}