/*
 * @(#)IAGELauncher.java 1.0 02/03/14
 *
 * You can modify the template of this file in the
 * directory ..\JCreator\Templates\Template_1\Project_Name.java
 *
 * You can also create your own project template by making a new
 * folder in the directory ..\JCreator\Template\. Use the other
 * templates as examples.
 *
 */
package iagelauncher;

import iageserver.*;
import iageclient.*;
import iagecompiler.*;

import java.awt.*;
import java.awt.event.*;

public class IAGELauncher extends Frame {
	
	private Button btnServer = new Button();
	private Button btnCompiler = new Button();
	private Button btnClient = new Button();
	
	private TextArea ins = new TextArea("", 0, 1, TextArea.SCROLLBARS_VERTICAL_ONLY);
	
	private GridLayout gl = new GridLayout(3, 1);
	private BorderLayout bl = new BorderLayout();
	private Panel pnlButtons = new Panel();
	
	public IAGELauncher() {
		
		this.setLayout(bl);
		
		ins.setText("Please select the program you wish to run. \n\nNote that to run a game, you should:\n\n1. Start the IAGE Server\n2. Open your game\n3. Start the server running\n4. Open the IAGE Client\n5. Connect to \"localhost\" to begin playing.");
		ins.setEditable(false);
		
		btnServer.setLabel("Start the IAGE Server");
	    btnServer.addActionListener(new ActionListener() {
	    	public void actionPerformed(ActionEvent e) {
	    		btnServer_actionPerformed(e);
	    	}
	    });
		
		btnCompiler.setLabel("Start the IAGE Compiler");
		btnCompiler.addActionListener(new ActionListener() {
	    	public void actionPerformed(ActionEvent e) {
	    		btnCompiler_actionPerformed(e);
	    	}
	    });
	    
		btnClient.setLabel("Start the IAGE Client");
		btnClient.addActionListener(new ActionListener() {
	    	public void actionPerformed(ActionEvent e) {
	    		btnClient_actionPerformed(e);
	    	}
	    });

		pnlButtons.setLayout(gl);
		pnlButtons.add(btnServer);
		pnlButtons.add(btnClient);
		pnlButtons.add(btnCompiler);
		
		this.add(pnlButtons, BorderLayout.EAST);
		this.add(ins, BorderLayout.CENTER);
		
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				dispose();
			}
		});
		
	}
	
	public void btnClient_actionPerformed(ActionEvent e) {
		try {
			new iageclient.windowborder();
		}
		catch(Exception ex) {ex.printStackTrace();}
	}
	
	public void btnServer_actionPerformed(ActionEvent e) {
		try {
			new iageserver.mainscreen(null);
			}
		catch(Exception ex) {ex.printStackTrace();}
	}
	
	public void btnCompiler_actionPerformed(ActionEvent e) {
		try {
			new iagecompiler.mainscreen();
			}
		catch(Exception ex) {ex.printStackTrace();}
	}

	public static void main(String args[]) {
		System.out.println("Starting IAGE Launcher...");
		IAGELauncher mainFrame = new IAGELauncher();
		mainFrame.setSize(400, 300);
		mainFrame.setTitle("IAGE Launcher");
		mainFrame.setVisible(true);
	}
}
