package iageserver;

/**
 * Character class - represents details of one IAGE Non-Player Character
 */

public class character {

  /** Character's ID */
  public long ID = 0;
  /** Display name of character */
  public String Name = "";
  /** Character's current location */
  public long CurrentLocation = 0;
  /** Description to use before NPC has moved from initial location (replaces Name) */
  public String Description = "";
  /** Flag to determine whether NPC has moved from where it started */
  public boolean MovedFromOriginalLocation = false;
  /** Default description when examining the NPC */
  public String DefaultExamine = "";
  /** Noun ID for referring to NPC */
  public long NounID = 0;
  /** Timer interval in milliseconds before OnTimer event runs */
  public long TimerInterval = 0;
  /** Number of timer events that have run */
  public long TimerIndex = 0;
  /** Time next OnTimer event will run */
  public long TimeToNextRun = 0;
  /** AI Mode NPC is currently in. System AI is only implemented as
   *  locational movement. All other AI must be scripted using the
   *  OnTimer event.
   *
   *  character.NONE (0) for no action
   *  character.FOLLOWPLAYER (1) for following a particular player
   *  character.RANDOM (2) for moving around the map at random.
   */
  public byte AIMode = 0;
  /** Constant for no NPC AI movement */
  public static byte NONE = 0;
  /** Constant for following player AI movement */
  public static byte FOLLOWPLAYER = 1;
  /** Constant for random map AI movement */
  public static byte RANDOM = 2;
  /** Constant for attacking */
  public static byte ATTACKING = 3;
  /** Unique identifier (Index) of player this NPC is following */
  public long FollowPlayerIndex = 0;
  /** Custom properties string. Custom properties tie together flags and objects */
  public String CustomProperties = "";
  /** Hit points the NPC has */
  public long HitPoints = 0;
  /** Maximum amount of damage NPC can do */
  public long DamageIndicator = 0;
  /** Money carried by NPC */
  public long Money = 0;
  /** If IAGE combat is on, cause this NPC to attack any players in the location */
  public boolean AutoAttack = false;
  /** If IAGE combat is on, cause this NPC to fight when people attack them */
  public boolean AttackWhenAttacked = false;
  /** Contains the index of the player this NPC is attacking */
  public int AttackingWho = 0;
  /** Name value pairs */
  public iagecollection NameValues = new iagecollection();
  /** Code collection which fires when the NPC is referenced */
  public iagecode OnAction = new iagecode();
  /** Code collection which fires when the NPC is spoken to 
    * (a player starts their input with <npcname><comma><string>
    */
  public iagecode OnTalk = new iagecode();
  /** Code collection which fires when the timer's interval has elapsed */
  public iagecode OnTimer = new iagecode();

  /**
   * Used by Random AI mode of NPCs - this method analyses the
   * NPC's current location and takes them to a nearby location,
   * selecting at random.
   */
  public void GoSomewhere() {

    location l = new location();
    boolean foundlocation = false;
    int i = 0;
    long newloc = 0;
    String newdir = "";

    // Find the player's current location
    i = 1;
    while (i <= data.olocations.getCount()) {
      l = (location)data.olocations.get(i);
      if (l.ID == this.CurrentLocation) {
        foundlocation = true;
        break;
      }
      i++;
    }

    if (foundlocation) {

      if (l.N > 0 && Math.random() > 0.5) {newloc = l.N; newdir = "north";}
      if (l.S > 0 && Math.random() > 0.5) {newloc = l.S; newdir = "south";}
      if (l.E > 0 && Math.random() > 0.5) {newloc = l.E; newdir = "east";}
      if (l.W > 0 && Math.random() > 0.5) {newloc = l.W; newdir = "west";}
      if (l.U > 0 && Math.random() > 0.5) {newloc = l.U; newdir = "up";}
      if (l.D > 0 && Math.random() > 0.5) {newloc = l.D; newdir = "down";}
      if (l.NE > 0 && Math.random() > 0.5) {newloc = l.NE; newdir = "northeast";}
      if (l.NW > 0 && Math.random() > 0.5) {newloc = l.NW; newdir = "northwest";}
      if (l.SE > 0 && Math.random() > 0.5) {newloc = l.SE; newdir = "southeast";}
      if (l.SW > 0 && Math.random() > 0.5) {newloc = l.SW; newdir = "southwest";}

      // Move
      if (newloc > 0) {
        // If we are going to move then tell everyone
        // in the location which way we are going as well.
        vdu.TransmitAllInLocation(this.Name + " goes " + newdir + ".", null , this.CurrentLocation);
        // Move them
        this.CurrentLocation = newloc;
        // Tell everyone in new location
        vdu.TransmitAllInLocation(this.Name + " enters.", null, newloc);
      }
    }
  }
  
	/*** Called by NPCTimer - examines what this NPC's AI mode is and does things accordingly */
	public void PerformAI() {
		
		// If we aren't doing anything - don't!
		if (AIMode == character.NONE) {
			return;	
		}		
		
		// Moving around the map at random - do it
		if (AIMode == character.RANDOM) {
			this.GoSomewhere();
		}
		
		// Note that following a player is handled in game.displaycurrentlocation
		
		// Attacking a player
		if (AIMode == character.ATTACKING) {
		
			// Find the player
	 		int i = 1;
	 		player p = null;
	 		while (i <= data.oplayers.getCount()) {
	 			p = (player) data.oplayers.get(i);
	 			if (p.Index == this.AttackingWho) {
	 				break;	
	 			}
	 			i++;	
	 		}
	 		
	 		// Make sure the player is here, if they aren't, go back into 
	 		// dormant mode
	 		if (p.CurrentLocation != this.CurrentLocation) {
	 			AIMode = character.NONE;
	 			return;
	 		}
	 		
		 	// Calculate damage from attack as an integer
		 	long damagedone = Math.round((Math.random() * this.DamageIndicator) + 1);
		 	
		 	// Now determine whether they hit or missed (all NPCs have 75%)
		 	boolean missed = ((Math.abs(Math.random() * 100) + 1) > 75);
		 	
		 	// If they missed, tell everyone and bomb out now
		 	if (missed) {
		 		vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERATTACKSANDMISSES), this.Name, p.Name), p, p.CurrentLocation);
		 		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_PLAYERATTACKSANDMISSES), this.Name, p.Name), p);
		 		return;
		 	}
	 		
	 		// Take off the damage
	 		p.HitPoints -= damagedone;
	 		
	 		// Tell everyone
	 		vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERATTACKSXFORXPOINTSOFDAMAGE), this.Name, p.Name, Long.toString(damagedone)), p, p.CurrentLocation);
	 		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_PLAYERATTACKSXFORXPOINTSOFDAMAGE), this.Name, p.Name, Long.toString(damagedone)), p);
	 		// Tell the person who got slapped
	 		vdu.Transmit(processor.smake(message.getMessage(constant.MSG_YOUHAVEBEENHITFORXPOINTSBYX), Long.toString(damagedone), this.Name), p);	 		
	 		// See if they are dead		
	 		if (p.HitPoints < 1) {
	 			// They are!
	 			vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERISDEAD), p.Name), p, p.CurrentLocation);
	 			vdu.Transmit(processor.smake(message.getMessage(constant.MSG_PLAYERISDEAD), p.Name), p);
	 			// Tell them they have been killed
	 			vdu.Transmit(message.getMessage(constant.MSG_YOUHAVEBEENKILLED), p);
	 			// Drop all their objects and tell everyone
	 			item.MoveAll(p.Index + location.PLAYERBASE, p.CurrentLocation);
		  		vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERDROPSTHEIROBJECTS), p.Name), p, p.CurrentLocation);
		  		if (data.ogame.UsingIAGEMoney) {
		 			// Award the killer the player's money
		 			this.Money += p.Money;
		 		}
	 			// Increment their damage indicator
	 			this.DamageIndicator += data.ogame.DamageIndicatorIncrementForKill;
	 			// See what our policy is for dead people
	 			if (data.ogame.PlayersStayDead) {
	 				// If they stay dead, close their connection - it's all over!
	 				p.quit(true);
	 			}
	 			else
	 			{
	 				// Reset their attributes
				    p.HitPoints = data.ogame.DefaultHitPoints;
				    p.Money = data.ogame.DefaultMoney;
				    p.DamageIndicator = data.ogame.DefaultDamage;
				    p.ChanceOfHitting = data.ogame.DefaultChanceOfHitting;
				    
				    // Resurrect them
	 				if (data.ogame.StartingLocation == -1) {
				    	p.CurrentLocation = data.ogame.getRandomLocation();
				    }
				    else
				    {
				      	p.CurrentLocation = data.ogame.StartingLocation;
				    }
				    // Tell everyone they're here
				    vdu.TransmitAllInLocation(processor.smake(message.getMessage(constant.MSG_PLAYERAPPEARS), p.Name), p, p.CurrentLocation);
	 			}
	 		}	
			
		}
		
	}
	
	public String getNameValue(String valname) {
	
		 // Find value of this name
		 int ic = 1;
		 namevaluepair nv = null;
		 while (ic <= this.NameValues.getCount()) {
		 	 nv = (namevaluepair) this.NameValues.get(ic);
		 	 if (nv.Name.equalsIgnoreCase(valname)) {
		 	 	// Found it - return the value
		 	 	return nv.Value;
		 	 }
		     ic++;	 	
		 }	
		 return "0";
	}
	
	public void setNameValue(String valname, String newval) {
	
		// Hunt through to see if we already have a value with
		// this name:
		 int ic = 1;
		 namevaluepair nv = null;
		 
		 while (ic <= this.NameValues.getCount()) {
		 	 nv = (namevaluepair) this.NameValues.get(ic);
		 	 if (nv.Name.equalsIgnoreCase(valname)) {
		 	 	
		 	 	// We have one, replace the value
		 	 	nv.Value = newval;
		 	 	return;
		 	 }
		     ic++;	 	
		 }
		 
	 	// Add it
	 	nv = new namevaluepair();
	 	nv.Name = valname;
	 	nv.Value = newval;
	 	this.NameValues.add(nv);
		
	}
	

}