package iageserver;

/**
 * Verb class - represents one IAGE verb.
 */
public class verb {

  /** Verb ID */
  public long ID = 0;
  /** Verb Text */
  public String Text = "";

  /**
   *  Returns an iagecollection of verbs
   *  matching a given ID.
   */
  public static iagecollection getVerbsForID(long VerbID) {
  	int i = 1;
  	verb v = null;
  	iagecollection returnlist = new iagecollection();
  	while (i <= data.overbs.getCount()) {
  		v = (verb) data.overbs.get(i);
  		if (v.ID == VerbID) {
  			returnlist.add(v);
  		}
  		i++;
  	}
  	return returnlist;
  }
  
  /**
   *  If any synonym of the given verb ID is present
   *  anywhere in the string, the location of it is returned.
   *  Otherwise, -1 is returned.
   *  If wholestring is set, the whole string must match to return
   *  a non-negative value.
   */
  public static int checkVerbIDInString(long VerbID, String s, boolean wholestring) {
  	int i = 1;
  	int pos = 0;
  	verb v = null;
  	
  	// Remove any spaces from the beginning or end
  	s = data.trimstring(s);
  	
  	while (i <= data.overbs.getCount()) {
  		// Read current verb
  		v = (verb) data.overbs.get(i);
  		// Check if the ID matches our passed ID
  		if (v.ID == VerbID) {
  			// Attempt to find the verb text in the string
  			pos = s.indexOf(v.Text);
  			// If a match is found, return the position
  			if (pos != -1) {
  				// Make a further check now - ensure that there is
  				// a space if we have wholeword on
  				if (wholestring) {
  					if (s.equalsIgnoreCase(v.Text)) {
  						return pos;	
  					}
  					else return -1;
  				}
  				else return pos;
  			}
  		}
  		i++;
  	}
  	// If we got here, we didn't find it, return -1
  	return -1;
  }
  
}