#charset "us-ascii"

/*
 *   Copyright (c) 2001 Michael J. Roberts
 *   
 *   This file is part of TADS 3.  
 */

#ifndef _BYTEARR_H_
#define _BYTEARR_H_

/* we need the CharacterSet class for mapToString */
#include "charset.h"

/*
 *   'ByteArray' intrinsic class.  This class provides a fixed-size array of
 *   unsigned 8-bit byte values; each array element is an integer in the
 *   range 0-255.  
 */
intrinsic class ByteArray 'bytearray/030000'
{
    /*
     *   Constructors:
     *   
     *   new ByteArray(length) - create a byte array with the given number
     *   of bytes.  All elements in the new array are initialized to zero.
     *   
     *   new ByteArray(byteArray, startIndex?, length?) - create a new byte
     *   array as a copy of the given byte range of the given byte array,
     *   which must be an object of intrinsic class ByteArray.  If the
     *   starting index and length are not given, the new object is a
     *   complete copy of the source byte array.  
     */

    /* 
     *   Get the number of bytes in the array.  The length is fixed at
     *   creation time.  
     */
    length();

    /* 
     *   create a new ByteArray as a copy of the given range of this array;
     *   if the length is not given, bytes from the starting index to the
     *   end of this array are included in the new array
     */
    subarray(startIndex, length?);

    /* 
     *   Copy bytes from the source array into this array.  Bytes are copied
     *   into this array starting at the given index.  The specified number
     *   of bytes are copied from the source array starting at the given
     *   index.  
     */
    copyFrom(src, srcStartIndex, dstStartIndex, length);

    /*
     *   Fill bytes in this array with the given value.  If no starting
     *   index or length values are given, the entire array is filled with
     *   the given byte value.  The byte value must be an integer in the
     *   range 0 to 255. 
     */
    fillValue(val, startIndex?, length?);

    /*
     *   Convert a range of bytes in the array to a string, interpreting the
     *   bytes in the array as characters in the given character set.  The
     *   resulting string is, of course, a standard T3 string encoded in the
     *   Unicode character set, so the value returned is not dependent upon
     *   the mapping character set.
     *   
     *   If the starting index and length are not given, the entire byte
     *   array is converted to a string.  'charset' must be an object of
     *   intrinsic class CharacterSet.  
     */
    mapToString(charset, startIndex?, length?);
}

#endif /* _BYTEARR_H_ */
