/*----------------------------------------------------------------------*\

	pmParse.c

	ParserMaker generated parser

\*----------------------------------------------------------------------*/

/* %%IMPORT */


#include "srcp.h"
#include "smScan.h"
#include "token.h"
#include "lmList.h"
#include "a2a3.h"

/* END %%IMPORT */

#include <string.h>
#include <setjmp.h>

#include "pmParse.h"

#define PMTRUE 1
#define PMFALSE 0
typedef unsigned char PmBoolean; /* For logical values */

/* System dependencies */

/* These datatypes should be defined to be unsigned integers of length 1, 2
 * and 4 bytes respectively.
 */
typedef unsigned char UByte1;
typedef unsigned short UByte2;
typedef unsigned int UByte4;

/* Token definition */
#include "alanCommon.h"

/* %%ATTRIBUTES - The semantic attributes for grammar symbols */
typedef struct pmGrammar {
    int val;
    char *string;
} pmGrammar;

/* END %%ATTRIBUTES */

/* Parser constants *\
\* ---------------- */
#define ERROR_ACT 0			/* Action - Error */
#define SHIFT_ACT 1			/* Action - Shift */
#define SHIFTRED_ACT 2		/* Action - Shift_Reduce */
#define REDUCE_ACT 3		/* Action - Reduce */
#define ACCEPT_ACT 4		/* Action - Accept */

#define ERR_SYM 0		/* Error token */
#define ENDMARK 1		/* End of file token code */

/* Recovery method *\
\* --------------- */
#define NONE_REC 0		/* No recovery found */
#define IN_REC 1		/* Insertion of symbol(s) */
#define DEL_REC 2		/* Deletion of symbol(s) */
#define REP_REC 3		/* Replacement of symbol(s) */
#define BAK_REC 4		/* Stack backup */
#define HALT_REC 5		/* System halted */

/* Error class *\
\* ----------- */
#define LEX_ERR 1		/* Non valid scanner symbol found */
#define SYN_ERR 2		/* Normal syntax error */
#define OFLW_ERR 3		/* Parse stack overflow */
#define TAB_ERR 4		/* Parse table error */
	   
/* Error severity *\
\* -------------- */
#define WAR_SEV 1		/* Warnings */
#define ERR_SEV 2		/* Repairable error */
#define FAT_SEV 3		/* Fatal error */
#define SYS_SEV 4		/* System & limit error */

/* Parser constants *\
\* ---------------- */
#define SccMax 104		/* Max scanner code value */
#define TermMin 1		/* Minimum terminal number */
#define Terms 104		/* Number of terminals in grammar */
#define StateMin 1		/* Minimum state number */
#define States 363		/* Number of states */
#define ProdMin 1		/* Minimum production number */
#define Prods 405		/* Number of productions */
#define PmStkMax 64		/* Parse stack size */
#define	PmLaMax 5		/* Look-ahead length */
#define	PmCost 5		/* Shifting cost */

/* Types *\
\* ----- */
typedef unsigned char TermSet[(Terms + TermMin + 7) >> 3]; /* Terminal set */
typedef UByte2 ParseStack[PmStkMax]; /* Parse stack */

/* Terminal table *\
\* -------------- */

typedef struct {
    UByte1 tsym;		/* Normal continuation */
    UByte1 ssym;		/* Separator continuation */
} ContRec;

typedef struct {
    ContRec cont[363];		/* Continuation function */
    TermSet sepa;		/* Separator symbols */
    TermSet fiduc;		/* Fiducial symbols */
    TermSet skip;		/* Symbols to skip */
} RecTab;

typedef struct  {
    UByte2 act[14545];		/* Action table */
    UByte2 actCheck[14550];	/* Row Displacement Check Vector*/
    UByte2 actRix[363];		/* Action row mapping */
    RecTab recover;		/* Error recovery info */
} TermTab;

static TermTab act = {
{4,0,1553,2755,2755,2755,1898,2755,2755,1441,2755,2755,2755,2755,2755,2755
,2755,2755,2755,2755,627,2755,2195,3050,2755,2755,2755,2755,2755,691,2755
,2755,137,2755,2755,2755,2755,2755,779,801,281,2195,691,1202,2755,2755,2755
,2755,691,1202,2755,779,627,2755,2755,2755,2755,779,801,1210,1218,691,1403
,658,2755,1210,1218,1225,2755,1091,802,1073,1898,715,2027,650,2755,2755
,2755,2755,1403,1091,2755,1443,137,1091,1091,2755,2755,137,618,2755,1969
,1091,2755,2755,2755,2755,2755,1443,1443,2755,610,961,1443,642,1043,2369
,1403,779,2602,1443,1443,2443,1443,1443,1443,113,865,913,1443,634,779,1443
,985,1443,1906,489,505,1443,1553,1689,1059,2027,1443,465,497,729,1553,297
,1537,802,1091,1443,2209,1059,585,1443,953,1443,529,1091,1091,1898,1443
,1091,1443,1443,553,569,625,665,1443,3011,1059,1443,1681,1443,1443,521,513
,1443,1443,1443,579,2267,89,721,769,833,1443,1443,1443,1065,1898,1443,1202
,851,779,291,3050,579,137,2267,961,579,137,3034,1657,851,1801,779,1210,1218
,579,579,851,1969,113,865,913,579,1801,65,579,1201,579,1906,489,505,802
,579,3018,2203,1881,579,465,497,729,1227,314,579,579,579,579,137,291,585
,2642,2315,579,529,1898,579,579,1121,137,579,3027,553,569,625,665,579,137
,2401,579,1041,579,579,521,513,579,579,579,579,579,89,721,769,833,579,579
,2338,1065,2507,2523,2507,1898,2507,2523,2041,2523,2523,2523,2523,2523,2507
,137,2523,2523,2507,1481,2507,19,1466,2523,2523,2523,2523,2523,19,2523,2507
,1898,2523,2523,2507,2507,2507,1962,19,19,1169,1898,354,2507,2507,2507,2507
,889,1970,2507,19,19,2507,2507,2507,2523,2082,1978,921,2059,2025,697,994
,2507,2865,19,19,2507,2763,1986,2553,2561,19,19,2059,2507,2507,2507,2507
,19,2059,2523,257,257,1994,1394,2507,2507,241,241,2523,1898,219,2507,2507
,2507,2507,2523,3074,1265,2507,2609,425,305,795,1650,1857,369,3034,282,2002
,306,2059,618,561,3170,2681,795,961,3162,2778,2778,274,795,570,610,2010
,1721,642,3234,1754,2763,113,865,913,3218,273,289,2059,2721,3210,1905,1913
,1921,634,1018,2786,2786,1337,3138,465,497,729,577,1689,2746,2193,2201,3194
,3027,434,585,2698,2075,3178,1945,1898,2730,1682,2075,1761,3242,1769,553
,569,625,665,3202,345,387,3186,2018,3098,3082,1937,1929,3226,3090,3146,2738
,1369,89,721,769,833,3154,387,762,1065,961,387,2075,1025,2841,2273,1546
,1033,1170,2234,1401,387,1898,66,113,865,913,387,74,0,387,0,387,1906,489
,505,0,387,2075,0,0,387,465,497,729,0,0,387,387,387,387,0,0,585,0,0,387
,529,0,387,387,0,0,387,0,553,569,625,665,387,0,0,387,0,387,387,521,513,387
,387,387,387,387,89,721,769,833,387,387,2611,1065,0,0,2611,0,2611,2611,2611
,2611,2611,2611,0,2611,2611,0,0,1907,0,0,2611,2611,2611,2611,2611,1907,2611
,2611,0,2611,2611,1907,1907,1907,0,0,0,0,1907,0,1907,1907,1907,2611,1907
,1307,0,257,0,1907,1907,1907,2611,241,0,0,0,1307,0,0,1907,1307,1307,0,1907
,0,0,0,0,1307,1307,1307,1907,1907,1907,1907,0,2225,2611,0,0,0,0,1907,1907
,2778,0,2611,0,0,1907,1907,1907,1907,2611,2395,0,1907,0,2395,0,2395,2395
,2395,2395,2395,0,0,2395,2395,0,2786,961,0,0,2395,2395,2395,2395,2395,2395
,2395,0,0,2395,2395,113,865,913,0,0,1307,0,0,0,1906,489,505,2395,0,907,0
,257,0,465,497,729,2395,241,0,0,0,907,0,0,585,907,907,0,529,0,0,0,0,907
,907,907,553,569,625,665,257,0,2395,0,0,0,241,521,513,2778,0,2395,0,0,89
,721,769,833,2395,2387,0,1065,0,2387,0,2387,2387,2387,2387,2387,0,0,2387
,2387,0,2786,961,0,2778,2387,2387,2387,2387,2387,2387,2387,0,0,2387,2387
,113,865,913,0,0,907,0,1795,0,1906,489,505,2387,1795,2786,0,0,0,465,497
,729,2387,0,0,0,0,0,0,0,585,0,2675,0,529,0,0,0,2675,0,0,0,553,569,625,665
,1795,0,2387,0,0,0,0,521,513,0,0,2387,0,0,89,721,769,833,2387,1251,0,1065
,0,961,2675,0,1795,0,0,0,0,1251,0,0,0,1251,1251,113,865,913,0,0,1977,1251
,1251,1251,1906,489,505,1457,2675,963,0,1251,0,465,497,729,0,1385,2857,41
,0,2017,0,0,585,963,963,0,529,1321,1561,0,1251,1977,2065,2129,553,569,625
,665,0,0,0,0,1417,1249,0,521,513,3074,1251,1353,1505,0,89,721,769,833,2577
,1251,1251,1065,0,1251,0,1339,1339,0,0,0,3162,0,1339,0,0,0,0,1339,0,0,3234
,1339,1339,0,0,0,3218,0,0,1339,1339,1339,0,3106,3114,2041,0,1339,0,0,3138
,0,0,2866,1339,0,0,0,0,3194,0,0,2898,2906,0,3178,0,257,0,0,1339,0,3242,241
,2858,2874,2882,2890,3202,0,1339,3186,0,3098,3082,3130,3122,3226,1339,3146
,1243,0,0,0,1259,0,3154,1339,1339,0,0,1339,1243,0,0,2778,1243,1243,1259
,1259,1259,0,0,0,1243,1243,1243,1259,1259,1259,0,0,0,0,1243,0,1259,1259
,1259,0,0,2786,0,0,0,0,0,1259,0,0,401,1259,0,0,0,1243,0,385,0,1259,1259
,1259,1259,0,0,0,0,0,0,0,1259,1259,3074,1243,0,0,0,1259,1259,1259,1259,0
,1243,1243,1259,0,1243,0,1411,3170,1977,0,0,3162,0,0,0,1457,0,0,1411,1305
,0,3234,1411,1411,0,1385,2857,3218,0,0,1411,0,3210,0,3106,3114,1411,1321
,1561,0,0,3138,0,0,0,0,0,0,0,0,3194,0,1417,1249,2425,0,3178,0,0,1353,1505
,1411,0,3242,1411,0,2577,0,0,3202,961,0,3186,0,3098,3082,3130,3122,3226
,1411,3146,0,0,0,113,865,913,3154,1411,1411,1763,0,1411,1906,489,505,0,1763
,0,0,0,0,465,497,729,0,0,1763,1763,1763,0,0,0,585,0,0,0,529,0,1763,1763
,0,0,0,0,553,569,625,665,0,0,0,0,0,1763,1763,521,513,0,1363,0,1763,1763
,89,721,769,833,3074,1763,0,1065,1363,305,0,0,1363,1363,3034,0,0,0,0,0,1363
,3170,0,0,0,3162,1363,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218,273,289,0,0,3210
,2610,3106,3114,0,1363,0,1363,1363,3138,0,0,0,0,0,2746,0,0,3194,3027,0,0
,2698,1363,3178,2626,0,2730,0,0,0,3242,1363,1363,0,0,1363,3202,345,0,3186
,0,3098,3082,3130,3122,3226,3090,3146,2738,0,2595,0,0,0,3154,2595,0,0,0
,0,2595,0,0,0,0,0,0,2595,0,0,0,2595,0,0,0,0,0,0,0,0,0,2595,0,0,0,0,0,2595
,2595,2595,0,0,2595,2595,2595,2595,0,0,0,0,0,2595,0,0,0,0,0,2595,0,0,2595
,2595,0,0,2595,0,2595,2595,0,2595,0,0,0,2595,0,0,0,0,0,2595,2595,0,2595
,0,2595,2595,2595,2595,2595,2595,2595,2595,0,3074,0,0,0,2595,305,0,0,0,0
,3034,0,0,0,0,0,0,3170,0,0,0,3162,0,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218
,273,289,0,0,3210,2610,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,2746,0,0,3194
,3027,0,0,2698,0,3178,2626,0,2730,0,0,0,3242,0,0,0,0,0,3202,345,0,3186,0
,3098,3082,3130,3122,3226,3090,3146,2738,0,2579,0,0,0,3154,2579,0,0,0,0
,2579,0,0,0,0,0,0,2579,0,0,0,2579,0,0,0,0,0,0,0,0,0,2579,0,0,0,0,0,2579
,2579,2579,0,0,2579,2579,2579,2579,0,0,0,0,0,2579,0,0,0,0,0,2579,0,0,2579
,2579,0,0,2579,0,2579,2579,0,2579,0,0,0,2579,0,0,0,0,0,2579,2579,0,2579
,0,2579,2579,2579,2579,2579,2579,2579,2579,0,3074,0,0,0,2579,305,0,0,0,0
,3034,0,0,0,0,0,0,3170,0,0,0,3162,0,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218
,273,289,0,0,3210,2610,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,2746,0,0,3194
,3027,0,0,2698,0,3178,2626,0,2730,0,0,0,3242,0,0,0,0,0,3202,345,0,3186,0
,3098,3082,3130,3122,3226,3090,3146,2738,0,2587,0,0,0,3154,2587,0,0,0,0
,2587,0,0,0,0,0,0,2587,0,0,0,2587,0,0,0,0,0,0,0,0,0,2587,0,0,0,0,0,2587
,2587,2587,0,0,2587,2587,2587,2587,0,0,0,0,0,2587,0,0,0,0,0,2587,0,0,2587
,2587,0,0,2587,0,2587,2587,0,2587,0,0,0,2587,0,0,0,0,0,2587,2587,0,2587
,0,2587,2587,2587,2587,2587,2587,2587,2587,0,3074,0,0,0,2587,305,0,0,0,0
,3034,0,0,0,0,0,0,3170,0,0,0,3162,0,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218
,273,289,0,0,3210,2610,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,2746,0,0,3194
,3027,0,0,2698,0,3178,2626,0,2730,0,0,0,3242,0,0,0,0,0,3202,345,0,3186,0
,3098,3082,3130,3122,3226,3090,3146,2738,0,3074,0,0,0,3154,305,0,0,0,0,3034
,0,0,0,0,0,0,3170,0,0,0,3162,0,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218,273,289
,0,0,3210,2610,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,2746,0,0,3194,3027,0,0
,2698,0,3178,2626,0,2730,0,0,0,3242,0,0,0,0,0,3202,345,0,3186,0,3098,3082
,3130,3122,3226,3090,3146,2738,0,2099,0,0,0,3154,2099,0,0,0,0,2099,0,0,0
,0,0,0,2099,0,0,0,2099,0,0,0,0,0,0,0,0,0,2099,0,0,0,0,0,2099,2099,2099,0
,0,2099,2099,2099,2099,0,0,0,0,0,2099,0,0,0,0,0,2099,0,0,2099,2099,0,0,2099
,0,2099,2099,0,2099,0,0,0,2099,0,0,0,0,0,2099,2099,0,2099,0,2099,2099,2099
,2099,2099,2099,2099,2099,0,3074,0,0,0,2099,305,0,0,0,0,3034,0,0,0,0,0,0
,3170,0,0,0,3162,0,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218,273,289,0,0,3210
,2610,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,2746,0,0,3194,3027,0,0,2698,0,3178
,2626,0,2730,0,0,0,3242,0,0,0,0,0,3202,345,0,3186,0,3098,3082,3130,3122
,3226,3090,3146,2738,0,2211,0,0,0,3154,2211,0,0,0,0,2211,0,0,0,0,0,0,2211
,0,0,0,2211,0,0,0,0,0,0,0,0,0,2211,0,0,0,0,0,2211,2211,2211,0,0,2211,2211
,2211,2211,0,0,0,0,0,2211,0,0,0,0,0,2211,0,0,2211,2211,0,0,2211,0,2211,2211
,0,2211,0,0,0,2211,0,0,0,0,0,2211,2211,0,2211,0,2211,2211,2211,2211,2211
,2211,2211,2211,0,3074,0,0,0,2211,305,0,0,0,0,3034,0,0,0,0,0,0,3170,0,0
,0,3162,0,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218,273,289,0,0,3210,2610,3106
,3114,0,0,0,0,0,3138,0,0,0,0,0,2746,0,0,3194,3027,0,0,2698,0,3178,2626,0
,2730,0,0,0,3242,0,0,0,0,0,3202,345,0,3186,0,3098,3082,3130,3122,3226,3090
,3146,2738,0,2171,0,0,0,3154,2171,0,0,0,0,2171,0,0,0,0,0,0,2171,0,0,0,2171
,0,0,0,0,0,0,0,0,0,2171,0,0,0,0,0,2171,2171,2171,0,0,2171,2171,2171,2171
,0,0,0,0,0,2171,0,0,0,0,0,2171,0,0,2171,2171,0,0,2171,0,2171,2171,0,2171
,0,0,0,2171,0,0,0,0,0,2171,2171,0,2171,0,2171,2171,2171,2171,2171,2171,2171
,2171,0,3074,0,0,0,2171,305,0,0,0,0,3034,0,0,0,0,0,0,3170,0,0,0,3162,0,0
,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218,273,289,0,0,3210,2610,3106,3114,0,0,0
,0,0,3138,0,0,0,0,0,2746,0,0,3194,3027,0,0,2698,0,3178,2626,0,2730,0,0,0
,3242,0,0,0,0,0,3202,345,0,3186,0,3098,3082,3130,3122,3226,3090,3146,2738
,0,2243,0,0,0,3154,2243,0,0,0,0,2243,0,0,0,0,0,0,2243,0,0,0,2243,0,0,0,0
,0,0,0,0,0,2243,0,0,0,0,0,2243,2243,2243,0,0,2243,2243,2243,2243,0,0,0,0
,0,2243,0,0,0,0,0,2243,0,0,2243,2243,0,0,2243,0,2243,2243,0,2243,0,0,0,2243
,0,0,0,0,0,2243,2243,0,2243,0,2243,2243,2243,2243,2243,2243,2243,2243,0
,3074,0,0,0,2243,305,0,0,0,0,3034,0,0,0,0,0,0,3170,0,0,0,3162,0,0,0,0,0
,0,0,0,0,3234,0,0,0,0,0,3218,273,289,0,0,3210,2610,3106,3114,0,0,0,0,0,3138
,0,0,0,0,0,2746,0,0,3194,3027,0,0,2698,0,3178,2626,0,2730,0,0,0,3242,0,0
,0,0,0,3202,345,0,3186,0,3098,3082,3130,3122,3226,3090,3146,2738,0,2347
,0,0,0,3154,2347,0,0,0,0,2347,0,0,0,0,0,0,2347,0,0,0,2347,0,0,0,0,0,0,0
,0,0,2347,0,0,0,0,0,2347,2347,2347,0,0,2347,2347,2347,2347,0,0,0,0,0,2347
,0,0,0,0,0,2347,0,0,2347,2347,0,0,2347,0,2347,2347,0,2347,0,0,0,2347,0,0
,0,0,0,2347,2347,0,2347,0,2347,2347,2347,2347,2347,2347,2347,2347,0,3074
,0,0,0,2347,305,0,0,0,0,3034,0,0,0,0,0,0,3170,0,0,0,3162,0,0,0,0,0,0,0,0
,0,3234,0,0,0,0,0,3218,273,289,0,0,3210,2610,3106,3114,0,0,0,0,0,3138,0
,0,0,0,0,2746,0,0,3194,3027,0,0,2698,0,3178,2626,0,2730,0,0,0,3242,0,0,0
,0,0,3202,345,0,3186,0,3098,3082,3130,3122,3226,3090,3146,2738,0,2475,0
,0,0,3154,2475,0,0,0,0,2475,0,0,0,0,0,0,2475,0,0,0,2475,0,0,0,0,0,0,0,0
,0,2475,0,0,0,0,0,2475,2475,2475,0,0,2475,2475,2475,2475,0,0,0,0,0,2475
,0,0,0,0,0,2475,0,0,2475,2475,0,0,2475,0,2475,2475,0,2475,0,0,0,2475,0,0
,0,0,0,2475,2475,0,2475,0,2475,2475,2475,2475,2475,2475,2475,2475,0,3074
,0,0,0,2475,305,0,0,0,0,3034,0,0,0,0,0,0,3170,0,0,0,3162,0,0,0,0,0,0,0,0
,0,3234,0,0,0,0,0,3218,273,289,0,0,3210,2610,3106,3114,0,0,0,0,0,3138,0
,0,0,0,0,2746,0,0,3194,3027,0,0,2698,0,3178,2626,0,2730,0,0,0,3242,0,0,0
,0,0,3202,345,0,3186,0,3098,3082,3130,3122,3226,3090,3146,2738,0,2299,0
,0,0,3154,2299,0,0,0,0,2299,0,0,0,0,0,0,2299,0,0,0,2299,0,0,0,0,0,0,0,0
,0,2299,0,0,0,0,0,2299,2299,2299,0,0,2299,2299,2299,2299,0,0,0,0,0,2299
,0,0,0,0,0,2299,0,0,2299,2299,0,0,2299,0,2299,2299,0,2299,0,0,0,2299,0,0
,0,0,0,2299,2299,0,2299,0,2299,2299,2299,2299,2299,2299,2299,2299,0,3074
,0,0,0,2299,305,0,0,0,0,3034,0,0,0,0,0,0,3170,0,0,0,3162,0,0,0,0,0,0,0,0
,0,3234,0,0,0,0,0,3218,273,289,0,0,3210,2610,3106,3114,0,0,0,0,0,3138,0
,0,0,0,0,2746,0,0,3194,3027,0,0,2698,0,3178,2626,0,2730,0,0,0,3242,0,0,0
,0,0,3202,345,0,3186,0,3098,3082,3130,3122,3226,3090,3146,2738,0,2499,0
,0,0,3154,2499,0,0,0,0,2499,0,0,0,0,0,0,2499,0,0,0,2499,0,0,0,0,0,0,0,0
,0,2499,0,0,0,0,0,2499,2499,2499,0,0,2499,2499,2499,2499,0,0,0,0,0,2499
,0,0,0,0,0,2499,0,0,2499,2499,0,0,2499,0,2499,2499,0,2499,0,0,0,2499,0,0
,0,0,0,2499,2499,0,2499,0,2499,2499,2499,2499,2499,2499,2499,2499,0,1771
,0,0,0,2499,1771,0,0,0,0,1771,0,0,0,0,0,0,1771,0,0,0,1771,0,0,0,0,0,0,0
,0,0,1771,0,0,0,0,0,1771,1771,1771,0,0,1771,1771,1771,1771,0,0,0,0,0,1771
,0,0,0,0,0,1771,0,0,1771,1771,0,0,1771,0,1771,1771,0,1771,0,0,0,1771,0,0
,0,0,0,1771,1771,0,1771,0,1771,1771,1771,1771,1771,1771,1771,1771,0,3074
,0,0,0,1771,305,0,0,0,0,3034,0,0,0,0,0,0,3170,0,0,0,3162,0,0,0,0,0,0,0,0
,0,3234,0,0,0,0,0,3218,273,289,0,0,3210,2610,3106,3114,0,0,0,0,0,3138,0
,0,0,0,0,2746,0,0,3194,3027,0,0,2698,0,3178,2626,0,2730,0,0,0,3242,0,0,0
,0,0,3202,345,0,3186,0,3098,3082,3130,3122,3226,3090,3146,2738,0,3074,0
,0,0,3154,305,0,0,0,0,3034,0,0,0,0,0,0,3170,0,0,0,3162,0,0,0,0,0,0,0,0,0
,3234,0,0,0,0,0,3218,273,289,0,0,3210,2610,3106,3114,0,0,0,0,0,3138,0,0
,0,0,0,2746,0,0,3194,3027,0,0,2698,0,3178,2626,0,2730,0,0,0,3242,0,0,0,0
,0,3202,345,0,3186,0,3098,3082,3130,3122,3226,3090,3146,2738,0,1947,0,0
,0,3154,1947,0,0,0,0,1947,0,0,0,0,0,0,1947,0,0,0,1947,0,0,0,0,0,0,0,0,0
,1947,0,0,0,0,0,1947,1947,1947,0,0,1947,1947,1947,1947,0,0,0,0,0,1947,0
,0,0,0,0,1947,0,0,1947,1947,0,0,1947,0,1947,1947,0,1947,0,0,0,1947,0,0,0
,0,0,1947,1947,0,1947,0,1947,1947,1947,1947,1947,1947,1947,1947,0,3074,0
,0,0,1947,305,0,0,0,0,3034,0,0,0,0,0,0,3170,0,0,0,3162,0,0,0,0,0,0,0,0,0
,3234,0,0,0,0,0,3218,273,289,0,0,3210,2610,3106,3114,0,0,0,0,0,3138,0,0
,0,0,0,2746,0,0,3194,3027,0,0,2698,0,3178,2626,0,2730,0,0,0,3242,0,0,0,0
,0,3202,345,0,3186,0,3098,3082,3130,3122,3226,3090,3146,2738,0,827,0,0,0
,3154,827,0,0,0,0,827,0,0,0,0,0,0,827,0,0,0,827,0,0,0,0,0,0,0,0,0,827,0
,0,0,0,0,827,827,827,0,0,827,827,827,827,0,0,0,0,0,827,0,0,0,0,0,827,0,0
,827,827,0,0,827,0,827,827,0,827,0,0,0,827,0,0,0,0,0,827,827,0,827,0,827
,827,827,827,827,827,827,827,0,3074,0,0,0,827,305,0,0,0,0,3034,0,0,0,0,0
,0,3170,0,0,0,3162,0,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218,273,289,0,0,3210
,2610,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,2746,0,0,3194,3027,0,0,2698,0,3178
,2626,0,2730,0,0,0,3242,0,0,0,0,0,3202,345,0,3186,0,3098,3082,3130,3122
,3226,3090,3146,2738,0,3074,0,0,0,3154,305,0,0,0,0,3034,0,0,0,0,0,0,3170
,0,0,0,3162,0,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218,273,289,0,0,3210,2610
,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,2746,0,0,3194,3027,0,0,2698,0,3178,2626
,0,2730,0,0,0,3242,0,0,0,0,0,3202,345,0,3186,0,3098,3082,3130,3122,3226
,3090,3146,2738,0,2667,0,0,0,3154,2667,0,0,0,0,2667,0,0,0,0,0,0,2667,0,0
,0,2667,0,0,0,0,0,0,0,0,0,2667,0,0,0,0,0,2667,2667,2667,0,0,2667,2667,2667
,2667,0,0,0,0,0,2667,0,0,0,0,0,2667,0,0,2667,2667,0,0,2667,0,2667,2667,0
,2667,0,0,0,2667,0,0,0,0,0,2667,2667,0,2667,0,2667,2667,2667,2667,2667,2667
,2667,2667,0,3074,0,0,0,2667,305,0,0,0,0,3034,0,0,0,0,0,0,3170,0,0,0,3162
,0,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218,273,289,0,0,3210,2610,3106,3114,0
,0,0,0,0,3138,0,0,0,0,0,2746,0,0,3194,3027,0,0,2698,0,3178,2626,0,2730,0
,0,0,3242,0,0,0,0,0,3202,345,0,3186,0,3098,3082,3130,3122,3226,3090,3146
,2738,0,2683,0,0,0,3154,2683,0,0,0,0,2683,0,0,0,0,0,1691,2683,0,0,0,2683
,0,0,0,0,0,0,1691,0,0,2683,1691,1691,0,0,0,2683,2683,2683,1691,0,2683,2683
,2683,2683,0,0,0,0,2681,2683,0,0,0,0,0,2683,0,0,2683,2683,0,0,2683,0,2683
,2683,0,2683,0,1691,0,2683,0,0,0,0,0,2683,2683,0,2683,0,2683,2683,2683,2683
,2683,2683,2683,2683,1483,0,0,0,961,2683,1691,0,0,0,1691,0,1483,0,0,0,1483
,1483,113,865,913,0,0,0,1483,0,0,1906,489,505,1483,0,1635,0,0,0,465,497
,729,0,0,1579,0,0,2601,0,0,585,1635,1635,0,529,0,1579,0,1483,1977,1579,1579
,553,569,625,665,0,3074,1579,0,0,0,305,521,513,0,1483,3034,0,0,89,721,769
,833,3170,1483,1483,1065,3162,1483,2769,0,0,0,0,0,0,0,3234,1579,0,0,0,0
,3218,273,289,0,0,3210,2610,3106,3114,0,0,0,0,2289,3138,0,0,2041,0,0,2746
,0,1579,3194,3027,0,1579,2698,0,3178,2626,0,2730,0,0,0,3242,0,0,0,0,0,3202
,345,0,3186,0,3098,3082,3130,3122,3226,3090,3146,2738,0,2691,0,0,0,3154
,2691,0,0,0,0,2691,0,0,0,0,0,0,2691,0,0,0,2691,0,0,0,0,0,0,0,0,0,2691,0
,0,0,0,0,2691,2691,2691,0,0,2691,2691,2691,2691,0,0,0,0,0,2691,0,0,0,0,0
,2691,0,0,2691,2691,0,0,2691,0,2691,2691,0,2691,0,0,0,2691,0,0,0,0,0,2691
,2691,0,2691,0,2691,2691,2691,2691,2691,2691,2691,2691,0,1747,0,0,0,2691
,1747,0,0,0,0,1747,0,0,0,0,0,0,1747,0,0,0,1747,0,0,0,0,0,0,0,0,0,1747,0
,0,0,0,0,1747,1747,1747,0,0,1747,1747,1747,1747,0,0,0,0,0,1747,0,0,0,0,0
,1747,0,0,1747,1747,0,0,1747,0,1747,1747,0,1747,0,0,0,1747,0,0,0,0,0,1747
,1747,0,1747,0,1747,1747,1747,1747,1747,1747,1747,1747,0,3074,0,0,0,1747
,305,0,0,0,0,3034,0,0,0,0,0,0,3170,0,0,0,3162,0,0,0,0,0,0,0,0,0,3234,0,0
,0,0,0,3218,273,289,0,0,3210,2610,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,2746
,0,1155,3194,3027,0,0,2698,0,3178,2626,0,2730,0,2265,0,3242,0,1155,1155
,0,0,3202,345,0,3186,1977,3098,3082,3130,3122,3226,3090,3146,2738,1507,0
,0,0,961,3154,0,0,0,0,0,0,1507,0,0,0,1507,1507,113,865,913,0,0,0,1507,0
,0,1906,489,505,0,0,0,0,0,0,465,497,729,0,2433,0,0,0,0,0,0,585,0,2289,2457
,529,0,2041,0,1507,0,0,0,553,569,625,665,0,3074,0,0,0,0,0,521,513,0,1507
,0,0,0,89,721,769,833,3170,1507,1507,1065,3162,1507,0,0,0,0,0,0,1305,0,3234
,0,0,0,0,0,3218,0,0,259,0,3210,0,3106,3114,0,259,0,0,0,3138,0,0,0,0,0,259
,259,259,3194,0,0,0,0,0,3178,0,0,259,259,0,0,3242,0,0,0,0,523,3202,0,0,3186
,0,259,259,3130,3122,3226,3090,3146,259,259,0,0,523,0,3154,259,523,0,0,0
,0,0,0,0,0,1625,523,0,0,0,0,0,523,0,0,523,0,523,0,523,523,0,523,0,0,0,523
,0,0,0,0,0,523,523,523,523,0,0,0,0,0,523,0,0,523,523,0,0,523,0,0,0,0,3074
,523,0,0,523,0,523,523,523,523,523,523,523,523,523,0,0,3170,0,523,523,3162
,0,0,0,0,0,0,0,1305,0,3234,0,0,0,0,0,3218,0,0,211,0,3210,0,3106,3114,0,211
,0,0,0,3138,0,0,0,0,0,211,211,211,3194,0,0,0,0,0,3178,0,0,211,211,0,0,3242
,0,0,0,0,3074,3202,0,0,3186,0,211,211,3130,3122,3226,3090,3146,211,211,0
,0,3170,0,3154,211,3162,0,0,0,0,0,0,0,1305,0,3234,0,0,0,0,0,3218,0,0,243
,0,3210,0,3106,3114,0,243,0,0,0,3138,0,0,0,0,0,243,243,243,3194,0,0,0,0
,0,3178,0,0,243,243,0,0,3242,0,0,0,0,3074,3202,0,0,3186,0,243,243,3130,3122
,3226,3090,3146,243,243,0,0,3170,0,3154,243,3162,0,0,0,0,0,0,0,1305,0,3234
,0,0,0,0,0,3218,0,0,227,0,3210,0,3106,3114,0,227,0,0,0,3138,0,0,0,0,0,227
,227,227,3194,0,0,0,0,0,3178,0,0,227,227,0,0,3242,0,0,0,0,3074,3202,0,0
,3186,0,227,227,3130,3122,3226,3090,3146,227,227,0,0,3170,0,3154,227,3162
,0,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218,0,0,363,0,3210,0,3106,3114,0,363
,0,0,0,3138,0,0,0,0,0,363,363,363,3194,0,0,0,0,0,3178,0,0,363,363,0,0,3242
,0,0,0,0,0,3202,0,0,3186,0,363,363,3130,3122,3226,3090,3146,363,363,0,0
,1267,0,3154,363,1283,0,0,0,0,0,0,0,1267,0,0,0,1267,1267,1283,1283,1283
,0,0,0,1267,0,0,1283,1283,1283,0,0,0,0,0,0,1283,1283,1283,0,0,0,0,0,0,0
,0,1283,0,0,0,1283,0,0,0,0,0,0,0,1283,1283,1283,1283,0,0,0,0,0,0,0,1283
,1283,0,1267,0,0,0,1283,1283,1283,1283,1275,1267,1267,1283,961,1267,0,0
,0,0,0,0,1275,0,0,0,1275,1275,113,865,913,0,0,0,1275,0,0,1906,489,505,0
,0,0,0,0,0,465,497,729,0,0,0,0,0,0,0,0,585,0,0,0,529,0,0,0,0,0,0,0,553,569
,625,665,0,0,0,0,0,0,0,521,513,0,1275,0,0,0,89,721,769,833,1291,1275,1275
,1065,961,1275,0,0,0,0,0,0,1291,0,0,0,1291,1291,113,865,913,0,0,0,1291,0
,0,1906,489,505,0,0,0,0,0,0,465,497,729,0,0,0,0,0,0,0,0,585,0,0,0,529,0
,0,0,0,0,0,0,553,569,625,665,0,0,0,0,0,0,0,521,513,0,1291,0,0,0,89,721,769
,833,1715,1291,1291,1065,961,1291,0,0,0,0,0,0,1715,0,0,0,1715,1715,113,865
,913,0,0,0,1715,0,0,1906,489,505,0,0,0,1403,1715,0,465,497,729,0,0,0,0,0
,0,1403,0,585,0,1403,1403,529,3074,0,0,1715,0,1403,0,553,569,625,665,1403
,0,0,0,0,0,3170,521,513,0,3162,0,0,0,89,721,769,833,0,1715,3234,1065,0,1715
,0,1403,3218,2369,1403,323,0,3210,0,3106,3114,0,323,0,0,0,3138,0,0,1403
,0,0,323,323,323,3194,0,0,1403,1403,0,3178,1403,0,323,323,0,0,3242,0,0,0
,0,3074,3202,0,0,3186,0,323,323,3130,3122,3226,3090,3146,323,323,0,0,3170
,0,3154,323,3162,0,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218,0,0,395,0,3210,0
,3106,3114,0,395,0,0,0,3138,0,0,0,0,0,395,395,395,3194,0,0,0,0,0,3178,0
,0,395,395,0,0,3242,0,0,0,0,0,3202,0,0,3186,0,395,395,3130,3122,3226,3090
,3146,395,395,0,0,1731,0,3154,395,961,0,0,0,0,0,0,0,1731,0,0,0,1731,1731
,113,865,913,0,0,0,1731,0,0,1906,489,505,0,0,0,0,1731,0,465,497,729,0,0
,0,0,0,0,0,0,585,0,0,0,529,0,0,0,1731,0,0,0,553,569,625,665,0,0,0,0,0,0
,0,521,513,0,0,0,0,0,89,721,769,833,1723,1731,0,1065,961,1731,0,0,0,0,0
,0,1723,0,0,0,1723,1723,113,865,913,0,0,0,1723,0,0,1906,489,505,0,0,0,0
,1723,0,465,497,729,0,0,0,0,0,0,0,0,585,0,0,0,529,0,0,0,1723,0,0,0,553,569
,625,665,0,0,0,0,0,0,0,521,513,3074,0,0,0,0,89,721,769,833,0,1723,0,1065
,0,1723,0,1611,3170,0,0,0,3162,0,0,0,0,0,0,1611,1305,0,3234,1611,1611,0
,0,0,3218,0,0,1611,0,3210,0,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,0,0,0,3194
,0,0,0,0,0,3178,0,0,0,0,1611,0,3242,0,0,0,0,0,3202,0,0,3186,0,3098,3082
,3130,3122,3226,3090,3146,979,0,0,0,961,0,3154,1611,0,0,0,1611,979,0,0,0
,979,979,113,865,913,0,0,0,979,979,979,1906,489,505,0,0,0,0,0,0,465,497
,729,0,0,0,0,0,0,0,0,585,0,0,0,529,0,0,0,0,0,0,0,553,569,625,665,0,0,0,3074
,0,0,0,521,513,0,0,0,0,0,89,721,769,833,0,1139,3170,1065,0,979,3162,0,0
,0,0,0,0,1139,1305,0,3234,1139,1139,0,0,0,3218,0,0,1139,0,3210,0,3106,3114
,0,0,0,0,0,3138,0,1499,0,0,0,0,0,0,3194,0,0,0,0,1499,3178,0,0,1499,1499
,0,0,3242,3074,0,0,1499,0,3202,0,0,3186,2321,3098,3082,3130,3122,3226,1139
,3146,3170,0,0,0,3162,0,3154,1139,1139,0,0,1139,0,0,3234,0,0,1499,0,0,3218
,0,0,27,0,3210,0,3106,3114,0,27,0,0,0,3138,1499,0,0,0,0,27,27,0,3194,1499
,1499,0,0,1499,3178,0,0,27,27,0,0,3242,0,0,0,0,0,3202,0,0,3186,0,27,27,3130
,3122,3226,3090,3146,27,27,0,0,2467,0,3154,27,2467,0,0,0,0,0,0,0,2467,0
,0,0,2467,0,2467,0,0,0,0,0,0,0,0,0,161,0,0,0,2467,2467,2467,0,0,0,0,0,0
,2467,2467,2467,2467,0,0,2467,0,0,2467,2467,2467,0,0,0,0,0,0,0,0,2467,0
,0,0,2467,0,0,0,0,0,0,0,2467,2467,2467,2467,0,0,3074,0,0,0,0,2467,2467,0
,0,0,0,0,2467,2467,2467,2467,939,3170,0,2467,0,3162,0,0,0,0,0,0,939,1305
,0,3234,939,939,0,0,0,3218,0,0,939,939,939,0,3106,3114,0,0,0,0,0,3138,0
,0,0,0,0,0,0,0,3194,0,0,0,0,0,3178,0,0,0,0,0,0,3242,0,0,0,0,0,3202,0,0,3186
,0,3098,3082,3130,3122,3226,3090,3146,2459,0,0,0,2459,0,3154,0,0,0,0,939
,2459,0,0,0,2459,0,2459,0,0,0,0,0,0,0,0,0,161,0,0,0,2459,2459,2459,0,0,0
,0,0,0,2459,2459,2459,2459,0,0,2459,0,0,2459,2459,2459,0,0,0,0,0,0,0,0,2459
,0,0,0,2459,0,0,0,0,0,0,0,2459,2459,2459,2459,0,0,0,0,0,0,0,2459,2459,0
,0,0,0,0,2459,2459,2459,2459,475,0,475,2459,0,475,0,498,506,0,0,0,0,0,0
,0,0,475,0,0,0,475,0,0,0,0,2355,0,0,0,2355,475,2355,2355,2355,2355,2355
,475,0,2355,2355,0,475,0,475,475,2355,2355,2355,2355,2355,475,2355,0,0,2355
,2355,0,0,0,475,0,475,0,0,0,475,0,0,2355,0,0,0,475,0,0,0,0,2355,475,0,0
,475,0,475,475,475,475,475,475,475,483,0,483,0,0,483,475,483,483,0,0,0,0
,2355,0,0,0,483,0,0,0,483,2355,0,0,0,2947,0,0,2355,2842,483,2826,2834,2850
,2947,2947,483,0,1202,2947,0,483,0,483,483,2947,2947,2947,2947,2947,483
,2954,0,0,1210,1218,0,0,0,483,0,483,0,0,0,483,0,0,1137,0,0,0,483,0,0,0,0
,2947,483,0,0,483,0,483,483,483,483,483,483,483,961,0,0,0,0,0,483,0,835
,0,835,0,0,2947,113,865,913,0,0,0,0,835,2947,1906,489,505,0,835,0,2947,0
,0,465,497,729,0,0,0,0,0,0,0,0,585,0,0,0,529,0,0,0,0,0,0,0,553,569,625,665
,0,0,0,0,0,0,0,521,513,0,0,0,0,0,89,721,769,833,1994,3131,0,1065,0,3131
,0,3131,3131,3131,3131,3131,3131,0,3131,3131,0,0,0,0,3131,3131,3131,3131
,3131,3131,0,3131,3131,0,3131,3131,0,0,0,0,0,0,0,0,2027,2627,0,0,3131,2627
,0,2627,2627,2627,2627,2627,2627,3131,2627,2627,0,0,0,0,0,2627,2627,2627
,2627,2627,0,2627,2627,0,2627,2627,0,0,0,0,0,0,0,3131,0,0,961,0,2627,0,0
,0,3131,0,787,0,0,2627,0,3131,113,865,913,2027,0,0,0,787,0,1906,489,505
,0,787,0,0,0,0,465,497,729,0,961,2627,0,0,0,0,0,585,2259,0,2627,529,0,0
,113,865,913,2627,0,553,569,625,665,1906,489,505,2259,0,0,0,521,513,465
,497,729,0,987,89,721,769,833,0,0,585,1065,0,0,529,1201,0,987,987,987,0
,0,553,569,625,665,987,987,987,0,0,0,0,521,513,987,987,987,0,987,89,721
,769,833,0,0,987,1065,2915,987,987,0,0,0,0,0,0,0,987,987,987,987,2915,2915
,2915,987,0,0,0,987,987,2915,2915,2915,0,0,987,987,987,987,2915,2915,2915
,987,2938,0,0,0,0,0,0,2915,0,875,2930,2915,0,0,0,0,0,0,0,2915,2915,2915
,2915,875,875,875,2922,0,0,0,2915,2915,875,875,875,0,0,2915,2915,2915,2915
,875,875,875,2915,875,0,0,0,0,0,0,875,0,2915,875,875,0,0,0,0,0,0,0,875,875
,875,875,2915,2915,2915,875,0,0,0,875,875,2915,2915,2915,0,0,875,875,875
,875,2915,2915,2915,875,2938,0,0,0,0,0,0,2915,0,961,2930,2915,0,0,0,0,0
,2291,0,2915,2915,2915,2915,113,865,913,2922,0,0,0,2915,2915,1906,489,505
,2291,0,2915,2915,2915,2915,465,497,729,2915,0,0,0,0,0,0,0,585,0,0,0,529
,2291,0,0,0,0,0,0,553,569,625,665,0,0,0,0,0,0,0,521,513,0,0,0,0,0,89,721
,769,833,1962,3107,0,1065,0,3107,0,3107,3107,3107,3107,3107,3107,0,3107
,3107,0,0,0,0,3107,3107,3107,3107,3107,3107,0,3107,3107,0,3107,3107,0,0
,0,0,0,0,0,0,1978,3115,0,0,3107,3115,0,3115,3115,3115,3115,3115,3115,3107
,3115,3115,0,0,0,0,3115,3115,3115,3115,3115,3115,0,3115,3115,0,3115,3115
,0,0,0,0,0,0,0,3107,0,0,0,0,3115,0,0,0,3107,0,0,0,0,3115,0,3107,0,0,0,0
,0,0,1986,3123,0,0,0,3123,0,3123,3123,3123,3123,3123,3123,0,3123,3123,0
,3115,0,0,3123,3123,3123,3123,3123,3123,3115,3123,3123,0,3123,3123,0,3115
,961,0,0,0,0,1323,1323,0,867,0,3123,0,1323,0,113,865,913,1323,0,3123,0,1323
,1323,1906,489,505,0,867,0,1323,0,0,465,497,729,0,0,1323,0,0,0,0,0,585,1323
,3123,0,529,3074,0,0,0,0,0,3123,553,569,625,665,0,0,3123,0,0,0,3170,521
,513,0,3162,1323,0,0,89,721,769,833,0,1323,3234,1065,0,0,0,0,3218,0,1323
,1323,0,3210,1323,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,2746,0,0,3194,0,0,0
,0,0,3178,0,0,2730,0,0,0,3242,0,2819,0,0,0,3202,0,0,3186,0,3098,3082,3130
,3122,3226,3090,3146,2738,2819,0,0,0,2819,3154,0,0,0,0,0,0,0,0,2819,0,0
,0,0,0,2819,0,0,0,0,2819,0,2819,2819,0,0,0,0,0,2819,0,0,0,0,0,2819,0,0,2819
,0,0,0,0,0,2819,0,0,2819,0,0,0,2819,0,3074,0,0,0,2819,0,0,2819,0,2819,2819
,2819,2819,2819,2819,2819,2819,3170,0,0,0,3162,2819,0,0,0,0,0,0,0,0,3234
,0,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,2746,0
,0,3194,0,0,0,0,0,3178,0,0,2730,0,0,0,3242,0,1939,0,0,0,3202,0,0,3186,0
,3098,3082,3130,3122,3226,3090,3146,2738,1939,0,0,0,1939,3154,0,0,0,0,0
,0,0,0,1939,0,0,0,0,0,1939,0,0,0,0,1939,0,1939,1939,0,0,0,0,0,1939,0,0,0
,0,0,1939,0,0,1939,0,0,0,0,0,1939,0,0,1939,0,0,0,1939,0,1955,0,0,0,1939
,0,0,1939,0,1939,1939,1939,1939,1939,1939,1939,1939,1955,0,0,0,1955,1939
,0,0,0,0,0,0,0,0,1955,0,0,0,0,0,1955,0,0,0,0,1955,0,1955,1955,0,0,0,0,0
,1955,0,0,0,0,0,1955,0,0,1955,0,0,0,0,0,1955,0,0,1955,0,0,0,1955,0,3074
,0,0,0,1955,0,0,1955,0,1955,1955,1955,1955,1955,1955,1955,1955,3170,0,0
,0,3162,1955,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114
,0,0,0,0,0,3138,0,0,0,0,0,2746,0,0,3194,0,0,0,0,0,3178,0,0,2730,0,0,0,3242
,0,2051,0,0,0,3202,0,0,3186,0,3098,3082,3130,3122,3226,3090,3146,2738,2051
,0,0,0,2051,3154,0,0,0,0,0,0,0,0,2051,0,0,0,0,0,2051,0,0,0,0,2051,0,2051
,2051,0,0,0,0,0,2051,0,0,0,0,0,2051,0,0,2051,0,0,0,0,0,2051,0,0,2051,0,0
,0,2051,0,3074,0,0,0,2051,0,0,2051,0,2051,2051,2051,2051,2051,2051,2051
,2051,3170,0,0,0,3162,2051,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218,0,0,0,0,3210
,0,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,2746,0,0,3194,0,0,0,0,0,3178,0,0,2730
,0,0,0,3242,0,2067,0,0,0,3202,0,0,3186,0,3098,3082,3130,3122,3226,3090,3146
,2738,2067,0,0,0,2067,3154,0,0,0,0,0,0,0,0,2067,0,0,0,0,0,2067,0,0,0,0,2067
,0,2067,2067,0,0,0,0,0,2067,0,0,0,0,0,2067,0,0,2067,0,0,0,0,0,2067,0,0,2067
,0,0,0,2067,0,3074,0,514,0,2067,1705,0,2067,0,2067,2067,2067,2067,2067,2067
,2067,2067,3170,0,0,0,3162,2067,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218,0,0
,0,0,3210,0,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,0,0,0,3194,0,1601,0,0,0,3178
,0,0,0,0,0,0,3242,0,0,0,1739,0,3202,0,0,3186,0,3098,3082,3130,3122,3226
,3090,3146,1739,1739,1739,0,0,0,3154,0,0,1739,1739,1739,0,0,0,0,0,2713,1739
,1739,1739,0,0,0,0,0,0,0,0,1739,0,0,2705,1739,3074,0,0,0,0,0,0,1739,1739
,1739,1739,0,0,0,0,0,0,3170,1739,1739,0,3162,1475,0,0,1739,1739,1739,1739
,0,0,3234,1739,0,1475,0,0,3218,1475,1475,0,0,3210,0,3106,3114,1475,0,0,0
,0,3138,1475,0,0,0,0,2746,0,0,3194,0,0,0,0,0,3178,0,0,2730,0,0,0,3242,0
,3074,0,1475,0,3202,2345,0,3186,0,3098,3082,3130,3122,3226,3090,3146,2738
,3170,0,0,1475,3162,3154,0,0,0,0,0,0,1475,1475,3234,0,1475,0,0,0,3218,0
,0,0,0,3210,0,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,2746,0,0,3194,0,0,0,0,0
,3178,0,0,2730,0,0,0,3242,0,2811,0,0,0,3202,0,0,3186,0,3098,3082,3130,3122
,3226,3090,3146,2738,2811,0,0,0,2811,3154,0,0,0,0,0,0,0,0,2811,0,0,0,0,0
,2811,0,0,0,0,2811,0,2811,2811,0,0,0,0,0,2811,0,0,0,0,0,2811,0,0,2811,0
,0,0,0,0,2811,0,0,2811,0,0,0,2811,0,2147,0,0,0,2811,0,0,2811,0,2811,2811
,2811,2811,2811,2811,2811,2811,2147,0,0,0,2147,2811,0,0,0,0,0,0,0,0,2147
,0,0,0,0,0,2147,0,0,0,0,2147,0,2147,2147,0,0,0,0,0,2147,0,0,0,0,0,2147,0
,0,2147,0,0,0,0,0,2147,0,0,2147,0,0,0,2147,0,3074,0,0,0,2147,0,0,2147,0
,2147,2147,2147,2147,2147,2147,2147,2147,3170,0,0,0,3162,2147,0,0,0,0,0
,0,0,0,3234,0,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,0,0,3138,0,0,0
,0,0,2746,0,0,3194,0,0,0,0,0,3178,0,0,2730,0,0,0,3242,0,3074,0,0,0,3202
,0,0,3186,0,3098,3082,3130,3122,3226,3090,3146,2738,3170,0,0,0,3162,3154
,0,0,0,0,0,0,0,0,3234,0,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,0,0
,3138,0,0,0,0,0,2746,0,1803,3194,0,0,0,0,0,3178,0,0,2730,0,0,0,3242,0,0
,0,0,0,3202,1803,0,3186,0,3098,3082,3130,3122,3226,3090,3146,2738,0,0,1803
,1803,1803,3154,0,0,0,0,0,1803,1803,1803,0,0,0,0,0,0,1803,1803,1803,0,0
,0,0,0,0,0,1811,1803,0,0,0,1803,0,0,0,0,0,0,0,1803,1803,1803,1803,0,0,0
,0,961,0,0,1803,1803,0,0,0,0,0,1803,1803,1803,1803,113,865,913,1803,0,0
,0,0,0,1906,489,505,0,0,0,2763,257,0,465,497,729,0,241,0,0,0,0,2763,0,585
,0,2763,2763,529,1419,0,0,0,0,2763,0,553,569,625,665,0,0,2763,0,0,0,1419
,521,513,2778,1419,0,0,0,89,721,769,833,1419,0,1419,1065,0,0,0,2763,1419
,0,0,0,0,1419,0,1419,1419,2786,0,0,0,0,1419,0,0,0,0,0,0,0,0,1419,0,0,2763
,1419,0,1419,2763,0,0,0,137,0,1419,0,0,0,961,0,1419,0,0,1419,0,1419,1419
,1419,1419,1419,1419,1419,113,865,913,0,0,0,1419,0,0,1906,489,505,0,0,0
,1323,1323,0,465,497,729,0,1323,0,0,0,0,1323,0,585,0,1323,1323,529,3074
,0,0,0,0,1323,0,553,569,625,665,0,0,1323,0,0,0,3170,521,513,1323,3162,0
,0,0,89,721,769,833,1305,0,3234,1065,0,0,0,1323,3218,0,0,0,0,3210,0,3106
,3114,1323,0,0,0,0,3138,0,0,0,0,1819,0,0,0,3194,0,0,1323,2425,0,3178,1323
,0,0,0,0,0,3242,0,0,0,961,0,3202,0,0,3186,0,3098,3082,3130,3122,3226,3090
,3146,113,865,913,0,0,0,3154,0,0,1906,489,505,0,0,0,0,0,0,465,497,729,0
,961,0,0,0,0,0,0,585,2833,0,0,529,0,0,113,865,913,0,0,553,569,625,665,1906
,489,505,0,0,0,0,521,513,465,497,729,0,0,89,721,769,833,0,0,585,1065,961
,0,529,0,0,0,0,0,2323,0,553,569,625,665,113,865,913,0,0,0,0,521,513,1906
,489,505,0,0,89,721,769,833,465,497,729,1065,0,0,0,0,0,0,0,585,0,0,0,529
,3074,0,58,0,0,0,0,553,569,625,665,0,0,0,0,0,0,3170,521,513,0,3162,0,0,0
,89,721,769,833,0,0,3234,1065,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0
,0,0,0,3138,0,0,0,0,0,0,0,0,3194,2905,0,0,0,0,3178,0,0,0,0,0,0,3242,3074
,0,0,0,0,3202,0,0,3186,0,3098,3082,3130,3122,3226,3090,3146,3170,0,0,0,3162
,0,3154,0,0,0,0,0,0,0,3234,3074,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0
,0,0,3170,0,3138,0,3162,0,0,0,0,0,0,3194,1305,0,3234,0,0,3178,0,0,3218,0
,0,0,3242,3210,0,3106,3114,0,3202,0,0,3186,3138,3098,3082,3130,3122,3226
,3090,3146,0,3194,0,0,0,0,3154,3178,0,0,267,0,0,0,3242,2155,0,0,0,0,3202
,0,0,3186,0,3098,3082,3130,3122,3226,3090,3146,2155,0,0,0,2155,0,3154,0
,0,0,0,0,2155,0,2155,0,0,0,0,0,2155,0,0,0,0,2155,0,2155,2155,0,0,0,0,0,2155
,0,0,0,0,0,0,0,0,2155,0,0,0,0,0,2155,0,0,0,0,0,0,2155,0,0,0,0,0,2155,0,0
,2155,0,2155,2155,2155,2155,2155,2155,2155,0,2379,0,0,0,2379,2155,2379,2379
,2379,2379,2379,0,0,2379,2379,0,0,961,0,0,2379,2379,2379,2379,2379,1113
,2379,0,0,2379,2379,113,865,913,0,0,0,0,0,0,1906,489,505,2379,0,0,0,0,0
,465,497,729,2379,0,0,0,0,0,0,0,585,0,0,0,529,0,0,0,0,0,0,0,553,569,625
,665,0,0,2379,0,0,0,0,521,513,2411,0,2379,0,0,89,721,769,833,2379,0,0,1065
,0,2411,2411,2411,0,0,0,0,0,0,2411,2411,2411,0,0,0,2763,257,0,2411,2411
,2411,0,241,0,0,0,0,2763,0,2411,0,2763,2763,2411,3074,0,2963,0,0,2763,0
,2411,2411,2411,2411,0,0,2225,0,0,0,3170,2411,2411,2778,3162,0,0,0,2411
,2411,2411,2411,0,0,3234,2411,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,2786
,0,0,0,0,3138,0,0,2763,0,0,0,0,0,3194,0,0,2763,2763,0,3178,2763,0,0,0,0
,0,3242,0,0,0,961,0,3202,0,0,3186,0,3098,3082,3130,3122,3226,3090,3146,113
,865,913,0,0,0,3154,0,0,1906,489,505,0,0,0,0,0,0,465,497,729,0,961,0,0,0
,0,0,0,585,0,0,0,529,0,0,113,865,913,0,0,553,569,625,665,1906,489,505,0
,0,0,0,521,513,465,497,729,0,0,89,721,769,833,0,0,585,1065,0,0,529,2947
,0,0,0,0,0,0,553,569,625,665,0,0,0,0,0,0,2947,521,513,0,2947,0,0,0,89,721
,769,833,2954,0,2947,1065,0,0,0,0,2947,0,0,0,0,2947,0,2947,2947,0,0,0,0
,0,2947,0,0,0,0,0,0,0,0,2947,0,0,0,0,0,2947,0,0,0,0,0,0,2947,0,0,0,1779
,0,2947,0,0,2947,0,2947,2947,2947,2947,2947,2947,2947,1779,1779,1779,0,0
,0,2947,0,0,1779,1779,1779,0,0,0,0,0,0,1779,1779,1779,0,961,0,0,0,0,0,0
,1779,0,0,0,1779,0,0,113,865,913,0,0,1779,1779,1779,1779,1906,489,505,0
,0,0,0,1779,1779,465,497,729,0,961,1779,1779,1779,1779,0,0,585,1779,0,0
,529,0,0,113,865,913,0,0,553,569,625,665,1906,489,505,0,0,0,0,521,513,465
,497,729,0,2403,89,721,769,833,0,0,585,1065,0,0,529,0,0,2403,2403,2403,0
,0,553,569,625,665,2403,2403,2403,0,0,0,0,521,513,2403,2403,2403,0,0,89
,721,769,833,0,0,2403,1065,0,0,2403,971,0,0,0,0,0,0,2403,2403,2403,2403
,0,0,0,0,0,0,971,2403,2403,0,971,0,0,0,2403,2403,2403,2403,971,0,971,2403
,0,0,0,0,971,0,0,0,0,971,0,971,971,0,0,0,0,0,971,0,0,0,0,0,0,0,0,971,0,0
,0,0,0,971,0,0,0,0,0,0,971,3074,0,0,0,0,971,0,0,971,0,971,971,971,971,971
,971,971,3170,0,0,0,3162,0,971,0,0,0,0,0,1305,0,3234,0,0,0,0,0,3218,0,0
,0,0,3210,0,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,0,0,0,3194,0,0,0,0,0,3178
,0,0,0,0,0,0,3242,0,0,0,961,0,3202,0,0,3186,0,3098,3082,3130,3122,3226,3090
,3146,113,865,913,0,0,0,3154,0,0,1906,489,505,0,0,0,2763,257,0,465,497,729
,0,241,0,0,0,0,2763,0,585,0,2763,2763,529,3074,0,2963,0,0,2763,0,553,569
,625,665,0,0,2763,0,0,0,3170,521,513,2778,3162,0,0,0,89,721,769,833,0,0
,3234,1065,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,2786,0,0,0,0,3138,0,0,2763
,0,0,0,0,0,3194,0,0,2763,2763,0,3178,2763,0,0,0,0,0,3242,0,0,0,2251,0,3202
,0,0,3186,0,3098,3082,3130,3122,3226,3090,3146,2251,2251,2251,0,0,0,3154
,0,0,2251,2251,2251,0,0,0,2763,257,0,2251,2251,2251,0,241,0,0,0,0,2763,0
,2251,0,2763,2763,2251,3074,0,2963,0,0,2763,0,2251,2251,2251,2251,0,0,2225
,0,0,0,3170,2251,2251,2778,3162,0,0,0,2251,2251,2251,2251,0,0,3234,2251
,0,0,0,2763,3218,0,0,0,0,3210,0,3106,3114,2786,0,0,0,0,3138,0,0,0,0,0,0
,0,0,3194,0,0,2763,0,0,3178,2763,0,0,0,0,0,3242,0,0,0,1515,0,3202,0,0,3186
,0,3098,3082,3130,3122,3226,3090,3146,1515,1515,1515,0,0,0,3154,0,0,1515
,1515,1515,0,0,0,0,0,0,1515,1515,1515,0,961,0,0,0,0,0,0,1515,0,0,0,1515
,0,0,113,865,913,0,0,1515,1515,1515,1515,1906,489,505,0,0,0,0,1515,1515
,465,497,729,0,0,1515,1515,1515,1515,0,0,585,1515,0,0,529,3074,0,0,0,0,1705
,0,553,569,625,665,0,0,0,0,0,0,3170,521,513,0,3162,0,0,0,89,721,769,833
,0,0,3234,1065,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,0,0,3138,0,0
,0,0,0,0,0,0,3194,0,0,0,0,0,3178,0,0,0,0,0,0,3242,0,0,0,1491,0,3202,0,0
,3186,0,3098,3082,3130,3122,3226,3090,3146,1491,1491,1491,0,0,0,3154,0,0
,1491,1491,1491,0,0,0,0,0,0,1491,1491,1491,0,961,0,0,0,0,0,0,1491,0,0,0
,1491,0,0,113,865,913,0,0,1491,1491,1491,1491,1906,489,505,0,0,0,0,1491
,1491,465,497,729,0,961,1491,1491,1491,1491,0,0,585,1491,0,0,529,0,0,113
,865,913,0,0,553,569,625,665,1906,489,505,0,0,0,0,521,513,465,497,729,0
,0,89,721,769,833,0,0,585,1065,0,0,529,2947,0,0,0,0,0,0,553,569,625,665
,0,0,0,0,0,0,2947,521,513,0,2947,0,0,0,89,721,769,833,2954,0,2947,1065,0
,0,0,0,2947,0,0,0,0,2947,0,2947,2947,0,0,0,0,0,2947,0,0,0,0,0,0,0,0,2947
,0,0,0,0,0,2947,0,0,0,0,0,0,2947,0,0,0,587,0,2947,0,0,2947,0,2947,2947,2947
,2947,2947,2947,2947,587,587,587,0,0,0,2947,0,0,587,587,587,0,0,0,0,0,0
,587,587,587,0,961,0,0,0,0,0,0,587,0,0,0,587,0,0,113,865,913,0,0,587,587
,587,587,1906,489,505,0,0,0,0,587,587,465,497,729,0,1451,587,587,587,587
,0,0,585,587,0,0,529,0,0,1451,1451,1451,0,0,553,569,625,665,1451,1451,1451
,0,0,0,0,521,513,1451,1451,1451,0,961,89,721,769,833,0,0,1451,1065,0,0,1451
,0,0,113,865,913,0,0,1451,1451,1451,1451,1906,489,505,0,0,0,0,1451,1451
,465,497,729,0,2307,1451,1451,1451,1451,0,0,585,1451,0,0,529,0,0,2307,2307
,2307,0,0,553,569,625,665,2307,2307,2307,0,0,0,0,521,513,2307,2307,2307
,0,961,89,721,769,833,0,0,2307,1065,0,0,2307,0,0,113,865,913,0,0,2307,2307
,2307,2307,1906,489,505,0,0,0,0,2307,2307,465,497,729,0,961,2307,2307,2307
,2307,0,0,585,2307,0,0,529,0,0,113,865,913,0,0,553,569,625,665,1906,489
,505,0,0,0,0,521,513,465,497,729,0,2331,89,721,769,833,0,0,585,1065,0,0
,529,0,0,2331,2331,2331,0,0,553,569,625,665,2331,2331,2331,0,0,0,0,521,513
,2331,2331,2331,0,1299,89,721,769,833,0,0,2331,1065,0,0,2331,0,0,1299,1299
,1299,0,0,2331,2331,2331,2331,1299,1299,1299,0,0,0,0,2331,2331,1299,1299
,1299,0,961,2331,2331,2331,2331,0,0,1299,2331,0,0,1299,0,0,113,865,913,0
,0,1299,1299,1299,1299,1906,489,505,0,0,0,0,1299,1299,465,497,729,0,0,1299
,1299,1299,1299,0,0,585,1299,0,0,529,771,0,771,0,0,0,0,553,569,625,665,0
,0,0,0,0,0,771,521,513,0,771,0,0,0,89,721,769,833,0,0,771,1065,0,0,0,0,771
,0,0,0,0,771,0,771,771,0,0,0,0,0,771,0,0,0,0,0,0,0,0,771,0,0,0,0,0,771,0
,0,0,0,0,0,771,1163,0,0,0,0,771,0,0,771,0,771,771,771,771,771,771,771,1163
,0,0,0,1163,0,771,0,0,0,0,0,1163,0,1163,3074,0,0,0,0,1163,0,0,0,0,1163,0
,1163,1163,0,0,0,3170,0,1163,0,3162,0,0,0,0,0,0,1163,1305,0,3234,0,0,1163
,0,0,3218,0,0,0,1163,3210,0,3106,3114,0,1163,0,0,1163,3138,1163,1163,1163
,1163,1163,1163,1163,0,3194,0,0,0,0,1163,3178,0,0,0,0,0,0,3242,3074,0,2963
,0,0,3202,0,0,3186,0,3098,3082,3130,3122,3226,3090,3146,3170,0,0,0,3162
,0,3154,0,0,0,0,0,0,0,3234,3074,0,2963,0,0,3218,0,0,0,0,3210,0,3106,3114
,0,0,0,3170,0,3138,0,3162,0,0,0,0,0,0,3194,0,0,3234,0,0,3178,0,0,3218,0
,0,0,3242,3210,0,3106,3114,0,3202,0,0,3186,3138,3098,3082,3130,3122,3226
,3090,3146,0,3194,0,0,0,0,3154,3178,0,0,0,0,0,0,3242,3074,0,2963,0,0,3202
,0,0,3186,0,3098,3082,3130,3122,3226,3090,3146,3170,0,0,0,3162,0,3154,0
,0,0,0,0,0,0,3234,1643,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,1643
,0,3138,0,1643,0,0,0,0,0,0,3194,1643,0,1643,0,0,3178,0,0,1643,0,0,0,3242
,1643,0,1643,1643,0,3202,0,0,3186,1643,3098,3082,3130,3122,3226,3090,3146
,0,1643,0,0,0,0,3154,1643,0,0,0,0,0,0,1643,3074,0,0,0,0,1643,0,0,1643,0
,1643,1643,1643,1643,1643,1643,1643,3170,0,0,0,3162,0,1643,0,0,0,0,0,1305
,0,3234,3074,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,3170,0,3138,0,3162
,0,0,0,0,0,0,3194,1305,0,3234,0,0,3178,0,0,3218,0,0,0,3242,3210,0,3106,3114
,0,3202,0,0,3186,3138,3098,3082,3130,3122,3226,3090,3146,0,3194,0,0,0,0
,3154,3178,0,0,0,0,0,0,3242,0,0,0,961,0,3202,0,0,3186,0,3098,3082,3130,3122
,3226,3090,3146,113,865,913,0,0,0,3154,0,0,1906,489,505,0,0,0,0,0,0,465
,497,729,0,961,0,0,0,0,0,0,585,0,0,0,529,0,0,113,865,913,0,0,553,569,625
,665,1906,489,505,0,0,0,0,521,513,465,497,729,0,961,89,721,769,833,0,0,585
,1065,0,0,529,0,0,113,865,913,0,0,553,569,625,665,1906,489,505,0,0,0,0,521
,513,465,497,729,0,0,89,721,769,833,0,0,585,1065,0,0,529,3074,0,0,0,0,0
,0,553,569,625,665,0,0,0,0,0,0,3170,521,513,0,3162,0,0,0,89,721,769,833
,0,0,3234,1065,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,0,0,3138,0,0
,0,0,0,0,0,0,3194,0,0,0,0,0,3178,0,0,0,0,0,0,3242,3074,0,0,0,0,3202,0,0
,3186,0,3098,3082,3130,3122,3226,3090,3146,3170,0,0,0,3162,0,3154,0,0,0
,251,0,1305,0,3234,2427,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,2427
,0,3138,0,2427,0,0,0,0,0,0,3194,0,0,2427,0,0,3178,0,0,2427,0,0,0,3242,2427
,0,2427,2427,0,3202,0,0,3186,2427,3098,3082,3130,3122,3226,3090,3146,0,2427
,2427,0,0,0,3154,2427,0,0,0,0,0,0,2427,3074,0,0,0,0,2427,0,0,2427,0,2427
,2427,2427,2427,2427,2427,2427,3170,0,0,0,3162,0,2427,0,0,0,0,0,0,0,3234
,0,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,0,0,0
,3194,0,0,0,0,0,3178,0,0,0,0,0,0,3242,0,0,0,0,0,3202,961,0,3186,0,3098,3082
,3130,3122,3226,3090,3146,0,0,0,113,865,913,3154,0,0,0,235,0,1906,489,505
,0,0,0,0,0,0,465,497,729,0,0,0,0,0,0,0,0,585,0,0,0,529,3074,0,0,0,0,0,0
,553,569,625,665,0,0,0,0,0,0,3170,521,513,0,3162,0,0,0,89,721,769,833,1305
,0,3234,1065,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,0,0,3138,0,0,0
,0,0,0,0,0,3194,0,0,0,0,0,3178,0,0,0,0,0,0,3242,3074,0,0,0,0,3202,0,0,3186
,0,3098,3082,3130,3122,3226,3090,3146,3170,0,0,0,3162,0,3154,0,0,0,0,0,0
,0,3234,0,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,0,0,3138,0,0,0,0,0
,0,0,0,3194,3058,0,0,0,0,3178,0,0,0,0,0,0,3242,0,0,0,1531,0,3202,0,0,3186
,0,3098,3082,3130,3122,3226,3090,3146,1531,1531,1531,0,0,0,3154,0,0,1531
,1531,1531,0,0,0,0,0,0,1531,1531,1531,0,961,0,0,0,0,0,0,1531,0,0,0,1531
,0,0,113,865,913,0,0,1531,1531,1531,1531,1906,489,505,0,0,0,0,1531,1531
,465,497,729,0,843,1531,1531,1531,1531,0,0,585,1531,0,0,529,0,0,843,843
,843,0,0,553,569,625,665,843,843,843,0,0,0,0,521,513,843,843,843,0,0,89
,721,769,833,0,0,843,1065,0,0,843,3074,0,2963,0,0,0,0,843,843,843,843,0
,0,0,0,0,0,3170,843,843,0,3162,0,0,0,843,843,843,843,0,0,3234,843,0,0,0
,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,0,0,0,3194,0,0
,0,0,0,3178,0,0,0,0,0,0,3242,0,0,0,961,0,3202,0,0,3186,0,3098,3082,3130
,3122,3226,3090,3146,113,865,913,0,0,0,3154,0,0,1906,489,505,0,0,0,0,0,0
,465,497,729,0,0,0,0,0,0,0,0,585,0,0,0,529,3074,0,0,0,0,0,0,553,569,625
,665,0,0,0,0,0,0,3170,521,513,0,3162,0,0,0,89,721,769,833,0,0,3234,1065
,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,0,0,3138,0,0,0,0,0,0,0,0,3194
,3058,0,0,0,0,3178,0,0,0,0,0,0,3242,3074,0,0,0,0,3202,0,0,3186,0,3098,3082
,3130,3122,3226,3090,3146,3170,0,0,0,3162,0,3154,0,0,0,0,0,0,0,3234,403
,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,403,0,3138,0,403,0,0,0,0,0
,0,3194,0,0,403,0,0,3178,0,0,403,0,0,0,3242,403,0,403,403,0,3202,0,0,3186
,403,3098,3082,3130,3122,3226,3090,3146,0,403,0,0,0,0,3154,403,0,0,0,0,0
,0,403,3074,0,0,0,0,403,0,0,403,0,403,403,403,403,403,403,403,3170,0,0,0
,3162,0,403,0,0,0,0,0,0,0,3234,3074,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114
,0,0,0,3170,0,3138,0,3162,0,0,0,0,0,0,3194,0,0,3234,0,0,3178,0,0,3218,0
,0,0,3242,3210,0,3106,3114,0,3202,0,0,3186,3138,3098,3082,3130,3122,3226
,3090,3146,0,3194,0,0,0,0,3154,3178,0,0,0,0,0,0,3242,3074,0,0,0,0,3202,0
,0,3186,0,3098,3082,3130,3122,3226,3090,3146,3170,0,0,0,3162,0,3154,0,0
,0,0,0,0,0,3234,3074,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,3170,0
,3138,0,3162,0,0,0,0,0,0,3194,0,0,3234,0,0,3178,0,0,3218,0,0,0,3242,3210
,0,3106,3114,0,3202,0,0,3186,3138,3098,3082,3130,3122,3226,3090,3146,0,3194
,0,0,0,0,3154,3178,0,0,0,0,0,0,3242,531,0,0,0,0,3202,0,0,3186,0,3098,3082
,3130,3122,3226,3090,3146,531,0,0,0,531,0,3154,0,0,0,0,0,0,0,531,3074,0
,0,0,0,531,0,0,0,0,531,0,531,531,0,0,0,3170,0,531,0,3162,0,0,0,0,0,0,531
,0,0,3234,0,0,531,0,0,3218,0,0,0,531,3210,0,3106,3114,0,531,0,0,531,3138
,531,531,531,531,531,531,531,0,3194,0,0,0,0,531,3178,0,0,0,0,0,0,3242,3074
,0,0,0,0,3202,0,0,3186,0,3098,3082,3130,3122,3226,3090,3146,3170,0,0,0,3162
,0,3154,0,0,0,0,0,0,0,3234,699,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0
,0,699,0,3138,0,699,0,0,0,0,0,0,3194,0,0,699,0,0,3178,0,0,699,0,0,0,3242
,699,0,699,699,0,3202,0,0,3186,699,3098,3082,3130,3122,3226,3090,3146,0
,699,0,0,0,0,3154,699,0,0,0,0,0,0,699,3074,0,0,0,0,699,0,0,699,0,699,699
,699,699,699,699,699,3170,0,0,0,3162,0,699,0,0,0,0,0,0,0,3234,3074,0,0,0
,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,3170,0,3138,0,3162,0,0,0,0,0,0,3194
,0,0,3234,0,0,3178,0,0,3218,0,0,0,3242,3210,0,3106,3114,0,3202,0,0,3186
,3138,3098,3082,3130,3122,3226,3090,3146,0,3194,0,0,0,0,3154,3178,0,0,0
,0,0,0,3242,555,0,0,0,0,3202,0,0,3186,0,3098,3082,3130,3122,3226,3090,3146
,555,0,0,0,555,0,3154,0,0,0,0,0,0,0,555,3074,0,0,0,0,555,0,0,0,0,555,0,555
,555,0,0,0,3170,0,555,0,3162,0,0,0,0,0,0,555,0,0,3234,0,0,555,0,0,3218,0
,0,0,555,3210,0,3106,3114,0,555,0,0,555,3138,555,555,555,555,555,555,555
,0,3194,0,0,0,0,555,3178,0,0,0,0,0,0,3242,2187,0,0,0,0,3202,0,0,3186,0,3098
,3082,3130,3122,3226,3090,3146,2187,0,0,0,2187,0,3154,0,0,0,0,0,0,0,2187
,3074,0,0,0,0,2187,0,0,0,0,2187,0,2187,2187,0,0,0,3170,0,2187,0,3162,0,0
,0,0,0,0,2187,0,0,3234,0,0,2187,0,0,3218,0,0,0,2187,3210,0,3106,3114,0,2187
,0,0,2187,3138,2187,2187,2187,2187,2187,2187,2187,0,3194,0,0,0,0,2187,3178
,0,0,0,0,0,0,3242,3074,0,0,0,0,3202,0,0,3186,0,3098,3082,3130,3122,3226
,3090,3146,3170,0,0,0,3162,0,3154,0,0,0,0,0,0,0,3234,2163,0,0,0,0,3218,0
,0,0,0,3210,0,3106,3114,0,0,0,2163,0,3138,0,2163,0,0,0,0,0,0,3194,0,0,2163
,0,0,3178,0,0,2163,0,0,0,3242,2163,0,2163,2163,0,3202,0,0,3186,2163,3098
,3082,3130,3122,3226,3090,3146,0,2163,0,0,0,0,3154,2163,0,0,0,0,0,0,2163
,3074,0,0,0,0,2163,0,0,2163,0,2163,2163,2163,2163,2163,2163,2163,3170,0
,0,0,3162,0,2163,0,0,0,0,0,0,0,3234,3074,0,0,0,0,3218,0,0,0,0,3210,0,3106
,3114,0,0,0,3170,0,3138,0,3162,0,0,0,0,0,0,3194,0,0,3234,0,0,3178,0,0,3218
,0,0,0,3242,3210,0,3106,3114,0,3202,0,0,3186,3138,3098,3082,3130,3122,3226
,3090,3146,0,3194,0,0,0,0,3154,3178,0,0,0,0,0,0,3242,3074,0,0,0,0,3202,0
,0,3186,0,3098,3082,3130,3122,3226,3090,3146,3170,0,0,0,3162,0,3154,0,0
,0,0,0,0,0,3234,3074,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,3170,0
,3138,0,3162,0,0,0,0,0,0,3194,0,0,3234,0,0,3178,0,0,3218,0,0,0,3242,3210
,0,3106,3114,0,3202,0,0,3186,3138,3098,3082,3130,3122,3226,3090,3146,0,3194
,0,0,0,0,3154,3178,0,0,0,0,0,0,3242,3074,0,0,0,0,3202,0,0,3186,0,3098,3082
,3130,3122,3226,3090,3146,3170,0,0,0,3162,0,3154,0,0,0,0,0,0,0,3234,1027
,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,1027,0,3138,0,1027,0,0,0,0
,0,0,3194,0,0,1027,0,0,3178,0,0,1027,0,0,0,3242,1027,0,1027,1027,0,3202
,0,0,3186,1027,3098,3082,3130,3122,3226,3090,3146,0,1027,0,0,0,0,3154,1027
,0,0,0,0,0,0,1027,3074,0,0,0,0,1027,0,0,1027,0,1027,1027,1027,1027,1027
,1027,1027,3170,0,0,0,3162,0,1027,0,0,0,0,0,0,0,3234,3074,0,0,0,0,3218,0
,0,0,0,3210,0,3106,3114,0,0,0,3170,0,3138,0,3162,0,0,0,0,0,0,3194,0,0,3234
,0,0,3178,0,0,3218,0,0,0,3242,3210,0,3106,3114,0,3202,0,0,3186,3138,3098
,3082,3130,3122,3226,3090,3146,0,3194,0,0,0,0,3154,3178,0,0,0,0,0,0,3242
,3074,0,0,0,0,3202,0,0,3186,0,3098,3082,3130,3122,3226,3090,3146,3170,0
,0,0,3162,0,3154,0,0,0,0,0,0,0,3234,1347,0,0,0,0,3218,0,0,0,0,3210,0,3106
,3114,0,0,0,1347,0,3138,0,1347,0,0,0,0,0,0,3194,0,0,1347,0,0,3178,0,0,1347
,0,0,0,3242,1347,0,1347,1347,0,3202,0,0,3186,1347,3098,3082,3130,3122,3226
,3090,3146,0,1347,0,0,0,0,3154,1347,0,0,0,0,0,0,1347,3074,0,0,0,0,1347,0
,0,1347,0,1347,1347,1347,1347,1347,1347,1347,3170,0,0,0,3162,0,1347,0,0
,0,0,0,0,0,3234,3074,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114,0,0,0,3170,0
,3138,0,3162,0,0,0,0,0,0,3194,0,0,3234,0,0,3178,0,0,3218,0,0,0,3242,3210
,0,3106,3114,0,3202,0,0,3186,3138,3098,3082,3130,3122,3226,3090,3146,0,3194
,0,0,0,0,3154,3178,0,0,0,0,0,0,3242,2179,0,0,0,0,3202,0,0,3186,0,3098,3082
,3130,3122,3226,3090,3146,2179,0,0,0,2179,0,3154,0,0,0,0,0,0,0,2179,331
,0,0,0,0,2179,0,0,0,0,2179,0,2179,2179,0,0,0,331,0,2179,0,331,0,0,0,0,0
,0,2179,0,0,331,0,0,2179,0,0,331,0,0,0,2179,331,0,331,331,0,2179,0,0,2179
,331,2179,2179,2179,2179,2179,2179,2179,0,331,0,0,0,0,2179,331,0,0,0,0,0
,0,331,3074,0,0,0,0,331,0,0,331,0,331,331,331,331,331,331,331,3170,0,0,0
,3162,0,331,0,0,0,0,0,0,0,3234,3074,0,0,0,0,3218,0,0,0,0,3210,0,3106,3114
,0,0,0,3170,0,3138,0,3162,0,0,0,0,0,0,3194,0,0,3234,0,0,3178,0,0,3218,0
,0,0,3242,3210,0,3106,3114,0,3202,0,0,3186,3138,3098,3082,3130,3122,3226
,3090,3146,0,3194,0,0,0,0,3154,3178,0,0,0,0,0,0,3242,35,0,0,0,0,3202,0,0
,3186,0,3098,3082,3130,3122,3226,3090,3146,35,0,0,0,35,0,3154,0,0,0,0,0
,0,0,35,3074,0,0,0,0,35,0,0,0,0,35,0,35,35,0,0,0,3170,0,35,0,3162,0,0,0
,0,0,0,35,0,0,3234,0,0,35,0,0,3218,0,0,0,35,3210,0,3106,3114,0,35,0,0,35
,3138,35,35,35,35,35,35,35,0,3194,0,0,0,0,35,3178,0,0,0,0,0,0,3242,0,0,0
,0,0,3202,0,0,3186,0,3098,3082,3130,3122,3226,3090,3146,0,2947,0,0,0,2842
,3154,2826,2834,2850,2947,2947,3074,0,1202,2947,0,0,0,0,0,2947,2947,2947
,2947,2947,0,2954,0,3170,1210,1218,0,3162,0,0,0,0,0,0,0,0,0,3234,1137,0
,0,0,0,3218,0,0,0,2947,3210,0,3106,3114,0,0,2947,0,0,3138,2842,0,2826,2834
,2850,2947,2947,0,3194,1202,2947,0,0,0,3178,2947,2947,2947,2947,2947,2947
,3242,2954,0,2947,1210,1218,3202,0,0,3186,2947,3098,3082,3130,3122,3226
,3090,3146,0,0,0,0,0,0,3154,0,0,2947,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,2947,0,0,0,0,0,0,0,0,2947,0,0,0,0,0,0,2947}
,
{1,363,248,26,26,26,98,26,26,178,26,26,26,26,26,26,26,26,26,26,210,26,105
,26,26,26,26,26,26,248,26,26,151,26,26,26,26,26,244,105,33,97,248,309,26
,26,26,26,248,327,26,244,210,26,26,26,26,244,97,309,309,248,316,210,26,327
,327,151,26,280,244,132,15,243,65,210,26,26,26,26,316,280,26,301,15,280
,280,26,26,121,204,26,243,280,26,26,26,26,26,301,301,26,204,301,301,204
,268,316,316,270,25,301,301,116,301,301,301,301,301,301,301,204,270,301
,121,301,301,301,301,301,267,204,268,65,301,301,301,301,190,35,190,270,280
,301,267,268,301,301,116,301,301,280,280,76,301,280,301,301,301,301,301
,301,301,66,268,301,205,301,301,301,301,301,301,301,208,148,301,301,301
,301,301,301,301,301,112,301,261,223,217,160,102,208,233,148,208,208,112
,160,205,271,223,217,261,261,208,208,223,217,208,208,208,208,271,6,208,148
,208,208,208,208,217,208,66,101,233,208,208,208,208,331,160,208,208,208
,208,101,160,208,39,125,208,208,88,208,208,138,39,208,160,208,208,208,208
,208,88,298,208,125,208,208,208,208,208,208,208,208,208,208,208,208,208
,208,208,139,208,21,21,21,59,21,21,331,21,21,21,21,21,21,183,21,21,21,183
,21,0,302,21,21,21,21,21,0,21,21,106,21,21,21,21,21,60,0,0,144,81,192,21
,21,21,21,109,61,21,0,0,21,21,21,21,83,62,113,74,251,85,253,21,0,0,0,21
,75,63,317,318,0,0,74,21,21,21,21,0,74,21,84,75,64,320,21,21,84,75,21,117
,155,21,21,21,21,21,228,156,21,324,51,228,230,326,230,44,228,159,67,161
,74,209,68,228,332,230,228,228,84,75,163,230,211,209,69,213,209,228,337
,84,228,228,228,228,228,228,74,338,228,228,228,228,209,269,84,75,165,228
,228,228,228,70,209,228,272,273,228,228,216,228,228,79,228,228,94,228,346
,79,218,228,219,228,228,228,228,228,228,180,228,71,228,228,228,228,228,228
,228,228,169,228,228,228,228,228,180,222,228,180,180,79,126,353,282,355
,127,284,128,173,180,12,361,180,180,180,180,362,363,180,363,180,180,180
,180,363,180,79,363,363,180,180,180,180,363,363,180,180,180,180,363,363
,180,363,363,180,180,363,180,180,363,363,180,363,180,180,180,180,180,363
,363,180,363,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180
,237,180,363,363,237,363,237,237,237,237,237,237,363,237,237,363,363,237
,363,363,237,237,237,237,237,237,237,237,363,237,237,237,237,237,363,363
,363,363,237,363,237,237,237,237,237,276,363,80,363,237,237,237,237,80,363
,363,363,276,363,363,237,276,276,363,237,363,363,363,363,276,276,276,237
,237,237,237,363,276,237,363,363,363,363,237,237,80,363,237,363,363,237
,237,237,237,237,147,363,237,363,147,363,147,147,147,147,147,363,363,147
,147,363,80,147,363,363,147,147,147,147,147,147,147,363,363,147,147,147
,147,147,363,363,276,363,363,363,147,147,147,147,363,249,363,28,363,147
,147,147,147,28,363,363,363,249,363,363,147,249,249,363,147,363,363,363
,363,249,249,249,147,147,147,147,5,363,147,363,363,363,5,147,147,28,363
,147,363,363,147,147,147,147,147,143,363,147,363,143,363,143,143,143,143
,143,363,363,143,143,363,28,143,363,5,143,143,143,143,143,143,143,363,363
,143,143,143,143,143,363,363,249,363,4,363,143,143,143,143,4,5,363,363,363
,143,143,143,143,363,363,363,363,363,363,363,143,363,27,363,143,363,363
,363,27,363,363,363,143,143,143,143,4,363,143,363,363,363,363,143,143,363
,363,143,363,363,143,143,143,143,143,256,363,143,363,256,27,363,4,363,363
,363,363,256,363,363,363,256,256,256,256,256,363,363,3,256,256,256,256,256
,256,3,27,250,363,256,363,256,256,256,363,3,3,3,363,250,363,363,256,250
,250,363,256,3,3,363,256,250,250,250,256,256,256,256,363,363,363,363,3,3
,363,256,256,279,256,3,3,363,256,256,256,256,3,256,256,256,363,256,363,279
,279,363,363,363,279,363,279,363,363,363,363,279,363,363,279,279,279,363
,363,363,279,363,363,279,279,279,363,279,279,250,363,279,363,363,279,363
,363,23,279,363,363,363,363,279,363,363,23,23,363,279,363,23,363,363,279
,363,279,23,23,23,23,23,279,363,279,279,363,279,279,279,279,279,279,279
,254,363,363,363,254,363,279,279,279,363,363,279,254,363,363,23,254,254
,254,254,254,363,363,363,254,254,254,254,254,254,363,363,363,363,254,363
,254,254,254,363,363,23,363,363,363,363,363,254,363,363,23,254,363,363,363
,254,363,23,363,254,254,254,254,363,363,363,363,363,363,363,254,254,297
,254,363,363,363,254,254,254,254,363,254,254,254,363,254,363,297,297,2,363
,363,297,363,363,363,2,363,363,297,297,363,297,297,297,363,2,2,297,363,363
,297,363,297,363,297,297,297,2,2,363,363,297,363,363,363,363,363,363,363
,363,297,363,2,2,297,363,297,363,363,2,2,297,363,297,297,363,2,363,363,297
,186,363,297,363,297,297,297,297,297,297,297,363,363,363,186,186,186,297
,297,297,186,363,297,186,186,186,363,186,363,363,363,363,186,186,186,363
,363,186,186,186,363,363,363,186,363,363,363,186,363,186,186,363,363,363
,363,186,186,186,186,363,363,363,363,363,186,186,186,186,363,285,363,186
,186,186,186,186,186,46,186,363,186,285,46,363,363,285,285,46,363,363,363
,363,363,285,46,363,363,363,46,285,363,363,363,363,363,363,363,363,46,363
,363,363,363,363,46,46,46,363,363,46,46,46,46,363,285,363,285,285,46,363
,363,363,363,363,46,363,363,46,46,363,363,46,285,46,46,363,46,363,363,363
,46,285,285,363,363,285,46,46,363,46,363,46,46,46,46,46,46,46,46,363,47
,363,363,363,46,47,363,363,363,363,47,363,363,363,363,363,363,47,363,363
,363,47,363,363,363,363,363,363,363,363,363,47,363,363,363,363,363,47,47
,47,363,363,47,47,47,47,363,363,363,363,363,47,363,363,363,363,363,47,363
,363,47,47,363,363,47,363,47,47,363,47,363,363,363,47,363,363,363,363,363
,47,47,363,47,363,47,47,47,47,47,47,47,47,363,48,363,363,363,47,48,363,363
,363,363,48,363,363,363,363,363,363,48,363,363,363,48,363,363,363,363,363
,363,363,363,363,48,363,363,363,363,363,48,48,48,363,363,48,48,48,48,363
,363,363,363,363,48,363,363,363,363,363,48,363,363,48,48,363,363,48,363
,48,48,363,48,363,363,363,48,363,363,363,363,363,48,48,363,48,363,48,48
,48,48,48,48,48,48,363,49,363,363,363,48,49,363,363,363,363,49,363,363,363
,363,363,363,49,363,363,363,49,363,363,363,363,363,363,363,363,363,49,363
,363,363,363,363,49,49,49,363,363,49,49,49,49,363,363,363,363,363,49,363
,363,363,363,363,49,363,363,49,49,363,363,49,363,49,49,363,49,363,363,363
,49,363,363,363,363,363,49,49,363,49,363,49,49,49,49,49,49,49,49,363,50
,363,363,363,49,50,363,363,363,363,50,363,363,363,363,363,363,50,363,363
,363,50,363,363,363,363,363,363,363,363,363,50,363,363,363,363,363,50,50
,50,363,363,50,50,50,50,363,363,363,363,363,50,363,363,363,363,363,50,363
,363,50,50,363,363,50,363,50,50,363,50,363,363,363,50,363,363,363,363,363
,50,50,363,50,363,50,50,50,50,50,50,50,50,363,52,363,363,363,50,52,363,363
,363,363,52,363,363,363,363,363,363,52,363,363,363,52,363,363,363,363,363
,363,363,363,363,52,363,363,363,363,363,52,52,52,363,363,52,52,52,52,363
,363,363,363,363,52,363,363,363,363,363,52,363,363,52,52,363,363,52,363
,52,52,363,52,363,363,363,52,363,363,363,363,363,52,52,363,52,363,52,52
,52,52,52,52,52,52,363,53,363,363,363,52,53,363,363,363,363,53,363,363,363
,363,363,363,53,363,363,363,53,363,363,363,363,363,363,363,363,363,53,363
,363,363,363,363,53,53,53,363,363,53,53,53,53,363,363,363,363,363,53,363
,363,363,363,363,53,363,363,53,53,363,363,53,363,53,53,363,53,363,363,363
,53,363,363,363,363,363,53,53,363,53,363,53,53,53,53,53,53,53,53,363,54
,363,363,363,53,54,363,363,363,363,54,363,363,363,363,363,363,54,363,363
,363,54,363,363,363,363,363,363,363,363,363,54,363,363,363,363,363,54,54
,54,363,363,54,54,54,54,363,363,363,363,363,54,363,363,363,363,363,54,363
,363,54,54,363,363,54,363,54,54,363,54,363,363,363,54,363,363,363,363,363
,54,54,363,54,363,54,54,54,54,54,54,54,54,363,86,363,363,363,54,86,363,363
,363,363,86,363,363,363,363,363,363,86,363,363,363,86,363,363,363,363,363
,363,363,363,363,86,363,363,363,363,363,86,86,86,363,363,86,86,86,86,363
,363,363,363,363,86,363,363,363,363,363,86,363,363,86,86,363,363,86,363
,86,86,363,86,363,363,363,86,363,363,363,363,363,86,86,363,86,363,86,86
,86,86,86,86,86,86,363,87,363,363,363,86,87,363,363,363,363,87,363,363,363
,363,363,363,87,363,363,363,87,363,363,363,363,363,363,363,363,363,87,363
,363,363,363,363,87,87,87,363,363,87,87,87,87,363,363,363,363,363,87,363
,363,363,363,363,87,363,363,87,87,363,363,87,363,87,87,363,87,363,363,363
,87,363,363,363,363,363,87,87,363,87,363,87,87,87,87,87,87,87,87,363,99
,363,363,363,87,99,363,363,363,363,99,363,363,363,363,363,363,99,363,363
,363,99,363,363,363,363,363,363,363,363,363,99,363,363,363,363,363,99,99
,99,363,363,99,99,99,99,363,363,363,363,363,99,363,363,363,363,363,99,363
,363,99,99,363,363,99,363,99,99,363,99,363,363,363,99,363,363,363,363,363
,99,99,363,99,363,99,99,99,99,99,99,99,99,363,100,363,363,363,99,100,363
,363,363,363,100,363,363,363,363,363,363,100,363,363,363,100,363,363,363
,363,363,363,363,363,363,100,363,363,363,363,363,100,100,100,363,363,100
,100,100,100,363,363,363,363,363,100,363,363,363,363,363,100,363,363,100
,100,363,363,100,363,100,100,363,100,363,363,363,100,363,363,363,363,363
,100,100,363,100,363,100,100,100,100,100,100,100,100,363,110,363,363,363
,100,110,363,363,363,363,110,363,363,363,363,363,363,110,363,363,363,110
,363,363,363,363,363,363,363,363,363,110,363,363,363,363,363,110,110,110
,363,363,110,110,110,110,363,363,363,363,363,110,363,363,363,363,363,110
,363,363,110,110,363,363,110,363,110,110,363,110,363,363,363,110,363,363
,363,363,363,110,110,363,110,363,110,110,110,110,110,110,110,110,363,111
,363,363,363,110,111,363,363,363,363,111,363,363,363,363,363,363,111,363
,363,363,111,363,363,363,363,363,363,363,363,363,111,363,363,363,363,363
,111,111,111,363,363,111,111,111,111,363,363,363,363,363,111,363,363,363
,363,363,111,363,363,111,111,363,363,111,363,111,111,363,111,363,363,363
,111,363,363,363,363,363,111,111,363,111,363,111,111,111,111,111,111,111
,111,363,119,363,363,363,111,119,363,363,363,363,119,363,363,363,363,363
,363,119,363,363,363,119,363,363,363,363,363,363,363,363,363,119,363,363
,363,363,363,119,119,119,363,363,119,119,119,119,363,363,363,363,363,119
,363,363,363,363,363,119,363,363,119,119,363,363,119,363,119,119,363,119
,363,363,363,119,363,363,363,363,363,119,119,363,119,363,119,119,119,119
,119,119,119,119,363,120,363,363,363,119,120,363,363,363,363,120,363,363
,363,363,363,363,120,363,363,363,120,363,363,363,363,363,363,363,363,363
,120,363,363,363,363,363,120,120,120,363,363,120,120,120,120,363,363,363
,363,363,120,363,363,363,363,363,120,363,363,120,120,363,363,120,363,120
,120,363,120,363,363,363,120,363,363,363,363,363,120,120,363,120,363,120
,120,120,120,120,120,120,120,363,133,363,363,363,120,133,363,363,363,363
,133,363,363,363,363,363,363,133,363,363,363,133,363,363,363,363,363,363
,363,363,363,133,363,363,363,363,363,133,133,133,363,363,133,133,133,133
,363,363,363,363,363,133,363,363,363,363,363,133,363,363,133,133,363,363
,133,363,133,133,363,133,363,363,363,133,363,363,363,363,363,133,133,363
,133,363,133,133,133,133,133,133,133,133,363,134,363,363,363,133,134,363
,363,363,363,134,363,363,363,363,363,363,134,363,363,363,134,363,363,363
,363,363,363,363,363,363,134,363,363,363,363,363,134,134,134,363,363,134
,134,134,134,363,363,363,363,363,134,363,363,363,363,363,134,363,363,134
,134,363,363,134,363,134,134,363,134,363,363,363,134,363,363,363,363,363
,134,134,363,134,363,134,134,134,134,134,134,134,134,363,16,363,363,363
,134,16,363,363,363,363,16,363,363,363,363,363,363,16,363,363,363,16,363
,363,363,363,363,363,363,363,363,16,363,363,363,363,363,16,16,16,363,363
,16,16,16,16,363,363,363,363,363,16,363,363,363,363,363,16,363,363,16,16
,363,363,16,363,16,16,363,16,363,363,363,16,363,363,363,363,363,16,16,363
,16,363,16,16,16,16,16,16,16,16,363,17,363,363,363,16,17,363,363,363,363
,17,363,363,363,363,363,363,17,363,363,363,17,363,363,363,363,363,363,363
,363,363,17,363,363,363,363,363,17,17,17,363,363,17,17,17,17,363,363,363
,363,363,17,363,363,363,363,363,17,363,363,17,17,363,363,17,363,17,17,363
,17,363,363,363,17,363,363,363,363,363,17,17,363,17,363,17,17,17,17,17,17
,17,17,363,149,363,363,363,17,149,363,363,363,363,149,363,363,363,363,363
,363,149,363,363,363,149,363,363,363,363,363,363,363,363,363,149,363,363
,363,363,363,149,149,149,363,363,149,149,149,149,363,363,363,363,363,149
,363,363,363,363,363,149,363,363,149,149,363,363,149,363,149,149,363,149
,363,363,363,149,363,363,363,363,363,149,149,363,149,363,149,149,149,149
,149,149,149,149,363,150,363,363,363,149,150,363,363,363,363,150,363,363
,363,363,363,363,150,363,363,363,150,363,363,363,363,363,363,363,363,363
,150,363,363,363,363,363,150,150,150,363,363,150,150,150,150,363,363,363
,363,363,150,363,363,363,363,363,150,363,363,150,150,363,363,150,363,150
,150,363,150,363,363,363,150,363,363,363,363,363,150,150,363,150,363,150
,150,150,150,150,150,150,150,363,19,363,363,363,150,19,363,363,363,363,19
,363,363,363,363,363,363,19,363,363,363,19,363,363,363,363,363,363,363,363
,363,19,363,363,363,363,363,19,19,19,363,363,19,19,19,19,363,363,363,363
,363,19,363,363,363,363,363,19,363,363,19,19,363,363,19,363,19,19,363,19
,363,363,363,19,363,363,363,363,363,19,19,363,19,363,19,19,19,19,19,19,19
,19,363,181,363,363,363,19,181,363,363,363,363,181,363,363,363,363,363,363
,181,363,363,363,181,363,363,363,363,363,363,363,363,363,181,363,363,363
,363,363,181,181,181,363,363,181,181,181,181,363,363,363,363,363,181,363
,363,363,363,363,181,363,363,181,181,363,363,181,363,181,181,363,181,363
,363,363,181,363,363,363,363,363,181,181,363,181,363,181,181,181,181,181
,181,181,181,363,182,363,363,363,181,182,363,363,363,363,182,363,363,363
,363,363,363,182,363,363,363,182,363,363,363,363,363,363,363,363,363,182
,363,363,363,363,363,182,182,182,363,363,182,182,182,182,363,363,363,363
,363,182,363,363,363,363,363,182,363,363,182,182,363,363,182,363,182,182
,363,182,363,363,363,182,363,363,363,363,363,182,182,363,182,363,182,182
,182,182,182,182,182,182,363,20,363,363,363,182,20,363,363,363,363,20,363
,363,363,363,363,363,20,363,363,363,20,363,363,363,363,363,363,363,363,363
,20,363,363,363,363,363,20,20,20,363,363,20,20,20,20,363,363,363,363,363
,20,363,363,363,363,363,20,363,363,20,20,363,363,20,363,20,20,363,20,363
,363,363,20,363,363,363,363,363,20,20,363,20,363,20,20,20,20,20,20,20,20
,363,13,363,363,363,20,13,363,363,363,363,13,363,363,363,363,363,363,13
,363,363,363,13,363,363,363,363,363,363,363,363,363,13,363,363,363,363,363
,13,13,13,363,363,13,13,13,13,363,363,363,363,363,13,363,363,363,363,363
,13,363,363,13,13,363,363,13,363,13,13,363,13,363,363,363,13,363,363,363
,363,363,13,13,363,13,363,13,13,13,13,13,13,13,13,363,24,363,363,363,13
,24,363,363,363,363,24,363,363,363,363,363,363,24,363,363,363,24,363,363
,363,363,363,363,363,363,363,24,363,363,363,363,363,24,24,24,363,363,24
,24,24,24,363,363,363,363,363,24,363,363,363,363,363,24,363,363,24,24,363
,363,24,363,24,24,363,24,363,363,363,24,363,363,363,363,363,24,24,363,24
,363,24,24,24,24,24,24,24,24,363,231,363,363,363,24,231,363,363,363,363
,231,363,363,363,363,363,363,231,363,363,363,231,363,363,363,363,363,363
,363,363,363,231,363,363,363,363,363,231,231,231,363,363,231,231,231,231
,363,363,363,363,363,231,363,363,363,363,363,231,363,363,231,231,363,363
,231,363,231,231,363,231,363,363,363,231,363,363,363,363,363,231,231,363
,231,363,231,231,231,231,231,231,231,231,363,232,363,363,363,231,232,363
,363,363,363,232,363,363,363,363,363,363,232,363,363,363,232,363,363,363
,363,363,363,363,363,363,232,363,363,363,363,363,232,232,232,363,363,232
,232,232,232,363,363,363,363,363,232,363,363,363,363,363,232,363,363,232
,232,363,363,232,363,232,232,363,232,363,363,363,232,363,363,363,363,363
,232,232,363,232,363,232,232,232,232,232,232,232,232,363,14,363,363,363
,232,14,363,363,363,363,14,363,363,363,363,363,363,14,363,363,363,14,363
,363,363,363,363,363,363,363,363,14,363,363,363,363,363,14,14,14,363,363
,14,14,14,14,363,363,363,363,363,14,363,363,363,363,363,14,363,363,14,14
,363,363,14,363,14,14,363,14,363,363,363,14,363,363,363,363,363,14,14,363
,14,363,14,14,14,14,14,14,14,14,363,37,363,363,363,14,37,363,363,363,363
,37,363,363,363,363,363,363,37,363,363,363,37,363,363,363,363,363,363,363
,363,363,37,363,363,363,363,363,37,37,37,363,363,37,37,37,37,363,363,363
,363,363,37,363,363,363,363,363,37,363,363,37,37,363,363,37,363,37,37,363
,37,363,363,363,37,363,363,363,363,363,37,37,363,37,363,37,37,37,37,37,37
,37,37,363,38,363,363,363,37,38,363,363,363,363,38,363,363,363,363,363,363
,38,363,363,363,38,363,363,363,363,363,363,363,363,363,38,363,363,363,363
,363,38,38,38,363,363,38,38,38,38,363,363,363,363,363,38,363,363,363,363
,363,38,363,363,38,38,363,363,38,363,38,38,363,38,363,363,363,38,363,363
,363,363,363,38,38,363,38,363,38,38,38,38,38,38,38,38,363,42,363,363,363
,38,42,363,363,363,363,42,363,363,363,363,363,333,42,363,363,363,42,363
,363,363,363,363,363,333,363,363,42,333,333,363,363,363,42,42,42,333,363
,42,42,42,42,363,363,363,363,333,42,363,363,363,363,363,42,363,363,42,42
,363,363,42,363,42,42,363,42,363,333,363,42,363,363,363,363,363,42,42,363
,42,363,42,42,42,42,42,42,42,42,294,363,363,363,294,42,333,363,363,363,333
,363,294,363,363,363,294,294,294,294,294,363,363,363,294,363,363,294,294
,294,294,363,323,363,363,363,294,294,294,363,363,322,363,363,323,363,363
,294,323,323,363,294,363,322,363,294,323,322,322,294,294,294,294,363,43
,322,363,363,363,43,294,294,363,294,43,363,363,294,294,294,294,43,294,294
,294,43,294,323,363,363,363,363,363,363,363,43,322,363,363,363,363,43,43
,43,363,363,43,43,43,43,363,363,363,363,323,43,363,363,323,363,363,43,363
,322,43,43,363,322,43,363,43,43,363,43,363,363,363,43,363,363,363,363,363
,43,43,363,43,363,43,43,43,43,43,43,43,43,363,45,363,363,363,43,45,363,363
,363,363,45,363,363,363,363,363,363,45,363,363,363,45,363,363,363,363,363
,363,363,363,363,45,363,363,363,363,363,45,45,45,363,363,45,45,45,45,363
,363,363,363,363,45,363,363,363,363,363,45,363,363,45,45,363,363,45,363
,45,45,363,45,363,363,363,45,363,363,363,363,363,45,45,363,45,363,45,45
,45,45,45,45,45,45,363,339,363,363,363,45,339,363,363,363,363,339,363,363
,363,363,363,363,339,363,363,363,339,363,363,363,363,363,363,363,363,363
,339,363,363,363,363,363,339,339,339,363,363,339,339,339,339,363,363,363
,363,363,339,363,363,363,363,363,339,363,363,339,339,363,363,339,363,339
,339,363,339,363,363,363,339,363,363,363,363,363,339,339,363,339,363,339
,339,339,339,339,339,339,339,363,340,363,363,363,339,340,363,363,363,363
,340,363,363,363,363,363,363,340,363,363,363,340,363,363,363,363,363,363
,363,363,363,340,363,363,363,363,363,340,340,340,363,363,340,340,340,340
,363,363,363,363,363,340,363,363,363,363,363,340,363,281,340,340,363,363
,340,363,340,340,363,340,363,281,363,340,363,281,281,363,363,340,340,363
,340,281,340,340,340,340,340,340,340,340,291,363,363,363,291,340,363,363
,363,363,363,363,291,363,363,363,291,291,291,291,291,363,363,363,291,363
,363,291,291,291,363,363,363,363,363,363,291,291,291,363,281,363,363,363
,363,363,363,291,363,281,281,291,363,281,363,291,363,363,363,291,291,291
,291,363,175,363,363,363,363,363,291,291,363,291,363,363,363,291,291,291
,291,175,291,291,291,175,291,363,363,363,363,363,363,175,363,175,363,363
,363,363,363,175,363,363,175,363,175,363,175,175,363,175,363,363,363,175
,363,363,363,363,363,175,175,175,175,363,363,363,363,363,175,363,363,175
,175,363,363,175,363,363,363,363,201,175,363,363,175,363,175,175,175,175
,175,175,175,175,175,363,363,201,363,175,175,201,363,363,363,363,363,363
,363,363,201,201,363,363,363,363,363,201,363,363,201,363,201,363,201,201
,363,201,363,363,363,201,363,363,363,363,363,201,201,201,201,363,363,363
,363,363,201,363,363,201,201,363,363,201,363,363,363,363,158,201,363,363
,201,363,201,201,201,201,201,201,201,201,201,363,363,158,363,201,201,158
,363,363,363,363,363,363,363,158,363,158,363,363,363,363,363,158,363,363
,158,363,158,363,158,158,363,158,363,363,363,158,363,363,363,363,363,158
,158,158,158,363,363,363,363,363,158,363,363,158,158,363,363,158,363,363
,363,363,167,158,363,363,158,363,158,158,158,158,158,158,158,158,158,363
,363,167,363,158,158,167,363,363,363,363,363,363,363,167,363,167,363,363
,363,363,363,167,363,363,167,363,167,363,167,167,363,167,363,363,363,167
,363,363,363,363,363,167,167,167,167,363,363,363,363,363,167,363,363,167
,167,363,363,167,363,363,363,363,171,167,363,363,167,363,167,167,167,167
,167,167,167,167,167,363,363,171,363,167,167,171,363,363,363,363,363,363
,363,171,363,171,363,363,363,363,363,171,363,363,171,363,171,363,171,171
,363,171,363,363,363,171,363,363,363,363,363,171,171,171,171,363,363,363
,363,363,171,363,363,171,171,363,363,171,363,363,363,363,177,171,363,363
,171,363,171,171,171,171,171,171,171,171,171,363,363,177,363,171,171,177
,363,363,363,363,363,363,363,363,363,177,363,363,363,363,363,177,363,363
,177,363,177,363,177,177,363,177,363,363,363,177,363,363,363,363,363,177
,177,177,177,363,363,363,363,363,177,363,363,177,177,363,363,177,363,363
,363,363,363,177,363,363,177,363,177,177,177,177,177,177,177,177,177,363
,363,303,363,177,177,303,363,363,363,363,363,363,363,303,363,363,363,303
,303,303,303,303,363,363,363,303,363,363,303,303,303,363,363,363,363,363
,363,303,303,303,363,363,363,363,363,363,363,363,303,363,363,363,303,363
,363,363,363,363,363,363,303,303,303,303,363,363,363,363,363,363,363,303
,303,363,303,363,363,363,303,303,303,303,305,303,303,303,305,303,363,363
,363,363,363,363,305,363,363,363,305,305,305,305,305,363,363,363,305,363
,363,305,305,305,363,363,363,363,363,363,305,305,305,363,363,363,363,363
,363,363,363,305,363,363,363,305,363,363,363,363,363,363,363,305,305,305
,305,363,363,363,363,363,363,363,305,305,363,305,363,363,363,305,305,305
,305,308,305,305,305,308,305,363,363,363,363,363,363,308,363,363,363,308
,308,308,308,308,363,363,363,308,363,363,308,308,308,363,363,363,363,363
,363,308,308,308,363,363,363,363,363,363,363,363,308,363,363,363,308,363
,363,363,363,363,363,363,308,308,308,308,363,363,363,363,363,363,363,308
,308,363,308,363,363,363,308,308,308,308,336,308,308,308,336,308,363,363
,363,363,363,363,336,363,363,363,336,336,336,336,336,363,363,363,336,363
,363,336,336,336,363,363,363,286,336,363,336,336,336,363,363,363,363,363
,363,286,363,336,363,286,286,336,189,363,363,336,363,286,363,336,336,336
,336,286,363,363,363,363,363,189,336,336,363,189,363,363,363,336,336,336
,336,363,336,189,336,363,336,363,286,189,286,286,189,363,189,363,189,189
,363,189,363,363,363,189,363,363,286,363,363,189,189,189,189,363,363,286
,286,363,189,286,363,189,189,363,363,189,363,363,363,363,196,189,363,363
,189,363,189,189,189,189,189,189,189,189,189,363,363,196,363,189,189,196
,363,363,363,363,363,363,363,363,363,196,363,363,363,363,363,196,363,363
,196,363,196,363,196,196,363,196,363,363,363,196,363,363,363,363,363,196
,196,196,196,363,363,363,363,363,196,363,363,196,196,363,363,196,363,363
,363,363,363,196,363,363,196,363,196,196,196,196,196,196,196,196,196,363
,363,342,363,196,196,342,363,363,363,363,363,363,363,342,363,363,363,342
,342,342,342,342,363,363,363,342,363,363,342,342,342,363,363,363,363,342
,363,342,342,342,363,363,363,363,363,363,363,363,342,363,363,363,342,363
,363,363,342,363,363,363,342,342,342,342,363,363,363,363,363,363,363,342
,342,363,363,363,363,363,342,342,342,342,344,342,363,342,344,342,363,363
,363,363,363,363,344,363,363,363,344,344,344,344,344,363,363,363,344,363
,363,344,344,344,363,363,363,363,344,363,344,344,344,363,363,363,363,363
,363,363,363,344,363,363,363,344,363,363,363,344,363,363,363,344,344,344
,344,363,363,363,363,363,363,363,344,344,330,363,363,363,363,344,344,344
,344,363,344,363,344,363,344,363,330,330,363,363,363,330,363,363,363,363
,363,363,330,330,363,330,330,330,363,363,363,330,363,363,330,363,330,363
,330,330,363,363,363,363,363,330,363,363,363,363,363,363,363,363,330,363
,363,363,363,363,330,363,363,363,363,330,363,330,363,363,363,363,363,330
,363,363,330,363,330,330,330,330,330,330,330,260,363,363,363,260,363,330
,330,363,363,363,330,260,363,363,363,260,260,260,260,260,363,363,363,260
,260,260,260,260,260,363,363,363,363,363,363,260,260,260,363,363,363,363
,363,363,363,363,260,363,363,363,260,363,363,363,363,363,363,363,260,260
,260,260,363,363,363,312,363,363,363,260,260,363,363,363,363,363,260,260
,260,260,363,312,312,260,363,260,312,363,363,363,363,363,363,312,312,363
,312,312,312,363,363,363,312,363,363,312,363,312,363,312,312,363,363,363
,363,363,312,363,288,363,363,363,363,363,363,312,363,363,363,363,288,312
,363,363,288,288,363,363,312,359,363,363,288,363,312,363,363,312,288,312
,312,312,312,312,312,312,359,363,363,363,359,363,312,312,312,363,363,312
,363,363,359,363,363,288,363,363,359,363,363,359,363,359,363,359,359,363
,359,363,363,363,359,288,363,363,363,363,359,359,363,359,288,288,363,363
,288,359,363,363,359,359,363,363,359,363,363,363,363,363,359,363,363,359
,363,359,359,359,359,359,359,359,359,359,363,363,18,363,359,359,18,363,363
,363,363,363,363,363,18,363,363,363,18,363,18,363,363,363,363,363,363,363
,363,363,18,363,363,363,18,18,18,363,363,363,363,363,363,18,18,18,18,363
,363,18,363,363,18,18,18,363,363,363,363,363,363,363,363,18,363,363,363
,18,363,363,363,363,363,363,363,18,18,18,18,363,363,264,363,363,363,363
,18,18,363,363,363,363,363,18,18,18,18,264,264,363,18,363,264,363,363,363
,363,363,363,264,264,363,264,264,264,363,363,363,264,363,363,264,264,264
,363,264,264,363,363,363,363,363,264,363,363,363,363,363,363,363,363,264
,363,363,363,363,363,264,363,363,363,363,363,363,264,363,363,363,363,363
,264,363,363,264,363,264,264,264,264,264,264,264,40,363,363,363,40,363,264
,363,363,363,363,264,40,363,363,363,40,363,40,363,363,363,363,363,363,363
,363,363,40,363,363,363,40,40,40,363,363,363,363,363,363,40,40,40,40,363
,363,40,363,363,40,40,40,363,363,363,363,363,363,363,363,40,363,363,363
,40,363,363,363,363,363,363,363,40,40,40,40,363,363,363,363,363,363,363
,40,40,363,363,363,363,363,40,40,40,40,215,363,215,40,363,215,363,215,215
,363,363,363,363,363,363,363,363,215,363,363,363,215,363,363,363,363,135
,363,363,363,135,215,135,135,135,135,135,215,363,135,135,363,215,363,215
,215,135,135,135,135,135,215,135,363,363,135,135,363,363,363,215,363,215
,363,363,363,215,363,363,135,363,363,363,215,363,363,363,363,135,215,363
,363,215,363,215,215,215,215,215,215,215,214,363,214,363,363,214,215,214
,214,363,363,363,363,135,363,363,363,214,363,363,363,214,135,363,363,363
,136,363,363,135,136,214,136,136,136,136,136,214,363,136,136,363,214,363
,214,214,136,136,136,136,136,214,136,363,363,136,136,363,363,363,214,363
,214,363,363,363,214,363,363,136,363,363,363,214,363,363,363,363,136,214
,363,363,214,363,214,214,214,214,214,214,214,236,363,363,363,363,363,214
,363,236,363,236,363,363,136,236,236,236,363,363,363,363,236,136,236,236
,236,363,236,363,136,363,363,236,236,236,363,363,363,363,363,363,363,363
,236,363,363,363,236,363,363,363,363,363,363,363,236,236,236,236,363,363
,363,363,363,363,363,236,236,363,363,363,363,363,236,236,236,236,241,241
,363,236,363,241,363,241,241,241,241,241,241,363,241,241,363,363,363,363
,241,241,241,241,241,241,363,241,241,363,241,241,363,363,363,363,363,363
,363,363,242,242,363,363,241,242,363,242,242,242,242,242,242,241,242,242
,363,363,363,363,363,242,242,242,242,242,363,242,242,363,242,242,363,363
,363,363,363,363,363,241,363,363,229,363,242,363,363,363,241,363,229,363
,363,242,363,241,229,229,229,242,363,363,363,229,363,229,229,229,363,229
,363,363,363,363,229,229,229,363,124,242,363,363,363,363,363,229,124,363
,242,229,363,363,124,124,124,242,363,229,229,229,229,124,124,124,124,363
,363,363,229,229,124,124,124,363,257,229,229,229,229,363,363,124,229,363
,363,124,124,363,257,257,257,363,363,124,124,124,124,257,257,257,363,363
,363,363,124,124,257,257,257,363,257,124,124,124,124,363,363,257,124,258
,257,257,363,363,363,363,363,363,363,257,257,257,257,258,258,258,257,363
,363,363,257,257,258,258,258,363,363,257,257,257,257,258,258,258,257,258
,363,363,363,363,363,363,258,363,224,258,258,363,363,363,363,363,363,363
,258,258,258,258,224,224,224,258,363,363,363,258,258,224,224,224,363,363
,258,258,258,258,224,224,224,258,224,363,363,363,363,363,363,224,363,225
,224,224,363,363,363,363,363,363,363,224,224,224,224,225,225,225,224,363
,363,363,224,224,225,225,225,363,363,224,224,224,224,225,225,225,224,225
,363,363,363,363,363,363,225,363,154,225,225,363,363,363,363,363,154,363
,225,225,225,225,154,154,154,225,363,363,363,225,225,154,154,154,154,363
,225,225,225,225,154,154,154,225,363,363,363,363,363,363,363,154,363,363
,363,154,154,363,363,363,363,363,363,154,154,154,154,363,363,363,363,363
,363,363,154,154,363,363,363,363,363,154,154,154,154,238,238,363,154,363
,238,363,238,238,238,238,238,238,363,238,238,363,363,363,363,238,238,238
,238,238,238,363,238,238,363,238,238,363,363,363,363,363,363,363,363,239
,239,363,363,238,239,363,239,239,239,239,239,239,238,239,239,363,363,363
,363,239,239,239,239,239,239,363,239,239,363,239,239,363,363,363,363,363
,363,363,238,363,363,363,363,239,363,363,363,238,363,363,363,363,239,363
,238,363,363,363,363,363,363,240,240,363,363,363,240,363,240,240,240,240
,240,240,363,240,240,363,239,363,363,240,240,240,240,240,240,239,240,240
,363,240,240,363,239,227,363,363,363,363,314,314,363,227,363,240,363,314
,363,227,227,227,314,363,240,363,314,314,227,227,227,363,227,363,314,363
,363,227,227,227,363,363,314,363,363,363,363,363,227,314,240,363,227,30
,363,363,363,363,363,240,227,227,227,227,363,363,240,363,363,363,30,227
,227,363,30,314,363,363,227,227,227,227,363,314,30,227,363,363,363,363,30
,363,314,314,363,30,314,30,30,363,363,363,363,363,30,363,363,363,363,363
,30,363,363,30,363,363,363,363,363,30,363,363,30,363,363,363,30,363,31,363
,363,363,30,363,363,30,363,30,30,30,30,30,30,30,30,31,363,363,363,31,30
,363,363,363,363,363,363,363,363,31,363,363,363,363,363,31,363,363,363,363
,31,363,31,31,363,363,363,363,363,31,363,363,363,363,363,31,363,363,31,363
,363,363,363,363,31,363,363,31,363,363,363,31,363,32,363,363,363,31,363
,363,31,363,31,31,31,31,31,31,31,31,32,363,363,363,32,31,363,363,363,363
,363,363,363,363,32,363,363,363,363,363,32,363,363,363,363,32,363,32,32
,363,363,363,363,363,32,363,363,363,363,363,32,363,363,32,363,363,363,363
,363,32,363,363,32,363,363,363,32,363,10,363,363,363,32,363,363,32,363,32
,32,32,32,32,32,32,32,10,363,363,363,10,32,363,363,363,363,363,363,363,363
,10,363,363,363,363,363,10,363,363,363,363,10,363,10,10,363,363,363,363
,363,10,363,363,363,363,363,10,363,363,10,363,363,363,363,363,10,363,363
,10,363,363,363,10,363,57,363,363,363,10,363,363,10,363,10,10,10,10,10,10
,10,10,57,363,363,363,57,10,363,363,363,363,363,363,363,363,57,363,363,363
,363,363,57,363,363,363,363,57,363,57,57,363,363,363,363,363,57,363,363
,363,363,363,57,363,363,57,363,363,363,363,363,57,363,363,57,363,363,363
,57,363,58,363,363,363,57,363,363,57,363,57,57,57,57,57,57,57,57,58,363
,363,363,58,57,363,363,363,363,363,363,363,363,58,363,363,363,363,363,58
,363,363,363,363,58,363,58,58,363,363,363,363,363,58,363,363,363,363,363
,58,363,363,58,363,363,363,363,363,58,363,363,58,363,363,363,58,363,72,363
,363,363,58,363,363,58,363,58,58,58,58,58,58,58,58,72,363,363,363,72,58
,363,363,363,363,363,363,363,363,72,363,363,363,363,363,72,363,363,363,363
,72,363,72,72,363,363,363,363,363,72,363,363,363,363,363,72,363,363,72,363
,363,363,363,363,72,363,363,72,363,363,363,72,363,73,363,363,363,72,363
,363,72,363,72,72,72,72,72,72,72,72,73,363,363,363,73,72,363,363,363,363
,363,363,363,363,73,363,363,363,363,363,73,363,363,363,363,73,363,73,73
,363,363,363,363,363,73,363,363,363,363,363,73,363,363,73,363,363,363,363
,363,73,363,363,73,363,363,363,73,363,77,363,363,363,73,363,363,73,363,73
,73,73,73,73,73,73,73,77,363,363,363,77,73,363,363,363,363,363,363,363,363
,77,363,363,363,363,363,77,363,363,363,363,77,363,77,77,363,363,363,363
,363,77,363,363,363,363,363,77,363,363,77,363,363,363,363,363,77,363,363
,77,363,363,363,77,363,198,363,198,363,77,198,363,77,363,77,77,77,77,77
,77,77,77,198,363,363,363,198,77,363,363,363,363,363,363,363,363,198,363
,363,363,363,363,198,363,363,363,363,198,363,198,198,363,363,363,363,363
,198,363,363,363,363,363,363,363,363,198,363,198,363,363,363,198,363,363
,363,363,363,363,198,363,363,363,334,363,198,363,363,198,363,198,198,198
,198,198,198,198,334,334,334,363,363,363,198,363,363,334,334,334,363,363
,363,363,363,334,334,334,334,363,363,363,363,363,363,363,363,334,363,363
,334,334,78,363,363,363,363,363,363,334,334,334,334,363,363,363,363,363
,363,78,334,334,363,78,287,363,363,334,334,334,334,363,363,78,334,363,287
,363,363,78,287,287,363,363,78,363,78,78,287,363,363,363,363,78,287,363
,363,363,363,78,363,363,78,363,363,363,363,363,78,363,363,78,363,363,363
,78,363,11,363,287,363,78,287,363,78,363,78,78,78,78,78,78,78,78,11,363
,363,287,11,78,363,363,363,363,363,363,287,287,11,363,287,363,363,363,11
,363,363,363,363,11,363,11,11,363,363,363,363,363,11,363,363,363,363,363
,11,363,363,11,363,363,363,363,363,11,363,363,11,363,363,363,11,363,29,363
,363,363,11,363,363,11,363,11,11,11,11,11,11,11,11,29,363,363,363,29,11
,363,363,363,363,363,363,363,363,29,363,363,363,363,363,29,363,363,363,363
,29,363,29,29,363,363,363,363,363,29,363,363,363,363,363,29,363,363,29,363
,363,363,363,363,29,363,363,29,363,363,363,29,363,90,363,363,363,29,363
,363,29,363,29,29,29,29,29,29,29,29,90,363,363,363,90,29,363,363,363,363
,363,363,363,363,90,363,363,363,363,363,90,363,363,363,363,90,363,90,90
,363,363,363,363,363,90,363,363,363,363,363,90,363,363,90,363,363,363,363
,363,90,363,363,90,363,363,363,90,363,91,363,363,363,90,363,363,90,363,90
,90,90,90,90,90,90,90,91,363,363,363,91,90,363,363,363,363,363,363,363,363
,91,363,363,363,363,363,91,363,363,363,363,91,363,91,91,363,363,363,363
,363,91,363,363,363,363,363,91,363,363,91,363,363,363,363,363,91,363,363
,91,363,363,363,91,363,41,363,363,363,91,363,363,91,363,91,91,91,91,91,91
,91,91,41,363,363,363,41,91,363,363,363,363,363,363,363,363,41,363,363,363
,363,363,41,363,363,363,363,41,363,41,41,363,363,363,363,363,41,363,363
,363,363,363,41,363,7,41,363,363,363,363,363,41,363,363,41,363,363,363,41
,363,363,363,363,363,41,7,363,41,363,41,41,41,41,41,41,41,41,363,363,7,7
,7,41,363,363,363,363,363,7,7,7,363,363,363,363,363,363,7,7,7,363,363,363
,363,363,363,363,8,7,363,363,363,7,363,363,363,363,363,363,363,7,7,7,7,363
,363,363,363,8,363,363,7,7,363,363,363,363,363,7,7,7,7,8,8,8,7,363,363,363
,363,363,8,8,8,363,363,363,347,347,363,8,8,8,363,347,363,363,363,363,347
,363,8,363,347,347,8,295,363,363,363,363,347,363,8,8,8,8,363,363,347,363
,363,363,295,8,8,347,295,363,363,363,8,8,8,8,295,363,295,8,363,363,363,347
,295,363,363,363,363,295,363,295,295,347,363,363,363,363,295,363,363,363
,363,363,363,363,363,295,363,363,347,295,363,295,347,363,363,363,341,363
,295,363,363,363,341,363,295,363,363,295,363,295,295,295,295,295,295,295
,341,341,341,363,363,363,295,363,363,341,341,341,363,363,363,348,348,363
,341,341,341,363,348,363,363,363,363,348,363,341,363,348,348,341,296,363
,363,363,363,348,363,341,341,341,341,363,363,348,363,363,363,296,341,341
,348,296,363,363,363,341,341,341,341,296,363,296,341,363,363,363,348,296
,363,363,363,363,296,363,296,296,348,363,363,363,363,296,363,363,363,363
,9,363,363,363,296,363,363,348,296,363,296,348,363,363,363,363,363,296,363
,363,363,9,363,296,363,363,296,363,296,296,296,296,296,296,296,9,9,9,363
,363,363,296,363,363,9,9,9,363,363,363,363,363,363,9,9,9,363,352,363,363
,363,363,363,363,9,352,363,363,9,363,363,352,352,352,363,363,9,9,9,9,352
,352,352,363,363,363,363,9,9,352,352,352,363,363,9,9,9,9,363,363,352,9,131
,363,352,363,363,363,363,363,131,363,352,352,352,352,131,131,131,363,363
,363,363,352,352,131,131,131,363,363,352,352,352,352,131,131,131,352,363
,363,363,363,363,363,363,131,363,363,363,131,360,363,360,363,363,363,363
,131,131,131,131,363,363,363,363,363,363,360,131,131,363,360,363,363,363
,131,131,131,131,363,363,360,131,363,363,363,363,360,363,363,363,363,360
,363,360,360,363,363,363,363,363,360,363,363,363,363,363,363,363,363,360
,360,363,363,363,363,360,363,363,363,363,363,363,360,172,363,363,363,363
,360,363,363,360,363,360,360,360,360,360,360,360,172,363,363,363,172,363
,360,363,363,363,363,363,363,363,172,174,363,363,363,363,172,363,363,363
,363,172,363,172,172,363,363,363,174,363,172,363,174,363,363,363,363,363
,363,172,174,363,174,363,363,172,363,363,174,363,363,363,172,174,363,174
,174,363,172,363,363,172,174,172,172,172,172,172,172,172,363,174,363,363
,363,363,172,174,363,363,172,363,363,363,174,92,363,363,363,363,174,363
,363,174,363,174,174,174,174,174,174,174,92,363,363,363,92,363,174,363,363
,363,363,363,92,363,92,363,363,363,363,363,92,363,363,363,363,92,363,92
,92,363,363,363,363,363,92,363,363,363,363,363,363,363,363,92,363,363,363
,363,363,92,363,363,363,363,363,363,92,363,363,363,363,363,92,363,363,92
,363,92,92,92,92,92,92,92,363,137,363,363,363,137,92,137,137,137,137,137
,363,363,137,137,363,363,179,363,363,137,137,137,137,137,137,137,363,363
,137,137,179,179,179,363,363,363,363,363,363,179,179,179,137,363,363,363
,363,363,179,179,179,137,363,363,363,363,363,363,363,179,363,363,363,179
,363,363,363,363,363,363,363,179,179,179,179,363,363,137,363,363,363,363
,179,179,141,363,137,363,363,179,179,179,179,137,363,363,179,363,141,141
,141,363,363,363,363,363,363,141,141,141,363,363,363,315,315,363,141,141
,141,363,315,363,363,363,363,315,363,141,363,315,315,141,252,363,252,363
,363,315,363,141,141,141,141,363,363,315,363,363,363,252,141,141,315,252
,363,363,363,141,141,141,141,363,363,252,141,363,363,363,363,252,363,363
,363,363,252,363,252,252,315,363,363,363,363,252,363,363,315,363,363,363
,363,363,252,363,363,315,315,363,252,315,363,363,363,363,363,252,363,363
,363,142,363,252,363,363,252,363,252,252,252,252,252,252,252,142,142,142
,363,363,363,252,363,363,142,142,142,363,363,363,363,363,363,142,142,142
,363,255,363,363,363,363,363,363,142,363,363,363,142,363,363,255,255,255
,363,363,142,142,142,142,255,255,255,363,363,363,363,142,142,255,255,255
,363,363,142,142,142,142,363,363,255,142,363,363,255,93,363,363,363,363
,363,363,255,255,255,255,363,363,363,363,363,363,93,255,255,363,93,363,363
,363,255,255,255,255,93,363,93,255,363,363,363,363,93,363,363,363,363,93
,363,93,93,363,363,363,363,363,93,363,363,363,363,363,363,363,363,93,363
,363,363,363,363,93,363,363,363,363,363,363,93,363,363,363,184,363,93,363
,363,93,363,93,93,93,93,93,93,93,184,184,184,363,363,363,93,363,363,184
,184,184,363,363,363,363,363,363,184,184,184,363,185,363,363,363,363,363
,363,184,363,363,363,184,363,363,185,185,185,363,363,184,184,184,184,185
,185,185,363,363,363,363,184,184,185,185,185,363,259,184,184,184,184,363
,363,185,184,363,363,185,363,363,259,259,259,363,363,185,185,185,185,259
,259,259,363,363,363,363,185,185,259,259,259,363,145,185,185,185,185,363
,363,259,185,363,363,259,363,363,145,145,145,363,363,259,259,259,259,145
,145,145,363,363,363,363,259,259,145,145,145,363,363,259,259,259,259,363
,363,145,259,363,363,145,262,363,363,363,363,363,363,145,145,145,145,363
,363,363,363,363,363,262,145,145,363,262,363,363,363,145,145,145,145,262
,363,262,145,363,363,363,363,262,363,363,363,363,262,363,262,262,363,363
,363,363,363,262,363,363,363,363,363,363,363,363,262,363,363,363,363,363
,262,363,363,363,363,363,363,262,263,363,363,363,363,262,363,363,262,363
,262,262,262,262,262,262,262,263,363,363,363,263,363,262,363,363,363,363
,363,263,363,263,363,363,363,363,363,263,363,363,363,363,263,363,263,263
,363,363,363,363,363,263,363,363,363,363,363,363,363,363,263,363,363,363
,363,363,263,363,363,363,363,363,363,263,363,363,363,146,363,263,363,363
,263,363,263,263,263,263,263,263,263,146,146,146,363,363,363,263,363,363
,146,146,146,363,363,363,313,313,363,146,146,146,363,313,363,363,363,363
,313,363,146,363,313,313,146,274,363,274,363,363,313,363,146,146,146,146
,363,363,313,363,363,363,274,146,146,313,274,363,363,363,146,146,146,146
,363,363,274,146,363,363,363,363,274,363,363,363,363,274,363,274,274,313
,363,363,363,363,274,363,363,313,363,363,363,363,363,274,363,363,313,313
,363,274,313,363,363,363,363,363,274,363,363,363,122,363,274,363,363,274
,363,274,274,274,274,274,274,274,122,122,122,363,363,363,274,363,363,122
,122,122,363,363,363,349,349,363,122,122,122,363,349,363,363,363,363,349
,363,122,363,349,349,122,283,363,283,363,363,349,363,122,122,122,122,363
,363,349,363,363,363,283,122,122,349,283,363,363,363,122,122,122,122,363
,363,283,122,363,363,363,349,283,363,363,363,363,283,363,283,283,349,363
,363,363,363,283,363,363,363,363,363,363,363,363,283,363,363,349,363,363
,283,349,363,363,363,363,363,283,363,363,363,289,363,283,363,363,283,363
,283,283,283,283,283,283,283,289,289,289,363,363,363,283,363,363,289,289
,289,363,363,363,363,363,363,289,289,289,363,290,363,363,363,363,363,363
,289,363,363,363,289,363,363,290,290,290,363,363,289,289,289,289,290,290
,290,363,363,363,363,289,289,290,290,290,363,363,289,289,289,289,363,363
,290,289,363,363,290,197,363,363,363,363,197,363,290,290,290,290,363,363
,363,363,363,363,197,290,290,363,197,363,363,363,290,290,290,290,363,363
,197,290,363,363,363,363,197,363,363,363,363,197,363,197,197,363,363,363
,363,363,197,363,363,363,363,363,363,363,363,197,363,363,363,363,363,197
,363,363,363,363,363,363,197,363,363,363,292,363,197,363,363,197,363,197
,197,197,197,197,197,197,292,292,292,363,363,363,197,363,363,292,292,292
,363,363,363,363,363,363,292,292,292,363,293,363,363,363,363,363,363,292
,363,363,363,292,363,363,293,293,293,363,363,292,292,292,292,293,293,293
,363,363,363,363,292,292,293,293,293,363,123,292,292,292,292,363,363,293
,292,363,363,293,363,363,123,123,123,363,363,293,293,293,293,123,123,123
,363,363,363,363,293,293,123,123,123,363,363,293,293,293,293,363,363,123
,293,363,363,123,55,363,363,363,363,363,363,123,123,123,123,363,363,363
,363,363,363,55,123,123,363,55,363,363,363,123,123,123,123,55,363,55,123
,363,363,363,363,55,363,363,363,363,55,363,55,55,363,363,363,363,363,55
,363,363,363,363,363,363,363,363,55,363,363,363,363,363,55,363,363,363,363
,363,363,55,363,363,363,206,363,55,363,363,55,363,55,55,55,55,55,55,55,206
,206,206,363,363,363,55,363,363,206,206,206,363,363,363,363,363,363,206
,206,206,363,207,363,363,363,363,363,363,206,363,363,363,206,363,363,207
,207,207,363,363,206,206,206,206,207,207,207,363,363,363,363,206,206,207
,207,207,363,299,206,206,206,206,363,363,207,206,363,363,207,363,363,299
,299,299,363,363,207,207,207,207,299,299,299,363,363,363,363,207,207,299
,299,299,363,300,207,207,207,207,363,363,299,207,363,363,299,363,363,300
,300,300,363,363,299,299,299,299,300,300,300,363,363,363,363,299,299,300
,300,300,363,152,299,299,299,299,363,363,300,299,363,363,300,363,363,152
,152,152,363,363,300,300,300,300,152,152,152,363,363,363,363,300,300,152
,152,152,363,153,300,300,300,300,363,363,152,300,363,363,152,363,363,153
,153,153,363,363,152,152,152,152,153,153,153,363,363,363,363,152,152,153
,153,153,363,304,152,152,152,152,363,363,153,152,363,363,153,363,363,304
,304,304,363,363,153,153,153,153,304,304,304,363,363,363,363,153,153,304
,304,304,363,129,153,153,153,153,363,363,304,153,363,363,304,363,363,129
,129,129,363,363,304,304,304,304,129,129,129,363,363,363,363,304,304,129
,129,129,363,306,304,304,304,304,363,363,129,304,363,363,129,363,363,306
,306,306,363,363,129,129,129,129,306,306,306,363,363,363,363,129,129,306
,306,306,363,307,129,129,129,129,363,363,306,129,363,363,306,363,363,307
,307,307,363,363,306,306,306,306,307,307,307,363,363,363,363,306,306,307
,307,307,363,363,306,306,306,306,363,363,307,306,363,363,307,220,363,220
,363,363,363,363,307,307,307,307,363,363,363,363,363,363,220,307,307,363
,220,363,363,363,307,307,307,307,363,363,220,307,363,363,363,363,220,363
,363,363,363,220,363,220,220,363,363,363,363,363,220,363,363,363,363,363
,363,363,363,220,363,363,363,363,363,220,363,363,363,363,363,363,220,310
,363,363,363,363,220,363,363,220,363,220,220,220,220,220,220,220,310,363
,363,363,310,363,220,363,363,363,363,363,310,363,310,311,363,363,363,363
,310,363,363,363,363,310,363,310,310,363,363,363,311,363,310,363,311,363
,363,363,363,363,363,310,311,363,311,363,363,310,363,363,311,363,363,363
,310,311,363,311,311,363,310,363,363,310,311,310,310,310,310,310,310,310
,363,311,363,363,363,363,310,311,363,363,363,363,363,363,311,221,363,221
,363,363,311,363,363,311,363,311,311,311,311,311,311,311,221,363,363,363
,221,363,311,363,363,363,363,363,363,363,221,319,363,319,363,363,221,363
,363,363,363,221,363,221,221,363,363,363,319,363,221,363,319,363,363,363
,363,363,363,221,363,363,319,363,363,221,363,363,319,363,363,363,221,319
,363,319,319,363,221,363,363,221,319,221,221,221,221,221,221,221,363,319
,363,363,363,363,221,319,363,363,363,363,363,363,319,325,363,325,363,363
,319,363,363,319,363,319,319,319,319,319,319,319,325,363,363,363,325,363
,319,363,363,363,363,363,363,363,325,328,363,363,363,363,325,363,363,363
,363,325,363,325,325,363,363,363,328,363,325,363,328,363,363,363,363,363
,363,325,328,363,328,363,363,325,363,363,328,363,363,363,325,328,363,328
,328,363,325,363,363,325,328,325,325,325,325,325,325,325,363,328,363,363
,363,363,325,328,363,363,363,363,363,363,328,329,363,363,363,363,328,363
,363,328,363,328,328,328,328,328,328,328,329,363,363,363,329,363,328,363
,363,363,363,363,329,363,329,157,363,363,363,363,329,363,363,363,363,329
,363,329,329,363,363,363,157,363,329,363,157,363,363,363,363,363,363,329
,157,363,157,363,363,329,363,363,157,363,363,363,329,157,363,157,157,363
,329,363,363,329,157,329,329,329,329,329,329,329,363,157,363,363,363,363
,329,157,363,363,363,363,363,363,157,363,363,363,130,363,157,363,363,157
,363,157,157,157,157,157,157,157,130,130,130,363,363,363,157,363,363,130
,130,130,363,363,363,363,363,363,130,130,130,363,335,363,363,363,363,363
,363,130,363,363,363,130,363,363,335,335,335,363,363,130,130,130,130,335
,335,335,363,363,363,363,130,130,335,335,335,363,226,130,130,130,130,363
,363,335,130,363,363,335,363,363,226,226,226,363,363,335,335,335,335,226
,226,226,363,363,363,363,335,335,226,226,226,363,363,335,335,335,335,363
,363,226,335,363,363,226,164,363,363,363,363,363,363,226,226,226,226,363
,363,363,363,363,363,164,226,226,363,164,363,363,363,226,226,226,226,363
,363,164,226,363,363,363,363,164,363,363,363,363,164,363,164,164,363,363
,363,363,363,164,363,363,363,363,363,363,363,363,164,363,363,363,363,363
,164,363,363,363,363,363,363,164,166,363,363,363,363,164,363,363,164,363
,164,164,164,164,164,164,164,166,363,363,363,166,363,164,363,363,363,164
,363,166,363,166,114,363,363,363,363,166,363,363,363,363,166,363,166,166
,363,363,363,114,363,166,363,114,363,363,363,363,363,363,166,363,363,114
,363,363,166,363,363,114,363,363,363,166,114,363,114,114,363,166,363,363
,166,114,166,166,166,166,166,166,166,363,114,114,363,363,363,166,114,363
,363,363,363,363,363,114,168,363,363,363,363,114,363,363,114,363,114,114
,114,114,114,114,114,168,363,363,363,168,363,114,363,363,363,363,363,363
,363,168,363,363,363,363,363,168,363,363,363,363,168,363,168,168,363,363
,363,363,363,168,363,363,363,363,363,363,363,363,168,363,363,363,363,363
,168,363,363,363,363,363,363,168,363,363,363,363,363,168,343,363,168,363
,168,168,168,168,168,168,168,363,363,363,343,343,343,168,363,363,363,168
,363,343,343,343,363,363,363,363,363,363,343,343,343,363,363,363,363,363
,363,363,363,343,363,363,363,343,170,363,363,363,363,363,363,343,343,343
,343,363,363,363,363,363,363,170,343,343,363,170,363,363,363,343,343,343
,343,170,363,170,343,363,363,363,363,170,363,363,363,363,170,363,170,170
,363,363,363,363,363,170,363,363,363,363,363,363,363,363,170,363,363,363
,363,363,170,363,363,363,363,363,363,170,345,363,363,363,363,170,363,363
,170,363,170,170,170,170,170,170,170,345,363,363,363,345,363,170,363,363
,363,363,363,363,363,345,363,363,363,363,363,345,363,363,363,363,345,363
,345,345,363,363,363,363,363,345,363,363,363,363,363,363,363,363,345,345
,363,363,363,363,345,363,363,363,363,363,363,345,363,363,363,350,363,345
,363,363,345,363,345,345,345,345,345,345,345,350,350,350,363,363,363,345
,363,363,350,350,350,363,363,363,363,363,363,350,350,350,363,351,363,363
,363,363,363,363,350,363,363,363,350,363,363,351,351,351,363,363,350,350
,350,350,351,351,351,363,363,363,363,350,350,351,351,351,363,234,350,350
,350,350,363,363,351,350,363,363,351,363,363,234,234,234,363,363,351,351
,351,351,234,234,234,363,363,363,363,351,351,234,234,234,363,363,351,351
,351,351,363,363,234,351,363,363,234,354,363,354,363,363,363,363,234,234
,234,234,363,363,363,363,363,363,354,234,234,363,354,363,363,363,234,234
,234,234,363,363,354,234,363,363,363,363,354,363,363,363,363,354,363,354
,354,363,363,363,363,363,354,363,363,363,363,363,363,363,363,354,363,363
,363,363,363,354,363,363,363,363,363,363,354,363,363,363,235,363,354,363
,363,354,363,354,354,354,354,354,354,354,235,235,235,363,363,363,354,363
,363,235,235,235,363,363,363,363,363,363,235,235,235,363,363,363,363,363
,363,363,363,235,363,363,363,235,115,363,363,363,363,363,363,235,235,235
,235,363,363,363,363,363,363,115,235,235,363,115,363,363,363,235,235,235
,235,363,363,115,235,363,363,363,363,115,363,363,363,363,115,363,115,115
,363,363,363,363,363,115,363,363,363,363,363,363,363,363,115,115,363,363
,363,363,115,363,363,363,363,363,363,115,193,363,363,363,363,115,363,363
,115,363,115,115,115,115,115,115,115,193,363,363,363,193,363,115,363,363
,363,363,363,363,363,193,194,363,363,363,363,193,363,363,363,363,193,363
,193,193,363,363,363,194,363,193,363,194,363,363,363,363,363,363,193,363
,363,194,363,363,193,363,363,194,363,363,363,193,194,363,194,194,363,193
,363,363,193,194,193,193,193,193,193,193,193,363,194,363,363,363,363,193
,194,363,363,363,363,363,363,194,195,363,363,363,363,194,363,363,194,363
,194,194,194,194,194,194,194,195,363,363,363,195,363,194,363,363,363,363
,363,363,363,195,118,363,363,363,363,195,363,363,363,363,195,363,195,195
,363,363,363,118,363,195,363,118,363,363,363,363,363,363,195,363,363,118
,363,363,195,363,363,118,363,363,363,195,118,363,118,118,363,195,363,363
,195,118,195,195,195,195,195,195,195,363,118,363,363,363,363,195,118,363
,363,363,363,363,363,118,96,363,363,363,363,118,363,363,118,363,118,118
,118,118,118,118,118,96,363,363,363,96,363,118,363,363,363,363,363,363,363
,96,89,363,363,363,363,96,363,363,363,363,96,363,96,96,363,363,363,89,363
,96,363,89,363,363,363,363,363,363,96,363,363,89,363,363,96,363,363,89,363
,363,363,96,89,363,89,89,363,96,363,363,96,89,96,96,96,96,96,96,96,363,89
,363,363,363,363,96,89,363,363,363,363,363,363,89,199,363,363,363,363,89
,363,363,89,363,89,89,89,89,89,89,89,199,363,363,363,199,363,89,363,363
,363,363,363,363,363,199,200,363,363,363,363,199,363,363,363,363,199,363
,199,199,363,363,363,200,363,199,363,200,363,363,363,363,363,363,199,363
,363,200,363,363,199,363,363,200,363,363,363,199,200,363,200,200,363,199
,363,363,199,200,199,199,199,199,199,199,199,363,200,363,363,363,363,199
,200,363,363,363,363,363,363,200,245,363,363,363,363,200,363,363,200,363
,200,200,200,200,200,200,200,245,363,363,363,245,363,200,363,363,363,363
,363,363,363,245,246,363,363,363,363,245,363,363,363,363,245,363,245,245
,363,363,363,246,363,245,363,246,363,363,363,363,363,363,245,363,363,246
,363,363,245,363,363,246,363,363,363,245,246,363,246,246,363,245,363,363
,245,246,245,245,245,245,245,245,245,363,246,363,363,363,363,245,246,363
,363,363,363,363,363,246,247,363,363,363,363,246,363,363,246,363,246,246
,246,246,246,246,246,247,363,363,363,247,363,246,363,363,363,363,363,363
,363,247,56,363,363,363,363,247,363,363,363,363,247,363,247,247,363,363
,363,56,363,247,363,56,363,363,363,363,363,363,247,363,363,56,363,363,247
,363,363,56,363,363,363,247,56,363,56,56,363,247,363,363,247,56,247,247
,247,247,247,247,247,363,56,363,363,363,363,247,56,363,363,363,363,363,363
,56,202,363,363,363,363,56,363,363,56,363,56,56,56,56,56,56,56,202,363,363
,363,202,363,56,363,363,363,363,363,363,363,202,203,363,363,363,363,202
,363,363,363,363,202,363,202,202,363,363,363,203,363,202,363,203,363,363
,363,363,363,363,202,363,363,203,363,363,202,363,363,203,363,363,363,202
,203,363,203,203,363,202,363,363,202,203,202,202,202,202,202,202,202,363
,203,363,363,363,363,202,203,363,363,363,363,363,363,203,103,363,363,363
,363,203,363,363,203,363,203,203,203,203,203,203,203,103,363,363,363,103
,363,203,363,363,363,363,363,363,363,103,104,363,363,363,363,103,363,363
,363,363,103,363,103,103,363,363,363,104,363,103,363,104,363,363,363,363
,363,363,103,363,363,104,363,363,103,363,363,104,363,363,363,103,104,363
,104,104,363,103,363,363,103,104,103,103,103,103,103,103,103,363,104,363
,363,363,363,103,104,363,363,363,363,363,363,104,321,363,363,363,363,104
,363,363,104,363,104,104,104,104,104,104,104,321,363,363,363,321,363,104
,363,363,363,363,363,363,363,321,107,363,363,363,363,321,363,363,363,363
,321,363,321,321,363,363,363,107,363,321,363,107,363,363,363,363,363,363
,321,363,363,107,363,363,321,363,363,107,363,363,363,321,107,363,107,107
,363,321,363,363,321,107,321,321,321,321,321,321,321,363,107,363,363,363
,363,321,107,363,363,363,363,363,363,107,212,363,363,363,363,107,363,363
,107,363,107,107,107,107,107,107,107,212,363,363,363,212,363,107,363,363
,363,363,363,363,363,212,176,363,363,363,363,212,363,363,363,363,212,363
,212,212,363,363,363,176,363,212,363,176,363,363,363,363,363,363,212,363
,363,176,363,363,212,363,363,176,363,363,363,212,176,363,176,176,363,212
,363,363,212,176,212,212,212,212,212,212,212,363,176,363,363,363,363,212
,176,363,363,363,363,363,363,176,108,363,363,363,363,176,363,363,176,363
,176,176,176,176,176,176,176,108,363,363,363,108,363,176,363,363,363,363
,363,363,363,108,82,363,363,363,363,108,363,363,363,363,108,363,108,108
,363,363,363,82,363,108,363,82,363,363,363,363,363,363,108,363,363,82,363
,363,108,363,363,82,363,363,363,108,82,363,82,82,363,108,363,363,108,82
,108,108,108,108,108,108,108,363,82,363,363,363,363,108,82,363,363,363,363
,363,363,82,34,363,363,363,363,82,363,363,82,363,82,82,82,82,82,82,82,34
,363,363,363,34,363,82,363,363,363,363,363,363,363,34,265,363,363,363,363
,34,363,363,363,363,34,363,34,34,363,363,363,265,363,34,363,265,363,363
,363,363,363,363,34,363,363,265,363,363,34,363,363,265,363,363,363,34,265
,363,265,265,363,34,363,363,34,265,34,34,34,34,34,34,34,363,265,363,363
,363,363,34,265,363,363,363,363,363,363,265,266,363,363,363,363,265,363
,363,265,363,265,265,265,265,265,265,265,266,363,363,363,266,363,265,363
,363,363,363,363,363,363,266,36,363,363,363,363,266,363,363,363,363,266
,363,266,266,363,363,363,36,363,266,363,36,363,363,363,363,363,363,266,363
,363,36,363,363,266,363,363,36,363,363,363,266,36,363,36,36,363,266,363
,363,266,36,266,266,266,266,266,266,266,363,36,363,363,363,363,266,36,363
,363,363,363,363,363,36,275,363,363,363,363,36,363,363,36,363,36,36,36,36
,36,36,36,275,363,363,363,275,363,36,363,363,363,363,363,363,363,275,277
,363,363,363,363,275,363,363,363,363,275,363,275,275,363,363,363,277,363
,275,363,277,363,363,363,363,363,363,275,363,363,277,363,363,275,363,363
,277,363,363,363,275,277,363,277,277,363,275,363,363,275,277,275,275,275
,275,275,275,275,363,277,363,363,363,363,275,277,363,363,363,363,363,363
,277,278,363,363,363,363,277,363,363,277,363,277,277,277,277,277,277,277
,278,363,363,363,278,363,277,363,363,363,363,363,363,363,278,162,363,363
,363,363,278,363,363,363,363,278,363,278,278,363,363,363,162,363,278,363
,162,363,363,363,363,363,363,278,363,363,162,363,363,278,363,363,162,363
,363,363,278,162,363,162,162,363,278,363,363,278,162,278,278,278,278,278
,278,278,363,162,363,363,363,363,278,162,363,363,363,363,363,363,162,95
,363,363,363,363,162,363,363,162,363,162,162,162,162,162,162,162,95,363
,363,363,95,363,162,363,363,363,363,363,363,363,95,187,363,363,363,363,95
,363,363,363,363,95,363,95,95,363,363,363,187,363,95,363,187,363,363,363
,363,363,363,95,363,363,187,363,363,95,363,363,187,363,363,363,95,187,363
,187,187,363,95,363,363,95,187,95,95,95,95,95,95,95,363,187,363,363,363
,363,95,187,363,363,363,363,363,363,187,188,363,363,363,363,187,363,363
,187,363,187,187,187,187,187,187,187,188,363,363,363,188,363,187,363,363
,363,363,363,363,363,188,356,363,363,363,363,188,363,363,363,363,188,363
,188,188,363,363,363,356,363,188,363,356,363,363,363,363,363,363,188,363
,363,356,363,363,188,363,363,356,363,363,363,188,356,363,356,356,363,188
,363,363,188,356,188,188,188,188,188,188,188,363,356,363,363,363,363,188
,356,363,363,363,363,363,363,356,357,363,363,363,363,356,363,363,356,363
,356,356,356,356,356,356,356,357,363,363,363,357,363,356,363,363,363,363
,363,363,363,357,358,363,363,363,363,357,363,363,363,363,357,363,357,357
,363,363,363,358,363,357,363,358,363,363,363,363,363,363,357,363,363,358
,363,363,357,363,363,358,363,363,363,357,358,363,358,358,363,357,363,363
,357,358,357,357,357,357,357,357,357,363,358,363,363,363,363,357,358,363
,363,363,363,363,363,358,363,363,363,363,363,358,363,363,358,363,358,358
,358,358,358,358,358,363,140,363,363,363,140,358,140,140,140,140,140,191
,363,140,140,363,363,363,363,363,140,140,140,140,140,363,140,363,191,140
,140,363,191,363,363,363,363,363,363,363,363,363,191,140,363,363,363,363
,191,363,363,363,140,191,363,191,191,363,363,22,363,363,191,22,363,22,22
,22,22,22,363,191,22,22,363,363,363,191,140,22,22,22,22,22,191,22,363,140
,22,22,191,363,363,191,140,191,191,191,191,191,191,191,363,363,363,363,363
,363,191,363,363,22,363,363,363,363,363,363,363,363,363,363,363,363,363
,363,363,363,363,363,363,363,363,363,363,363,363,22,363,363,363,363,363
,363,363,363,22,363,363,363,363,363,363,22,363,363,363,363,363}
,
{253,0,1048,818,761,704,210,8673,8736,8986,7663,8313,481,3645,4017,69,2901
,2994,6317,3273,3552,272,14446,958,3738,48,0,785,675,8388,7438,7513,7588
,17,13630,116,13768,4110,4203,231,6487,8613,4296,4452,364,4545,1227,1320
,1413,1506,1599,344,1692,1785,1878,10616,13026,7738,7813,275,307,318,327
,339,354,71,160,380,325,396,382,451,7888,7963,329,338,150,8038,8238,418
,580,311,13556,326,337,267,1971,2064,239,12708,8463,8538,9315,9701,436,14054
,12676,38,3,2157,2250,220,167,13206,13238,19,301,13344,13524,304,2343,2436
,181,259,11792,12390,110,361,12602,2529,2622,74,10190,10548,6941,210,446
,458,478,10925,11546,9067,49,2715,2808,6607,6698,9404,165,270,14387,9472
,9597,737,308,9866,10065,642,146,3087,3180,17,10817,10853,7157,263,270,11489
,5043,379,186,322,13980,392,11686,319,11760,5121,11866,361,11994,5199,9209
,380,9241,4887,13450,5277,4,9404,451,3366,3459,273,9758,9794,1130,14086
,14160,5667,136,14401,312,12464,12496,12570,5745,10419,8113,12782,12814
,4965,13100,13132,32,151,10673,10709,173,328,5,365,13418,393,6675,6584,429
,159,414,404,11065,11245,467,158,7067,7112,11618,7370,370,6905,348,3831
,3924,177,12197,12322,6746,547,7252,7292,7354,6841,6881,44,9,12888,12920
,12994,0,674,851,241,9540,332,982,9633,819,6977,7022,9830,6068,169,9934
,10008,6398,13662,13736,128,103,415,80,170,400,387,10133,13842,579,13874
,13948,907,52,4774,407,10258,477,1203,5632,8244,6187,10315,10351,4807,10476
,10512,4372,8804,8929,1070,205,10745,10781,82,233,5356,10889,5437,10961
,10997,5518,26,11139,11171,6150,10098,7379,9505,33,314,245,11277,355,13312
,4413,4404,316,11351,375,32,11383,11457,5993,178,338,4296,8170,11582,5599
,341,346,4638,4731,8861,5824,11926,5905,12068,438,8769,8894,10223,12125
,12161,9022,417,12265,475,14192,14266,14298,6224,9135,482,487}
,
{
{{42,42}
,{1,1}
,{87,87}
,{61,61}
,{19,19}
,{57,57}
,{4,4}
,{1,1}
,{1,1}
,{1,1}
,{2,2}
,{71,71}
,{4,4}
,{2,2}
,{63,63}
,{4,4}
,{2,2}
,{63,63}
,{4,4}
,{2,2}
,{63,63}
,{4,4}
,{5,5}
,{57,57}
,{63,63}
,{63,63}
,{4,4}
,{19,19}
,{57,57}
,{2,2}
,{71,71}
,{2,2}
,{71,71}
,{24,24}
,{2,2}
,{24,24}
,{2,2}
,{2,2}
,{63,63}
,{8,8}
,{4,4}
,{71,71}
,{2,2}
,{63,63}
,{17,17}
,{2,2}
,{63,63}
,{2,2}
,{63,63}
,{2,2}
,{63,63}
,{32,32}
,{2,2}
,{63,63}
,{63,63}
,{2,2}
,{2,2}
,{2,2}
,{71,71}
,{4,4}
,{4,4}
,{4,4}
,{4,4}
,{4,4}
,{4,4}
,{4,4}
,{4,4}
,{4,4}
,{63,63}
,{4,4}
,{45,45}
,{4,4}
,{2,2}
,{71,71}
,{4,4}
,{4,4}
,{4,4}
,{2,2}
,{71,71}
,{19,19}
,{57,57}
,{4,4}
,{2,2}
,{4,4}
,{68,68}
,{68,68}
,{2,2}
,{63,63}
,{4,4}
,{2,2}
,{2,2}
,{71,71}
,{2,2}
,{2,2}
,{4,4}
,{2,2}
,{2,2}
,{4,4}
,{4,4}
,{2,2}
,{63,63}
,{4,4}
,{24,24}
,{2,2}
,{2,2}
,{4,4}
,{4,4}
,{2,2}
,{2,2}
,{17,17}
,{2,2}
,{63,63}
,{4,4}
,{73,73}
,{2,2}
,{63,63}
,{4,4}
,{4,4}
,{2,2}
,{2,2}
,{63,63}
,{51,51}
,{22,22}
,{45,45}
,{30,30}
,{30,30}
,{30,30}
,{22,22}
,{4,4}
,{22,22}
,{45,45}
,{30,30}
,{23,23}
,{2,2}
,{63,63}
,{5,5}
,{48,48}
,{30,30}
,{81,81}
,{4,4}
,{48,48}
,{22,22}
,{45,45}
,{5,5}
,{6,6}
,{22,22}
,{45,45}
,{5,5}
,{30,30}
,{2,2}
,{63,63}
,{51,51}
,{22,22}
,{45,45}
,{30,30}
,{103,103}
,{103,103}
,{2,2}
,{42,42}
,{4,4}
,{4,4}
,{63,63}
,{2,2}
,{4,4}
,{103,103}
,{103,103}
,{2,2}
,{42,42}
,{103,103}
,{103,103}
,{2,2}
,{42,42}
,{103,103}
,{103,103}
,{2,2}
,{42,42}
,{2,2}
,{42,42}
,{6,6}
,{45,45}
,{2,2}
,{2,2}
,{63,63}
,{20,20}
,{22,22}
,{45,45}
,{42,42}
,{2,2}
,{2,2}
,{42,42}
,{5,3}
,{2,2}
,{4,4}
,{2,2}
,{2,2}
,{2,2}
,{42,42}
,{2,2}
,{4,4}
,{2,2}
,{2,2}
,{2,2}
,{2,2}
,{2,2}
,{71,71}
,{48,48}
,{22,22}
,{45,45}
,{2,2}
,{71,71}
,{16,16}
,{33,33}
,{2,2}
,{8,8}
,{2,2}
,{2,2}
,{5,5}
,{30,30}
,{30,30}
,{42,42}
,{2,2}
,{4,4}
,{4,4}
,{30,30}
,{22,22}
,{22,22}
,{45,45}
,{30,30}
,{45,45}
,{30,30}
,{30,30}
,{2,2}
,{63,63}
,{48,48}
,{22,22}
,{45,45}
,{30,30}
,{22,22}
,{4,4}
,{4,4}
,{4,4}
,{4,4}
,{4,4}
,{30,30}
,{30,30}
,{2,2}
,{2,2}
,{2,2}
,{30,3}
,{18,18}
,{30,30}
,{93,93}
,{4,4}
,{4,4}
,{18,18}
,{45,45}
,{18,18}
,{22,22}
,{22,22}
,{45,45}
,{18,18}
,{18,18}
,{2,2}
,{2,2}
,{18,18}
,{2,2}
,{2,2}
,{17,3}
,{4,4}
,{4,4}
,{30,30}
,{30,30}
,{30,30}
,{44,44}
,{4,4}
,{2,2}
,{18,18}
,{2,2}
,{2,2}
,{18,18}
,{18,18}
,{30,30}
,{71,71}
,{4,4}
,{4,4}
,{18,18}
,{18,18}
,{18,18}
,{18,18}
,{22,22}
,{45,45}
,{18,18}
,{22,22}
,{45,45}
,{18,18}
,{2,2}
,{2,2}
,{18,18}
,{51,51}
,{22,22}
,{45,45}
,{2,2}
,{63,63}
,{18,18}
,{45,45}
,{18,18}
,{22,22}
,{45,45}
,{18,18}
,{18,18}
,{2,2}
,{2,2}
,{18,18}
,{18,18}
,{18,18}
,{18,18}
,{30,30}
,{30,30}
,{100,100}
,{4,4}
,{4,4}
,{2,2}
,{18,18}
,{30,30}
,{59,59}
,{4,4}
,{4,4}
,{18,18}
,{2,2}
,{2,2}
,{18,18}
,{52,52}
,{52,52}
,{18,18}
,{22,22}
,{45,45}
,{18,18}
,{63,63}
,{67,67}
,{2,2}
,{63,63}
,{45,45}
,{18,18}
,{45,45}
,{18,18}
,{63,63}
,{4,4}
,{18,18}
,{18,18}
,{18,18}
,{22,22}
,{45,45}
,{30,30}
,{60,60}
,{4,4}
,{4,4}
,{2,2}
,{2,2}
,{2,2}
,{42,42}
,{4,4}
,{4,4}
,{4,4}
}
,
{16,0,0,0,0,0,0,0,0,0,0,0,0}
,
{0,0,0,2,0,56,0,30,1,192,0,6,13}
,
{40,0,0,0,0,0,0,1,0,0,0,0,0}
}
};


/* Non terminal table *\
\* ------------------ */
typedef  struct {
    UByte2 gto[1543];		/* Goto table */
    UByte2 gtoRix[363];		/* Goto row mapping */
    UByte2 lhs[405];		/* Left hand side symbols */
    UByte1 rhsz[405];		/* Size of the RHS */
} NonTermTab;

static NonTermTab gto = {
{1289,466,1289,82,162,138,2754,2978,217,2241,1330,1433,33,217,202,194,601
,1289,2618,858,57,2770,1737,2618,1713,154,178,90,162,138,1289,337,98,1289
,1289,1434,337,10,202,194,2274,2450,146,130,170,449,370,746,2658,154,178
,449,1426,2538,2785,1289,98,186,1313,217,1313,1082,2385,217,1833,441,146
,130,170,2618,153,441,2513,2618,329,1458,2994,449,2785,810,1289,186,337
,825,217,2970,337,1697,1281,2482,1833,1313,1458,2482,2618,2994,2513,441
,1609,177,898,1314,1633,177,1665,3066,337,337,1329,346,1529,825,1649,1313
,2562,2530,1834,809,201,1289,1433,1826,2754,1146,177,681,2754,2889,338,1529
,681,841,641,466,337,353,745,825,1281,1409,225,2505,1330,490,1289,225,1361
,2130,682,1674,1745,42,2217,2770,2770,378,1122,1697,2881,1826,337,2809,2585
,1289,1737,1057,122,1193,681,1425,1826,418,2649,2249,1745,106,2217,1313
,458,681,2185,1585,1074,2218,209,2809,2585,2001,2218,209,122,225,1130,2481
,2121,225,114,2249,1698,106,2362,2537,1313,1841,1849,1873,2370,2393,1105
,193,1826,2001,1882,1866,81,193,225,1882,1866,681,114,1281,1842,2177,2393
,2537,2218,1842,1850,2650,442,1826,3066,1850,2650,209,1050,2218,1161,209
,681,193,2226,1009,1161,1874,1890,2226,1858,1793,1874,1890,1521,1858,1153
,1882,1866,857,1273,1826,209,738,1106,1234,890,1842,1882,1866,681,1745,2514
,1850,1114,594,1066,1185,1842,2218,2673,2434,2650,1826,1850,1345,2650,2226
,1826,562,1874,1890,681,1858,546,426,1786,681,2226,1641,2218,1874,1890,217
,1858,1241,849,2650,1882,1866,1826,937,450,2618,1577,410,1562,617,1842,681
,1593,1098,2970,1289,1850,1585,337,1449,2218,1882,1866,1826,1497,417,881
,858,2665,17,2226,1842,681,1874,1890,177,1858,1850,1289,1354,2970,1570,2218
,2770,1826,2305,1673,2218,2770,1882,1866,2226,785,681,1874,1890,538,1858
,1833,1842,1617,1641,2545,1289,761,1850,1834,1825,2305,2218,730,1882,1866
,1313,602,681,1882,1866,1961,2226,1289,1842,1874,1890,2970,1858,1842,1850
,1001,1393,2218,1753,1850,1826,1706,2970,1281,2753,1882,1866,2777,2226,681
,2770,1874,1890,2226,1858,1842,1874,1890,2218,1858,2994,1850,1826,2754,2554
,2169,1882,1866,1281,457,2970,681,1289,2794,225,2226,1842,2994,1874,1890
,2218,1858,1850,1826,1897,1281,1729,1882,1866,2970,1777,873,681,169,1993
,2754,2226,1842,2754,1874,1890,1377,1858,1850,1826,2802,2057,2218,105,1882
,1866,2145,2281,681,2754,25,2754,2226,209,1842,1874,1890,457,1858,3042,1850
,481,2089,1809,2218,1281,1826,1817,2889,897,754,1882,1866,1785,2226,681
,377,1874,1890,2138,1858,1842,929,2337,1865,2218,689,1850,1826,97,1889,2521
,50,1882,1866,945,2418,681,2650,1793,537,2226,969,1842,1874,1890,2218,1858
,1985,1850,2361,706,722,1826,1882,1866,393,2569,2009,1953,1961,993,681,2226
,1842,185,1874,1890,2617,1858,1850,2049,2417,2218,409,1882,1866,1017,2073
,2081,1049,73,2161,2105,2226,1842,2793,1874,1890,2113,1858,1850,433,1081
,2137,2218,2033,2449,1914,2153,1097,1826,1882,1866,121,2226,1129,233,1874
,1890,681,1858,1842,1034,1145,2849,2233,2722,1850,2986,2218,2753,1826,2257
,1882,1866,473,1177,2297,2634,2313,681,2226,1386,1842,1874,1890,2329,1858
,1930,1850,2282,2353,1826,1209,2473,537,2377,1233,1882,1866,217,681,545
,2226,2409,593,1874,1890,1842,1858,2618,1826,1257,2441,1850,2697,249,2218
,609,2465,681,1297,298,337,2489,217,2497,49,2226,2034,2570,1874,1890,633
,1858,2618,2745,2529,2218,265,177,649,1826,1370,657,1378,1882,1866,337,2593
,2042,681,673,2633,2641,2761,1842,1922,705,2218,2706,2090,1850,1834,2106
,1089,2689,1882,1866,1465,737,2729,681,1489,2714,753,2226,1842,2218,1874
,1890,1513,1858,1850,1834,313,2825,2114,1882,1866,1545,2801,3002,681,2817
,1569,777,2226,1842,145,1874,1890,1538,1858,1850,2873,1834,1882,1866,2218
,793,1522,2122,2897,0,681,0,1842,2226,0,0,1874,1890,1850,1858,0,0,1834,0
,0,2218,0,225,0,0,0,681,2226,1882,1866,1874,1890,0,1858,0,0,0,0,1842,0,0
,2218,1834,0,1850,0,0,225,0,1882,1866,681,0,0,0,0,0,0,2226,1842,0,1874,1890
,2218,1858,1850,209,1834,0,0,1882,1866,0,0,0,0,681,0,0,2226,1842,0,1874
,1890,2218,1858,1850,0,1834,0,0,209,1882,1866,0,0,0,681,0,0,2226,0,1842
,1874,1890,0,1858,0,1850,2218,1834,2650,0,1882,1866,1834,0,0,0,681,0,0,2226
,1842,681,1874,1890,0,1858,1850,0,0,0,0,2218,0,2650,0,1882,1866,0,0,0,2226
,0,0,1874,1890,1842,1858,0,0,1834,0,1850,2218,0,1834,0,0,0,681,0,1882,1866
,0,681,0,2226,0,0,1874,1890,1842,1858,0,0,2218,0,1850,0,0,2218,0,1882,1866
,0,0,0,0,0,0,0,2226,1842,1834,1874,1890,0,1858,1850,0,0,0,681,0,1882,1866
,0,0,0,1882,1866,0,2226,0,1842,1874,1890,2218,1858,1842,1850,1834,2218,0
,1618,1850,0,0,0,0,681,0,0,0,2226,0,0,1874,1890,2226,1858,0,1874,1890,0
,1858,1882,1866,1834,1626,0,1882,1866,0,0,0,1842,681,2657,1834,2218,1842
,1850,0,0,0,0,1850,681,0,0,0,0,0,0,0,2226,0,0,1874,1890,2226,1858,0,1874
,1890,0,1858,2218,1882,1866,0,0,0,0,0,0,1834,217,1842,0,0,1834,0,0,1850
,681,2625,2618,329,0,681,0,0,818,2218,0,1882,1866,2226,0,337,1874,1890,0
,1858,2218,1842,2482,0,0,0,0,1850,0,0,0,0,177,1834,0,0,0,0,1882,1866,0,2226
,681,0,1874,1890,1834,1858,1842,1882,1866,0,0,0,1850,681,0,1594,2218,1842
,1554,0,0,2218,1745,1850,0,1602,2226,0,0,1874,1890,0,1858,0,0,1834,0,2226
,0,0,1874,1890,0,1858,681,1882,1866,1834,0,0,1882,1866,0,0,0,1842,681,0
,2218,0,1842,1850,0,1586,0,0,1850,217,0,0,0,2218,0,0,0,2226,0,2618,1874
,1890,2226,1858,225,1874,1890,217,1858,1882,1866,0,337,954,1873,0,946,2618
,329,1842,0,0,1882,1866,2218,1850,0,0,0,2546,337,0,1842,0,0,0,2218,2482
,1850,2226,0,0,1874,1890,0,1858,0,177,209,0,217,0,2226,1882,1866,1874,1890
,0,1858,0,2618,329,0,1842,0,1882,1866,0,217,1850,0,0,0,337,217,1842,2097
,0,2618,0,2482,1850,0,2226,2618,329,1874,1890,0,1858,177,337,217,2650,0
,2226,0,337,1874,1890,217,1858,2618,329,2482,0,217,0,361,0,2618,329,0,0
,177,337,2618,329,0,0,0,225,2482,337,217,0,0,217,0,337,2482,0,177,217,2618
,329,2482,2618,329,225,177,0,0,2618,329,0,177,337,217,321,337,0,0,0,2482
,0,337,2482,2618,1745,0,0,922,2482,177,209,0,177,0,0,0,337,0,177,0,0,0,0
,2490,882,0,930,225,209,0,0,0,0,177,0,0,0,1217,0,0,0,0,0,0,0,225,0,0,0,0
,0,225,0,0,0,2650,0,0,0,0,0,2737,0,0,0,0,914,0,0,225,0,209,0,2650,0,0,0
,225,0,713,0,0,0,225,0,0,0,817,0,209,0,0,0,905,0,209,0,0,0,0,0,225,0,0,225
,0,0,0,0,0,225,977,0,209,1473,0,2650,0,0,0,129,209,0,0,0,225,0,209,0,0,0
,0,0,0,2650,0,0,0,0,0,2650,0,0,0,0,209,0,0,209,0,0,0,0,0,209,0,0,0,2650
,0,0,0,0,0,0,0,2650,0,0,209,0,0,2650,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2650
,0,0,2650,0,0,0,0,0,2650,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2650}
,
{279,25,0,24,568,1,12,470,74,806,416,457,527,490,1306,637,608,59,12,325
,1321,421,76,96,1162,12,12,457,594,514,422,536,454,11,695,11,709,587,1180
,11,11,473,0,1241,11,364,8,409,84,429,301,10,446,635,13,316,601,511,475
,568,9,8,8,8,8,530,434,7,7,7,7,7,539,6,551,135,609,565,122,572,660,630,687
,3,330,3,587,1265,641,699,597,126,601,263,667,619,137,530,692,3,1273,3,3
,18,83,42,92,340,111,2,382,1279,448,2,381,105,302,465,41,411,1297,2,429
,254,20,345,2,2,2,445,25,645,2,457,660,463,44,468,2,2,50,474,114,1034,2
,488,135,737,605,511,1223,2,514,163,910,602,1,119,30,1,480,1,657,1,61,1
,144,80,100,1,321,163,347,1,0,344,11,120,1,185,276,612,1300,1,615,190,691
,667,95,76,1,725,1,727,680,164,22,133,1,47,157,1,50,87,76,1,51,212,764,183
,1,1,24,1,227,84,1,337,87,1,386,346,1,327,421,323,233,872,63,953,1,444,1045
,1,449,303,1046,1,1,1,1,1,424,177,63,47,470,419,1,373,1182,1,429,1,478,325
,623,493,395,346,666,566,505,55,431,508,436,566,353,1,37,13,1,1,85,597,93
,520,7,603,453,119,0,320,0,531,163,425,433,536,367,716,542,394,759,549,34
,17,0,556,416,801,0,570,441,844,575,489,899,658,586,2,369,335,491,2,186
,495,0,390,0,680,539,967,0,401,0,687,601,33,386,110,189,391,611,510,948
,0,0,615,1247,531,990,550,1003,232,0,390,545,134,643,581,602,0,448,0,737
,699,127,492,748,0,0}
,
{161,300,300,146,136,136,129,129,129,117,117,108,108,108,108,108,108,108
,108,108,108,108,108,108,108,137,150,301,151,280,152,271,153,244,244,163
,163,163,163,147,154,262,262,138,148,263,263,140,130,155,253,253,254,264
,265,290,290,282,282,323,323,164,164,334,334,156,314,314,157,310,315,316
,158,141,141,302,302,302,302,302,302,302,283,283,109,255,167,165,165,311
,311,304,312,303,166,168,291,291,291,132,246,246,169,121,170,272,272,111
,171,149,292,257,274,274,317,317,317,317,317,172,173,277,174,275,284,284
,112,175,122,318,318,176,131,278,177,259,259,305,305,305,305,305,305,179
,180,260,324,324,181,106,106,106,329,329,258,258,182,142,142,183,178,184
,276,276,286,286,113,185,248,186,162,306,287,288,293,293,187,133,133,123
,188,295,295,294,294,189,289,289,190,119,191,266,249,120,267,159,250,250
,296,296,296,296,296,192,193,251,332,332,134,143,144,194,194,114,114,114
,195,196,319,110,197,198,118,199,200,325,325,245,245,201,201,201,201,201
,201,201,160,307,307,307,307,202,203,204,313,313,313,313,313,313,313,313
,205,333,333,206,207,208,209,298,298,211,210,330,330,330,330,213,214,215
,216,217,218,320,320,219,331,331,268,220,221,328,328,252,252,125,222,223
,321,321,224,327,225,226,269,269,227,261,261,228,229,297,230,309,322,322
,247,247,231,116,116,232,135,135,233,299,299,299,299,299,299,234,235,236
,145,145,145,145,145,145,145,145,238,239,240,241,237,237,237,212,115,115
,115,115,285,285,124,124,124,124,242,243,126,126,126,126,127,127,127,127
,127,127,127,273,273,273,273,270,270,256,256,107,107,139,139,308,308,281
,281,326,128,279,279,105,105,105,105,105,105,105,105,105,105,105,105,105
,105,105,105,105,105,105,105,105,105}
,
{3,0,3,0,1,2,2,3,3,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,0,4,0,4,0,4,0,2,3,1
,2,3,2,3,0,1,2,4,2,1,2,3,3,0,1,2,2,2,2,1,2,1,4,0,2,1,1,1,3,0,1,4,0,2,2,4
,0,1,3,1,1,1,1,1,2,2,0,2,3,3,0,1,1,1,2,2,2,2,5,0,0,2,2,1,1,4,0,4,0,0,1,4
,0,3,2,2,0,2,1,1,4,1,1,0,0,4,0,4,0,2,6,0,2,0,6,0,3,4,2,0,2,1,1,1,1,4,1,0
,0,4,0,4,0,1,1,1,0,1,1,3,0,1,3,0,3,0,0,1,0,2,3,0,3,0,3,2,3,4,0,3,0,1,2,4
,0,1,2,0,3,0,0,3,0,4,0,2,4,3,4,2,0,2,1,1,4,1,1,0,0,4,0,2,2,3,2,1,2,3,2,6
,0,0,3,6,0,0,6,0,0,0,1,1,2,1,1,1,1,1,1,1,1,1,4,4,4,0,0,0,2,2,2,2,2,4,3,3
,0,6,6,0,0,0,0,3,6,0,2,6,5,5,7,0,0,0,0,0,0,0,3,0,1,1,11,0,0,0,1,1,2,6,0
,0,0,3,0,9,0,0,1,3,0,3,4,0,0,6,0,1,0,2,1,4,0,1,4,0,1,3,0,2,2,3,2,4,7,0,0
,0,2,1,1,1,3,4,1,6,0,0,0,0,1,3,3,2,1,1,1,1,0,1,1,1,3,3,0,0,1,1,1,1,1,1,1
,1,1,1,1,0,1,1,1,0,1,0,1,1,2,1,3,0,1,0,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1}
};


/* Vocabulary *\
\* ---------- */
typedef struct {
    UByte1 scc;			/* Scanner code value */
    UByte1 iCost;		/* Insertion cost */
    UByte1 dCost;		/* Deletion cost */
    char *name;			/* Name string */
    char *psym;			/* Print name */
} VocTab[104];
			     
static VocTab voc = {{1,255,255,"EndOfText",""}
,{2,1,1,"IDENT","Identifier"}
,{3,1,1,"','",""}
,{4,1,1,"'.'",""}
,{5,1,1,"'='",""}
,{6,1,1,"':'",""}
,{7,1,1,"'('",""}
,{8,1,1,"')'",""}
,{9,1,1,"'*'",""}
,{10,1,1,"'!'",""}
,{11,1,1,"'+'",""}
,{12,1,1,"'-'",""}
,{13,1,1,"'/'",""}
,{14,1,1,"'>'",""}
,{15,1,1,"'<'",""}
,{16,1,1,"'OR'",""}
,{17,1,1,"'TO'",""}
,{18,1,1,"'IS'",""}
,{19,1,1,"'IN'",""}
,{20,1,1,"'=>'",""}
,{21,1,1,"'BY'",""}
,{22,1,1,"'IF'",""}
,{23,1,1,"'ON'",""}
,{24,1,1,"'OF'",""}
,{25,1,1,"'AT'",""}
,{26,1,1,"'<>'",""}
,{27,1,1,"'=='",""}
,{28,1,1,"'>='",""}
,{29,1,1,"'<='",""}
,{30,1,1,"'END'",""}
,{31,1,1,"'NOT'",""}
,{32,1,1,"'AND'",""}
,{33,1,1,"'ISA'",""}
,{34,1,1,"'ARE'",""}
,{35,1,1,"'HAS'",""}
,{36,1,1,"'SAY'",""}
,{37,1,1,"'SET'",""}
,{38,1,1,"'USE'",""}
,{39,1,1,"'FOR'",""}
,{40,1,1,"'SUM'",""}
,{41,1,1,"'MAX'",""}
,{42,1,1,"'VERB'",""}
,{43,1,1,"'DOES'",""}
,{44,1,1,"'EXIT'",""}
,{45,1,1,"STRING",""}
,{46,1,1,"'QUIT'",""}
,{47,1,1,"'SAVE'",""}
,{48,1,1,"'ELSE'",""}
,{49,1,1,"'WHEN'",""}
,{50,1,1,"'NAME'",""}
,{51,1,1,"'THEN'",""}
,{52,1,1,"'STEP'",""}
,{53,1,1,"'WAIT'",""}
,{54,1,1,"'LIST'",""}
,{55,1,1,"'LOOK'",""}
,{56,1,1,"'MAKE'",""}
,{57,1,1,"'HERE'",""}
,{58,1,1,"'ONLY'",""}
,{59,1,1,"'ACTOR'",""}
,{60,1,1,"'EVENT'",""}
,{61,1,1,"'START'",""}
,{62,1,1,"'CHECK'",""}
,{63,1,1,"Integer",""}
,{64,1,1,"'WHERE'",""}
,{65,1,1,"'EMPTY'",""}
,{66,1,1,"'COUNT'",""}
,{67,1,1,"'UNTIL'",""}
,{68,1,1,"'AFTER'",""}
,{69,1,1,"'SCORE'",""}
,{70,1,1,"'ELSIF'",""}
,{71,1,1,"'OBJECT'",""}
,{72,1,1,"'SYNTAX'",""}
,{73,1,1,"'SCRIPT'",""}
,{74,1,1,"'STRING'",""}
,{75,1,1,"'LIMITS'",""}
,{76,1,1,"'HEADER'",""}
,{77,1,1,"'VISITS'",""}
,{78,1,1,"'SYSTEM'",""}
,{79,1,1,"'LOCATE'",""}
,{80,1,1,"'CANCEL'",""}
,{81,1,1,"'DEPEND'",""}
,{82,1,1,"'RANDOM'",""}
,{83,1,1,"'NEARBY'",""}
,{84,1,1,"'BEFORE'",""}
,{85,1,1,"'OPTIONS'",""}
,{86,1,1,"'MESSAGE'",""}
,{87,1,1,"'DEFAULT'",""}
,{88,1,1,"'RESTART'",""}
,{89,1,1,"'RESTORE'",""}
,{90,1,1,"'INTEGER'",""}
,{91,1,1,"'ARTICLE'",""}
,{92,1,1,"'BETWEEN'",""}
,{93,1,1,"'LOCATION'",""}
,{94,1,1,"'SYNONYMS'",""}
,{95,1,1,"'DESCRIBE'",""}
,{96,1,1,"'SCHEDULE'",""}
,{97,1,1,"'INCREASE'",""}
,{98,1,1,"'DECREASE'",""}
,{99,1,1,"'CONTAINS'",""}
,{100,1,1,"'CONTAINER'",""}
,{101,1,1,"'MENTIONED'",""}
,{102,1,1,"'DEPENDING'",""}
,{103,1,1,"'ATTRIBUTES'",""}
,{104,1,1,"'DESCRIPTION'",""}
}
;


/* Variables used in the parsing process *\
\* ------------------------------------- */
short pmStkP;			/* Stack pointer */
Token pmSySt[PmStkMax];	/* Symbol stack */
pmGrammar pmSeSt[PmStkMax];	/* Semantic stack */ 
static UByte2 currstat;		/* Current state number */
static UByte2 arg;		/* Argument */
static UByte1 action;		/* Action type */
static PmBoolean endparse;	/* Termination flag */
static ParseStack parsStk;	/* Parse stack */
static UByte1 scIndex[104 + 1]; /* Converts scanner code to internal value */
static Token tokenBuf;	/* Scanner token buffer */
static Token *token = &tokenBuf;	/* Pointer to it for readsymb */


/* Error recovery look-ahead buffer *\
\* -------------------------------- */
static Token la_buff[PmLaMax + 1]; /* Buffer */
static int la_ptr;		/* Current pointer */
static int la_end;		/* Last item */

static jmp_buf pmJmpB;		/* Buffer for long jump */

/* Interface routines *\
\* ------------------ */

extern void pmRPoi(	/* Error recovery - restart point  */
Token *sym			/* IN the restart symbol */
);
extern void pmISym(	/* Error recovery - insert symbol  */
int code,			/* IN terminal code number */
char *sstr,			/* IN terminal string */
char *pstr,			/* IN the terminals print symbol */
Token *sym			/* OUT the created scanner symbol */
);
extern void pmDSym(	/* Error recovery - delete symbol  */
Token *sym,			/* IN terminal code number */
char *sstr,			/* IN terminal string */
char *pstr			/* IN terminals print string */
);
extern void pmMess(	/* Error recovery - error message  */
Token *sym,			/* IN error token */
int method,			/* IN recovery method */
int code,			/* IN error classification */
int severity			/* IN error severity code */
);

/* External functions */
extern void pmPaSema(
int rule			/* IN production number */
);

/*----------------------------------------------------------------------------
 * paAbort - Abort the parsing process
 *----------------------------------------------------------------------------
 */
static void paAbort(
Token *token,		/* IN current token */
short eClass,			/* IN error classification */
short severity			/* IN error severity code */
)
{
    pmMess(token, HALT_REC, eClass, severity);
    longjmp(pmJmpB, PMTRUE);	/* Jump out to top level */
}/*paAbort()*/


/*----------------------------------------------------------------------------
 * SetIns - Add one element to a set
 *----------------------------------------------------------------------------
 */
#define SetIns(set, n) ((set)[(n) >> 3] |= (0x80 >> ((n) & 0x7)))


/*----------------------------------------------------------------------------
 * SetClear - Clear a ParserMaker set
 *----------------------------------------------------------------------------
 */
#define SetClear(set, length) memset((void *)set, 0, (size_t)((length) + 7) >> 3)

/*----------------------------------------------------------------------------
 * SetMem - Check member inclusion
 *----------------------------------------------------------------------------
 */
#define SetMem(set, n) ((set)[(n) >> 3] & (0x80 >> ((n) & 0x7)))


/*----------------------------------------------------------------------------
 * paInit - Initialize the parsing process
 *----------------------------------------------------------------------------
 */
static void paInit(void)
{
    short i;

    la_ptr = 0;
    la_end = 0;
    pmStkP = 0;
    currstat = 1;
    endparse = PMFALSE;
    parsStk[0] = 1;

    /* Scanner interface */
    for (i = 0; i <= SccMax; i++) scIndex[i] = ERR_SYM;
    for (i = TermMin; i <= Terms; i++) scIndex[voc[i - TermMin].scc] = (UByte1)i;
}/*paInit()*/


/*----------------------------------------------------------------------------
 * pushStat[Tok] - Push the current state on the stack and possibly push current
 *	      token on the symbol stack.
 *----------------------------------------------------------------------------
 */
#define MOVETOKEN pmSySt[pmStkP] = *token
#define pushStatTok()\
{\
    if (++pmStkP < PmStkMax) {\
	parsStk[pmStkP] = currstat;\
	MOVETOKEN;\
    } else {\
	token->code = voc[token->code-TermMin].scc;\
	paAbort(token, OFLW_ERR, SYS_SEV);\
    }\
} 

#define pushStat()\
{\
    if (++pmStkP < PmStkMax) {\
	parsStk[pmStkP] = currstat;\
    } else {\
	token->code = voc[token->code-TermMin].scc;\
	paAbort(token, OFLW_ERR, SYS_SEV);\
    }\
} 



/*----------------------------------------------------------------------------
 * actTbl - Do a look-up in the action table
 *----------------------------------------------------------------------------
 */
#define actTbl(st, sy, action, arg)\
{\
    register int actEnt;\
    register int actSt;\
    register int actSy;\
    actSt = st - StateMin;\
    actSy = sy - TermMin;\
    if (act.actCheck[act.actRix[actSt] + actSy] == actSt)\
	actEnt = act.act[act.actRix[actSt] + actSy];\
    else actEnt = ERROR_ACT;\
    *action = actEnt & 0x7;\
    *arg = actEnt >> 3;\
}/*actTbl()*/


/*----------------------------------------------------------------------------
 * gtoTbl - Do a look-up in the goto table
 *----------------------------------------------------------------------------
 */
#define gtoTbl(st, sy, action, arg)\
{\
    register int gtoEnt;\
    register int gtoSt;\
    register int gtoSy;\
    gtoSt = st - StateMin;\
    gtoSy = sy - Terms - 1;\
	gtoEnt = gto.gto[gto.gtoRix[gtoSt] + gtoSy];\
    *action = gtoEnt & 0x7;\
    *arg = gtoEnt >> 3;\
}/*gtoTbl()*/


/*----------------------------------------------------------------------------
 * E R R O R   R E C O V E R Y
 * ---------------------------
 *
 * The error recovery algorithm tries to modify current configuration in such
 * a way that parsing can be resumed correctly. Current configuration is
 * characterized by:
 *
 * w = x t y, where  x = parsed input
 *		     t = current token
 *		     y = unprocessed input
 *----------------------------------------------------------------------------
 */

typedef struct {
    Token err_tok;
    Token res_tok;
    short method;
    short eClass;
    short severity;
} ERR_REC;

static ERR_REC errdescr; 


/*----------------------------------------------------------------------------
 * ePush - Push a state during error recovery
 *----------------------------------------------------------------------------
 */
static void ePush(
UByte2 state,			/* IN state to push */
UByte2 stack[],			/* INOUT parser stack */
short *sp			/* INOUT current stack pointer */
)
{
    if (++(*sp) < PmStkMax) stack[*sp] = state;
    else paAbort(&errdescr.err_tok, OFLW_ERR, SYS_SEV);
}/*ePush()*/


/*----------------------------------------------------------------------------
 * legalAct - Check if a symbol is legal to shift in current state
 *----------------------------------------------------------------------------
 */
static PmBoolean legalAct(
UByte2 stack[],			/* IN current stack */
short stack_p,			/* IN current stack pointer */
UByte1 sym			/* IN symbol code */
)				/* RET true if "symbol" is read (shifted) */
				/*     in current state */
{
    UByte2 state;		/* Current state */
    UByte1 action;		/* Current parser action */
    UByte2 arg;			/* Current parser argument */

    ParseStack t_stk;		/* Temporary parser stack */
    int i;			/* For loop index */

    /* Copy stack
     */
    for (i = 0; i <= stack_p; i++) t_stk[i] = stack[i]; 

    state = stack[stack_p];

    for (;;) {
	actTbl(state, sym, &action, &arg);
	switch (action) {

	case ERROR_ACT:
	    return(PMFALSE);

	case SHIFT_ACT:
	case SHIFTRED_ACT:	
	case ACCEPT_ACT:
	    return(PMTRUE);

	case REDUCE_ACT:
	    do {
		stack_p = stack_p - gto.rhsz[arg - ProdMin];
		gtoTbl(t_stk[stack_p], gto.lhs[arg - ProdMin], &action, &arg);
		ePush(state, t_stk, &stack_p);
	    } while (action != SHIFT_ACT);
	    state = arg; t_stk[stack_p] = state;
	    break;

	}/*switch*/
    }/*for*/
}/*legalAct()*/
			     
	
/*----------------------------------------------------------------------------
 * gLegSym - Get legal symbols
 *----------------------------------------------------------------------------
 */
static void gLegSym(
ParseStack stack,		/* IN current stack */
short stack_p,			/* IN current stack pointer */
TermSet legals			/* OUT legal symbols in current state */
)
{
    short sym;			/* Loop index */

    SetClear(legals, Terms + 1);
    for (sym = 1; sym <= Terms; sym++) {
	if (legalAct(stack, stack_p, sym)) SetIns(legals, sym);
    }/*for*/
}/*gLegSym()*/


/*----------------------------------------------------------------------------
 * backup - Backup the parse stack until current symbol is accepted (shifted)
 *	    or the parse stack becomes empty
 *----------------------------------------------------------------------------
 */
static short backup(
ParseStack stack,		/* IN current stack */
short stack_p,			/* IN current stack pointer */
UByte1 sym	/* IN recovery symbol */
)				/* RET new stack pointer, 0 if symbol is */
				/*     not accepted */
{
    while ((stack_p > 0) && (!legalAct(stack, stack_p, sym))) stack_p--;
    return(stack_p);
}/*backup()*/


/*----------------------------------------------------------------------------
 * delSym - Delete a symbol in the input stream
 *----------------------------------------------------------------------------
 */
static void delSym(
Token *token			/* INOUT symbol to delete, new symbol */
)
{
    short  t;

    t = token->code - TermMin;
    token->code = voc[t].scc;
    pmDSym(token, voc[t].name, voc[t].psym);
{
    if (la_ptr < la_end) {
	la_ptr++;
	*token = la_buff[la_ptr];
    } else {
	do {
	    
    smScan(lexContext, token);


	    if (token->code > SccMax || token->code < 0) {
		token->code = ERR_SYM;
	    } else token->code = scIndex[token->code];
	    if (token->code == ERR_SYM) {
		pmMess(token, DEL_REC, LEX_ERR, FAT_SEV);
		}
	} while (token->code == ERR_SYM);
    }
}
    if (errdescr.method == IN_REC) errdescr.method = REP_REC;
    else if (errdescr.method != REP_REC) errdescr.method = DEL_REC;
}/*delSym()*/


/*----------------------------------------------------------------------------
 * inSym - Insert a symbol in the input stream
 *----------------------------------------------------------------------------
 */
static void inSym(
short isym,			/* IN symbol code to insert */
Token *gen_symb		/* OUT created symbol */
)
{
    pmISym(voc[isym - TermMin].scc, voc[isym - TermMin].name,
	   voc[isym - TermMin].psym, gen_symb);
    if (errdescr.method == DEL_REC) errdescr.method = REP_REC;
    else if (errdescr.method != REP_REC) errdescr.method = IN_REC; 

    gen_symb->code = isym;
}/*inSym()*/


/*----------------------------------------------------------------------------
 * M U L T I P L E   R E C O V E R Y
 * ---------------------------------
 *
 * The multiple symbols recovery technique is a "true local corrector", i.e.
 * it will always return a legal configuration for any input. Logically the
 * algorithm can be described as follows:
 *
 * 1) Roerich method (Karlsruhe):
 *    a. Find a continuation "u" of "x", such that "xu" is accepted.
 *    b. De composite "ty" into "qsy'", where q is a string.
 *    c. Delete "q".
 *    d. Insert u' (a prefix of u) between "x" and "sy'" giving xu' s y'.
 *
 * 2) Panic mode:
 *    If "q" contains a fiducial symbol "a"  then:
 *    a. Pop stack until "a" is accepted.
 *    b. If not succeeded resume at step 1.
 *----------------------------------------------------------------------------
 */

typedef struct {
    UByte2 r_state;		/* Recovery state */
    PmBoolean r_sepa;		/* Insert separator? */
    UByte2 r_sstat;		/* Where to insert separator */
} REC_POI;


/*----------------------------------------------------------------------------
 * acceptbl - Check whether "symbol" is reachable from current state using
 *	      the continuation grammar.
 *----------------------------------------------------------------------------
 */
static void acceptbl(
UByte1 sym,			/* IN terminal symbol code */
ParseStack stack,		/* IN parse stack */
short stack_p,			/* IN stack pointer */
Token *token,			/* IN current token */
PmBoolean *found,		/* OUT "symbol" accepted? */
REC_POI *point			/* OUT recovery point description */
)
{
    PmBoolean done;		/* Terminator flag */
    UByte2 state;		/* Current state */
    UByte1 action;		/* Parser action */
    UByte1 sep_act;		/* Parser action separator test */
    UByte2 arg;			/* Parser prod/state */
    UByte2 sep_arg;		/* Parser prod/state separator test */
    PmBoolean sepa_acc;		/* Separator is accepted? */
    ParseStack t_stk;		/* Temporary parser stack */
    short i;			/* Copy loop index */

    for (i = 0; i <= stack_p; i++) t_stk[i] = stack[i];

    state = t_stk[stack_p];
    done = PMFALSE;

    while (!done) {
	actTbl(state, sym, &action, &arg);
	if (legalAct(t_stk, stack_p, sym)) {
	    /* Symbol is directly accepted */
	    done = PMTRUE;
	    *found = PMTRUE;
	    point->r_state = state;
	} else {
	    /* Use the continuation grammar */
	    actTbl(state, act.recover.cont[state - StateMin].tsym, &action,
		   &arg);
	    actTbl(state, act.recover.cont[state - StateMin].ssym, &sep_act,
		   &sep_arg);
	    if ((action != sep_act) || (arg != sep_arg)) {
		/* A separator is legal. Check if current symbol is accepted
		 * behind the separator
		 */
	        ParseStack stk;	/* Temporary stack */
	        short sp;	/* Temporary stack pointer */

		sp = stack_p; 
		for (i = 0; i <= stack_p; i++) stk[i] = t_stk[i];
		sepa_acc = PMFALSE;

		while (!sepa_acc) {
		  actTbl(stk[sp], act.recover.cont[state - StateMin].ssym,
			 &sep_act, &sep_arg);
		    switch (sep_act) {

		    case ERROR_ACT:
		    case ACCEPT_ACT:
			sepa_acc = PMTRUE;
			break;

		    case SHIFT_ACT: 
			sepa_acc = PMTRUE;
			ePush(sep_arg, stk, &sp);
			break;

		    case SHIFTRED_ACT:
			ePush(1, stk, &sp);
			sepa_acc = PMTRUE;
			goto reduce;

		    case REDUCE_ACT:
		      reduce:
			do {
			    sp -= gto.rhsz[sep_arg-ProdMin];
			    gtoTbl(stk[sp], gto.lhs[sep_arg-ProdMin], &sep_act,
				   &sep_arg);
			    ePush(1, stk, &sp);
			} while (sep_act != SHIFT_ACT);

			stk[sp] = sep_arg;
			break;
		    }/*switch*/
		}/*while*/

		if ((sep_act == SHIFT_ACT) || (sep_act == SHIFTRED_ACT)) {
		    if (legalAct(stk, sp, sym)) {
			/* Separator is to be inserted */
			point->r_state = stk[sp];
			point->r_sepa = PMTRUE;
			point->r_sstat = state;
			done = PMTRUE;
			*found = PMTRUE;
		    }/*if*/
		}/*if*/
	    }/*if*/
		  
	    if (!*found) {
		switch (action) {

		case ERROR_ACT: 
		    paAbort(token, TAB_ERR, SYS_SEV);
		    break;

		case ACCEPT_ACT:
		    done = PMTRUE;
		    break;

		case SHIFT_ACT:
		    state = arg;
		    ePush(state, t_stk, &stack_p);
		    break;

		case SHIFTRED_ACT:
		    ePush(state, t_stk, &stack_p);
		    goto reduce2;

		case REDUCE_ACT:
		  reduce2:
		    do {
			stack_p -= gto.rhsz[arg-ProdMin];
			gtoTbl(t_stk[stack_p], gto.lhs[arg-ProdMin], &action,
			       &arg);
			ePush(state, t_stk, &stack_p);
		    } while (action != SHIFT_ACT);

		    state = arg;
		    t_stk[stack_p] = state;
		    break;

		}/*switch*/
	    }/*if*/
	}/*if*/
    }/*while*/
}/*acceptbl()*/


/*----------------------------------------------------------------------------
 * search - Search recovery point
 *----------------------------------------------------------------------------
 */
static void search(
ParseStack stack,		/* IN current stack */
short *stack_p,			/* INOUT current stack pointer */
Token *token,			/* INOUT current symbol */
REC_POI *point			/* OUT descriptor of where to restart */
				/*     the parser */
)
{
    UByte2 state;		/* Current state */
    PmBoolean rp_found;		/* Recovery point found? */
    short new_stkp;		/* Temp stack pointer */

    state = stack[*stack_p];
    point->r_state = state;
    point->r_sepa = PMFALSE;
    point->r_sstat = 1;
    rp_found = PMFALSE;

    do {
	if (!SetMem(act.recover.skip, token->code)) {
	    acceptbl(token->code, stack, *stack_p, token, &rp_found, point);
	}/*if*/

	if (!rp_found) {
	    new_stkp = 0;
	    if (SetMem(act.recover.fiduc, token->code)) {
		new_stkp = backup(stack, *stack_p, token->code);
	    }/*if*/
	    if (new_stkp > 0) {
		rp_found = PMTRUE;
		*stack_p = new_stkp;
		point->r_state = stack[*stack_p];
		errdescr.method = BAK_REC;
	    } else 
	        delSym(token);
	}/*if*/
    } while (!rp_found);
}/*search()*/


/*----------------------------------------------------------------------------
 * reach - Use the continuation functions and insert symbols upto curr token.
 *----------------------------------------------------------------------------
 */
static void reach(
ParseStack stack,		/* INOUT current stack */
short *stack_p,			/* INOUT current stack pointer */	
Token *token,			/* INOUT current symbol */
REC_POI *point			/* IN recovery point descriptor */
)
{
    UByte2 state;		/* Current state */
    UByte1 cont_sym;		/* Continuation symbol */
    Token gen_symb;		/* Generated symbol */
    UByte1 action;		/* Current parser action */
    UByte2 arg;			/* Current prod/state */
    PmBoolean sepaAccept;	/* Separator accepted yet? */
    PmBoolean useSepa;		/* Use the separator now? */

    state = stack[*stack_p];
    gen_symb = *token;
    useSepa = PMFALSE;
    while (state != point->r_state) {
	if (point->r_sepa)
	    if (state == point->r_sstat) {
		/* Separator state reached, remember to use separator */
		cont_sym = act.recover.cont[state-StateMin].ssym;
		useSepa = PMTRUE;
	    } else cont_sym = act.recover.cont[state-StateMin].tsym;
	else cont_sym = act.recover.cont[state-StateMin].tsym;
	sepaAccept = PMFALSE;

	do {
	  actTbl(state, cont_sym, &action, &arg);
	  switch (action) {

	  case ERROR_ACT:
	    paAbort(token, TAB_ERR, SYS_SEV);
	    break;

	  case ACCEPT_ACT:
	    break;

	  case SHIFT_ACT:
	    sepaAccept = PMTRUE;
	    state = arg;
	    inSym(cont_sym, &gen_symb);
	    ePush(state, stack, stack_p);
	    pmSySt[*stack_p] = gen_symb;
	    break;

	  case SHIFTRED_ACT:
	    sepaAccept = PMTRUE;
	    inSym(cont_sym, &gen_symb);
	    ePush(state, stack, stack_p);
	    pmSySt[*stack_p] = gen_symb;
	    goto reduce;

	  case REDUCE_ACT:
	    reduce:
	    do {
		*stack_p = *stack_p - gto.rhsz[arg-ProdMin];
		pmPaSema(arg);
		gtoTbl(stack[*stack_p], gto.lhs[arg-ProdMin], &action, &arg);
		ePush(state, stack, stack_p);
	    } while (action != SHIFT_ACT);
	    state = arg;
	    stack[*stack_p] = state;
	  }/*switch*/
	} while (useSepa && !sepaAccept);
    }/*while*/
}/*reach()*/


/*----------------------------------------------------------------------------
 * global - Global error recovery
 *----------------------------------------------------------------------------
 */
static void multiple(
ParseStack err_stk,		/* INOUT current parse stack */
short *err_stkp,		/* INOUT current stack pointer */
Token *err_tok,		/* INOUT current token */
UByte2 *newstat		/* OUT state after recovery */	
)
{
    REC_POI  point;		/* Recovery point descriptor */

    search(err_stk, err_stkp, err_tok, &point);
    reach(err_stk, err_stkp, err_tok, &point);
    *newstat = err_stk[*err_stkp];
}/*multiple()*/


/*----------------------------------------------------------------------------
 * S I N G L E   R E C O V E R Y
 * -----------------------------
 *
 * The single recovery technique tries to REPAIR the error by finding the
 * least cost single symbol correction. One single symbol of:
 * - insertion
 * - deletion
 * - replacement
 * is concidered. The cost of the repair is the sum of the ADAPTION cost and
 * the MODIFICATION cost. The adaption cost indicates how well a correction
 * fits in the context. The modification cost is based on the
 * insertion/deletion cost given in the input. A correction is applied if
 * the cost is below a predefined threshold value.
 *----------------------------------------------------------------------------
 */

#define ShiftCost (PmCost)	/* The cost of shifting one symbol */
#define InfCost (ShiftCost * (PmLaMax)) /* Infinity */
#define Thresh (((PmLaMax) - 3) * ShiftCost) /* Acceptance cost */


/*----------------------------------------------------------------------------
 * readLa - Read tokens to the look-ahead buffer
 *----------------------------------------------------------------------------
 */
static void readLa(
Token *curtok			/* IN current token */
)
{
    int i;
    Token tokbuf;
    Token *token = &tokbuf;

    la_buff[0] = *curtok;
    *token = *curtok;
    for (i = la_ptr + 1; i <= la_end; i++) {
	/* Move old look_ahead to the beginning of the buffer */
	la_buff[i - la_ptr] = la_buff[i];
    }/*for*/
    la_end = la_end - la_ptr;
    la_ptr = -1;

    while ((la_buff[la_end].code != ENDMARK) && (la_end < PmLaMax)) {
	la_end++;
	do {
            
    smScan(lexContext, token);


	    if (token->code > SccMax || token->code < 0) {
		token->code = ERR_SYM;
	    } else {
		token->code = scIndex[token->code];
	    }/*if*/
	    if (token->code == ERR_SYM) {
		pmMess(token, DEL_REC, LEX_ERR, FAT_SEV);
	    }/*if*/
	} while (token->code == ERR_SYM);
	la_buff[la_end] = *token;
    }/*while*/
}/*readLa()*/


/*----------------------------------------------------------------------------
 * rdLaSym - Fetches the i:th look-ahead symbol code from the look-ahead set
 *----------------------------------------------------------------------------
 */
static UByte1 rdLaSym(
char index			/* IN i:th look-ahead symbol */
)				/* RET token code */
{
    if (index > la_end) return(ENDMARK);
    else return(la_buff[(int)index].code);
}/*rdLaSym()*/


/*----------------------------------------------------------------------------
 * laParse - Continue the parsing process by reading tokens from the
 *	     look-ahead set. The parse is terminated when:
 *	     - out of read ahead
 *	     - a new error is encountered
 *	     Note! No semantic actions are carried out
 *----------------------------------------------------------------------------
 */
static void laParse(
UByte1 sym,			/* IN current terminal symbol */
char next_la,			/* IN index to next look-ahead symbol */
ParseStack stack,		/* IN parse stack */
short stack_p,			/* IN current stack pointer */
short *cost			/* OUT adaption cost */
)
{
    PmBoolean done ;		/* Terminator flag */
    char sh_cnt;		/* Number of shifted symbols */
    UByte2 state;		/* Current state number */
    UByte1 action;		/* Parser action */
    UByte2 arg; 		/* Parser argument */
    short i;			/* Loop index */
    ParseStack t_stk;		/* Temporary stack */

    /* Copy stack
     */
    for (i = 0; i <= stack_p; i++) t_stk[i] = stack[i];	

    done = PMFALSE;
    sh_cnt = 0;
    state = t_stk[stack_p];

    while (!done) {
	actTbl(state, sym, &action, &arg);
	
	switch (action) {

	case ERROR_ACT: 
	    done = PMTRUE;
	    break;

	case SHIFT_ACT:
	    state = arg;
	    ePush(state, t_stk, &stack_p);
	    sh_cnt++;
	    if (sh_cnt == PmLaMax) done = PMTRUE;
	    else {
		sym = rdLaSym(next_la);
		next_la++;
	    }/*if*/
	    break;

	case SHIFTRED_ACT:
	    ePush(state, t_stk, &stack_p);
	    sh_cnt++;
	    if (sh_cnt == PmLaMax) done = PMTRUE;
	    else {
		sym = rdLaSym(next_la);
		if (next_la < PmLaMax) next_la++;
	    }/*if*/
	    goto reduce;

	case REDUCE_ACT:
	  reduce:
	    do {
		stack_p -= gto.rhsz[arg-ProdMin];
		gtoTbl(t_stk[stack_p], gto.lhs[arg-ProdMin], &action, &arg);
		ePush(state, t_stk, &stack_p);
	    } while (action != SHIFT_ACT); 

	    state = arg;
	    t_stk[stack_p] = state;
	    break;

	case ACCEPT_ACT:
	    done = PMTRUE;
	    sh_cnt = PmLaMax;
	    break;

	}/*switch*/
    }/*while*/

    *cost = InfCost - (sh_cnt*ShiftCost);
}/*laParse()*/


/*----------------------------------------------------------------------------
 * tryIn - Tries to insert a symbol from the legal set in front of current
 *	   token: x t y  => x st y, where s becomes current symbol
 *----------------------------------------------------------------------------
 */
static void tryIn(
TermSet legals,			/* IN set of legal symbols */
ParseStack stack,		/* IN current parser stack */
short stack_p,			/* IN current stack pointer */
UByte1 *sym,			/* OUT best insertion symbol */
short *cost,			/* OUT best cost so far */
short *choice			/* OUT best choice so far */
)
{
    short i;
    short mod_cost;		/* Modification cost */
    short ad_cost;		/* Adaption cost */
    short tot_cost;		/* Total insertion cost */

    for (i = 1; i <= Terms; i++) {
	/* For all legal symbols
	 */
	if (SetMem(legals, i)) {
	    mod_cost = voc[i - TermMin].iCost;
	    if (mod_cost < *cost) {
		laParse(i, 0, stack, stack_p, &ad_cost);
		tot_cost = ad_cost + mod_cost;
		if (tot_cost < *cost) {
		    *cost = tot_cost;
		    *choice = IN_REC;
		    *sym = (UByte1)i;
		}/*if*/
	    }/*if*/
	}/*if*/
    }/*for*/
}/*tryIn()*/


/*----------------------------------------------------------------------------
 * tryRep - Tries to replace currrent symbol with a new terminal:
 *	    x t y  => x s y, where s becomes current symbol
 *----------------------------------------------------------------------------
 */
static void tryRep(
TermSet legals,			/* IN set of legal symbols */
ParseStack stack,		/* IN current parser stack */
short stack_p,			/* IN current stack pointer */
UByte1 *sym,			/* OUT best replacement symbol */
short *cost,			/* OUT best cost so far */
short *choice			/* OUT best choice so far */
)
{
    short i;
    short mod_cost;		/* Modification cost */
    short ad_cost;		/* Adaption cost */
    short tot_cost;		/* Total replacment cost */

    for (i = 1; i <= Terms; i++) {
	/* For all legal symbols
	 */
	if (SetMem(legals, i)) {
	    mod_cost = (short) (voc[i-TermMin].iCost +
			voc[rdLaSym(0)-TermMin].dCost) / 2 + 1;
	    if (mod_cost < *cost) {
		laParse(i, 1, stack, stack_p, &ad_cost);
		tot_cost = ad_cost + mod_cost;
		if (tot_cost < *cost) {
		    *cost = tot_cost;
		    *choice = REP_REC;
		    *sym = (UByte1)i;
		}/*if*/
	    }/*if*/
	}/*if*/
    }/*for*/
}/*tryRep()*/


/*----------------------------------------------------------------------------
 * tryDel - Tries to delete current symbol: x t y  => x y
 *----------------------------------------------------------------------------
 */
static void tryDel(
ParseStack stack,		/* IN current parser stack */
short stack_p,			/* IN current stack pointer */
short *cost,			/* INOUT best cost so far */
short *choice			/* INOUT best choice so far */
)
{
    short mod_cost;		/* Modification cost */
    short ad_cost;  		/* Adaption cost */
    short tot_cost;		/* Total deletion cost */

    mod_cost = voc[rdLaSym(0) - TermMin].dCost;
    if (mod_cost < *cost) {
	laParse(rdLaSym(1), 2, stack, stack_p, &ad_cost);
	tot_cost = ad_cost + mod_cost;
	if (tot_cost < *cost) {
	    *cost = tot_cost;
	    *choice = DEL_REC;
	}/*if*/
    }/*if*/
}/*tryDel()*/


/*----------------------------------------------------------------------------
 * _pmInsert
 *----------------------------------------------------------------------------
 */
static void _pmInsert(
UByte1 sym,			/* IN symbol code to insert */
Token *token			/* OUT constructed token */
)
{
    inSym(sym, token);
}/*_pmInsert()*/


/*----------------------------------------------------------------------------
 * _pmReplace
 *----------------------------------------------------------------------------
 */
static void _pmReplace(
UByte1 sym,			/* IN replacement symbol code */
Token *token			/* OUT constructed token */
)
{
    delSym(token);
    inSym(sym, token);
}/*_pmReplace()*/


/*----------------------------------------------------------------------------
 * _pmDelete
 *----------------------------------------------------------------------------
 */

static void _pmDelete(
Token *token			/* OUT new token */
)
{
{
    if (la_ptr < la_end) {
	la_ptr++;
	*token = la_buff[la_ptr];
    } else {
	do {
	    
    smScan(lexContext, token);


	    if (token->code > SccMax || token->code < 0) {
		token->code = ERR_SYM;
	    } else token->code = scIndex[token->code];
	    if (token->code == ERR_SYM) {
		pmMess(token, DEL_REC, LEX_ERR, FAT_SEV);
		}
	} while (token->code == ERR_SYM);
    }
}
    delSym(token);
}/*_pmDelete()*/


/*----------------------------------------------------------------------------
 * single - Single error recovery
 *----------------------------------------------------------------------------
 */
static void single(
TermSet leg_sys,		/* IN legal symbols in current state */
ParseStack err_stk,		/* INOUT current parser stack */
short *err_stkp,		/* INOUT current stack pointer */
Token *token,		/* INOUT current token */
UByte2 *newstat		/* OUT recovery state */
)
{
    short choice;		/* Recovery action performed */
    short cost;			/* Best cost so far */
    UByte1 sym;			/* Insert symbol */

    choice = NONE_REC;
    cost = InfCost;
    readLa(token);

    tryIn(leg_sys, err_stk, *err_stkp, &sym, &cost, &choice);
    tryRep(leg_sys, err_stk, *err_stkp, &sym, &cost, &choice);
    tryDel(err_stk, *err_stkp, &cost, &choice);

    if (cost > Thresh) choice = NONE_REC;

    switch (choice) {

    case IN_REC:
	_pmInsert(sym, token);
	break;

    case DEL_REC:  
	_pmDelete(token);
	break;

    case REP_REC: 
	_pmReplace(sym, token);
	break;

    default:
{
    if (la_ptr < la_end) {
	la_ptr++;
	*token = la_buff[la_ptr];
    } else {
	do {
	    
    smScan(lexContext, token);


	    if (token->code > SccMax || token->code < 0) {
		token->code = ERR_SYM;
	    } else token->code = scIndex[token->code];
	    if (token->code == ERR_SYM) {
		pmMess(token, DEL_REC, LEX_ERR, FAT_SEV);
		}
	} while (token->code == ERR_SYM);
    }
}
    }/*switch*/

    *newstat = err_stk[*err_stkp];
}/*single()*/



/*----------------------------------------------------------------------------
 * recover - From an error
 *----------------------------------------------------------------------------
 */
static void recover(
ParseStack err_stk,		/* INOUT updated parse stack */
short *err_stkp,		/* INOUT updated stack pointer */
Token *err_symb,		/* INOUT current token */
UByte2 *rec_stat		/* OUT state after recovery */
)
{
    TermSet legal_sy;		/* Legal symbols */

    errdescr.err_tok = *err_symb;
    errdescr.err_tok.code = voc[errdescr.err_tok.code - TermMin].scc;
    errdescr.method = NONE_REC;
    errdescr.eClass = SYN_ERR;
    errdescr.severity = ERR_SEV;
    gLegSym(err_stk, *err_stkp, legal_sy);
    single(legal_sy, err_stk, err_stkp, err_symb, rec_stat);
    if (errdescr.method == NONE_REC) {
	multiple(err_stk, err_stkp, err_symb, rec_stat);
	pmMess(&errdescr.err_tok, errdescr.method, errdescr.eClass, 
	       errdescr.severity); 
    } else {
	pmMess(&errdescr.err_tok, errdescr.method, SYN_ERR, errdescr.severity);
    }/*if*/
    errdescr.res_tok = *err_symb;
    errdescr.res_tok.code = voc[errdescr.res_tok.code - TermMin].scc;
    pmRPoi(&errdescr.res_tok);
}/*recover()*/


/*----------------------------------------------------------------------------
 * pmParse - Parser routine, entry point
 *----------------------------------------------------------------------------
 */
void pmParse(void)
{
    paInit();
{
    if (la_ptr < la_end) {
	la_ptr++;
	*token = la_buff[la_ptr];
    } else {
	do {
	    
    smScan(lexContext, token);


	    if (token->code > SccMax || token->code < 0) {
		token->code = ERR_SYM;
	    } else token->code = scIndex[token->code];
	    if (token->code == ERR_SYM) {
		pmMess(token, DEL_REC, LEX_ERR, FAT_SEV);
		}
	} while (token->code == ERR_SYM);
    }
}
    pushStatTok()
    if (setjmp(pmJmpB)) return;

    while (!endparse) {
	actTbl(currstat, token->code, &action, &arg);

	switch (action) {

	case ERROR_ACT:
	    recover(parsStk, &pmStkP, token, &currstat);
	    if (pmStkP == 0) endparse = PMTRUE;
	    break;

	case SHIFT_ACT:
	    currstat = arg;
	    pushStatTok();
{
    if (la_ptr < la_end) {
	la_ptr++;
	*token = la_buff[la_ptr];
    } else {
	do {
	    
    smScan(lexContext, token);


	    if (token->code > SccMax || token->code < 0) {
		token->code = ERR_SYM;
	    } else token->code = scIndex[token->code];
	    if (token->code == ERR_SYM) {
		pmMess(token, DEL_REC, LEX_ERR, FAT_SEV);
		}
	} while (token->code == ERR_SYM);
    }
}
	    break;

	case SHIFTRED_ACT:
	    pushStatTok();
{
    if (la_ptr < la_end) {
	la_ptr++;
	*token = la_buff[la_ptr];
    } else {
	do {
	    
    smScan(lexContext, token);


	    if (token->code > SccMax || token->code < 0) {
		token->code = ERR_SYM;
	    } else token->code = scIndex[token->code];
	    if (token->code == ERR_SYM) {
		pmMess(token, DEL_REC, LEX_ERR, FAT_SEV);
		}
	} while (token->code == ERR_SYM);
    }
}
	    goto reduce;

 	case REDUCE_ACT:
	  reduce:
	    do {
		pmStkP -= gto.rhsz[arg - ProdMin];	
		pmPaSema(arg);
		gtoTbl(parsStk[pmStkP], gto.lhs[arg - ProdMin], &action, &arg);
		pushStat();
	    } while (action != SHIFT_ACT);

	    currstat = arg;
	    parsStk[pmStkP] = currstat;
	    break;

	case ACCEPT_ACT:
	    endparse = PMTRUE;
	    break;
	}/*switch*/
    }/*while*/
}/*pmParse()*/

