! This include file is for the purpose of containing objects prefixed by 'ROOM_', i.e. rooms.

! A class to handle AGT rooms. Based on BarringerRoom by C.E.Forman and Gareth Rees.
class AGTRoom
 with
  n_to
  [;
   print "You can't go n from here!^";
   return self;
  ],
  s_to
  [;
   print "You can't go s from here!^";
   return self;
  ],
  e_to
  [;
   print "You can't go e from here!^";
   return self;
  ],
  w_to
  [;
   print "You can't go w from here!^";
   return self;
  ],
  u_to
  [;
   print "You can't go u from here!^";
   return self;
  ],
  d_to
  [;
   print "You can't go d from here!^";
   return self;
  ],
  ne_to
  [;
   print "You can't go ne from here!^";
   return self;
  ],
  nw_to
  [;
   print "You can't go nw from here!^";
   return self;
  ],
  se_to
  [;
   print "You can't go se from here!^";
   return self;
  ],
  sw_to
  [;
   print "You can't go sw from here!^";
   return self;
  ],
  in_to
  [;
   print "You can't enter anything here.^";
   return self;
  ],
  out_to
  [;
   print "You're not inside anything that you can exit.^";
   return self;
  ],
  short_name
  [;
   print_ret "<< ", (object)self, " >>";
  ]
 has
;

! Limbo - a special room.
object ROOM_Limbo "Limbo"
 with
  description "Limbo is a special room, not intended to be visited.",
  name "limbo"
 has
  enterable
  light
;

! Foggy street a
AGTRoom ROOM_StreetA "the foggy street"
 with
  description "The is fog everywhere, obscuring the entire landscape. Max feels suddenly like a huge cloud has lifted him up and taken him away. He wonders where he has gone.",
  e_to ROOM_Bedroom,	! The bedroom
  n_to ROOM_Theatre,	! The theatre
  w_to ROOM_Cobble	! The cobble street
 has
  light
;

! The theatre.
AGTRoom ROOM_Theatre "the theatre"
 with
  description "Max is onstage. He is dressed in kahki fatigues. His head is shaved. He is playing the part of man trapped inside his own skin. Three other people, his ~family~ try to tell he is alright. But he is not alright. He is misunderstood. He cannot even begin to articulate how he feels. But there is a panic inside him, growing more desparate by the moment. He begins to scoop water out of a large metal pot and watch it trickle back. he does this for some time. the movement comforts him. then the panic strikes again. He spies something shiny in the water. He reaches in and grasps the object and hurls it into the air. A huge fish flies across the stage and lands wetly a few feet away. Everyone is suddenly very quiet.",
  e_to ROOM_StreetC,	! Foggy street C
  n_to
  [;
   return self;	! The theatre
  ],
  s_to ROOM_StreetA,	! Foggy street A
  w_to ROOM_Forest	! The forest
 has
  light
;

! The hospital.
AGTRoom ROOM_Hospital "the hospital"
 with
  description "Max is in the operating room of a hospital. His wife is on the operating table, breathing quite heavily. There are several doctors and nurses in the room. He tries to touch one of them but his hand passes right through. His wife is breathing heavier now. He goes to her, tries to talk to her. She does not hear. A nurse comes up to Max and tells him if he is cannot calm down he will have to leave. He watches quietly as they cut open his wife's stomach. He watches the birth of his son. The nurse comes up to him, handing him the baby. The doctors have begun to sew up his wife. ~You will have to leave now,~ the nurse says. He looks down at his baby son, but the child is gone.",
  e_to ROOM_Parlor,	! The parlor
  n_to ROOM_StreetB,	! Foggy street B
  s_to ROOM_StreetC,	! Foggy street C
  w_to ROOM_Forest	! The forest
 has
  light
;

! The bedroom
AGTRoom ROOM_Bedroom "the bedroom"
 with
  description "Max is in bed with his grandfather Willie. Willie is snoring quite loudly. Max turns over to tell his grandfather to be quiet when he is assailed by the smell of grandfather's breath. Willie is fond of cigars and they give his breath the aroma of used dragon smoke. Max starts to get out of bed, but finds he is surrounded by an impenetrable darkness. The bed seems to be floating. Willie begins talking in his sleep. ~What's the matter with you,~ he says. ~You never listen to anything I tell you. You think you're so smart. You're a bum just like your father. Never listen to me.~ Willie begins to swing his hands in his sleep. Max ducks and dodges. Finally he lifts his pillow in self defense. Under the pillow is a wet cigar.",
  e_to ROOM_StreetB,	! Foggy street B
  n_to ROOM_StreetA,	! Foggy street A
  s_to
  [;
   return self;		! Loops back on itself.
  ],
  w_to
  [;
   return self;		! Loops back on itself.
  ],
 has
  light
  scored
;

! The study.
AGTRoom ROOM_Study "the study"
 with
  description "Max is in cantor Diamond's study. The cantor is a tall man with an open face and kind eyes. Max is listening to him sing a passage from the haftorah. Morris Diamond has the most beautiful voice in the world. Long before Max has ever heard opera, he has heard enough of Morris Diamond to change his life forever. When he hears the cantor sing he is swept up in the peculair feeling of tremendous joy and unspeakable sorrow. The cantor's voice touches him in a way that Max can never forget. Morris asks Max to repeat the passage. Although he does not have a bad singing voice, his chanting cannot compare with the cantor's. Max begins to weep, not for his lack of talent, but for his lack of feeling. How could he follow such a voice. Morris Diamond goes to his desk and opens a drawer. He takes out a small book and places it on the table before Max.",
  e_to ROOM_StreetA,	! Foggy street A
  n_to ROOM_Lake,	! The frozen lake
  s_to ROOM_Parlor,	! The parlor
  w_to ROOM_StreetA	! Foggy street A
 has
  light
  scored
;

! The forest
AGTRoom ROOM_Forest "the forest"
 with
  description "Max is in the woods near his house. It is a crisp autumn day. His nostrils flare as he picks up the scent of burning leaves. Every autumn old man Whittaker sets the woods on fire. All the kids in the neighborhood tell their parents, but they are not believed. So each autumn, the woods behind their rowhouse burns. the firemen come out with their trucks. Several hours later the fire will be out for another year. But now is the time of greatest danger. The forest is blazing all around Max. He feels the heat of the flames on his face. If he doesn't move soon he will become part of the blaze. Max hopes he does not step in any poison ivy.",
  e_to ROOM_Fire,	! The raging fire
  n_to ROOM_Fire,	! The raging fire
  s_to ROOM_Patch,	! The patch
  w_to ROOM_Fire	! The raging fire
 has
  light
;

! The cobble street
AGTRoom ROOM_Cobble "the cobble street"
 with
  description "Max is walking down a cobble street when a small boy, perhaps a year old, falls to the pavement from a second story window. The baby gasps and then does not move. For a moment, Max is paralyzed with horror. Before he can recover, a woman comes running out of the house screaming, ~my baby, my baby.~ She lifts the child up high into the air above her, sobbing hysterically. She runs back inside the house and closes the door behind her.",
  e_to ROOM_StreetB,	! The foggy street B
  n_to ROOM_Alley,	! The alley
  s_to ROOM_Hospital,	! The hospital
  w_to ROOM_StreetC	! The foggy street C
 has
  light
;

! The frozen lake
AGTRoom ROOM_Lake "the frozen lake"
 with
  description "It is after the first snowfall of winter. The lake has frozen solid. Max stands on the newly formed ice and listens to the quietness. He can hear the tinkle of icecicles banging against each other in the wind as they hang off the evergreen brahcnes. Max feels he is at he center of the universe and that center is calm. He thinks of Morris Diamond. Max can hear the faint sound of a dog barking two miles away.",
  e_to ROOM_Alley,	! The alley
  n_to ROOM_StreetA,	! Foggy street A
  s_to ROOM_Forest,	! The forest
  w_to ROOM_Door,	! The front door
 has
  light
  scored
;

! The front door
AGTRoom ROOM_Door "the front door"
 with
  description
  [;
   deadflag=2;	! You have won the game.
   print "Quite unexpectedly, Max finds himself at his front door. How long has he been walking, he wonders. And what was he doing out on a night like this?", (NewLine)1, "He can't remember. The fog has obliterated the street behind him. He fumbles for his house keys, opens his door and climbs the steps.", (NewLine)1, "~A fine thing,~ he mumbles,~ to be walking around on such a night. A person could get lost.~";
   print (NewLine)2, (Center)"~~~~~~~~~~~~~~~~~~~~", (NewLine)1, "T H E      E N D", (NewLine)1, (Center)"~~~~~~~~~~~~~~~~~~~~", (NewLine)1;
   ! Does not justify the means.
   WaitForKey ("[Press any key...]");
   rtrue;
  ],
 has
  light
;

! The raging fire
AGTRoom ROOM_Fire "the raging fire"
 with
  description "Max is surrounded by flames. The whole forest is burning! If Max does not do something soon, he will be burned alive.",
  e_to ROOM_Patch,	! The patch
  n_to
  [;
   return self;
  ],
  s_to
  [;
   return self;
  ],
  w_to
  [;
   return self;
  ],
 has
  light
;

! The patch
AGTRoom ROOM_Patch "the patch"
 with
  description "Max find himself in the only part of the forest not in flames, a patch of poison ivy. He walks through it gingerly trying not to touch anthing, but he is already beginning to feel itchy all over his body.",
  e_to ROOM_Study,	! The study
  n_to ROOM_Fire,	! The raging fire
  s_to ROOM_StreetA,	! Foggy street A
  w_to ROOM_StreetB	! Foggy street B
 has
  light
;

! Foggy street B
AGTRoom ROOM_StreetB "the foggy street"
 with
  description "The is fog everywhere, obscuring the entire landscape. Max feels suddenly like a huge cloud has lifted him up and taken him away. He wonders where he has gone.",
  e_to ROOM_StreetA,	! Foggy street A
  n_to ROOM_Cobble,	! The cobble street
  s_to
  [;
   return self;		! Foggy street B
  ],
  w_to ROOM_Bedroom	! The bedroom
 has
  light
;

! Foggy street C
AGTRoom ROOM_StreetC "the foggy street"
 with
  description "The is fog everywhere, obscuring the entire landscape. Max feels suddenly like a huge cloud has lifted him up and taken him away. He wonders where he has gone.",
  e_to ROOM_Study,	! The study
  n_to ROOM_Forest,	! The Forest
  s_to ROOM_StreetB,	! Foggy street B
  w_to ROOM_StreetA	! Foggy street A
 has
  light
;

! The alley
AGTRoom ROOM_Alley "the alley"
 with
  description
  [;
   print_ret "Max watches four young girls jump rope in a red bricked alley not far from his home. They play with an intensity that precludes any awareness that they are watched. The rope skips across the concrete as the girls chant with great seriousness,", (NewLine)2, "~Cinderella", (NewLine)1, "Dressed in yell-a", (NewLine)1, "Went upstairs to see her fella", (NewLine)1, "How many kisses did she get:", (NewLine)1, "One...", (NewLine)1, "two...", (NewLine)1, "three...~", (NewLine)1, "Suddenly the eldest girl spins around and stares at Max. The other girls all fall in behind her. The jump rope lies on the ground, lifeless.";
   ! Like this script.
  ],
  e_to ROOM_Hospital,	! The hospital
  n_to ROOM_StreetC,	! Foggy street C
  s_to ROOM_Parlor,	! The parlor
  w_to ROOM_Forest	! The forest
 has
  light
;

! The parlor
AGTRoom ROOM_Parlor "the parlor"
 with
  description "Max is sitting next to Cora on a large green couch. It is the hottest day of the summer. They are content to sip lemonade, chat softly and wait for Cora's roommate to leave the stuffy apartment. Max's desire for Cora is finally answered as she slips into his arms. He unbottons her blouse and beholds a vision that will mark him for the rest of his life. Cora's breasts are beautiful She wears a small silver cross around her neck which falls with erotic precision in the tuck of her cleavage. A drop of sweat has beaded up on Cora's collar bone and falls slowly down to meet the cross. For Max, the drop of sweat is pure magic, the most remarkable thing he has ever witnessed in his entire life. Cora looks at him warmly and smiles.",
  e_to ROOM_Hospital,	! The hospital
  n_to ROOM_StreetA,	! Foggy street A
  s_to ROOM_Forest,	! The forest
  w_to ROOM_Bedroom	! The bedroom
 has
  light
;