!***************************************************************************
!**
!** Not Just A Game - Copyright (c) 1999 by John Menichelli
!** 
!**                        Hints/Help
!**
!***************************************************************************

!***************************************************************************
!**
!**  Hints
!**
!***************************************************************************

#ifdef INCLUDE_HINTS;

Array lr_hints table [;
   "Relax - stay a while.";
   "Watch TV.";
   "Read a few good books.";
];

Array kitchen_hints table [;
   "You're not hungry, but there are still a few things you can do here.";
   "Examine the refrigerator.";
   "And the oven.";
   "Read the poster.";
];

Array bedroom_hints table [;
   "You're not sleepy, but there are still a few things you can do here.";
   "Play with the computer.";
   "Look closely at the desk.";
   "How about the drawer?";
   "Look under the bed.";
];

Array bathroom_hints table [;
   "Did you talk to the dragon in the shower?";
   "Ask the dragon about the riddle.";
   "What dragon?";
   "What riddle?";
   "Actually, you don't need anything in the bathroom to finish the game.";
];

Array closet_hints table [;
   "Examine everything in the closet.";
   "Those boxes are neatly stacked.";
   "Maybe a little too neatly.";
   "Try to move them.";
   "Hey! A safe!";
   "But you need a combination...";
   "Did you open the desk drawer?";
   "It seems to stick a little when you open and close it.";
   "Look under it.";
   "When you open the safe, you find a lever.";
   "So pull it!";
   "What's that noise? Go look around and see if you can find 
    out what happened.";
   "The bookshelf moved, revealing a stairway leading down.";
];

Array go_board_hints table [;
   "Have you found the Go booklet and the four white Go stones?";
   "Then you know that Go stones belong on Go boards.";
   "Did you read how stones are captured?";
   "Try capturing a black stone with the white ones.";
   "You'll have to do some exploring before you see the significance of 
    this, though.";
];

Array maze_hints table [;
   "Have you done any exploring?";
   "It looks like a maze, doesn't it?";
   "Don't worry, it's not!";
   "The rooms are merely laid out in a 9x9 pattern.";
   "Every now and then the walls change color.";
   "Examine the walls.";
   "Where else have you seen this pattern and these materials?";
   "Go equipment, maybe?";
   "Each room corresponds to a coordinate on the 9x9 Go board.";
   "Those coordinates without stones are made of the same material as the 
    board.";
   "While those with stones are made of the same material as the stone.";
];
   
Array cube_hints table [;
   "Remember: take everything.";
   "Specifically, the cube.";
];

Array wheel_hints table [;
   "The idea here is to get the waterwheel turning.";
   "That water pipe probably has something to do with it.";
   "And the valve is the key.";
   "Open the valve.";
   "Hmmmm - that doesn't work.";
   "Look closely at the valve stem.";
   "Something must go in that hole.";
   "Put the rod in the hole, then open the valve.";
];

Array salt_hints table [;
   "Not much in this room besides salt.";
   "Take some of it - it might come in handy later.";
];

Array sculp_hints table [;
   "Look closely at the sculpture.";
   "There's a ball the the bottom of the cylinder.";
   "You have to find some way of getting it out of the cylinder.";
   "Read any good books lately?";
   "Read the books in the living room.";
   "Put the salt in the water.";
];

Array wood_hints table [;
   "That log is pretty big, isn't it?";
   "It's so big, you can't carry it up the steps.";
   "Did you find the lathe?";
   "If you haven't found the waterwheel yet, go solve that puzzle first.";
   "Once you get the waterwheel turning, the lathe will have power.";
   "Put the log in the clamp, then start the lathe.";
];

Array drum_hints table [;
   "That drum looks interesting.";
   "Try opening it.";
   "Couldn't do it, huh? Maybe you need more leverage.";
   "Something you can pry with.";
   "How about the steel rod?";
   "Pry the lid with the rod.";
   "Well, now you opened the drum.";
   "Look inside.";
   "Take the gloves.";
];

Array work_hints table [;
   "There's a steel rod on the workbench.";
   "So take it.";
   "Oops - now you did it!";
   "You can't reach the fuse.";
   "You'll need something to reach down into the hole.";
   "How about the rod?";
   "But it needs something... else.";
   "Something sticky, maybe?";
   "Put the chewed gum on the rod.";
   "Then put the rod in the hole.";
];

Array shop_hints table [;
   "You can't use the lathe until you solve the waterwheel puzzle.";
   "Read the description of the lathe carefully.";
   "Try putting different objects into the clamp, then starting the lathe.";
   "Have you seen anything that just begs to be shaped?";
   "How about that log?";
];

Array silver_hints table [;
   "There are several different bins here.";
   "Most of them have metal ingots in them.";
   "Take them all - you never know if they'll be useful.";
   "However, you'll only need one of them.";
   "The silver ingot, in particular.";
];

Array control_hints table [;
   "You can't solve this puzzle until you solve the waterwheel puzzle.";
   "Take a close look at the glass plate.";
   "There's faint smudge on it.";
   "What can you do to make it more visible?";
   "Read any good books lately?";
   "There's a clue in the books in the living room.";
   "Something about dark powder and fingerprints.";
   "Have you found any dark powder?";
   "Soot, maybe?";
   "Put the soot on the glass plate.";
   "Then press the plate.";
];

Array duct_hints table [;
   "There sure are a lot of pipes and ducts in here, huh?";
   "Look at all of them.";
   "One of them has some soot on it.";
   "Take some of it - it might come in handy later.";
];
   
Array kiln_hints table [;
   "Remember to search everything.";
   "Search the shards.";
   "Take the mold.";
];

Array furn_hints1 table [;
   "The first thing to do is light the furnace.";
   "There are several things that have to be done before that will happen.";
   "Did you find the diary?";
   "There's a hint in there.";
   "Notice the socket on the side of the stove?";
   "Did you find the fuse?";
   "Put the fuse in the socket.";
   "There are two buttons on the furnace.";
   "Press them and see what happens.";
   "One of them controls the blower.";
   "The other actually starts the furnace.";
];

Array furn_hints2 table [;
   "Now that the furnace works, you need to put it to use.";
   "Did you find the silver ingot?";
   "Put it in the asbestos cup";
   "Close the crucible.";
   "Then start the furnace.";
   "So now you have some molten silver.";
   "What can you do with it?";
   "Did you ever find the gloves?";
   "You'll have to wear the gloves to get the asbestos cup out of the 
    crucible.";
   "Did you find the mold?";
   "Molten silver and a mold - that looks like a match.";
   "Before you pour the silver into the mold, you'll have to put the mold on 
    something solid first.";
   "Like that steel table.";
   "So now you have a mold full of silver.";
   "Take a good look at the mold.";
   "It's brittle, but not exactly falling apart.";
   "You need something to give it a good whack.";
   "Hit the mold with the bat.";
   "There you go - four silver Go stones!";
];

Array get_here_hints table [;
   "Do you have the gold Go stone?";
   "Do you have the four silver Go stones?";
   "Did you notice anything about the 9x9 Go board?";
   "If you superimpose the four areas over the 9x9 Go board, there's a ~hole~ 
    in the middle.";
   "Now, you have this gold Go stone and these four silver ones...";
   "Put the gold Go stone on E5, then capture it with the silver stones.";
   "Go to the center of the ~maze~, then go down the stairs.";
];

Array large_go_hints table [;
   "Hey! It's the missing Go board.";
   "Go get it.";
   "Oh, you can't.";
   "You'll have to wait a while for that to happen."
   "In the mean time, continue exploring.";
];

Array block_hints table [;
   "Have you looked around?";
   "There is a marble block in each of the rooms adjacent to the Go board.";
   "By now you must have found the four cubes.";
   "The cubes fit on the marble blocks.";
   "But which cube goes on which block?";
   "You could try every possible combination, but that would take a while.";
   "Did you ever find a poster?";
   "There was one on the side of the refrigerator.";
   "There seems to be a correlation between the rooms and the cubes.";
   "Put the black cube on the northern block.";
   "Put the red cube on the southern block.";
   "Put the white cube on the western block.";
   "Put the green cube on the eastern block.";
   "Something happens each time you put a cube on the correct block - 
    you'll have to check another category for those hints.";
];

Array test_hints table [;
   "Each Testing Room presents you with a different Go problem.";
   "Use the information in the Go booklet to help you.";
   "Each board's description tells you what you're trying to do.";
   "There's no easy way to hint at each problem's solution, so the following
    'hints' will give explicit solutions.";
   "Northern Testing Room: Put the crystal Go stone on I9.";
   "Southern Testing Room: Put the crystal Go stone on G9."; 
   "Eastern Testing Room: Put the crystal Go stone on I6.";
   "Western Testing Room: Put the crystal Go stone on E7.";
];

Array end_hints table [;
   "Well, now the lesson begins.";
   "All you have to do is determine black's score and white's score.";
   "Remember, komi is zero and no stones have been captured.";
   "The easiest way to count the score is to divide the board into different 
    areas.";
   "Here's the breakdown for black:";
   "Upper center: 4 points.";
   "Center, left: 7 points.";
   "The large area in center: 46 points.";
   "Lower left: 10 points.";
   "The area just northeast of the lower left: 1 point.";
   "This give a total of 68 points for black.";
   "Here's the breakdown for white:";
   "Upper left: 54 points.";
   "Upper right: 8 points";
   "Right center: 2 points.";
   "Bottom left: 4 points.";
   "Bottom right: 4 points.";
   "This give a total of 72 points for white.";
   "Once you have the scores, do what your teacher told you to do.";
   "Put the white sphere into depression number 72.";
   "Put the black sphere into depression number 68.";
];

[ ShowHints list a b;
   a = list-->0;
   for (b = 1 : b <= a : b++) {
      print "^(Hint ", b, " of ", a, "): ";
      print (string) list-->b;
      if (a ~= b) {
         print "^^Do you want another hint (answer y or n)? ";
         if (YesNo() == 0) break;
      }
      else {
         print "^^[Press any key to continue]";
         Pause();
      }
   }
];

[ YesNo i;
   for (::) {
      read buffer parse;
      i = parse-->1;
      if (i==YES1__WD or YES2__WD or YES3__WD) rtrue;
      if (i==NO1__WD or NO2__WD or NO3__WD) rfalse;
      L__M(##Quit,1); print "> ";
  }
];

Menu hint_menu "Hints";
Option -> "About These Hints"
   with description
      "This game uses an adaptive hint system, which means that you won't
       see hints for areas of the game you haven't explored. The hints for
       each area start out vague and end with an explicit solution. Use them
       wisely!";

Menu -> "The House";
Option -> -> "Living Room"
   with description [; ShowHints(lr_hints); return 2; ];
Option -> -> "Kitchen"
   with description [; ShowHints(kitchen_hints); return 2; ];
Option -> -> "Bedroom"
   with description [; ShowHints(bedroom_hints); return 2; ];
Option -> -> "Closet"
   with description [; ShowHints(closet_hints); return 2; ];
Option -> -> "Bathroom"
   with description [; ShowHints(bathroom_hints); return 2; ];

Option dim_menu "Dim Chamber"
   with description [; ShowHints(go_board_hints); return 2; ];

Option maze_menu "The ~Maze~"
   with description [; ShowHints(maze_hints); return 2; ];
   
Menu water_menu "The Water Rooms";
Option -> "The Pedestal Chamber"
   with description [; ShowHints(cube_hints); return 2; ];
Option -> "The Waterwheel Room"
   with description [; ShowHints(wheel_hints); return 2; ];
Option -> "The Salt Chamber"
   with description [; ShowHints(salt_hints); return 2; ];
Option -> "The Sculpture Chamber"
   with description [; ShowHints(sculp_hints); return 2; ];

Menu wood_menu "The Wood Rooms";
Option -> "The Pedestal Room"
   with description [; ShowHints(cube_hints); return 2; ];
Option -> "The Workshop"
   with description [; ShowHints(shop_hints); return 2; ];
Option -> "Wood Storage"
   with description [; ShowHints(wood_hints); return 2; ];
Option -> "The Drum Room"
   with description [; ShowHints(drum_hints); return 2; ];

Menu metal_menu "The Metal Rooms";
Option -> "The Pedestal Room"
   with description [; ShowHints(cube_hints); return 2; ];
Option -> "The Control Room"
   with description [; ShowHints(control_hints); return 2; ];
Option -> "The Material Storage Room"
   with description [; ShowHints(silver_hints); return 2; ];
Option -> "The Work Room"
   with description [; ShowHints(work_hints); return 2; ];

Menu fire_menu "The Fire Rooms";
Option -> "The Pedestal Room"
   with description [; ShowHints(cube_hints); return 2; ];
Option -> "The Duct Room"
   with description [; ShowHints(duct_hints); return 2; ];
Option -> "The Kiln Room"
   with description [; ShowHints(kiln_hints); return 2; ];
Option -> "The Oven Room (Part 1)"
   with description [; ShowHints(furn_hints1); return 2; ];
Option -> "The Oven Room (Part 2)"
   with description [; ShowHints(furn_hints2); return 2; ];

Menu earth_menu "The Earth Rooms";
Option -> "How do you get here?"
   with description [; ShowHints(get_here_hints); return 2; ];
Option -> "Go Board"
   with description [; ShowHints(large_go_hints); return 2; ];
Option -> "Marble Blocks"
   with description [; ShowHints(block_hints); return 2; ];
Option -> "The Testing Rooms"
   with description [; ShowHints(test_hints); return 2; ];

Option endgame "Endgame"
   with description [; ShowHints(end_hints); return 2; ];

Option "Walkthrough" hint_menu
   with description [;
            print "You are about to read a complete step-by-step walkthrough
                   for ~Not Just A Game.~ This is a bare-bones walkthrough, 
                   and won't explain some of the finer points of the game.
                   Are you sure you want to read this (answer y or n)? ";

               if (YesNo() == 0)
                  return 2;
               else

            print "^The game starts out in the living room of your teacher's 
                   house.  Examine the end table and get the white Go stones. 
                   Go south to the bedroom. Open the drawer, then open the 
                   box and get the gold stone. Look under the drawer and 
                   you will get a business card. Go south again and move the 
                   boxes; this will reveal a safe. Read the card, use the 
                   combination to open the safe, then pull the lever. Go 
                   north twice and then go down.^^";

            print "One at a time, put the white stones on coordinates C2, 
                   C4, B3 and D3. Then capture C7, G3 and G7. ^^";

            print "Go northeast, north six times and east twice. Go down and 
                   west. Get the salt, then go east twice. Put the salt 
                   in the cylinder and get the ball. Go west and north and 
                   get the black cube. Go south and up, south four times, 
                   then down.^^";
                   
            print "Go south and get the rod. Open the ball and get the gum.
                   Chew the gum, then put it on the rod. Put the rod in the 
                   hole to retrieve the fuse. Go north twice and get the white 
                   cube. Go south and up, north four times, then down.^^";

            print "Go south and put the rod in the stem's hole. Open the 
                   valve, then get the rod. Go north, up, east four times, 
                   then down.^^";

            print "Go north and get the green cube, then go south and west. 
                   Pry the lid with the rod, then look in the drum. Get the 
                   gloves. Go east and south, then get the log. Go north and 
                   east. Put the log in the clamp. Push the button and get 
                   the bat. Go west and up, south four times, then down.^^";

            print "Go north and get the red cube. Go south and west, then get 
                   the soot. Go east twice. Search the shards, then get the 
                   mold. Go west and up, west four times, then down.^^";

            print "Go east and put the soot on the glass plate, then press 
                   the plate. Go west twice. Open the silver bin and get 
                   the silver ingot. Go east and up, east four times, then 
                   down.^^";

            print "Go south. Put the fuse in the socket, then press the green 
                   button. Open the crucible and put the ingot in the cup.
                   Close the crucible, then press the red button. Put 
                   the mold on the table. Put on the gloves, then open the 
                   crucible. Get the cup and pour the cup into mold. Hit the 
                   mold with the bat, then get the four silver Go stones. Go 
                   north and up, south twice, west six times, then 
                   southwest.^^";
                   
            print "Put the gold stone on E5, then capture E5. Go northeast, 
                   north four times, then east four times. Go down and north.^^";

            print "Put the black cube on the pedestal, then go north twice. 
                   Get the crystal Go stone and put it on I9. Go south four 
                   times.^^";

            print "Put the red cube on the pedestal, then go south twice. 
                   Get the crystal Go stone and put it on G9. Go north three 
                   times and east.^^";
                   
            print "Put the green cube on the pedestal, then go east twice. 
                   Get the crystal Go stone and put it on I6. Go west four 
                   times.^^";

            print "Put the white cube on the pedestal, then go west twice. 
                   Get the crystal Go stone and put it on E7. Go east three 
                   times.^^";

            print "Put the white sphere in depression 72 and the black sphere 
                   in depression 68. That's it!^^";
];

#endif;

[ HintSub ;
   #ifdef INCLUDE_HINTS;
      hint_menu.select();
   #ifnot;
      "Sorry, this version of ~Not Just A Game~ doesn't include hints.";
   #endif;
];

!***************************************************************************
!**
!**  Help
!**
!***************************************************************************

[ HelpSub ;
   help_menu.select();
];

Menu help_menu "Help";
Menu -> "How To Play Interactive Fiction";
Option -> -> "Basics"
   with description [;
            print "~Interactive Fiction~ is the modern term for text 
                   adventures. In an adventure game, you play by typing 
                   commands that describe what you want to do. Unfortunately, 
                   the game isn't as smart as you are, so it doesn't 
                   understand nearly as many sentences as people do. This 
                   section will describe most of the types of commands that 
                   you will need to use while playing this game.^^

                   Each time you see the prompt, '>', you type a command. Your 
                   command should be a simple imperative sentence, or a series 
                   of imperatives separated by periods. Press the RETURN (or 
                   ENTER) key when you are done typing your command; the game 
                   will then process your command.^^

                   You can use upper or lower case letters in any combination. 
                   You can use words such as THE and AN when they're 
                   appropriate, or you can omit them if you prefer.^^";
        ];

Option -> -> "Other Characters"
   with description [;
      print "You may encounter other characters in the game. You can interact 
             in certain ways with these characters.  For example, you can 
             GIVE things to them, and you could try to attack them. In 
             addition, you can ask characters about things:^^";

      print "     ASK WIZARD ABOUT WAND^^";

      print "You can also tell characters to do something. To do this, type 
             the character's name, then a comma, then a command that you want 
             the character to perform.  You can type several commands for the 
             character all on the same line by separating the commands with 
             periods. For example:^^";

      print "     ROBOT, GO NORTH. PUSH BUTTON. GO SOUTH.^^";

      print "Of course, you shouldn't expect that characters will always 
             follow your instructions; most characters have minds of their 
             own, and won't automatically do what you ask.^^";
   ];

Option -> -> "Time and Travel"
   with description [;
            print "At all times during the game, you are in a specific 
                   location. The game describes your location when you first 
                   enter that location, and again any time you type LOOK. In 
                   a given location, you can reach anything described, so you 
                   don't need to type commands to move about within a 
                   location.^^";

            print "You move from place to place in the game by typing the 
                   direction you want to go. The game will usually tell you 
                   the directions that you can go from a location, although 
                   it usually doesn't tell you what you will find when you 
                   go there. You will probably find it helpful to make a map 
                   as you explore the game. The directions the game recognizes 
                   are NORTH, SOUTH, EAST, WEST, NORTHEAST, SOUTHEAST, 
                   NORTHWEST, SOUTHWEST, UP, and DOWN. You can abbreviate 
                   these to N, S, E, W, NE, SE, NW, SW, U, and D. In some 
                   locations you can also use IN and OUT.^^";

            print "Generally, backtracking will take you back to where you 
                   started. For example, if you start off in the kitchen, go 
                   north into the living room, then go south, you will be back 
                   in the kitchen.^^";

            print "Time passes only in response to commands you type. 
                   Nothing happens while the game is waiting for you 
                   to type something. Each turn takes about the same 
                   amount of time. If you want to let some game time 
                   pass, because you think something is about to happen, 
                   you can type WAIT (or just Z).^^";
        ];

Option -> -> "Objects"
   with description [;
            print "In the game, you will find many objects that you can carry 
                   or otherwise manipulate. When you want to do something with 
                   an object, type a simple command that tells the game what 
                   you want to do; be explicit. For example, you could type 
                   READ THE BOOK or OPEN THE DRAWER. Most of the objects in the 
                   game have fairly obvious uses; you shouldn't have to think 
                   of any obscure or unrelated words to manipulate the 
                   objects.^^

                   You don't have to specify exactly where you want to put 
                   an object that you wish to carry; you can just type TAKE 
                   or GET (followed by the object's name) to pick up an 
                   object.^^

                   Some basic verbs that you will use frequently are TAKE 
                   (to pick up an object), DROP (to drop an object), OPEN 
                   and CLOSE, and EXAMINE (which you can abbreviate to X). 
                   You can PUT an object IN or ON another object when 
                   appropriate. The game recognizes many other verbs as 
                   well. The verbs should be obvious; if you find a knob, 
                   you will be able to TURN it, and if you find a button, 
                   you will be able to PUSH it. By the same token, you 
                   probably won't need to turn the button or push the knob.
                   Don't be afraid to try unusual commands, though - you 
                   never know what may happen.^^

                   Some examples of commands that the game recognizes are 
                   shown below. These aren't necessarily commands that you'll 
                   ever type while playing, but they illustrate some of the 
                   verbs and sentence formats that you may use.^^";

            print "     GO NORTH^";
            print "     NORTH^";
            print "     N^";
            print "     UP^";
            print "     TAKE THE BOX^";
            print "     PUT THE FLOPPY DISK INTO THE BOX^";
            print "     CLOSE BOX^";
            print "     LOOK AT DISK^";
            print "     TAKE DISK OUT OF BOX^";
            print "     LOOK IN BOX^";
            print "     WEAR THE CONICAL HAT^";
            print "     TAKE OFF HAT^";
            print "     CLOSE BOX^";

            if (small_board has general) {
               print "     PUT THE WHITE STONE ON E5^";
               print "     GET THE WHITE STONE FROM E5^";
               print "     RESET BOARD^"; }

            if (task_done->2 == 1)
               print "     CAPTURE C3^";
            print "     TURN ON THE LANTERN^";
            print "     LIGHT MATCH^";
            print "     LIGHT CANDLE WITH MATCH^";
            print "     BURN BOOK WITH CANDLE^";
            print "     RING BELL^";
            print "     POUR WATER INTO BUCKET^";
            print "     PUSH BUTTON^";
            print "     TURN THE KNOB^";
            print "     TURN KNOB^";
            print "     EAT COOKIE^";
            print "     DRINK MILK^";
            print "     THROW KNIFE AT THIEF^";
            print "     KILL TROLL WITH SWORD^";
            print "     READ NEWSPAPER^";
            print "     LOOK THROUGH WINDOW^";
            print "     UNLOCK DOOR WITH KEY^";
            print "     TIE THE ROPE TO THE HOOK^";
            print "     CLIMB UP THE LADDER^";
            print "     JUMP^";
            print "     GIVE WAND TO JOE^";
            print "     ASK SUZY ABOUT WAND^^";
        ];

Option -> -> "Score"
   with description [;
            print "The game assigns you a score while you play, indicating 
                   how close you are to finishing the game. At certain points 
                   in the game, you will be awarded points when you solve some 
                   puzzle or obtain some item. The score is intended to 
                   provide you with a measure of your progress in the game, 
                   and increases as you get further in the game. You never 
                   lose points once they are earned.^^

                   You may find out your current score with the command SCORE. 
                   To see what you have accomplished (and how many points you 
                   have received for each accomplishment), use the command 
                   FULL.^^";
        ];

Option -> -> "Multiple Objects"
   with description [;
            print "You can usually use multiple objects in your sentences. 
                   You separate the objects with the word AND or a comma. 
                   For example:^^";

            print "     TAKE THE BOX, THE FLOPPY DISK, AND THE ROPE^";
            print "     PUT DISK AND ROPE IN BOX^";
            print "     DROP BOX AND BALL^^";

            print "You can use the word ALL to refer to everything that is 
                   applicable to your command, and you can use EXCEPT or BUT 
                   (right after the word ALL) to exclude certain objects.^^";

            print "     TAKE ALL^";
            print "     PUT ALL EXCEPT DISK AND ROPE INTO BOX^";
            print "     TAKE EVERYTHING OUT OF THE BOX^";
            print "     TAKE ALL OFF SHELF^^";

            print "The word ALL refers to everything that makes sense for 
                   your command, excluding things inside containers that 
                   are used in the command. For example, if you are carrying 
                   a box and a rope, and the box contains a floppy disk, 
                   typing DROP ALL will drop only the box and the rope; 
                   the floppy disk will remain in the box.^^";

            print "You an use IT and THEM to refer to the last object or 
                   objects that you used in a command. Some examples:^^";

            print "     TAKE THE BOX^";
            print "     OPEN IT^";
            print "     TAKE THE DISK AND THE ROPE^";
            print "     PUT THEM IN THE BOX^^";

            print "You can put multiple commands on a single input line by 
                   separating the commands with periods, commas, the word 
                   THEN, or the word AND. Each command still counts 
                   as a separate turn. For example:^^";

            print "     TAKE THE DISK AND PUT IT IN THE BOX^";
            print "     TAKE BOX. OPEN IT.^";
            print "     UNLOCK THE DOOR WITH THE KEY. OPEN IT, AND THEN GO 
                        NORTH^^";

            print "If the game doesn't understand one of the commands on 
                   the input line, it will tell you what it couldn't 
                   understand, and it will ignore the rest of the commands 
                   on the line.^^";
        ];

Option -> -> "Ambiguous Commands"
   with description [;
            print "If you type a command that leaves out some important 
                   information, the game will try to figure out what you 
                   mean anyway. When the game can be reasonably sure about 
                   what you mean, because only one object would make sense 
                   with the command, the game will make an assumption about 
                   the missing information and act as though you had supplied 
                   it. For example,^^";

            print "     >TIE THE ROPE^";
            print "      (to the hook)^";
            print "      The rope is now tied to the hook. The end of the^";
            print "      rope nearly reaches the floor of the pit below.^^";

            print "If your command is ambiguous enough that the game doesn't 
                   feel safe making assumptions about what you meant, the 
                   game will ask you for more information. You can answer 
                   these questions by typing the missing information. If you 
                   decide you didn't want to bother with the command after 
                   all, you can just type a new command; the game will 
                   ignore the question it asked. For example:^^";

            print "     >UNLOCK THE DOOR^";
            print "      What do you want to unlock the door with?^^";
   
            print "     >THE KEY^";
            print "      Which key do you mean, the gold key, or the silver 
                         key?^^";
   
            print "     >GOLD^";
            print "      The door is now unlocked.^^";
        ];

Option -> -> "Unknown Words"
   with description [;
            print "The game will sometimes use words in its descriptions that 
                   it doesn't understand in your commands. For example, you 
                   may see a description such as, ~The planet's rings are 
                   visible as a thin arc high overhead, glimmering in the 
                   sunlight.~  If the game doesn't know words such as 
                   ~rings,~ you can assume that they're not needed to play 
                   the game; they're in the descriptions simply to make 
                   the story more interesting. For those objects that are 
                   important, the game recognizes many synonyms; if the game 
                   doesn't understand a word you use, or any of its common 
                   synonyms, you are probably trying something that is not 
                   necessary to continue the game.^^";
        ];

Option -> -> "Saving and Restoring"
   with description [;
            print "You can store a snapshot of the game's state in a disk 
                   file at any time. Later, if you want to go back to a 
                   point you were at earlier in the game, you can simply 
                   restore the position from the snapshot in the disk file. 
                   You can save your position as many times as you like, using 
                   different disk files for each position. Saving the game 
                   also allows you to play the game over the course of many 
                   days, without having to start over from scratch each time 
                   you come back to the game.^^

                   To save the game, type SAVE at any prompt. The game will 
                   ask you for the name of a disk file to use to store the 
                   game state. (You will have to specify a filename suitable 
                   for your computer system, and the disk must have enough 
                   space to store the game state. The game will tell you if 
                   the game was not saved properly for some reason.)^^

                   When you wish to restore a game, type RESTORE at the 
                   command prompt. The game will ask you for the name of a 
                   disk file that you specified with a previous SAVE command. 
                   After reading the disk file, the game state will be 
                   restored to exactly the position when you saved it.^^";
        ];

Option -> -> "Special Commands"
   with description [;
           print "The game understands several special commands that you can 
                   use to control the game. You can use these commands at 
                   any prompt.^^";

            print "AGAIN or G: Repeats your last command. If your last input 
                   line was composed of several commands, only the last 
                   command on the line is repeated.^^";

            print "FULL: Shows what you have accomplished and how many 
                   points you have received for each accomplishment.^^";

            print "HELP: Shows this help file.^^";

            print "INVENTORY or I: Shows a list of items you are carrying.^^";

            print "LOOK or L: Shows the full description of your location.^^";

            print "NOTIFY ON or NOTIFY OFF: Tells the game whether you want 
                   to be notified of score changes when they happen. When 
                   the game starts, NOTIFY is turned on, so you will see 
                   a message whenever you do something that changes your 
                   score. If you'd prefer not to see these messages, type 
                   NOTIFY OFF. If you later change your mind, typing 
                   NOTIFY ON will turn notification back on.^^";

            print "QUIT: Stops the game.^^";

            print "RESTART: Starts the game over from the beginning.^^";

            print "RESTORE: Restores a position previously saved with the 
                   SAVE command.^^";

            print "SAVE: Stores the current state of the game in a disk file, 
                   so that you can come back to the same place later 
                   (with the RESTORE command).^^";

            print "SCORE: Shows you your current score, the maximum possible 
                   score, and the number of turns you have taken so far.^^";

            print "TRANSCRIPT (or SCRIPT): Starts writing everything you see 
                   on the screen (your commands and the game's responses) to 
                   a disk file. The game will ask you for a filename to be 
                   used for the transcript. Use the UNSCRIPT command to stop 
                   making the transcript.^^";

            print "UNDO: Take back the last command.^^";

            print "UNSCRIPT (or SCRIPT OFF): Turns off the transcript being 
                   made with the SCRIPT command.^^";

            print "VERSION: Shows you the current version of the game.^^";

            print "WAIT (or Z): Causes game time to pass. When the game is 
                   waiting for you to type a command, no game time passes. 
                   You can use this command to wait for something to happen.^";
        ];

Option -> "About"
   with description
            "~Not Just A Game~ is my first original design. The first piece 
             of interactive fiction I wrote was ~Hugo Zork,~ a port of 
             Infocom's Zork to Hugo. Not very original, but it was fun to do.^^
             
             I started out writing this game in Hugo, but then I decided
             that I wanted to learn Inform. This is the result.^^
             
             If you find any bugs or have any comments, please e-mail
             me at menichel@@64pixi.com.";

Option -> "Credits"
   with description [;
             print "First, of course, credit must go to those fine folks at 
                    Infocom - the original Implementors.^^";

             print "Next, to Graham Nelson, whose Inform language allows us 
                    mere mortals to become Implementors, if only for a little 
                    while.^^";

             print "I'd also like to thank the following people who assisted 
                    with coding this game: Jon Ingold for writing the safe's 
                    code for me, Magnus Olsson for the code I ~borrowed~ from 
                    his game 'Zugzwang', Graham Nelson (again) for the 
                    matchbook code (which I also borrowed, this time from 
                    'Toyshop'), Andrew Plotkin for various bits, Lucian Smith
                    for his beta testing web site, plus all the helpful 
                    people on rec.arts.int-fiction.^^";

             print "The original Reversi source code was written in PocketC
                    by Dave Derrick for handheld PCs. It is available from 
                    the OrbWorks web site (www.orbworks.com/ceres.html). I 
                    modified the source to make the AI avoid corner moves 
                    in the early- and mid-game. This will (hopefully) make 
                    it play a stronger game.^^";

             print "And last (but definitely not least) the beta testers. 
                    In alphabetical order they are: Karalee Coleman, David
                    Glasser, Jen Picagli, Vanessa Falls Pinter, Andy Scarfe, 
                    Daniel Talsky and Joseph Yarrow. Thanks to their efforts,
                    this is a much better game than I had originally designed.
                    Of course, any errors remaining are entirely my own.^^";
        ];

Option -> "The Game of Go"
   with description [;
             print "In case you can't tell, I like Go. I also like Interactive
                    Fiction, so ~Not Just a Game~ is my way of combining the 
                    two.^^";
             
             print "If you've read the in-game booklet, you know a little
                    about the rules of Go. For a better source, check out the
                    US Go Association's web site at www.usgo.org.^^";
             
             print "My descriptions of Go equipment (the boards, stones and 
                    bowls) don't really do them justice - mainly because in 
                    this case, a picture really is worth a thousand words.^^";

             print "While face-to-face Go is the best way to play, there is a 
					thriving online Go community. Many Go servers are available, 
					including:^^";

             print "     Online Go Server (OGS) (https://online-go.com/)^^";
             
             print "     KGS Go Server (https://www.gokgs.com/) and^^";

             print "     The Internet Go Server (igs.joyjoy.net) and^^";
        ];

Option amuse "Have you tried..."
   with description [;
    "... watching television?^
     ... 'listening' in the various rooms?^
     ... dropping objects while in the Cube Rooms?^
     ... using the verbs Xyzzy and Zork?^
     ... counting the pottery shards or the books on the bookshelf?^
     ... burning the Go boards, the bowls or the diary?^
     ... playing the games on the computer?^
     ... looking under the large Go board?^
     ... hitting the cubes?^
     ... turning on the lathe with a cube in the clamp?^
     ... leaving the oven room with a lit match?^
     ... leaving the oven room with the asbestos cup full of molten silver?^
     ... lighting a match in the room with the warning sign?^
     ... looking under the asbestos cup?^
     ... melting the different ingots?^
     ... burning the diary in front of your teacher?^
     ... showing the diary to your teacher?^
     ... asking your teacher about various topics?^
     ... putting the spheres in the wrong depressions more than three times?";
];
