! GQuoteWin  - GWindows quote box widget.
!
!
! GQuoteWin is a widget which emulates the Z-code quote box.
! Like the standard Glulx quote box, it vanishes even unto its
! shadow on the next turn.
! Unlike the Glulx quote box, however, its contents will appear in the
! transcript, and on-screen, the quote will be formatted in the style
! used by Z-code inform.
!
! Unlike Z-code, the GQuoteWin will not crash if the quote is too big
! for the window, but the quote will become steadily uglier as the window
! decreases in size.
!
! The quote window displays the current quote in reverse type, surrounded
! on all sides by a one-character border (unless the blockquote style is
! more exotic)
!
! This window does not need to be given a size when it is created;
! the split type and size are generated by the widget.
! A QuoteWin object should simply be placed in a window pair
! as you would any other popup window.
!
! By default, the QuoteWin appears at the top of the window it is paired
! with. You can change it to appear below, but giving it a split of
! left or right is *not* recommended.
!
! When you should use this:
!  The library's box mechanism should work with GWindows, and
!  you may prefer to use it rather than this library. This library
!  should be used if:
!  - You want more than one quote box
!  - You are using an exotic interface layout in which, say, the main window
!    is too narrow to hold a good-looking quote box
!  - You think the Glulx standard quote box is ugly
!  - You want quote boxes to appear in the transcript.
!  - You want more exotic quote boxes.
!
! Methods:
!  quote(text,[width]) :
!   display a quote in this window. The quote should be a table array
!   (an array whose first entry is the number of elements in it)
!   The elements in the array can be any printable value (anything
!   PrintAnything will print.), so assembling the contents of a quote box
!   "on the fly" is legal.
!   The second parameter is optional, and specifies the length of the longest
!   line of the quote. If it's absent, the quote window will work out the
!   width on its own. This is only used to compute the border around the text
!   box. If 'width' is given, that size will be used, regardless of the actual
!   width. If you give the "correct" width, the only effect will be the saving
!   of a few microseconds of processor time. If the width you give is greater,
!   the box in which the quote appears will be enlarged horizontally.
!   If the width you give is less, the contents will appear to "overhang"
!   the edge of the box (You probably don't ever want to do that)
!   Most of the time, you'll just want to ignore this parameter.
!
! You can also use a quote window to replace the internal 'box' command.
!
! BEFORE including this file, define Quote_GWindow to the quote window
! you wish to use, and add the line:
! Replace Box__Routine;
! The normal 'box' statement will then produce a box quote in the GQuoteWin
! you have specified.
!
! Inherits from: GTransient, TextGrid
!

ifndef GW_GQUOTE_H;
constant GW_GQUOTE_H;
! Shut the compiler up.
ifdef GW_GQUOTE_H;
endif;
include "gtrans";
Class GQuoteWin
 class GTransient TextGrid,
 private
      box_text,
      max_len,
      junk,
 with 
      split_dir winmethod_Above,
      stylehints style_BlockQuote stylehint_ReverseColor 1,
      redraw [ i begin;
                   if (self.split==self.dsplit) return;
                   begin=(self.width-(self.max_len+2))/2;
                   if (begin<0) begin=0;

                   glk_window_clear(self.winid);
                   glk_set_style(style_BlockQuote);
                   for(i=0:i<(self.height-1):i++)
                   {
                    glk_window_move_cursor(self.winid,begin-1,i+1);
                    spaces(self.max_len+2);
                    if (i>0 && i <=self.box_text-->0)
                    {
                     glk_window_move_cursor(self.winid,begin,i+1);
                     PrintAnything(self.box_text-->i);
                    }
                   }
                  glk_set_style(style_Normal);
               ],
        quote [ arr m x i;
#ifdef USE_GCONSOLE;
GConsole.penon();
print "[GQuoteWin]: Creating a quote in window ", (name) self, ".^";
GConsole.penoff();
#endif;

                if (gg_scriptstr)
                {
                 x=glk_stream_get_current();
                 glk_stream_set_current(gg_scriptstr);
                 print (char) '[';
                 for(i=1:i<=arr-->0:i++)
                 {
                  new_line;
                  PrintAnything(arr-->i);
                 }
                print "^]^";
                glk_stream_set_current(x);
                }

                if (m==0)
                for(i=1:i<=arr-->0:i++)
                {
                 x=PrintANyToArray(self.&junk,WORDSIZE,arr-->i);
                 if (x>m) m=x;
                }
                self.max_len=m;
                self.asplit=arr-->0+3;
                self.box_text=arr;
                if (self.split~=self.dsplit) self.deactivate();
                self.activate(1);

               ],
         has abssplit;

ifdef Quote_GWindow;
[ Box__Routine m arr;
  if (Quote_GWindow)
    Quote_GWindow.quote(arr,m);
  else
  {
   glk_set_style(style_BlockQuote);
   for(m=1:m<=arr-->0:m++)
   {
    new_line;
    PrintAnything(arr-->m);
   }
   glk_set_style(style_Normal);
   new_line;
  }
];
endif;
endif;
