! Utilities for Triform
!
! A small collection of miscellaneous routines for the Triform library.
! Everything in this file is public domain.

! This routine was created by Roger Firth and allows your NPCs to be
! called "mr. smith" and so on.

[ BeforeParsing x;
      for (wn=2 : wn<parse->1 : wn++)
          if (buffer->(parse->(4*wn + 1)) == '.' &&
            parse-->(2*wn - 3) == 'dr' or 'mr' or 'mrs' or 'prof' or 'rev' or 'st' &&
            parse-->(2*wn + 1) == 'jekyll' or 'hyde') {
              buffer->(parse->(4*wn + 1)) = ' ';
              x++;
          }
      if (x) @tokenise buffer parse;
];

! This is a ported version of Swap.h, available in the IF Archive.
! It will 'swap' two objects, moving each to the other's parent.
! If one object has no parent, the other object will be removed from
! the object tree unless flag is true.
!
! Note that you must manually set their relationships to their
! new parents.

[ Swap obj1 obj2 flag a b;
  a = parent(obj1);
  b = parent(obj2);
  if (b) Move(obj1, b);
	else if (~~flag) Remove(b);
  if (a) Move(obj2, a);
	else if (~~flag) Remove(a);
];

! If the object is providing illumination for
! the person, this routine will return:
! 0 if no light
! 1 if full light
! 2 if semilight (if GRADUAL_LIGHT defined)
! 3 if demilight (if GRADUAL_LIGHT defined)
! Needs to be tweaked for semivisibility.

[ OffersLight obj person j;

if (~~IsVisible(obj, person)) rfalse;

! First check for full light

if (obj has light) rtrue;

objectloop (j in obj)
	if (OffersLight(j, person) == 1) rtrue;

#Ifdef GRADUAL_LIGHT;

! Now check for semilight

if (obj has semilight) return 2;

objectloop (j in obj)
	if (OffersLight(j, person) == 2) return 2;

! Finally, check for demilight

if (obj has demilight) return 3;

objectloop (j in obj)
	if (OffersLight(j, person) == ) return 3;

#Endif;

rfalse;
];

! Returns the number of light sources the object contains
! which are hidden from view of the person. It does not
! recurse down the object tree.

[ HidesLightSource obj person j w;

#IFDEF GRADUAL_LIGHT;
objectloop (j in obj && j has light or semilight or demilight)
#IFNOT;
objectloop (j in obj && j has light)
#ENDIF;
	{
		if (IsVisible(j, person)) rfalse;
		w++;
	}

return w;

];

! This will take the specified object and set its relationship
! to its parent, if not already defined, and only if there is
! room for it.
!
! Its preference is for on top, then inside, then beneath,
! with behind as the last choice.

[ Place obj j k;
  j = parent(obj);

  if (obj.ontopofparent + obj.insideofparent + obj.beneathparent + obj.behindparent > 0) rfalse;
  if (j ofclass Room || j has animate) rfalse;

  if (j ofclass Container)
	{ if (j.ontop_capacity) {
		k = j.ontop_capacity - CountChildren(j, 4);
		if (k >= obj.volume) { obj.ontopofparent = true; return 4; }
	  }
	  if (j.inside_capacity) {
		k = j.inside_capacity - CountChildren(j, 3)
		if (k >= obj.volume) { obj.insideofparent = true; return 3; }
	  }
	  if (j.beneath_capacity) {
		k = j.beneath_capacity - CountChildren(j, 2);
		if (k >= obj.volume) { obj.beneathparent = true; return 2; }
	  }
	  if (j.behind_capacity) {
		k = j.behind_capacity - CountChildren(j, 1);
		if (k >= obj.volume) { obj.behindparent = true; return 1; }
	  }
	}
   rfalse;
];

#IFDEF COMPLEX_CLOTHING;
! Returns whatever layer the subject item of clothing is at.

[ CheckLayer subject test_layer flag i;
  flag = 0;
  objectloop (i ofclass Wearable && i.worn_by == subject && i.layer  == test_layer)
		{ flag = i; }
  return flag;
];
#ENDIF;

! Returns true if obj2 is the only child of obj1.

[ OnlyChild obj1 obj2 i;
  objectloop (i in obj1) if (i ~= obj2) rfalse;
  rtrue;
];

! Calculates the max_score, counting only positive scores.
! Ignores Achievable tasks.

[ CalculateMaxScore i j;

  objectloop (i provides points)
	if (i.points > 0) j = j + i.points;
];

! A variation of PrintOrRun, lowercasing the first letter and returning nothing

[ PrintLowercased obj prop flag nocaps centred  length i width;

    if (obj ofclass String || prop == 0) {
        PrintToBuffer (StorageForShortName, 160, obj);
        flag = 1;
    }
    else
        if (obj.#prop > WORDSIZE || metaclass(obj.prop) == Routine or String) {
            PrintToBuffer(StorageForShortName, 160, obj, prop);
        }
        else
            if (obj.prop == NULL) rfalse;
            else                  return RunTimeError(2, obj, prop);

    length = StorageForShortName-->0;
    width = ScreenWidth();
    if (centred && length < width)
        spaces ( (width - length) / 2 );
    if (~~nocaps)
        StorageForShortName->WORDSIZE = LowerCase(StorageForShortName->WORDSIZE);

    for (i=WORDSIZE: i<length+WORDSIZE: i++) print (char) StorageForShortName->i;

    if (flag == 0 && obj.#prop == WORDSIZE && metaclass(obj.prop) == String)
        new_line;
    return;
];

! This finds the highest non-Room for which IndirectlyContains(obj, i) would be true.

[ TopParent obj i result;

  i = parent(obj);

  while (~~i ofclass Room) {
		result = i;
		i = parent(i);
	}

  return result;
];

! If converting a very old game to Triform some authors may need this routine.

[ ConTopic w;
    consult_from = wn;
    do w = NextWordStopped();
    until (w == -1 || (w == 'to' && action_to_be == ##Answer));
    wn--;
    consult_words = wn - consult_from;
    if (consult_words == 0) return -1;
    if (action_to_be == ##Answer or ##Ask or ##Tell) {
        w = wn; wn = consult_from; parsed_number = NextWord();
        if (parsed_number == 'the' && consult_words > 1) parsed_number = NextWord();
        wn = w;
        return 1;
    }
    return 0;
];