/* Analizador YACC para el fichero de objetos de Nmesis */

%union
	{
	int entero;
	char cadena[5000];
	}
	
%{
#include <stdio.h>
FILE *fo;
FILE *fh;
FILE *faka;
int marcas[5001];
int maxima;
%}
	
%token TOBJ;
%token TFINOBJ;
%token TMAX;
%token TAKA;
%token TESTADO;
%token TJUGADOR;
%token TLOC;
%token TLIMBO;
%token TMAXJUG;
%token TNOCOGIBLE;

%token <cadena> TCADENA;
%token <entero> TENTERO;
%token <cadena> TID;
%token <cadena> TIDM;

%type <entero> OBJM1 OBJM2 ATRM1;


%%

S : {
    int i;

    for (i=1;i<=5000;i++) marcas[i]=0;
    maxima=0; /* mxima localidad definida */

    fprintf(fo,"/* DEFINICIN DE OBJETOS - GENERADO POR NEMOBJ */\n");
    fprintf(fo,"#include %clocobj.h%c\n",'"','"');
    fprintf(fh,"#include %clocobj.h%c\n",'"','"');
    fprintf(fh,"struct objeto* ptrobj(int n);\n");
    fprintf(fh,"void genobj();\n");
    }
    TMAXJUG '=' TENTERO ';'
    {
    fprintf(fh,"#define MAXJUG %d /* mximo de objetos que pueden llevare */\n",$4);
    }
    TMAX '=' TENTERO ';' SM1 LOBJS
    {
    fprintf(fo,"}\n");
    fprintf(fh,"#define MAXOBJ %d /* nmero total de objetos */\n",$9);
    }

SM1: {
    fprintf(fo,"struct objeto objs[%d];\n",($<entero>-1)+1);
    maxima=$<entero>-1;
    fprintf(faka,"#define MAXOBJ %d /* nmero total de objetos */\n",maxima);
    fprintf(fo,"/* Funcin que devuelve un puntero a un objeto */\n");
    fprintf(fo,"struct objeto* ptrobj(int n)\n{\n");
    fprintf(fo,"return &(objs[n]);\n}\n/* Funcin que define las localidades */\n");
    fprintf(fo,"void genobj()\n{\n");
    };

LOBJS : OBJ ';' LOBJS ;
       | ;
OBJ : TOBJ TENTERO OBJM1 TCADENA ';' OBJM2 LATRIBS TFINOBJ
	{
	marcas[$3]=1;
	}
	
OBJM1 : { $$=$<entero>0;
	  if (marcas[$$]!=0)
	  	{
	  	printf("El objeto %d fue definido ms de una vez.\n",$$);
	  	return 1;
	  	}
	  if ($$>maxima)
	  	{
	  	printf("El objeto %d excede el mximo declarado.\n",$$);
	  	return 1;
	  	}
	  }
OBJM2 : {
	fprintf(fo,"strcpy(objs[%d].descrip,%c%s%c);\n",$<entero>-2,'"',$<cadena>-1,'"');
	fprintf(fo,"objs[%d].cogible=1;\n",$<entero>-2);
	$$=$<entero>-2;

	};

LATRIBS : ATRIB ';' ATRM1 LATRIBS;
	  | ;
ATRM1 : {$$=$<entero>-2; /* para pasar el nmero de objeto actual */ };

ATRIB : TAKA '=' TIDM
	{
	fprintf(faka,"#define %s %d\n",$3,$<entero>0);
	}
	
ATRIB : TNOCOGIBLE ;
	{
	fprintf(fo,"objs[%d].cogible=0;\n",$<entero>0);
	}
	
ATRIB : TESTADO '=' TJUGADOR;
	{
	fprintf(fo,"objs[%d].estado=jugador;\n",$<entero>0);
	};

ATRIB : TESTADO '=' TLIMBO;
	{
	fprintf(fo,"objs[%d].estado=limbo;\n",$<entero>0);
	};
	
ATRIB : TESTADO '=' TLOC;
	{
	fprintf(fo,"objs[%d].estado=localidad;\n",$<entero>0);
	};

ATRIB : TLOC '=' TENTERO;
	{
	fprintf(fo,"objs[%d].loc=%d;\n",$<entero>0,$3);
	};
	


%%

#include "lex.yy.c"

main(int argc,char **argv)
{
int v;
puts("NEMOBJ - Compilador de fichero de objetos de Nmesis ver 1.0");
puts("(C) 2000 Definitive Software");
puts("Por Javier Basilio");
fo=fopen("objdef.c","w");
fh=fopen("objdef.h","w");
faka=fopen("oakas.h","w");
if (!fo)
	{
	puts("No puede crearse el fichero destino.");
	return 1;
	}
v=yyparse();
fclose(fo);
fclose(fh);
fclose(faka);

if (v>0)
	{
	printf("Detenido con error en lnea %d\n",numlinea);
	printf("ltimo token reconocido: %s\n",yytext);
	}
return v;
}


yyerror(char *s)
{
printf("%s\n",s);
}
