
#=================
# Import Libraries
#=================

from PAWS import *
from Universe import *

#==========
# Game data
#==========

Game.Author = "Roger Firth (implemented by Neil Cerutti.)"
Game.Copyright = "1999-2000"
Game.Name = "Cloak of Darkness"
Game.Version = "1"

Game.IntroText = """
    Hurrying through the rainswept November night, you're glad to see the
    bright lights of the Opera House. It's surprising that there aren't more
    people about, but, hey, what do you expect from a cheap demo game? ~n ~n
    """

#-------------------------------------------
# Game Specific Engine Replacement Functions
#-------------------------------------------

def CloakUserSetUpGame():
    Global.Production = TRUE
    Global.Player.StartingLocation = Foyer
    Global.CurrentActor = Global.Player

def CloakPostGameWrapUp():
    if not Bar.Visited: return

    if Sawdust.TrampleState < 2:
        Say("~n ~n *** You have won. *** ~n ~n ")
    else:
        Say("~n ~n *** You have lost. *** ~n ~n ")

Engine.UserSetUpGame = CloakUserSetUpGame
Engine.PostGameWrapUp = CloakPostGameWrapUp

#==============
# Rooms In Game
#==============

#-------------------------------------------
# Class Cloak Room (Blueprint For All Rooms)
#-------------------------------------------

class ClassCloakRoom(ServiceDictDescription, ClassRoom):

    def SetMyProperties(self):
        ClassRoom.SetMyProperties(self)
        ServiceDictDescription.SetServiceProperties(self)
        self.IsLit = TRUE

    def FeelDesc(self): return ClassRoom.FeelDesc(self)

#---------------
# Northern Foyer
#---------------

Foyer = ClassCloakRoom()
Foyer.NamePhrase = "Foyer of the Opera House"

Foyer.SetDesc("L","""
    You are standing in a spacious hall, splendidly decorated in red and
    gold, with glittering chandeliers overhead. The entrance from the
    street is to the north, and there are doorways south and west.
    """)

#-----------
# Cloak Room
#-----------

Cloakroom = ClassCloakRoom()
Cloakroom.NamePhrase = "Cloakroom"

Cloakroom.SetDesc("L","""
    The walls of this small room were clearly once lined with hooks, though
    now only one remains. The exit is a door to the east.
    """)

#--------
# The Bar
#--------

class ClassBar(ClassCloakRoom):
    def SetMyProperties(self):
        ClassCloakRoom.SetMyProperties(self)

    def SetIsLit(self, bool):
        """ Allows for easy changing of the Bar's IsLit property in CBEs.
        A routine called in a CBE must return a string object or another
        CBE. """
        self.IsLit = bool
        return ""

Bar = ClassBar()
Bar.NamePhrase = "Foyer Bar"
Bar.IsLit = FALSE

Bar.SetDesc("L","""
    The bar, much rougher than you expected after the opulence of the
    northern foyer, is completely empty. There seems to be some sort of
    message scrawled in the sawdust on the floor.
    """)

#--------
# Nowhere
#--------

# This room basically refuses entry and increments the trampled state of the
# sawdust message.

class ClassNowhere(ClassCloakRoom):
    def SetMyProperties(self):
        ClassCloakRoom.SetMyProperties(self)

    def Enter(self, Object):
        Say("Blundering around in the dark isn't a good idea.")
        Sawdust.TrampleState = Sawdust.TrampleState + 2
        return FAILURE

Nowhere = ClassNowhere()

#================
# Objects In Game
#================

#-----------------
# The Cloak Itself
#-----------------

class ClassCloak(ClassItem):
    def SetMyProperties(self):
        ClassItem.SetMyProperties(self)

    def Drop(self, Multiple=FALSE):
        """ You can't put the cloak anywhere but on the hook. """
        Say("This isn't the best place to leave a smart cloak lying around."
            + " ~n")
        return FAILURE

Cloak = ClassCloak("cloak","velvet,black,satin,dark,handsome")
Cloak.StartingLocation = Global.Player
Cloak.Bulk = 1
Cloak.Weight = 10

Cloak.SetDesc("L", """
                   A handsome cloak, of velvet trimmed with satin, and
                   slightly spattered with raindrops. Its blackness is so
                   deep that it almost seems to suck light from the room.
                   """)

Cloak.SetDesc("Take", "{Bar.SetIsLit(FALSE)}Taken.")

# The player won't be able to interact with the Cloak until it's
# remembered. TQ falls for this bug when the player received the Mandala
# but doesn't remember it, and hence can't do anything with it.

Global.Player.Memorize(Cloak)

#---------------
# The Brass Hook
#---------------

class ClassHook(ClassScenery,ServiceContainOn):
    def SetMyProperties(self):
        ClassScenery.SetMyProperties(self)
        ServiceContainOn.SetMyProperties(self)

    def Enter(self, Object):
        """ Turn on the light in the Foyer Bar when the player puts the
        cloak on the hook. """
        if Object == Cloak:
            Bar.SetIsLit(TRUE)
        return ClassScenery.Enter(self, Object)


Hook = ClassHook("hook,peg","small,brass")
Hook.MaxBulk = 1
Hook.MaxWeight = 10
Hook.StartingLocation = Cloakroom

Hook.SetDesc("Take", "The hook is screwed to the wall.")

Hook.SetDesc("L", """
    It's just a small brass hook,
    {Choose (Cloak in Self().Contents,
        " with a cloak hanging on it.",
        " screwed to the wall.")}
    """)

#--------------------
# The Sawdust Message
#--------------------

class ClassSawdust(ClassScenery):
    def SetMyProperties(self):
        ClassScenery.SetMyProperties(self)
        self.TrampleState = 0

    def ReadDesc(self):
        Global.GameState = FINISHED
        if Sawdust.TrampleState < 2:
            return "The message, neatly marked in the sawdust, reads..."
        else:
            return """The message has been carelessly trampled, making it
                  difficult to read. You can just distinguish the
                  words..."""

Sawdust = ClassSawdust("message,sawdust,floor")
Sawdust.SetDesc("L", "{Self().ReadDesc()}")
Sawdust.StartingLocation = Bar

#--------
# The map
#--------

Foyer.Map = {North: """
                    You've only just arrived and besides, the weather
                    outside seems to be getting worse.
                    """,
             South: Bar,
             West: Cloakroom}

Cloakroom.Map = {East: Foyer}

Bar.Map = {North:      Foyer,
           Northeast:  Nowhere,
           East:       Nowhere,
           Southeast:  Nowhere,
           South:      Nowhere,
           Southwest:  Nowhere,
           West:       Nowhere,
           Northwest:  Nowhere,
           Up:         Nowhere,
           Down:       Nowhere,
           Upstream:   Nowhere,
           Downstream: Nowhere,
           In:         Nowhere,
           Out:        Nowhere}
