/*
 * Copyright (C) 1998 Jose Luis Cebrian Pague
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#include <stdio.h>

#include "ss.h"

/* --- PNG --- */

#include <png.h>

int ss_render_save_png (char *filename)
{
    FILE 	* file ;
    png_structp	png_ptr ;
    png_infop	info_ptr ;
    png_uint_32 k ;
    png_bytep 	row_pointers[1024];
    png_colorp	palette ;

    if (ss_render_buffer == 0 || ss_render_buffer_size == 0)
	return 0 ;

    if (ss_render_mode != SS_RENDER_8BPP)
	return 0 ;

    file = fopen (filename, "wb") ;
    if (file == NULL)
	return 0 ;

    /* PNG Library Initialization */

    png_ptr = png_create_write_struct (PNG_LIBPNG_VER_STRING, 0, 0, 0) ;
    if (png_ptr == NULL)
	return 0 ;

    info_ptr = png_create_info_struct (png_ptr) ;
    if (info_ptr == NULL)
	return 0 ;

    if (setjmp (png_ptr->jmpbuf))
    {
	fclose (file) ;
	png_destroy_write_struct (&png_ptr, NULL) ;
	return 0 ;
    }

    png_init_io (png_ptr, file) ;

    /* Writing image info */

    png_set_IHDR (png_ptr, info_ptr, 
	    ss_render_buffer_width,
	    ss_render_buffer_height,
	    8,
	    PNG_COLOR_TYPE_PALETTE,
	    PNG_INTERLACE_NONE,
	    PNG_COMPRESSION_TYPE_BASE, 
	    PNG_FILTER_TYPE_BASE);

    /* Writting image */

    palette = (png_colorp)png_malloc(png_ptr, 256 * sizeof(png_color)) ;
    for (k = 0 ; k < 256 ; k++)
    {
	palette[k].red = ss_render_palette[k].r ;
	palette[k].green = ss_render_palette[k].g ;
	palette[k].blue = ss_render_palette[k].b ;
    }
    png_set_PLTE (png_ptr, info_ptr, palette, 256) ;

    png_write_info (png_ptr, info_ptr) ;
    for (k = 0 ; k < ss_render_buffer_height ; k++)
	row_pointers[k] = ss_render_buffer + ss_render_buffer_width * k ;
    png_write_image (png_ptr, row_pointers) ;
    png_write_end   (png_ptr, info_ptr) ;

    free (info_ptr->palette) ;
    fclose (file) ;
    return 1 ;
}

/* --- GIF --- */

#ifdef LIBGIF

#include <gif_lib.h>

int ss_render_save_gif (char *filename)
{
    GifFileType * 	file ;
    ColorMapObject 	cmap ;
    GifColorType	colors[256] ;
    int			i ;

    cmap.ColorCount = 256 ;
    cmap.BitsPerPixel = 8 ;
    cmap.Colors = colors  ;
    for (i = 0 ; i < 256 ; i++)
    {
	colors[i].Red = ss_render_palette[i].r ;
	colors[i].Green = ss_render_palette[i].g ;
	colors[i].Blue = ss_render_palette[i].b ;
    }

    if (ss_render_buffer == 0 || ss_render_buffer_size == 0)
	return 0 ;

    if (ss_render_mode != SS_RENDER_8BPP)
	return 0 ;

    file = EGifOpenFileName (filename, 0) ;
    EGifPutScreenDesc (file, ss_render_buffer_width, 
	    ss_render_buffer_height, 75, 0, &cmap) ;
    EGifPutImageDesc  (file, 0, 0, ss_render_buffer_width,
	    ss_render_buffer_height, 0, &cmap) ;

    for (i = 0 ; i < ss_render_buffer_height ; i++)
    {
	EGifPutLine (file, ss_render_buffer + ss_render_buffer_width*i, 
		ss_render_buffer_width) ;
    }
    EGifCloseFile (file) ;

    return 1 ;
}

#endif

/* --- Hicolor .ppm --- */

int ss_render_save_ppm (char *filename)
{
    int n, total ;
    unsigned char *ptr ;

    FILE *file ;

    if (ss_render_buffer == 0 || ss_render_buffer_size == 0)
	return 0 ;

    file = fopen (filename, "w") ;
    if (!file)
	return 0 ;

    /* Magic "P3", dimensions, max. color value */
    fprintf (file, "P3\n%d %d\n255\n", 
	    ss_render_buffer_width, ss_render_buffer_height) ;

    switch (ss_render_mode)
      {
	case SS_RENDER_24BPP:
	    ptr = ss_render_buffer ;
	    total = ss_render_buffer_width * ss_render_buffer_height * 3 ;
	    for (n = 0 ; n < total ; n++)
	      {
		fprintf (file, " %d", *ptr++) ;
		/* No line should be > 70 characters */
		if (!((n+1)%20))
		    fprintf (file, "\n") ;
	      }
	    break ;

	case SS_RENDER_8BPP:
	    ptr = ss_render_buffer ;
	    total = ss_render_buffer_width * ss_render_buffer_height ;
	    for (n = 0 ; n < total ; n++)
	      {
		fprintf  (file, " %d", ss_render_palette[*ptr  ].r) ;
		fprintf  (file, " %d", ss_render_palette[*ptr  ].g) ;
		fprintf  (file, " %d", ss_render_palette[*ptr++].b) ;
		if (!((n+1)%6))
		    fprintf (file, "\n") ;
	      }
	    break ;
      }

    fclose (file) ;
    return 1 ;
}

