/*
 * 		sample.t				version 1.0
 *		by Kevin Forchione		( Lysseus@msn.com )
 *		Copyright (c) 1999. 	All Rights Reserved.
 *
 *  	This file requires HTML TADS 2.2.6 or later.
 *
 *  	You may modify and use this file in any way you want, provided that
 *		if you redistribute modified copies of this file in source form, the
 *   	copies must include the original copyright notice (including this
 *   	paragraph), and must be clearly marked as modified from the original
 *   	version.
 *
 *------------------------------------------------------------------------------
 *		Revision History
 *------------------------------------------------------------------------------
 *		99-03-16:	Creation.
 */

// Since this is an HTML TADS game, let's use the HTML status line
#define USE_HTML_STATUS

#include    <adv.t>     	// Adventure Library
#include	<std.t>			// Standard definitions required by the system & library
#include	<dvehicle.t>	// directed-vehicle class file

startroom: room
	sdesc = "Foyer"
	ldesc = "The foyer of the magnificent Museum of TADS. A flight of stairs sweeps upward
		to the second floor, and corridors fan out on this level. These run:\n\tnorth 
		into Room 1\n\tsouth along Room 2\n\teast to Room 3\n\twest to Room 4\n\tne to Room 5
		\n\tnw to Room 6\n\tse to Room 7\n\tsw to Room 8\n\t and a ladder leads down into the
		basement.\n\tThe Museum exit is out.\b"
	north = room1
	south = room2
	east = room3
	west = room4
	ne = room5
	nw = room6
	se = room7
	sw = room8
	up = secondFloor
	down = basement
	out = road
;

/*
 *	A friendly companion you can take with you and order around.
 */
robbie: Actor
	location = startroom
	sdesc = "Robbie"
	adesc = "Robbie"
	thedesc = "Robbie"
	noun = 'robbie'
	actorDesc = "Robbie is here, waiting to obey you."
	actorAction( v, d, p, i ) = {}
;

chair: chairitem
	location = startroom
	sdesc = "fixed chair"
	noun = 'chair'
;

redCar: dvehicle
	location = startroom
	sdesc = "little red car"
	noun = 'car'
	adjective = 'little' 'red'
	ldesc = 
	{
		"Large enough to sit inside. Among the controls is a prominent
		on/off switch. The number plate is KAR 1. The car is 
		<<self.isActive ? "on" : "off">>. ";
		if ( robbie.isIn( self ) )
		{
			"\b"; robbie.actorDesc; "\b";
		}
	}
	doTurnon -> carSwitch
	doTurnoff -> carSwitch
	/*
	 *	This method should return true if the direction is valid for the
	 *	vehicle; otherwise it should return nil.
	 */
	validVehDir( v, l ) =
	{
		if ( v = uVerb or v = dVerb )
			return nil;
		else
			pass validVehDir;
	}
	goMessage( d, l ) = 
	{
		"Brmm! Brmm! ";
		if ( not parserGetMe.isIn( self ) )
		{
			caps(); "<<self.thedesc>> moves off to the "; say( d ); 
		}
	}
	cantgoMessage = "You can't go that way."
	inactiveMessage = "(The ignition is off at the moment.)"
;

carSwitch: switchItem
	location = redCar
	sdesc = "large on/off switch"
	noun = 'switch'
	doTurnon( actor ) =
	{
		redCar.isActive := true;
		pass doTurnon;
	}
	doTurnoff( actor ) =
	{
		redCar.isActive := nil;
		pass doTurnoff;
	}
;

smallNote: readable
	location = redCar
	sdesc = "small note"
	noun = 'note'
	adjective = 'small'
	ldesc = "!!!! FROBOZ MAGIC CAR COMPANY !!!!\bHello
		Driver!\bInstructions for use:\b\tTURN ON THE CAR and off you
		go!\b\tWarranty:\bThis car is guaranteed against all defects for a
		period of 76 milliseconds from date of purchase or until used, whichever
		comes first.\b\bGood Luck!"
;


room1: room
	sdesc = "Long Corridor"
	ldesc = "You are at the south end of a north-south corridor. At 
		the north end is a massive oak door, which is 
		<<oakDoor1.isopen ? "open" : "closed">>. "
	north = oakDoor1
	south = startroom
;

oakDoor1: doorway
	location = room1
	sdesc = "oaken door"
	noun = 'door'
	adjective = 'oaken' 'oak'
	doordest = room1a
	otherside = oakDoor2
;

sign: readable
	location = room1
	sdesc = "sign"
	noun = 'sign'
	ldesc = "You must open the door manually before going further if you are in
		the car, othewise it will open automatically when you pass through on
		foot."
;

room1a: room
	sdesc = "The Green Room"
	ldesc = "A room whose walls are painted an emerald green. An oaken door lies
		to the south, and is currently <<oakDoor2.isopen ? "open" : "closed">>."
	south = oakDoor2
;

oakDoor2: doorway
	location = room1a
	sdesc = "oaken door"
	noun = 'door'
	adjective = 'oaken' 'oak'
	doordest = room1
	otherside = oakDoor2
;	

room2: room
	sdesc = "Room 2"
	ldesc = "Just another boring room. The exit is north."
	north = startroom
;

room3: room
	sdesc = "Room 3"
	ldesc = "Just another boring room. The exit is west."
	west = startroom
;

room4: room
	sdesc = "Room 4"
	ldesc = "Just another boring room. The exit is east."
	east = startroom
;

room5: room
	sdesc = "Room 5"
	ldesc = "Just another boring room. The exit is southwest."
	sw = startroom
;

room6: room
	sdesc = "Room 6"
	ldesc = "Just another boring room. The exit is southeast."
	se = startroom
;

room7: room
	sdesc = "Room 7"
	ldesc = "Just another boring room. The exit is northwest."
	nw = startroom
;

room8: room
	sdesc = "Room 8"
	ldesc = "Just another boring room. The exit is northeast."
	ne = startroom
;

basement: room
	sdesc = "Museum Basement"
	ldesc = "Just another boring room. The exit is up."
	up = startroom
;

secondFloor: room
	sdesc = "Second Floor"
	ldesc = "Just another boring room. The exit is down."
	down = startroom
;

road: room
	sdesc = "Road"
	ldesc = "A paved road leading nowhere. The only exit is into
		the Museum."
	in = startroom
;

/*------------------------------------------------------------------------------
 *	ADV.T MODIFICATIONS
 *----------------------------------------------------------------------------*/

modify thing
    isReachable(actor) =
    {
        local loc;
        /* make sure the actor's location has a reachable list */
        if (actor.location = nil or actor.location.reachable = nil)
            return nil;
          
       	/* the object is visible to the actor and is an actor itself */
        if (self.isactor and self.isVisible( actor ) )
        	return true;

        /* if the object is in the room's 'reachable' list, it's reachable */
        if (find(actor.location.reachable, self) <> nil)
            return true;

        /*
         *   If the object's container's contents are reachable, and the
         *   container is reachable, the object is reachable.
         */
        loc := self.location;
        if (find(actor.location.reachable, self) <> nil)
            return true;
        if (loc = nil)
            return nil;
        if (loc = actor or loc = actor.location)
            return true;
        if (loc.contentsReachable)
            return loc.isReachable(actor);
        return nil;
    }
;

/* 
 *	Allowing Actors to reach things in chairs the way you can for other
 *	nestedrooms.
 */
modify chairitem
    canReachContents = true
;

/*------------------------------------------------------------------------------
 *	STD.T MODIFICATIONS
 *----------------------------------------------------------------------------*/

replace commonInit: function 
{
	"\H+";
}
;

/*
 *   showcontcont:  list the contents of the object, plus the contents of
 *   an fixeditem's contained by the object.  A complete sentence is shown.
 *   This is an internal routine used by listcontcont and listfixedcontcont.
 *
 *	This function has been modified to use itemXcnt() and listXcnt() to
 *	represent Actors in the listings.
 */
replace showcontcont: function(obj)
{
    if (itemXcnt(obj.contents))
    {
        if (obj.issurface)
        {
            if (not obj.isqsurface)
            {
                "Sitting on "; obj.thedesc;" is "; listXcont(obj);
                ". ";
            }
        }
        else if (obj.contentsVisible and not obj.isqcontainer)
        {
            caps();
            obj.thedesc; " seem";
            if (!obj.isThem) "s";
            " to contain ";
            listXcont(obj);
            ". ";
        }
    }
    if (obj.contentsVisible and not obj.isqcontainer)
        listfixedcontcont(obj);
}

/*
 *  itemXcnt: function(list)
 *
 *  Returns a count of the "listable" and "Actor" objects in list.  An
 *  object is listable (that is, it shows up in a room's description)
 *  if its isListed property is true. An object is considered an Actor
 *	if its isactor property is true. This function is
 *  useful for determining how many objects (if any) will be listed
 *  in a nestedroom's description.  Indistinguishable items are counted as
 *  a single item (two items are indistinguishable if they both have
 *  the same immediate superclass, and their isEquivalent properties
 *  are both true.
 */
itemXcnt: function(list)
{
    local cnt, tot, i, obj, j;

    tot := length(list);
    for (i := 1, cnt := 0 ; i <= tot ; ++i)
    {
        /* only consider this item if it's to be listed */
        obj := list[i];
        if (obj.isListed or obj.isactor)
        {
            /*
             *   see if there are other equivalent items later in the
             *   list - if so, don't count it (this ensures that each such
             *   item is counted only once, since only the last such item
             *   in the list will be counted) 
             */
            if (obj.isEquivalent)
            {
                local sc;
                
                sc := firstsc(obj);
                for (j := i + 1 ; j <= tot ; ++j)
                {
                    if (isIndistinguishable(obj, list[j]))
                        goto skip_this_item;
                }
            }
            
            /* count this item */
            ++cnt;
            
        skip_this_item: ;
        }
    }
    return cnt;
}

/*
 *  listXcont: function(obj)
 *
 *  This function displays the contents of an object, separated by
 *  commas.  The thedesc properties of the contents are used.
 *  It is up to the caller to provide the introduction to the list
 *  (usually something to the effect of "The box contains" is
 *  displayed before calling listcont) and finishing the
 *  sentence (usually by displaying a period).  An object is listed
 *  only if either its isListed property is true or its isactor property 
 *	is true.  If there are multiple indistinguishable items in the list, 
 *	the items are listed only once (with the number of the items).
 */
listXcont: function(obj)
{
    local i, count, tot, list, cur, disptot, prefix_count;

    list := obj.contents;
    tot := length(list);
    count := 0;
    disptot := itemXcnt(list);
    for (i := 1 ; i <= tot ; ++i)
    {
        cur := list[i];
        if (cur.isListed or cur.isactor)
        {
            /* presume there is only one such object */
            prefix_count := 1;
            
            /*
             *   if this is one of more than one equivalent items, list it
             *   only if it's the first one, and show the number of such
             *   items along with the first one 
             */
            if (cur.isEquivalent)
            {
                local before, after;
                local j;
                local sc;
        
                sc := firstsc(cur);
                for (before := after := 0, j := 1 ; j <= tot ; ++j)
                {
                    if (isIndistinguishable(cur, list[j]))
                    {
                        if (j < i)
                        {
                            /*
                             *   note that objects precede this one, and
                             *   then look no further, since we're just
                             *   going to skip this item anyway
                             */
                            ++before;
                            break;
                        }
                        else
                            ++after;
                    }
                }
                
                /*
                 *   if there are multiple such objects, and this is the
                 *   first such object, list it with the count prefixed;
                 *   if there are multiple and this isn't the first one,
                 *   skip it; otherwise, go on as normal 
                 */
                if (before = 0)
                    prefix_count := after;
                else
                    continue;
            }
            
            if (count > 0)
            {
                if (count+1 < disptot)
                    ", ";
                else if (count = 1)
                    " and ";
                else
                    ", and ";
            }
            
            /* list the object, along with the number of such items */
            if (prefix_count = 1)
                cur.adesc;
            else
            {
                sayPrefixCount(prefix_count); " ";
                cur.pluraldesc;
            }
            
            /* show any additional information about the item */
            if (cur.isworn)
                " (being worn)";
            if (cur.islamp and cur.islit)
                " (providing light)";
            count := count + 1;
        }
    }
}
;
