/*
;	MOIST SOURCE CODE V1.06
;	Copyright (c) 1996, 1999 Scarlet Herring (scarlet_herring@yahoo.com).
;
;	Parts of this file:
; 	Copyright (c) 1989, 1991 by Michael J. Roberts. All Rights Reserved.
;	
;	THIS SOURCE CODE IS MEANT FOR STUDYING PURPOSES ONLY. YOU ARE NOT 
;	ALLOWED TO CHANGE THE GAME AND RELEASE YOUR OWN VERSION OF IT.
;
;	Since this file is part of an adult text adventure, you are not
;	allowed to use it if you are underaged, and if you are easily
;	offended, you also best leave it alone.
;
;	Please read the enclosed READSRC.TXT for general comments.
*/

/* 	STDD.T
;
;	This file contains game-specific functions which should be enclosed in every game written
;	with TADS. It is enclosed in the TADS package as STD.T. These functions should be adapted
;	for each game, and therefore I have copied STD.T to STDD.T, and have made the necessary 
;	changes. I have removed all of the original comments from the file.
*/

die: function;
scoreRank: function;
situationRank: function;
init: function;
terminate: function;
pardon: function;
darkTravel: function;

/*
;   The die() function is called when the player dies. This doesn't happen in
;	Moist, but I left the original function in.
*/
die: function
{
    "\b*** You have died ***\b";
    scoreRank();
    "\bYou may restore a saved game, start over, take back
       the last move, or quit.\n";
    while ( 1 )
    {
        local resp;

        "\nPlease enter RESTORE, RESTART, UNDO, or QUIT: >";
        resp := upper(input());
        if ( resp = 'RESTORE' )
        {
            resp := askfile( 'File to restore' );
            if ( resp = nil ) "Restore failed. ";
            else if ( restore( resp )) "Restore failed. ";
            else
            {
                setscore( global.score, global.turnsofar );
                abort;
            }
        }
        else if ( resp = 'RESTART' )
        {
            setscore( 0, 0 );
            restart();
        }
        else if ( resp = 'UNDO' )
        {
            if (undo())
            {
                "(Undoing one command)\b";
                Me.location.lookAround(true);
                setscore(global.score, global.turnsofar);
                abort;
            }
            else
                "Sorry, no undo information is available. ";
        }
        else if ( resp = 'QUIT' )
        {
            terminate();
            quit();
            abort;
        }
    }
}

/*
;	The scoreRank() function displays how well the player is doing. I not only 
;	display the score, but also how the player is handling the girls.
*/
scoreRank: function
{
    "You have achieved a score of "; say( global.score );
    " point";
    if (global.score <> 1)
        "s";
    " out of a possible 15 in "; say( global.turnsofar ); " turn";
    if (global.turnsofar <> 1)
        "s";
    ". ";
    if  (Morghana.orgasms > 0)
        "You got Morghana to have an orgasm. Congratulations! ";
    else if  (Kim.orgasms < 1 and Ilsa.orgasms < 1 and Fanny.orgasms < 1)
        "None of the girls has recommended you to the queen. You should
        try harder! ";
    else
    {
        "You are recommended to the queen by";
        if  (Kim.orgasms >= 1)
        {
            " Kim";
            if  (Ilsa.orgasms < 1 and Fanny.orgasms < 1)
                ". ";
            else
                " and";
        }
        if  (Ilsa.orgasms >= 1)
        {
            " Ilsa";
            if  (Fanny.orgasms < 1)
                ". ";
            else
                " and";
        }
        if  (Fanny.orgasms >= 1)
            " Fanny. ";
        "You're progressing, but you still have some work to do. ";
    }
}

/*
;	This function displays several of the game states, but only in debug-mode.
;	Normally a player won't see these stats.
*/
situationRank: function
{
    if  (global.debugon)
    {
        "\b\nYour location is "; Me.location.thedesc; ". Your excitement
        level is "; say( Me.excitement ); " and you need to get to
        level "; say( Me.excitement_needed ); ". ";
        "\nFanny's location is "; Fanny.location.thedesc; ". Her excitement
        level is "; say( Fanny.excitement ); " and she needs to get to
        level "; say( Fanny.excitement_needed ); ". ";
        if  (rope.location = Fanny)
            "She is tied down with the rope. ";
        if  (Fanny.serving > 0)
        {
            "At the moment, she is in serving state "; say( Fanny.serving );
            ". ";
        }
        else
        {
            "The serve counter is now "; say( global.servecounter ); ". ";
        }
        "\nKim's location is "; Kim.location.thedesc; ". Her excitement
        level is "; say( Kim.excitement ); " and she needs to get to
        level "; say( Kim.excitement_needed ); ". ";
        if  (rope.location = Kim)
            "She is tied down with the rope. ";
        "\nIlsa's location is "; Ilsa.location.thedesc; ". Her excitement
        level is "; say( Ilsa.excitement ); " and she needs to get to
        level "; say( Ilsa.excitement_needed ); ". ";
        if  (Ilsa.tied)
            "She is tied down to the rack. ";
        if  (Ilsa.drugged > 0)
        {
            "She will be asleep for "; say( Ilsa.drugged ); " more turn";
            if  (Ilsa.drugged > 1)
                "s";
            ". ";
        }
        "\nMorghana's location is "; Morghana.location.thedesc; ". Her
        excitement level is "; say( Morghana.excitement ); " and she needs to
        get to level "; say( Morghana.excitement_needed ); ". ";
        if  (rope.location = Morghana)
            "She is tied down to the bed with the rope. ";
        if  (dildo.location <> Me)
        {
            "\nThe location of the dildo is "; dildo.location.thedesc; ". ";
        }
        if  (vibrator.location <> Me)
        {
            "\nThe location of the vibrator is ";
            if  (vibrator.location = nil)
                "the teddy bear";
            else
                vibrator.location.thedesc;
            ". ";
            if  (vibrator.activated)
                "It is turned on. ";
        }
    }
}

 /*
 ;	As you can see, I have removed all the contents of the preinit function. The 
 ;	reason is that I found that there was a bug in the TADS version which I
 ;	used to write Moist, which I thought I could solve by changing the preinit 
 ;	function. While I did solve that particular problem, I introduced a new 
 ;	one, which was discovered after I released the game. In the end, I decided
 ;	to remove the entire contents from this function, and hardcode the lists
 ;	which are filled here, in particular, the lamplist (see the global object).
 ;	This is a Very Bad Thing to do, and normally, you shouldn't worry about 
 ;	the contents of the preinit function. Whatever the problem was in the TADS 
 ;	version I used, it has been resolved now. 
 */
preinit: function
{
}

/*
;   The terminate() function is called just before the game ends.
*/
terminate: function
{
    "Goodbye. ";
}

/*
 ;   The pardon() function is called any time the player enters a blank
 ;   line. I have left in the original function.
*/
pardon: function
{
    "I beg your pardon? ";
}

/*
;	The original numObj and strObj.
*/
numObj: basicNumObj;
strObj: basicStrObj; 

/*
;	I have added a few of my own global parameters to the global object.
*/
global: object
    turnsofar = 0 // No turns have transpired so far.
    verbose = nil // We are currently in TERSE mode.
    lamplist = [dick,chandelier,lighter,torch] // list of all known light providers 
    	// in the game. As you can see, I hard-fill the list here to get around 
    	// problems I had with the preinit function. This also means that when the 
    	// game is changed and a new light-provider is added, it should get a place
        // in this list.
    score = 0 // Current score.
    earthquake = 11 // Turns to the earthquake.
    debugon = nil // Debugmode is off.
    enigmaon = true // Hint encryption is on.
    gamenumber = 0 // This is the number of the 21 hand you are currently 
    	// playing with Kim.
    color = 0 // This is the current card-color offset used in 21.
    face = 0 // This is the current face-offset used in 21.
    nearilsa = nil // This is a very bad solution to a problem I had with 
    	// Ilsa. The problem was that I had to know if you were near Ilsa
    	// in the previous move. If this is nil, you weren't near her in
    	// the previous move. The very least, this should have been a
    	// property of the Ilsa-actor, not a global property.
    rapedbyilsa = 0 // Indicates how many turns ago you were raped by Ilsa.
    servecounter = 0 // Fanny's serve-counter, which indicates in what
    	// serve-phase she currently is. Should have been a property of the
    	// Fanny object.
    glitter = 0 // When you are in the dining room, the glitter-counter is
    	// set to 3. It counts down towards zero, and when it gets to zero,
    	// you get a message saying that you see something glittering on
    	// the chandelier. Something like this is better solved with a
    	// fuse, but it works.
    randhint = 0 // Number of the last random hint shown.
    notifie = true // I got the notify command from the IF-archive. 
		// It was written by Gerry Kevin Wilson.
    	// This property and the next are part of that command.
    warned = nil // Part of the notify command.     
;

/*
;	"Me" is the player's actor.
 */
Me: basicMe
    thedesc = "you"
    bet = nil // Holds the bet placed by the player.
;

/*
;	This is the default darkTravel function from STD.T.
*/
darkTravel: function
{
    "You stumble around in the dark, and don't get anywhere. ";
}

