/*
 * The Legend Lives!
 *
 * Executable and source code are
 *
 *                 Copyright (C) 1995 by David M. Baggett
 *
 * All rights reserved, except as follows:
 * 
 *    Electronic redistribution is permitted, but only if not for profit.
 *    Specifically, you may provide copies in electronic form ONLY if you
 *    do not charge anything beyond the distribution media cost AND if you
 *    do not alter the source code in any way.
 *
 * Note that the author reserves all rights to derivative works and
 * products.  This includes ports and enhanced versions.  The author will
 * typically grant permission for these when asked, but this will be
 * dealt with on a case by case basis only.
 *
 */

//
// Init functions
//
replace userpreinit: function
{
	local	o;

	for (o := firstobj(); o <> nil; o := nextobj(o)) {
		// matter movers
                if (isclass(o, mattermover))
                        global.moverlist += o;
	}

	// init hints
	inithints();
}

replace userinit: function
{
	local o, r, i;

	//
	// Print the intro unless we're restarting.
	//
	if (global.restarting = nil) {
		"\b\b\b\b\b\b\b\b";
		intro();
	}
	
	//
	// NOTE: We have to set global.lastactor explicitly here,
	// because no command has been executed yet.  (Normally,
	// global.lastactor is set in the Verb disamiguation code.)
	//
	global.lastactor := Me;

	//
	// Note funny syntax:
	//
	Me.location.enter(Me);

	//
	//-------------------------------------------------------------------
	//

	//
	// Perform consitency checks if we're in playtesting mode.	
	//
	if (global.playtesting) {
/*
		r := 0;
		i := 0;
		for (o := firstobj(); o <> nil; o := nextobj(o)) {
			if (isclass(o, Room) and not isclass(o, Nestedroom)) {
				r++;
			}
			if (isclass(o, Item)) {
				i++;
			}
			if (isclass(o, floatingdecoration) and (o.loclist = nil or o.loclist = []))
				"WARNING: floatingdecoration \"<<o.sdesc>>\"
				has nil location\n";
			else if (isclass(o, Decoration) and o.location = nil)
				"WARNING: Decoration \"<<o.sdesc>>\"
				has nil location\n";
		}

		"\b";
		"Rooms: <<r>>\n";
		"Items: <<i>>\n";
*/
	}
	global.colorspace := 'Burnt Sienna';
	global.system := 'Val';
	global.planet := 'Frost';

	notify(Me, &normalcolor, 0);
	notify(TV, &createpatron, 0);
	notify(TVguard, &travel, 0);
	notify(TVtoys, &comeback, 0);

	// make the critters talk
	notify(Zdybel, &talk, 0);

#ifndef	DEMO
	notify(Dylbez, &talk, 0);
#endif
}
