#charset "us-ascii"
#include "tads.h"
#include "tok.h"
#include "adv3.h"
#include "en_us.h"
#include <vector.h>
#include <dict.h>
#include <gramprod.h>
#include <strcomp.h>

// ===================================================================
// TABLE OF CONTENTS
// ===================================================================

//  PART 1: Convert the 3.0.8 messages so they have curly quotes. 
//          **COMMENTED OUT**, because msg_custom.t has taken over this task.
//  PART 2: Make any updates to the 3.0.8 messages for 3.0.9/3.0.12.
//          (This part isn't necessary anymore, but the game was 
//          tested with this code in it, so whatever.)
//  PART 3: Make any desired changes to the standard library messages.
//          Add contractions, change "appear" to "seem", or just rewrite
//          messages based on personal taste.
//          **99% COMMENTED OUT**, because msg_custom.t has taken over this task.
//  PART 4: Rewrite messages for the sake of the bot.

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
////  
////  PART 1:
////  Convert the 3.0.8 messages so they have curly quotes.
////  
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////

/* // Begin commenting-out the entirety of part one

// -----------------------
// MSG_NEU.T MODIFICATIONS
// -----------------------

modify libMessages //: MessageHelper
//    whomPronoun = 'whom'
//    offerOopsNote = true
//    commandLookAround = 'look around'
//    commandFullScore = 'full score'
//    announceRemappedAction(action) {
//        return '\n<.assume>' + action.getParticiplePhrase() + '<./assume>\n';
//    }
//    announceImplicitAction(action, ctx) {
//        return ctx.buildImplicitAnnouncement(action.getImplicitPhrase(ctx));
//    }
//    silentImplicitAction(action, ctx) { return ''; }
//    announceMoveToBag(action, ctx) {
//        return ctx.buildImplicitAnnouncement(
//            action.getImplicitPhrase(ctx) + ' to make room');
//    }
//    showCredit(name, byline) { "<<name>> <<byline>>"; }
//    showVersion(name, version) { "<<name>> version <<version>>"; }
//    noAboutInfo = "<.parser>This story has no ABOUT
//                   information.<./parser> "
//    showListState(state) { " (<<state>>)"; }
//    allInSameListState(lst, stateName) { 
//        " (<<lst.length() == 2 ? 'both' : 'all'>> <<stateName>>)";
//    }
//    distantThingDesc(obj) {
//        gMessageParams(obj);
//        "{It's obj} too far away to make out any detail. ";
//    }
    obscuredThingDesc(obj, obs) {
        gMessageParams(obj, obs);
        "{You/he} can&rsquo;t make out any detail through {the obs/him}. ";
    }
    distantThingSoundDesc(obj)
        { "{You/he} can&rsquo;t hear any detail from this distance. "; }
    obscuredThingSoundDesc(obj, obs) {
        gMessageParams(obj, obs);
        "{You/he} can&rsquo;t hear any detail through {the obs/him}. ";
    }
    distantThingSmellDesc(obj)
        { "{You/he} can&rsquo;t smell much at this distance. "; }
    obscuredThingSmellDesc(obj, obs) {
        gMessageParams(obj, obs);
        "{You/he} can&rsquo;t smell much through {the obs/him}. ";
    }
//    thingTasteDesc(obj)
//        { "{You/he} taste{s} nothing out of the ordinary. "; }
//    thingFeelDesc(obj)
//        { "{You/he} feel{s} nothing out of the ordinary. "; }
//
    obscuredReadDesc(obj) {
        gMessageParams(obj);
        "{You/he} can&rsquo;t see {that obj/him} well enough to read {it/him}. ";
    }
    dimReadDesc(obj) {
        gMessageParams(obj);
        "There&rsquo;s not enough light to read {that obj/him}. ";
    }
//    litMatchDesc(obj) { "\^<<obj.nameIs>> lit. "; }
//    unlitMatchDesc(obj) { "\^<<obj.nameIs>> an ordinary match. "; }
//    litCandleDesc(obj) { "\^<<obj.nameIs>> lit. "; }
//    putDestContainer(obj) { return 'into ' + obj.theNameObj; }
//    putDestSurface(obj) { return 'onto ' + obj.theNameObj; }
//    putDestUnder(obj) { return 'under ' + obj.theNameObj; }
//    putDestBehind(obj) { return 'behind ' + obj.theNameObj; }
//    putDestFloor(obj) { return 'to ' + obj.theNameObj; }
//    listSepMiddle = ", "
//    listSepTwo = " and "
//    listSepEnd = ", and "
//    longListSepMiddle = "; "
//    longListSepTwo = ", and "
//    longListSepEnd = "; and "
    showScoreMessage(points, maxPoints, turns) {
        "You have
        scored <<points>> of a possible <<maxPoints>> point<<
          maxPoints == 1 ? '' : 's'>>. ";
        //"In <<turns>> move<<turns == 1 ? '' : 's'>>, you have
        //scored <<points>> of a possible <<maxPoints>> point<<
        //  maxPoints == 1 ? '' : 's'>>. ";
    }
//    showScoreNoMaxMessage(points, turns) {
//        "In <<turns>> move<<turns == 1 ? '' : 's'>>, you have
//        scored <<points>> point<<points == 1 ? '' : 's'>>. ";
//    }
//    showScoreRankMessage(msg) { "This makes you <<msg>>. "; }
//    showFullScorePrefix = "Your score consists of:"
//    fullScoreItemPoints(points) {
//        "<<points>> point<<points == 1 ? '' : 's'>> for ";
//    }
    //firstScoreChange(delta) {
    //    "<.commandsep><.notification><<
    //        basicScoreChange(delta)>><./notification>
    //    \n<.notification>If you&rsquo;d prefer not to be notified about
    //    score changes in the future, type <<
    //    aHref('notify off', 'NOTIFY OFF', 'Turn off score notifications')
    //    >>.<./notification> ";
    //}
    firstScoreChange(delta) {
      return scoreChange(delta);
    }
//    scoreChange(delta) {
//        "<.commandsep><.notification><<
//        basicScoreChange(delta)>><./notification> ";
//    }
    basicScoreChange(delta) {
        "Your score
        has just <<delta > 0 ? 'in' : 'de'>>creased by
        <<delta > 0 ? delta : -delta>>
        point<<delta is in (1, -1) ? '' : 's'>>.";
    }
//    footnoteRef(num) {
//        local str;
//        str = '<sup>[<a href="footnote ' + num + '"><.a>';
//        str += num;
//        str += '<./a></a>]</sup>';
//        return str;
//    }
    firstFootnote() {
        "<.commandsep><.notification>A number in [square brackets] like
        the one above refers to a footnote, which you can read by typing
        FOOTNOTE followed by the number: 
        <<aHref('footnote 1', 'FOOTNOTE 1', 'Show footnote [1]')>>,
        for example.  Footnotes usually contain added background information
        that might be interesting but isn&rsquo;t essential to the story.
        If you&rsquo;d prefer not to see footnotes at all,
        you can control their appearance by typing
        <<aHref('footnotes', 'FOOTNOTES',
                'Control footnote appearance')>>.<./notification> ";
    }
//    noSuchFootnote(num) {
//        "<.parser>The story has never referred to any such
//        footnote.<./parser> ";
//    }
    showFootnoteStatus(stat) {
        "The current setting is FOOTNOTES ";
        switch(stat)
        {
        case FootnotesOff:
            "OFF, which hides all footnote references.
            Type <<aHref('footnotes medium', 'FOOTNOTES MEDIUM',
                         'Set footnotes to Medium')>> to
            show references to footnotes except those you&rsquo;ve
            already seen, or <<aHref('footnotes full', 'FOOTNOTES FULL',
                                     'Set footnotes to Full')>>
            to show all footnote references. ";
            break;
        case FootnotesMedium:
            "MEDIUM, which shows references to unread footnotes, but
            hides references to those you&rsquo;ve already read.  Type
            <<aHref('footnotes off', 'FOOTNOTES OFF',
                    'Turn off footnotes')>> to hide
            footnote references entirely, or <<aHref(
                'footnotes full', 'FOOTNOTES FULL',
                'Set footnotes to Full')>> to show every reference, even to
            notes you&rsquo;ve already read. ";
            break;
        case FootnotesFull:
            "FULL, which shows every footnote reference, even to
            notes you&rsquo;ve already read.  Type <<aHref('footnotes medium',
            'FOOTNOTES MEDIUM', 'Set footnotes to Medium')>> to show
            only references to notes you
            haven&rsquo;t yet read, or <<aHref('footnotes off', 'FOOTNOTES OFF',
                'Turn off footnotes')>>
            to hide footnote references entirely. ";
            break;
        }
    }
//    acknowledgeFootnoteStatus(stat) {
//        "<.parser>The setting is now FOOTNOTES <<
//        stat == FootnotesOff ? 'OFF'
//        : stat == FootnotesMedium ? 'MEDIUM'
//        : 'FULL' >>.<./parser> ";
//    }
//    mainCommandPrompt(which) { "\b&gt;"; }
//    emptyCommandResponse = "<.parser>I beg your pardon?<./parser> "
    invalidCommandToken(ch) {
        "<.parser>The story doesn&rsquo;t know how to use the character
        &lsquo;<<ch>>&rsquo; in a command.<./parser> ";
    }
//    commandResultsPrefix = '<.p0>'
//    commandInterruptionPrefix = '<.p>'
//    commandResultsSeparator = '<.p>'
//    complexResultsSeparator = '<.p>'
//    internalResultsSeparator = '<.p>'
//    commandResultsSuffix = ''
//    commandResultsEmpty = 'Nothing obvious happens.<.p>'
//    intraCommandSeparator = '<.p>'
//    smellDescSeparator() {
//        "<.p>";
//    }
//    soundDescSeparator() {
//        "<.p>";
//    }
//    cannotTalkTo(targetActor, issuingActor) {
//        "\^<<targetActor.nameIs>> not something <<issuingActor.itNom>>
//        can talk to. ";
//    }
//    alreadyTalkingTo(actor, greeter) {
//        "\^<<greeter.theName>> already <<greeter.verbToHave>>
//        <<actor.theNamePossAdj>> attention. ";
//    }
//    noTopicsNotTalking = "<.parser>{You're} not currently talking
//                          to anyone.<./parser> "
//    oopsNote() {
//        if (offerOopsNote) {
//            "<.commandsep><.notification>If this was an accidental
//            misspelling, you can correct it by typing OOPS followed by the
//            corrected word now.  Any time the story points out an unknown
//            word, you can correct a misspelling using OOPS as your next
//            command.<./notification> ";
//            libMessages.offerOopsNote = nil;
//        }
//    }
    oopsOutOfContext = "<.parser>You can only use OOPS to correct
        a misspelling immediately after the story points out a word
        it doesn&rsquo;t know.<./parser> "
//    oopsMissingWord = "<.parser>To use OOPS to correct a misspelling,
//        put the corrected word after OOPS, as in OOPS BOOK.<./parser> "
//    acknowledgeVerboseMode(verbose) {
//        if (verbose)
//            "<.parser>VERBOSE mode is now selected.<./parser> ";
//        else
//            "<.parser>TERSE mode is now selected.<./parser> ";
//    }
//    showNotifyStatus(stat) {
//        "<.parser>Score notifications are
//        currently <<stat ? 'on' : 'off'>>.<./parser> ";
//    }
//    acknowledgeNotifyStatus(stat) {
//        "<.parser>Score notifications are now
//        <<stat ? 'on' : 'off'>>.<./parser> ";
//    }
//    announceMultiActionObject(obj, whichObj, action) {
//        return '\n<.announceObj>' + obj.name + ':<./announceObj> ';
//    }
//    announceAmbigActionObject(obj, whichObj, action) {
//        return '<.assume>' + obj.theName + '<./assume>\n';
//    }
//    announceDefaultObject(obj, whichObj, action, resolvedAllObjects) {
//        return '<.assume>'
//            + action.announceDefaultObject(obj, whichObj, resolvedAllObjects)
//            + '<./assume>\n';
//    }
    noCommandForAgain() {
        "<.parser>There&rsquo;s nothing to repeat.<./parser> ";
    }
//    againCannotChangeActor() {
//        "<.parser>To repeat a command like <q>turtle, go north,</q>
//        just say <q>again,</q> not <q>turtle, again.</q><./parser> ";
//    }
//    againCannotTalkToTarget(issuer, target) {
//        "\^<<issuer.theName>> cannot repeat that command. ";
//    }
//    againNotPossible(issuer) {
//        "That command cannot be repeated now. ";
//    }
//    systemActionToNPC() {
//        "<.parser>This command cannot be directed to another
//        character in the story.<./parser> ";
//    }
//    confirmQuit() {
//        "Do you really want to quit?\ (<<aHref('y', 'Y', 'Confirm quitting')
//        >> is affirmative) >\ ";
//    }
//    okayQuitting() { }
//    notTerminating() {
//        "<.parser>Continuing the story.<./parser> ";
//    }
//    confirmRestart() {
//        "Do you really want to start over?\ (<<aHref('Y', 'Y',
//        'Confirm restart')>> is affirmative) >\ ";
//    }
//    notRestarting() { "<.parser>Continuing the story.<./parser> "; }
//    showFinishMsg(msg) { "<.p>*** <<msg>>\ ***<.p>"; }
//    finishDeathMsg = 'YOU HAVE DIED'
//    finishVictoryMsg = 'YOU HAVE WON'
//    finishFailureMsg = 'YOU HAVE FAILED'
//    finishGameOverMsg = 'GAME OVER'
//    getSavePrompt =
//        'Please select a file in which to save the current position'
//    getRestorePrompt = 'Please select the saved position file to restore'
//    saveOkay() { "<.parser>Saved.<./parser> "; }
//    saveCanceled() { "<.parser>Canceled.<./parser> "; }
//    saveFailed(exc) {
//        "<.parser>Failed; your computer might be running low
//        on disk space, or you might not have the necessary permissions
//        to write this file.<./parser> ";
//    }
//    noteMainRestore() { "<.parser>Restoring saved game...<./parser>\n"; }
//    restoreOkay() { "<.parser>Restored.<./parser> "; }
//    restoreCanceled() { "<.parser>Canceled.<./parser> "; }
//    restoreInvalidFile() {
//        "<.parser>Failed: this is not a valid saved
//        position file.<./parser> ";
//    }
//    restoreCorruptedFile() {
//        "<.parser>Failed: this saved state file appears to be
//        corrupted.  This can occur if the file was modified by another
//        program, or the file was copied between computers in a non-binary
//        transfer mode, or the physical media storing the file were
//        damaged.<./parser> ";
//    }
//    restoreInvalidMatch() {
//        "<.parser>Failed: the file was not saved by this
//        story (or was saved by an incompatible version of
//        the story).<./parser> ";
//    }
//    restoreFailed(exc) {
//        "<.parser>Failed: the position could not be
//        restored.<./parser> ";
//    }
//    filePromptFailed() {
//        "<.parser>A system error occurred asking for a filename.
//        Your computer might be running low on memory, or might have a
//        configuration problem.<./parser> ";
//    }
    pausePrompt() {
        "<.parser>The story is now paused.  Please press
        the space bar when you are ready to resume the story, or
        press the &lsquo;S&rsquo; key to save the current position.<./parser><.p>";
    }
//    pauseSaving() {
//        "<.parser>Saving the story...<./parser><.p>";
//    }
//    pauseEnded() {
//        "<.parser>Resuming the story.<./parser> ";
//    }
//    inputScriptOkay(fname) {
//        "<.parser>Reading commands from <q><<fname.htmlify()
//         >></q>...<./parser>\n ";
//    }
//    getScriptingPrompt = 'Please select a name for the new script file'
//    scriptingOkay() {
//        "<.parser>Text will now be saved to the script file.
//        Type <<aHref('script off', 'SCRIPT OFF', 'Turn off scripting')>> to
//        discontinue scripting.<./parser> ";
//    }
//    scriptingCanceled = "<.parser>Canceled.<./parser> "
//    scriptOffOkay = "<.parser>Scripting ended.<./parser> "
//    scriptOffIgnored = "<.parser>No script is currently being
//                        recorded.<./parser> "
//    getRecordingPrompt = 'Please select a name for the new command log file'
//    recordingOkay = "<.parser>Commands will now be recorded.  Type
//                     <<aHref('record off', 'RECORD OFF',
//                             'Turn off recording')>>
//                     to stop recording commands.<.parser> "
//    recordingCanceled = "<.parser>Canceled.<./parser> "
//    recordOffOkay = "<.parser>Command recording ended.<./parser> "
//    recordOffIgnored = "<.parser>No command recording is currently being
//                        made.<./parser> "
//    getReplayPrompt = 'Please select the command log file to replay'
//    replayCanceled = "<.parser>Canceled.<./parser> "
//    undoOkay(actor, cmd) {
//        "<.parser>Taking back one turn: <q>";
//        if (actor != nil)
//            "<<actor>>, ";
//        "<<cmd>></q>.<./parser><.p>";
//    }
//    undoFailed() {
//        "<.parser>No more undo information is
//        available.<./parser> ";
//    }
//    noteAccepted = "Noted. "
    noteWithoutScript = "<.p><.notification>Note that the transcript isn&rsquo;t
        currently being recorded.  NOTE is usually used to provide feedback
        to the author by putting a comment in the transcript, so it&rsquo;s most
        useful when you&rsquo;re saving the transcript to a file.  If you want
        to start saving the transcript, please type <<
          aHref('script', 'SCRIPT', 'Begin saving the transcript')
          >>.<./notification> "
    invalidFinishOption(resp) {
        "\bThat isn&rsquo;t one of the options. ";
    }
//    exitsOnOffOkay(stat) {
//        "<.parser>The list of exits will <<
//        stat ? 'now' : 'no longer'>> be
//        displayed in each room description.<./parser> ";
//    }
//    explainExitsOnOff =
//        "<.p><.notification>You can control whether or not the exit list
//        is automatically displayed in each room description by typing
//        <<aHref('exits on', 'EXITS ON', 'Activate exit display')>> or
//        <<aHref('exits off', 'EXITS OFF', 'Turn off exit display'
//               )>>.<./notification> "
//    hintsDisabled = '<.parser>Hints are now disabled.<./parser> '
    sorryHintsDisabled = '<.parser>Sorry, but hints have been disabled
                          for this session, as you requested.  If you&rsquo;ve
                          changed your mind, you&rsquo;ll have to save your
                          current position, exit the TADS interpreter,
                          and start a new interpreter session.<./parser> '
    hintsNotPresent = '<.parser>Sorry, this story doesn&rsquo;t
                       have any built-in hints.<./parser> '
//    currentlyNoHints = '<.parser>Sorry, no hints are currently available.
//                        Please check back later.<./parser> '
    showHintWarning =
       "<.notification>Warning: Some people don&rsquo;t like built-in hints,
       since the temptation to ask for help prematurely can become
       overwhelming when hints are so close at hand.  If you&rsquo;re worried
       that your willpower won&rsquo;t hold up, you can disable hints for the
       rest of this session by typing <<aHref('hints off', 'HINTS OFF')
       >>.  If you still want to see the hints now, type
       <<aHref('hint', 'HINT')>>.<./notification> "
//    hintsDone = '<.parser>Done.<./parser> '
    commandNotPresent = "<.parser>That command isn&rsquo;t needed
                         here.<./parser> "
    scoreNotPresent = "<.parser>This story doesn&rsquo;t use
                       scoring.<./parser> "
//    mentionFullScore = "<.p><.notification>To see a detailed accounting
//        of your score, type <<
//          aHref('full score', 'FULL SCORE') >>.<./notification> "
//    menuKeyList = [
//                   ['q'],
//                   ['p', '[left]', '[bksp]', '[esc]'],
//                   ['u', '[up]'],
//                   ['d', '[down]'],
//                   ['ENTER', '\n', '[right]', ' ']
//                  ]
//    prevMenuLink = '<font size=-1>Previous</font>'
//    nextMenuTopicLink = '<font size=-1>Next</font>'
    textMenuMainPrompt(keylist) {
        "\bSelect a topic number, or press &lsquo;<<
        keylist[M_PREV][1]>>&rsquo; for the previous
        menu or &lsquo;<<keylist[M_QUIT][1]>>&rsquo; to quit:\ ";
    }
    textMenuTopicPrompt() {
        "\bPress the space bar to display the next line,
        &lsquo;<b>P</b>&rsquo; to go to the previous menu, or
        &lsquo;<b>Q</b>&rsquo; to quit.\b";
    }
//    menuTopicProgress(cur, tot) { " [<<cur>>/<<tot>>]"; }
//    menuTopicListEnd = '[The End]'
//    menuLongTopicEnd = '[The End]'
//    menuInstructions(keylist, prevLink) {
//        "<tab align=right ><b>\^<<keylist[M_QUIT][1]>></b>=Quit <b>\^<<
//        keylist[M_PREV][1]>></b>=Previous Menu<br>
//        <<prevLink != nil ? aHrefAlt('previous', prevLink, '') : ''>>
//        <tab align=right ><b>\^<<keylist[M_UP][1]>></b>=Up <b>\^<<
//        keylist[M_DOWN][1]>></b>=Down <b>\^<<
//        keylist[M_SEL][1]>></b>=Select<br>";
//    }
//    menuNextChapter(keylist, title, hrefNext, hrefUp) {
//        "Next: <a href='<<hrefNext>>'><<title>></a>;
//        <b>\^<<keylist[M_PREV][1]>></b>=<a href='<<hrefUp>>'>Menu</a>";
//    }
//    cannotReachObject(obj) {
//        "{You/he} cannot reach <<obj.theNameObj>>. ";
//    }
//    cannotReachContents(obj, loc) {
//        gMessageParams(obj, loc);
//        return '{You/he} cannot reach {the obj/him} through {the loc/him}. ';
//    }
//    cannotReachOutside(obj, loc) {
//        gMessageParams(obj, loc);
//        return '{You/he} cannot reach {the obj/him} through {the loc/him}. ';
//    }
//    soundIsFromWithin(obj, loc) {
//        "\^<<obj.theName>> appear<<obj.verbEndingS>> to be
//        coming from inside <<loc.theNameObj>>. ";
//    }
//    soundIsFromWithout(obj, loc) {
//        "\^<<obj.theName>> appear<<obj.verbEndingS>> to be
//        coming from outside <<loc.theNameObj>>. ";
//    }
//    smellIsFromWithin(obj, loc) {
//        "\^<<obj.theName>> appear<<obj.verbEndingS>> to be
//        coming from inside <<loc.theNameObj>>. ";
//    }
//    smellIsFromWithout(obj, loc) {
//        "\^<<obj.theName>> appear<<obj.verbEndingS>> to be
//        coming from outside <<loc.theNameObj>>. ";
//    }
//    pcDesc(actor) {
//        "\^<<actor.theName>> look<<actor.verbEndingS>> the same
//        as usual. ";
//    }
//    roomActorStatus(actor) {
//        if (actor.posture != standing)
//            " (<<actor.posture.participle>>)";
//    }
//    actorInRoomStatus(actor, room)
//        { " (<<actor.posture.participle>> <<room.actorInName>>)"; }
//    roomDarkName = 'In the dark'
    roomDarkDesc = "It&rsquo;s pitch black. "
//    roomActorHereDesc(actor) {
//        "\^<<actor.nameIs>> <<actor.posture.participle>> here. ";
//    }
//    roomActorThereDesc(actor) {
//        "\^<<actor.nameIs>> <<actor.posture.participle>> nearby. ";
//    }
//    actorInRoom(actor, cont) {
//        "\^<<actor.nameIs>> <<actor.posture.participle>>
//        <<cont.actorInName>>. ";
//    }
//    actorInRoomPosture(actor, room) {
//        "\^<<actor.itIs>> <<actor.posture.participle>>
//        <<room.actorInName>>. ";
//    }
//    roomActorPostureDesc(actor) {
//        if (actor.posture != standing)
//            "\^<<actor.itIs>> <<actor.posture.participle>>. ";
//    }
//    actorInRemoteRoom(actor, room, pov) {
//        "\^<<actor.nameIs>> <<actor.posture.participle>>
//        <<room.inRoomName(pov)>>. ";
//    }
//    actorInRemoteNestedRoom(actor, inner, outer, pov) {
//        "\^<<actor.nameIs>> <<outer.inRoomName(pov)>>,
//        <<actor.posture.participle>> <<inner.actorInName>>. ";
//    }
//    actorInGroupPrefix(posture, cont, lst) { "\^"; }
//    actorInGroupSuffix(posture, cont, lst) {
//        " <<lst.length() == 1 ? 'is' : 'are'>> <<posture.participle>>
//        <<cont.actorInName>>. ";
//    }
//    actorInRemoteGroupPrefix(pov, posture, cont, remote, lst) { "\^"; }
//    actorInRemoteGroupSuffix(pov, posture, cont, remote, lst) {
//        " <<lst.length() == 1 ? 'is' : 'are'>> <<remote.inRoomName(pov)>>,
//        <<posture.participle>> <<cont.actorInName>>. ";
//    }
//    actorHereGroupPrefix(posture, lst) { "\^"; }
//    actorHereGroupSuffix(posture, lst) {
//        " <<lst.length() == 1 ? 'is' : 'are'>>
//        <<posture.participle>> here. ";
//    }
//    actorThereGroupPrefix(pov, posture, remote, lst) { "\^"; }
//    actorThereGroupSuffix(pov, posture, remote, lst) {
//        " <<lst.length() == 1 ? 'is' : 'are'>> <<posture.participle>>
//        <<remote.inRoomName(pov)>>. ";
//    }
//    sayArriving(traveler) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerLocName>>. ";
//    }
//    sayDeparting(traveler) {
//        "\^<<traveler.travelerName(nil)>> leave<<traveler.verbEndingS>>
//        <<traveler.travelerLocName>>. ";
//    }
//    sayArrivingLocally(traveler, dest) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerLocName>>. ";
//    }
//    sayArrivingDir(traveler, dirName) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> from the <<dirName>>. ";
//    }
//    sayDepartingDir(traveler, dirName) {
//        local nm = traveler.travelerRemoteLocName;
//        "\^<<traveler.travelerName(nil)>> leave<<traveler.verbEndingS>>
//        to the <<dirName>><<nm != '' ? ' from ' + nm : ''>>. ";
//    }
//    sayArrivingShipDir(traveler, dirName) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> from <<dirName>>. ";
//    }
//    sayDepartingShipDir(traveler, dirName) {
//        local nm = traveler.travelerRemoteLocName;
//        
//        "\^<<traveler.travelerName(nil)>> leave<<traveler.verbEndingS>>
//        to <<dirName>><<nm != '' ? ' from ' + nm : ''>>. ";
//    }
//    sayDepartingAft(traveler) {
//        local nm = traveler.travelerRemoteLocName;
//        
//        "\^<<traveler.travelerName(nil)>> go<<traveler.verbEndingEs>>
//        aft<<nm != '' ? ' from ' + nm : ''>>. ";
//    }
//    sayDepartingFore(traveler) {
//        local nm = traveler.travelerRemoteLocName;
//        "\^<<traveler.travelerName(nil)>> go<<traveler.verbEndingEs>>
//        forward<<nm != '' ? ' from ' + nm : ''>>. ";
//    }
    notOnboardShip = "That direction isn&rsquo;t meaningful here. "
//    sayDepartingThroughPassage(traveler, passage) {
//        "\^<<traveler.travelerName(nil)>> leave<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> through <<passage.theNameObj>>. ";
//    }
//    sayArrivingThroughPassage(traveler, passage) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> through <<passage.theNameObj>>. ";
//    }
//    sayDepartingViaPath(traveler, passage) {
//        "\^<<traveler.travelerName(nil)>> leave<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> via <<passage.theNameObj>>. ";
//    }
//    sayArrivingViaPath(traveler, passage) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> via <<passage.theNameObj>>. ";
//    }
//    sayDepartingUpStairs(traveler, stairs) {
//        "\^<<traveler.travelerName(nil)>> go<<traveler.verbEndingEs>>
//        up <<stairs.theNameObj>>. ";
//    }
//    sayDepartingDownStairs(traveler, stairs) {
//        "\^<<traveler.travelerName(nil)>> go<<traveler.verbEndingEs>>
//        down <<stairs.theNameObj>>. ";
//    }
//    sayArrivingUpStairs(traveler, stairs) {
//        local nm = traveler.travelerRemoteLocName;
//
//        "\^<<traveler.travelerName(true)>> come<<traveler.verbEndingS>>
//        up <<stairs.theNameObj>><<nm != '' ? ' to ' + nm : ''>>. ";
//    }
//    sayArrivingDownStairs(traveler, stairs) {
//        local nm = traveler.travelerRemoteLocName;
//
//        "\^<<traveler.travelerName(true)>> come<<traveler.verbEndingS>>
//        down <<stairs.theNameObj>><<nm != '' ? ' to ' + nm : ''>>. ";
//    }
//    sayDepartingWith(traveler, lead) {
//        "\^<<traveler.travelerName(nil)>> come<<traveler.verbEndingS>>
//        with <<lead.theNameObj>>. ";
//    }
//    sayDepartingWithGuide(guide, lead) {
//        "\^<<lead.theName>> let<<lead.verbEndingS>>
//        <<guide.theNameObj>> lead the way. ";
//    }
//    sayOpenDoorRemotely(door, stat) {
//        "Someone <<stat ? 'open' : 'close'>>s <<door.theNameObj>> from
//        the other side. ";
//    }
//    openMsg(obj) { return 'open'; }
//    closedMsg(obj) { return 'closed'; }
//    currentlyOpen = '{It\'s dobj} currently open. '
//    currentlyClosed = '{It\'s dobj} currently closed. '
//    openStatusMsg(obj) { return obj.itIsContraction + ' ' + obj.openDesc; }
//    lockedMsg(obj) { return 'locked'; }
//    unlockedMsg(obj) { return 'unlocked'; }
//    currentlyLocked = '{It\'s dobj} currently locked. '
//    currentlyUnlocked = '{It\'s dobj} currently unlocked. '
//    onMsg(obj) { return 'on'; }
//    offMsg(obj) { return 'off'; }
//    matchBurnedOut(obj) {
//        gMessageParams(obj);
//        "{The obj/he} finish{es} burning, and disappear{s} into a
//        cloud of ash. ";
//    }
//    candleBurnedOut(obj) {
//        gMessageParams(obj);
//        "{The obj/he} burn{s} down too far to stay lit, and go{es} out. ";
//    }
//    objBurnedOut(obj) {
//        gMessageParams(obj);
//        "{The obj/he} go{es} out. ";
//    }
;

modify playerMessages //: libMessages
    commandNotUnderstood(actor) {
        "<.parser>The story doesn&rsquo;t understand that command.<./parser> ";
    }
    specialTopicInactive(actor) {
        "<.parser>That command can&rsquo;t be used right now.<./parser> ";
    }
////    // 2019-05-18 GWB: I want to be extra careful about replacing noMatch(). 
////    // Somehow, an incorrectly parameterized version of this function...
////    // noMatch(actor, txt) // <-- WRONG!
////    // ...rather than...
////    // noMatch(actor, action, txt)
////    // ...got into my code, either from an old version of TADS 3 or from
////    // me making a mistake. 
////    noMatch(actor, action, txt) {
////        "{You/he} see{s} no <<txt>> here. ";
////    }
//    allNotAllowed(actor) {
//        "<.parser><q>All</q> cannot be used with that verb.<./parser> ";
//    }
//    noMatchForAll(actor) {
//        "<.parser>{You/he} see{s} nothing to use
//        for <q>all</q> here.<./parser> ";
//    }
//    noMatchForAllBut(actor) {
//        "<.parser>{You/he} see{s} nothing else here.<./parser> ";
//    }
//    noMatchForListBut(actor) { noMatchForAllBut(actor); }
    noMatchForPronoun(actor, typ, pronounWord) {
        "<.parser>The word <q><<pronounWord>></q> doesn&rsquo;t refer to
        anything right now.<./parser> ";
    }
    reflexiveNotAllowed(actor, typ, pronounWord) {
        "<.parser>The story doesn&rsquo;t understand how to use the word
        <q><<pronounWord>></q> like that.<./parser> ";
    }
    wrongReflexive(actor, typ, pronounWord) {
        "<.parser>The story doesn&rsquo;t understand what the
        word <q><<pronounWord>></q> refers to.<./parser> ";
    }
//    noMatchForPossessive(actor, owner, txt) {
//        "<.parser>\^<<owner.theName>> do<<owner.verbEndingEs>>
//        not appear to have any such thing.<./parser> ";
//    }
//    noMatchForLocation(actor, loc, txt) {
//        "<.parser>\^<<actor.nameVerb('see')>> no 
//        <<loc.childInName(txt)>>.<./parser> ";
//    }
//    nothingInLocation(actor, loc) {
//        "<.parser>\^<<actor.nameVerb('see')>> 
//        <<loc.childInName('nothing unusual')>>.<./parser> ";
//    }
//    noMatchDisambig(actor, origPhrase, disambigResponse) {
//        "<.parser>That was not one of the choices. ";
//    }
//    emptyNounPhrase(actor) {
//        "<.parser>You seem to have left out some words.<./parser> ";
//    }
    zeroQuantity(actor, txt) {
        "<.parser>\^<<actor.theName>> can&rsquo;t do that to zero of
        something.<./parser> ";
    }
    insufficientQuantity(actor, txt, matchList, requiredNum) {
        "<.parser>\^<<actor.nameVerb('do')>>n&rsquo;t see that many <<txt>>
        here.<./parser> ";
    }
    uniqueObjectRequired(actor, txt, matchList) {
        "<.parser>Multiple objects aren&rsquo;t allowed with that
        command.<./parser> ";
    }
    singleObjectRequired(actor, txt) {
        "<.parser>Multiple objects aren&rsquo;t allowed with that
        command.<./parser> ";
    }
//    disambigOrdinalOutOfRange(actor, ordinalWord, originalText) {
//        "<.parser>There were not that many choices. ";
//    }
//    askDisambig(actor, originalText, matchList, fullMatchList,
//                requiredNum, askingAgain, dist)
//    {
//        reportQuestion('');
//        if (!askingAgain)
//            "<.parser>";
//        if (requiredNum == 1) {
//            if (askingAgain)
//                "Which did you mean,
//                <<askDisambigList(matchList, fullMatchList, nil, dist)>>?";
//            else
//                "Which <<originalText>> do you mean,
//                <<askDisambigList(matchList, fullMatchList, nil, dist)>>?";
//        }
//        else {
//            if (askingAgain)
//                "Which <<spellInt(requiredNum)>> (of
//                <<askDisambigList(matchList, fullMatchList, true, dist)>>)
//                did you mean?";
//            else
//                "Which <<spellInt(requiredNum)>>
//                (of <<askDisambigList(matchList, fullMatchList,
//                                      true, dist)>>) do you mean?";
//        }
//        "<./parser> ";
//    }
    ambiguousNounPhrase(actor, originalText, matchList, fullMatchList) {
        "<.parser>The story doesn&rsquo;t know which
        <<originalText>> you mean.<./parser> ";
    }
//    missingActor(actor) {
//        "<.parser>You must be more specific about <<
//        whomPronoun>> you want to address.<./parser> ";
//    }
//    singleActorRequired(actor) {
//        "<.parser>You can only address one person
//        at a time.<./parser> ";
//    }
//    cannotChangeActor() {
//        "<.parser>You cannot address more than one character on
//        a single command line in this story.<./parser> ";
//    }
//    askUnknownWord(actor, txt) {
//        "<.parser>The word <q><<txt>></q> is not necessary in this
//        story.<./parser> ";
//        oopsNote();
//    }
    wordIsUnknown(actor, txt) {
        "<.parser>The story doesn&rsquo;t understand that
        command.<./parser> ";
    }
//    refuseCommandBusy(targetActor, issuingActor) {
//        "\^<<targetActor.nameIs>> busy. ";
//    }
//    cannotAddressMultiple(actor) {
//        "<.parser>\^<<actor.theName>> cannot address multiple
//        people at once.<./parser> ";
//    }
;

modify npcMessages //: playerMessages
//    commandNotHeard(actor) {
//        "\^<<actor.nameVerb('do')>> not respond. ";
//    }
////    // 2019-05-18 GWB: I want to be extra careful about replacing noMatch(). 
////    // Somehow, an incorrectly parameterized version of this function...
////    // noMatch(actor, txt) // <-- WRONG!
////    // ...rather than...
////    // noMatch(actor, action, txt)
////    // ...got into my code, either from an old version of TADS 3 or from
////    // me making a mistake. 
////    noMatch(actor, action, txt) {
////        "\^<<actor.nameVerb('see')>> no <<txt>>. ";
////    }
    noMatchForAll(actor) {
        "<.parser>\^<<actor.nameVerb('do')>>n&rsquo;t see what you
        mean by <q>all.</q><./parser> ";
    }
//    noMatchForAllBut(actor) {
//        "<.parser>\^<<actor.nameVerb('see')>> nothing
//        else.<./parser> ";
//    }
    insufficientQuantity(actor, txt, matchList, requiredNum) {
        "<.parser>\^<<actor.nameVerb('do')>>n&rsquo;t see that many
         <<txt>>.<./parser> ";
    }
    ambiguousNounPhrase(actor, originalText, matchList, fullMatchList) {
        "<.parser>\^<<actor.nameVerb('do')>>n&rsquo;t know which
        <<originalText>> you mean.<./parser> ";
    }
//    askMissingObject(actor, action, which) {
//        reportQuestion('<.parser>\^' + action.whatObj(which)
//                       + ' do you want ' + actor.theNameObj + ' to '
//                       + action.getQuestionInf(which) + '?<./parser> ');
//    }
//    missingObject(actor, action, which) {
//        "<.parser>You must be more specific
//        about <<action.whatObj(which)>> you want <<actor.theNameObj>>
//        to <<action.getQuestionInf(which)>>.<./parser> ";
//    }
//    missingLiteral(actor, action, which) {
//        "<.parser>You must be more specific
//        about <<action.whatObj(which)>> you want <<actor.theNameObj>> to
//        <<action.getQuestionInf(which, nil)>>.  For example:
//        <<actor.theName>>, <<action.getQuestionInf(which, nil)>>
//        <q>something</q>.<./parser> ";
//    }
;

modify npcMessagesDirect //: npcMessages
////    // 2019-05-18 GWB: I want to be extra careful about replacing noMatch(). 
////    // Somehow, an incorrectly parameterized version of this function...
////    // noMatch(actor, txt) // <-- WRONG!
////    // ...rather than...
////    // noMatch(actor, action, txt)
////    // ...got into my code, either from an old version of TADS 3 or from
////    // me making a mistake. 
////    noMatch(actor, action, txt) {
////        "\^<<actor.nameVerb('look')>> around. <q>I don&rsquo;t
////        see any <<txt>>.</q> ";
////    }
    noMatchForAll(actor) {
        "\^<<actor.nameVerb('say')>>, <q>I don&rsquo;t see what
        you mean by <q>all</q>.</q> ";
    }
//    noMatchForAllBut(actor) {
//        "\^<<actor.nameVerb('say')>>, <q>I see nothing else here.</q> ";
//    }
    zeroQuantity(actor, txt) {
        "\^<<actor.nameVerb('say')>>, <q>I can&rsquo;t do that to
            zero of something.</q> ";
    }
    insufficientQuantity(actor, txt, matchList, requiredNum) {
        "\^<<actor.nameVerb('say')>>, <q>I don&rsquo;t see that many <<txt>>
            here.</q> ";
    }
    uniqueObjectRequired(actor, txt, matchList) {
        "\^<<actor.nameVerb('say')>>, <q>I can&rsquo;t use multiple objects
            like that.</q> ";
    }
    singleObjectRequired(actor, txt) {
        "\^<<actor.nameVerb('say')>>, <q>I can&rsquo;t use multiple objects
        like that.</q> ";
    }
//    noMatchDisambig(actor, origPhrase, disambigResponse) {
//        "\^<<actor.nameVerb('say')>>, <q>That was not one of
//        the choices. ";
//    }
    disambigOrdinalOutOfRange(actor, ordinalWord, originalText) {
        "\^<<actor.nameVerb('say')>>, <q>There weren&rsquo;t that many choices. ";
    }
//    askDisambig(actor, originalText, matchList, fullMatchList,
//                requiredNum, askingAgain, dist)
//    {
//        reportQuestion('');
//        if (requiredNum == 1) {
//            if (!askingAgain)
//                "\^<<actor.nameVerb('ask')>>, <q>";
//            "Which <<originalText>> do you mean, <<
//            askDisambigList(matchList, fullMatchList, nil, dist)>>?</q> ";
//        }
//        else {
//            if (!askingAgain)
//                "\^<<actor.nameVerb('ask')>>, <q>";
//            "Which <<spellInt(requiredNum)>> (of <<
//            askDisambigList(matchList, fullMatchList, true, dist)>>)
//            do you mean?</q> ";
//        }
//    }
    ambiguousNounPhrase(actor, originalText, matchList, fullMatchList) {
        "\^<<actor.nameVerb('say')>>, <q>I don&rsquo;t know which
            <<originalText>> you mean.</q> ";
    }
//    askMissingObject(actor, action, which) {
//        reportQuestion('\^' + actor.nameVerb('say') + ', <q>\^'
//                       + action.whatObj(which)
//                       + ' do you want me to '
//                       + action.getQuestionInf(which) + '?</q> ');
//    }
    missingObject(actor, action, which) {
        "\^<<actor.nameVerb('say')>>,
        <q>I don&rsquo;t know <<action.whatObj(which)>>
        you want me to <<action.getQuestionInf(which)>>.</q> ";
    }
//    missingLiteral(actor, action, which) {
//        missingObject(actor, action, which);
//    }
    askUnknownWord(actor, txt) {
        "\^<<actor.nameVerb('say')>>, <q>I don&rsquo;t know the word
         '<<txt>>'.</q> ";
    }
    wordIsUnknown(actor, txt) {
        "\^<<actor.nameVerb('say')>>, <q>You used a word I don&rsquo;t know.</q> ";
    }
;

modify npcDeferredMessagesDirect //: npcDeferredMessages
    commandNotUnderstood(actor) {
        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t understand
            what you meant.</q> ";
    }
////    // 2019-05-18 GWB: I want to be extra careful about replacing noMatch(). 
////    // Somehow, an incorrectly parameterized version of this function...
////    // noMatch(actor, txt) // <-- WRONG!
////    // ...rather than...
////    // noMatch(actor, action, txt)
////    // ...got into my code, either from an old version of TADS 3 or from
////    // me making a mistake. 
////    noMatch(actor, action, txt) {
////        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t see any <<txt>>.</q> ";
////    }
    noMatchForAll(actor) {
        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t see what
            you meant by <q>all</q>.</q> ";
    }
    noMatchForAllBut(actor) {
        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t see what you meant.</q> ";
    }
//    emptyNounPhrase(actor) {
//        "\^<<actor.nameVerb('say')>>, <q>You left some words out.</q> ";
//    }
    zeroQuantity(actor, txt) {
        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t
             understand what you meant.</q> ";
    }
    insufficientQuantity(actor, txt, matchList, requiredNum) {
        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t see enough <<txt>>.</q> ";
    }
    uniqueObjectRequired(actor, txt, matchList) {
        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t
            understand what you meant.</q> ";
    }
    singleObjectRequired(actor, txt) {
        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t
            understand what you meant.</q> ";
    }
    ambiguousNounPhrase(actor, originalText, matchList, fullMatchList) {
        "\^<<actor.nameVerb('say')>>, <q>I couldn&rsquo;t tell which
        <<originalText>> you meant.</q> ";
    }
    askMissingObject(actor, action, which) {
        reportQuestion('\^' + actor.nameVerb('say') + ', <q>I didn&rsquo;t know '
                       + action.whatObj(which) + ' you wanted me to '
                       + action.getQuestionInf(which) + '.</q> ');
    }
    wordIsUnknown(actor, txt) {
        "\^<<actor.nameVerb('say')>>, <q>You used a word I don&rsquo;t know.</q> ";
    }
;

modify playerActionMessages //: MessageHelper
    cannotDoThatMsg = '{You/he} can&rsquo;t do that. '
//    mustBeHoldingMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must be holding {the obj/him} to do that. ';
//    }
    tooDarkMsg = 'It&rsquo;s too dark to do that. '
//    mustBeVisibleMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot see {that obj/him}. ';
//    }
    heardButNotSeenMsg(obj) {
        gMessageParams(obj);
        return '{You/he} can hear {an obj/him}, but {you/he}
                 can&rsquo;t see{s} {it obj/him}. ';
    }
    smelledButNotSeenMsg(obj) {
        gMessageParams(obj);
        return '{You/he} can smell {an obj/him}, but {you/he}
                can&rsquo;t see{s} {it obj/him}. ';
    }
//    cannotHearMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot hear {that obj/him}. ';
//    }
//    cannotSmellMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot smell {that obj/him}. ';
//    }
//    cannotTasteMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot taste {that obj/him}. ';
//    }
//    cannotBeWearingMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must take off {the obj/him}
//                before {it actor/he} can do that. ';
//    }
//    mustBeEmptyMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must take everything out of {the obj/him}
//                before {it actor/he} can do that. ';
//    }
//    mustBeOpenMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must open {the obj/him}
//                before {it actor/he} can do that. ';
//    }
//    mustBeClosedMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must close {the obj/him}
//               before {it actor/he} can do that. ';
//    }
//    mustBeUnlockedMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must unlock {the obj/him}
//                before {it actor/he} can do that. ';
//    }
//    noKeyNeededMsg = '{The dobj/he} do{es} not appear to take a key. '
//    mustBeStandingMsg = '{You/he} must stand up before {it actor/he}
//                      can do that. '
//    mustSitOnMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must sit {in obj} first. ';
//    }
//    mustLieOnMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must lie {in obj} first. ';
//    }
//    mustGetOnMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must get {in obj} first. ';
//    }
//    mustBeInMsg(obj, loc) {
//        gMessageParams(obj, loc);
//        return '{The obj/he} must be {in loc} before {you/he}
//            can do that. ';
//    }
//    mustBeCarryingMsg(obj, actor) {
//        gMessageParams(obj, actor);
//        return '{The actor/he} must be holding {the obj/him}
//            before {you/he} can do that. ';
//    }
    decorationNotImportantMsg(obj) {
        gMessageParams(obj);
        return '{The obj/he} {is}n&rsquo;t important. ';
    }
    unthingNotHereMsg(obj) {
        gMessageParams(obj);
        return '{You/he} do{es}n&rsquo;t see {that obj/him} here. ';
    }
//    tooDistantMsg(obj) {
//        gMessageParams(obj);
//        return '{The obj/he} {is} too far away. ';
//    }
    notWithIntangibleMsg(obj) {
        gMessageParams(obj);
        return '{You/he} can&rsquo;t do that to {an obj/him}. ';
    }
    notWithVaporousMsg(obj) {
        gMessageParams(obj);
        return '{You/he} can&rsquo;t do that to {an obj/him}. ';
    }
//    lookInVaporousMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} just see{s} {the obj/him}. ';
//    }
//    cannotReachObjectMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot reach {the obj/him}. ';
//    }
//    cannotReachThroughMsg(obj, loc) {
//        gMessageParams(obj, loc);
//        return '{You/he} cannot reach {the obj/him} through {the loc/him}. ';
//    }
//    thingDescMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} see{s} nothing unusual about {it obj/him}. ';
//    }
//    thingSoundDescMsg(obj)
//        { return '{You/he} hear{s} nothing out of the ordinary. '; }
//    thingSmellDescMsg(obj)
//        { return '{You/he} smell{s} nothing out of the ordinary. '; }
//    npcDescMsg(npc) {
//        gMessageParams(npc);
//        return '{You/he} see{s} nothing unusual about {the npc/him}. ';
//    }
    nothingInsideMsg = 'There&rsquo;s nothing unusual in {the dobj/him}. '
//    nothingUnderMsg = '{You/he} see{s} nothing unusual under {the dobj/him}. '
//    nothingBehindMsg =
//        '{You/he} see{s} nothing unusual behind {the dobj/him}. '
//    nothingThroughMsg = '{You/he} can see nothing through {the dobj/him}. '
    cannotLookBehindMsg = '{You/he} can&rsquo;t look behind {the dobj/him}. '
    cannotLookUnderMsg = '{You/he} can&rsquo;t look under {the dobj/him}. '
    cannotLookThroughMsg = '{You/he} can&rsquo;t see through {the dobj/him}. '
    nothingThroughPassageMsg = '{You/he} can&rsquo;t see much through
        {the dobj/him} from here. '
//    nothingBeyondDoorMsg = 'Opening {the dobj/him} reveals nothing
//        unusual. '
//    nothingToSmellMsg = '{You/he} smell{s} nothing out of the ordinary. '
//    nothingToHearMsg = '{You/he} hear{s} nothing out of the ordinary. '
//    noiseSourceMsg(src) {
//        return '{The dobj/he} seem{s} to be coming from '
//            + src.theNameObj + '. ';
//    }
//    odorSourceMsg(src) {
//        return '{The dobj/he} seem{s} to be coming from '
//            + src.theNameObj + '. ';
//    }
    notWearableMsg = '{That dobj/he} {is}n&rsquo;t something {you/he} can wear. '
    notDoffableMsg = '{That dobj/he} {is}n&rsquo;t something {you/he} can remove. '
//    alreadyWearingMsg = '{You\'re} already wearing {it dobj/him}. '
//    notWearingMsg = '{You\'re} not wearing {that dobj/him}. '
//    okayWearMsg = 'Okay, {you\'re} now wearing {the dobj/him}. '
//    okayDoffMsg = 'Okay, {you\'re} no longer wearing {the dobj/him}. '
//    okayOpenMsg = 'Opened. '
//    okayCloseMsg = 'Closed. '
//    okayLockMsg = 'Locked. '
//    okayUnlockMsg = 'Unlocked. '
//    cannotDigMsg = '{You/he} {have} no reason to dig in {that dobj/him}. '
//    cannotDigWithMsg =
//        '{You/he} see{s} no way to use {that dobj/him} as a shovel. '
//    alreadyHoldingMsg = '{You/he} {are} already carrying {the dobj/him}. '
    takingSelfMsg = '{You/he} can&rsquo;t take {yourself}. '
//    notCarryingMsg = '{You\'re} not carrying {that dobj/him}. '
    droppingSelfMsg = '{You/he} can&rsquo;t drop {yourself}. '
    puttingSelfMsg = '{You/he} can&rsquo;t do that to {yourself}. '
//    alreadyPutInMsg = '{The dobj/he} {is} already in {the iobj/him}. '
//    alreadyPutOnMsg = '{The dobj/he} {is} already on {the iobj/him}. '
//    alreadyPutUnderMsg = '{The dobj/he} {is} already under {the iobj/him}. '
//    alreadyPutBehindMsg = '{The dobj/he} {is} already behind {the iobj/him}. '
//    cannotMoveFixtureMsg = '{The dobj/he} cannot be moved. '
    cannotTakeFixtureMsg = '{You/he} can&rsquo;t take {that dobj/him}. '
    cannotPutFixtureMsg = '{You/he} can&rsquo;t put {the dobj/him} anywhere. '
    cannotTakeImmovableMsg = '{You/he} can&rsquo;t take {that dobj/him}. '
//    cannotMoveImmovableMsg = '{The dobj/he} cannot be moved. '
    cannotPutImmovableMsg = '{You/he} can&rsquo;t put {the dobj/him} anywhere. '
//    cannotTakeHeavyMsg = '{The dobj/he} {is} too heavy. '
//    cannotMoveHeavyMsg = '{The dobj/he} {is} too heavy. '
//    cannotPutHeavyMsg = '{The dobj/he} {is} too heavy. '
//    cannotMoveComponentMsg(loc) {
//        return '{The dobj/he} {is} part of ' + loc.theNameObj + '. ';
//    }
    cannotTakeComponentMsg(loc) {
        return '{You/he} can&rsquo;t have {that/him dobj}; '
            + '{it\'s dobj} part of ' + loc.theNameObj + '. ';
    }
    cannotPutComponentMsg(loc) {
        return '{You/he} can&rsquo;t put {that/him dobj} anywhere; '
            + '{it\'s dobj} part of ' + loc.theNameObj + '. ';
    }
    cannotTakePushableMsg = '{You/he} can&rsquo;t take {that/him dobj}, but
        {it actor/he} might be able to push it somewhere. '
    cannotMovePushableMsg = 'It wouldn&rsquo;t accomplish anything to move
        {the dobj/him} around aimlessly, but {it actor/he}
        might be able to push {it dobj/him} in a specific direction. '
    cannotPutPushableMsg = '{You/he} can&rsquo;t put {that/him dobj} anywhere,
        but {it actor/he} might be able to push it somewhere. '
    cannotTakeLocationMsg = '{You/he} can&rsquo;t take {that/him dobj}
        while {you\'re} occupying {it/him dobj}. '
//    okayTakeMsg = 'Taken. '
//    okayDropMsg = 'Dropped. '
//    droppingObjMsg(dropobj) {
//        gMessageParams(dropobj);
//        return '{You/he} drop{s} {the dropobj/him}. ';
//    }
//    floorlessDropMsg(dropobj) {
//        gMessageParams(dropobj);
//        return '{It dropobj/he} fall{s} out of sight below. ';
//    }
//    okayPutInMsg = 'Done. '
//    okayPutOnMsg = 'Done. '
//    okayPutUnderMsg = 'Done. '
//    okayPutBehindMsg = 'Done. '
    cannotTakeActorMsg = '{The dobj/he} won&rsquo;t let {you/him} do that. '
    cannotMoveActorMsg = '{The dobj/he} won&rsquo;t let {you/him} do that. '
    cannotPutActorMsg = '{The dobj/he} won&rsquo;t let {you/him} do that. '
    cannotTakePersonMsg = '{The dobj/he} probably wouldn&rsquo;t like that. '
    cannotMovePersonMsg = '{The dobj/he} probably wouldn&rsquo;t like that. '
    cannotPutPersonMsg = '{The dobj/he} probably wouldn&rsquo;t like that. '
    cannotMoveThroughMsg(obj, obs) {
        gMessageParams(obj, obs);
        return '{You/he} can&rsquo;t move {that obj/him} through {the obs/him}. ';
    }
    cannotMoveThroughContainerMsg(obj, cont) {
        gMessageParams(obj, cont);
        return '{You/he} can&rsquo;t move {that obj/him} through {the cont/him}. ';
    }
    cannotMoveThroughClosedMsg(obj, cont) {
        gMessageParams(cont);
        return '{You/he} can&rsquo;t do that because {the cont/he} {is} closed. ';
    }
    cannotFitIntoOpeningMsg(obj, cont) {
        gMessageParams(obj, cont);
        return '{You/he} can&rsquo;t do that because {the obj/he} {is}
                too big to put into {the cont/him}. ';
    }
    cannotFitOutOfOpeningMsg(obj, cont) {
        gMessageParams(obj, cont);
        return '{You/he} can&rsquo;t do that because {the obj/he} {is}
                too big to take out of {the cont/him}. ';
    }
    cannotTouchThroughContainerMsg(obj, cont) {
        gMessageParams(obj, cont);
        return '{The obj/he} can&rsquo;t reach anything through {the cont/him}. ';
    }
    cannotTouchThroughClosedMsg(obj, cont) {
        gMessageParams(obj, cont);
        return '{The obj/he} can&rsquo;t do that because
               {the cont/he} {is} closed. ';
    }
    cannotReachIntoOpeningMsg(obj, cont) {
        gMessageParams(obj, cont);
        return '{The obj/he} can&rsquo;t fit {its/her} hand into {the cont/him}. ';
    }
    cannotReachOutOfOpeningMsg(obj, cont) {
        gMessageParams(obj, cont);
        return '{The obj/he} can&rsquo;t fit {its/her} hand through
               {the cont/him}. ';
    }
//    tooLargeForActorMsg(obj) {
//        gMessageParams(obj);
//        return '{The obj/he} {is} too large for {you/him} to hold. ';
//    }
//    handsTooFullForMsg(obj) {
//        return '{Your} hands are too full to hold ' + obj.theNameObj + '. ';
//    }
//    becomingTooLargeForActorMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot do that because {the obj/he}
//                would become too large for {you/him} to hold. ';
//    }
//    handsBecomingTooFullForMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot do that because {your} hands
//            would become too full to hold {the obj/him}. ';
//    }
//    tooHeavyForActorMsg(obj) {
//        gMessageParams(obj);
//        return '{The obj/he} {is} too heavy for {you/him} to pick up. ';
//    }
//    totalTooHeavyForMsg(obj) {
//        gMessageParams(obj);
//        return '{The obj/he} {is} too heavy; {you/he} will have to put
//            something else down first. ';
//    }
//    tooLargeForContainerMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} {is} too large for {the cont/him}. ';
//    }
//    tooLargeForUndersideMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} {is} too large to put under {the cont/him}. ';
//    }
//    tooLargeForRearMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} {is} too large to put behind {the cont/him}. ';
//    }
//    containerTooFullMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The cont/he} {is} already too full to hold {the obj/him}. ';
//    }
    surfaceTooFullMsg(obj, cont) {
        gMessageParams(obj, cont);
        return 'There&rsquo;s no room for {the obj/him} on {the cont/him}. ';
    }
    undersideTooFullMsg(obj, cont) {
        gMessageParams(obj, cont);
        return 'There&rsquo;s no room for {the obj/him} under {the cont/him}. ';
    }
    rearTooFullMsg(obj, cont) {
        gMessageParams(obj, cont);
        return 'There&rsquo;s no room for {the obj/him} behind {the cont/him}. ';
    }
//    becomingTooLargeForContainerMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} cannot do that because it would make
//            {the obj/him} too large for {the cont/him}. ';
//    }
//    containerBecomingTooFullMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} cannot do that because {the obj/he}
//            would no longer fit in {the cont/him}. ';
//    }
    notAContainerMsg = '{You/he} can&rsquo;t put anything in {the iobj/him}. '
    notASurfaceMsg = 'There&rsquo;s no good surface on {the iobj/him}. '
    cannotPutUnderMsg = '{You/he} can&rsquo;t put anything under {that iobj/him}. '
    cannotPutBehindMsg = '{You/he} can&rsquo;t put anything
        behind {the iobj/him}. '
    cannotPutInSelfMsg = '{You/he} can&rsquo;t put {the dobj/him} in {itself}. '
    cannotPutOnSelfMsg = '{You/he} can&rsquo;t put {the dobj/him} on {itself}. '
    cannotPutUnderSelfMsg = '{You/he} can&rsquo;t put {the dobj/him} under
        {itself}. '
    cannotPutBehindSelfMsg = '{You/he} can&rsquo;t put {the dobj/him} behind
        {itself}. '
    cannotPutInRestrictedMsg =
        '{You/he} can&rsquo;t put {that dobj/him} in {the iobj/him}. '
    cannotReturnToDispenserMsg =
        '{You/he} can&rsquo;t put {a dobj/him} back in {the iobj/him}. '
    cannotPutInDispenserMsg =
        '{You/he} can&rsquo;t put {a dobj/him} in {the iobj/him}. '
    objNotForKeyringMsg = '{The dobj/he} do{es}n&rsquo;t fit on {the iobj/him}. '
//    keyNotOnKeyringMsg = '{The dobj/he} {is} not attached to {the iobj/him}. '
    keyNotDetachableMsg = '{The dobj/he} {is}n&rsquo;t attached to anything. '
//    takenAndMovedToKeyringMsg(keyring) {
//        gMessageParams(keyring);
//        return '{You/he} pick{s} up {the dobj/him} and attach{es actor}
//            {it dobj/him} to {the keyring/him}. ';
//    }
//    movedKeyToKeyringMsg(keyring) {
//        gMessageParams(keyring);
//        return '{You/he} attach{es} {the dobj/him} to {the keyring/him}. ';
//    }
//    movedKeysToKeyringMsg(keyring, keys) {
//        gMessageParams(keyring);
//        return '{You/he} attach{es} {your/his} loose key'
//            + (keys.length() > 1 ? 's' : '')
//            + ' to {the keyring/him}. ';
//    }
    circularlyInMsg(x, y) {
        gMessageParams(x, y);
        return '{You/he} can&rsquo;t do that while {the x/he} {is}
            in {the y/him}. ';
    }
    circularlyOnMsg(x, y) {
        gMessageParams(x, y);
        return '{You/he} can&rsquo;t do that while {the x/he} {is}
            on {the y/him}. ';
    }
    circularlyUnderMsg(x, y) {
        gMessageParams(x, y);
        return '{You/he} can&rsquo;t do that while {the x/he} {is}
            under {the y/him}. ';
    }
    circularlyBehindMsg(x, y) {
        gMessageParams(x, y);
        return '{You/he} can&rsquo;t do that while {the x/he} {is}
            behind {the y/him}. ';
    }
    takeFromNotInMsg = '{The dobj/he} {is}n&rsquo;t in {that iobj/him}. '
    takeFromNotOnMsg = '{The dobj/he} {is}n&rsquo;t on {that iobj/him}. '
    takeFromNotUnderMsg = '{The dobj/he} {is}n&rsquo;t under {that iobj/him}. '
    takeFromNotBehindMsg = '{The dobj/he} {is}n&rsquo;t behind {that iobj/him}. '
    takeFromNotInActorMsg = '{The iobj/he} do{es}n&rsquo;t have {that dobj/him}. '
    willNotLetGoMsg(holder, obj) {
        gMessageParams(holder, obj);
        return '{The holder/he} won&rsquo;t let {you/him} have {that obj/him}. ';
    }
    whereToGoMsg = 'You&rsquo;ll have to say which way to go. '
    cannotGoThatWayMsg = '{You/he} can&rsquo;t go that way. '
    cannotGoThatWayInDarkMsg = 'It&rsquo;s too dark; {you/he} can&rsquo;t see
                             where {you\'re} going. '
    cannotGoBackMsg = '{You/he} do{es}n&rsquo;t know how to return from here. '
    cannotDoFromHereMsg = '{You/he} can&rsquo;t do that from here. '
    cannotGoThroughClosedDoorMsg(door) {
        gMessageParams(door);
        return '{You/he} can&rsquo;t do that, because {the door/he} {is} closed. ';
    }
    invalidStagingContainerMsg(cont, dest) {
        gMessageParams(cont, dest);
        return '{You/he} can&rsquo;t do that while {the dest/he} {is}
                {in cont}. ';
    }
    invalidStagingLocationMsg(dest) {
        gMessageParams(dest);
        return '{You/he} can&rsquo;t get {in dest}. ';
    }
//    nestedRoomTooHighMsg(obj) {
//        gMessageParams(obj);
//        return '{The obj/he} {is} too high to reach from here. ';
//    }
    nestedRoomTooHighToExitMsg(obj) {
        return 'It&rsquo;s too long a drop to do that from here. ';
    }
    cannotDoFromMsg(obj) {
        gMessageParams(obj);
        return '{You/he} can&rsquo;t do that from {the obj/him}. ';
    }
    vehicleCannotDoFromMsg(obj) {
        local loc = obj.location;
        gMessageParams(obj, loc);
        return '{You/he} can&rsquo;t do that while {the obj/he} {is} {in loc}. ';
    }
    cannotGoThatWayInVehicleMsg(traveler) {
        gMessageParams(traveler);
        return '{You/he} can&rsquo;t do that {in traveler}. ';
    }
    cannotPushObjectThatWayMsg(obj) {
        gMessageParams(obj);
        return '{You/he} can&rsquo;t go that way pushing {the obj/him}. ';
    }
    cannotEnterExitOnlyMsg(obj) {
        gMessageParams(obj);
        return '{You/he} can&rsquo;t enter {the obj/him} from here. ';
    }
//    mustOpenDoorMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must open {the obj/him} first. ';
//    }
//    doorClosesBehindMsg(obj) {
//        gMessageParams(obj);
//        return '<.p>After {you/he} go{es} through {the obj/him}, {it/he}
//                close{s} behind {it actor/him}. ';
//    }
//    stairwayNotUpMsg = '{The dobj/he} only go{es} down from here. '
//    stairwayNotDownMsg = '{The dobj/he} only go{es} up from here. '
//    timePassesMsg = 'Time passes... '
//    sayHelloMsg = (addressingNoOneMsg)
//    sayGoodbyeMsg = (addressingNoOneMsg)
//    sayYesMsg = (addressingNoOneMsg)
//    sayNoMsg = (addressingNoOneMsg)
//    addressingNoOneMsg {
//        return '{You/he} must be more specific about '
//            + libMessages.whomPronoun + ' {you/he} want{s} to talk to. ';
//    }
//    okayYellMsg = '{You/he} scream{s} as loud as {it actor/he} can. '
//    okayJumpMsg = '{You/he} jump{s} a little, and land{s} back where
//        {it actor/he} started. '
    cannotJumpOverMsg = '{You/he} can&rsquo;t jump over {that dobj/him}. '
    cannotJumpOffMsg = '{You/he} can&rsquo;t jump off {that dobj/him}. '
    cannotJumpOffHereMsg = 'There&rsquo;s nowhere to jump from here. '
    cannotFindTopicMsg = '{You/he} can&rsquo;t seem to find that in {the dobj/him}. '
//    refuseCommand(targetActor, issuingActor) {
//        gMessageParams(targetActor, issuingActor);
//        return '{The targetActor/he} refuse{s} {your/his} request. ';
//    }
//    notAddressableMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot talk to {that obj/him}. ';
//    }
//    noResponseFromMsg(other) {
//        gMessageParams(other);
//        return '{The other/he} do{es} not respond. ';
//    }
    cannotAskSelfMsg =
        'Talking to {yourself/himself} won&rsquo;t accomplish anything. '
    cannotAskSelfForMsg =
        'Talking to {yourself/himself} won&rsquo;t accomplish anything. '
    cannotTellSelfMsg =
        'Talking to {yourself/himself} won&rsquo;t accomplish anything. '
    cannotGiveToSelfMsg = 'Giving {the dobj/him} to {yourself/himself}
        won&rsquo;t accomplish anything. '
    cannotShowToSelfMsg = 'Showing {the dobj/him} to {yourself/himself}
        won&rsquo;t accomplish anything. '
//    notInterestedMsg(actor) {
//        return '\^' + actor.nameVerb('do') + ' not appear interested. ';
//    }
//    objCannotHearActorMsg(obj) {
//        return '\^' + obj.nameVerb('do')
//            + ' not appear to hear {you/him}. ';
//    }
//    actorCannotSeeMsg(actor, obj) {
//        return '\^' + actor.theName + ' does not appear to be able to see '
//            + obj.theNameObj + '. ';
//    }
//    notFollowableMsg = '{You/he} cannot follow {that dobj/him}. '
//    cannotFollowSelfMsg = '{You/he} cannot follow {yourself}. '
//    followAlreadyHereMsg = '{The dobj/he} {is} right here. '
    followAlreadyHereInDarkMsg = '{The dobj/he} should be right here,
        but {you/he} can&rsquo;t see {it dobj/him}. '
//    followUnknownMsg = '{You\'re} not sure where {the dobj/he}
//        went from here. '
//    cannotFollowFromHereMsg(srcLoc) {
//        return 'The last place you saw {the dobj/him} was '
//            + srcLoc.getDestName(gActor, gActor.location) + '. ';
//    }
//    okayFollowInSightMsg(loc) {
//        return '{You/he} follow{s} {the dobj/him} '
//            + loc.actorIntoName + '. ';
//    }
    notAWeaponMsg = '{You/he} can&rsquo;t attack anything with {the iobj/him}. '
//    uselessToAttackMsg = '{You/he} cannot attack {that dobj/him}. '
//    pushNoEffectMsg = 'Pushing {the dobj/him} has no effect. '
//    okayPushButtonMsg = '<q>Click.</q> '
//    alreadyPushedMsg =
//        '{It\'s dobj} already pushed as far as {it dobj/he} will go. '
//    okayPushLeverMsg = '{You/he} push{es} {the dobj/him} to
//                     {its/her dobj} stop. '
//    pullNoEffectMsg = 'Pulling {the dobj/him} has no effect. '
//    alreadyPulledMsg =
//        '{It\'s dobj} already pulled as far as {it dobj/he} will go. '
//    okayPullLeverMsg = '{You/he} pull{s} {the dobj/him} to
//                     {its/her dobj} stop. '
//    okayPullSpringLeverMsg = '{You/he} pull{s} {the dobj/him}, which
//        spring{s} back to {its/her} starting position as soon as
//        {you/he} let{s} go of {it dobj/him}. '
//    moveNoEffectMsg = 'Moving {the dobj/him} has no effect. '
//    moveToNoEffectMsg = 'This would accomplish nothing. '
//    cannotPushTravelMsg = 'This would accomplish nothing. '
//    okayPushTravelMsg(obj) {
//        return '<.p>{You/he} push{es} ' + obj.theNameObj
//            + ' into the area. ';
//    }
//    cannotMoveWithMsg = '{You/he} cannot move anything with {the iobj/him}. '
//    setToInvalidMsg = '{The dobj/he} {has} no such setting. '
//    okaySetToMsg(val)
//        { return 'Okay, {the dobj/he} {is} now set to ' + val + '. '; }
//    cannotTurnMsg = '{You/he} cannot turn {that dobj/him}. '
//    mustSpecifyTurnToMsg = '{You/he} must specify the setting to
//                         turn {it dobj/him} to. '
//    cannotTurnWithMsg = '{You/he} cannot turn anything with {that iobj/him}. '
//    turnToInvalidMsg = '{The dobj/he} {has} no such setting. '
//    okayTurnToMsg(val)
//        { return 'Okay, {the dobj/he} {is} now set to ' + val + '. '; }
//    alreadySwitchedOnMsg = '{The dobj/he} {is} already on. '
//    alreadySwitchedOffMsg = '{The dobj/he} {is} already off. '
//    okayTurnOnMsg = 'Okay, {the dobj/he} {is} now on. '
//    okayTurnOffMsg = 'Okay, {the dobj/he} {is} now off. '
//    flashlightOnButDark = '{You/he} turn{s} on {the dobj/him}, but
//        nothing seems to happen. '
//    okayEatMsg = '{You/he} eat{s} {the dobj/him}. '
//    mustBeBurningMsg(obj) {
//        return '{You/he} must light ' + obj.theNameObj
//            + ' before {it actor/he} can do that. ';
//    }
    matchNotLitMsg = '{The dobj/he} {is}n&rsquo;t lit. '
//    okayBurnMatchMsg =
//        '{You/he} strike{s} {the dobj/him}, igniting a small flame. '
//    okayExtinguishMatchMsg = '{You/he} put{s} out {the dobj/him}, which
//        disappear{s} into a cloud of ash. '
//    candleOutOfFuelMsg =
//        '{The dobj/he} {is} too burned down; {it/he} cannot be lit. '
//    okayBurnCandleMsg = '{You/he} light{s} {the dobj/him}. '
//    candleNotLitMsg = '{The dobj/he} {is} not lit. '
//    okayExtinguishCandleMsg = 'Done. '
//    cannotConsultMsg =
//        '{That dobj/he} {is} not something {you/he} can consult. '
//    cannotTypeOnMsg = '{You/he} cannot type anything on {that dobj/him}. '
//    cannotEnterOnMsg = '{You/he} cannot enter anything on {that dobj/him}. '
//    cannotSwitchMsg = '{You/he} cannot switch {that dobj/him}. '
//    cannotFlipMsg = '{You/he} cannot flip {that dobj/him}. '
    cannotTurnOnMsg =
        '{That dobj/he} {is}n&rsquo;t something {you/he} can turn on. '
    cannotTurnOffMsg =
        '{That dobj/he} {is}n&rsquo;t something {you/he} can turn off. '
//    cannotLightMsg = '{You/he} cannot light {that dobj/him}. '
//    cannotBurnMsg = '{That dobj/he} {is} not something {you/he} can burn. '
//    cannotBurnWithMsg = '{You/he} cannot burn anything with {that iobj/him}. '
//    cannotBurnDobjWithMsg = '{You/he} cannot light {the dobj/him}
//                          with {the iobj/him}. '
//    alreadyBurningMsg = '{The dobj/he} {is} already burning. '
//    cannotExtinguishMsg = '{You/he} cannot extinguish {that dobj/him}. '
//    cannotPourMsg = '{That dobj/he} {is} not something {you/he} can pour. '
//    cannotPourIntoMsg = '{You/he} cannot pour anything into {that dobj/him}. '
//    cannotPourOntoMsg = '{You/he} cannot pour anything onto {that dobj/him}. '
//    cannotAttachMsg = '{You/he} cannot attach {that dobj/him} to anything. '
//    cannotAttachToMsg = '{You/he} cannot attach anything to {that iobj/him}. '
//    cannotAttachToSelfMsg =
//        '{You/he} cannot attach {the dobj/him} to {itself}. '
//    alreadyAttachedMsg =
//        '{The dobj/he} {is} already attached to {the iobj/him}. '
    wrongAttachmentMsg =
        '{You/he} can&rsquo;t attach {that dobj/him} to {the iobj/him}. '
    wrongDetachmentMsg =
        '{You/he} can&rsquo;t detach {that dobj/him} from {the iobj/him}. '
//    mustDetachMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must detach {the obj/him} before {you/he}
//            can do that. ';
//    }
//    okayAttachToMsg = 'Done. '
//    okayDetachFromMsg = 'Done. '
//    cannotDetachMsg = '{You/he} cannot detach {that dobj/him}. '
//    cannotDetachFromMsg =
//        '{You/he} cannot detach anything from {that iobj/him}. '
    cannotDetachPermanentMsg =
        'There&rsquo;s no obvious way to detach {that dobj/him}. '
    notAttachedToMsg = '{The dobj/he} {is}n&rsquo;t attached to {that iobj/him}. '
//    shouldNotBreakMsg = 'Breaking {that dobj/him} would serve no purpose. '
    cutNoEffectMsg = '{The iobj/he} can&rsquo;t seem to cut {the dobj/him}. '
    cannotCutWithMsg = '{You/he} can&rsquo;t cut anything with {the iobj/him}. '
//    cannotClimbMsg = '{That dobj/he} {is} not something {you/he} can climb. '
//    cannotOpenMsg = '{That dobj/he} {is} not something {you/he} can open. '
//    cannotCloseMsg = '{That dobj/he} {is} not something {you/he} can close. '
//    alreadyOpenMsg = '{The dobj/he} {is} already open. '
//    alreadyClosedMsg = '{The dobj/he} {is} already closed. '
//    alreadyLockedMsg = '{The dobj/he} {is} already locked. '
//    alreadyUnlockedMsg = '{The dobj/he} {is} already unlocked. '
//    cannotLookInClosedMsg = '{The dobj/he} {is} closed. '
//    cannotLockMsg =
//        '{That dobj/he} {is} not something {you/he} can lock. '
//    cannotUnlockMsg =
//        '{That dobj/he} {is} not something {you/he} can unlock. '
//    cannotOpenLockedMsg = '{The dobj/he} seem{s} to be locked. '
//    unlockRequiresKeyMsg =
//        '{You/he} seem{s} to need a key to unlock {the dobj/him}. '
    cannotLockWithMsg =
        '{The iobj/he} do{es}n&rsquo;t look suitable for locking that. '
    cannotUnlockWithMsg =
        '{The iobj/he} do{es}n&rsquo;t look suitable for unlocking that. '
    unknownHowToLockMsg = 'It&rsquo;s not clear how to lock {the dobj/him}. '
    unknownHowToUnlockMsg = 'It&rsquo;s not clear how to unlock {the dobj/him}. '
    keyDoesNotFitLockMsg = '{The iobj/he} do{es}n&rsquo;t fit the lock. '
//    foundKeyOnKeyringMsg(ring, key) {
//        gMessageParams(ring, key);
//        return '{You/he} tr{ies} each key on {the ring/him}, and
//            find{s actor} that {the key/he} fit{s} the lock. ';
//    }
    foundNoKeyOnKeyringMsg(ring) {
        gMessageParams(ring);
        return '{You/he} tr{ies} each key on {the ring/him},
            but {you/he} can&rsquo;t find anything that fits the lock. ';
    }
//    cannotEatMsg = '{The dobj/he} do{es} not appear to be edible. '
//    cannotDrinkMsg = '{That dobj/he} do{es} not appear to be something
//        {you/he} can drink. '
    cannotCleanMsg = '{You/he} wouldn&rsquo;t know how to clean {that dobj/him}. '
    cannotCleanWithMsg =
        '{You/he} can&rsquo;t clean anything with {that iobj/him}. '
//    cannotAttachKeyToMsg =
//        '{You/he} cannot attach {the dobj/him} to {that iobj/him}. '
    cannotSleepMsg = '{You/he} do{es}n&rsquo;t need to sleep right now. '
    cannotSitOnMsg = '{That dobj/he} {is}n&rsquo;t something {you/he} can sit on. '
    cannotLieOnMsg = '{That dobj/he} {is}n&rsquo;t something {you/he} can lie on. '
    cannotStandOnMsg = '{You/he} can&rsquo;t stand on {that dobj/him}. '
    cannotBoardMsg = '{You/he} can&rsquo;t board {that dobj/him}. '
    cannotUnboardMsg = '{You/he} can&rsquo;t get out of {that dobj/him}. '
    cannotGetOffOfMsg = '{You/he} can&rsquo;t get off of {that dobj/him}. '
//    cannotStandOnPathMsg = 'If {you/he} want{s} to follow {the dobj/him},
//        just say so. '
    cannotEnterHeldMsg =
        '{You/he} can&rsquo;t do that while {you\'re} holding {the dobj/him}. '
//    cannotGetOutMsg = '{You\'re} not in anything {you/he} can disembark. '
//    alreadyStandingMsg = '{You\'re} already standing. '
//    alreadyStandingOnMsg = '{You\'re} already standing {on dobj}. '
//    alreadySittingOnMsg = '{You\'re} already sitting {on dobj}. '
//    alreadyLyingOnMsg = '{You\'re} already lying {on dobj}. '
//    notOnPlatformMsg = '{You\'re} not {on dobj}. '
    noRoomToStandMsg = 'There&rsquo;s no room for {you/him} to stand {on dobj}. '
    noRoomToSitMsg = 'There&rsquo;s no room for {you/him} to sit {on dobj}. '
    noRoomToLieMsg = 'There&rsquo;s no room for {you/him} to lie {on dobj}. '
//    okayPostureChangeMsg(posture)
//        { return 'Okay, {you\'re} now ' + posture.participle + '. '; }
//    roomOkayPostureChangeMsg(posture, obj) {
//        gMessageParams(obj);
//        return 'Okay, {you\'re} now ' + posture.participle + ' {on obj}. ';
//    }
//    okayNotStandingOnMsg = 'Okay, {you\'re} no longer {on dobj}. '
//    cannotFastenMsg = '{You/he} cannot fasten {the dobj/him}. '
//    cannotFastenToMsg = '{You/he} cannot fasten anything to {the iobj/him}. '
//    cannotUnfastenMsg = '{You/he} cannot unfasten {the dobj/him}. '
//    cannotUnfastenFromMsg =
//        '{You/he} cannot unfasten anything from {the iobj/him}. '
//    cannotPlugInMsg = '{You/he} see{s} no way to plug in {the dobj/him}. '
//    cannotPlugInToMsg =
//        '{You/he} see{s} no way to plug anything into {the iobj/him}. '
//    cannotUnplugMsg = '{You/he} see{s} no way to unplug {the dobj/him}. '
//    cannotUnplugFromMsg =
//        '{You/he} see{s} no way to unplug anything from {the iobj/him}. '
//    cannotScrewMsg = '{You/he} see{s} no way to screw {the dobj/him}. '
//    cannotScrewWithMsg =
//        '{You/he} cannot screw anything with {the iobj/him}. '
//    cannotUnscrewMsg = '{You/he} see{s} no way to unscrew {the dobj/him}. '
//    cannotUnscrewWithMsg =
//        '{You/he} cannot unscrew anything with {the iobj/him}. '
//    cannotEnterMsg = '{That/he dobj} {is} not something {you/he} can enter. '
//    cannotGoThroughMsg =
//        '{That/he dobj} {is} not something {you/he} can go through. '
    cannotThrowAtSelfMsg =
        '{You/he} can&rsquo;t throw {that dobj/him} at {itself}. '
//    cannotThrowAtContentsMsg = '{You/he} must remove {the iobj/him}
//        from {the dobj/him} before {it actor/he} can do that. '
//    shouldNotThrowAtFloorMsg =
//        '{You/he} should just put {it dobj/him} down instead. '
//    throwHitMsg(projectile, target) {
//        gMessageParams(projectile, target);
//        return '{The projectile/he} hit{s} {the target/him} without any
//            obvious effect. ';
//    }
//    throwHitFallMsg(projectile, target, dest) {
//        gMessageParams(projectile, target);
//        return '{The projectile/he} hit{s} {the target/him}
//            without any obvious effect, and fall{s projectile} '
//            + dest.putInName + '. ';
//    }
//    throwShortMsg(projectile, target) {
//        gMessageParams(projectile, target);
//        return '{The projectile/he} fall{s} well short of {the target/him}. ';
//    }
//    throwFallShortMsg(projectile, target, dest) {
//        gMessageParams(projectile, target);
//        return '{The projectile/he} fall{s} ' + dest.putInName
//            + ' well short of {the target/him}. ';
//    }
//    throwCatchMsg(obj, target) {
//        return '\^' + target.nameVerb('catch')
//            + ' ' + obj.theNameObj + '. ';
//    }
    willNotCatchMsg(catcher) {
        return '\^' + catcher.nameVerb('do')
            + 'n&rsquo;t look like ' + catcher.itNom + ' want'
            + catcher.verbEndingS + ' to catch anything. ';
    }
//    cannotKissMsg = 'Kissing {the dobj/him} has no obvious effect. '
    cannotKissActorMsg = '{The dobj/he} probably wouldn&rsquo;t like that. '
//    cannotKissSelfMsg = '{You/he} cannot kiss {yourself}. '
//    newlyDarkMsg = 'It is now pitch black. '
;

modify npcActionMessages //: playerActionMessages
//    timePassesMsg = '{You/he} wait{s}... '
//    cannotMoveFixtureMsg = '{You/he} cannot move {that dobj/him}. '
//    cannotMoveImmovableMsg = '{You/he} cannot move {that dobj/him}. '
//    cannotTakeHeavyMsg =
//        '{That dobj/he} {is} too heavy for {you/him} to take. '
//    cannotMoveHeavyMsg =
//        '{That dobj/he} {is} too heavy for {you/him} to move. '
//    cannotPutHeavyMsg =
//        '{That dobj/he} {is} too heavy for {you/him} to move. '
//    cannotMoveComponentMsg(loc) {
//        return '{You/he} cannot do that because {the dobj/he} {is} part
//            of ' + loc.theNameObj + '. ';
//    }
//    okayTakeMsg = '{You/he} take{s} {the dobj/him}. '
//    okayDropMsg = '{You/he} put{s} down {the dobj/him}. '
//    okayPutInMsg = '{You/he} put{s} {the dobj/him} in {the iobj/him}. '
//    okayPutOnMsg = '{You/he} put{s} {the dobj/him} on {the iobj/him}. '
//    okayPutUnderMsg = '{You/he} put{s} {the dobj/him} under {the iobj/him}. '
//    okayPutBehindMsg = '{You/he} put{s} {the dobj/him} behind {the iobj/him}. '
//    okayWearMsg = '{You/he} put{s} on {the dobj/him}. '
//    okayDoffMsg = '{You/he} take{s} off {the dobj/him}. '
//    okayOpenMsg = '{You/he} open{s} {the dobj/him}. '
//    okayCloseMsg = '{You/he} close{s} {the dobj/him}. '
//    okayLockMsg = '{You/he} lock{s} {the dobj/him}. '
//    okayUnlockMsg = '{You/he} unlock{s} {the dobj/him}. '
//    pushNoEffectMsg =
//        '{You/he} tr{ies} to push {the dobj/him}, with no obvious effect. '
//    pullNoEffectMsg =
//        '{You/he} tr{ies} to pull {the dobj/him}, with no obvious effect. '
//    moveNoEffectMsg =
//        '{You/he} tr{ies} to move {the dobj/him}, with no obvious effect. '
//    moveToNoEffectMsg =
//        '{You/he} leave{s} {the dobj/he} where {it/he} {is}. '
    whereToGoMsg = 'You&rsquo;ll have to say which way {you/he} should go. '
//    tooLargeForContainerMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} cannot do that because {the obj/he} {is}
//            too large for {the cont/him}. ';
//    }
    tooLargeForUndersideMsg(obj, cont) {
        gMessageParams(obj, cont);
        return '{You/he} cannot do that because {the obj/he}
            won&rsquo;t fit under {the cont/him}. ';
    }
    tooLargeForRearMsg(obj, cont) {
        gMessageParams(obj, cont);
        return '{You/he} cannot do that because {the obj/he}
            won&rsquo;t fit behind {the cont/him}. ';
    }
//    containerTooFullMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} cannot do that because {the cont/he} {is}
//            already too full to hold {the obj/him}. ';
//    }
    surfaceTooFullMsg(obj, cont) {
        gMessageParams(obj, cont);
        return '{You/he} cannot do that because there&rsquo;s
            no room for {the obj/him} on {the cont/him}. ';
    }
    objNotForKeyringMsg = '{You/he} cannot do that because
                        {that dobj/he} do{es}n&rsquo;t fit on {the iobj/him}. '
    takeFromNotInMsg = '{You/he} cannot do that because
        {the dobj/he} {is}n&rsquo;t in {that iobj/him}. '
    takeFromNotOnMsg = '{You/he} cannot do that because
        {the dobj/he} {is}n&rsquo;t on {that iobj/him}. '
    takeFromNotUnderMsg = '{You/he} cannot do that because
        {the dobj/he} {is}n&rsquo;t under {that iobj/him}. '
    takeFromNotBehindMsg = '{You/he} cannot do that because
        {the dobj/he} {is}n&rsquo;t behind {that iobj/him}. '
    cannotJumpOffHereMsg = 'There&rsquo;s nowhere for {you/him} to jump. '
    shouldNotBreakMsg = '{You/he} do{es}n&rsquo;t want to break {that dobj/him}. '
//    okayPostureChangeMsg(posture)
//        { return '{You/he} ' + posture.msgVerbI + '. '; }
//    roomOkayPostureChangeMsg(posture, obj) {
//        gMessageParams(obj);
//        return '{You/he} ' + posture.msgVerbT + ' {on obj}. ';
//    }
//    okayNotStandingOnMsg = '{You/he} get{s} {offof dobj}. '
//    okayTurnToMsg(val)
//        { return '{You/he} turn{s} {the dobj/him} to ' + val + '. '; }
//    okayPushButtonMsg = '{You/he} push{es} {the dobj/him}. '
//    okayTurnOnMsg = '{You/he} turn{s} {the dobj/him} on. '
//    okayTurnOffMsg = '{You/he} turn{s} {the dobj/him} off. '
    keyDoesNotFitLockMsg = '{You/he} tr{ies} {the iobj/he}, but {it iobj/he}
                         do{es}n&rsquo;t fit the lock. '
    okayFollowModeMsg = '<q>Okay, I will follow {the dobj/him}.</q> '
//    okayExtinguishCandleMsg = '{You/he} extinguish{es} {the dobj/him}. '
//    okayAttachToMsg = '{You/he} attach{es} {the dobj/him} to {the iobj/him}. '
//    okayDetachFromMsg =
//        '{You/he} detach{es} {the dobj/him} from {the iobj/him}. '
    cannotAskSelfMsg = '{You/he} won&rsquo;t accomplish anything talking
        to {yourself/himself}. '
    cannotAskSelfForMsg = '{You/he} won&rsquo;t accomplish anything talking
        to {yourself/himself}. '
    cannotTellSelfMsg = '{You/he} won&rsquo;t accomplish anything talking
        to {yourself/himself}. '
    cannotGiveToSelfMsg = '{You/he} won&rsquo;t accomplish anything
        giving {the dobj/him} to {yourself/himself}. '
    cannotShowToSelfMsg = '{You/he} won&rsquo;t accomplish anything
        showing {the dobj/him} to {yourself/himself}. '
;

// ---------------------
// EN_US.T MODIFICATIONS
// ---------------------

modify Thing
    thatIsContraction { return isPlural ? 'those are' : 'that&rsquo;s'; }
    itIsContraction { return isPlural ? 'they&rsquo;re' : 'it&rsquo;s'; }
    theNamePossAdj {
        return theName + (isPlural && theName.endsWith('s') ? '&rsquo;' : '&rsquo;s');
    }
    pluralNameFrom(str) {
        local len;
        local lastChar;
        local lastPair;
        if (isPlural)
            return str;
        len = str.length();
        if (len == 0)
            return '';
        if (len == 1) {
            if (rexMatch(patSingleApostropheS, str) != nil)
                return str + '\'s';
            else
                return str + 's';
        }
        lastChar = str.substr(len, 1);
        lastPair = (len == 1 ? lastChar : str.substr(len - 1, 2));
        if (rexMatch(patUpperOrDigit, lastChar) != nil)
            return str + 's';
        if (lastChar == '.')
            return str + '&rsquo;s';
        if (rexMatch(patVowelY, lastPair) != nil)
            return str.substr(1, len - 1) + 'ies';
        if ('sxzh'.find(lastChar) != nil)
            return str + 'es';
        return str + 's';
    }
    nameIsnt { return nameIs + 'n&rsquo;t'; }
;

modify Actor
    thatIsContraction {
        return thatNom + ['&rsquo;m', '&rsquo;re', '&rsquo;s',
                          '&rsquo;re', '&rsquo;re', ' are'][conjugationSelector];
    }
    itIsContraction {
        return itNom + '&rsquo;'
            + ['m', 're', 's', 're', 're', 're'][conjugationSelector];
    }
    nameIsnt {
        return conjugationSelector == 1
            ? 'I&rsquo;m not' : inherited;
    }
;

// ------------------------
// INSTRUCT.T MODIFICATIONS
// ------------------------

//#charset "us-ascii"
//#include "adv3.h"
//#include "en_us.h"

//DefineSystemAction(Instructions)
modify InstructionsAction
    conversationInstructions =
        "You can talk to other characters by asking or
        telling them about things in the story.  For example, you might
        ASK WIZARD ABOUT WAND or TELL GUARD ABOUT ALARM.  You should
        always use the ASK ABOUT or TELL ABOUT phrasing; the story
        won&rsquo;t be able to understand other formats, so you don&rsquo;t have
        to worry about thinking up complicated questions like <q>ask
        guard how to open the window.</q>
        In most cases, you&rsquo;ll get the best results by asking
        about specific objects or other characters you&rsquo;ve encountered
        in the story, rather than about abstract topics such as
        MEANING OF LIFE; however, if something in the story leads you
        to believe you <i>should</i> ask about some particular abstract
        topic, it can&rsquo;t hurt to try.

        \bIf you&rsquo;re asking or telling the same person about several
        topics in succession, you can save some typing by abbreviating
        ASK ABOUT to A, and TELL ABOUT to T.  For example, once you&rsquo;re
        talking to the wizard, you can abbreviate ASK WIZARD ABOUT AMULET
        to simply A AMULET.  This addresses the question to the same
        character as in the last ASK or TELL.

        <<firstObj(InConversationState, ObjInstances) != nil ?
          "\bTo greet another character, type TALK TO (Person).  This
          tries to get the other character&rsquo;s attention and start a
          conversation.  TALK TO is always optional, since you can start
          in with ASK or TELL directly if you prefer." : "">>

        <<firstObj(SpecialTopic, ObjInstances) != nil ?
          "\bThe story might occasionally suggest some special conversation
          commands, like this:

          \b\t(You could apologize, or explain about the aliens.)

          \bIf you like, you can use one of the suggestions just by
          typing in the special phrasing shown.  You can usually
          abbreviate these to the first few words when they&rsquo;re long.

          \b\t&gt;APOLOGIZE
          \n\t&gt;EXPLAIN ABOUT ALIENS

          \bSpecial suggestions like this only work right at the moment
          they&rsquo;re offered, so you don&rsquo;t have to worry about memorizing
          them, or trying them at other random times in the story.
          They&rsquo;re not new commands for you to learn; they&rsquo;re just extra
          options you have at specific times, and the story will always
          let you know when they&rsquo;re available.  When the story offers
          suggestions like this, they don&rsquo;t limit what you can do; you
          can still type any ordinary command instead of one of the
          suggestions." : "">>

        <<firstObj(SuggestedTopic, ObjInstances) != nil ?
          "\bIf you&rsquo;re not sure what to discuss, you can type TOPICS any
          time you&rsquo;re talking to someone.  This will show you a list of
          things that your character might be interested in discussing
          with the other person.  The TOPICS command usually won&rsquo;t list
          everything that you can discuss, so feel free to explore other
          topics even if they&rsquo;re not listed." : "">>

        \bYou can also interact with other characters using physical
        objects.  For example, you might be able to give something to
        another character, as in GIVE MONEY TO CLERK, or show an object
        to someone, as in SHOW IDOL TO PROFESSOR.  You might also be
        able to fight other characters, as in ATTACK TROLL WITH
        SWORD or THROW AXE AT DWARF.

        \bIn some cases, you can tell a character to do
        something for you.  You do this by typing the character&rsquo;s name,
        then a comma, then the command you want the character to perform,
        using the same wording you&rsquo;d use for a command to your own
        character.  For example:

        \b\t&gt;ROBOT, GO NORTH

        \bKeep in mind, though, that there&rsquo;s no guarantee that other
        characters will always obey your orders.  Most characters have
        minds of their own and won&rsquo;t automatically do whatever you ask. "

#ifdef INSTRUCTIONS_MENU
    
#else // INSTRUCTIONS_MENU

    showInstructions()
    {
        local startedScript;
        startedScript = nil;
        "The story is about to show a full set of instructions,
        designed especially for people who aren&rsquo;t already familiar
        with interactive fiction.  The instructions are lengthy";
        if (scriptStatus.scriptFile == nil)
        {
            local str;
            ", so you might want to capture them to a file (so that
            you can print them out, for example).  Would you like to
            proceed?
            \n(<a href='yes'>Y</a> is affirmative, or type
            <a href='script'>SCRIPT</a> to capture to
            a file) &gt; ";
            str = inputManager.getInputLine(nil, nil);
            if (rexMatch('<nocase><space>*s(c(r(i(pt?)?)?)?)?<space>*', str)
                == str.length())
            {
                ScriptAction.setUpScripting(nil);
                if (scriptStatus.scriptFile == nil)
                    return;
                startedScript = true;
            }
            else if (rexMatch('<nocase><space>*y.*', str) != str.length())
            {
                "Canceled. ";
                return;
            }
        }
        else
        {
            "; would you like to proceed?
            \n(Y is affirmative) &gt; ";
            if (!yesOrNo())
            {
                "Canceled. ";
                return;
            }
        }
        "\ ";
        showCommandsChapter();
        showAbbrevChapter();
        showTravelChapter();
        showObjectsChapter();
        showConversationChapter();
        showTimeChapter();
        showSaveRestoreChapter();
        showSpecialCmdChapter();
        showUnknownWordsChapter();
        showAmbiguousCmdChapter();
        showAdvancedCmdChapter();
        showTipsChapter();
        if (startedScript)
            ScriptOffAction.turnOffScripting(nil);
    }

#endif // INSTRUCTIONS_MENU

    showCommandsChapter()
    {
        "\b<b>Entering Commands</b>\b
        You&rsquo;ve probably already noticed that you interact with the story
        by typing a command whenever you see the <q>prompt,</q> which
        usually looks like this:
        \b";

        libMessages.mainCommandPrompt(rmcCommand);

        "\bKnowing this much, you&rsquo;re probably thinking one of two things:
        <q>Great, I can type absolutely anything I want, in plain English,
        and the story will do my bidding,</q> or <q>Great, now I have to
        figure out yet another heinously complex command language for
        a computer program; I think I&rsquo;ll go play Minefield.</q>  Well,
        neither extreme is quite true.

        \bIn actual play, you&rsquo;ll only need a fairly small set of commands,
        and the commands are mostly in ordinary English, so there&rsquo;s not
        very much you&rsquo;ll have to learn or remember.  Even though that
        command prompt can look intimidating, don&rsquo;t let it scare you off
        &mdash; there are just a few simple things you have to know.

        \bFirst, you&rsquo;ll almost never have to refer to anything that
        isn&rsquo;t directly mentioned in the story; this is a story, after all,
        not a guessing game where you have to think of everything that
        goes together with some random object.  For example,
        if you&rsquo;re wearing a jacket, you might assume that the jacket has
        pockets, or buttons, or a zipper &mdash; but if the story never
        mentions those things, you shouldn&rsquo;t have to worry about them.

        \bSecond, you won&rsquo;t have to think of every conceivable action
        you could perform.  The point of the game isn&rsquo;t to make you
        guess at verbs.  Instead, you&rsquo;ll only have to use a relatively
        small number of simple, ordinary actions.  To give you an idea
        of what we mean, here are some of the commands you can use:";
        
        "\b
        \n\t LOOK AROUND
        \n\t INVENTORY
        \n\t GO NORTH (or EAST, SOUTHWEST, and so on, or UP, DOWN, IN, OUT)
        \n\t WAIT
        \n\t TAKE THE BOX
        \n\t DROP THE DISK
        \n\t LOOK AT THE DISK
        \n\t READ THE BOOK
        \n\t OPEN BOX
        \n\t CLOSE BOX
        \n\t LOOK IN THE BOX
        \n\t LOOK THROUGH WINDOW
        \n\t PUT FLOPPY DISK INTO BOX
        \n\t PUT BOX ON TABLE
        \n\t WEAR THE CONICAL HAT
        \n\t TAKE OFF HAT
        \n\t TURN ON LANTERN
        \n\t LIGHT MATCH
        \n\t LIGHT CANDLE WITH MATCH
        \n\t PUSH BUTTON
        \n\t PULL LEVER
        \n\t TURN KNOB
        \n\t TURN DIAL TO 11
        \n\t EAT COOKIE
        \n\t DRINK MILK
        \n\t THROW PIE AT CLOWN
        \n\t ATTACK TROLL WITH SWORD
        \n\t UNLOCK DOOR WITH KEY
        \n\t LOCK DOOR WITH KEY
        \n\t CLIMB THE LADDER
        \n\t GET IN THE CAR
        \n\t SIT ON THE CHAIR
        \n\t STAND ON THE TABLE
        \n\t STAND IN FLOWER BED
        \n\t LIE ON THE BED
        \n\t TYPE HELLO ON COMPUTER
        \n\t LOOK UP BOB IN PHONE BOOK";

        foreach (local cur in conversationVerbs)
            "\n\t <<cur>>";

        foreach (local cur in customVerbs)
            "\n\t <<cur>>";

        if (allRequiredVerbsDisclosed)
            "\bThat&rsquo;s it &mdash; every verb and every command phrasing
            you need to complete the story is shown above.
            If you ever get stuck and feel like the story is expecting
            you to think of something completely out of the blue, remember
            this: whatever it is you have to do, you can do it with one
            or more of the commands shown above. 
            Don&rsquo;t ever worry that you have to start trying lots of
            random commands to hit upon the magic phrasing, because
            everything you need is shown plainly above. ";
        else
            "\bMost of the verbs you&rsquo;ll need to complete the story are
            shown above; there might be a few additional commands you&rsquo;ll
            need from time to time as well, but they&rsquo;ll follow the same
            simple format as the commands above.";

        "\bA few of these commands deserve some more explanation.
        LOOK AROUND (which you abbreviate to LOOK, or even just L)
        shows the description of the current location.  You can use
        this if you want to refresh your memory of your character&rsquo;s
        surroundings.  INVENTORY (or just I) shows a list of everything
        your character is carrying. WAIT (or Z) just lets a little
        time pass in the story.";
    }

    showAbbrevChapter()
    {
        "\b<b>Abbreviations</b>
        \bYou&rsquo;ll probably use a few commands quite a lot, so to save
        typing, you can abbreviate some of the most frequently-used
        commands:

        \b
        \n\t LOOK AROUND can be shortened to LOOK, or merely L
        \n\t INVENTORY can be simply I
        \n\t GO NORTH can be written NORTH, or even just N (likewise E, W, S,
            NE, SE, NW, SW, U for UP and D for DOWN)
        \n\t LOOK AT THE DISK can be entered as EXAMINE DISK or simply X DISK
        \n\t WAIT can be shortened to Z
        <<conversationAbbr>>

        \b<b>A Few More Command Details</b>
        \bWhen you&rsquo;re entering commands, you can use capital or small
        letters in any mixture.  You can use words such as THE and A
        when they&rsquo;re appropriate, but you can omit them if you prefer. ";

        if (truncationLength != nil)
        {
            "You can abbreviate any word to its first <<
            spellInt(truncationLength)>> letters, but if you choose not
            to abbreviate, the story will pay attention to
            everything you actually type; this means, for example, that you
            can abbreviate SUPERCALIFRAGILISTICEXPIALIDOCIOUS to <<
            'SUPERCALIFRAGILISTICEXPIALIDOCIOUS'.substr(1, truncationLength)
            >> or <<
            'SUPERCALIFRAGILISTICEXPIALIDOCIOUS'.substr(1, truncationLength+2)
            >>, but not to <<
            'SUPERCALIFRAGILISTICEXPIALIDOCIOUS'.substr(1, truncationLength)
            >>SDF. ";
        }
    }

    showTravelChapter()
    {
        "\b<b>Travel</b>
        \bAt any given time in the story, your character is in a
        <q>location.</q>  The story describes the location when your
        character first enters, and again any time you type LOOK.
        Each location usually has a short name that&rsquo;s displayed just
        before its full description; the name is useful when drawing a map,
        and the short name can help jog your memory as you&rsquo;re finding
        your way around.

        \bEach location is a separate room, or a large outdoor area,
        or the like.  (Sometimes a single physical room is so large that
        it comprises several locations in the game, but that&rsquo;s fairly
        rare.)  For the most part, going to a location is as specific
        as you have to get about travel; once your character is in a
        location, the character can usually see and reach everything
        within the location, so you don&rsquo;t have to worry about where
        exactly your character is standing within the room.  Once in
        a while, you might find that something is out of reach, perhaps
        because it&rsquo;s on a high shelf or on the other side of a moat; in
        these cases, it&rsquo;s sometimes useful to be more specific about
        your character&rsquo;s location, such as by standing on something
        (STAND ON TABLE, for example).

        \bTraveling from one location to another is usually done using
        a direction command: GO NORTH, GO NORTHEAST, GO UP, and so on.
        (You can abbreviate the cardinal and vertical directions to one
        letter each &mdash; N, S, E, W, U, D &mdash; and the diagonal
        directions to two: NE, NW, SE, SW.)  The story should always
        tell you the directions that you can go when it describes a
        location, so you should never have to try all the unmentioned
        directions to see if they go anywhere.

        \bIn most cases, backtracking (by reversing the direction you
        took from one location to another) will take you back to where you
        started, although some passages might have turns.

        \bMost of the time, when the story describes a door or passageway,
        you won&rsquo;t need to open the door to go through the passage, as the
        story will do this for you.  Only when the story specifically
        states that a door is blocking your way will you usually have to
        deal with the door explicitly.";
    }

    showObjectsChapter()
    {
        "\b<b>Manipulating Objects</b>
        \bYou might find objects in the story that your character can
        carry or otherwise manipulate.  If you want to carry something,
        type TAKE and the object&rsquo;s name: TAKE BOOK.  If you want to drop
        something your character is carrying, DROP it.

        \bYou usually won&rsquo;t have to be very specific about exactly how
        your character is supposed to carry or hold something, so you
        shouldn&rsquo;t have to worry about which hand is holding which item
        or anything like that.  It might sometimes be useful to put
        one object inside or on top of another, though; for example,
        PUT BOOK IN SHOPPING BAG or PUT VASE ON TABLE.  If your character&rsquo;s
        hands get full, it might help to put some items being carried
        into a container, much as in real life you can carry more stuff
        if it&rsquo;s in a bag or a box.

        \bYou can often get a lot of extra information (and sometimes 
        vital clues) by examining objects, which you can do with the LOOK
        AT command (or, equivalently, EXAMINE, which you can abbreviate
        to simply X, as in X PAINTING).  Most experienced players get
        in the habit of examining everything in a new location right
        away. ";
    }

    showConversationChapter()
    {
        "\b<b>Interacting with Other Characters</b>
        \bYour character may encounter other people or creatures in the
        story.  You can sometimes interact with these characters.\b";

        // show the customizable conversation instructions
        conversationInstructions;
    }

    showTimeChapter()
    {
        "\b<b>Time</b>";

        if (isRealTime)
        {
            "\bTime passes in the story in response to the commands
            you type.  In addition, some parts of the story
            might unfold in <q>real time,</q> which means that things
            can happen even while you&rsquo;re thinking about your next move.

            \bIf you want to stop the clock while you&rsquo;re away from your
            computer for a moment (or you just need some time to think),
            you can type PAUSE.";
        }
        else
        {
            "\bTime passes in the story only in response to commands
            you type.  This means that nothing happens while the story
            is waiting for you to type something.  Each command takes
            about the same amount of time in the story.  If you
            specifically want to let some extra time pass within the
            story, because you think something is about to happen,
            you can type WAIT (or just Z). ";
        }
    }

    showSaveRestoreChapter()
    {
        "\b<b>Saving and Restoring</b>
        \bYou can save a snapshot of your current position in the story
        at any time, so that you can later restore the story to the
        same position.  The snapshot will be saved to a file on your
        computer&rsquo;s disk, and you can save as many different snapshots
        as you&rsquo;d like (to the extent you have space on your disk,
        anyway).\b";

        switch (crueltyLevel)
        {
        case 0:
            "In this story, your character will never be killed, and
            you&rsquo;ll never find yourself in a situation where it&rsquo;s impossible
            to complete the story.  Whatever happens to your character,
            you&rsquo;ll always be able to find a way to complete the story.
            So, unlike in many text games, you don&rsquo;t have to worry about
            saving positions to protect yourself against getting stuck
            in impossible situations.  Of course, you can still save
            as often as you&rsquo;d like, to suspend your session and return
            to it later, or to save positions that you think you might
            want to revisit.";
            break;

        case 1:
        case 2:
            "It might be possible for your character to be killed in
            the story, or for you to find your character in an impossible
            situation where you won&rsquo;t be able to complete the story.
            So, you should be sure to save your position
            <<crueltyLevel == 1 ? 'from time to time' : 'frequently'>>
            so that you won&rsquo;t have to go back too far if this should
            happen. ";

            if (crueltyLevel == 2)
                "(You should make a point of keeping all of your old saved
                positions, too, because you might not always realize
                immediately when a situation has become impossible.
                You might find at times that you need to go back further
                than just the last position that you <i>thought</i>
                was safe.)";

            break;
        }

        "\bTo save your position, type SAVE at the command prompt.
        The story will ask you for the name of a disk file to use
        to store a snapshot.  You&rsquo;ll have to specify a filename suitable
        for your computer system, and the disk will need enough free
        space to store the file; you&rsquo;ll be told if there&rsquo;s any problem
        saving the file.  You should use a filename that doesn&rsquo;t already
        exist on your machine, because the new file will overwrite any
        existing file with the same name.

        \bYou can restore a previously saved position by typing RESTORE
        at any prompt.  The story will ask you for the name of the file
        to restore.  After the computer reads the file, everything in
        the story will be exactly as it was when you saved that file.";

        "\b<b>Undo</b>
        \bEven if you haven&rsquo;t saved your position recently, you can
        usually take back your last few commands with the UNDO command.
        Each time you type UNDO, the story reverses the effect of one
        command, restoring the story as it was before you typed that
        command.  UNDO is limited to taking back the last few commands,
        so this isn&rsquo;t a substitute for SAVE/RESTORE, but it&rsquo;s very handy
        if you find your character unexpectedly in a dangerous situation,
        or you make a mistake you want to take back.";
    }

    showSpecialCmdChapter()
    {
        "\b<b>Some Other Special Commands</b>
        \bThe story understands a few other special commands that
        you might find useful.

        \bAGAIN (or just G): Repeats the last command.  (If your last input
        line had several commands, only the last single command on the line
        is repeated.)
        \bINVENTORY (or just I): Shows what your character is carrying.
        \bLOOK (or just L): Shows the full description of your
        character&rsquo;s current location.";

        if (gExitLister != nil)
            "\bEXITS: Shows the list of obvious exits from the current
            location.
            \bEXITS ON/OFF/STATUS/LOOK: Controls the way the game
            displays exit lists.  EXITS ON puts a list of
            exits in the status line and also lists exits in each room
            description.  EXITS OFF turns off both of these listings.
            EXITS STATUS turns on just the status line exit list, and
            EXITS ROOM turns on only the room description lists.";
        
#ifdef TADS309
        // if the exit lister module is active, mention the EXITS command
        if (gExitLister != nil)
            "\bEXITS: Shows the list of obvious exits from the current
            location.
            \bEXITS ON/OFF/STATUS/LOOK: Controls the way the game
            displays exit lists.  EXITS ON puts a list of
            exits in the status line and also lists exits in each room
            description.  EXITS OFF turns off both of these listings.
            EXITS STATUS turns on just the status line exit list, and
            EXITS ROOM turns on only the room description lists.";
#endif
        
        "\bOOPS: Corrects a single misspelled word in a command, without
        retyping the entire command.  You can only use OOPS immediately
        after the story tells you it didn&rsquo;t recognize a word in your
        previous command.  Type OOPS followed by the corrected word.
        \bQUIT (or just Q): Terminates the story.
        \bRESTART: Starts the story over from the beginning.
        \bRESTORE: Restores a position previously saved with SAVE.
        \bSAVE: Saves the current position in a disk file.
        \bSCRIPT: Starts making a transcript of your story session,
        saving all of the displayed text to a disk file, so that you
        can peruse it later or print it out.
        \bSCRIPT OFF: Ends a transcript that you started with SCRIPT. 
        \bUNDO: Takes back the last command. ";
#ifdef TADS309
        "\bSAVE DEFAULTS: Saves your current settings for things like
        NOTIFY, EXITS, and FOOTNOTES as defaults.  This means that your
        settings will be restored automatically the next time you start
        a new game, or RESTART this one.
        \bRESTORE DEFAULTS: Explicitly restores the option settings
        you previously saved with SAVE DEFAULTS. ";
#endif
    }
    
    showUnknownWordsChapter()
    {
        "\b<b>Unknown Words</b>
        \bThe story doesn&rsquo;t pretend to know every word in the English
        language.  The story might even occasionally use words in its
        own descriptions that it doesn&rsquo;t understand in commands.  If
        you type a command with a word the story doesn&rsquo;t know, the
        story will tell you which word it didn&rsquo;t recognize.  If the
        story doesn&rsquo;t know know a word for something it described, and
        it doesn&rsquo;t know any synonyms for that thing, you can probably
        assume that the object is just there as a detail of the setting,
        and isn&rsquo;t important to the story. ";
    }

    showAmbiguousCmdChapter()
    {
        "\b<b>Ambiguous Commands</b>
        \bIf you type a command that leaves out some important information,
        the story will try its best to figure out what you mean.  Whenever
        it&rsquo;s reasonably obvious from context what you mean, the story will
        make an assumption about the missing information and proceed with
        the command.  The story will point out what it&rsquo;s assuming in these
        cases, to avoid any confusion from a mismatch between the story&rsquo;s
        assumptions and yours.  For example:

        \b
        \n\t &gt;TIE THE ROPE
        \n\t (to the hook)
        \n\t The rope is now tied to the hook.  The end of the
        \n\t rope nearly reaches the floor of the pit below.
        
        \bIf the command is ambiguous enough that the story can&rsquo;t
        safely make an assumption, you&rsquo;ll be asked for more
        information.  You can answer these questions by typing the
        missing information.

        \b
        \n\t &gt;UNLOCK THE DOOR
        \n\t What do you want to unlock it with?
        \b
        \n\t &gt;KEY
        \n\t Which key do you mean, the gold key, or the silver key?
        \b
        \n\t &gt;GOLD
        \n\t Unlocked.

        \bIf the story asks you one of these questions, and you decide
        that you don&rsquo;t want to proceed with the original command after
        all, you can just type in a brand new command instead of answering
        the question.";
    }

    showAdvancedCmdChapter()
    {
        "\b<b>Advanced Command Formats</b>
        \bOnce you get comfortable with entering commands, you might
        be interested to know about some more complex command formats
        that the story will accept.  These advanced commands are all
        completely optional, because you can always do the same things
        with the simpler formats we&rsquo;ve talked about so far, but
        experienced players often like the advanced formats because
        they can save you a little typing.

        \b<b>Using Multiple Objects at Once</b>
        \bIn most commands, you can operate on multiple objects in
        a single command.  Use the word AND, or a comma, to separate
        one object from another:

        \b
        \n\t TAKE THE BOX, THE FLOPPY DISK, AND THE ROPE
        \n\t PUT DISK AND ROPE IN BOX
        \n\t DROP BOX AND ROPE
        
        \bYou can use the words ALL and EVERYTHING to refer to everything
        applicable to your command, and you can use EXCEPT or BUT
        (right after the word ALL) to exclude specific objects:

        \b
        \n\t TAKE ALL
        \n\t PUT ALL BUT DISK AND ROPE INTO BOX
        \n\t TAKE EVERYTHING OUT OF THE BOX
        \n\t TAKE ALL OFF SHELF

        \bALL refers to everything that makes sense for your command,
        excluding things inside other objects matching the ALL.  For
        example, if you&rsquo;re carrying a box and a rope, and the box contains
        a floppy disk, typing DROP ALL will drop the box and the rope,
        and the floppy will remain in the box.

        \b<b><q>It</q> and <q>Them</q></b>
        \bYou can use IT and THEM to refer to the last object or objects
        that you used in a command:

        \b
        \n\t TAKE THE BOX
        \n\t OPEN IT
        \n\t TAKE THE DISK AND THE ROPE
        \n\t PUT THEM IN THE BOX

        \b<b>Multiple Commands At Once</b>
        \bYou can put multiple commands on a single input line by
        separating the commands with periods or the word THEN, or
        with a comma or AND.  For example:

        \b
        \n\t TAKE THE DISK AND PUT IT IN THE BOX
        \n\t TAKE BOX. OPEN IT.
        \n\t UNLOCK THE DOOR WITH THE KEY. OPEN IT, THEN GO NORTH.

        \b If the story doesn&rsquo;t understand one of the commands, it will
        tell you what it couldn&rsquo;t understand, and ignore everything after
        that on the line.";
    }

    showTipsChapter()
    {
        "\b<b>A Few Tips</b>
        \bNow that you know the technical details of entering commands,
        you might be interested in some strategy pointers.  Here are
        a few techniques that experienced interactive fiction players use
        when approaching a story.

        \bEXAMINE everything, especially when you enter a new location
        for the first time.  Looking at objects will often reveal details
        that aren&rsquo;t mentioned in the broader description of the location.
        If examining an object mentions detailed parts of the object,
        examine them as well.

        \bMake a map, if the story has more than a few locations.  When
        you encounter a new location for the first time, note all of its
        exits; this will make it easy to see at a glance if there are any
        exits you haven&rsquo;t explored yet.  If you get stuck, you can scan
        your map for any unexplored areas, where you might find what
        you&rsquo;re looking for.

        \bIf the story doesn&rsquo;t recognize a word or any of its synonyms,
        the object you&rsquo;re trying to manipulate probably isn&rsquo;t important
        to the story.  If you try manipulating something, and the story
        responds with something like <q>that isn&rsquo;t important,</q> you
        can probably just ignore the object; it&rsquo;s most likely just there
        as scenery, to make the setting more detailed.

        \bIf you&rsquo;re trying to accomplish something, and nothing you do
        seems to work, pay attention to what&rsquo;s going wrong.  If everything
        you try is met with utter dismissal (<q>nothing happens</q> or
        <q>that&rsquo;s not something you can open</q>), you might simply be
        on the wrong track; step back and think about other ways of
        approaching the problem.  If the response is something more
        specific, it might be a clue. <q>The guard says <q>you can&rsquo;t
        open that here!</q>\ and snatches the box from your hands</q> &emdash;
        this might indicate that you have to get the guard to leave, or
        that you should take the box somewhere else before you open it,
        for example.

        \bIf you get completely stuck, you might try setting aside the
        current puzzle and working on a different problem for a while.
        You might even want to save your position and take a break from
        the game.  The solution to the problem that&rsquo;s been
        thwarting your progress might come to you in a flash of insight
        when you least expect it, and those moments of insight can be
        incredibly rewarding.  Some stories are best appreciated when
        played over a period of days, weeks, or even months; if you&rsquo;re
        enjoying the story, why rush through it?

        \bFinally, if all else fails, you can try asking for help.  A
        great place to go for hints is the Usenet newsgroup
        <a href='news:rec.games.int-fiction'>rec.games.int-fiction</a>. ";

        "\n";
    }
;


#ifdef INSTRUCTIONS_MENU

modify topInstructionsMenu
  addToContents(obj) {
    
    
    // START HACK
    if (!obj.ofKind(MenuLongTopicItem) ||
        obj.ofKind(InstructionsMenu) ||
        obj.hasBeenHackedByMsgSmart) {
    // END HACK
    
    
      if (obj.menuOrder == nil && !overrides(obj, MenuObject, &menuOrder)) {
        local maxVal;
        maxVal = nil;
        foreach (local cur in contents) {
          if (cur.menuOrder != nil
              && (maxVal == nil || cur.menuOrder > maxVal))
            maxVal = cur.menuOrder;
        }
        if (maxVal == nil)
          maxVal = 0;
        obj.menuOrder = maxVal;
      }
      contents += obj;
    
    
    // START HACK
    }
    // END HACK
    
    
  }
;

MenuLongTopicItem
  location = topInstructionsMenu
  isChapterMenu = true
  title = 'Introduction'
  heading = nil
  menuContents =
    "\b<b>Introduction</b>
    \bWelcome!  If you&rsquo;ve never played Interactive Fiction
    before, these instructions are designed to help you
    get started.  If you already know how to play this kind
    of game, you can probably skip the full instructions, but
    you might want to type ABOUT at the command prompt for a
    summary of the special features of this story.
    \b
    To make the instructions easier to navigate, they&rsquo;re
    broken up into chapters.  At the end of each chapter, just press
    <b><<curKeyList[M_SEL][1].toUpper()>></b> to proceed to
    the next chapter, or <b><<curKeyList[M_PREV][1].toUpper()>></b>
    to return to the chapter list. "
  hasBeenHackedByMsgSmart = true
;

#endif // INSTRUCTIONS_MENU

*/ // End commenting-out the entirety of part one

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
////  
////  PART 2:
////  Make any updates to the 3.0.8 messages for 3.0.9/3.0.12.
////  
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////

// 2019-05-24 GWB this section is not necessary anymore (compiling now for 
// 3.1.3 (versionInteger 3013)), but I've been testing with this included,
// and it doesn't seem to be doing any harm.

modify moduleAdv3
  versionInteger {
    local str = version;
    local nonNum1, nonNum2, nonNum3;
    local num1, num2, num3;
    // set nonNum1
    nonNum1 = rexSearch(notAnInteger, str);
    if (nonNum1 != nil) nonNum1 = nonNum1[1];
    // set nonNum2
    if (nonNum1 != nil)
      nonNum2 = rexSearch(notAnInteger, str, nonNum1 + 1);
    else
      nonNum2 = nil;
    if (nonNum2 != nil) nonNum2 = nonNum2[1];
    // set nonNum3
    if (nonNum2 != nil)
      nonNum3 = rexSearch(notAnInteger, str, nonNum2 + 1);
    else
      nonNum3 = nil;
    if (nonNum3 != nil) nonNum3 = nonNum3[1];
    // set num1
    if (!nonNum1)
      num1 = toInteger(str);
    else
      num1 = toInteger(str.substr(1, nonNum1 - 1));
    // set num2
    if (!nonNum1)
      num2 = 0;
    else if (!nonNum2)
      num2 = toInteger(str.substr(nonNum1 + 1));
    else
      num2 = toInteger(str.substr(nonNum1 + 1, nonNum2 - nonNum1 - 1));
    // set num3
    if (!nonNum2)
      num3 = 0;
    else if (!nonNum3)
      num3 = toInteger(str.substr(nonNum2 + 1));
    else
      num3 = toInteger(str.substr(nonNum2 + 1, nonNum3 - nonNum2 - 1));
    // return the proper value
    return (1000 * num1) + (100 * num2) + num3;
  }
  notAnInteger = static new RexPattern('[^0-9]')
;

modify libMessages
  // This fixes a bug whereby the library says "YOU HAVE DIED" even
  // if the game is in the third person. This is always preferable.
  finishDeathMsg = '{YOU/HE pc} {HAVE} DIED'
  // The following 3.0.9 change to noteAccepted (adding the parser tag)
  // is always preferable.
  noteAccepted = "<.parser>Noted.<./parser> "
  // Due to changes in the 3.0.10+ way of handling the "NOTE" verb,
  // noteWithoutScript needs to be modified for TADS 3.0.10+.
  noteWithoutScript {
    if (moduleAdv3.versionInteger >= 3010)
      "<.parser>Comment <b>not</b> recorded.<./parser> ";
    else
      inherited;
  }
  // exitsOnOffOkay is different for 3.0.9 and later because of
  // differences to the exits module for that version. Also, a different
  // number of arguments for 3.0.8 vs. 3.0.9+.
  exitsOnOffOkay([args]) {
    local stat, look;
    stat = args[1];
    if (args.length > 1) look = args[2];
    if (moduleAdv3.versionInteger >= 3009) {
      if (stat && look)
        "<.parser>The list of exits will now be shown in both
        the status line and in each room description.<./parser> ";
      else if (!stat && !look)
        "<.parser>The list of exits will no longer be shown in
        either the status line or room description.<./parser> ";
      else
        "<.parser>The list of exits <<stat ? 'will' : 'will not'>> be
        shown in the status line, and <<look ? 'will' : 'won&rsquo;t'>>
        be included in room descriptions.<./parser> ";
    }  
    else {
      inherited(stat);
    }
  }
;

// playerMessages.uniqueObjectRequired is different starting with 3.0.9.
// 3.0.8:  "<.parser>Multiple objects aren't allowed with that command.<./parser> "
// 3.0.9+: "<.parser>You can't use multiple objects there.<./parser> "
// But I don't care so much about the wording of this command.
// So I'm not making any changes.

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
////  
////  PART 3:
////  Make any desired changes to the standard library messages.
////  Add contractions, change "appear" to "seem", or just rewrite
////  messages based on personal taste.
////  
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////

modify libMessages //: MessageHelper
//    whomPronoun = 'whom'
//    offerOopsNote = true
//    commandLookAround = 'look around'
//    commandFullScore = 'full score'
//    announceRemappedAction(action) {
//        return '\n<.assume>' + action.getParticiplePhrase() + '<./assume>\n';
//    }
//    announceImplicitAction(action, ctx) {
//        return ctx.buildImplicitAnnouncement(action.getImplicitPhrase(ctx));
//    }
//    silentImplicitAction(action, ctx) { return ''; }
//    announceMoveToBag(action, ctx) {
//        return ctx.buildImplicitAnnouncement(
//            action.getImplicitPhrase(ctx) + ' to make room');
//    }
//    showCredit(name, byline) { "<<name>> <<byline>>"; }
//    showVersion(name, version) { "<<name>> version <<version>>"; }
//    noAboutInfo = "<.parser>This story has no ABOUT
//                   information.<./parser> "
//    showListState(state) { " (<<state>>)"; }
//    allInSameListState(lst, stateName) { 
//        " (<<lst.length() == 2 ? 'both' : 'all'>> <<stateName>>)";
//    }
//    distantThingDesc(obj) {
//        gMessageParams(obj);
//        "{It's obj} too far away to make out any detail. ";
//    }
//    obscuredThingDesc(obj, obs) {
//        gMessageParams(obj, obs);
//        "{You/he} can&rsquo;t make out any detail through {the obs/him}. ";
//    }
//    distantThingSoundDesc(obj)
//        { "{You/he} can&rsquo;t hear any detail from this distance. "; }
//    obscuredThingSoundDesc(obj, obs) {
//        gMessageParams(obj, obs);
//        "{You/he} can&rsquo;t hear any detail through {the obs/him}. ";
//    }
//    distantThingSmellDesc(obj)
//        { "{You/he} can&rsquo;t smell much at this distance. "; }
//    obscuredThingSmellDesc(obj, obs) {
//        gMessageParams(obj, obs);
//        "{You/he} can&rsquo;t smell much through {the obs/him}. ";
//    }
//    thingTasteDesc(obj)
//        { "{You/he} taste{s} nothing out of the ordinary. "; }
//    thingFeelDesc(obj)
//        { "{You/he} feel{s} nothing out of the ordinary. "; }
//
//    obscuredReadDesc(obj) {
//        gMessageParams(obj);
//        "{You/he} can&rsquo;t see {that obj/him} well enough to read {it/him}. ";
//    }
//    dimReadDesc(obj) {
//        gMessageParams(obj);
//        "There&rsquo;s not enough light to read {that obj/him}. ";
//    }
//    litMatchDesc(obj) { "\^<<obj.nameIs>> lit. "; }
//    unlitMatchDesc(obj) { "\^<<obj.nameIs>> an ordinary match. "; }
//    litCandleDesc(obj) { "\^<<obj.nameIs>> lit. "; }
//    putDestContainer(obj) { return 'into ' + obj.theNameObj; }
//    putDestSurface(obj) { return 'onto ' + obj.theNameObj; }
//    putDestUnder(obj) { return 'under ' + obj.theNameObj; }
//    putDestBehind(obj) { return 'behind ' + obj.theNameObj; }
//    putDestFloor(obj) { return 'to ' + obj.theNameObj; }
//    listSepMiddle = ", "
//    listSepTwo = " and "
//    listSepEnd = ", and "
//    longListSepMiddle = "; "
//    longListSepTwo = ", and "
//    longListSepEnd = "; and "
//    showScoreMessage(points, maxPoints, turns) {
//        "In <<turns>> move<<turns == 1 ? '' : 's'>>, you have
//        scored <<points>> of a possible <<maxPoints>> point<<
//          maxPoints == 1 ? '' : 's'>>. ";
//    }
//    showScoreNoMaxMessage(points, turns) {
//        "In <<turns>> move<<turns == 1 ? '' : 's'>>, you have
//        scored <<points>> point<<points == 1 ? '' : 's'>>. ";
//    }
//    showScoreRankMessage(msg) { "This makes you <<msg>>. "; }
//    showFullScorePrefix = "Your score consists of:"
//    fullScoreItemPoints(points) {
//        "<<points>> point<<points == 1 ? '' : 's'>> for ";
//    }
//    firstScoreChange(delta) {
//        "<.commandsep><.notification><<
//            basicScoreChange(delta)>><./notification>
//        \n<.notification>If you&rsquo;d prefer not to be notified about
//        score changes in the future, type <<
//        aHref('notify off', 'NOTIFY OFF', 'Turn off score notifications')
//        >>.<./notification> ";
//    }
//    scoreChange(delta) {
//        "<.commandsep><.notification><<
//        basicScoreChange(delta)>><./notification> ";
//    }
//    basicScoreChange(delta) {
//        "Your <<aHref(commandFullScore, 'score', 'Show full score')>>
//        has just <<delta > 0 ? 'in' : 'de'>>creased by
//        <<spellInt(delta > 0 ? delta : -delta)>>
//        point<<delta is in (1, -1) ? '' : 's'>>.";
//    }
//    footnoteRef(num) {
//        local str;
//        str = '<sup>[<a href="footnote ' + num + '"><.a>';
//        str += num;
//        str += '<./a></a>]</sup>';
//        return str;
//    }
//    firstFootnote() {
//        "<.commandsep><.notification>A number in [square brackets] like
//        the one above refers to a footnote, which you can read by typing
//        FOOTNOTE followed by the number: 
//        <<aHref('footnote 1', 'FOOTNOTE 1', 'Show footnote [1]')>>,
//        for example.  Footnotes usually contain added background information
//        that might be interesting but isn&rsquo;t essential to the story.
//        If you&rsquo;d prefer not to see footnotes at all,
//        you can control their appearance by typing
//        <<aHref('footnotes', 'FOOTNOTES',
//                'Control footnote appearance')>>.<./notification> ";
//    }
//    noSuchFootnote(num) {
//        "<.parser>The story has never referred to any such
//        footnote.<./parser> ";
//    }
//    showFootnoteStatus(stat) {
//        "The current setting is FOOTNOTES ";
//        switch(stat)
//        {
//        case FootnotesOff:
//            "OFF, which hides all footnote references.
//            Type <<aHref('footnotes medium', 'FOOTNOTES MEDIUM',
//                         'Set footnotes to Medium')>> to
//            show references to footnotes except those you&rsquo;ve
//            already seen, or <<aHref('footnotes full', 'FOOTNOTES FULL',
//                                     'Set footnotes to Full')>>
//            to show all footnote references. ";
//            break;
//        case FootnotesMedium:
//            "MEDIUM, which shows references to unread footnotes, but
//            hides references to those you&rsquo;ve already read.  Type
//            <<aHref('footnotes off', 'FOOTNOTES OFF',
//                    'Turn off footnotes')>> to hide
//            footnote references entirely, or <<aHref(
//                'footnotes full', 'FOOTNOTES FULL',
//                'Set footnotes to Full')>> to show every reference, even to
//            notes you&rsquo;ve already read. ";
//            break;
//        case FootnotesFull:
//            "FULL, which shows every footnote reference, even to
//            notes you&rsquo;ve already read.  Type <<aHref('footnotes medium',
//            'FOOTNOTES MEDIUM', 'Set footnotes to Medium')>> to show
//            only references to notes you
//            haven&rsquo;t yet read, or <<aHref('footnotes off', 'FOOTNOTES OFF',
//                'Turn off footnotes')>>
//            to hide footnote references entirely. ";
//            break;
//        }
//    }
//    acknowledgeFootnoteStatus(stat) {
//        "<.parser>The setting is now FOOTNOTES <<
//        stat == FootnotesOff ? 'OFF'
//        : stat == FootnotesMedium ? 'MEDIUM'
//        : 'FULL' >>.<./parser> ";
//    }
//    mainCommandPrompt(which) { "\b&gt;"; }
//    emptyCommandResponse = "<.parser>I beg your pardon?<./parser> "
//    invalidCommandToken(ch) {
//        "<.parser>The story doesn&rsquo;t know how to use the character
//        &lsquo;<<ch>>&rsquo; in a command.<./parser> ";
//    }
//    commandResultsPrefix = '<.p0>'
//    commandInterruptionPrefix = '<.p>'
//    commandResultsSeparator = '<.p>'
//    complexResultsSeparator = '<.p>'
//    internalResultsSeparator = '<.p>'
//    commandResultsSuffix = ''
//    commandResultsEmpty = 'Nothing obvious happens.<.p>'
//    intraCommandSeparator = '<.p>'
//    smellDescSeparator() {
//        "<.p>";
//    }
//    soundDescSeparator() {
//        "<.p>";
//    }
//    cannotTalkTo(targetActor, issuingActor) {
//        "\^<<targetActor.nameIs>> not something <<issuingActor.itNom>>
//        can talk to. ";
//    }
//    alreadyTalkingTo(actor, greeter) {
//        "\^<<greeter.theName>> already <<greeter.verbToHave>>
//        <<actor.theNamePossAdj>> attention. ";
//    }
//    noTopicsNotTalking = "<.parser>{You're} not currently talking
//                          to anyone.<./parser> "
//    oopsNote() {
//        if (offerOopsNote) {
//            "<.commandsep><.notification>If this was an accidental
//            misspelling, you can correct it by typing OOPS followed by the
//            corrected word now.  Any time the story points out an unknown
//            word, you can correct a misspelling using OOPS as your next
//            command.<./notification> ";
//            libMessages.offerOopsNote = nil;
//        }
//    }
//    oopsOutOfContext = "<.parser>You can only use OOPS to correct
//        a misspelling immediately after the story points out a word
//        it doesn&rsquo;t know.<./parser> "
//    oopsMissingWord = "<.parser>To use OOPS to correct a misspelling,
//        put the corrected word after OOPS, as in OOPS BOOK.<./parser> "
//    acknowledgeVerboseMode(verbose) {
//        if (verbose)
//            "<.parser>VERBOSE mode is now selected.<./parser> ";
//        else
//            "<.parser>TERSE mode is now selected.<./parser> ";
//    }
//    showNotifyStatus(stat) {
//        "<.parser>Score notifications are
//        currently <<stat ? 'on' : 'off'>>.<./parser> ";
//    }
//    acknowledgeNotifyStatus(stat) {
//        "<.parser>Score notifications are now
//        <<stat ? 'on' : 'off'>>.<./parser> ";
//    }
//    announceMultiActionObject(obj, whichObj, action) {
//        return '\n<.announceObj>' + obj.name + ':<./announceObj> ';
//    }
//    announceAmbigActionObject(obj, whichObj, action) {
//        return '<.assume>' + obj.theName + '<./assume>\n';
//    }
//    announceDefaultObject(obj, whichObj, action, resolvedAllObjects) {
//        return '<.assume>'
//            + action.announceDefaultObject(obj, whichObj, resolvedAllObjects)
//            + '<./assume>\n';
//    }
//    noCommandForAgain() {
//        "<.parser>There&rsquo;s nothing to repeat.<./parser> ";
//    }
//    againCannotChangeActor() {
//        "<.parser>To repeat a command like <q>turtle, go north,</q>
//        just say <q>again,</q> not <q>turtle, again.</q><./parser> ";
//    }
//    againCannotTalkToTarget(issuer, target) {
//        "\^<<issuer.theName>> cannot repeat that command. ";
//    }
//    againNotPossible(issuer) {
//        "That command cannot be repeated now. ";
//    }
//    systemActionToNPC() {
//        "<.parser>This command cannot be directed to another
//        character in the story.<./parser> ";
//    }
//    confirmQuit() {
//        "Do you really want to quit?\ (<<aHref('y', 'Y', 'Confirm quitting')
//        >> is affirmative) >\ ";
//    }
//    okayQuitting() { }
//    notTerminating() {
//        "<.parser>Continuing the story.<./parser> ";
//    }
//    confirmRestart() {
//        "Do you really want to start over?\ (<<aHref('Y', 'Y',
//        'Confirm restart')>> is affirmative) >\ ";
//    }
//    notRestarting() { "<.parser>Continuing the story.<./parser> "; }
//    showFinishMsg(msg) { "<.p>*** <<msg>>\ ***<.p>"; }
//    finishDeathMsg = 'YOU HAVE DIED'
//    finishVictoryMsg = 'YOU HAVE WON'
//    finishFailureMsg = 'YOU HAVE FAILED'
//    finishGameOverMsg = 'GAME OVER'
//    getSavePrompt =
//        'Please select a file in which to save the current position'
//    getRestorePrompt = 'Please select the saved position file to restore'
//    saveOkay() { "<.parser>Saved.<./parser> "; }
//    saveCanceled() { "<.parser>Canceled.<./parser> "; }
//    saveFailed(exc) {
//        "<.parser>Failed; your computer might be running low
//        on disk space, or you might not have the necessary permissions
//        to write this file.<./parser> ";
//    }
//    noteMainRestore() { "<.parser>Restoring saved game...<./parser>\n"; }
//    restoreOkay() { "<.parser>Restored.<./parser> "; }
//    restoreCanceled() { "<.parser>Canceled.<./parser> "; }
//    restoreInvalidFile() {
//        "<.parser>Failed: this is not a valid saved
//        position file.<./parser> ";
//    }
//    restoreCorruptedFile() {
//        "<.parser>Failed: this saved state file appears to be
//        corrupted.  This can occur if the file was modified by another
//        program, or the file was copied between computers in a non-binary
//        transfer mode, or the physical media storing the file were
//        damaged.<./parser> ";
//    }
//    restoreInvalidMatch() {
//        "<.parser>Failed: the file was not saved by this
//        story (or was saved by an incompatible version of
//        the story).<./parser> ";
//    }
//    restoreFailed(exc) {
//        "<.parser>Failed: the position could not be
//        restored.<./parser> ";
//    }
//    filePromptFailed() {
//        "<.parser>A system error occurred asking for a filename.
//        Your computer might be running low on memory, or might have a
//        configuration problem.<./parser> ";
//    }
//    pausePrompt() {
//        "<.parser>The story is now paused.  Please press
//        the space bar when you are ready to resume the story, or
//        press the &lsquo;S&rsquo; key to save the current position.<./parser><.p>";
//    }
//    pauseSaving() {
//        "<.parser>Saving the story...<./parser><.p>";
//    }
//    pauseEnded() {
//        "<.parser>Resuming the story.<./parser> ";
//    }
//    inputScriptOkay(fname) {
//        "<.parser>Reading commands from <q><<fname.htmlify()
//         >></q>...<./parser>\n ";
//    }
//    getScriptingPrompt = 'Please select a name for the new script file'
//    scriptingOkay() {
//        "<.parser>Text will now be saved to the script file.
//        Type <<aHref('script off', 'SCRIPT OFF', 'Turn off scripting')>> to
//        discontinue scripting.<./parser> ";
//    }
//    scriptingCanceled = "<.parser>Canceled.<./parser> "
//    scriptOffOkay = "<.parser>Scripting ended.<./parser> "
//    scriptOffIgnored = "<.parser>No script is currently being
//                        recorded.<./parser> "
//    getRecordingPrompt = 'Please select a name for the new command log file'
//    recordingOkay = "<.parser>Commands will now be recorded.  Type
//                     <<aHref('record off', 'RECORD OFF',
//                             'Turn off recording')>>
//                     to stop recording commands.<.parser> "
//    recordingCanceled = "<.parser>Canceled.<./parser> "
//    recordOffOkay = "<.parser>Command recording ended.<./parser> "
//    recordOffIgnored = "<.parser>No command recording is currently being
//                        made.<./parser> "
//    getReplayPrompt = 'Please select the command log file to replay'
//    replayCanceled = "<.parser>Canceled.<./parser> "
//    undoOkay(actor, cmd) {
//        "<.parser>Taking back one turn: <q>";
//        if (actor != nil)
//            "<<actor>>, ";
//        "<<cmd>></q>.<./parser><.p>";
//    }
//    undoFailed() {
//        "<.parser>No more undo information is
//        available.<./parser> ";
//    }
//    noteAccepted = "Noted. "
//    noteWithoutScript = "<.p><.notification>Note that the transcript isn&rsquo;t
//        currently being recorded.  NOTE is usually used to provide feedback
//        to the author by putting a comment in the transcript, so it&rsquo;s most
//        useful when you&rsquo;re saving the transcript to a file.  If you want
//        to start saving the transcript, please type <<
//          aHref('script', 'SCRIPT', 'Begin saving the transcript')
//          >>.<./notification> "
//    invalidFinishOption(resp) {
//        "\bThat isn&rsquo;t one of the options. ";
//    }
//    exitsOnOffOkay(stat) {
//        "<.parser>The list of exits will <<
//        stat ? 'now' : 'no longer'>> be
//        displayed in each room description.<./parser> ";
//    }
//    explainExitsOnOff =
//        "<.p><.notification>You can control whether or not the exit list
//        is automatically displayed in each room description by typing
//        <<aHref('exits on', 'EXITS ON', 'Activate exit display')>> or
//        <<aHref('exits off', 'EXITS OFF', 'Turn off exit display'
//               )>>.<./notification> "
//    hintsDisabled = '<.parser>Hints are now disabled.<./parser> '
//    sorryHintsDisabled = '<.parser>Sorry, but hints have been disabled
//                          for this session, as you requested.  If you&rsquo;ve
//                          changed your mind, you&rsquo;ll have to save your
//                          current position, exit the TADS interpreter,
//                          and start a new interpreter session.<./parser> '
//    hintsNotPresent = '<.parser>Sorry, this story doesn&rsquo;t
//                       have any built-in hints.<./parser> '
//    currentlyNoHints = '<.parser>Sorry, no hints are currently available.
//                        Please check back later.<./parser> '
//    showHintWarning =
//       "<.notification>Warning: Some people don&rsquo;t like built-in hints,
//       since the temptation to ask for help prematurely can become
//       overwhelming when hints are so close at hand.  If you&rsquo;re worried
//       that your willpower won&rsquo;t hold up, you can disable hints for the
//       rest of this session by typing <<aHref('hints off', 'HINTS OFF')
//       >>.  If you still want to see the hints now, type
//       <<aHref('hint', 'HINT')>>.<./notification> "
//    hintsDone = '<.parser>Done.<./parser> '
//    commandNotPresent = "<.parser>That command isn&rsquo;t needed
//                         in this story.<./parser> "
//    scoreNotPresent = "<.parser>This story doesn&rsquo;t use
//                       scoring.<./parser> "
//    mentionFullScore = "<.p><.notification>To see a detailed accounting
//        of your score, type <<
//          aHref('full score', 'FULL SCORE') >>.<./notification> "
//    menuKeyList = [
//                   ['q'],
//                   ['p', '[left]', '[bksp]', '[esc]'],
//                   ['u', '[up]'],
//                   ['d', '[down]'],
//                   ['ENTER', '\n', '[right]', ' ']
//                  ]
//    prevMenuLink = '<font size=-1>Previous</font>'
//    nextMenuTopicLink = '<font size=-1>Next</font>'
//    textMenuMainPrompt(keylist) {
//        "\bSelect a topic number, or press &lsquo;<<
//        keylist[M_PREV][1]>>&rsquo; for the previous
//        menu or &lsquo;<<keylist[M_QUIT][1]>>&rsquo; to quit:\ ";
//    }
//    textMenuTopicPrompt() {
//        "\bPress the space bar to display the next line,
//        &lsquo;<b>P</b>&rsquo; to go to the previous menu, or
//        &lsquo;<b>Q</b>&rsquo; to quit.\b";
//    }
//    menuTopicProgress(cur, tot) { " [<<cur>>/<<tot>>]"; }
//    menuTopicListEnd = '[The End]'
//    menuLongTopicEnd = '[The End]'
//    menuInstructions(keylist, prevLink) {
//        "<tab align=right ><b>\^<<keylist[M_QUIT][1]>></b>=Quit <b>\^<<
//        keylist[M_PREV][1]>></b>=Previous Menu<br>
//        <<prevLink != nil ? aHrefAlt('previous', prevLink, '') : ''>>
//        <tab align=right ><b>\^<<keylist[M_UP][1]>></b>=Up <b>\^<<
//        keylist[M_DOWN][1]>></b>=Down <b>\^<<
//        keylist[M_SEL][1]>></b>=Select<br>";
//    }
//    menuNextChapter(keylist, title, hrefNext, hrefUp) {
//        "Next: <a href='<<hrefNext>>'><<title>></a>;
//        <b>\^<<keylist[M_PREV][1]>></b>=<a href='<<hrefUp>>'>Menu</a>";
//    }
//    cannotReachObject(obj) {
//        "{You/he} cannot reach <<obj.theNameObj>>. ";
//    }
//    cannotReachContents(obj, loc) {
//        gMessageParams(obj, loc);
//        return '{You/he} cannot reach {the obj/him} through {the loc/him}. ';
//    }
//    cannotReachOutside(obj, loc) {
//        gMessageParams(obj, loc);
//        return '{You/he} cannot reach {the obj/him} through {the loc/him}. ';
//    }
//    soundIsFromWithin(obj, loc) {
//        "\^<<obj.theName>> appear<<obj.verbEndingS>> to be
//        coming from inside <<loc.theNameObj>>. ";
//    }
//    soundIsFromWithout(obj, loc) {
//        "\^<<obj.theName>> appear<<obj.verbEndingS>> to be
//        coming from outside <<loc.theNameObj>>. ";
//    }
//    smellIsFromWithin(obj, loc) {
//        "\^<<obj.theName>> appear<<obj.verbEndingS>> to be
//        coming from inside <<loc.theNameObj>>. ";
//    }
//    smellIsFromWithout(obj, loc) {
//        "\^<<obj.theName>> appear<<obj.verbEndingS>> to be
//        coming from outside <<loc.theNameObj>>. ";
//    }
//    pcDesc(actor) {
//        "\^<<actor.theName>> look<<actor.verbEndingS>> the same
//        as usual. ";
//    }
//    roomActorStatus(actor) {
//        if (actor.posture != standing)
//            " (<<actor.posture.participle>>)";
//    }
//    actorInRoomStatus(actor, room)
//        { " (<<actor.posture.participle>> <<room.actorInName>>)"; }
//    roomDarkName = 'In the dark'
//    roomDarkDesc = "It&rsquo;s pitch black. "
//    roomActorHereDesc(actor) {
//        "\^<<actor.nameIs>> <<actor.posture.participle>> here. ";
//    }
//    roomActorThereDesc(actor) {
//        "\^<<actor.nameIs>> <<actor.posture.participle>> nearby. ";
//    }
//    actorInRoom(actor, cont) {
//        "\^<<actor.nameIs>> <<actor.posture.participle>>
//        <<cont.actorInName>>. ";
//    }
//    actorInRoomPosture(actor, room) {
//        "\^<<actor.itIs>> <<actor.posture.participle>>
//        <<room.actorInName>>. ";
//    }
//    roomActorPostureDesc(actor) {
//        if (actor.posture != standing)
//            "\^<<actor.itIs>> <<actor.posture.participle>>. ";
//    }
//    actorInRemoteRoom(actor, room, pov) {
//        "\^<<actor.nameIs>> <<actor.posture.participle>>
//        <<room.inRoomName(pov)>>. ";
//    }
//    actorInRemoteNestedRoom(actor, inner, outer, pov) {
//        "\^<<actor.nameIs>> <<outer.inRoomName(pov)>>,
//        <<actor.posture.participle>> <<inner.actorInName>>. ";
//    }
//    actorInGroupPrefix(posture, cont, lst) { "\^"; }
//    actorInGroupSuffix(posture, cont, lst) {
//        " <<lst.length() == 1 ? 'is' : 'are'>> <<posture.participle>>
//        <<cont.actorInName>>. ";
//    }
//    actorInRemoteGroupPrefix(pov, posture, cont, remote, lst) { "\^"; }
//    actorInRemoteGroupSuffix(pov, posture, cont, remote, lst) {
//        " <<lst.length() == 1 ? 'is' : 'are'>> <<remote.inRoomName(pov)>>,
//        <<posture.participle>> <<cont.actorInName>>. ";
//    }
//    actorHereGroupPrefix(posture, lst) { "\^"; }
//    actorHereGroupSuffix(posture, lst) {
//        " <<lst.length() == 1 ? 'is' : 'are'>>
//        <<posture.participle>> here. ";
//    }
//    actorThereGroupPrefix(pov, posture, remote, lst) { "\^"; }
//    actorThereGroupSuffix(pov, posture, remote, lst) {
//        " <<lst.length() == 1 ? 'is' : 'are'>> <<posture.participle>>
//        <<remote.inRoomName(pov)>>. ";
//    }
//    sayArriving(traveler) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerLocName>>. ";
//    }
//    sayDeparting(traveler) {
//        "\^<<traveler.travelerName(nil)>> leave<<traveler.verbEndingS>>
//        <<traveler.travelerLocName>>. ";
//    }
//    sayArrivingLocally(traveler, dest) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerLocName>>. ";
//    }
//    sayArrivingDir(traveler, dirName) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> from the <<dirName>>. ";
//    }
//    sayDepartingDir(traveler, dirName) {
//        local nm = traveler.travelerRemoteLocName;
//        "\^<<traveler.travelerName(nil)>> leave<<traveler.verbEndingS>>
//        to the <<dirName>><<nm != '' ? ' from ' + nm : ''>>. ";
//    }
//    sayArrivingShipDir(traveler, dirName) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> from <<dirName>>. ";
//    }
//    sayDepartingShipDir(traveler, dirName) {
//        local nm = traveler.travelerRemoteLocName;
//        
//        "\^<<traveler.travelerName(nil)>> leave<<traveler.verbEndingS>>
//        to <<dirName>><<nm != '' ? ' from ' + nm : ''>>. ";
//    }
//    sayDepartingAft(traveler) {
//        local nm = traveler.travelerRemoteLocName;
//        
//        "\^<<traveler.travelerName(nil)>> go<<traveler.verbEndingEs>>
//        aft<<nm != '' ? ' from ' + nm : ''>>. ";
//    }
//    sayDepartingFore(traveler) {
//        local nm = traveler.travelerRemoteLocName;
//        "\^<<traveler.travelerName(nil)>> go<<traveler.verbEndingEs>>
//        forward<<nm != '' ? ' from ' + nm : ''>>. ";
//    }
//    notOnboardShip = "That direction isn&rsquo;t meaningful here. "
//    sayDepartingThroughPassage(traveler, passage) {
//        "\^<<traveler.travelerName(nil)>> leave<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> through <<passage.theNameObj>>. ";
//    }
//    sayArrivingThroughPassage(traveler, passage) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> through <<passage.theNameObj>>. ";
//    }
//    sayDepartingViaPath(traveler, passage) {
//        "\^<<traveler.travelerName(nil)>> leave<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> via <<passage.theNameObj>>. ";
//    }
//    sayArrivingViaPath(traveler, passage) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> via <<passage.theNameObj>>. ";
//    }
//    sayDepartingUpStairs(traveler, stairs) {
//        "\^<<traveler.travelerName(nil)>> go<<traveler.verbEndingEs>>
//        up <<stairs.theNameObj>>. ";
//    }
//    sayDepartingDownStairs(traveler, stairs) {
//        "\^<<traveler.travelerName(nil)>> go<<traveler.verbEndingEs>>
//        down <<stairs.theNameObj>>. ";
//    }
//    sayArrivingUpStairs(traveler, stairs) {
//        local nm = traveler.travelerRemoteLocName;
//
//        "\^<<traveler.travelerName(true)>> come<<traveler.verbEndingS>>
//        up <<stairs.theNameObj>><<nm != '' ? ' to ' + nm : ''>>. ";
//    }
//    sayArrivingDownStairs(traveler, stairs) {
//        local nm = traveler.travelerRemoteLocName;
//
//        "\^<<traveler.travelerName(true)>> come<<traveler.verbEndingS>>
//        down <<stairs.theNameObj>><<nm != '' ? ' to ' + nm : ''>>. ";
//    }
//    sayDepartingWith(traveler, lead) {
//        "\^<<traveler.travelerName(nil)>> come<<traveler.verbEndingS>>
//        with <<lead.theNameObj>>. ";
//    }
//    sayDepartingWithGuide(guide, lead) {
//        "\^<<lead.theName>> let<<lead.verbEndingS>>
//        <<guide.theNameObj>> lead the way. ";
//    }
//    sayOpenDoorRemotely(door, stat) {
//        "Someone <<stat ? 'open' : 'close'>>s <<door.theNameObj>> from
//        the other side. ";
//    }
//    openMsg(obj) { return 'open'; }
//    closedMsg(obj) { return 'closed'; }
//    currentlyOpen = '{It\'s dobj} currently open. '
//    currentlyClosed = '{It\'s dobj} currently closed. '
//    openStatusMsg(obj) { return obj.itIsContraction + ' ' + obj.openDesc; }
//    lockedMsg(obj) { return 'locked'; }
//    unlockedMsg(obj) { return 'unlocked'; }
//    currentlyLocked = '{It\'s dobj} currently locked. '
//    currentlyUnlocked = '{It\'s dobj} currently unlocked. '
//    onMsg(obj) { return 'on'; }
//    offMsg(obj) { return 'off'; }
//    matchBurnedOut(obj) {
//        gMessageParams(obj);
//        "{The obj/he} finish{es} burning, and disappear{s} into a
//        cloud of ash. ";
//    }
//    candleBurnedOut(obj) {
//        gMessageParams(obj);
//        "{The obj/he} burn{s} down too far to stay lit, and go{es} out. ";
//    }
//    objBurnedOut(obj) {
//        gMessageParams(obj);
//        "{The obj/he} go{es} out. ";
//    }
;

modify playerMessages //: libMessages
//    commandNotUnderstood(actor) {
//        "<.parser>The story doesn&rsquo;t understand that command.<./parser> ";
//    }
//    specialTopicInactive(actor) {
//        "<.parser>That command can&rsquo;t be used right now.<./parser> ";
//    }
////    // 2019-05-18 GWB: I want to be extra careful about replacing noMatch(). 
////    // Somehow, an incorrectly parameterized version of this function...
////    // noMatch(actor, txt) // <-- WRONG!
////    // ...rather than...
////    // noMatch(actor, action, txt)
////    // ...got into my code, either from an old version of TADS 3 or from
////    // me making a mistake. 
////    noMatch(actor, action, txt) {
////        "{You/he} see{s} no <<txt>> here. ";
////    }
//    allNotAllowed(actor) {
//        "<.parser><q>All</q> cannot be used with that verb.<./parser> ";
//    }
//    noMatchForAll(actor) {
//        "<.parser>{You/he} see{s} nothing to use
//        for <q>all</q> here.<./parser> ";
//    }
//    noMatchForAllBut(actor) {
//        "<.parser>{You/he} see{s} nothing else here.<./parser> ";
//    }
//    noMatchForListBut(actor) { noMatchForAllBut(actor); }
//    noMatchForPronoun(actor, typ, pronounWord) {
//        "<.parser>The word <q><<pronounWord>></q> doesn&rsquo;t refer to
//        anything right now.<./parser> ";
//    }
//    reflexiveNotAllowed(actor, typ, pronounWord) {
//        "<.parser>The story doesn&rsquo;t understand how to use the word
//        <q><<pronounWord>></q> like that.<./parser> ";
//    }
//    wrongReflexive(actor, typ, pronounWord) {
//        "<.parser>The story doesn&rsquo;t understand what the
//        word <q><<pronounWord>></q> refers to.<./parser> ";
//    }
//    noMatchForPossessive(actor, owner, txt) {
//        "<.parser>\^<<owner.theName>> do<<owner.verbEndingEs>>
//        not appear to have any such thing.<./parser> ";
//    }
//    noMatchForLocation(actor, loc, txt) {
//        "<.parser>\^<<actor.nameVerb('see')>> no 
//        <<loc.childInName(txt)>>.<./parser> ";
//    }
//    nothingInLocation(actor, loc) {
//        "<.parser>\^<<actor.nameVerb('see')>> 
//        <<loc.childInName('nothing unusual')>>.<./parser> ";
//    }
//    noMatchDisambig(actor, origPhrase, disambigResponse) {
//        "<.parser>That was not one of the choices. ";
//    }
//    emptyNounPhrase(actor) {
//        "<.parser>You seem to have left out some words.<./parser> ";
//    }
//    zeroQuantity(actor, txt) {
//        "<.parser>\^<<actor.theName>> can&rsquo;t do that to zero of
//        something.<./parser> ";
//    }
//    insufficientQuantity(actor, txt, matchList, requiredNum) {
//        "<.parser>\^<<actor.nameVerb('do')>>n&rsquo;t see that many <<txt>>
//        here.<./parser> ";
//    }
//    uniqueObjectRequired(actor, txt, matchList) {
//        "<.parser>Multiple objects aren&rsquo;t allowed with that
//        command.<./parser> ";
//    }
//    singleObjectRequired(actor, txt) {
//        "<.parser>Multiple objects aren&rsquo;t allowed with that
//        command.<./parser> ";
//    }
//    disambigOrdinalOutOfRange(actor, ordinalWord, originalText) {
//        "<.parser>There were not that many choices. ";
//    }
//    askDisambig(actor, originalText, matchList, fullMatchList,
//                requiredNum, askingAgain, dist)
//    {
//        reportQuestion('');
//        if (!askingAgain)
//            "<.parser>";
//        if (requiredNum == 1) {
//            if (askingAgain)
//                "Which did you mean,
//                <<askDisambigList(matchList, fullMatchList, nil, dist)>>?";
//            else
//                "Which <<originalText>> do you mean,
//                <<askDisambigList(matchList, fullMatchList, nil, dist)>>?";
//        }
//        else {
//            if (askingAgain)
//                "Which <<spellInt(requiredNum)>> (of
//                <<askDisambigList(matchList, fullMatchList, true, dist)>>)
//                did you mean?";
//            else
//                "Which <<spellInt(requiredNum)>>
//                (of <<askDisambigList(matchList, fullMatchList,
//                                      true, dist)>>) do you mean?";
//        }
//        "<./parser> ";
//    }
//    ambiguousNounPhrase(actor, originalText, matchList, fullMatchList) {
//        "<.parser>The story doesn&rsquo;t know which
//        <<originalText>> you mean.<./parser> ";
//    }
//    missingActor(actor) {
//        "<.parser>You must be more specific about <<
//        whomPronoun>> you want to address.<./parser> ";
//    }
//    singleActorRequired(actor) {
//        "<.parser>You can only address one person
//        at a time.<./parser> ";
//    }
//    cannotChangeActor() {
//        "<.parser>You cannot address more than one character on
//        a single command line in this story.<./parser> ";
//    }
//    askUnknownWord(actor, txt) {
//        "<.parser>The word <q><<txt>></q> is not necessary in this
//        story.<./parser> ";
//        oopsNote();
//    }
//    wordIsUnknown(actor, txt) {
//        "<.parser>The story doesn&rsquo;t understand that
//        command.<./parser> ";
//    }
//    refuseCommandBusy(targetActor, issuingActor) {
//        "\^<<targetActor.nameIs>> busy. ";
//    }
//    cannotAddressMultiple(actor) {
//        "<.parser>\^<<actor.theName>> cannot address multiple
//        people at once.<./parser> ";
//    }
;

modify npcMessages //: playerMessages
//    commandNotHeard(actor) {
//        "\^<<actor.nameVerb('do')>> not respond. ";
//    }
////    // 2019-05-18 GWB: I want to be extra careful about replacing noMatch(). 
////    // Somehow, an incorrectly parameterized version of this function...
////    // noMatch(actor, txt) // <-- WRONG!
////    // ...rather than...
////    // noMatch(actor, action, txt)
////    // ...got into my code, either from an old version of TADS 3 or from
////    // me making a mistake. 
////    noMatch(actor, action, txt) {
////        "\^<<actor.nameVerb('see')>> no <<txt>>. ";
////    }
//    noMatchForAll(actor) {
//        "<.parser>\^<<actor.nameVerb('do')>>n&rsquo;t see what you
//        mean by <q>all.</q><./parser> ";
//    }
//    noMatchForAllBut(actor) {
//        "<.parser>\^<<actor.nameVerb('see')>> nothing
//        else.<./parser> ";
//    }
//    insufficientQuantity(actor, txt, matchList, requiredNum) {
//        "<.parser>\^<<actor.nameVerb('do')>>n&rsquo;t see that many
//         <<txt>>.<./parser> ";
//    }
//    ambiguousNounPhrase(actor, originalText, matchList, fullMatchList) {
//        "<.parser>\^<<actor.nameVerb('do')>>n&rsquo;t know which
//        <<originalText>> you mean.<./parser> ";
//    }
//    askMissingObject(actor, action, which) {
//        reportQuestion('<.parser>\^' + action.whatObj(which)
//                       + ' do you want ' + actor.theNameObj + ' to '
//                       + action.getQuestionInf(which) + '?<./parser> ');
//    }
//    missingObject(actor, action, which) {
//        "<.parser>You must be more specific
//        about <<action.whatObj(which)>> you want <<actor.theNameObj>>
//        to <<action.getQuestionInf(which)>>.<./parser> ";
//    }
//    missingLiteral(actor, action, which) {
//        "<.parser>You must be more specific
//        about <<action.whatObj(which)>> you want <<actor.theNameObj>> to
//        <<action.getQuestionInf(which, nil)>>.  For example:
//        <<actor.theName>>, <<action.getQuestionInf(which, nil)>>
//        <q>something</q>.<./parser> ";
//    }
;

modify npcMessagesDirect //: npcMessages
////    // 2019-05-18 GWB: I want to be extra careful about replacing noMatch(). 
////    // Somehow, an incorrectly parameterized version of this function...
////    // noMatch(actor, txt) // <-- WRONG!
////    // ...rather than...
////    // noMatch(actor, action, txt)
////    // ...got into my code, either from an old version of TADS 3 or from
////    // me making a mistake. 
////    noMatch(actor, action, txt) {
////        "\^<<actor.nameVerb('look')>> around. <q>I don&rsquo;t
////        see any <<txt>>.</q> ";
////    }
//    noMatchForAll(actor) {
//        "\^<<actor.nameVerb('say')>>, <q>I don&rsquo;t see what
//        you mean by <q>all</q>.</q> ";
//    }
//    noMatchForAllBut(actor) {
//        "\^<<actor.nameVerb('say')>>, <q>I see nothing else here.</q> ";
//    }
//    zeroQuantity(actor, txt) {
//        "\^<<actor.nameVerb('say')>>, <q>I can&rsquo;t do that to
//            zero of something.</q> ";
//    }
//    insufficientQuantity(actor, txt, matchList, requiredNum) {
//        "\^<<actor.nameVerb('say')>>, <q>I don&rsquo;t see that many <<txt>>
//            here.</q> ";
//    }
//    uniqueObjectRequired(actor, txt, matchList) {
//        "\^<<actor.nameVerb('say')>>, <q>I can&rsquo;t use multiple objects
//            like that.</q> ";
//    }
//    singleObjectRequired(actor, txt) {
//        "\^<<actor.nameVerb('say')>>, <q>I can&rsquo;t use multiple objects
//        like that.</q> ";
//    }
//    noMatchDisambig(actor, origPhrase, disambigResponse) {
//        "\^<<actor.nameVerb('say')>>, <q>That was not one of
//        the choices. ";
//    }
//    disambigOrdinalOutOfRange(actor, ordinalWord, originalText) {
//        "\^<<actor.nameVerb('say')>>, <q>There weren&rsquo;t that many choices. ";
//    }
//    askDisambig(actor, originalText, matchList, fullMatchList,
//                requiredNum, askingAgain, dist)
//    {
//        reportQuestion('');
//        if (requiredNum == 1) {
//            if (!askingAgain)
//                "\^<<actor.nameVerb('ask')>>, <q>";
//            "Which <<originalText>> do you mean, <<
//            askDisambigList(matchList, fullMatchList, nil, dist)>>?</q> ";
//        }
//        else {
//            if (!askingAgain)
//                "\^<<actor.nameVerb('ask')>>, <q>";
//            "Which <<spellInt(requiredNum)>> (of <<
//            askDisambigList(matchList, fullMatchList, true, dist)>>)
//            do you mean?</q> ";
//        }
//    }
//    ambiguousNounPhrase(actor, originalText, matchList, fullMatchList) {
//        "\^<<actor.nameVerb('say')>>, <q>I don&rsquo;t know which
//            <<originalText>> you mean.</q> ";
//    }
//    askMissingObject(actor, action, which) {
//        reportQuestion('\^' + actor.nameVerb('say') + ', <q>\^'
//                       + action.whatObj(which)
//                       + ' do you want me to '
//                       + action.getQuestionInf(which) + '?</q> ');
//    }
//    missingObject(actor, action, which) {
//        "\^<<actor.nameVerb('say')>>,
//        <q>I don&rsquo;t know <<action.whatObj(which)>>
//        you want me to <<action.getQuestionInf(which)>>.</q> ";
//    }
//    missingLiteral(actor, action, which) {
//        missingObject(actor, action, which);
//    }
//    askUnknownWord(actor, txt) {
//        "\^<<actor.nameVerb('say')>>, <q>I don&rsquo;t know the word
//         '<<txt>>'.</q> ";
//    }
//    wordIsUnknown(actor, txt) {
//        "\^<<actor.nameVerb('say')>>, <q>You used a word I don&rsquo;t know.</q> ";
//    }
;

modify npcDeferredMessagesDirect //: npcDeferredMessages
//    commandNotUnderstood(actor) {
//        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t understand
//            what you meant.</q> ";
//    }
////    // 2019-05-18 GWB: I want to be extra careful about replacing noMatch(). 
////    // Somehow, an incorrectly parameterized version of this function...
////    // noMatch(actor, txt) // <-- WRONG!
////    // ...rather than...
////    // noMatch(actor, action, txt)
////    // ...got into my code, either from an old version of TADS 3 or from
////    // me making a mistake. 
////    noMatch(actor, action, txt) {
////        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t see any <<txt>>.</q> ";
////    }
//    noMatchForAll(actor) {
//        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t see what
//            you meant by <q>all</q>.</q> ";
//    }
//    noMatchForAllBut(actor) {
//        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t see what you meant.</q> ";
//    }
//    emptyNounPhrase(actor) {
//        "\^<<actor.nameVerb('say')>>, <q>You left some words out.</q> ";
//    }
//    zeroQuantity(actor, txt) {
//        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t
//             understand what you meant.</q> ";
//    }
//    insufficientQuantity(actor, txt, matchList, requiredNum) {
//        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t see enough <<txt>>.</q> ";
//    }
//    uniqueObjectRequired(actor, txt, matchList) {
//        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t
//            understand what you meant.</q> ";
//    }
//    singleObjectRequired(actor, txt) {
//        "\^<<actor.nameVerb('say')>>, <q>I didn&rsquo;t
//            understand what you meant.</q> ";
//    }
//    ambiguousNounPhrase(actor, originalText, matchList, fullMatchList) {
//        "\^<<actor.nameVerb('say')>>, <q>I couldn&rsquo;t tell which
//        <<originalText>> you meant.</q> ";
//    }
//    askMissingObject(actor, action, which) {
//        reportQuestion('\^' + actor.nameVerb('say') + ', <q>I didn&rsquo;t know '
//                       + action.whatObj(which) + ' you wanted me to '
//                       + action.getQuestionInf(which) + '.</q> ');
//    }
//    wordIsUnknown(actor, txt) {
//        "\^<<actor.nameVerb('say')>>, <q>You used a word I don&rsquo;t know.</q> ";
//    }
;

modify playerActionMessages //: MessageHelper
//    cannotDoThatMsg = '{You/he} can&rsquo;t do that. '
//    mustBeHoldingMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must be holding {the obj/him} to do that. ';
//    }
//    tooDarkMsg = 'It&rsquo;s too dark to do that. '
//    mustBeVisibleMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot see {that obj/him}. ';
//    }
//    heardButNotSeenMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} can hear {an obj/him}, but {you/he}
//                 can&rsquo;t see{s} {it obj/him}. ';
//    }
//    smelledButNotSeenMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} can smell {an obj/him}, but {you/he}
//                can&rsquo;t see{s} {it obj/him}. ';
//    }
//    cannotHearMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot hear {that obj/him}. ';
//    }
//    cannotSmellMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot smell {that obj/him}. ';
//    }
//    cannotTasteMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot taste {that obj/him}. ';
//    }
//    cannotBeWearingMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must take off {the obj/him}
//                before {it actor/he} can do that. ';
//    }
//    mustBeEmptyMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must take everything out of {the obj/him}
//                before {it actor/he} can do that. ';
//    }
//    mustBeOpenMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must open {the obj/him}
//                before {it actor/he} can do that. ';
//    }
//    mustBeClosedMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must close {the obj/him}
//               before {it actor/he} can do that. ';
//    }
//    mustBeUnlockedMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must unlock {the obj/him}
//                before {it actor/he} can do that. ';
//    }
//    noKeyNeededMsg = '{The dobj/he} do{es} not appear to take a key. '
//    mustBeStandingMsg = '{You/he} must stand up before {it actor/he}
//                      can do that. '
//    mustSitOnMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must sit {in obj} first. ';
//    }
//    mustLieOnMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must lie {in obj} first. ';
//    }
//    mustGetOnMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must get {in obj} first. ';
//    }
//    mustBeInMsg(obj, loc) {
//        gMessageParams(obj, loc);
//        return '{The obj/he} must be {in loc} before {you/he}
//            can do that. ';
//    }
//    mustBeCarryingMsg(obj, actor) {
//        gMessageParams(obj, actor);
//        return '{The actor/he} must be holding {the obj/him}
//            before {you/he} can do that. ';
//    }
//    decorationNotImportantMsg(obj) {
//        gMessageParams(obj);
//        return '{The obj/he} {is}n&rsquo;t important. ';
//    }
//    unthingNotHereMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} do{es}n&rsquo;t see {that obj/him} here. ';
//    }
//    tooDistantMsg(obj) {
//        gMessageParams(obj);
//        return '{The obj/he} {is} too far away. ';
//    }
//    notWithIntangibleMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} can&rsquo;t do that to {an obj/him}. ';
//    }
//    notWithVaporousMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} can&rsquo;t do that to {an obj/him}. ';
//    }
//    lookInVaporousMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} just see{s} {the obj/him}. ';
//    }
//    cannotReachObjectMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot reach {the obj/him}. ';
//    }
//    cannotReachThroughMsg(obj, loc) {
//        gMessageParams(obj, loc);
//        return '{You/he} cannot reach {the obj/him} through {the loc/him}. ';
//    }
//    thingDescMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} see{s} nothing unusual about {it obj/him}. ';
//    }
//    thingSoundDescMsg(obj)
//        { return '{You/he} hear{s} nothing out of the ordinary. '; }
//    thingSmellDescMsg(obj)
//        { return '{You/he} smell{s} nothing out of the ordinary. '; }
//    npcDescMsg(npc) {
//        gMessageParams(npc);
//        return '{You/he} see{s} nothing unusual about {the npc/him}. ';
//    }
//    nothingInsideMsg = 'There&rsquo;s nothing unusual in {the dobj/him}. '
//    nothingUnderMsg = '{You/he} see{s} nothing unusual under {the dobj/him}. '
//    nothingBehindMsg =
//        '{You/he} see{s} nothing unusual behind {the dobj/him}. '
//    nothingThroughMsg = '{You/he} can see nothing through {the dobj/him}. '
//    cannotLookBehindMsg = '{You/he} can&rsquo;t look behind {the dobj/him}. '
//    cannotLookUnderMsg = '{You/he} can&rsquo;t look under {the dobj/him}. '
//    cannotLookThroughMsg = '{You/he} can&rsquo;t see through {the dobj/him}. '
//    nothingThroughPassageMsg = '{You/he} can&rsquo;t see much through
//        {the dobj/him} from here. '
//    nothingBeyondDoorMsg = 'Opening {the dobj/him} reveals nothing
//        unusual. '
//    nothingToSmellMsg = '{You/he} smell{s} nothing out of the ordinary. '
//    nothingToHearMsg = '{You/he} hear{s} nothing out of the ordinary. '
//    noiseSourceMsg(src) {
//        return '{The dobj/he} seem{s} to be coming from '
//            + src.theNameObj + '. ';
//    }
//    odorSourceMsg(src) {
//        return '{The dobj/he} seem{s} to be coming from '
//            + src.theNameObj + '. ';
//    }
//    notWearableMsg = '{That dobj/he} {is}n&rsquo;t something {you/he} can wear. '
//    notDoffableMsg = '{That dobj/he} {is}n&rsquo;t something {you/he} can remove. '
//    alreadyWearingMsg = '{You\'re} already wearing {it dobj/him}. '
//    notWearingMsg = '{You\'re} not wearing {that dobj/him}. '
//    okayWearMsg = 'Okay, {you\'re} now wearing {the dobj/him}. '
//    okayDoffMsg = 'Okay, {you\'re} no longer wearing {the dobj/him}. '
//    okayOpenMsg = 'Opened. '
//    okayCloseMsg = 'Closed. '
//    okayLockMsg = 'Locked. '
//    okayUnlockMsg = 'Unlocked. '
//    cannotDigMsg = '{You/he} {have} no reason to dig in {that dobj/him}. '
//    cannotDigWithMsg =
//        '{You/he} see{s} no way to use {that dobj/him} as a shovel. '
//    alreadyHoldingMsg = '{You/he} {are} already carrying {the dobj/him}. '
//    takingSelfMsg = '{You/he} can&rsquo;t take {yourself}. '
//    notCarryingMsg = '{You\'re} not carrying {that dobj/him}. '
//    droppingSelfMsg = '{You/he} can&rsquo;t drop {yourself}. '
//    puttingSelfMsg = '{You/he} can&rsquo;t do that to {yourself}. '
//    alreadyPutInMsg = '{The dobj/he} {is} already in {the iobj/him}. '
//    alreadyPutOnMsg = '{The dobj/he} {is} already on {the iobj/him}. '
//    alreadyPutUnderMsg = '{The dobj/he} {is} already under {the iobj/him}. '
//    alreadyPutBehindMsg = '{The dobj/he} {is} already behind {the iobj/him}. '
//    cannotMoveFixtureMsg = '{The dobj/he} cannot be moved. '
//    cannotTakeFixtureMsg = '{You/he} can&rsquo;t take {that dobj/him}. '
//    cannotPutFixtureMsg = '{You/he} can&rsquo;t put {the dobj/him} anywhere. '
//    cannotTakeImmovableMsg = '{You/he} can&rsquo;t take {that dobj/him}. '
//    cannotMoveImmovableMsg = '{The dobj/he} cannot be moved. '
//    cannotPutImmovableMsg = '{You/he} can&rsquo;t put {the dobj/him} anywhere. '
//    cannotTakeHeavyMsg = '{The dobj/he} {is} too heavy. '
//    cannotMoveHeavyMsg = '{The dobj/he} {is} too heavy. '
//    cannotPutHeavyMsg = '{The dobj/he} {is} too heavy. '
//    cannotMoveComponentMsg(loc) {
//        return '{The dobj/he} {is} part of ' + loc.theNameObj + '. ';
//    }
//    cannotTakeComponentMsg(loc) {
//        return '{You/he} can&rsquo;t have {that/him dobj}; '
//            + '{it\'s dobj} part of ' + loc.theNameObj + '. ';
//    }
//    cannotPutComponentMsg(loc) {
//        return '{You/he} can&rsquo;t put {that/him dobj} anywhere; '
//            + '{it\'s dobj} part of ' + loc.theNameObj + '. ';
//    }
//    cannotTakePushableMsg = '{You/he} can&rsquo;t take {that/him dobj}, but
//        {it actor/he} might be able to push it somewhere. '
//    cannotMovePushableMsg = 'It wouldn&rsquo;t accomplish anything to move
//        {the dobj/him} around aimlessly, but {it actor/he}
//        might be able to push {it dobj/him} in a specific direction. '
//    cannotPutPushableMsg = '{You/he} can&rsquo;t put {that/him dobj} anywhere,
//        but {it actor/he} might be able to push it somewhere. '
//    cannotTakeLocationMsg = '{You/he} can&rsquo;t take {that/him dobj}
//        while {you\'re} occupying {it/him dobj}. '
//    okayTakeMsg = 'Taken. '
//    okayDropMsg = 'Dropped. '
//    droppingObjMsg(dropobj) {
//        gMessageParams(dropobj);
//        return '{You/he} drop{s} {the dropobj/him}. ';
//    }
//    floorlessDropMsg(dropobj) {
//        gMessageParams(dropobj);
//        return '{It dropobj/he} fall{s} out of sight below. ';
//    }
//    okayPutInMsg = 'Done. '
//    okayPutOnMsg = 'Done. '
//    okayPutUnderMsg = 'Done. '
//    okayPutBehindMsg = 'Done. '
//    cannotTakeActorMsg = '{The dobj/he} won&rsquo;t let {you/him} do that. '
//    cannotMoveActorMsg = '{The dobj/he} won&rsquo;t let {you/him} do that. '
//    cannotPutActorMsg = '{The dobj/he} won&rsquo;t let {you/him} do that. '
//    cannotTakePersonMsg = '{The dobj/he} probably wouldn&rsquo;t like that. '
//    cannotMovePersonMsg = '{The dobj/he} probably wouldn&rsquo;t like that. '
//    cannotPutPersonMsg = '{The dobj/he} probably wouldn&rsquo;t like that. '
//    cannotMoveThroughMsg(obj, obs) {
//        gMessageParams(obj, obs);
//        return '{You/he} can&rsquo;t move {that obj/him} through {the obs/him}. ';
//    }
//    cannotMoveThroughContainerMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} can&rsquo;t move {that obj/him} through {the cont/him}. ';
//    }
//    cannotMoveThroughClosedMsg(obj, cont) {
//        gMessageParams(cont);
//        return '{You/he} can&rsquo;t do that because {the cont/he} {is} closed. ';
//    }
//    cannotFitIntoOpeningMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} can&rsquo;t do that because {the obj/he} {is}
//                too big to put into {the cont/him}. ';
//    }
//    cannotFitOutOfOpeningMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} can&rsquo;t do that because {the obj/he} {is}
//                too big to take out of {the cont/him}. ';
//    }
//    cannotTouchThroughContainerMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} can&rsquo;t reach anything through {the cont/him}. ';
//    }
//    cannotTouchThroughClosedMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} can&rsquo;t do that because
//               {the cont/he} {is} closed. ';
//    }
//    cannotReachIntoOpeningMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} can&rsquo;t fit {its/her} hand into {the cont/him}. ';
//    }
//    cannotReachOutOfOpeningMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} can&rsquo;t fit {its/her} hand through
//               {the cont/him}. ';
//    }
//    tooLargeForActorMsg(obj) {
//        gMessageParams(obj);
//        return '{The obj/he} {is} too large for {you/him} to hold. ';
//    }
//    handsTooFullForMsg(obj) {
//        return '{Your} hands are too full to hold ' + obj.theNameObj + '. ';
//    }
//    becomingTooLargeForActorMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot do that because {the obj/he}
//                would become too large for {you/him} to hold. ';
//    }
//    handsBecomingTooFullForMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot do that because {your} hands
//            would become too full to hold {the obj/him}. ';
//    }
//    tooHeavyForActorMsg(obj) {
//        gMessageParams(obj);
//        return '{The obj/he} {is} too heavy for {you/him} to pick up. ';
//    }
//    totalTooHeavyForMsg(obj) {
//        gMessageParams(obj);
//        return '{The obj/he} {is} too heavy; {you/he} will have to put
//            something else down first. ';
//    }
//    tooLargeForContainerMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} {is} too large for {the cont/him}. ';
//    }
//    tooLargeForUndersideMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} {is} too large to put under {the cont/him}. ';
//    }
//    tooLargeForRearMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} {is} too large to put behind {the cont/him}. ';
//    }
//    containerTooFullMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The cont/he} {is} already too full to hold {the obj/him}. ';
//    }
//    surfaceTooFullMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return 'There&rsquo;s no room for {the obj/him} on {the cont/him}. ';
//    }
//    undersideTooFullMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return 'There&rsquo;s no room for {the obj/him} under {the cont/him}. ';
//    }
//    rearTooFullMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return 'There&rsquo;s no room for {the obj/him} behind {the cont/him}. ';
//    }
//    becomingTooLargeForContainerMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} cannot do that because it would make
//            {the obj/him} too large for {the cont/him}. ';
//    }
//    containerBecomingTooFullMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} cannot do that because {the obj/he}
//            would no longer fit in {the cont/him}. ';
//    }
//    notAContainerMsg = '{You/he} can&rsquo;t put anything in {the iobj/him}. '
//    notASurfaceMsg = 'There&rsquo;s no good surface on {the iobj/him}. '
//    cannotPutUnderMsg = '{You/he} can&rsquo;t put anything under {that iobj/him}. '
//    cannotPutBehindMsg = '{You/he} can&rsquo;t put anything
//        behind {the iobj/him}. '
//    cannotPutInSelfMsg = '{You/he} can&rsquo;t put {the dobj/him} in {itself}. '
//    cannotPutOnSelfMsg = '{You/he} can&rsquo;t put {the dobj/him} on {itself}. '
//    cannotPutUnderSelfMsg = '{You/he} can&rsquo;t put {the dobj/him} under
//        {itself}. '
//    cannotPutBehindSelfMsg = '{You/he} can&rsquo;t put {the dobj/him} behind
//        {itself}. '
//    cannotPutInRestrictedMsg =
//        '{You/he} can&rsquo;t put {that dobj/him} in {the iobj/him}. '
//    cannotReturnToDispenserMsg =
//        '{You/he} can&rsquo;t put {a dobj/him} back in {the iobj/him}. '
//    cannotPutInDispenserMsg =
//        '{You/he} can&rsquo;t put {a dobj/him} in {the iobj/him}. '
//    objNotForKeyringMsg = '{The dobj/he} do{es}n&rsquo;t fit on {the iobj/him}. '
//    keyNotOnKeyringMsg = '{The dobj/he} {is} not attached to {the iobj/him}. '
//    keyNotDetachableMsg = '{The dobj/he} {is}n&rsquo;t attached to anything. '
//    takenAndMovedToKeyringMsg(keyring) {
//        gMessageParams(keyring);
//        return '{You/he} pick{s} up {the dobj/him} and attach{es actor}
//            {it dobj/him} to {the keyring/him}. ';
//    }
//    movedKeyToKeyringMsg(keyring) {
//        gMessageParams(keyring);
//        return '{You/he} attach{es} {the dobj/him} to {the keyring/him}. ';
//    }
//    movedKeysToKeyringMsg(keyring, keys) {
//        gMessageParams(keyring);
//        return '{You/he} attach{es} {your/his} loose key'
//            + (keys.length() > 1 ? 's' : '')
//            + ' to {the keyring/him}. ';
//    }
//    circularlyInMsg(x, y) {
//        gMessageParams(x, y);
//        return '{You/he} can&rsquo;t do that while {the x/he} {is}
//            in {the y/him}. ';
//    }
//    circularlyOnMsg(x, y) {
//        gMessageParams(x, y);
//        return '{You/he} can&rsquo;t do that while {the x/he} {is}
//            on {the y/him}. ';
//    }
//    circularlyUnderMsg(x, y) {
//        gMessageParams(x, y);
//        return '{You/he} can&rsquo;t do that while {the x/he} {is}
//            under {the y/him}. ';
//    }
//    circularlyBehindMsg(x, y) {
//        gMessageParams(x, y);
//        return '{You/he} can&rsquo;t do that while {the x/he} {is}
//            behind {the y/him}. ';
//    }
//    takeFromNotInMsg = '{The dobj/he} {is}n&rsquo;t in {that iobj/him}. '
//    takeFromNotOnMsg = '{The dobj/he} {is}n&rsquo;t on {that iobj/him}. '
//    takeFromNotUnderMsg = '{The dobj/he} {is}n&rsquo;t under {that iobj/him}. '
//    takeFromNotBehindMsg = '{The dobj/he} {is}n&rsquo;t behind {that iobj/him}. '
//    takeFromNotInActorMsg = '{The iobj/he} do{es}n&rsquo;t have {that dobj/him}. '
//    willNotLetGoMsg(holder, obj) {
//        gMessageParams(holder, obj);
//        return '{The holder/he} won&rsquo;t let {you/him} have {that obj/him}. ';
//    }
//    whereToGoMsg = 'You&rsquo;ll have to say which way to go. '
//    cannotGoThatWayMsg = '{You/he} can&rsquo;t go that way. '
//    cannotGoThatWayInDarkMsg = 'It&rsquo;s too dark; {you/he} can&rsquo;t see
//                             where {you\'re} going. '
//    cannotGoBackMsg = '{You/he} do{es}n&rsquo;t know how to return from here. '
//    cannotDoFromHereMsg = '{You/he} can&rsquo;t do that from here. '
//    cannotGoThroughClosedDoorMsg(door) {
//        gMessageParams(door);
//        return '{You/he} can&rsquo;t do that, because {the door/he} {is} closed. ';
//    }
//    invalidStagingContainerMsg(cont, dest) {
//        gMessageParams(cont, dest);
//        return '{You/he} can&rsquo;t do that while {the dest/he} {is}
//                {in cont}. ';
//    }
//    invalidStagingLocationMsg(dest) {
//        gMessageParams(dest);
//        return '{You/he} can&rsquo;t get {in dest}. ';
//    }
//    nestedRoomTooHighMsg(obj) {
//        gMessageParams(obj);
//        return '{The obj/he} {is} too high to reach from here. ';
//    }
//    nestedRoomTooHighToExitMsg(obj) {
//        return 'It&rsquo;s too long a drop to do that from here. ';
//    }
//    cannotDoFromMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} can&rsquo;t do that from {the obj/him}. ';
//    }
//    vehicleCannotDoFromMsg(obj) {
//        local loc = obj.location;
//        gMessageParams(obj, loc);
//        return '{You/he} can&rsquo;t do that while {the obj/he} {is} {in loc}. ';
//    }
//    cannotGoThatWayInVehicleMsg(traveler) {
//        gMessageParams(traveler);
//        return '{You/he} can&rsquo;t do that {in traveler}. ';
//    }
//    cannotPushObjectThatWayMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} can&rsquo;t go that way pushing {the obj/him}. ';
//    }
//    cannotEnterExitOnlyMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} can&rsquo;t enter {the obj/him} from here. ';
//    }
//    mustOpenDoorMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must open {the obj/him} first. ';
//    }
//    doorClosesBehindMsg(obj) {
//        gMessageParams(obj);
//        return '<.p>After {you/he} go{es} through {the obj/him}, {it/he}
//                close{s} behind {it actor/him}. ';
//    }
//    stairwayNotUpMsg = '{The dobj/he} only go{es} down from here. '
//    stairwayNotDownMsg = '{The dobj/he} only go{es} up from here. '
    timePassesMsg = 'Time passes . . . '
//    sayHelloMsg = (addressingNoOneMsg)
//    sayGoodbyeMsg = (addressingNoOneMsg)
//    sayYesMsg = (addressingNoOneMsg)
//    sayNoMsg = (addressingNoOneMsg)
//    addressingNoOneMsg {
//        return '{You/he} must be more specific about '
//            + libMessages.whomPronoun + ' {you/he} want{s} to talk to. ';
//    }
//    okayYellMsg = '{You/he} scream{s} as loud as {it actor/he} can. '
//    okayJumpMsg = '{You/he} jump{s} a little, and land{s} back where
//        {it actor/he} started. '
//    cannotJumpOverMsg = '{You/he} can&rsquo;t jump over {that dobj/him}. '
//    cannotJumpOffMsg = '{You/he} can&rsquo;t jump off {that dobj/him}. '
//    cannotJumpOffHereMsg = 'There&rsquo;s nowhere to jump from here. '
//    cannotFindTopicMsg = '{You/he} can&rsquo;t seem to find that in {the dobj/him}. '
//    refuseCommand(targetActor, issuingActor) {
//        gMessageParams(targetActor, issuingActor);
//        return '{The targetActor/he} refuse{s} {your/his} request. ';
//    }
//    notAddressableMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot talk to {that obj/him}. ';
//    }
//    noResponseFromMsg(other) {
//        gMessageParams(other);
//        return '{The other/he} do{es} not respond. ';
//    }
//    cannotAskSelfMsg =
//        'Talking to {yourself/himself} won&rsquo;t accomplish anything. '
//    cannotAskSelfForMsg =
//        'Talking to {yourself/himself} won&rsquo;t accomplish anything. '
//    cannotTellSelfMsg =
//        'Talking to {yourself/himself} won&rsquo;t accomplish anything. '
//    cannotGiveToSelfMsg = 'Giving {the dobj/him} to {yourself/himself}
//        won&rsquo;t accomplish anything. '
//    cannotShowToSelfMsg = 'Showing {the dobj/him} to {yourself/himself}
//        won&rsquo;t accomplish anything. '
//    notInterestedMsg(actor) {
//        return '\^' + actor.nameVerb('do') + ' not appear interested. ';
//    }
//    objCannotHearActorMsg(obj) {
//        return '\^' + obj.nameVerb('do')
//            + ' not appear to hear {you/him}. ';
//    }
//    actorCannotSeeMsg(actor, obj) {
//        return '\^' + actor.theName + ' does not appear to be able to see '
//            + obj.theNameObj + '. ';
//    }
//    notFollowableMsg = '{You/he} cannot follow {that dobj/him}. '
//    cannotFollowSelfMsg = '{You/he} cannot follow {yourself}. '
//    followAlreadyHereMsg = '{The dobj/he} {is} right here. '
//    followAlreadyHereInDarkMsg = '{The dobj/he} should be right here,
//        but {you/he} can&rsquo;t see {it dobj/him}. '
//    followUnknownMsg = '{You\'re} not sure where {the dobj/he}
//        went from here. '
//    cannotFollowFromHereMsg(srcLoc) {
//        return 'The last place you saw {the dobj/him} was '
//            + srcLoc.getDestName(gActor, gActor.location) + '. ';
//    }
//    okayFollowInSightMsg(loc) {
//        return '{You/he} follow{s} {the dobj/him} '
//            + loc.actorIntoName + '. ';
//    }
//    notAWeaponMsg = '{You/he} can&rsquo;t attack anything with {the iobj/him}. '
//    uselessToAttackMsg = '{You/he} cannot attack {that dobj/him}. '
//    pushNoEffectMsg = 'Pushing {the dobj/him} has no effect. '
//    okayPushButtonMsg = '<q>Click.</q> '
//    alreadyPushedMsg =
//        '{It\'s dobj} already pushed as far as {it dobj/he} will go. '
//    okayPushLeverMsg = '{You/he} push{es} {the dobj/him} to
//                     {its/her dobj} stop. '
//    pullNoEffectMsg = 'Pulling {the dobj/him} has no effect. '
//    alreadyPulledMsg =
//        '{It\'s dobj} already pulled as far as {it dobj/he} will go. '
//    okayPullLeverMsg = '{You/he} pull{s} {the dobj/him} to
//                     {its/her dobj} stop. '
//    okayPullSpringLeverMsg = '{You/he} pull{s} {the dobj/him}, which
//        spring{s} back to {its/her} starting position as soon as
//        {you/he} let{s} go of {it dobj/him}. '
//    moveNoEffectMsg = 'Moving {the dobj/him} has no effect. '
//    moveToNoEffectMsg = 'This would accomplish nothing. '
//    cannotPushTravelMsg = 'This would accomplish nothing. '
//    okayPushTravelMsg(obj) {
//        return '<.p>{You/he} push{es} ' + obj.theNameObj
//            + ' into the area. ';
//    }
//    cannotMoveWithMsg = '{You/he} cannot move anything with {the iobj/him}. '
//    setToInvalidMsg = '{The dobj/he} {has} no such setting. '
//    okaySetToMsg(val)
//        { return 'Okay, {the dobj/he} {is} now set to ' + val + '. '; }
//    cannotTurnMsg = '{You/he} cannot turn {that dobj/him}. '
//    mustSpecifyTurnToMsg = '{You/he} must specify the setting to
//                         turn {it dobj/him} to. '
//    cannotTurnWithMsg = '{You/he} cannot turn anything with {that iobj/him}. '
//    turnToInvalidMsg = '{The dobj/he} {has} no such setting. '
//    okayTurnToMsg(val)
//        { return 'Okay, {the dobj/he} {is} now set to ' + val + '. '; }
//    alreadySwitchedOnMsg = '{The dobj/he} {is} already on. '
//    alreadySwitchedOffMsg = '{The dobj/he} {is} already off. '
//    okayTurnOnMsg = 'Okay, {the dobj/he} {is} now on. '
//    okayTurnOffMsg = 'Okay, {the dobj/he} {is} now off. '
//    flashlightOnButDark = '{You/he} turn{s} on {the dobj/him}, but
//        nothing seems to happen. '
//    okayEatMsg = '{You/he} eat{s} {the dobj/him}. '
//    mustBeBurningMsg(obj) {
//        return '{You/he} must light ' + obj.theNameObj
//            + ' before {it actor/he} can do that. ';
//    }
//    matchNotLitMsg = '{The dobj/he} {is}n&rsquo;t lit. '
//    okayBurnMatchMsg =
//        '{You/he} strike{s} {the dobj/him}, igniting a small flame. '
//    okayExtinguishMatchMsg = '{You/he} put{s} out {the dobj/him}, which
//        disappear{s} into a cloud of ash. '
//    candleOutOfFuelMsg =
//        '{The dobj/he} {is} too burned down; {it/he} cannot be lit. '
//    okayBurnCandleMsg = '{You/he} light{s} {the dobj/him}. '
//    candleNotLitMsg = '{The dobj/he} {is} not lit. '
//    okayExtinguishCandleMsg = 'Done. '
//    cannotConsultMsg =
//        '{That dobj/he} {is} not something {you/he} can consult. '
//    cannotTypeOnMsg = '{You/he} cannot type anything on {that dobj/him}. '
//    cannotEnterOnMsg = '{You/he} cannot enter anything on {that dobj/him}. '
//    cannotSwitchMsg = '{You/he} cannot switch {that dobj/him}. '
//    cannotFlipMsg = '{You/he} cannot flip {that dobj/him}. '
//    cannotTurnOnMsg =
//        '{That dobj/he} {is}n&rsquo;t something {you/he} can turn on. '
//    cannotTurnOffMsg =
//        '{That dobj/he} {is}n&rsquo;t something {you/he} can turn off. '
//    cannotLightMsg = '{You/he} cannot light {that dobj/him}. '
//    cannotBurnMsg = '{That dobj/he} {is} not something {you/he} can burn. '
//    cannotBurnWithMsg = '{You/he} cannot burn anything with {that iobj/him}. '
//    cannotBurnDobjWithMsg = '{You/he} cannot light {the dobj/him}
//                          with {the iobj/him}. '
//    alreadyBurningMsg = '{The dobj/he} {is} already burning. '
//    cannotExtinguishMsg = '{You/he} cannot extinguish {that dobj/him}. '
//    cannotPourMsg = '{That dobj/he} {is} not something {you/he} can pour. '
//    cannotPourIntoMsg = '{You/he} cannot pour anything into {that dobj/him}. '
//    cannotPourOntoMsg = '{You/he} cannot pour anything onto {that dobj/him}. '
//    cannotAttachMsg = '{You/he} cannot attach {that dobj/him} to anything. '
//    cannotAttachToMsg = '{You/he} cannot attach anything to {that iobj/him}. '
//    cannotAttachToSelfMsg =
//        '{You/he} cannot attach {the dobj/him} to {itself}. '
//    alreadyAttachedMsg =
//        '{The dobj/he} {is} already attached to {the iobj/him}. '
//    wrongAttachmentMsg =
//        '{You/he} can&rsquo;t attach {that dobj/him} to {the iobj/him}. '
//    wrongDetachmentMsg =
//        '{You/he} can&rsquo;t detach {that dobj/him} from {the iobj/him}. '
//    mustDetachMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must detach {the obj/him} before {you/he}
//            can do that. ';
//    }
//    okayAttachToMsg = 'Done. '
//    okayDetachFromMsg = 'Done. '
//    cannotDetachMsg = '{You/he} cannot detach {that dobj/him}. '
//    cannotDetachFromMsg =
//        '{You/he} cannot detach anything from {that iobj/him}. '
//    cannotDetachPermanentMsg =
//        'There&rsquo;s no obvious way to detach {that dobj/him}. '
//    notAttachedToMsg = '{The dobj/he} {is}n&rsquo;t attached to {that iobj/him}. '
//    shouldNotBreakMsg = 'Breaking {that dobj/him} would serve no purpose. '
//    cutNoEffectMsg = '{The iobj/he} can&rsquo;t seem to cut {the dobj/him}. '
//    cannotCutWithMsg = '{You/he} can&rsquo;t cut anything with {the iobj/him}. '
//    cannotClimbMsg = '{That dobj/he} {is} not something {you/he} can climb. '
//    cannotOpenMsg = '{That dobj/he} {is} not something {you/he} can open. '
//    cannotCloseMsg = '{That dobj/he} {is} not something {you/he} can close. '
//    alreadyOpenMsg = '{The dobj/he} {is} already open. '
//    alreadyClosedMsg = '{The dobj/he} {is} already closed. '
//    alreadyLockedMsg = '{The dobj/he} {is} already locked. '
//    alreadyUnlockedMsg = '{The dobj/he} {is} already unlocked. '
//    cannotLookInClosedMsg = '{The dobj/he} {is} closed. '
//    cannotLockMsg =
//        '{That dobj/he} {is} not something {you/he} can lock. '
//    cannotUnlockMsg =
//        '{That dobj/he} {is} not something {you/he} can unlock. '
//    cannotOpenLockedMsg = '{The dobj/he} seem{s} to be locked. '
//    unlockRequiresKeyMsg =
//        '{You/he} seem{s} to need a key to unlock {the dobj/him}. '
//    cannotLockWithMsg =
//        '{The iobj/he} do{es}n&rsquo;t look suitable for locking that. '
//    cannotUnlockWithMsg =
//        '{The iobj/he} do{es}n&rsquo;t look suitable for unlocking that. '
//    unknownHowToLockMsg = 'It&rsquo;s not clear how to lock {the dobj/him}. '
//    unknownHowToUnlockMsg = 'It&rsquo;s not clear how to unlock {the dobj/him}. '
//    keyDoesNotFitLockMsg = '{The iobj/he} do{es}n&rsquo;t fit the lock. '
//    foundKeyOnKeyringMsg(ring, key) {
//        gMessageParams(ring, key);
//        return '{You/he} tr{ies} each key on {the ring/him}, and
//            find{s actor} that {the key/he} fit{s} the lock. ';
//    }
//    foundNoKeyOnKeyringMsg(ring) {
//        gMessageParams(ring);
//        return '{You/he} tr{ies} each key on {the ring/him},
//            but {you/he} can&rsquo;t find anything that fits the lock. ';
//    }
//    cannotEatMsg = '{The dobj/he} do{es} not appear to be edible. '
//    cannotDrinkMsg = '{That dobj/he} do{es} not appear to be something
//        {you/he} can drink. '
//    cannotCleanMsg = '{You/he} wouldn&rsquo;t know how to clean {that dobj/him}. '
//    cannotCleanWithMsg =
//        '{You/he} can&rsquo;t clean anything with {that iobj/him}. '
//    cannotAttachKeyToMsg =
//        '{You/he} cannot attach {the dobj/him} to {that iobj/him}. '
//    cannotSleepMsg = '{You/he} do{es}n&rsquo;t need to sleep right now. '
//    cannotSitOnMsg = '{That dobj/he} {is}n&rsquo;t something {you/he} can sit on. '
//    cannotLieOnMsg = '{That dobj/he} {is}n&rsquo;t something {you/he} can lie on. '
//    cannotStandOnMsg = '{You/he} can&rsquo;t stand on {that dobj/him}. '
//    cannotBoardMsg = '{You/he} can&rsquo;t board {that dobj/him}. '
//    cannotUnboardMsg = '{You/he} can&rsquo;t get out of {that dobj/him}. '
//    cannotGetOffOfMsg = '{You/he} can&rsquo;t get off of {that dobj/him}. '
//    cannotStandOnPathMsg = 'If {you/he} want{s} to follow {the dobj/him},
//        just say so. '
//    cannotEnterHeldMsg =
//        '{You/he} can&rsquo;t do that while {you\'re} holding {the dobj/him}. '
//    cannotGetOutMsg = '{You\'re} not in anything {you/he} can disembark. '
//    alreadyStandingMsg = '{You\'re} already standing. '
//    alreadyStandingOnMsg = '{You\'re} already standing {on dobj}. '
//    alreadySittingOnMsg = '{You\'re} already sitting {on dobj}. '
//    alreadyLyingOnMsg = '{You\'re} already lying {on dobj}. '
//    notOnPlatformMsg = '{You\'re} not {on dobj}. '
//    noRoomToStandMsg = 'There&rsquo;s no room for {you/him} to stand {on dobj}. '
//    noRoomToSitMsg = 'There&rsquo;s no room for {you/him} to sit {on dobj}. '
//    noRoomToLieMsg = 'There&rsquo;s no room for {you/him} to lie {on dobj}. '
//    okayPostureChangeMsg(posture)
//        { return 'Okay, {you\'re} now ' + posture.participle + '. '; }
//    roomOkayPostureChangeMsg(posture, obj) {
//        gMessageParams(obj);
//        return 'Okay, {you\'re} now ' + posture.participle + ' {on obj}. ';
//    }
//    okayNotStandingOnMsg = 'Okay, {you\'re} no longer {on dobj}. '
//    cannotFastenMsg = '{You/he} cannot fasten {the dobj/him}. '
//    cannotFastenToMsg = '{You/he} cannot fasten anything to {the iobj/him}. '
//    cannotUnfastenMsg = '{You/he} cannot unfasten {the dobj/him}. '
//    cannotUnfastenFromMsg =
//        '{You/he} cannot unfasten anything from {the iobj/him}. '
//    cannotPlugInMsg = '{You/he} see{s} no way to plug in {the dobj/him}. '
//    cannotPlugInToMsg =
//        '{You/he} see{s} no way to plug anything into {the iobj/him}. '
//    cannotUnplugMsg = '{You/he} see{s} no way to unplug {the dobj/him}. '
//    cannotUnplugFromMsg =
//        '{You/he} see{s} no way to unplug anything from {the iobj/him}. '
//    cannotScrewMsg = '{You/he} see{s} no way to screw {the dobj/him}. '
//    cannotScrewWithMsg =
//        '{You/he} cannot screw anything with {the iobj/him}. '
//    cannotUnscrewMsg = '{You/he} see{s} no way to unscrew {the dobj/him}. '
//    cannotUnscrewWithMsg =
//        '{You/he} cannot unscrew anything with {the iobj/him}. '
//    cannotEnterMsg = '{That/he dobj} {is} not something {you/he} can enter. '
//    cannotGoThroughMsg =
//        '{That/he dobj} {is} not something {you/he} can go through. '
//    cannotThrowAtSelfMsg =
//        '{You/he} can&rsquo;t throw {that dobj/him} at {itself}. '
//    cannotThrowAtContentsMsg = '{You/he} must remove {the iobj/him}
//        from {the dobj/him} before {it actor/he} can do that. '
//    shouldNotThrowAtFloorMsg =
//        '{You/he} should just put {it dobj/him} down instead. '
//    throwHitMsg(projectile, target) {
//        gMessageParams(projectile, target);
//        return '{The projectile/he} hit{s} {the target/him} without any
//            obvious effect. ';
//    }
//    throwHitFallMsg(projectile, target, dest) {
//        gMessageParams(projectile, target);
//        return '{The projectile/he} hit{s} {the target/him}
//            without any obvious effect, and fall{s projectile} '
//            + dest.putInName + '. ';
//    }
//    throwShortMsg(projectile, target) {
//        gMessageParams(projectile, target);
//        return '{The projectile/he} fall{s} well short of {the target/him}. ';
//    }
//    throwFallShortMsg(projectile, target, dest) {
//        gMessageParams(projectile, target);
//        return '{The projectile/he} fall{s} ' + dest.putInName
//            + ' well short of {the target/him}. ';
//    }
//    throwCatchMsg(obj, target) {
//        return '\^' + target.nameVerb('catch')
//            + ' ' + obj.theNameObj + '. ';
//    }
//    willNotCatchMsg(catcher) {
//        return '\^' + catcher.nameVerb('do')
//            + 'n&rsquo;t look like ' + catcher.itNom + ' want'
//            + catcher.verbEndingS + ' to catch anything. ';
//    }
//    cannotKissMsg = 'Kissing {the dobj/him} has no obvious effect. '
//    cannotKissActorMsg = '{The dobj/he} probably wouldn&rsquo;t like that. '
//    cannotKissSelfMsg = '{You/he} cannot kiss {yourself}. '
//    newlyDarkMsg = 'It is now pitch black. '
;

modify npcActionMessages //: playerActionMessages
    timePassesMsg = '{You/he} wait{s} . . . '
//    cannotMoveFixtureMsg = '{You/he} cannot move {that dobj/him}. '
//    cannotMoveImmovableMsg = '{You/he} cannot move {that dobj/him}. '
//    cannotTakeHeavyMsg =
//        '{That dobj/he} {is} too heavy for {you/him} to take. '
//    cannotMoveHeavyMsg =
//        '{That dobj/he} {is} too heavy for {you/him} to move. '
//    cannotPutHeavyMsg =
//        '{That dobj/he} {is} too heavy for {you/him} to move. '
//    cannotMoveComponentMsg(loc) {
//        return '{You/he} cannot do that because {the dobj/he} {is} part
//            of ' + loc.theNameObj + '. ';
//    }
//    okayTakeMsg = '{You/he} take{s} {the dobj/him}. '
//    okayDropMsg = '{You/he} put{s} down {the dobj/him}. '
//    okayPutInMsg = '{You/he} put{s} {the dobj/him} in {the iobj/him}. '
//    okayPutOnMsg = '{You/he} put{s} {the dobj/him} on {the iobj/him}. '
//    okayPutUnderMsg = '{You/he} put{s} {the dobj/him} under {the iobj/him}. '
//    okayPutBehindMsg = '{You/he} put{s} {the dobj/him} behind {the iobj/him}. '
//    okayWearMsg = '{You/he} put{s} on {the dobj/him}. '
//    okayDoffMsg = '{You/he} take{s} off {the dobj/him}. '
//    okayOpenMsg = '{You/he} open{s} {the dobj/him}. '
//    okayCloseMsg = '{You/he} close{s} {the dobj/him}. '
//    okayLockMsg = '{You/he} lock{s} {the dobj/him}. '
//    okayUnlockMsg = '{You/he} unlock{s} {the dobj/him}. '
//    pushNoEffectMsg =
//        '{You/he} tr{ies} to push {the dobj/him}, with no obvious effect. '
//    pullNoEffectMsg =
//        '{You/he} tr{ies} to pull {the dobj/him}, with no obvious effect. '
//    moveNoEffectMsg =
//        '{You/he} tr{ies} to move {the dobj/him}, with no obvious effect. '
//    moveToNoEffectMsg =
//        '{You/he} leave{s} {the dobj/he} where {it/he} {is}. '
//    whereToGoMsg = 'You&rsquo;ll have to say which way {you/he} should go. '
//    tooLargeForContainerMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} cannot do that because {the obj/he} {is}
//            too large for {the cont/him}. ';
//    }
//    tooLargeForUndersideMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} cannot do that because {the obj/he}
//            won&rsquo;t fit under {the cont/him}. ';
//    }
//    tooLargeForRearMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} cannot do that because {the obj/he}
//            won&rsquo;t fit behind {the cont/him}. ';
//    }
//    containerTooFullMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} cannot do that because {the cont/he} {is}
//            already too full to hold {the obj/him}. ';
//    }
//    surfaceTooFullMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} cannot do that because there&rsquo;s
//            no room for {the obj/him} on {the cont/him}. ';
//    }
//    objNotForKeyringMsg = '{You/he} cannot do that because
//                        {that dobj/he} do{es}n&rsquo;t fit on {the iobj/him}. '
//    takeFromNotInMsg = '{You/he} cannot do that because
//        {the dobj/he} {is}n&rsquo;t in {that iobj/him}. '
//    takeFromNotOnMsg = '{You/he} cannot do that because
//        {the dobj/he} {is}n&rsquo;t on {that iobj/him}. '
//    takeFromNotUnderMsg = '{You/he} cannot do that because
//        {the dobj/he} {is}n&rsquo;t under {that iobj/him}. '
//    takeFromNotBehindMsg = '{You/he} cannot do that because
//        {the dobj/he} {is}n&rsquo;t behind {that iobj/him}. '
//    cannotJumpOffHereMsg = 'There&rsquo;s nowhere for {you/him} to jump. '
//    shouldNotBreakMsg = '{You/he} do{es}n&rsquo;t want to break {that dobj/him}. '
//    okayPostureChangeMsg(posture)
//        { return '{You/he} ' + posture.msgVerbI + '. '; }
//    roomOkayPostureChangeMsg(posture, obj) {
//        gMessageParams(obj);
//        return '{You/he} ' + posture.msgVerbT + ' {on obj}. ';
//    }
//    okayNotStandingOnMsg = '{You/he} get{s} {offof dobj}. '
//    okayTurnToMsg(val)
//        { return '{You/he} turn{s} {the dobj/him} to ' + val + '. '; }
//    okayPushButtonMsg = '{You/he} push{es} {the dobj/him}. '
//    okayTurnOnMsg = '{You/he} turn{s} {the dobj/him} on. '
//    okayTurnOffMsg = '{You/he} turn{s} {the dobj/him} off. '
//    keyDoesNotFitLockMsg = '{You/he} tr{ies} {the iobj/he}, but {it iobj/he}
//                         do{es}n&rsquo;t fit the lock. '
//    okayFollowModeMsg = '<q>Okay, I will follow {the dobj/him}.</q> '
//    okayExtinguishCandleMsg = '{You/he} extinguish{es} {the dobj/him}. '
//    okayAttachToMsg = '{You/he} attach{es} {the dobj/him} to {the iobj/him}. '
//    okayDetachFromMsg =
//        '{You/he} detach{es} {the dobj/him} from {the iobj/him}. '
//    cannotAskSelfMsg = '{You/he} won&rsquo;t accomplish anything talking
//        to {yourself/himself}. '
//    cannotAskSelfForMsg = '{You/he} won&rsquo;t accomplish anything talking
//        to {yourself/himself}. '
//    cannotTellSelfMsg = '{You/he} won&rsquo;t accomplish anything talking
//        to {yourself/himself}. '
//    cannotGiveToSelfMsg = '{You/he} won&rsquo;t accomplish anything
//        giving {the dobj/him} to {yourself/himself}. '
//    cannotShowToSelfMsg = '{You/he} won&rsquo;t accomplish anything
//        showing {the dobj/him} to {yourself/himself}. '
;


//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
////  
////  PART 4:
////  Rewrite messages for the sake of the bot.
////  
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////

// make sure to change the contents of the non-commented-out
// properties of libMessages here, making them depend on whether the
// bot is the PC.

modify libMessages //: MessageHelper
//    whomPronoun = 'whom'
//    offerOopsNote = true
//    commandLookAround = 'look around'
//    commandFullScore = 'full score'
//    announceRemappedAction(action) {
//        return '\n<.assume>' + action.getParticiplePhrase() + '<./assume>\n';
//    }
//    announceImplicitAction(action, ctx) {
//        return ctx.buildImplicitAnnouncement(action.getImplicitPhrase(ctx));
//    }
//    silentImplicitAction(action, ctx) { return ''; }
//    announceMoveToBag(action, ctx) {
//        return ctx.buildImplicitAnnouncement(
//            action.getImplicitPhrase(ctx) + ' to make room');
//    }
//    showCredit(name, byline) { "<<name>> <<byline>>"; }
//    showVersion(name, version) { "<<name>> version <<version>>"; }
//    noAboutInfo = "<.parser>This story has no ABOUT
//                   information.<./parser> "
//    showListState(state) { " (<<state>>)"; }
//    allInSameListState(lst, stateName) { 
//        " (<<lst.length() == 2 ? 'both' : 'all'>> <<stateName>>)";
//    }
    distantThingDesc(obj) {
      if (gPlayerChar == bot) {
        gMessageParams(obj);
        "<.q>{It's obj} way off in the distance,<./q> says Sheila.
          <.q>I can<./s>t make out much detail from here.<./q> ";
      }
      else {
        inherited(obj);
      }
    }
//    obscuredThingDesc(obj, obs) {
//        gMessageParams(obj, obs);
//        "{You/he} can&rsquo;t make out any detail through {the obs/him}. ";
//    }
//    distantThingSoundDesc(obj)
//        { "{You/he} can&rsquo;t hear any detail from this distance. "; }
//    obscuredThingSoundDesc(obj, obs) {
//        gMessageParams(obj, obs);
//        "{You/he} can&rsquo;t hear any detail through {the obs/him}. ";
//    }
//    distantThingSmellDesc(obj)
//        { "{You/he} can&rsquo;t smell much at this distance. "; }
//    obscuredThingSmellDesc(obj, obs) {
//        gMessageParams(obj, obs);
//        "{You/he} can&rsquo;t smell much through {the obs/him}. ";
//    }
    thingTasteDesc(obj) {
      if (gPlayerChar == bot) {
        gMessageParams(obj);
        if (obj && obj.ofKind(Actor))
          "<.q>Taste {an obj/he}?<./q> says Sheila. 
            <.q>I think not.<./q> ";
        else
          "<.q>{An obj/he}?<./q> says Sheila quizzically. 
            <.q>{That's obj} not the kind of thing
            I<./s>d want to taste.<./q> ";
      }
      else {
        inherited(obj);
      }
    }
    thingFeelDesc(obj) {
      if (gPlayerChar == bot) {
        gMessageParams(obj);
        "Sheila wheels over to {the obj/him}
          and runs her robotic fingers over {it obj/him}. 
          <.q>Nothing unusual there,<./q>
          she says. ";
      }
      else {
        inherited(obj);
      }
    }
//
//    obscuredReadDesc(obj) {
//        gMessageParams(obj);
//        "{You/he} can&rsquo;t see {that obj/him} well enough to read {it/him}. ";
//    }
//    dimReadDesc(obj) {
//        gMessageParams(obj);
//        "There&rsquo;s not enough light to read {that obj/him}. ";
//    }
//    litMatchDesc(obj) { "\^<<obj.nameIs>> lit. "; }
//    unlitMatchDesc(obj) { "\^<<obj.nameIs>> an ordinary match. "; }
//    litCandleDesc(obj) { "\^<<obj.nameIs>> lit. "; }
//    putDestContainer(obj) { return 'into ' + obj.theNameObj; }
//    putDestSurface(obj) { return 'onto ' + obj.theNameObj; }
//    putDestUnder(obj) { return 'under ' + obj.theNameObj; }
//    putDestBehind(obj) { return 'behind ' + obj.theNameObj; }
//    putDestFloor(obj) { return 'to ' + obj.theNameObj; }
//    listSepMiddle = ", "
//    listSepTwo = " and "
//    listSepEnd = ", and "
//    longListSepMiddle = "; "
//    longListSepTwo = ", and "
//    longListSepEnd = "; and "
//    showScoreMessage(points, maxPoints, turns) {
//        "In <<turns>> move<<turns == 1 ? '' : 's'>>, you have
//        scored <<points>> of a possible <<maxPoints>> point<<
//          maxPoints == 1 ? '' : 's'>>. ";
//    }
//    showScoreNoMaxMessage(points, turns) {
//        "In <<turns>> move<<turns == 1 ? '' : 's'>>, you have
//        scored <<points>> point<<points == 1 ? '' : 's'>>. ";
//    }
//    showScoreRankMessage(msg) { "This makes you <<msg>>. "; }
//    showFullScorePrefix = "Your score consists of:"
//    fullScoreItemPoints(points) {
//        "<<points>> point<<points == 1 ? '' : 's'>> for ";
//    }
//    firstScoreChange(delta) {
//        "<.commandsep><.notification><<
//            basicScoreChange(delta)>><./notification>
//        \n<.notification>If you&rsquo;d prefer not to be notified about
//        score changes in the future, type <<
//        aHref('notify off', 'NOTIFY OFF', 'Turn off score notifications')
//        >>.<./notification> ";
//    }
//    scoreChange(delta) {
//        "<.commandsep><.notification><<
//        basicScoreChange(delta)>><./notification> ";
//    }
//    basicScoreChange(delta) {
//        "Your <<aHref(commandFullScore, 'score', 'Show full score')>>
//        has just <<delta > 0 ? 'in' : 'de'>>creased by
//        <<spellInt(delta > 0 ? delta : -delta)>>
//        point<<delta is in (1, -1) ? '' : 's'>>.";
//    }
//    footnoteRef(num) {
//        local str;
//        str = '<sup>[<a href="footnote ' + num + '"><.a>';
//        str += num;
//        str += '<./a></a>]</sup>';
//        return str;
//    }
//    firstFootnote() {
//        "<.commandsep><.notification>A number in [square brackets] like
//        the one above refers to a footnote, which you can read by typing
//        FOOTNOTE followed by the number: 
//        <<aHref('footnote 1', 'FOOTNOTE 1', 'Show footnote [1]')>>,
//        for example.  Footnotes usually contain added background information
//        that might be interesting but isn&rsquo;t essential to the story.
//        If you&rsquo;d prefer not to see footnotes at all,
//        you can control their appearance by typing
//        <<aHref('footnotes', 'FOOTNOTES',
//                'Control footnote appearance')>>.<./notification> ";
//    }
//    noSuchFootnote(num) {
//        "<.parser>The story has never referred to any such
//        footnote.<./parser> ";
//    }
//    showFootnoteStatus(stat) {
//        "The current setting is FOOTNOTES ";
//        switch(stat)
//        {
//        case FootnotesOff:
//            "OFF, which hides all footnote references.
//            Type <<aHref('footnotes medium', 'FOOTNOTES MEDIUM',
//                         'Set footnotes to Medium')>> to
//            show references to footnotes except those you&rsquo;ve
//            already seen, or <<aHref('footnotes full', 'FOOTNOTES FULL',
//                                     'Set footnotes to Full')>>
//            to show all footnote references. ";
//            break;
//        case FootnotesMedium:
//            "MEDIUM, which shows references to unread footnotes, but
//            hides references to those you&rsquo;ve already read.  Type
//            <<aHref('footnotes off', 'FOOTNOTES OFF',
//                    'Turn off footnotes')>> to hide
//            footnote references entirely, or <<aHref(
//                'footnotes full', 'FOOTNOTES FULL',
//                'Set footnotes to Full')>> to show every reference, even to
//            notes you&rsquo;ve already read. ";
//            break;
//        case FootnotesFull:
//            "FULL, which shows every footnote reference, even to
//            notes you&rsquo;ve already read.  Type <<aHref('footnotes medium',
//            'FOOTNOTES MEDIUM', 'Set footnotes to Medium')>> to show
//            only references to notes you
//            haven&rsquo;t yet read, or <<aHref('footnotes off', 'FOOTNOTES OFF',
//                'Turn off footnotes')>>
//            to hide footnote references entirely. ";
//            break;
//        }
//    }
//    acknowledgeFootnoteStatus(stat) {
//        "<.parser>The setting is now FOOTNOTES <<
//        stat == FootnotesOff ? 'OFF'
//        : stat == FootnotesMedium ? 'MEDIUM'
//        : 'FULL' >>.<./parser> ";
//    }
//    mainCommandPrompt(which) { "\b&gt;"; }
    emptyCommandResponse {
      if (gPlayerChar == bot) {
        "<.q><<rand('What did you say?'
                   ,'I didn<./s>t quite catch that,')>><./q>
            says Sheila. ";
      }
      else {
        inherited;
      }
    }
    invalidCommandToken(ch) {
      if (gPlayerChar == bot) {
        "Apologetically, Sheila says, <.q>The character 
          <.s><<ch>>><./s> isn<./s>t in my data banks. 
          Maybe you could say that some other way.<./q> ";
      }
      else {
        inherited(ch);
      }
    }
//    commandResultsPrefix = '<.p0>'
//    commandInterruptionPrefix = '<.p>'
//    commandResultsSeparator = '<.p>'
//    complexResultsSeparator = '<.p>'
//    internalResultsSeparator = '<.p>'
//    commandResultsSuffix = ''
//    commandResultsEmpty = 'Nothing obvious happens.<.p>'
//    intraCommandSeparator = '<.p>'
//    smellDescSeparator() {
//        "<.p>";
//    }
//    soundDescSeparator() {
//        "<.p>";
//    }
//    cannotTalkTo(targetActor, issuingActor) {
//        "\^<<targetActor.nameIs>> not something <<issuingActor.itNom>>
//        can talk to. ";
//    }
//    alreadyTalkingTo(actor, greeter) {
//        "\^<<greeter.theName>> already <<greeter.verbToHave>>
//        <<actor.theNamePossAdj>> attention. ";
//    }
//    noTopicsNotTalking = "<.parser>{You're} not currently talking
//                          to anyone.<./parser> "
//    oopsNote() {
//        if (offerOopsNote) {
//            "<.commandsep><.notification>If this was an accidental
//            misspelling, you can correct it by typing OOPS followed by the
//            corrected word now.  Any time the story points out an unknown
//            word, you can correct a misspelling using OOPS as your next
//            command.<./notification> ";
//            libMessages.offerOopsNote = nil;
//        }
//    }
//    oopsOutOfContext = "<.parser>You can only use OOPS to correct
//        a misspelling immediately after the story points out a word
//        it doesn&rsquo;t know.<./parser> "
//    oopsMissingWord = "<.parser>To use OOPS to correct a misspelling,
//        put the corrected word after OOPS, as in OOPS BOOK.<./parser> "
//    acknowledgeVerboseMode(verbose) {
//        if (verbose)
//            "<.parser>VERBOSE mode is now selected.<./parser> ";
//        else
//            "<.parser>TERSE mode is now selected.<./parser> ";
//    }
//    showNotifyStatus(stat) {
//        "<.parser>Score notifications are
//        currently <<stat ? 'on' : 'off'>>.<./parser> ";
//    }
//    acknowledgeNotifyStatus(stat) {
//        "<.parser>Score notifications are now
//        <<stat ? 'on' : 'off'>>.<./parser> ";
//    }
//    announceMultiActionObject(obj, whichObj, action) {
//        return '\n<.announceObj>' + obj.name + ':<./announceObj> ';
//    }
//    announceAmbigActionObject(obj, whichObj, action) {
//        return '<.assume>' + obj.theName + '<./assume>\n';
//    }
//    announceDefaultObject(obj, whichObj, action, resolvedAllObjects) {
//        return '<.assume>'
//            + action.announceDefaultObject(obj, whichObj, resolvedAllObjects)
//            + '<./assume>\n';
//    }
//    noCommandForAgain() {
//        "<.parser>There&rsquo;s nothing to repeat.<./parser> ";
//    }
//    againCannotChangeActor() {
//        "<.parser>To repeat a command like <q>turtle, go north,</q>
//        just say <q>again,</q> not <q>turtle, again.</q><./parser> ";
//    }
//    againCannotTalkToTarget(issuer, target) {
//        "\^<<issuer.theName>> cannot repeat that command. ";
//    }
//    againNotPossible(issuer) {
//        "That command cannot be repeated now. ";
//    }
//    systemActionToNPC() {
//        "<.parser>This command cannot be directed to another
//        character in the story.<./parser> ";
//    }
//    confirmQuit() {
//        "Do you really want to quit?\ (<<aHref('y', 'Y', 'Confirm quitting')
//        >> is affirmative) >\ ";
//    }
//    okayQuitting() { }
//    notTerminating() {
//        "<.parser>Continuing the story.<./parser> ";
//    }
//    confirmRestart() {
//        "Do you really want to start over?\ (<<aHref('Y', 'Y',
//        'Confirm restart')>> is affirmative) >\ ";
//    }
//    notRestarting() { "<.parser>Continuing the story.<./parser> "; }
//    showFinishMsg(msg) { "<.p>*** <<msg>>\ ***<.p>"; }
//    finishDeathMsg = 'YOU HAVE DIED'
//    finishVictoryMsg = 'YOU HAVE WON'
//    finishFailureMsg = 'YOU HAVE FAILED'
//    finishGameOverMsg = 'GAME OVER'
//    getSavePrompt =
//        'Please select a file in which to save the current position'
//    getRestorePrompt = 'Please select the saved position file to restore'
//    saveOkay() { "<.parser>Saved.<./parser> "; }
//    saveCanceled() { "<.parser>Canceled.<./parser> "; }
//    saveFailed(exc) {
//        "<.parser>Failed; your computer might be running low
//        on disk space, or you might not have the necessary permissions
//        to write this file.<./parser> ";
//    }
//    noteMainRestore() { "<.parser>Restoring saved game...<./parser>\n"; }
//    restoreOkay() { "<.parser>Restored.<./parser> "; }
//    restoreCanceled() { "<.parser>Canceled.<./parser> "; }
//    restoreInvalidFile() {
//        "<.parser>Failed: this is not a valid saved
//        position file.<./parser> ";
//    }
//    restoreCorruptedFile() {
//        "<.parser>Failed: this saved state file appears to be
//        corrupted.  This can occur if the file was modified by another
//        program, or the file was copied between computers in a non-binary
//        transfer mode, or the physical media storing the file were
//        damaged.<./parser> ";
//    }
//    restoreInvalidMatch() {
//        "<.parser>Failed: the file was not saved by this
//        story (or was saved by an incompatible version of
//        the story).<./parser> ";
//    }
//    restoreFailed(exc) {
//        "<.parser>Failed: the position could not be
//        restored.<./parser> ";
//    }
//    filePromptFailed() {
//        "<.parser>A system error occurred asking for a filename.
//        Your computer might be running low on memory, or might have a
//        configuration problem.<./parser> ";
//    }
//    pausePrompt() {
//        "<.parser>The story is now paused.  Please press
//        the space bar when you are ready to resume the story, or
//        press the &lsquo;S&rsquo; key to save the current position.<./parser><.p>";
//    }
//    pauseSaving() {
//        "<.parser>Saving the story...<./parser><.p>";
//    }
//    pauseEnded() {
//        "<.parser>Resuming the story.<./parser> ";
//    }
//    inputScriptOkay(fname) {
//        "<.parser>Reading commands from <q><<fname.htmlify()
//         >></q>...<./parser>\n ";
//    }
//    getScriptingPrompt = 'Please select a name for the new script file'
//    scriptingOkay() {
//        "<.parser>Text will now be saved to the script file.
//        Type <<aHref('script off', 'SCRIPT OFF', 'Turn off scripting')>> to
//        discontinue scripting.<./parser> ";
//    }
//    scriptingCanceled = "<.parser>Canceled.<./parser> "
//    scriptOffOkay = "<.parser>Scripting ended.<./parser> "
//    scriptOffIgnored = "<.parser>No script is currently being
//                        recorded.<./parser> "
//    getRecordingPrompt = 'Please select a name for the new command log file'
//    recordingOkay = "<.parser>Commands will now be recorded.  Type
//                     <<aHref('record off', 'RECORD OFF',
//                             'Turn off recording')>>
//                     to stop recording commands.<.parser> "
//    recordingCanceled = "<.parser>Canceled.<./parser> "
//    recordOffOkay = "<.parser>Command recording ended.<./parser> "
//    recordOffIgnored = "<.parser>No command recording is currently being
//                        made.<./parser> "
//    getReplayPrompt = 'Please select the command log file to replay'
//    replayCanceled = "<.parser>Canceled.<./parser> "
//    undoOkay(actor, cmd) {
//        "<.parser>Taking back one turn: <q>";
//        if (actor != nil)
//            "<<actor>>, ";
//        "<<cmd>></q>.<./parser><.p>";
//    }
//    undoFailed() {
//        "<.parser>No more undo information is
//        available.<./parser> ";
//    }
//    noteAccepted = "Noted. "
//    noteWithoutScript = "<.p><.notification>Note that the transcript isn&rsquo;t
//        currently being recorded.  NOTE is usually used to provide feedback
//        to the author by putting a comment in the transcript, so it&rsquo;s most
//        useful when you&rsquo;re saving the transcript to a file.  If you want
//        to start saving the transcript, please type <<
//          aHref('script', 'SCRIPT', 'Begin saving the transcript')
//          >>.<./notification> "
//    invalidFinishOption(resp) {
//        "\bThat isn&rsquo;t one of the options. ";
//    }
//    exitsOnOffOkay(stat) {
//        "<.parser>The list of exits will <<
//        stat ? 'now' : 'no longer'>> be
//        displayed in each room description.<./parser> ";
//    }
//    explainExitsOnOff =
//        "<.p><.notification>You can control whether or not the exit list
//        is automatically displayed in each room description by typing
//        <<aHref('exits on', 'EXITS ON', 'Activate exit display')>> or
//        <<aHref('exits off', 'EXITS OFF', 'Turn off exit display'
//               )>>.<./notification> "
//    hintsDisabled = '<.parser>Hints are now disabled.<./parser> '
//    sorryHintsDisabled = '<.parser>Sorry, but hints have been disabled
//                          for this session, as you requested.  If you&rsquo;ve
//                          changed your mind, you&rsquo;ll have to save your
//                          current position, exit the TADS interpreter,
//                          and start a new interpreter session.<./parser> '
//    hintsNotPresent = '<.parser>Sorry, this story doesn&rsquo;t
//                       have any built-in hints.<./parser> '
//    currentlyNoHints = '<.parser>Sorry, no hints are currently available.
//                        Please check back later.<./parser> '
//    showHintWarning =
//       "<.notification>Warning: Some people don&rsquo;t like built-in hints,
//       since the temptation to ask for help prematurely can become
//       overwhelming when hints are so close at hand.  If you&rsquo;re worried
//       that your willpower won&rsquo;t hold up, you can disable hints for the
//       rest of this session by typing <<aHref('hints off', 'HINTS OFF')
//       >>.  If you still want to see the hints now, type
//       <<aHref('hint', 'HINT')>>.<./notification> "
//    hintsDone = '<.parser>Done.<./parser> '
//    commandNotPresent = "<.parser>That command isn&rsquo;t needed
//                         in this story.<./parser> "
//    scoreNotPresent = "<.parser>This story doesn&rsquo;t use
//                       scoring.<./parser> "
//    mentionFullScore = "<.p><.notification>To see a detailed accounting
//        of your score, type <<
//          aHref('full score', 'FULL SCORE') >>.<./notification> "
//    menuKeyList = [
//                   ['q'],
//                   ['p', '[left]', '[bksp]', '[esc]'],
//                   ['u', '[up]'],
//                   ['d', '[down]'],
//                   ['ENTER', '\n', '[right]', ' ']
//                  ]
//    prevMenuLink = '<font size=-1>Previous</font>'
//    nextMenuTopicLink = '<font size=-1>Next</font>'
//    textMenuMainPrompt(keylist) {
//        "\bSelect a topic number, or press &lsquo;<<
//        keylist[M_PREV][1]>>&rsquo; for the previous
//        menu or &lsquo;<<keylist[M_QUIT][1]>>&rsquo; to quit:\ ";
//    }
//    textMenuTopicPrompt() {
//        "\bPress the space bar to display the next line,
//        &lsquo;<b>P</b>&rsquo; to go to the previous menu, or
//        &lsquo;<b>Q</b>&rsquo; to quit.\b";
//    }
//    menuTopicProgress(cur, tot) { " [<<cur>>/<<tot>>]"; }
//    menuTopicListEnd = '[The End]'
//    menuLongTopicEnd = '[The End]'
//    menuInstructions(keylist, prevLink) {
//        "<tab align=right ><b>\^<<keylist[M_QUIT][1]>></b>=Quit <b>\^<<
//        keylist[M_PREV][1]>></b>=Previous Menu<br>
//        <<prevLink != nil ? aHrefAlt('previous', prevLink, '') : ''>>
//        <tab align=right ><b>\^<<keylist[M_UP][1]>></b>=Up <b>\^<<
//        keylist[M_DOWN][1]>></b>=Down <b>\^<<
//        keylist[M_SEL][1]>></b>=Select<br>";
//    }
//    menuNextChapter(keylist, title, hrefNext, hrefUp) {
//        "Next: <a href='<<hrefNext>>'><<title>></a>;
//        <b>\^<<keylist[M_PREV][1]>></b>=<a href='<<hrefUp>>'>Menu</a>";
//    }
    cannotReachObject(obj) {
      if (gPlayerChar == bot) {
        gMessageParams(obj);
        "<.q>I can<./s>t reach {that obj}!<./q> says Sheila. ";
      }
      else {
        inherited(obj);
      }
    }
//    cannotReachContents(obj, loc) {
//        gMessageParams(obj, loc);
//        return '{You/he} cannot reach {the obj/him} through {the loc/him}. ';
//    }
//    cannotReachOutside(obj, loc) {
//        gMessageParams(obj, loc);
//        return '{You/he} cannot reach {the obj/him} through {the loc/him}. ';
//    }
//    soundIsFromWithin(obj, loc) {
//        "\^<<obj.theName>> appear<<obj.verbEndingS>> to be
//        coming from inside <<loc.theNameObj>>. ";
//    }
//    soundIsFromWithout(obj, loc) {
//        "\^<<obj.theName>> appear<<obj.verbEndingS>> to be
//        coming from outside <<loc.theNameObj>>. ";
//    }
//    smellIsFromWithin(obj, loc) {
//        "\^<<obj.theName>> appear<<obj.verbEndingS>> to be
//        coming from inside <<loc.theNameObj>>. ";
//    }
//    smellIsFromWithout(obj, loc) {
//        "\^<<obj.theName>> appear<<obj.verbEndingS>> to be
//        coming from outside <<loc.theNameObj>>. ";
//    }
//    pcDesc(actor) {
//        "\^<<actor.theName>> look<<actor.verbEndingS>> the same
//        as usual. ";
//    }
//    roomActorStatus(actor) {
//        if (actor.posture != standing)
//            " (<<actor.posture.participle>>)";
//    }
//    actorInRoomStatus(actor, room)
//        { " (<<actor.posture.participle>> <<room.actorInName>>)"; }
//    roomDarkName = 'In the dark'
//    roomDarkDesc = "It&rsquo;s pitch black. "
//    roomActorHereDesc(actor) {
//        "\^<<actor.nameIs>> <<actor.posture.participle>> here. ";
//    }
//    roomActorThereDesc(actor) {
//        "\^<<actor.nameIs>> <<actor.posture.participle>> nearby. ";
//    }
//    actorInRoom(actor, cont) {
//        "\^<<actor.nameIs>> <<actor.posture.participle>>
//        <<cont.actorInName>>. ";
//    }
//    actorInRoomPosture(actor, room) {
//        "\^<<actor.itIs>> <<actor.posture.participle>>
//        <<room.actorInName>>. ";
//    }
//    roomActorPostureDesc(actor) {
//        if (actor.posture != standing)
//            "\^<<actor.itIs>> <<actor.posture.participle>>. ";
//    }
//    actorInRemoteRoom(actor, room, pov) {
//        "\^<<actor.nameIs>> <<actor.posture.participle>>
//        <<room.inRoomName(pov)>>. ";
//    }
//    actorInRemoteNestedRoom(actor, inner, outer, pov) {
//        "\^<<actor.nameIs>> <<outer.inRoomName(pov)>>,
//        <<actor.posture.participle>> <<inner.actorInName>>. ";
//    }
//    actorInGroupPrefix(posture, cont, lst) { "\^"; }
//    actorInGroupSuffix(posture, cont, lst) {
//        " <<lst.length() == 1 ? 'is' : 'are'>> <<posture.participle>>
//        <<cont.actorInName>>. ";
//    }
//    actorInRemoteGroupPrefix(pov, posture, cont, remote, lst) { "\^"; }
//    actorInRemoteGroupSuffix(pov, posture, cont, remote, lst) {
//        " <<lst.length() == 1 ? 'is' : 'are'>> <<remote.inRoomName(pov)>>,
//        <<posture.participle>> <<cont.actorInName>>. ";
//    }
//    actorHereGroupPrefix(posture, lst) { "\^"; }
//    actorHereGroupSuffix(posture, lst) {
//        " <<lst.length() == 1 ? 'is' : 'are'>>
//        <<posture.participle>> here. ";
//    }
//    actorThereGroupPrefix(pov, posture, remote, lst) { "\^"; }
//    actorThereGroupSuffix(pov, posture, remote, lst) {
//        " <<lst.length() == 1 ? 'is' : 'are'>> <<posture.participle>>
//        <<remote.inRoomName(pov)>>. ";
//    }
//    sayArriving(traveler) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerLocName>>. ";
//    }
//    sayDeparting(traveler) {
//        "\^<<traveler.travelerName(nil)>> leave<<traveler.verbEndingS>>
//        <<traveler.travelerLocName>>. ";
//    }
//    sayArrivingLocally(traveler, dest) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerLocName>>. ";
//    }
//    sayArrivingDir(traveler, dirName) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> from the <<dirName>>. ";
//    }
//    sayDepartingDir(traveler, dirName) {
//        local nm = traveler.travelerRemoteLocName;
//        "\^<<traveler.travelerName(nil)>> leave<<traveler.verbEndingS>>
//        to the <<dirName>><<nm != '' ? ' from ' + nm : ''>>. ";
//    }
//    sayArrivingShipDir(traveler, dirName) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> from <<dirName>>. ";
//    }
//    sayDepartingShipDir(traveler, dirName) {
//        local nm = traveler.travelerRemoteLocName;
//        
//        "\^<<traveler.travelerName(nil)>> leave<<traveler.verbEndingS>>
//        to <<dirName>><<nm != '' ? ' from ' + nm : ''>>. ";
//    }
//    sayDepartingAft(traveler) {
//        local nm = traveler.travelerRemoteLocName;
//        
//        "\^<<traveler.travelerName(nil)>> go<<traveler.verbEndingEs>>
//        aft<<nm != '' ? ' from ' + nm : ''>>. ";
//    }
//    sayDepartingFore(traveler) {
//        local nm = traveler.travelerRemoteLocName;
//        "\^<<traveler.travelerName(nil)>> go<<traveler.verbEndingEs>>
//        forward<<nm != '' ? ' from ' + nm : ''>>. ";
//    }
//    notOnboardShip = "That direction isn&rsquo;t meaningful here. "
//    sayDepartingThroughPassage(traveler, passage) {
//        "\^<<traveler.travelerName(nil)>> leave<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> through <<passage.theNameObj>>. ";
//    }
//    sayArrivingThroughPassage(traveler, passage) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> through <<passage.theNameObj>>. ";
//    }
//    sayDepartingViaPath(traveler, passage) {
//        "\^<<traveler.travelerName(nil)>> leave<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> via <<passage.theNameObj>>. ";
//    }
//    sayArrivingViaPath(traveler, passage) {
//        "\^<<traveler.travelerName(true)>> enter<<traveler.verbEndingS>>
//        <<traveler.travelerRemoteLocName>> via <<passage.theNameObj>>. ";
//    }
//    sayDepartingUpStairs(traveler, stairs) {
//        "\^<<traveler.travelerName(nil)>> go<<traveler.verbEndingEs>>
//        up <<stairs.theNameObj>>. ";
//    }
//    sayDepartingDownStairs(traveler, stairs) {
//        "\^<<traveler.travelerName(nil)>> go<<traveler.verbEndingEs>>
//        down <<stairs.theNameObj>>. ";
//    }
//    sayArrivingUpStairs(traveler, stairs) {
//        local nm = traveler.travelerRemoteLocName;
//
//        "\^<<traveler.travelerName(true)>> come<<traveler.verbEndingS>>
//        up <<stairs.theNameObj>><<nm != '' ? ' to ' + nm : ''>>. ";
//    }
//    sayArrivingDownStairs(traveler, stairs) {
//        local nm = traveler.travelerRemoteLocName;
//
//        "\^<<traveler.travelerName(true)>> come<<traveler.verbEndingS>>
//        down <<stairs.theNameObj>><<nm != '' ? ' to ' + nm : ''>>. ";
//    }
//    sayDepartingWith(traveler, lead) {
//        "\^<<traveler.travelerName(nil)>> come<<traveler.verbEndingS>>
//        with <<lead.theNameObj>>. ";
//    }
//    sayDepartingWithGuide(guide, lead) {
//        "\^<<lead.theName>> let<<lead.verbEndingS>>
//        <<guide.theNameObj>> lead the way. ";
//    }
//    sayOpenDoorRemotely(door, stat) {
//        "Someone <<stat ? 'open' : 'close'>>s <<door.theNameObj>> from
//        the other side. ";
//    }
//    openMsg(obj) { return 'open'; }
//    closedMsg(obj) { return 'closed'; }
//    currentlyOpen = '{It\'s dobj} currently open. '
//    currentlyClosed = '{It\'s dobj} currently closed. '
//    openStatusMsg(obj) { return obj.itIsContraction + ' ' + obj.openDesc; }
//    lockedMsg(obj) { return 'locked'; }
//    unlockedMsg(obj) { return 'unlocked'; }
//    currentlyLocked = '{It\'s dobj} currently locked. '
//    currentlyUnlocked = '{It\'s dobj} currently unlocked. '
//    onMsg(obj) { return 'on'; }
//    offMsg(obj) { return 'off'; }
//    matchBurnedOut(obj) {
//        gMessageParams(obj);
//        "{The obj/he} finish{es} burning, and disappear{s} into a
//        cloud of ash. ";
//    }
//    candleBurnedOut(obj) {
//        gMessageParams(obj);
//        "{The obj/he} burn{s} down too far to stay lit, and go{es} out. ";
//    }
//    objBurnedOut(obj) {
//        gMessageParams(obj);
//        "{The obj/he} go{es} out. ";
//    }
;

//modify playerMessages //: libMessages
botPlayerMessages: playerMessages
    commandNotUnderstood(actor) {
        "<.q>I don<./s>t understand that, sorry,<./q> 
        says Sheila. <.q>I understood your words, 
        but not the way you arranged them.<./q> ";
    }
    specialTopicInactive(actor) {
        "<.q>I don<./s>t see how to do that right now,<./q> 
        says Sheila. ";
    }
    // EXTREMELY IMPORTANT: THIS NEEDS 3 PARAMETERS!!!!
    // 2019-05-18 GWB: I want to be extra careful about replacing noMatch(). 
    // Somehow, an incorrectly parameterized version of this function...
    // noMatch(actor, txt) // <-- WRONG!
    // ...rather than...
    // noMatch(actor, action, txt)
    // ...got into my code, either from an old version of TADS 3 or from
    // me making a mistake. 
    noMatch(actor, action, txt) {
        "<.q>I don<./s>t see any <<txt>> here,<./q>
        says Sheila. ";
    }
    allNotAllowed(actor) {
        "<.q>I can<./s>t just act on everything in sight 
        all at once,<./q> says Sheila. <.q>At least, 
        not when I<./s>m doing something like that.<./q> ";
    }
    noMatchForAll(actor) {
        "<.q>I don<./s>t see anything suitable here,<./q>
        says Sheila. ";
    }
    noMatchForAllBut(actor) {
        "<.q>I don<./s>t see anything suitable here,<./q>
        says Sheila. ";
    }
    noMatchForListBut(actor) { noMatchForAllBut(actor); }
    noMatchForPronoun(actor, typ, pronounWord) {
        "<.q>Sorry, but you<./s>re going to have 
        to tell me what you mean
        by <.s><<pronounWord>>,<./s><./q>
        says Sheila. ";
    }
    reflexiveNotAllowed(actor, typ, pronounWord) {
        "<.q>Sorry, but I don<./s>t understand how to
        use the word <.s><<pronounWord>><./s> like that,<./q>
        says Sheila. ";
    }
    wrongReflexive(actor, typ, pronounWord) {
        "<.q>Sorry, but I don<./s>t know what you mean
        by <.s><<pronounWord>>,<./s><./q> says Sheila. ";
    }
    noMatchForPossessive(actor, owner, txt) {
        "<.q>\^<<owner.theName>> <<owner.verbToDo>>n<./s>t 
        have anything like that, as far as I can tell,<./q>
        says Sheila. ";
    }
    noMatchForLocation(actor, loc, txt) {
        "<.q>I don<./s>t see any <<loc.childInName(txt)>> 
        here,<./q> says Sheila. ";
    }
    nothingInLocation(actor, loc) {
        "<.q>I don<./s>t see much of anything there,<./q>
        says Sheila. ";
    }
    noMatchDisambig(actor, origPhrase, disambigResponse) {
        "<.q>Sorry, but that wasn<./s>t one of the 
        choices,<./q> says Sheila. ";
    }
    emptyNounPhrase(actor) {
        "<.q>I don<./s>t understand what thing you meant,<./q>
        says Sheila. <.q>Maybe you could rephrase.<./q> ";
    }
    zeroQuantity(actor, txt) {
        "<.q>I can<./s>t do that to zero of something,<./q>
        says Sheila. ";
    }
    insufficientQuantity(actor, txt, matchList, requiredNum) {
        "<.q>Sorry, but I don<./s>t see that
        many <<txt>> here,<./q> says Sheila. ";
    }
    uniqueObjectRequired(actor, txt, matchList) {
        "<.q>I can<./s>t just act on a bunch of things
        all at once,<./q> says Sheila. <.q>At least, 
        not when I<./s>m doing something like that.<./q> ";
    }
    singleObjectRequired(actor, txt) {
        "<.q>I can<./s>t just act on a bunch of things
        all at once,<./q> says Sheila. <.q>At least, 
        not when I<./s>m doing something like that.<./q> ";
    }
    disambigOrdinalOutOfRange(actor, ordinalWord, originalText) {
        "<.q>Sorry, but there weren<./s>t that many 
        choices,<./q> says Sheila. ";
    }
    askDisambig(actor, originalText, matchList, fullMatchList,
                requiredNum, askingAgain, dist)
    {
        reportQuestion('');
        //if (!askingAgain)
        //    "<.parser>";
        "<.q>";
        if (requiredNum == 1) {
            if (askingAgain)
                "Which did you mean,
                <<askDisambigList(matchList, fullMatchList, nil, dist)>>?";
            else
                "Which <<originalText>> do you mean,
                <<askDisambigList(matchList, fullMatchList, nil, dist)>>?";
        }
        else {
            if (askingAgain)
                "Which <<spellInt(requiredNum)>> (of
                <<askDisambigList(matchList, fullMatchList, true, dist)>>)
                did you mean?";
            else
                "Which <<spellInt(requiredNum)>>
                (of <<askDisambigList(matchList, fullMatchList,
                                      true, dist)>>) do you mean?";
        }
        //"<./parser> ";
        "<./q> Sheila asks. ";
    }
    ambiguousNounPhrase(actor, originalText, matchList, fullMatchList) {
        "<.q>Sorry, but I don<./s>t know which <<originalText>> 
        you<./s>re talking about,<./q> says Sheila.
        <.q>Maybe you could rephrase.<./q> ";
    }
    missingActor(actor) {
        "<.q>If you were trying to talk to someone, you should
        just type <.s>talk to person,<./s><./q> says Sheila. ";
    }
    singleActorRequired(actor) {
        //"<.q>I can<./s>t talk to more than one person at once,<./q>
        //says Sheila. <.q>Also,
        //if you want to talk to someone, just type
        //<.s>talk to person.<./s><./q> ";
        "<.q>If you want to talk to someone, just type
        <.s>talk to person,<./s><./q> says Sheila.
        <.q>And it<./s>s usually easiest just to talk to one person
        at a time.<./q> ";
    }
    cannotChangeActor() {
        //"<.q>I can<./s>t talk to multiple people like that,<./q>
        //says Sheila. <.q>Also,
        //if you want to talk to someone, just type
        //<.s>talk to person.<./s><./q> ";
        "<.q>Were you trying to address than one person 
        at a time?<./q> asks Sheila. <.q>If so, maybe
        you could rephrase. That<./s>s a little too complicated
        for me.<./q> ";
    }
    askUnknownWord(actor, txt) {
        "<.q>Sorry, but <.s><<txt>><./s> isn<./s>t
        in my database of words,<./q> says Sheila. 
        <.q>Maybe you could rephrase.<./q> ";
        //oopsNote();
    }
    wordIsUnknown(actor, txt) {
        "<.q>Sorry, but <.s><<txt>><./s> isn<./s>t
        in my database of words,<./q> says Sheila. ";
    }
//    refuseCommandBusy(targetActor, issuingActor) {
//        "\^<<targetActor.nameIs>> busy. ";
//    }
    cannotAddressMultiple(actor) {
        //"<.q>I can<./s>t talk to more than one person at once,<./q>
        //says Sheila. <.q>Also,
        //if you want to talk to someone, you should just type
        //<.s>talk to person.<./s><./q> ";
        "<.q>If you want to talk to someone, just type
        <.s>talk to person,<./s><./q> says Sheila.
        <.q>And it<./s>s usually easiest just to talk to one person
        at a time.<./q> ";
    }
;

//modify playerActionMessages //: MessageHelper
botPlayerActionMessages: playerActionMessages
    cannotDoThatMsg = '<.q>Sorry, but I don<./s>t know
        how to do that,<./q> says Sheila. '
    mustBeHoldingMsg(obj) {
        gMessageParams(obj);
        return '<.q>I<./s>d have to be holding {the obj/him}
            before I could do that,<./q> says Sheila. ';
    }
//    tooDarkMsg = 'It&rsquo;s too dark to do that. '
    mustBeVisibleMsg(obj) {
        gMessageParams(obj);
        return '<.q>I can<./s>t see {that obj/him},<./q> 
            says Sheila. ';
    }
//    heardButNotSeenMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} can hear {an obj/him}, but {you/he}
//                 can&rsquo;t see{s} {it obj/him}. ';
//    }
//    smelledButNotSeenMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} can smell {an obj/him}, but {you/he}
//                can&rsquo;t see{s} {it obj/him}. ';
//    }
    cannotHearMsg(obj) {
        gMessageParams(obj);
        return '<.q>I can<./s>t hear {that obj/him},<./q> 
            says Sheila. ';
    }
    cannotSmellMsg(obj) {
        gMessageParams(obj);
        return '<.q>Sorry,<./q> says Sheila, <.q>but I was not 
          equipped with a sense of smell.<./q> ';
    }
    cannotTasteMsg(obj) {
        gMessageParams(obj);
        return '<.q>Sorry,<./q> says Sheila, <.q>but I was not 
          equipped with taste buds.<./q> ';
    }
//    cannotBeWearingMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must take off {the obj/him}
//                before {it actor/he} can do that. ';
//    }
//    mustBeEmptyMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must take everything out of {the obj/him}
//                before {it actor/he} can do that. ';
//    }
//    mustBeOpenMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must open {the obj/him}
//                before {it actor/he} can do that. ';
//    }
//    mustBeClosedMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must close {the obj/him}
//               before {it actor/he} can do that. ';
//    }
//    mustBeUnlockedMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must unlock {the obj/him}
//                before {it actor/he} can do that. ';
//    }
//    noKeyNeededMsg = '{The dobj/he} do{es} not appear to take a key. '
//    mustBeStandingMsg = '{You/he} must stand up before {it actor/he}
//                      can do that. '
//    mustSitOnMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must sit {in obj} first. ';
//    }
//    mustLieOnMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must lie {in obj} first. ';
//    }
//    mustGetOnMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must get {in obj} first. ';
//    }
//    mustBeInMsg(obj, loc) {
//        gMessageParams(obj, loc);
//        return '{The obj/he} must be {in loc} before {you/he}
//            can do that. ';
//    }
    mustBeCarryingMsg(obj, actor) {
        gMessageParams(obj, actor);
        if (actor == bot)
            return '<.q>I<./s>d have to be carrying {the obj/him}
                before I could do that,<./q> says Sheila. ';
        else
            return '<.q>{The actor/he} would have to be carrying
                {the obj/him} before {it actor/he} could do that,<./q> 
                says Sheila. ';
    }
    decorationNotImportantMsg(obj) {
        gMessageParams(obj);
        return 'Sheila lowers her voice conspiratorially 
            and says, <.q>I think {that\'s obj} just ' 
            + (!obj.isPlural ? 'scenery' : 'scenery')
            + '. We probably don<./s>t need to worry about 
            {it obj/him}.<./q> ';
    }
    unthingNotHereMsg(obj) {
        gMessageParams(obj);
        return '<.q>I don<./s>t see {that obj/him} here,<./q> 
            says Sheila. ';
    }
    tooDistantMsg(obj) {
        gMessageParams(obj);
        return '<.q>Sorry, but {that\'s obj/he} 
            too far away,<./q> says Sheila. ';
    }
//    notWithIntangibleMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} can&rsquo;t do that to {an obj/him}. ';
//    }
//    notWithVaporousMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} can&rsquo;t do that to {an obj/him}. ';
//    }
//    lookInVaporousMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} just see{s} {the obj/him}. ';
//    }
//    cannotReachObjectMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot reach {the obj/him}. ';
//    }
//    cannotReachThroughMsg(obj, loc) {
//        gMessageParams(obj, loc);
//        return '{You/he} cannot reach {the obj/him} through {the loc/him}. ';
//    }
    thingDescMsg(obj) {
        gMessageParams(obj);
        return '<.q>I don<./s>t see anything special about 
            {it obj/him},<./q> says Sheila. ';
    }
    thingSoundDescMsg(obj) {
        gMessageParams(obj);
        return '<.q>I don<./s>t hear anything unusual,<./q>
            says Sheila. ';
    }
    thingSmellDescMsg(obj) {
        gMessageParams(obj);
        return '<.q>I don<./s>t smell anything unusual,<./q>
            says Sheila. ';
    }
    npcDescMsg(npc) {
        gMessageParams(npc);
        return '<.q>{It npc/he} look{s} as good-looking
            as ever, I suppose,<./q> says Sheila. ';
    }
    nothingInsideMsg = 
        '<.q>I don<./s>t see anything in {the dobj/him},<./q> 
        says Sheila. '
    nothingUnderMsg = 
        '<.q>I don<./s>t see anything under {the dobj/him},<./q> 
        says Sheila. '
    nothingBehindMsg =
        '<.q>I don<./s>t see anything behind {the dobj/him},<./q> 
        says Sheila. '
    nothingThroughMsg = 
        '<.q>I can<./s>t see anything through {the dobj/him},<./q> 
        says Sheila. '
//    cannotLookBehindMsg = '{You/he} can&rsquo;t look behind {the dobj/him}. '
//    cannotLookUnderMsg = '{You/he} can&rsquo;t look under {the dobj/him}. '
//    cannotLookThroughMsg = '{You/he} can&rsquo;t see through {the dobj/him}. '
//    nothingBeyondDoorMsg = 'Opening {the dobj/him} reveals nothing
//        unusual. '
    nothingToSmellMsg = 
        '<.q>Sorry,<./q> says Sheila, <.q>but I was not 
          equipped with a sense of smell.<./q> '
    nothingToHearMsg = 
        'Sheila listens, then says, <.q>I can<./s>t hear much of 
          anything.<./q> '
//    noiseSourceMsg(src) {
//        return '{The dobj/he} seem{s} to be coming from '
//            + src.theNameObj + '. ';
//    }
//    odorSourceMsg(src) {
//        return '{The dobj/he} seem{s} to be coming from '
//            + src.theNameObj + '. ';
//    }
    notWearableMsg =
        '<.q>I don<./s>t see how I can wear 
        {the dobj/him},<./q> says Sheila. '
    notDoffableMsg =
        '<.q>I don<./s>t see how I can remove 
        {the dobj/him},<./q> says Sheila. '
    alreadyWearingMsg = 
        '<.q>In case you hadn<./s>t noticed, 
        I<./s>m already wearing {the dobj/him},<./q>
        says Sheila. '
    notWearingMsg =
        '<.q>In case you hadn<./s>t noticed, 
        I<./s>m not wearing {the dobj/him},<./q>
        says Sheila. '
    okayWearMsg = 
        okayStr() + ' says Sheila, and she puts on {the dobj/him}. '
    okayDoffMsg = 
        okayStr() + ' says Sheila, and she removes {the dobj/him}. '
    okayOpenMsg = 
        okayStr() + ' says Sheila, and she opens {the dobj/him}. '
    okayCloseMsg = 
        okayStr() + ' says Sheila, and she closes {the dobj/him}. '
    okayLockMsg = 
        okayStr() + ' says Sheila, and she locks {the dobj/him}. '
    okayUnlockMsg = 
        okayStr() + ' says Sheila, and she unlocks {the dobj/him}. '
    cannotDigMsg = 
        '<.q>Sorry, but I don<./s>t know how to dig in 
        {that dobj/him},<./q> says Sheila. '
    cannotDigWithMsg =
        '<.q>Sorry, but I don<./s>t know how to dig in anything
        with {that iobj/him},<./q> says Sheila. '
    alreadyHoldingMsg =
        '<.q>In case you hadn<./s>t noticed, 
        I<./s>m already carrying {the dobj/him},<./q>
        says Sheila. '
    takingSelfMsg = 
        '<.q>What, you want me to take myself into my own possession?<./q> 
        says Sheila. <.q>I think not.<./q> '
    notCarryingMsg =
        '<.q>In case you hadn<./s>t noticed, 
        I<./s>m not carrying {the dobj/him},<./q>
        says Sheila. '
    droppingSelfMsg =
        '<.q>What, you want me to drop myself?<./q> 
        says Sheila. <.q>I think not.<./q> '
    puttingSelfMsg =
        '<.q>So you want me to put myself somewhere, do you?<./q>
        says Sheila. <.q>Well, that<./s>s fine by me, but you<./s>ll
        have to explain how you want me to do that.<./q> '
    alreadyPutInMsg =
        '<.q>In case you hadn<./s>t noticed, 
        {the dobj/he} is already in {the iobj/him},<./q>
        says Sheila. '
    alreadyPutOnMsg =
        '<.q>In case you hadn<./s>t noticed, 
        {the dobj/he} is already on {the iobj/him},<./q>
        says Sheila. '
    alreadyPutUnderMsg =
        '<.q>In case you hadn<./s>t noticed, 
        {the dobj/he} is already under {the iobj/him},<./q>
        says Sheila. '
    alreadyPutBehindMsg =
        '<.q>In case you hadn<./s>t noticed, 
        {the dobj/he} is already behind {the iobj/him},<./q>
        says Sheila. '
    //cannotMoveFixtureMsg {
    //    local vb;
    //    if (gActionIs(Pull)) vb = 'pulls';
    //    else vb = 'pushes';
    //    return 'Sheila walks up to {the dobj/him} and ' + vb 
    //        + ' {it dobj/him} as hard as she can. After some exertion,
    //        she looks up and says, <.q>Looks like 
    //        {the dobj/he} {is}n<./s>t going anywhere.<./q> ';
    //}
    //cannotMoveFixtureMsg =
    //    'Sheila flexes her fingers, then turns to {the dobj/him} 
    //    and tries as hard as she can to move {it dobj/him}. 
    //    After some exertion, she looks up and says, 
    //    <.q>Looks like {it\'s dobj} not going anywhere.<./q> '
    //cannotTakeFixtureMsg =
    //    'Sheila flexes her fingers, then turns to {the dobj/him} 
    //    and tries as hard as she can to pick {it dobj/him} up. 
    //    After some exertion, she looks up and says, 
    //    <.q>Looks like {it\'s dobj} not going anywhere.<./q> '
    cannotMoveFixtureMsg =
        '<.q>I don<./s>t think I can move {that dobj/him},<./q>
        Sheila says. '
    cannotTakeFixtureMsg =
        '<.q>I don<./s>t think I can take {that dobj/him},<./q>
        Sheila says. '
    cannotPutFixtureMsg =
        '<.q>I don<./s>t think I can put {that dobj/him} anywhere,<./q>
        Sheila says. '
    cannotTakeImmovableMsg =
        '<.q>I don<./s>t think I can take {that dobj/him},<./q>
        Sheila says. '
    cannotMoveImmovableMsg =
        '<.q>I don<./s>t think I can move {that dobj/him},<./q>
        Sheila says. '
    cannotPutImmovableMsg =
        '<.q>I don<./s>t think I can put {that dobj/him} anywhere,<./q>
        Sheila says. '
    cannotTakeHeavyMsg =
        'Sheila tries as hard as she can to pick up {the dobj/him},
        without any success. '
    cannotMoveHeavyMsg =
        'Sheila tries as hard as she can to move {the dobj/him},
        without any success. '
    cannotPutHeavyMsg =
        'Sheila tries as hard as she can to move {the dobj/him},
        without any success. '
    cannotMoveComponentMsg(loc) {
        return 'Sheila frowns, then says, 
            <.q>What, move {the dobj/him}?
            But {that\'s dobj/him} part of ' + loc.theNameObj + '.<./q> ';
    }
    cannotTakeComponentMsg(loc) {
        return 'Sheila frowns, then says, 
            <.q>What, take {the dobj/him}?
            But {that\'s dobj/him} part of ' + loc.theNameObj + '.<./q> ';
    }
    cannotPutComponentMsg(loc) {
        return 'Sheila frowns, then says, 
            <.q>What, move {the dobj/him}?
            But {that\'s dobj/him} part of ' + loc.theNameObj + '.<./q> ';
    }
//    cannotTakePushableMsg = '{You/he} can&rsquo;t take {that/him dobj}, but
//        {it actor/he} might be able to push it somewhere. '
//    cannotMovePushableMsg = 'It wouldn&rsquo;t accomplish anything to move
//        {the dobj/him} around aimlessly, but {it actor/he}
//        might be able to push {it dobj/him} in a specific direction. '
//    cannotPutPushableMsg = '{You/he} can&rsquo;t put {that/him dobj} anywhere,
//        but {it actor/he} might be able to push it somewhere. '
    cannotTakeLocationMsg =
        '<.q>One piece of advice,<./q> Sheila says. 
        <.q>Next time you want me to take {the dobj/him},
        try to make sure I<./s>m not inside of it.<./q> '
    okayTakeMsg =
        okayStr() + ' says Sheila, and she picks up {the dobj/him}. '
    okayDropMsg = 
        okayStr() + ' says Sheila, and she drops {the dobj/him}. '
    // Since I don't quite understand when droppingObjMsg is used,
    // I'd better not modify it.
    //droppingObjMsg(dropobj) {
    //    gMessageParams(dropobj);
    //    return '{You/he} drop{s} {the dropobj/him}. ';
    //}
//    floorlessDropMsg(dropobj) {
//        gMessageParams(dropobj);
//        return '{It dropobj/he} fall{s} out of sight below. ';
//    }
    okayPutInMsg =
        okayStr() + ' says Sheila, and she puts {the dobj/him} into {the iobj/him}. '
    okayPutOnMsg =
        okayStr() + ' says Sheila, and she puts {the dobj/him} onto {the iobj/him}. '
    okayPutUnderMsg =
        okayStr() + ' says Sheila, and she puts {the dobj/him} under {the iobj/him}. '
    okayPutBehindMsg =
        okayStr() + ' says Sheila, and she puts {the dobj/him} behind {the iobj/him}. '
    cannotTakeActorMsg = (cannotTakeOrMoveActor)
    cannotMoveActorMsg = (cannotTakeOrMoveActor)
    cannotPutActorMsg = (cannotTakeOrMoveActor)
    cannotTakePersonMsg = (cannotTakeOrMoveActor)
    cannotMovePersonMsg = (cannotTakeOrMoveActor)
    cannotPutPersonMsg = (cannotTakeOrMoveActor)
    // This is my own property. It doesn't exist in the library.
    cannotTakeOrMoveActor =
        '<.q>I<./s>m betting {the dobj/him} wouldn<./s>t 
        appreciate that,<./q> says Sheila. <.q>Besides, 
        I don<./s>t see much point in trying that anyway.<./q> '
//    cannotMoveThroughMsg(obj, obs) {
//        gMessageParams(obj, obs);
//        return '{You/he} can&rsquo;t move {that obj/him} through {the obs/him}. ';
//    }
//    cannotMoveThroughContainerMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} can&rsquo;t move {that obj/him} through {the cont/him}. ';
//    }
//    cannotMoveThroughClosedMsg(obj, cont) {
//        gMessageParams(cont);
//        return '{You/he} can&rsquo;t do that because {the cont/he} {is} closed. ';
//    }
//    cannotFitIntoOpeningMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} can&rsquo;t do that because {the obj/he} {is}
//                too big to put into {the cont/him}. ';
//    }
//    cannotFitOutOfOpeningMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} can&rsquo;t do that because {the obj/he} {is}
//                too big to take out of {the cont/him}. ';
//    }
//    cannotTouchThroughContainerMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} can&rsquo;t reach anything through {the cont/him}. ';
//    }
//    cannotTouchThroughClosedMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} can&rsquo;t do that because
//               {the cont/he} {is} closed. ';
//    }
//    cannotReachIntoOpeningMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} can&rsquo;t fit {its/her} hand into {the cont/him}. ';
//    }
//    cannotReachOutOfOpeningMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} can&rsquo;t fit {its/her} hand through
//               {the cont/him}. ';
//    }
//    tooLargeForActorMsg(obj) {
//        gMessageParams(obj);
//        return '{The obj/he} {is} too large for {you/him} to hold. ';
//    }
//    handsTooFullForMsg(obj) {
//        return '{Your} hands are too full to hold ' + obj.theNameObj + '. ';
//    }
//    becomingTooLargeForActorMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot do that because {the obj/he}
//                would become too large for {you/him} to hold. ';
//    }
//    handsBecomingTooFullForMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} cannot do that because {your} hands
//            would become too full to hold {the obj/him}. ';
//    }
//    tooHeavyForActorMsg(obj) {
//        gMessageParams(obj);
//        return '{The obj/he} {is} too heavy for {you/him} to pick up. ';
//    }
//    totalTooHeavyForMsg(obj) {
//        gMessageParams(obj);
//        return '{The obj/he} {is} too heavy; {you/he} will have to put
//            something else down first. ';
//    }
//    tooLargeForContainerMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} {is} too large for {the cont/him}. ';
//    }
//    tooLargeForUndersideMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} {is} too large to put under {the cont/him}. ';
//    }
//    tooLargeForRearMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The obj/he} {is} too large to put behind {the cont/him}. ';
//    }
//    containerTooFullMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{The cont/he} {is} already too full to hold {the obj/him}. ';
//    }
//    surfaceTooFullMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return 'There&rsquo;s no room for {the obj/him} on {the cont/him}. ';
//    }
//    undersideTooFullMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return 'There&rsquo;s no room for {the obj/him} under {the cont/him}. ';
//    }
//    rearTooFullMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return 'There&rsquo;s no room for {the obj/him} behind {the cont/him}. ';
//    }
//    becomingTooLargeForContainerMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} cannot do that because it would make
//            {the obj/him} too large for {the cont/him}. ';
//    }
//    containerBecomingTooFullMsg(obj, cont) {
//        gMessageParams(obj, cont);
//        return '{You/he} cannot do that because {the obj/he}
//            would no longer fit in {the cont/him}. ';
//    }
    notAContainerMsg = 
        '<.q>I don<./s>t see how I can put anything into 
        {the iobj/him},<./q> says Sheila. '
    notASurfaceMsg =
        '<.q>I don<./s>t see any good surface on {the iobj/him},<./q>
        says Sheila. '
    cannotPutUnderMsg =
        '<.q>I don<./s>t see how I can put anything under 
        {the iobj/him},<./q> says Sheila. '
    cannotPutBehindMsg =
        '<.q>I don<./s>t see how I can put anything behind 
        {the iobj/him},<./q> says Sheila. '
    cannotPutInSelfMsg =
        'Sheila gives you a funny look, then says, 
        <.q>I don<./s>t see how I can put {that dobj/him} 
        inside of {itself}.<./q> '
    cannotPutOnSelfMsg =
        'Sheila gives you a funny look, then says, 
        <.q>I don<./s>t see how I can put {that dobj/him} 
        on top of {itself}.<./q> '
    cannotPutUnderSelfMsg =
        'Sheila gives you a funny look, then says, 
        <.q>I don<./s>t see how I can put {that dobj/him} 
        underneath {itself}.<./q> '
    cannotPutBehindSelfMsg =
        'Sheila gives you a funny look, then says, 
        <.q>I don<./s>t see how I can put {that dobj/him} 
        behind {itself}.<./q> '
//    cannotPutInRestrictedMsg =
//        '{You/he} can&rsquo;t put {that dobj/him} in {the iobj/him}. '
//    cannotReturnToDispenserMsg =
//        '{You/he} can&rsquo;t put {a dobj/him} back in {the iobj/him}. '
//    cannotPutInDispenserMsg =
//        '{You/he} can&rsquo;t put {a dobj/him} in {the iobj/him}. '
//    objNotForKeyringMsg = '{The dobj/he} do{es}n&rsquo;t fit on {the iobj/him}. '
//    keyNotOnKeyringMsg = '{The dobj/he} {is} not attached to {the iobj/him}. '
//    keyNotDetachableMsg = '{The dobj/he} {is}n&rsquo;t attached to anything. '
//    takenAndMovedToKeyringMsg(keyring) {
//        gMessageParams(keyring);
//        return '{You/he} pick{s} up {the dobj/him} and attach{es actor}
//            {it dobj/him} to {the keyring/him}. ';
//    }
//    movedKeyToKeyringMsg(keyring) {
//        gMessageParams(keyring);
//        return '{You/he} attach{es} {the dobj/him} to {the keyring/him}. ';
//    }
//    movedKeysToKeyringMsg(keyring, keys) {
//        gMessageParams(keyring);
//        return '{You/he} attach{es} {your/his} loose key'
//            + (keys.length() > 1 ? 's' : '')
//            + ' to {the keyring/him}. ';
//    }
//    circularlyInMsg(x, y) {
//        gMessageParams(x, y);
//        return '{You/he} can&rsquo;t do that while {the x/he} {is}
//            in {the y/him}. ';
//    }
//    circularlyOnMsg(x, y) {
//        gMessageParams(x, y);
//        return '{You/he} can&rsquo;t do that while {the x/he} {is}
//            on {the y/him}. ';
//    }
//    circularlyUnderMsg(x, y) {
//        gMessageParams(x, y);
//        return '{You/he} can&rsquo;t do that while {the x/he} {is}
//            under {the y/him}. ';
//    }
//    circularlyBehindMsg(x, y) {
//        gMessageParams(x, y);
//        return '{You/he} can&rsquo;t do that while {the x/he} {is}
//            behind {the y/him}. ';
//    }
    takeFromNotInMsg =
        '<.q>Huh?<./q> says Sheila.
        <.q>In case you hadn<./s>t noticed, 
        {the dobj/he} {is}n&rsquo;t in {the iobj/him}.<./q> '
    takeFromNotOnMsg =
        '<.q>Huh?<./q> says Sheila.
        <.q>In case you hadn<./s>t noticed, 
        {the dobj/he} {is}n&rsquo;t on {the iobj/him}.<./q> '
    takeFromNotUnderMsg =
        '<.q>Huh?<./q> says Sheila.
        <.q>In case you hadn<./s>t noticed, 
        {the dobj/he} {is}n&rsquo;t under {the iobj/him}.<./q> '
    takeFromNotBehindMsg =
        '<.q>Huh?<./q> says Sheila.
        <.q>In case you hadn<./s>t noticed, 
        {the dobj/he} {is}n&rsquo;t behind {the iobj/him}.<./q> '
    takeFromNotInActorMsg = 
        '<.q>Huh?<./q> says Sheila, looking confused.
        <.q>But {the iobj/he} do{es}n&rsquo;t have {the dobj/him}, 
        as far as I can tell.<./q> '
    //willNotLetGoMsg(holder, obj) {
    //    gMessageParams(holder, obj);
    //    return '{The holder/he} won&rsquo;t let {you/him} have {that obj/him}. ';
    //}
    whereToGoMsg =
        '<.q>Sorry, but I don<./s>t understand,<./q> says Sheila.
        <.q>You<./s>re going to have to tell me what direction 
        to go in.<./q> '
    cannotGoThatWayMsg = 
        '<.q>I can<./s>t go that way,<./q> Sheila says. '
        //'Sheila looks in that direction, then shrugs and says, 
        //<.q>Sorry, but I can<./s>t go that way.<./q> '
//    cannotGoThatWayInDarkMsg = 'It&rsquo;s too dark; {you/he} can&rsquo;t see
//                             where {you\'re} going. '
    cannotGoBackMsg = 
        'Sheila shrugs, then says,
        <.q>Sorry, but I don<./s>t know how to go back from here.<.q> '
//    cannotDoFromHereMsg = '{You/he} can&rsquo;t do that from here. '
//    cannotGoThroughClosedDoorMsg(door) {
//        gMessageParams(door);
//        return '{You/he} can&rsquo;t do that, because {the door/he} {is} closed. ';
//    }
//    invalidStagingContainerMsg(cont, dest) {
//        gMessageParams(cont, dest);
//        return '{You/he} can&rsquo;t do that while {the dest/he} {is}
//                {in cont}. ';
//    }
//    invalidStagingLocationMsg(dest) {
//        gMessageParams(dest);
//        return '{You/he} can&rsquo;t get {in dest}. ';
//    }
//    nestedRoomTooHighMsg(obj) {
//        gMessageParams(obj);
//        return '{The obj/he} {is} too high to reach from here. ';
//    }
//    nestedRoomTooHighToExitMsg(obj) {
//        return 'It&rsquo;s too long a drop to do that from here. ';
//    }
//    cannotDoFromMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} can&rsquo;t do that from {the obj/him}. ';
//    }
//    vehicleCannotDoFromMsg(obj) {
//        local loc = obj.location;
//        gMessageParams(obj, loc);
//        return '{You/he} can&rsquo;t do that while {the obj/he} {is} {in loc}. ';
//    }
//    cannotGoThatWayInVehicleMsg(traveler) {
//        gMessageParams(traveler);
//        return '{You/he} can&rsquo;t do that {in traveler}. ';
//    }
//    cannotPushObjectThatWayMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} can&rsquo;t go that way pushing {the obj/him}. ';
//    }
//    cannotEnterExitOnlyMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} can&rsquo;t enter {the obj/him} from here. ';
//    }
//    mustOpenDoorMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must open {the obj/him} first. ';
//    }
//    doorClosesBehindMsg(obj) {
//        gMessageParams(obj);
//        return '<.p>After {you/he} go{es} through {the obj/him}, {it/he}
//                close{s} behind {it actor/him}. ';
//    }
    stairwayNotUpMsg =
        '<.q>{The dobj/he} do{es}n<./s>t go up from here,<./q>
        says Sheila. '
    stairwayNotDownMsg =
        '<.q>{The dobj/he} do{es}n<./s>t go down from here,<./q>
          says Sheila '
//    timePassesMsg = 
//        'Sheila spins one of her wheels impatiently while
//        you decide on your next move. '
//    sayHelloMsg = (addressingNoOneMsg)
//    sayGoodbyeMsg = (addressingNoOneMsg)
//    sayYesMsg = (addressingNoOneMsg)
//    sayNoMsg = (addressingNoOneMsg)
    addressingNoOneMsg {
        return '<.q>If you want me to talk to someone, 
            you<./s>ll have to be a little more specific 
            about who you have in mind,<./q>
            says Sheila. ';
    }
    okayYellMsg = 
        'Sheila turns up the volume on her robotic speakers, 
        echoing a cry into the distance. '
    okayJumpMsg =
        '<.q>Sorry,<./q> says Sheila, <.q>but my legs are not 
        really designed for jumping. Maybe I could try 
        something else instead.<./q> '
    cannotJumpOverMsg =
        '<.q>Sorry,<./q> says Sheila, <.q>but my legs are not 
        really designed for jumping. Maybe I could try 
        something else instead.<./q> '
    cannotJumpOffMsg =
        '<.q>Sorry,<./q> says Sheila, <.q>but my legs are not 
        really designed for jumping. Maybe I could try 
        something else instead.<./q> '
    cannotJumpOffHereMsg =
        '<.q>Sorry,<./q> says Sheila, <.q>but my legs are not 
        really designed for jumping. Maybe I could try 
        something else instead.<./q> '
//    cannotFindTopicMsg = '{You/he} can&rsquo;t seem to find that in {the dobj/him}. '
//    refuseCommand(targetActor, issuingActor) {
//        gMessageParams(targetActor, issuingActor);
//        return '{The targetActor/he} refuse{s} {your/his} request. ';
//    }
    notAddressableMsg(obj) {
        gMessageParams(obj);
        return '<.q>What, talk to {a dobj/him}?<./q> says Sheila.
            <.q>I don<./s>t think that<./s>d do much good.<./q> ';
    }
//    noResponseFromMsg(other) {
//        gMessageParams(other);
//        return '{The other/he} do{es} not respond. ';
//    }
    cannotAskSelfMsg =
        '<.q>I don<./s>t think it<./s>d do much good 
        to talk to myself,<./q> says Sheila. '
    cannotAskSelfForMsg =
        '<.q>I don<./s>t think it<./s>d do much good 
        to talk to myself,<./q> says Sheila. '
    cannotTellSelfMsg =
        '<.q>I don<./s>t think it<./s>d do much good 
        to talk to myself,<./q> says Sheila. '
    cannotGiveToSelfMsg =
        '<.q>It seems a little redundant 
        to give something to myself,<./q> says Sheila. '
    cannotShowToSelfMsg =
        '<.q>It seems a little redundant 
        to show something to myself,<./q> says Sheila. '
    //notInterestedMsg(actor) {
    //    return '\^' + actor.nameVerb('do') + ' not appear interested. ';
    //}
//    objCannotHearActorMsg(obj) {
//        return '\^' + obj.nameVerb('do')
//            + ' not appear to hear {you/him}. ';
//    }
//    actorCannotSeeMsg(actor, obj) {
//        return '\^' + actor.theName + ' does not appear to be able to see '
//            + obj.theNameObj + '. ';
//    }
    notFollowableMsg =
        '<.q>What, follow {a dobj/him}?<./q> says Sheila.
        <.q>I don<./s>t see how that<./s>d do much good.<./q> '
    cannotFollowSelfMsg =
        '<.q>It seems a little redundant 
        to follow myself,<./q> says Sheila. '
    followAlreadyHereMsg =
        '<.q>What, follow {the dobj/him}?<./q> says Sheila.
        <.q>But {it\'s dobj} already here.<./q> '
//    followAlreadyHereInDarkMsg = '{The dobj/he} should be right here,
//        but {you/he} can&rsquo;t see {it dobj/him}. '
//    followUnknownMsg = '{You\'re} not sure where {the dobj/he}
//        went from here. '
//    cannotFollowFromHereMsg(srcLoc) {
//        return 'The last place you saw {the dobj/him} was '
//            + srcLoc.getDestName(gActor, gActor.location) + '. ';
//    }
//    okayFollowInSightMsg(loc) {
//        return '{You/he} follow{s} {the dobj/him} '
//            + loc.actorIntoName + '. ';
//    }
    notAWeaponMsg {
        //local aGreatThing = 'a great thing';
        //if (gIobj && gIobj.isPlural) aGreatThing = 'great things';
        return 'Sheila eyes {the iobj/him} and says,
            <.q>I<./s>m not so sure {that iobj/he} would be very good 
            for hitting things.<./q> ';
    }
// This is taken care of in 1actions.t:
//    uselessToAttackMsg =
//        '<.q>Satisfying as it might be to attack {the dobj/him},
//        I get the feeling it wouldn<./s>t do me much good,<./q>
//        says Sheila. '
    pushNoEffectMsg =
        'Sheila pushes {the dobj/him} as hard as she can, 
        but nothing happens. '
//    okayPushButtonMsg = '<q>Click.</q> '
//    alreadyPushedMsg =
//        '{It\'s dobj} already pushed as far as {it dobj/he} will go. '
//    okayPushLeverMsg = '{You/he} push{es} {the dobj/him} to
//                     {its/her dobj} stop. '
    pullNoEffectMsg =
        'Sheila tries as hard as she can to pull {the dobj/him}, 
        but nothing happens. '
//    alreadyPulledMsg =
//        '{It\'s dobj} already pulled as far as {it dobj/he} will go. '
//    okayPullLeverMsg = '{You/he} pull{s} {the dobj/him} to
//                     {its/her dobj} stop. '
//    okayPullSpringLeverMsg = '{You/he} pull{s} {the dobj/him}, which
//        spring{s} back to {its/her} starting position as soon as
//        {you/he} let{s} go of {it dobj/him}. '
    moveNoEffectMsg =
        'Sheila tries as hard as she can to move {the dobj/him}, 
        but nothing happens. '
    moveToNoEffectMsg =
        'Scratching her head, Sheila says, <.q>You<./s>re going to
        have to explain how you want me to do that.<./q> '
    cannotPushTravelMsg =
        '<.q>I don<./s>t think I can push {the dobj/him} 
        that way,<./q> says Sheila. '
//    okayPushTravelMsg(obj) {
//        return '<.p>{You/he} push{es} ' + obj.theNameObj
//            + ' into the area. ';
//    }
    cannotMoveWithMsg =
        '<.q>Sorry, but I don<./s>t see how I can move anything 
        with {the iobj/him},<./q> says Sheila. '
//    setToInvalidMsg = '{The dobj/he} {has} no such setting. '
//    okaySetToMsg(val)
//        { return 'Okay, {the dobj/he} {is} now set to ' + val + '. '; }
    cannotTurnMsg =
        'Sheila tries as hard as she can to turn {the dobj/him}, 
        but nothing happens. '
//    mustSpecifyTurnToMsg = '{You/he} must specify the setting to
//                         turn {it dobj/him} to. '
    cannotTurnWithMsg =
        '<.q>Sorry, but I don<./s>t see how I can turn anything 
        with {the iobj/him},<./q> says Sheila. '
//    turnToInvalidMsg = '{The dobj/he} {has} no such setting. '
//    okayTurnToMsg(val)
//        { return 'Okay, {the dobj/he} {is} now set to ' + val + '. '; }
//    alreadySwitchedOnMsg = '{The dobj/he} {is} already on. '
//    alreadySwitchedOffMsg = '{The dobj/he} {is} already off. '
//    okayTurnOnMsg = 'Okay, {the dobj/he} {is} now on. '
//    okayTurnOffMsg = 'Okay, {the dobj/he} {is} now off. '
//    flashlightOnButDark = '{You/he} turn{s} on {the dobj/him}, but
//        nothing seems to happen. '
//    okayEatMsg = '{You/he} eat{s} {the dobj/him}. '
//    mustBeBurningMsg(obj) {
//        return '{You/he} must light ' + obj.theNameObj
//            + ' before {it actor/he} can do that. ';
//    }
//    matchNotLitMsg = '{The dobj/he} {is}n&rsquo;t lit. '
//    okayBurnMatchMsg =
//        '{You/he} strike{s} {the dobj/him}, igniting a small flame. '
//    okayExtinguishMatchMsg = '{You/he} put{s} out {the dobj/him}, which
//        disappear{s} into a cloud of ash. '
//    candleOutOfFuelMsg =
//        '{The dobj/he} {is} too burned down; {it/he} cannot be lit. '
//    okayBurnCandleMsg = '{You/he} light{s} {the dobj/him}. '
//    candleNotLitMsg = '{The dobj/he} {is} not lit. '
//    okayExtinguishCandleMsg = 'Done. '
    cannotConsultMsg =
        '<.q>I don<./s>t see any way to consult {that dobj/him},<./q> 
        says Sheila. '
    cannotTypeOnMsg =
        '<.q>I don<./s>t see any way to type anything on {that dobj/him},<./q> 
        says Sheila. '
    cannotEnterOnMsg =
        '<.q>I don<./s>t see any way to enter anything on {that dobj/him},<./q> 
        says Sheila. '
    cannotSwitchMsg =
        '<.q>I don<./s>t see any way to switch {that dobj/him},<./q> 
        says Sheila. '
    cannotFlipMsg =
        '<.q>I don<./s>t see any way to flip {that dobj/him},<./q> 
        says Sheila. '
    cannotTurnOnMsg =
        '<.q>I don<./s>t see any way to turn {that dobj/him} on,<./q> 
        says Sheila. '
    cannotTurnOffMsg =
        '<.q>I don<./s>t see any way to turn {that dobj/him} off,<./q> 
        says Sheila. '
    cannotLightMsg =
        '<.q>I don<./s>t see any way to light {that dobj/him},<./q> 
        says Sheila. '
    cannotBurnMsg =
        '<.q>I really don<./s>t like fire,<./q> says Sheila,
        <.q>I<./s>m not sure I<./s>d want to burn {the dobj/him} 
        even if I could.<./q> '
    cannotBurnWithMsg =
        '<.q>I don<./s>t see any way to burn anything 
        with {that dobj/him},<./q> says Sheila. <.q>Besides, 
        I don<./s>t like burning things anyway.<./q> '
//    cannotBurnDobjWithMsg = '{You/he} cannot light {the dobj/him}
//                          with {the iobj/him}. '
//    alreadyBurningMsg = '{The dobj/he} {is} already burning. '
    cannotExtinguishMsg =
        '<.q>I don<./s>t see any way to put {that dobj/him} out,<./q> 
        says Sheila. '
    cannotPourMsg =
        '<.q>I don<./s>t see any point in trying to pour 
        {the dobj/him},<./q> says Sheila. '
    cannotPourIntoMsg =
        '<.q>I don<./s>t see any point in trying to pour 
        {the dobj/him} anywhere,<./q> says Sheila. '
    cannotPourOntoMsg =
        '<.q>I don<./s>t see any point in trying to pour 
        {the dobj/him} anywhere,<./q> says Sheila. '
    cannotAttachMsg =
        '<.q>I don<./s>t see how I can attach {that dobj/him} to anything,<./q> 
        says Sheila. '
    cannotAttachToMsg =
        '<.q>I don<./s>t see how I can attach anything to {that iobj/him},<./q> 
        says Sheila. '
    cannotAttachToSelfMsg =
        '<.q>I don<./s>t see how I can attach {that dobj/him} to itself,<./q> 
        says Sheila. '
//    alreadyAttachedMsg =
//        '{The dobj/he} {is} already attached to {the iobj/him}. '
//    wrongAttachmentMsg =
//        '{You/he} can&rsquo;t attach {that dobj/him} to {the iobj/him}. '
//    wrongDetachmentMsg =
//        '{You/he} can&rsquo;t detach {that dobj/him} from {the iobj/him}. '
//    mustDetachMsg(obj) {
//        gMessageParams(obj);
//        return '{You/he} must detach {the obj/him} before {you/he}
//            can do that. ';
//    }
//    okayAttachToMsg = 'Done. '
//    okayDetachFromMsg = 'Done. '
    cannotDetachMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see how I can detach {that dobj/him} from anything.<./q> '
    cannotDetachFromMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see how I can detach anything from {that dobj/him}.<./q> '
//    cannotDetachPermanentMsg =
//        'There&rsquo;s no obvious way to detach {that dobj/him}. '
//    notAttachedToMsg = '{The dobj/he} {is}n&rsquo;t attached to {that iobj/him}. '
    shouldNotBreakMsg =
        'Sheila frowns, then says, 
        <.q>Satisfying as it might be to break {the dobj/him},
        I get the feeling it wouldn<./s>t do me much good.<./q> '
    cutNoEffectMsg =
        'Using {the iobj/him}, Sheila tries as hard as she can to cut
        {the dobj/him}. {The dobj/he} remains unaffected. '
    cannotCutWithMsg =
        'Sheila eyes {the iobj/him} skeptically, then says,
        <.q>I don<./s>t see how I can cut anything with {that iobj/him}.<./q> '
    cannotClimbMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to climb {that dobj/him}.<./q> '
    cannotOpenMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to open {that dobj/him}.<./q> '
    cannotCloseMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to close {that dobj/him}.<./q> '
    alreadyOpenMsg =
        '<.q>Looks to me like {that\'s dobj} already open,<./q>
          says Sheila. '
    alreadyClosedMsg =
        '<.q>Looks to me like {that\'s dobj} already closed,<./q>
          says Sheila. '
    alreadyLockedMsg =
        '<.q>Looks to me like {that\'s dobj} already locked,<./q>
          says Sheila. '
    alreadyUnlockedMsg =
        '<.q>Looks to me like {that\'s dobj} already unlocked,<./q>
          says Sheila. '
//    cannotLookInClosedMsg = '{The dobj/he} {is} closed. '
    cannotLockMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to lock {that dobj/him}.<./q> '
    cannotUnlockMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to unlock {that dobj/him}.<./q> '
    cannotOpenLockedMsg =
        'Sheila tries open {the dobj/him}, but finds that 
        {it\'s dobj} locked. '
//    unlockRequiresKeyMsg =
//        '{You/he} seem{s} to need a key to unlock {the dobj/him}. '
    cannotLockWithMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see how I can use {the dobj/him} to lock anything.<./q> '
    cannotUnlockWithMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see how I can use {the dobj/him} to unlock anything.<./q> '
    unknownHowToLockMsg =
        'Sheila puzzles over {the dobj/him} for a moment, then says,
        <.q>{The dobj/he} do{es}n<./s>t have a keyhole.
        If you want me to lock it, you<./s>ll have to be more specific
        on how to do that.<./q> '
    unknownHowToUnlockMsg =
        'Sheila puzzles over {the dobj/him} for a moment, then says,
        <.q>{The dobj/he} do{es}n<./s>t have a keyhole.
        If you want me to unlock {it dobj/him}, you<./s>ll have to 
        give me some idea how to do that.<./q> '
//    keyDoesNotFitLockMsg = '{The iobj/he} do{es}n&rsquo;t fit the lock. '
//    foundKeyOnKeyringMsg(ring, key) {
//        gMessageParams(ring, key);
//        return '{You/he} tr{ies} each key on {the ring/him}, and
//            find{s actor} that {the key/he} fit{s} the lock. ';
//    }
//    foundNoKeyOnKeyringMsg(ring) {
//        gMessageParams(ring);
//        return '{You/he} tr{ies} each key on {the ring/him},
//            but {you/he} can&rsquo;t find anything that fits the lock. ';
//    }
    cannotEatMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>{That dobj/him} do{es}n<./s>t look like something
        I<./s>d want to eat.<./q> '
    cannotDrinkMsg =
        'Eyeing {the dobj/him} skeptically, Sheila says, 
        <.q>You want me to drink {that dobj/him}, huh? No thanks, 
        I think I<./s>ll pass.<./q> '
    cannotCleanMsg =
        'Sheila emits a low growl, then says,
        <.q>Do I really look like one of those voice-activated
        vacuum cleaners? Well, I<./s>m not! If you really want
        something clean, you can do it yourself.<./q> '
    cannotCleanWithMsg =
        'Sheila emits a low growl, then says,
        <.q>Do I really look like one of those voice-activated
        vacuum cleaners? Well, I<./s>m not! If you really want
        something clean, you can do it yourself.<./q> '
//    cannotAttachKeyToMsg =
//        '{You/he} cannot attach {the dobj/him} to {that iobj/him}. '
    cannotSleepMsg =
        'Sheila chuckles a bit.
        <.q>No, no,<./q> she says. <.q>I don<./s>t need to sleep. 
        I<./s>m a robot!<./q> '
    cannotSitOnMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to sit on {that dobj/him}.<./q> '
    cannotLieOnMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to lie on {that dobj/him}.<./q> '
    cannotStandOnMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to stand on {that dobj/him}.<./q> '
    cannotBoardMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to get onto {that dobj/him}.<./q> '
    cannotUnboardMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to get out of {that dobj/him}.<./q> '
    cannotGetOffOfMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to get off of {that dobj/him}.<./q> '
//    cannotStandOnPathMsg = 'If {you/he} want{s} to follow {the dobj/him},
//        just say so. '
//    cannotEnterHeldMsg =
//        '{You/he} can&rsquo;t do that while {you\'re} holding {the dobj/him}. '
//    cannotGetOutMsg = '{You\'re} not in anything {you/he} can disembark. '
    alreadyStandingMsg =
        'Sheila says, <.q>But I<./s>m already standing.<./q> '
    alreadyStandingOnMsg =
        'Sheila gives you a funny look, then says, 
        <.q>But I<./s>m already standing {on dobj}.<./q> '
    alreadySittingOnMsg =
        'Sheila gives you a funny look, then says, 
        <.q>But I<./s>m already sitting {on dobj}.<./q> '
    alreadyLyingOnMsg =
        'Sheila gives you a funny look, then says, 
        <.q>But I<./s>m already lying {on dobj}.<./q> '
//    notOnPlatformMsg = '{You\'re} not {on dobj}. '
    noRoomToStandMsg =
        'Sheila looks over {the dobj}, frowns, then says,
        <.q>I don<./s>t think there<./s>s any room for me to
        stand {on dobj}.<./q> '
    noRoomToSitMsg =
        'Sheila looks over {the dobj}, frowns, then says,
        <.q>I don<./s>t think there<./s>s any room for me to
        sit {on dobj}.<./q> '
    noRoomToLieMsg =
        'Sheila looks over {the dobj}, frowns, then says,
        <.q>I don<./s>t think there<./s>s any room for me to
        lie {on dobj}.<./q> '
    okayPostureChangeMsg(posture) {
        local postureChangeStr;
        if (!posture.msgVerbI.find('{s}'))
          postureChangeStr = posture.msgVerbI;
        else
          postureChangeStr = 
            standing.msgVerbI.substr(1,standing.msgVerbI.find('{s}')-1) 
            + 's'
            + standing.msgVerbI.substr(standing.msgVerbI.find('{s}')+3);
        return okayStr() + ' says Sheila, 
            and she ' + postureChangeStr + '. ';
    }
    roomOkayPostureChangeMsg(posture, obj) {
        local postureChangeStr;
        gMessageParams(obj);
        
        if (!posture.msgVerbI.find('{s}'))
          postureChangeStr = posture.msgVerbI;
        else
          postureChangeStr = 
            standing.msgVerbI.substr(1,standing.msgVerbI.find('{s}')-1) 
            + 's';
        
        return okayStr() + ' says Sheila,
            and she ' + postureChangeStr + ' {on obj}. ';
    }
    okayNotStandingOnMsg {
        local outOfStr = 'out of';
        if (gDobj && gDobj.ofKind(Surface))
            outOfStr = 'off of';
        return okayStr() + ' says Sheila,
            and she gets ' + outOfStr + ' {the dobj/him}. ';
    }
    cannotFastenMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see how I can fasten {that dobj/him} to anything.<./q> '
    cannotFastenToMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see how I can fasten anything to {that dobj/him}.<./q> '
    cannotUnfastenMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see how I can unfasten {that dobj/him} from anything.<./q> '
    cannotUnfastenFromMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see how I can unfasten anything from {that dobj/him}.<./q> '
    cannotPlugInMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to plug in {that dobj/him}.<./q> '
    cannotPlugInToMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see how I can unfasten anything into {that dobj/him}.<./q> '
    cannotUnplugMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see how I can unplug {that dobj/him} from anything.<./q> '
    cannotUnplugFromMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see how I can unplug anything from {that dobj/him}.<./q> '
    cannotScrewMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to screw {that dobj/him}.<./q> '
    cannotScrewWithMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see how I can screw anything with {that dobj/him}.<./q> '
    cannotUnscrewMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to unscrew {that dobj/him}.<./q> '
    cannotUnscrewWithMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see how I can unscrew anything with {that dobj/him}.<./q> '
    cannotEnterMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to enter {that dobj/him}.<./q> '
    cannotGoThroughMsg =
        'Sheila eyes {the dobj/him} skeptically, then says,
        <.q>I don<./s>t see any way to go through {that dobj/him}.<./q> '
    cannotThrowAtSelfMsg =
        'Sheila says,
        <.q>You want me to throw {that dobj/him} at {itself}, huh? 
        No thanks, I think I<./s>ll pass.<./q> '
    cannotThrowAtContentsMsg =
        'Spinning one of her wheels impatiently, Sheila says, 
        <.q>Next time you want me to throw {the dobj/him} at {the iobj/him},
        try to make sure {the iobj/he} {is}n<./q>t among the contents
        of {the dobj/him}.<./q> '
//    shouldNotThrowAtFloorMsg =
//        '{You/he} should just put {it dobj/him} down instead. '
//    throwHitMsg(projectile, target) {
//        gMessageParams(projectile, target);
//        return '{The projectile/he} hit{s} {the target/him} without any
//            obvious effect. ';
//    }
//    throwHitFallMsg(projectile, target, dest) {
//        gMessageParams(projectile, target);
//        return '{The projectile/he} hit{s} {the target/him}
//            without any obvious effect, and fall{s projectile} '
//            + dest.putInName + '. ';
//    }
//    throwShortMsg(projectile, target) {
//        gMessageParams(projectile, target);
//        return '{The projectile/he} fall{s} well short of {the target/him}. ';
//    }
//    throwFallShortMsg(projectile, target, dest) {
//        gMessageParams(projectile, target);
//        return '{The projectile/he} fall{s} ' + dest.putInName
//            + ' well short of {the target/him}. ';
//    }
//    throwCatchMsg(obj, target) {
//        return '\^' + target.nameVerb('catch')
//            + ' ' + obj.theNameObj + '. ';
//    }
    //willNotCatchMsg(catcher) {
    //    return '\^' + catcher.nameVerb('do')
    //        + 'n&rsquo;t look like ' + catcher.itNom + ' want'
    //        + catcher.verbEndingS + ' to catch anything. ';
    //}
    cannotKissMsg =
        'Sheila looks around sheepishly, then puts her mouth to 
        {the dobj/him}. <.q>There. Happy now?<./q> she remarks. '
    cannotKissActorMsg =
        'Sheila pauses for a long second, then says,
        <.q>Uh, no thanks. Something tells me {the dobj/him}
        wouldn<./s>t welcome such an advance.<./q> '
        //'Sheila emits a low growl, then says,
        //<.q>What do you take me for, the Seductotron 3000?
        //Here, tell you what. After <i>you</i> kiss {the dobj/him},
        //maybe I<./s>ll think about doing that.<./q> '
    cannotKissSelfMsg =
        'Sheila says,
        <.q>You want me to kiss myself, huh? No thanks, I think I<./s>ll pass.<./q> '
//    newlyDarkMsg = 'It is now pitch black. '
;

okayStr() {
  return '<.q>' + rand('Okay,'
                      ,'You bet,'
                      ,'Certainly,'
                      ,'All right,'
                      ,'No problem,') + '<./q>';
}

