#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// ENDGAME MAP: Templates Relating to Map State, etc.
// ENDGAME MAP: Glimpseability
// ENDGAME MAP: giveFileForH9 method
// ENDGAME MAP: giveFilename/giveHtml methods: museum
// ENDGAME MAP: giveFilename/giveHtml methods: second row (north of office, etc.)
// ENDGAME MAP: giveFilename/giveHtml methods: third row (office)
// ENDGAME MAP: giveFilename/giveHtml methods: fourth row (dream room, etc.)
// ENDGAME MAP: giveFilename/giveHtml methods: fifth row (hallways 3 to 6)
// ENDGAME MAP: giveFilename/giveHtml methods: sixth row (cell to conference room)
// ENDGAME MAP: giveFilename/giveHtml methods: seventh row (south of cell, etc.)
// ENDGAME MAP: endgameMapPrint

// -------------------------------------------------------------------
// ENDGAME MAP: Templates Relating to Map State, etc.
// -------------------------------------------------------------------

#define officeDoorIsOpen  (officeDoor.isOpen)
#define hallDoorsAreOpen  (hallDoors.isOpen)
#define cellDoorIsOpen    (cellDoor.isOpen)
#define breakDoorIsOpen   (breakDoor.isOpen)
#define bathDoorIsOpen    (bathDoor.isOpen)
#define confDoorIsOpen    (confDoor.isOpen)
#define dreamDoorIsOpen   (dreamDoor.isOpen)
#define frontDoorsAreOpen (frontDoors.isOpen)
#define slowingFieldIsOn  (slowingField.isOn)
#define netonLocation     (neton.realLocation)
#define netonXValue       (neton.xValue)
#define netonYValue       (neton.yValue)
#define netonXOffset      (neton.xOffset)
#define netonYOffset      (neton.yOffset)
#define ovanLocation      (ovan.realLocation)
#define ovanXValue        (ovan.xValue)
#define ovanYValue        (ovan.yValue)
#define ovanXOffset       (ovan.xOffset)
#define ovanYOffset       (ovan.yOffset)
#define youngGuardLocation    (youngGuard.realLocation)
#define youngGuardXValue      (youngGuard.xValue)
#define youngGuardYValue      (youngGuard.yValue)
#define youngGuardXOffset     (youngGuard.xOffset)
#define youngGuardYOffset     (youngGuard.yOffset)
#define oldGuardLocation    (oldGuard.realLocation)
#define oldGuardXValue      (oldGuard.xValue)
#define oldGuardYValue      (oldGuard.yValue)
#define oldGuardXOffset     (oldGuard.xOffset)
#define oldGuardYOffset     (oldGuard.yOffset)
#define assistantLocation (assistant.realLocation)
#define assistantXValue   (assistant.xValue)
#define assistantYValue   (assistant.yValue)
#define assistantXOffset  (assistant.xOffset)
#define assistantYOffset  (assistant.yOffset)
#define vickiLocation (vicki.realLocation)
#define vickiXValue   (vicki.xValue)
#define vickiYValue   (vicki.yValue)
#define vickiXOffset  (vicki.xOffset)
#define vickiYOffset  (vicki.yOffset)
#define dianeLocation (diane.realLocation)
#define dianeXValue   (diane.xValue)
#define dianeYValue   (diane.yValue)
#define dianeXOffset  (diane.xOffset)
#define dianeYOffset  (diane.yOffset)
/*
#define officeDoorIsOpen  (officeDoor.lks)
#define hallDoorsAreOpen  (hallDoors.lks)
#define cellDoorIsOpen    (cellDoor.lks)
#define breakDoorIsOpen   (breakDoor.lks)
#define bathDoorIsOpen    (bathDoor.lks)
#define confDoorIsOpen    (confDoor.lks)
#define dreamDoorIsOpen   (dreamDoor.lks)
#define frontDoorsAreOpen (frontDoors.isOpen)
#define slowingFieldIsOn  (nil)               // change later
#define netonLocation     (neton.lkl)
#define netonXValue       (neton.lkx)
#define netonYValue       (neton.lky)
#define netonXOffset      (neton.lkx2)
#define netonYOffset      (neton.lky2)
#define ovanLocation  (ovan.lkl)
#define ovanXValue    (ovan.lkx)
#define ovanYValue    (ovan.lky)
#define ovanXOffset   (ovan.lkx2)
#define ovanYOffset   (ovan.lky2)
#define youngGuardLocation    (youngGuard.lkl)
#define youngGuardXValue      (youngGuard.lkx)
#define youngGuardYValue      (youngGuard.lky)
#define youngGuardXOffset     (youngGuard.lkx2)
#define youngGuardYOffset     (youngGuard.lky2)
#define oldGuardLocation    (oldGuard.lkl)
#define oldGuardXValue      (oldGuard.lkx)
#define oldGuardYValue      (oldGuard.lky)
#define oldGuardXOffset     (oldGuard.lkx2)
#define oldGuardYOffset     (oldGuard.lky2)
#define assistantLocation (assistant.lkl)
#define assistantXValue   (assistant.lkx)
#define assistantYValue   (assistant.lky)
#define assistantXOffset  (assistant.lkx2)
#define assistantYOffset  (assistant.lky2)
#define vickiLocation (vicki.lkl)
#define vickiXValue   (vicki.lkx)
#define vickiYValue   (vicki.lky)
#define vickiXOffset  (vicki.lkx2)
#define vickiYOffset  (vicki.lky2)
#define dianeLocation (diane.lkl)
#define dianeXValue   (diane.lkx)
#define dianeYValue   (diane.lky)
#define dianeXOffset  (diane.lkx2)
#define dianeYOffset  (diane.lky2)
*/

// -------------------------------------------------------------------
// ENDGAME MAP: Glimpseability
// -------------------------------------------------------------------

modify Actor
  saw(obj) {
    return obj.glimpsed;
    //return hasSeen(obj);
    ////if (hasSeen(obj) || canSee(obj)) return true;
    ////return nil;
  }
;

/*
                   museum
                     |
                   skyway
  D                  |
 hw1   hw8--office  hw9
  |     |            |
 hw2   hw7  dream  stairs
  D     |     |      |
 hw3---hw4---hw5----hw6
  |     |     |      |
cell  break  bath   conf
*/

/*
Are you suggesting "It's okay that 
*/

modify me
  isInForMap(obj) {
    if (glob.pcIsDead)
      return nil;
    return isIn(obj);
  }
;
modify Thing
  isInForMap(obj) {
    return isIn(obj);
  }
;

modify Thing
  glimpsed = nil
;

modify AlienRoom
  glimpsed = nil
  doGlimpseFromHereNoMore = nil
  // internal use only
  tryGlimpsingParticularRoomFromHere(arg) {
    // If no doors need be open for glimpsing, just glimpse.
    if (glimpseableRooms[arg][2].length == 0) {
      glimpseableRooms[arg][1].glimpsed = true;
      return;
    }
    // If one ore more doors must be open for glimpsing,
    // then glimpse if and only if all of those doors are open.
    else {
      // If any of the doors in the list are closed, then stop!
      for (local b = 1; b <= glimpseableRooms[arg][2].length; b++) {
        if (!glimpseableRooms[arg][2][b].isOpen) {
          return;
        }
      }
      // If we haven't stopped yet, then now's the time to glimpse.
      glimpseableRooms[arg][1].glimpsed = true;
      return;
    }
  }
  doGlimpseFromHere {
    local allGlimpsed = true;
    if (doGlimpseFromHereNoMore)
      return;
    self.glimpsed = true;
    for (local a = 1; a <= glimpseableRooms.length; a++) {
      // Look at each of the rooms in the glimpseableRooms list.
      // If any of them hasn't already been glimpsed, then try 
      // to glimpse them.
      if (!glimpseableRooms[a][1].glimpsed) {
        tryGlimpsingParticularRoomFromHere(a);
      }
      // If after trying to glimpse the room, it still isn't 
      // glimpsed, then by the time we get to the end, 
      // all the rooms won't be glimpsed.
      if (!glimpseableRooms[a][1].glimpsed) {
        allGlimpsed = nil;
      }
    }
    if (allGlimpsed)
      doGlimpseFromHereNoMore = true;
  }
  canGlimpse(rm) {
    local elmt;
    elmt = glimpseableRooms.indexWhich({x:x[1]==rm});
    // If "rm" == self, it can be glimpsed. We can always see things 
    // in the room we ourselves are in.
    if (rm == self)
      return true;
    // If "rm" isn't in the glimpseableRooms list, it can't ever be 
    // seen from here.
    if (!elmt)
      return nil;
    // If "rm" is in glimpseableRooms and is not associated with
    // any doors, it's always visible from here.
    if (glimpseableRooms[elmt][2].length == 0)
      return true;
    // If any of the doors in the list are closed, "rm" isn't visible.
    for (local a = 1; a <= glimpseableRooms[elmt][2].length; a++) {
      if (!glimpseableRooms[elmt][2][a].isOpen)
        return nil;
    }
    // "Rm" is in glimpseableRooms, and all of the doors associated
    // with it are open, so it's visible.
    return true;
  }
  glimpseableRooms = []
;

modify hallway1
  glimpseableRooms = [
     [hallway2 ,[                   ] ]
    ,[hallway3 ,[hallDoors          ] ]
    ,[cell     ,[hallDoors, cellDoor] ]
  ]
;
modify hallway2
  glimpseableRooms = [
     [hallway1 ,[                   ] ]
    ,[hallway3 ,[hallDoors          ] ]
    ,[cell     ,[hallDoors, cellDoor] ]
  ]
;
modify hallway3
  glimpseableRooms = [
     [hallway4 ,[         ] ]
    ,[hallway5 ,[         ] ]
    ,[hallway6 ,[         ] ]
    ,[hallway1 ,[hallDoors] ]
    ,[hallway2 ,[hallDoors] ]
    ,[cell     ,[cellDoor ] ]
  ]
;
modify cell
  glimpseableRooms = [
     [hallway3 ,[cellDoor           ] ]
    ,[hallway1 ,[cellDoor, hallDoors] ]
    ,[hallway2 ,[cellDoor, hallDoors] ]
  ]
;
modify hallway8
  glimpseableRooms = [
     [hallway7 ,[          ] ]
    ,[hallway4 ,[          ] ]
    ,[office   ,[officeDoor] ]
    ,[breakRoom,[breakDoor ] ]
  ]
;
modify hallway7
  glimpseableRooms = [
     [hallway8 ,[         ] ]
    ,[hallway4 ,[         ] ]
    ,[breakRoom,[breakDoor] ]
  ]
;
modify hallway4
  glimpseableRooms = [
     [hallway3 ,[         ] ]
    ,[hallway5 ,[         ] ]
    ,[hallway6 ,[         ] ]
    ,[hallway7 ,[         ] ]
    ,[hallway8 ,[         ] ]
    ,[breakRoom,[breakDoor] ]
  ]
;
modify breakRoom
  glimpseableRooms = [
     [hallway8 ,[breakDoor] ]
    ,[hallway7 ,[breakDoor] ]
    ,[hallway4 ,[breakDoor] ]
  ]
;
modify office
  glimpseableRooms = [
     [dreamRoom,[          ] ]
    ,[hallway8 ,[officeDoor] ]
    //,[hallway5 ,[dreamDoor [ ]
  ]
;
modify dreamRoom
  glimpseableRooms = [
     [office   ,[                   ] ]
    ,[hallway5 ,[dreamDoor          ] ]
    ,[bathroom ,[dreamDoor, bathDoor] ]
  ]
;
modify hallway5
  glimpseableRooms = [
     [hallway3 ,[         ] ]
    ,[hallway4 ,[         ] ]
    ,[hallway6 ,[         ] ]
    //,[office   ,[dreamDoor] ]
    ,[dreamRoom,[dreamDoor] ]
    ,[bathroom ,[bathDoor ] ]
  ]
;
modify bathroom
  glimpseableRooms = [
     [hallway5 ,[bathDoor           ] ]
    ,[dreamRoom,[bathDoor, dreamDoor] ]
  ]
;
modify museum
  glimpseableRooms = [
     [skyway   ,[        ] ]
    ,[hallway9 ,[        ] ]
    ,[stairs   ,[        ] ]
    ,[hallway6 ,[        ] ]
    ,[confRoom ,[confDoor] ]
  ]
;
modify skyway
  glimpseableRooms = [
     [museum   ,[        ] ]
    ,[hallway9 ,[        ] ]
    ,[stairs   ,[        ] ]
    ,[hallway6 ,[        ] ]
    ,[confRoom ,[confDoor] ]
  ]
;
modify hallway9
  glimpseableRooms = [
     [museum   ,[        ] ]
    ,[skyway   ,[        ] ]
    ,[stairs   ,[        ] ]
    ,[hallway6 ,[        ] ]
    ,[confRoom ,[confDoor] ]
  ]
;
modify stairs
  glimpseableRooms = [
     [museum   ,[        ] ]
    ,[skyway   ,[        ] ]
    ,[hallway9 ,[        ] ]
    ,[hallway6 ,[        ] ]
    ,[confRoom ,[confDoor] ]
  ]
;
modify hallway6
  glimpseableRooms = [
     [museum   ,[        ] ]
    ,[skyway   ,[        ] ]
    ,[hallway9 ,[        ] ]
    ,[stairs   ,[        ] ]
    ,[confRoom ,[confDoor] ]
    ,[hallway3 ,[        ] ]
    ,[hallway4 ,[        ] ]
    ,[hallway5 ,[        ] ]
  ]
;
modify confRoom
  glimpseableRooms = [
     [museum   ,[confDoor] ]
    ,[skyway   ,[confDoor] ]
    ,[hallway9 ,[confDoor] ]
    ,[stairs   ,[confDoor] ]
    ,[hallway6 ,[confDoor] ]
  ]
;

// The following visibleRooms lists are not needed because
// 3endmap.t now has a better list, glimpseableRooms, 
// for each room.

/*
modify hallway1
  visibleRooms = [
     [hallway2 ,nil                   ]
    ,[hallway3 ,[hallDoors]           ]
    ,[cell     ,[hallDoors, cellDoor] ]
  ]
;
modify hallway2
  visibleRooms = [
     [hallway1 ,nil                   ]
    ,[hallway3 ,[hallDoors]           ]
    ,[cell     ,[hallDoors, cellDoor] ]
  ]
;
modify hallway3
  visibleRooms = [
     [hallway1 ,[hallDoors]           ]
    ,[hallway2 ,[hallDoors]           ]
    ,[cell     ,[cellDoor]            ]
    ,[hallway4 ,nil                   ]
    ,[hallway5 ,nil                   ]
    ,[hallway6 ,nil                   ]
  ]
;
modify cell
  visibleRooms = [
     [hallway1 ,[hallDoors, cellDoor] ]
    ,[hallway2 ,[hallDoors, cellDoor] ]
    ,[hallway3 ,[cellDoor]            ]
  ]
;
modify hallway8
  visibleRooms = [
     [hallway7 ,nil                   ]
    ,[hallway4 ,nil                   ]
    ,[breakRoom,[breakDoor]           ]
    ,[office   ,[officeDoor]          ]
  ]
;
modify hallway7
  visibleRooms = [
     [hallway8 ,nil                   ]
    ,[hallway4 ,nil                   ]
    ,[breakRoom,[breakDoor]           ]
  ]
;
modify hallway4
  visibleRooms = [
     [hallway3 ,nil                   ]
    ,[hallway8 ,nil                   ]
    ,[hallway7 ,nil                   ]
    ,[breakRoom,[breakDoor]           ]
    ,[hallway5 ,nil                   ]
    ,[hallway6 ,nil                   ]
  ]
;
modify breakRoom
  visibleRooms = [
     [hallway8 ,[breakDoor]           ]
    ,[hallway7 ,[breakDoor]           ]
    ,[hallway4 ,[breakDoor]           ]
  ]
;
modify office
  visibleRooms = [
     [hallway8 ,[officeDoor]          ]
  ]
;
modify dreamRoom
  visibleRooms = [
     [hallway5 ,[dreamDoor]           ]
    ,[bathroom ,[dreamDoor, bathDoor] ]
  ]
;
modify hallway5
  visibleRooms = [
     [hallway3 ,nil                   ]
    ,[hallway4 ,nil                   ]
    ,[dreamRoom,[dreamDoor]           ]
    ,[bathroom ,[bathDoor]            ]
    ,[hallway6 ,nil                   ]
  ]
;
modify bathroom
  visibleRooms = [
     [dreamRoom,[dreamDoor, bathDoor] ]
    ,[hallway5 ,[bathDoor]            ]
  ]
;
modify museum
  visibleRooms = [
     [skyway   ,nil                   ]
    ,[hallway9 ,nil                   ]
    ,[stairs   ,nil                   ]
    ,[hallway6 ,nil                   ]
    ,[confRoom ,[confDoor]            ]
  ]
;
modify skyway
  visibleRooms = [
     [museum   ,nil                   ]
    ,[hallway9 ,nil                   ]
    ,[stairs   ,nil                   ]
    ,[hallway6 ,nil                   ]
    ,[confRoom ,[confDoor]            ]
  ]
;
modify hallway9
  visibleRooms = [
     [museum   ,nil                   ]
    ,[skyway   ,nil                   ]
    ,[stairs   ,nil                   ]
    ,[hallway6 ,nil                   ]
    ,[confRoom ,[confDoor]            ]
  ]
;
modify stairs
  visibleRooms = [
     [museum   ,nil                   ]
    ,[skyway   ,nil                   ]
    ,[hallway9 ,nil                   ]
    ,[hallway6 ,nil                   ]
    ,[confRoom ,[confDoor]            ]
  ]
;
modify hallway6
  visibleRooms = [
     [hallway3 ,nil                   ]
    ,[hallway4 ,nil                   ]
    ,[hallway5 ,nil                   ]
    ,[museum   ,nil                   ]
    ,[skyway   ,nil                   ]
    ,[hallway9 ,nil                   ]
    ,[stairs   ,nil                   ]
    ,[confRoom ,[confDoor]            ]
  ]
;
modify confRoom
  visibleRooms = [
     [museum   ,[confDoor]            ]
    ,[skyway   ,[confDoor]            ]
    ,[hallway9 ,[confDoor]            ]
    ,[stairs   ,[confDoor]            ]
    ,[hallway6 ,[confDoor]            ]
  ]
;
*/

// -------------------------------------------------------------------
// ENDGAME MAP: giveFileForH9 method
// -------------------------------------------------------------------

modify AlienRoom
  giveFileForH9(xstr, stairstr, val1, room1, val2, thisrm, meadd) {
    local dude1loc, dude1yval, dude1str, considerdude1,
          dude2loc, dude2yval, dude2str, considerdude2,
          dude3loc, dude3yval, dude3str, considerdude3;
    local str;
    str = 'h9' + xstr + '-' + stairstr;
    //if (!me.isIn(thisrm) || (me.xValue!=val1 && me.xValue!=val2)) { }
    if (xstr == 'a') {
      dude1str = 'p';
      dude2str = 'g';
      dude3str = 'a';
      dude1loc = netonLocation;     dude1yval = netonYValue;
      dude2loc = youngGuardLocation;    dude2yval = youngGuardYValue;
      dude3loc = assistantLocation; dude3yval = assistantYValue;
    }
    else {
      dude1str = 'a';
      dude2str = 'h';
      dude3str = 'q';
      dude1loc = assistantLocation; dude1yval = assistantYValue;
      dude2loc = oldGuardLocation;    dude2yval = oldGuardYValue;
      dude3loc = ovanLocation;  dude3yval = ovanYValue;
    }
    considerdude1 = ( (dude1loc==room1  && dude1yval==val1)
                   || (dude1loc==thisrm && dude1yval==val2) );
    considerdude2 = ( (dude2loc==room1  && dude2yval==val1)
                   || (dude2loc==thisrm && dude2yval==val2) );
    considerdude3 = ( (dude3loc==room1  && dude3yval==val1)
                   || (dude3loc==thisrm && dude3yval==val2) );
    
    if (considerdude1 || considerdude2 || considerdude3) {
      str = str + dude1str;
      if (!considerdude1)
        str = str + '0';
      else if (dude1loc==room1  && dude1yval==val1)
        str = str + '1';
      else if (dude1loc==thisrm && dude1yval==val2)
        str = str + '2';
      else
        str = str + '0';
      
      str = str + dude2str;
      if (!considerdude2)
        str = str + '0';
      else if (dude2loc==room1  && dude2yval==val1)
        str = str + '1';
      else if (dude2loc==thisrm && dude2yval==val2)
        str = str + '2';
      else
        str = str + '0';
      
      str = str + dude3str;
      if (!considerdude3)
        str = str + '0';
      else if (dude3loc==room1  && dude3yval==val1)
        str = str + '1';
      else if (dude3loc==thisrm && dude3yval==val2)
        str = str + '2';
      else
        str = str + '0';
    }
    //else if ( (me.isIn(room1)  && me.yValue==val1)
    //       || (me.isIn(thisrm) && me.yValue==val2) ) {
    else if (me.isInForMap(room1) && me.yValue==val1) {
      str = str + 'm1' + meadd;
    }
    else if (me.isInForMap(thisrm) && me.yValue==val2) {
      str = str + 'm2';
    }
    else if (self == skyway
             && netonLocation != self
             && ovanLocation != self
             && youngGuardLocation != self
             && oldGuardLocation != self
             && assistantLocation != self
             && !me.isInForMap(self)) {
      if (val2 == 1) str = str + 'sky1';
      else if (val2 == 0) str = str + 'sky2';
      else str = str + dude1str + '0' + dude2str + '0' + dude3str + '0';
    }
    else {
      str = str + dude1str + '0' + dude2str + '0' + dude3str + '0';
    }
    return str;
  }
;

// -------------------------------------------------------------------
// ENDGAME MAP: giveFilename/giveHtml methods: museum
// -------------------------------------------------------------------

modify glob
  hackEndgameMap = nil
;

modify museum
  giveFilename() { return 'zz-nil'; }
  meY = 10
  netonY = 10
  ovanY = 10
  giveHtml() {
    if (!me.saw(self) && !glob.hackEndgameMap) {
      return '<img src="endgame/zz-nil.png" border="0">';
    }
//    local meIsInMu = nil;
//    local meIsNearMu = nil;
//    local netonIsInMu = nil;
//    local netonIsNearMu = nil;
//    local ovanIsInMu = nil;
//    local ovanIsNearMu = nil;
    //if (   me.isIn(museum)) {    meIsInMu = true;    meIsNearMu = true; }
    //if (neton.isIn(museum)) { netonIsInMu = true; netonIsNearMu = true; }
    //if ( ovan.isIn(museum)) {  ovanIsInMu = true;  ovanIsNearMu = true; }
    //if (   me.location==skyway &&    me.yOffset==2)    meIsNearMu = true;
    //if (neton.location==skyway && neton.yOffset==2) netonIsNearMu = true;
    //if ( ovan.location==skyway &&  ovan.yOffset==2)  ovanIsNearMu = true;
    
    //local meY, netonY, ovanY;
    if (me.isInForMap(skyway) && me.yValue==2) meY = -4;
    else if (!me.isInForMap(museum))           meY = 10;
    else                                       meY = me.yValue;
    if (neton.realLocation==skyway && neton.yValue==2) netonY = -4;
    else if (!neton.realLocation ||
             !neton.realLocation.isOrIsIn(museum)) netonY = 10;
    else                                           netonY = neton.yValue;
    if (ovan.realLocation==skyway && ovan.yValue==2) ovanY = -4;
    else if (!ovan.realLocation ||
             !ovan.realLocation.isOrIsIn(museum))  ovanY = 10;
    else                                           ovanY = ovan.yValue;

    if (!me.isInForMap(museum) && 
        (!neton.realLocation || !neton.realLocation.isOrIsIn(museum)) && 
        (!ovan.realLocation || !ovan.realLocation.isOrIsIn(museum))) {
      return '<table border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td><img src="endgame/zz-nil.png" width="152" height="135" border="0"></td>
            <td><img src="endgame/zz-flank1.png" border="0"></td>
            <td>
              <table border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td><img src="endgame/mu1a-.png" border="0"></td>
                  <td><img src="endgame/mu2a-.png" border="0"></td>
                  <td><img src="endgame/mu3a-.png" border="0"></td>
                  <td><img src="endgame/mu3a-.png" border="0"></td>
                  <td><img src="endgame/mu3a-.png" border="0"></td>
                  <td><img src="endgame/mu4a-.png" border="0"></td>
                  <td><img src="endgame/mu5a-.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/mu1b-.png" border="0"></td>
                  <td><img src="endgame/mu2b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-.png" border="0"></td>
                  <td><img src="endgame/mu4b-.png" border="0"></td>
                  <td><img src="endgame/mu5b-.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/mu1c-.png" border="0"></td>
                  <td><img src="endgame/mu2b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-.png" border="0"></td>
                  <td><img src="endgame/mu4b-.png" border="0"></td>
                  <td><img src="endgame/mu5c-.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/mu1d-.png" border="0"></td>
                  <td><img src="endgame/mu2b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-.png" border="0"></td>
                  <td><img src="endgame/mu4b-.png" border="0"></td>
                  <td><img src="endgame/mu5d-.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/mu1e-.png" border="0"></td>
                  <td><img src="endgame/mu2b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-z1.png" border="0"></td>
                  <td><img src="endgame/mu3b-z2.png" border="0"></td>
                  <td><img src="endgame/mu3b-z3.png" border="0"></td>
                  <td><img src="endgame/mu4b-.png" border="0"></td>
                  <td><img src="endgame/mu5e-.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/mu1f-.png" border="0"></td>
                  <td><img src="endgame/mu2b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-z4.png" border="0"></td>
                  <td><img src="endgame/mu3b-z5.png" border="0"></td>
                  <td><img src="endgame/mu3b-z6.png" border="0"></td>
                  <td><img src="endgame/mu4b-.png" border="0"></td>
                  <td><img src="endgame/mu5f-.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/mu1g-.png" border="0"></td>
                  <td><img src="endgame/mu2b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-.png" border="0"></td>
                  <td><img src="endgame/mu4b-.png" border="0"></td>
                  <td><img src="endgame/mu5g-.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/mu1h-.png" border="0"></td>
                  <td><img src="endgame/mu2b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-.png" border="0"></td>
                  <td><img src="endgame/mu3b-.png" border="0"></td>
                  <td><img src="endgame/mu4b-.png" border="0"></td>
                  <td><img src="endgame/mu5h-.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/mu1i-.png" border="0"></td>
                  <td><img src="endgame/mu2c-.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename3I() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename4I() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename5I() + '.png" border="0"></td>
                  <td><img src="endgame/mu4c-.png" border="0"></td>
                  <td><img src="endgame/mu5i-.png" border="0"></td>
                </tr>
              </table>
            </td>
            <td><img src="endgame/zz-flank2.png" border="0"></td>
          </tr>
        </table>';
    }
    else {
      return '<table border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td><img src="endgame/zz-nil.png" width="152" height="135" border="0"></td>
            <td><img src="endgame/zz-flank1.png" border="0"></td>
            <td>
              <table border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td><img src="endgame/' + giveFilename1A() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename2A() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename3A() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename4A() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename5A() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename6A() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename7A() + '.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/' + giveFilename1B() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename2B() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename3B() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename4B() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename5B() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename6B() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename7B() + '.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/' + giveFilename1C() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename2C() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename3C() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename4C() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename5C() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename6C() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename7C() + '.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/' + giveFilename1D() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename2D() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename3D() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename4D() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename5D() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename6D() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename7D() + '.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/' + giveFilename1E() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename2E() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename3E() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename4E() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename5E() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename6E() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename7E() + '.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/' + giveFilename1F() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename2F() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename3F() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename4F() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename5F() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename6F() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename7F() + '.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/' + giveFilename1G() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename2G() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename3G() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename4G() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename5G() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename6G() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename7G() + '.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/' + giveFilename1H() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename2H() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename3H() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename4H() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename5H() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename6H() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename7H() + '.png" border="0"></td>
                </tr>
                <tr>
                  <td><img src="endgame/' + giveFilename1I() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename2I() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename3I() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename4I() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename5I() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename6I() + '.png" border="0"></td>
                  <td><img src="endgame/' + giveFilename7I() + '.png" border="0"></td>
                </tr>
              </table>
            </td>
            <td><img src="endgame/zz-flank2.png" border="0"></td>
          </tr>
        </table>';
    }
  }
  /*
  giveFilename1A() { return 'mu1a-'; }
  giveFilename2A() { return 'mu2a-'; }
  giveFilename3A() { return 'mu3a-'; }
  giveFilename4A() { return 'mu3a-'; }
  giveFilename5A() { return 'mu3a-'; }
  giveFilename6A() { return 'mu4a-'; }
  giveFilename7A() { return 'mu1a-'; }
  giveFilename1B() { return 'mu1b-'; }
  giveFilename2B() { return 'mu2b-'; }
  giveFilename3B() { return 'mu3b-'; }
  giveFilename4B() { return 'mu3b-'; }
  giveFilename5B() { return 'mu3b-'; }
  giveFilename6B() { return 'mu4b-'; }
  giveFilename7B() { return 'mu1b-'; }
  giveFilename1C() { return 'mu1b-'; }
  giveFilename2C() { return 'mu2b-'; }
  giveFilename3C() { return 'mu3b-'; }
  giveFilename4C() { return 'mu3b-'; }
  giveFilename5C() { return 'mu3b-'; }
  giveFilename6C() { return 'mu4b-'; }
  giveFilename7C() { return 'mu1b-'; }
  giveFilename1D() { return 'mu1b-'; }
  giveFilename2D() { return 'mu2b-'; }
  giveFilename3D() { return 'mu3b-'; }
  giveFilename4D() { return 'mu3b-'; }
  giveFilename5D() { return 'mu3b-'; }
  giveFilename6D() { return 'mu4b-'; }
  giveFilename7D() { return 'mu1b-'; }
  giveFilename1E() { return 'mu1b-'; }
  giveFilename2E() { return 'mu2b-'; }
  giveFilename3E() { return 'mu3b-'; }
  giveFilename4E() { return 'mu3b-'; }
  giveFilename5E() { return 'mu3b-'; }
  giveFilename6E() { return 'mu4b-'; }
  giveFilename7E() { return 'mu1b-'; }
  giveFilename1F() { return 'mu1b-'; }
  giveFilename2F() { return 'mu2b-'; }
  giveFilename3F() { return 'mu3b-'; }
  giveFilename4F() { return 'mu3b-'; }
  giveFilename5F() { return 'mu3b-'; }
  giveFilename6F() { return 'mu4b-'; }
  giveFilename7F() { return 'mu1b-'; }
  giveFilename1G() { return 'mu1b-'; }
  giveFilename2G() { return 'mu2b-'; }
  giveFilename3G() { return 'mu3b-'; }
  giveFilename4G() { return 'mu3b-'; }
  giveFilename5G() { return 'mu3b-'; }
  giveFilename6G() { return 'mu4b-'; }
  giveFilename7G() { return 'mu1b-'; }
  giveFilename1H() { return 'mu1b-'; }
  giveFilename2H() { return 'mu2b-'; }
  giveFilename3H() { return 'mu3b-'; }
  giveFilename4H() { return 'mu3b-'; }
  giveFilename5H() { return 'mu3b-'; }
  giveFilename6H() { return 'mu4b-'; }
  giveFilename7H() { return 'mu1b-'; }
  giveFilename1I() { return 'mu1c-'; }
  giveFilename2I() { return 'mu2c-'; }
  giveFilename3I() { return 'mu3b-'; }
  giveFilename4I() { return 'mu3b-'; }
  giveFilename5I() { return 'mu3b-'; }
  giveFilename6I() { return 'mu4c-'; }
  giveFilename7I() { return 'mu1c-'; }
  */
  giveFilename1A() { return giveFileForMu('a', '1',  5, -3); }
  giveFilename2A() { return giveFileForMu('a', '2',  5, -2); }
  giveFilename3A() { return giveFileForMu('a', '3',  5, -1); }
  giveFilename4A() { return giveFileForMu('a', '3',  5,  0); }
  giveFilename5A() { return giveFileForMu('a', '3',  5,  1); }
  giveFilename6A() { return giveFileForMu('a', '4',  5,  2); }
  giveFilename7A() { return giveFileForMu('a', '5',  5,  3); }

  giveFilename1B() { return giveFileForMu('b', '1',  4, -3); }
  giveFilename2B() { return giveFileForMu('b', '2',  4, -2); }
  giveFilename3B() { return giveFileForMu('b', '3',  4, -1); }
  giveFilename4B() { return giveFileForMu('b', '3',  4,  0); }
  giveFilename5B() { return giveFileForMu('b', '3',  4,  1); }
  giveFilename6B() { return giveFileForMu('b', '4',  4,  2); }
  giveFilename7B() { return giveFileForMu('b', '5',  4,  3); }

  giveFilename1C() { return giveFileForMu('c', '1',  3, -3); }
  giveFilename2C() { return giveFileForMu('b', '2',  3, -2); }
  giveFilename3C() { return giveFileForMu('b', '3',  3, -1); }
  giveFilename4C() { return giveFileForMu('b', '3',  3,  0); }
  giveFilename5C() { return giveFileForMu('b', '3',  3,  1); }
  giveFilename6C() { return giveFileForMu('b', '4',  3,  2); }
  giveFilename7C() { return giveFileForMu('c', '5',  3,  3); }

  giveFilename1D() { return giveFileForMu('d', '1',  2, -3); }
  giveFilename2D() { return giveFileForMu('b', '2',  2, -2); }
  giveFilename3D() { return giveFileForMu('b', '3',  2, -1); }
  giveFilename4D() { return giveFileForMu('b', '3',  2,  0); }
  giveFilename5D() { return giveFileForMu('b', '3',  2,  1); }
  giveFilename6D() { return giveFileForMu('b', '4',  2,  2); }
  giveFilename7D() { return giveFileForMu('d', '5',  2,  3); }

  giveFilename1E() { return giveFileForMu('e', '1',  1, -3); }
  giveFilename2E() { return giveFileForMu('b', '2',  1, -2); }
  giveFilename3E() { return giveFileForMu('b', '3',  1, -1); }
  giveFilename4E() { return giveFileForMu('b', '3',  1,  0); }
  giveFilename5E() { return giveFileForMu('b', '3',  1,  1); }
  giveFilename6E() { return giveFileForMu('b', '4',  1,  2); }
  giveFilename7E() { return giveFileForMu('e', '5',  1,  3); }

  giveFilename1F() { return giveFileForMu('f', '1',  0, -3); }
  giveFilename2F() { return giveFileForMu('b', '2',  0, -2); }
  giveFilename3F() { return giveFileForMu('b', '3',  0, -1); }
  giveFilename4F() { return giveFileForMu('b', '3',  0,  0); }
  giveFilename5F() { return giveFileForMu('b', '3',  0,  1); }
  giveFilename6F() { return giveFileForMu('b', '4',  0,  2); }
  giveFilename7F() { return giveFileForMu('f', '5',  0,  3); }

  giveFilename1G() { return giveFileForMu('g', '1', -1, -3); }
  giveFilename2G() { return giveFileForMu('b', '2', -1, -2); }
  giveFilename3G() { return giveFileForMu('b', '3', -1, -1); }
  giveFilename4G() { return giveFileForMu('b', '3', -1,  0); }
  giveFilename5G() { return giveFileForMu('b', '3', -1,  1); }
  giveFilename6G() { return giveFileForMu('b', '4', -1,  2); }
  giveFilename7G() { return giveFileForMu('g', '5', -1,  3); }

  giveFilename1H() { return giveFileForMu('h', '1', -2, -3); }
  giveFilename2H() { return giveFileForMu('b', '2', -2, -2); }
  giveFilename3H() { return giveFileForMu('b', '3', -2, -1); }
  giveFilename4H() { return giveFileForMu('b', '3', -2,  0); }
  giveFilename5H() { return giveFileForMu('b', '3', -2,  1); }
  giveFilename6H() { return giveFileForMu('b', '4', -2,  2); }
  giveFilename7H() { return giveFileForMu('h', '5', -2,  3); }

  giveFilename1I() { return giveFileForMu('i', '1', -3, -3); }
  giveFilename2I() { return giveFileForMu('c', '2', -3, -2); }
  giveFilename3I() { return giveFileForMu('b', '3', -3, -1); }
  giveFilename4I() { return giveFileForMu('b', '3', -3,  0); }
  giveFilename5I() { return giveFileForMu('b', '3', -3,  1); }
  giveFilename6I() { return giveFileForMu('c', '4', -3,  2); }
  giveFilename7I() { return giveFileForMu('i', '5', -3,  3); }
  
  
//  giveFilename1A() { return giveFileForMu('a', '1',  5, -3); }
//  giveFilename2A() { return giveFileForMu('a', '2',  5, -2); }
//  giveFilename3A() { return giveFileForMu('a', '3',  5, -1); }
//  giveFilename4A() { return giveFileForMu('a', '3',  5,  0); }
//  giveFilename5A() { return giveFileForMu('a', '3',  5,  1); }
//  giveFilename6A() { return giveFileForMu('a', '4',  5,  2); }
//  giveFilename7A() { return giveFileForMu('a', '1',  5,  3); }
//  giveFilename1B() { return giveFileForMu('b', '1',  4, -3); }
//  giveFilename2B() { return giveFileForMu('b', '2',  4, -2); }
//  giveFilename3B() { return giveFileForMu('b', '3',  4, -1); }
//  giveFilename4B() { return giveFileForMu('b', '3',  4,  0); }
//  giveFilename5B() { return giveFileForMu('b', '3',  4,  1); }
//  giveFilename6B() { return giveFileForMu('b', '4',  4,  2); }
//  giveFilename7B() { return giveFileForMu('b', '1',  4,  3); }
//  giveFilename1C() { return giveFileForMu('b', '1',  3, -3); }
//  giveFilename2C() { return giveFileForMu('b', '2',  3, -2); }
//  giveFilename3C() { return giveFileForMu('b', '3',  3, -1); }
//  giveFilename4C() { return giveFileForMu('b', '3',  3,  0); }
//  giveFilename5C() { return giveFileForMu('b', '3',  3,  1); }
//  giveFilename6C() { return giveFileForMu('b', '4',  3,  2); }
//  giveFilename7C() { return giveFileForMu('b', '1',  3,  3); }
//  giveFilename1D() { return giveFileForMu('b', '1',  2, -3); }
//  giveFilename2D() { return giveFileForMu('b', '2',  2, -2); }
//  giveFilename3D() { return giveFileForMu('b', '3',  2, -1); }
//  giveFilename4D() { return giveFileForMu('b', '3',  2,  0); }
//  giveFilename5D() { return giveFileForMu('b', '3',  2,  1); }
//  giveFilename6D() { return giveFileForMu('b', '4',  2,  2); }
//  giveFilename7D() { return giveFileForMu('b', '1',  2,  3); }
//  giveFilename1E() { return giveFileForMu('b', '1',  1, -3); }
//  giveFilename2E() { return giveFileForMu('b', '2',  1, -2); }
//  giveFilename3E() { return giveFileForMu('b', '3',  1, -1); }
//  giveFilename4E() { return giveFileForMu('b', '3',  1,  0); }
//  giveFilename5E() { return giveFileForMu('b', '3',  1,  1); }
//  giveFilename6E() { return giveFileForMu('b', '4',  1,  2); }
//  giveFilename7E() { return giveFileForMu('b', '1',  1,  3); }
//  giveFilename1F() { return giveFileForMu('b', '1',  0, -3); }
//  giveFilename2F() { return giveFileForMu('b', '2',  0, -2); }
//  giveFilename3F() { return giveFileForMu('b', '3',  0, -1); }
//  giveFilename4F() { return giveFileForMu('b', '3',  0,  0); }
//  giveFilename5F() { return giveFileForMu('b', '3',  0,  1); }
//  giveFilename6F() { return giveFileForMu('b', '4',  0,  2); }
//  giveFilename7F() { return giveFileForMu('b', '1',  0,  3); }
//  giveFilename1G() { return giveFileForMu('b', '1', -1, -3); }
//  giveFilename2G() { return giveFileForMu('b', '2', -1, -2); }
//  giveFilename3G() { return giveFileForMu('b', '3', -1, -1); }
//  giveFilename4G() { return giveFileForMu('b', '3', -1,  0); }
//  giveFilename5G() { return giveFileForMu('b', '3', -1,  1); }
//  giveFilename6G() { return giveFileForMu('b', '4', -1,  2); }
//  giveFilename7G() { return giveFileForMu('b', '1', -1,  3); }
//  giveFilename1H() { return giveFileForMu('b', '1', -2, -3); }
//  giveFilename2H() { return giveFileForMu('b', '2', -2, -2); }
//  giveFilename3H() { return giveFileForMu('b', '3', -2, -1); }
//  giveFilename4H() { return giveFileForMu('b', '3', -2,  0); }
//  giveFilename5H() { return giveFileForMu('b', '3', -2,  1); }
//  giveFilename6H() { return giveFileForMu('b', '4', -2,  2); }
//  giveFilename7H() { return giveFileForMu('b', '1', -2,  3); }
//  giveFilename1I() { return giveFileForMu('c', '1', -3, -3); }
//  giveFilename2I() { return giveFileForMu('c', '2', -3, -2); }
//  giveFilename3I() { return giveFileForMu('b', '3', -3, -1); }
//  giveFilename4I() { return giveFileForMu('b', '3', -3,  0); }
//  giveFilename5I() { return giveFileForMu('b', '3', -3,  1); }
//  giveFilename6I() { return giveFileForMu('c', '4', -3,  2); }
//  giveFilename7I() { return giveFileForMu('c', '1', -3,  3); }
  
  
  

  giveFileForMu(let, num, yval, xval) {
    
    
//if (ovan.getOutermostRoom == skyway && ovan.yValue == 2 && yval == -3 && xval == 1) { local k=0; k=k/k; }
    
    
    
    local str;
    local spot1 = nil;
    local spot2 = nil;
    str = 'mu' + num + let + '-';
    switch (xval) {
      // Deal with pedestal graphics differently, because we do not
      // want to allow for the possibility that any NPC could ever be 
      // standing on a pedestal. The PC is a different matter; he could
      // certainly be standing on a pedestal.
      case -3:
      case  3:
        if (me.xValue == xval) {
          if (meY == yval  ) str = str + 'm2';
          if (meY == yval-1) str = str + 'm1';
        }
        //return str;
        break;
      // When not dealing with pedestal graphics, we certainly do 
      // have to allow for the necessity of displaying graphics 
      // for Neton or Ovan -- or, of course, the PC.
      case -2:
      case -1:
      case  0:
      case  1:
      case  2:
        spot1 = nil;
        spot2 = nil;
        if (me.xValue == xval) {
          if (meY == yval  ) { str = str + 'm2'; spot2 = true; }
          if (meY == yval-1) {
            spot1 = true;
            if (meY == -4) str = str + 'mx';
            else str = str + 'm1';
          }
        }
        if (neton.xValue == xval && 
            ((neton.realLocation && neton.realLocation.isOrIsIn(museum)) ||
             (neton.realLocation && neton.realLocation.isOrIsIn(skyway) && neton.yValue == 2))) {
          if (netonY==yval   && spot2==nil) { str = str + 'p2'; spot2 = true; }
          if (netonY==yval-1 && spot1==nil) { str = str + 'p1'; spot1 = true; }
        }
        if (ovan.xValue == xval && 
            ((ovan.realLocation && ovan.realLocation.isOrIsIn(museum)) ||
             (ovan.realLocation && ovan.realLocation.isOrIsIn(skyway) && ovan.yValue == 2))) {
          if (ovanY==yval   && spot2==nil) str = str + 'q2';
          if (ovanY==yval-1 && spot1==nil) str = str + 'q1';
        }
        break;
        //return str;
        
        
        
        //break;
    }
    return str;
  }
  giveFileForMuA() {
    return '';
  }
  giveFileForMuB() {
    return '';
  }
  giveFileForMuC() {
    return '';
  }
  giveFileForMuD() {
    return '';
  }
;

// -------------------------------------------------------------------
// ENDGAME MAP: giveFilename/giveHtml methods: second row (north of office, etc.)
// -------------------------------------------------------------------

northwestOfHallway1: object
  giveFilename() {
    if (me.saw(hallway1) || glob.hackEndgameMap)
      return 'zz-wall9';
    else
      return 'zz-nil';
  }
;
northOfHallway1: AlienRoom
  'Hallway'
  'the room where you win the game'
  "This is not an actual room. Please go 
    back south now. "
  south = frontDoors2
  giveFilename() {
    if (me.saw(hallway1) || glob.hackEndgameMap) {
      if (frontDoorsAreOpen) return 'zz-doors8b';
      else return 'zz-doors8c';
    }
    else if (me.saw(hallway8) || glob.hackEndgameMap) {
      return 'zz-wall9';
    }
    else {
      return 'zz-nil';
    }
  }
;
northOfHallway8: object
  giveFilename() {
    if (me.saw(hallway8) || glob.hackEndgameMap)
      return 'zz-wall8';
    else
      return 'zz-wall9';
  }
;
northOfOffice: object
  giveFilename() {
    if (me.saw(skyway) || glob.hackEndgameMap)
      return 'zz-nook1';
    else
      return 'zz-wall8';
  }
;
modify skyway
  //giveFilename() { return 'zz-nil'; }
  giveHtml() {
    if (!me.saw(self) && !glob.hackEndgameMap) {
      return '<img src="endgame/zz-wall7.png" border="0">';
    }
    else {
      return '<table border="0" cellspacing="0" cellpadding="0">
              <tr>
                <td><img src="endgame/' + giveFilenameA1() + '.png" border="0"></td>
                <td><img src="endgame/' + giveFilenameB1() + '.png" border="0"></td>
              </tr>
              <tr>
                <td><img src="endgame/' + giveFilenameA2() + '.png" border="0"></td>
                <td><img src="endgame/' + giveFilenameB2() + '.png" border="0"></td>
              </tr>
              <tr>
                <td><img src="endgame/' + giveFilenameA3() + '.png" border="0"></td>
                <td><img src="endgame/' + giveFilenameB3() + '.png" border="0"></td>
              </tr>
              <tr>
                <td><img src="endgame/' + giveFilenameA4() + '.png" border="0"></td>
                <td><img src="endgame/' + giveFilenameB4() + '.png" border="0"></td>
              </tr>
            </table>';
    }
  }
  giveFilenameA1() { return giveFileForH9('a', '0', 1, self, 2, self, ''); }
  giveFilenameA2() { return giveFileForH9('a', '0', 0, self, 1, self, ''); }
  giveFilenameA3() { return giveFileForH9('a', '0', -1,self, 0, self, ''); }
  giveFilenameA4() { return giveFileForH9('a', '0', 2, self.south, -1,self, ''); }
  giveFilenameB1() { return giveFileForH9('b', '0', 1, self, 2, self, ''); }
  giveFilenameB2() { return giveFileForH9('b', '0', 0, self, 1, self, ''); }
  giveFilenameB3() { return giveFileForH9('b', '0', -1,self, 0, self, ''); }
  giveFilenameB4() { return giveFileForH9('b', '0', 2, self.south, -1,self, ''); }
  //giveFilenameA1() {
  //  return 'h9a-0p0g0a0';
  //}
  //giveFilenameA2() {
  //  return 'h9a-0p0g0a0';
  //}
  //giveFilenameA3() {
  //  return 'h9a-0p0g0a0';
  //}
  //giveFilenameA4() {
  //  return 'h9a-0p0g0a0';
  //}
  //giveFilenameB1() {
  //  return 'h9b-0a0h0q0';
  //}
  //giveFilenameB2() {
  //  return 'h9b-0a0h0q0';
  //}
  //giveFilenameB3() {
  //  return 'h9b-0a0h0q0';
  //}
  //giveFilenameB4() {
  //  return 'h9b-0a0h0q0';
  //}
;
eastOfSkyway: object
  giveFilename() {
    if (me.saw(skyway) || glob.hackEndgameMap)
      return 'zz-nook2';
    else
      return 'zz-nil';
  }
;

// -------------------------------------------------------------------
// ENDGAME MAP: giveFilename/giveHtml methods: third row (office)
// -------------------------------------------------------------------

westOfHallway1: object
  giveFilename() {
    if (me.saw(hallway1) || glob.hackEndgameMap)
      return 'zz-wall6';
    else if (me.saw(hallway2))
      return 'zz-wall9';
    else
      return 'zz-nil';
  }
;
modify hallway1
  giveFilename() {
    local str;
    if (!me.saw(self) && !glob.hackEndgameMap) {
      if (me.saw(hallway2) && me.saw(hallway8))
        return 'zz-wallcorner67';
      else if (me.saw(hallway2))
        return 'zz-corners79';
      else if (me.saw(hallway8))
        return 'zz-wall6';
      else if (me.saw(hallway7))
        return 'zz-wall9';
      else
        return 'zz-nil';
    }
    else {
      str = 'h1-';
      if (frontDoorsAreOpen) str = str + '0';
      else str = str + '1';
      if (me.isInForMap(self)) str = str + 'm';
      if (vickiLocation == self || dianeLocation == self)
        str = str + 'wx';
      return str;
    }
  }
;
modify hallway8
  giveFilename() {
    if (!me.saw(self) && !glob.hackEndgameMap) {
      if (officeDoorIsOpen) return 'zz-door6b';
      else return 'zz-door6c';
    }
    else if (netonLocation == self || ovanLocation == self) {
      if (officeDoorIsOpen) return 'h8-0pq';
      else return 'h8-1pq';
    }
    else if (me.isInForMap(self)) {
      if (officeDoorIsOpen) return 'h8-0m';
      else return 'h8-1m';
    }
    else {
      if (officeDoorIsOpen) return 'h8-0';
      else return 'h8-1';
    }
  }
;
modify office
  giveFilename() {
    if (netonLocation == office || ovanLocation == office) {
      if (officeDoorIsOpen) return 'of-0pq';
      else return 'of-1pq';
    }
    else if (me.isInForMap(office)) {
      if (officeDoorIsOpen) return 'of-0m';
      else return 'of-1m';
    }
    else {
      if (officeDoorIsOpen) return 'of-0';
      else return 'of-1';
    }
  }
;
modify hallway9
  //giveFilename() { return 'zz-nil'; }
  giveHtml() {
    if (!me.saw(self) && !glob.hackEndgameMap) {
      return '<img src="endgame/zz-wall4.png" border="0">';
    }
    else {
      return '<table border="0" cellspacing="0" cellpadding="0">
              <tr>
                <td><img src="endgame/' + giveFilenameA1() + '.png" border="0"></td>
                <td><img src="endgame/' + giveFilenameB1() + '.png" border="0"></td>
              </tr>
              <tr>
                <td><img src="endgame/' + giveFilenameA2() + '.png" border="0"></td>
                <td><img src="endgame/' + giveFilenameB2() + '.png" border="0"></td>
              </tr>
              <tr>
                <td><img src="endgame/' + giveFilenameA3() + '.png" border="0"></td>
                <td><img src="endgame/' + giveFilenameB3() + '.png" border="0"></td>
              </tr>
              <tr>
                <td><img src="endgame/' + giveFilenameA4() + '.png" border="0"></td>
                <td><img src="endgame/' + giveFilenameB4() + '.png" border="0"></td>
              </tr>
            </table>';
    }
  }
  giveFilenameA1() { return giveFileForH9('a', '0', 1, self, 2, self, ''); }
  giveFilenameA2() { return giveFileForH9('a', '0', 0, self, 1, self, ''); }
  giveFilenameA3() { return giveFileForH9('a', '0', -1,self, 0, self, ''); }
  giveFilenameA4() { return giveFileForH9('a', '0', 2, self.south, -1,self, ''); }
  giveFilenameB1() { return giveFileForH9('b', '0', 1, self, 2, self, ''); }
  giveFilenameB2() { return giveFileForH9('b', '0', 0, self, 1, self, ''); }
  giveFilenameB3() { return giveFileForH9('b', '0', -1,self, 0, self, ''); }
  giveFilenameB4() { return giveFileForH9('b', '0', 2, self.south, -1,self, ''); }
  //giveFilenameA1() {
  //  return 'h9a-0p0g0a0';
  //}
  //giveFilenameA2() {
  //  return 'h9a-0p0g0a0';
  //}
  //giveFilenameA3() {
  //  return 'h9a-0p0g0a0';
  //}
  //giveFilenameA4() {
  //  return 'h9a-0p0g0a0';
  //}
  //giveFilenameB1() {
  //  return 'h9b-0a0h0q0';
  //}
  //giveFilenameB2() {
  //  return 'h9b-0a0h0q0';
  //}
  //giveFilenameB3() {
  //  return 'h9b-0a0h0q0';
  //}
  //giveFilenameB4() {
  //  return 'h9b-0a0h0q0';
  //}
;
eastOfHallway9: object
  giveFilename() {
    if (me.saw(hallway9) || glob.hackEndgameMap)
      return 'zz-wall4';
    else
      return 'zz-nil';
  }
;

// -------------------------------------------------------------------
// ENDGAME MAP: giveFilename/giveHtml methods: fourth row (dream room, etc.)
// -------------------------------------------------------------------

westOfHallway2: object
  giveFilename() {
    if (me.saw(hallway2) || glob.hackEndgameMap)
      return 'zz-wall6';
    else if (me.saw(hallway3))
      return 'zz-wall9';
    else
      return 'zz-nil';
  }
;
modify hallway2
  giveFilename() {
    local str;
    if (!me.saw(self) && !glob.hackEndgameMap) {
      if (me.saw(hallway7) && me.saw(hallway3)) {
        if (hallDoorsAreOpen) return 'zz-doorswall8b6';
        else return 'zz-doorswall8c6';
      }
      else if (me.saw(hallway7)) {
        return 'zz-wall6';
      }
      else if (me.saw(hallway3)) {
        if (hallDoorsAreOpen) return 'zz-doors8a';
        else return 'zz-doors8c';
      }
      else if (me.saw(hallway4)) {
        return 'zz-wall9';
      }
      else {
        return 'zz-nil';
      }
    }
    else {
      str = 'h2-';
      if (hallDoorsAreOpen) str = str + '0';
      else str = str + '1';
      if (me.isInForMap(self)) str = str + 'm';
      if (vickiLocation == self || dianeLocation == self)
        str = str + 'wx';
      return str;
    }
  }
;
modify hallway7
  giveFilename() {
    if (!me.saw(self) && !glob.hackEndgameMap) {
      if (me.saw(hallway4))
        return 'zz-wallcorner67';
      else
        return 'zz-wall6';
    }
    else {
      if (netonLocation == self || ovanLocation == self)
        return 'h7-pq';
      else if (me.isInForMap(self))
        return 'h7-m';
      else
        return 'h7-';
    }
  }
;
modify dreamRoom
  giveFilename() {
    if (netonLocation == dreamRoom || ovanLocation == dreamRoom) {
      if (dreamDoorIsOpen) return 'dr-0pq';
      else return 'dr-1pq';
    }
    else if (me.isInForMap(dreamRoom)) {
      if (dreamDoorIsOpen) return 'dr-0m';
      else return 'dr-1m';
    }
    else {
      if (dreamDoorIsOpen) return 'dr-0';
      else return 'dr-1';
    }
  }
;
modify stairs
  //giveFilename() { return 'zz-nil'; }
  giveHtml() {
    if (!me.saw(self) && !glob.hackEndgameMap) {
      if (me.saw(hallway6))
        return '<img src="endgame/zz-wallcorner49.png" border="0">';
      else
        return '<img src="endgame/zz-wall4.png" border="0">';
    }
    else {
      return '<table border="0" cellspacing="0" cellpadding="0">
              <tr>
                <td><img src="endgame/' + giveFilenameA1() + '.png" border="0"></td>
                <td><img src="endgame/' + giveFilenameB1() + '.png" border="0"></td>
              </tr>
              <tr>
                <td><img src="endgame/' + giveFilenameA2() + '.png" border="0"></td>
                <td><img src="endgame/' + giveFilenameB2() + '.png" border="0"></td>
              </tr>
              <tr>
                <td><img src="endgame/' + giveFilenameA3() + '.png" border="0"></td>
                <td><img src="endgame/' + giveFilenameB3() + '.png" border="0"></td>
              </tr>
              <tr>
                <td><img src="endgame/' + giveFilenameA4() + '.png" border="0"></td>
                <td><img src="endgame/' + giveFilenameB4() + '.png" border="0"></td>
              </tr>
            </table>';
    }
  }
  giveFilenameA1() { return giveFileForH9('a', '1', 1, self, 2, self, ''); }
  giveFilenameA2() { return giveFileForH9('a', '1', 0, self, 1, self, ''); }
  giveFilenameA3() { return giveFileForH9('a', '1', -1,self, 0, self, ''); }
  giveFilenameA4() { return giveFileForH9('a', '1', 2, self.south, -1,self, 'b'); }
  giveFilenameB1() { return giveFileForH9('b', '1', 1, self, 2, self, ''); }
  giveFilenameB2() { return giveFileForH9('b', '1', 0, self, 1, self, ''); }
  giveFilenameB3() { return giveFileForH9('b', '1', -1,self, 0, self, ''); }
  giveFilenameB4() { return giveFileForH9('b', '1', 2, self.south, -1,self, 'b'); }
  //giveFilenameA1() {
  //  local val1 = 1, val2 = 2;
  //  local str;
  //  str = 'h9a-1';
  //  if ((netonLocation==self && (netonYValue==val1 || netonYValue==val2))
  //       || (netonLocation==self && (youngGuardYValue==val1 || youngGuardYValue==val2))
  //       || (assistantLocation==self && (assistantYValue==val1 || assistantYValue==val2))) {
  //    if (netonLocation != self) str = str + 'p0';
  //    else if (netonYValue == val1) str = str + 'p1';
  //    else if (netonYValue == val2) str = str + 'p2';
  //    else str = str + 'p0';
  //    
  //    if (youngGuardLocation != self) str = str + 'g0';
  //    else if (youngGuardYValue == val1) str = str + 'g1';
  //    else if (youngGuardYValue == val2) str = str + 'g2';
  //    else str = str + 'g0';
  //    
  //    if (assistantLocation != self) str = str + 'a0';
  //    else if (assistantYValue == val1) str = str + 'a1';
  //    else if (assistantYValue == val2) str = str + 'a2';
  //    else str = str + 'a0';
  //  }
  //  else if (me.isIn(self) && (me.yValue==val1 || me.yValue==val2)) {
  //    if (me.yValue == val1) str = str + 'm1';
  //    else str = str + 'm2';
  //  }
  //  else str = str + 'p0g0a0';
  //  //str = 'h9a-1p0g0a0';
  //  return str;
  //}
  //giveFilenameA2() {
  //  local val1 = 0, val2 = 1;
  //  local str;
  //  str = 'h9a-1';
  //  if ((netonLocation==self && (netonYValue==val1 || netonYValue==val2))
  //       || (netonLocation==self && (youngGuardYValue==val1 || youngGuardYValue==val2))
  //       || (assistantLocation==self && (assistantYValue==val1 || assistantYValue==val2))) {
  //    if (netonLocation != self) str = str + 'p0';
  //    else if (netonYValue == val1) str = str + 'p1';
  //    else if (netonYValue == val2) str = str + 'p2';
  //    else str = str + 'p0';
  //    
  //    if (youngGuardLocation != self) str = str + 'g0';
  //    else if (youngGuardYValue == val1) str = str + 'g1';
  //    else if (youngGuardYValue == val2) str = str + 'g2';
  //    else str = str + 'g0';
  //    
  //    if (assistantLocation != self) str = str + 'a0';
  //    else if (assistantYValue == val1) str = str + 'a1';
  //    else if (assistantYValue == val2) str = str + 'a2';
  //    else str = str + 'a0';
  //  }
  //  else if (me.isIn(self) && (me.yValue==val1 || me.yValue==val2)) {
  //    if (me.yValue == val1) str = str + 'm1';
  //    else str = str + 'm2';
  //  }
  //  else str = str + 'p0g0a0';
  //  //str = 'h9a-1p0g0a0';
  //  return str;
  //}
  //giveFilenameA3() {
  //  local val1 = -1, val2 = 0;
  //  local str;
  //  str = 'h9a-1';
  //  if ((netonLocation==self && (netonYValue==val1 || netonYValue==val2))
  //       || (netonLocation==self && (youngGuardYValue==val1 || youngGuardYValue==val2))
  //       || (assistantLocation==self && (assistantYValue==val1 || assistantYValue==val2))) {
  //    if (netonLocation != self) str = str + 'p0';
  //    else if (netonYValue == val1) str = str + 'p1';
  //    else if (netonYValue == val2) str = str + 'p2';
  //    else str = str + 'p0';
  //    
  //    if (youngGuardLocation != self) str = str + 'g0';
  //    else if (youngGuardYValue == val1) str = str + 'g1';
  //    else if (youngGuardYValue == val2) str = str + 'g2';
  //    else str = str + 'g0';
  //    
  //    if (assistantLocation != self) str = str + 'a0';
  //    else if (assistantYValue == val1) str = str + 'a1';
  //    else if (assistantYValue == val2) str = str + 'a2';
  //    else str = str + 'a0';
  //  }
  //  else if (me.isIn(self) && (me.yValue==val1 || me.yValue==val2)) {
  //    if (me.yValue == val1) str = str + 'm1';
  //    else str = str + 'm2';
  //  }
  //  else str = str + 'p0g0a0';
  //  //str = 'h9a-1p0g0a0';
  //  return str;
  //}
  //giveFilenameA4() {
  //  local val1 = 2, val2 = -1;
  //  local str;
  //  str = 'h9a-1';
  //  if (    (netonLocation==self.south && netonYValue==val1)
  //       || (netonLocation==self       && netonYValue==val2)
  //       || (youngGuardLocation==self.south && youngGuardYValue==val1)
  //       || (youngGuardLocation==self       && youngGuardYValue==val2)
  //       || (assistantLocation==self.south && assistantYValue==val1)
  //       || (assistantLocation==self       && assistantYValue==val2) ) {
  //  
  //    if (netonLocation==self.south && netonYValue==val1)
  //      str = str + 'p1';
  //    else if (netonLocation==self && netonYValue==val2)
  //      str = str + 'p2';
  //    else str = str + 'p0';
  //    
  //    if (youngGuardLocation==self.south && youngGuardYValue==val1)
  //      str = str + 'g1';
  //    else if (youngGuardLocation==self && youngGuardYValue==val2)
  //      str = str + 'g2';
  //    else str = str + 'g0';
  //    
  //    if (assistantLocation==self.south && assistantYValue==val1)
  //      str = str + 'a1';
  //    else if (assistantLocation==self && assistantYValue==val2)
  //      str = str + 'a2';
  //    else str = str + 'a0';
  //  }
  //  else if (me.isIn(self.south) && me.yValue==val1) {
  //    str = str + 'm1';
  //  }
  //  else if (me.isIn(self) && me.yValue==val2) {
  //    str = str + 'm2';
  //  }
  //  else str = str + 'p0g0a0';
  //  //str = 'h9a-1p0g0a0';
  //  return str;
  //}
  //giveFilenameB1() {
  //  local str;
  //  str = 'h9b-1';
  //  str = 'h9b-1a0h0q0';
  //  return str;
  //}
  //giveFilenameB2() {
  //  local str;
  //  str = 'h9b-1';
  //  str = 'h9b-1a0h0q0';
  //  return str;
  //}
  //giveFilenameB3() {
  //  local str;
  //  str = 'h9b-1';
  //  str = 'h9b-1a0h0q0';
  //  return str;
  //}
  //giveFilenameB4() {
  //  local str;
  //  str = 'h9b-1';
  //  str = 'h9b-1a0h0q0';
  //  return str;
  //}
;
eastOfStairs: object
  giveFilename() {
    if (me.saw(stairs) || glob.hackEndgameMap)
      return 'zz-wall4';
    else if (me.saw(hallway6))
      return 'zz-wall7';
    else
      return 'zz-nil';
  }
;

// -------------------------------------------------------------------
// ENDGAME MAP: giveFilename/giveHtml methods: fifth row (hallways 3 to 6)
// -------------------------------------------------------------------

westOfHallway3: object
  giveFilename() {
    if (me.saw(hallway3) || glob.hackEndgameMap) {
      return 'zz-wall6';
    }
    else {
      return 'zz-nil';
    }
  }
;
modify hallway3
  giveFilename() {
    local str;
    if (!me.saw(hallway4) && !glob.hackEndgameMap) {
      return 'zz-nil';
    }
    else if (!me.saw(self) && !glob.hackEndgameMap) {
      return 'zz-corners39';
    }
    else {
      str = 'h3-';
      if (hallDoorsAreOpen) str = str + '0';
      else str = str + '1';
      if (cellDoorIsOpen) str = str + '0';
      else str = str + '1';
      if (me.isInForMap(self)) str = str + 'm';
      if (vickiLocation == self || dianeLocation == self)
        str = str + 'wx';
      return str;
    }
  }
;
modify hallway4
  giveFilename() {
    if (!me.saw(hallway5) && !glob.hackEndgameMap) {
      return 'zz-wall3';
    }
    else if (!me.saw(self) && !glob.hackEndgameMap) {
      return 'zz-corners39';
    }
    else if (netonLocation == self || ovanLocation == self) {
      if (breakDoorIsOpen) return 'h4-0pq';
      else return 'h4-1pq';
    }
    else if (youngGuardLocation == self || oldGuardLocation == self) {
      if (breakDoorIsOpen) return 'h4-0g';
      else return 'h4-1g';
    }
    else if (!me.isInForMap(self)) {
      if (breakDoorIsOpen) return 'h4-0';
      else return 'h4-1';
    }
    else if (oldGuardLocation == breakRoom) {
      if (breakDoorIsOpen) return 'h4-0m1';
      else return 'h4-1m1';
    }
    else {
      if (breakDoorIsOpen) return 'h4-0m';
      else return 'h4-1m';
    }
  }
;
modify hallway5
  giveFilename() {
    local str;
    if (!me.saw(self) && !glob.hackEndgameMap) {
      return 'zz-door2c';
    }
    else {
      if (dreamDoorIsOpen) str = 'h5-0';
      else str = 'h5-1';
      if (bathDoorIsOpen) str = str + '0';
      else str = str + '1';
      if (netonLocation == self || ovanLocation == self)
        str = str + 'pq';
      else if (youngGuardLocation == self && oldGuardLocation == self)
        str = str + 'gh';
      else if (youngGuardLocation == self || oldGuardLocation == self)
        str = str + 'g';
      else if (me.isInForMap(self))
        str = str + 'm';
      return str;
    }
  }
;
modify hallway6
  //giveFilename() { return 'zz-nil'; }
  giveHtml() {
    if (!me.saw(hallway5) && !glob.hackEndgameMap) {
      return '<img src="endgame/zz-wall1.png" border="0">';
    }
    else if (!me.saw(self) && !glob.hackEndgameMap) {
      return '<img src="endgame/zz-doorway4.png" border="0">';
    }
    else {
return '<table border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td><img src="endgame/' + giveFilenameA() + '.png" border="0"></td>
          <td><img src="endgame/' + giveFilenameB() + '.png" border="0"></td>
          <td><img src="endgame/' + giveFilenameC() + '.png" border="0"></td>
          <td><img src="endgame/' + giveFilenameD() + '.png" border="0"></td>
        </tr>
      </table>
    </td>
  </tr>
  <tr>
    <td><img src="endgame/' + giveFilenameE + '.png" border="0"></td>
  </tr>
</table>';
    }
  }
  giveFilenameA() {
    local str;
    str = 'h6a-';
    if (slowingFieldIsOn) str = str + '1';
    else str = str + '0';
    if (netonLocation != self) str = str + 'p0';
    else {
      switch (netonYValue) {
        case 0:  str = str + 'p1'; break;
        case 1:  str = str + 'p2'; break;
        case 2:  str = str + 'p3'; break;
        default: str = str + 'p0'; break;
      }
    }
    if (youngGuardLocation != self) str = str + 'g0';
    else {
      switch (youngGuardYValue) {
        case 0:  str = str + 'g1'; break;
        case 1:  str = str + 'g2'; break;
        case 2:  str = str + 'g3'; break;
        default: str = str + 'g0'; break;
      }
    }
    return str;
  }
  giveFilenameB() {
    local str;
    str = 'h6b-';
    if (slowingFieldIsOn) str = str + '1';
    else str = str + '0';
    if (youngGuardLocation != self) str = str + 'g0';
    else {
      switch (youngGuardYValue) {
        case 0:  str = str + 'g1'; break;
        case 1:  str = str + 'g2'; break;
        case 2:  str = str + 'g3'; break;
        default: str = str + 'g0'; break;
      }
    }
    if (assistantLocation != self) str = str + 'a0';
    else {
      // We deal with this case differently because we want to fix
      // the way it looks when the assistant is in the same room as
      // the two guards -- a common case. If they are all at 
      // the same vertical position in the same room, then they are 
      // smooshed together on the map and it doesn't look good.
      // 
      // To fix this, budge the assistant back a little.
      // 
      // In all other rooms but Hallway 6, this is a simple matter
      // of setting assistant.baseYValue = -1.
      // 
      // In Hallway 6, however, a Y value of -1 is problematic. 
      // So we make sure the assistant never has a Y value of 
      // less than zero there, while outputting graphics that 
      // *simulate the appearance* of a Y value of -1. Note that we only
      // do this when appropriate -- i.e., when there is one or more 
      // guard in Hallway 6 with a Y value of 0.
      switch (assistant.apparentYValueForHallway6) {
        case 1:  str = str + 'a2'; break;
        case 2:  str = str + 'a3'; break;
        case 0:  str = str + 'a1'; break;
        case -1: str = str + 'a4'; break;
        default: str = str + 'a0'; break;
      }
      //switch (assistantYValue) {
      //  case 1:  str = str + 'a2'; break;
      //  case 2:  str = str + 'a3'; break;
      //  case 0: 
      //    if ((youngGuardLocation == self && youngGuardYValue == 0) ||
      //        (oldGuardLocation == self && oldGuardYValue == 0))
      //      str = str + 'a4';
      //    else
      //      str = str + 'a1'; 
      //    break;
      //  default: str = str + 'a0'; break;
      //}
    }
    if (!me.isInForMap(self)) str = str + 'm0';
    else {
      switch (me.yValue) {
        case 0:  str = str + 'm1'; break;
        case 1:  str = str + 'm2'; break;
        case 2:  str = str + 'm3'; break;
        default: str = str + 'm0'; break;
      }
    }
    return str;
  }
  giveFilenameC() {
    local str;
    str = 'h6c-';
    if (slowingFieldIsOn) str = str + '1';
    else str = str + '0';
    if (assistantLocation != self) str = str + 'a0';
    else {
      // See comments above for why this is different
      switch (assistant.apparentYValueForHallway6) {
        case 1:  str = str + 'a2'; break;
        case 2:  str = str + 'a3'; break;
        case 0:  str = str + 'a1'; break;
        case -1: str = str + 'a4'; break;
        default: str = str + 'a0'; break;
      }
      //switch (assistantYValue) {
      //  case 1:  str = str + 'a2'; break;
      //  case 2:  str = str + 'a3'; break;
      //  case 0:
      //    if ((youngGuardLocation == self && youngGuardYValue == 0) ||
      //        (oldGuardLocation == self && oldGuardYValue == 0))
      //      str = str + 'a4';
      //    else
      //      str = str + 'a1'; 
      //    break;
      //  default: str = str + 'a0'; break;
      //}
    }
    if (oldGuardLocation != self) str = str + 'h0';
    else {
      switch (oldGuardYValue) {
        case 0:  str = str + 'h1'; break;
        case 1:  str = str + 'h2'; break;
        case 2:  str = str + 'h3'; break;
        default: str = str + 'h0'; break;
      }
    }
    if (!me.isInForMap(self)) str = str + 'm0';
    else {
      switch (me.yValue) {
        case 0:  str = str + 'm1'; break;
        case 1:  str = str + 'm2'; break;
        case 2:  str = str + 'm3'; break;
        default: str = str + 'm0'; break;
      }
    }
    return str;
  }
  giveFilenameD() {
    local str;
    str = 'h6d-';
    if (slowingFieldIsOn) str = str + '1';
    else str = str + '0';
    if (oldGuardLocation != self) str = str + 'h0';
    else {
      switch (oldGuardYValue) {
        case 0:  str = str + 'h1'; break;
        case 1:  str = str + 'h2'; break;
        case 2:  str = str + 'h3'; break;
        default: str = str + 'h0'; break;
      }
    }
    if (ovanLocation != self) str = str + 'q0';
    else {
      switch (ovanYValue) {
        case 0:  str = str + 'q1'; break;
        case 1:  str = str + 'q2'; break;
        case 2:  str = str + 'q3'; break;
        default: str = str + 'q0'; break;
      }
    }
    return str;
  }
  // See comments above for why this is weird.
  giveFilenameE() {
    if (assistantLocation == self && 
        assistant.apparentYValueForHallway6 == -1) {
      if (confDoorIsOpen) return 'h6e-0a4';
      else return 'h6e-1a4';
    }
    //if (assistantLocation == self && assistantYValue == 0 && 
    //    ((youngGuardLocation == self && youngGuardYValue == 0) || 
    //     (oldGuardLocation == self && oldGuardYValue == 0)))
    //{
    //  if (confDoorIsOpen) return 'h6e-0a4';
    //  else return 'h6e-1a4';
    //}
    else {
      if (confDoorIsOpen) return 'h6e-0a0';
      else return 'h6e-1a0';
    }
  }
;

modify assistant
  needsContinuingIllusoryYValueForHallway6 = nil
  apparentYValueForHallway6 {
    if (yValue != 0) {
      return yValue;
    }
    else { // yValue == 0
      if (!isStunned) {
        needsContinuingIllusoryYValueForHallway6 = nil;
      }
      else if (isStunned &&
          ((youngGuardLocation == hallway6 && youngGuardYValue == 0) ||
          (oldGuardLocation == hallway6 && oldGuardYValue == 0))) {
        needsContinuingIllusoryYValueForHallway6 = true;
      }
      if (glob.imminentDeathBySlowingField)
        return 0;
      else if (needsContinuingIllusoryYValueForHallway6 ||
          (youngGuardLocation == hallway6 && youngGuardYValue == 0) ||
          (oldGuardLocation == hallway6 && oldGuardYValue == 0))
        return -1;
      else
        return 0;
    }
  }
;

eastOfHallway6: object
  giveFilename() {
    if (me.saw(hallway6) || glob.hackEndgameMap)
      return 'zz-wall4';
    else
      return 'zz-nil';
  }
;

// -------------------------------------------------------------------
// ENDGAME MAP: giveFilename/giveHtml methods: sixth row (cell to conference room)
// -------------------------------------------------------------------

westOfCell: object
  giveFilename() {
    if (me.saw(cell) || glob.hackEndgameMap)
      return 'zz-wall6';
    else if (me.saw(hallway3))
      return 'zz-wall3';
    else
      return 'zz-nil';
  }
;
modify cell
  giveFilename() {
    local str;
    if (!me.saw(hallway4) && !glob.hackEndgameMap) {
      return 'zz-nil';
    }
    else if (!me.saw(self) && !glob.hackEndgameMap) {
      if (me.saw(hallway3) && me.saw(breakRoom)) {
        if (cellDoorIsOpen) return 'zz-doorwall2a6';
        else return 'zz-doorwall2c6';
      }
      else if (me.saw(breakRoom)) {
        return 'zz-wall6';
      }
      else if (me.saw(hallway3)) {
        if (cellDoorIsOpen) return 'zz-door2a';
        else return 'zz-door2c';
      }
      else {
        return 'zz-wall3';
      }
    }
    else {
      str = 'ce-';
      if (cellDoorIsOpen) str = str + '0';
      else str = str + '1';
      if (me.isInForMap(self)) str = str + 'm';
      if (vickiLocation == self || dianeLocation == self)
        str = str + 'wx';
      return str;
    }
  }
;
modify breakRoom
  giveFilename() {
    if (!me.saw(hallway5) && !glob.hackEndgameMap) {
      return 'zz-nil';
    }
    else if (!me.saw(self) && !glob.hackEndgameMap) {
      if (me.saw(cell) && me.saw(bathroom)) {
        if (breakDoorIsOpen) return 'zz-doorwalls2a46';
        else return 'zz-doorwalls2c46';
      }
      else if (me.saw(cell)) {
        if (breakDoorIsOpen) return 'zz-doorwall2a4';
        else return 'zz-doorwall2c4';
      }
      else if (me.saw(hallway4) && me.saw(bathroom)) {
        if (breakDoorIsOpen) return 'zz-doorwall2a6';
        else return 'zz-doorwall2c6';
      }
      else if (me.saw(bathroom)) {
        return 'zz-wall6';
      }
      else if (me.saw(hallway4)) {
        if (breakDoorIsOpen) return 'zz-door2a';
        else return 'zz-door2c';
      }
      else { // we already ruled out "hasn't seen hallway5"
        return 'zz-wall3';
      }
    }
    else if (netonLocation == self || ovanLocation == self) {
      if (breakDoorIsOpen) return 'br-0pqg';
      else return 'br-1pqg';
    }
    else if (youngGuardLocation == self || oldGuardLocation == self) {
      if (breakDoorIsOpen) return 'br-0g';
      else return 'br-1g';
    }
    else if (me.isInForMap(self)) {
      if (breakDoorIsOpen) return 'br-0m';
      else return 'br-1m';
    }
    else {
      if (breakDoorIsOpen) return 'br-0';
      else return 'br-1';
    }
  }
;
modify bathroom
  giveFilename() {
    if (!me.saw(self) && !glob.hackEndgameMap) {
      if (!me.saw(hallway5)) {
        return 'zz-nil';
      }
      if (me.saw(breakRoom) && me.saw(confRoom)) {
        if (bathDoorIsOpen) return 'zz-doorwalls2a46';
        else return 'zz-doorwalls2c46';
      }
      if (me.saw(breakRoom)) {
        if (bathDoorIsOpen) return 'zz-doorwall2a4';
        else return 'zz-doorwall2c4';
      }
      if (me.saw(confRoom)) {
        if (bathDoorIsOpen) return 'zz-doorwall2a6';
        else return 'zz-doorwall2c6';
      }
      if (bathDoorIsOpen) return 'zz-door2a';
      else return 'zz-door2c';
    }
    else {
      if (youngGuardLocation == self && oldGuardLocation == self) {
        if (bathDoorIsOpen) return 'ba-0gh';
        else return 'ba-1gh';
      }
      else if (youngGuardLocation == self || oldGuardLocation == self) {
        if (bathDoorIsOpen) return 'ba-0h';
        else return 'ba-1h';
      }
      else if (me.isInForMap(self)) {
        if (bathDoorIsOpen) return 'ba-0m';
        else return 'ba-1m';
      }
      else {
        if (bathDoorIsOpen) return 'ba-0';
        else return 'ba-1';
      }
    }
  }
;
modify confRoom
  giveFilename() {
    local str;
    if (!me.saw(self) && !glob.hackEndgameMap) {
      if (!me.saw(hallway5)) {
        return 'zz-nil';
      }
      if (me.saw(bathroom) && me.saw(hallway6)) {
        if (confDoorIsOpen) return 'zz-doorwall2a4';
        else return 'zz-doorwall2c4';
      }
      if (me.saw(bathroom)) {
        return 'zz-wall4';
      }
      if (me.saw(hallway6)) {
        if (confDoorIsOpen) return 'zz-door2a';
        else return 'zz-door2c';
      }
      else return 'zz-wall1';
    }
    else {
      str = 'co-';
      if (confDoorIsOpen) str = str + '0';
      else str = str + '1';
      if (assistantLocation==self 
       && (netonLocation==self || ovanLocation==self))
        str = str + 'pqa';
      else if (netonLocation == self || ovanLocation == self)
        str = str + 'pq';
      else if (assistantLocation == self && me.isInForMap(self))
        str = str + 'ma';
      else if (assistantLocation==self)
        str = str + 'a';
      else if (me.isInForMap(self))
        str = str + 'm';
      return str;
    }
  }
;
eastOfConfRoom: object
  giveFilename() {
    if (me.saw(confRoom) || glob.hackEndgameMap)
      return 'zz-wall4';
    else if (me.saw(hallway6))
      return 'zz-wall1';
    else
      return 'zz-nil';
  }
;

// -------------------------------------------------------------------
// ENDGAME MAP: giveFilename/giveHtml methods: seventh row (south of cell, etc.)
// -------------------------------------------------------------------

southwestOfCell: object
  giveFilename() {
    if (me.saw(cell)) {
      return 'zz-wall3';
    }
    else {
      return 'zz-nil';
    }
  }
;
southOfCell: object
  giveFilename() {
    if (me.saw(cell) || glob.hackEndgameMap)
      return 'zz-wall2';
    else if (me.saw(breakRoom))
      return 'zz-wall3';
    else
      return 'zz-nil';
  }
;
southOfBreakRoom: object
  giveFilename() {
    if (me.saw(breakRoom) || glob.hackEndgameMap)
      return 'zz-wall2';
    else if (me.saw(cell) && me.saw(bathroom))
      return 'zz-farcorners13';
    else if (me.saw(cell))
      return 'zz-wallspace12';
    else if (me.saw(bathroom))
      return 'zz-wallspace32';
    else
      return 'zz-nil';
  }
;
southOfBathroom: object
  giveFilename() {
    if (me.saw(bathroom) || glob.hackEndgameMap)
      return 'zz-wall2';
    else if (me.saw(breakRoom) && me.saw(confRoom))
      return 'zz-farcorners13';
    else if (me.saw(breakRoom))
      return 'zz-wallspace12';
    else if (me.saw(confRoom))
      return 'zz-wallspace32';
    else
      return 'zz-nil';
  }
;
southOfConfRoom: object
  giveFilename() {
    if (me.saw(confRoom) || glob.hackEndgameMap)
      return 'zz-wall2';
    else if (me.saw(bathroom))
      return 'zz-wall1';
    else
      return 'zz-nil';
  }
;
southeastOfConfRoom: object
  giveFilename() {
    if (me.saw(confRoom) || glob.hackEndgameMap)
      return 'zz-wall1';
    else
      return 'zz-nil';
  }
;

/*
northOfOffice: object;
northOfHallway8: object;
northOfHallway1: Room 'You won the game' south=frontDoors2;
northwestOfHallway1: object;
westOfHallway1: object;
westOfHallway2: object;
westOfHallway3: object;
westOfCell: object;
southwestOfCell: object;
southOfCell: object;
southOfBreakRoom: object;
southOfBathroom: object;
southOfConfRoom: object;
southeastOfConfRoom: object;
eastOfConfRoom: object;
eastOfHallway6: object;
eastOfStairs: object;
eastOfHallway9: object;
eastOfSkyway: object;
modify hallway1;
modify hallway2;
modify hallway3;
modify hallway4;
modify hallway5;
modify hallway6;
modify hallway7;
modify hallway8;
modify hallway9;
modify cell;
modify breakRoom;
modify bathroom;
modify confRoom;
modify office;
modify dreamRoom;
modify stairs;
modify skyway;
modify museum;
*/

/*
giveEndgameFilename(rm) {
  switch (rm) {
    
    case hallway1:      break;
    case hallway8:      break;
    case office:      break;
    case hallway9:      break;
    
    case hallway2:      break;
    case hallway7:      break;
    case dreamRoom:      break;
    case stairs:      break;
    
    case hallway3:      break;
    case hallway4:      break;
    case hallway5:      break;
    case hallway6:      break;
    
    case cell:      break;
    case breakRoom:      break;
    case bathroom:      break;
    case confRoom:      break;
    
    case skyway:      break;
    case museum:      break;
    case northOfOffice: break;
    case northOfHallway8: break;
    case northOfHallway1: break;
    case northwestOfHallway1: break;
    case westOfHallway1: break;
    case westOfHallway2: break;
    case westOfHallway3: break;
    case westOfCell: break;
    case southwestOfCell: break;
    case southOfCell: break;
    case southOfBreakRoom: break;
    case southOfBathroom: break;
    case southOfConfRoom: break;
    case southeastOfConfRoom: break;
    case eastOfConfRoom: break;
    case eastOfHallway6: break;
    case eastOfStairs: break;
    case eastOfHallway9: break;
    case eastOfSkyway: break;
  }
}
*/

// -------------------------------------------------------------------
// ENDGAME MAP: endgameMapPrint
// -------------------------------------------------------------------

function endgameMapPrint() {
return '<table border="0" cellspacing="0" cellpadding="0">
  <tr> 
    <td align="right">' + museum.giveHtml() + '</td>
  </tr>
  <tr> 
    <td>
      <table border="0" cellspacing="0" cellpadding="0">
        <tr> 
          <td align="right" valign="bottom"><img src="endgame/' + northwestOfHallway1.giveFilename() + '.png" border="0"></td>
          <td align="right" valign="bottom"><img src="endgame/' + northOfHallway1.giveFilename() + '.png" border="0"></td>
          <td align="right" valign="bottom"><img src="endgame/' + northOfHallway8.giveFilename() + '.png" border="0"></td>
          <td valign="bottom"><img src="endgame/' + northOfOffice.giveFilename() + '.png" border="0"></td>
          <td valign="bottom" align="left">' + skyway.giveHtml() + '</td>
          <td valign="bottom" align="left"><img src="endgame/' + eastOfSkyway.giveFilename() + '.png" border="0"></td>
        </tr>
        <tr> 
          <td align="right" valign="bottom"><img src="endgame/' + westOfHallway1.giveFilename() + '.png" border="0"></td>
          <td align="right" valign="bottom"><img src="endgame/' + hallway1.giveFilename() + '.png" border="0"></td>
          <td align="right" valign="bottom"><img src="endgame/' + hallway8.giveFilename() + '.png" border="0"></td>
          <td><img src="endgame/' + office.giveFilename() + '.png" border="0"></td>
          <td align="left" valign="bottom">' + hallway9.giveHtml() + '</td>
          <td align="left" valign="bottom"><img src="endgame/' + eastOfHallway9.giveFilename() + '.png" border="0"></td>
        </tr>
        <tr> 
          <td align="right" valign="bottom"><img src="endgame/' + westOfHallway2.giveFilename() + '.png" border="0"></td>
          <td align="right" valign="bottom"><img src="endgame/' + hallway2.giveFilename() + '.png" border="0"></td>
          <td align="right" valign="bottom"><img src="endgame/' + hallway7.giveFilename() + '.png" border="0"></td>
          <td><img src="endgame/' + dreamRoom.giveFilename() + '.png" border="0"></td>
          <td align="left" valign="bottom">' + stairs.giveHtml() + '</td>
          <td align="left" valign="bottom"><img src="endgame/' + eastOfStairs.giveFilename() + '.png" border="0"></td>
        </tr>
        <tr> 
          <td align="right" valign="top"><img src="endgame/' + westOfHallway3.giveFilename() + '.png" border="0"></td>
          <td align="right" valign="top"><img src="endgame/' + hallway3.giveFilename() + '.png" border="0"></td>
          <td align="right" valign="top"><img src="endgame/' + hallway4.giveFilename() + '.png" border="0"></td>
          <td valign="top"><img src="endgame/' + hallway5.giveFilename() + '.png" border="0"></td>
          <td align="left" valign="top">' + hallway6.giveHtml() + '</td>
          <td align="left" valign="top"><img src="endgame/' + eastOfHallway6.giveFilename() + '.png" border="0"></td>
        </tr>
        <tr> 
          <td align="right" valign="top"><img src="endgame/' + westOfCell.giveFilename() + '.png" border="0"></td>
          <td align="right" valign="top"><img src="endgame/' + cell.giveFilename() + '.png" border="0"></td>
          <td align="right" valign="top"><img src="endgame/' + breakRoom.giveFilename() + '.png" border="0"></td>
          <td valign="top"><img src="endgame/' + bathroom.giveFilename() + '.png" border="0"></td>
          <td align="left" valign="top"><img src="endgame/' + confRoom.giveFilename() + '.png" border="0"></td>
          <td align="left" valign="top"><img src="endgame/' + eastOfConfRoom.giveFilename() + '.png" border="0"></td>
        </tr>
        <tr> 
          <td align="right" valign="top"><img src="endgame/' + southwestOfCell.giveFilename() + '.png" border="0"></td>
          <td align="right" valign="top"><img src="endgame/' + southOfCell.giveFilename() + '.png" border="0"></td>
          <td align="right" valign="top"><img src="endgame/' + southOfBreakRoom.giveFilename() + '.png" border="0"></td>
          <td valign="top"><img src="endgame/' + southOfBathroom.giveFilename() + '.png" border="0"></td>
          <td align="left" valign="top"><img src="endgame/' + southOfConfRoom.giveFilename() + '.png" border="0"></td>
          <td align="left" valign="top"><img src="endgame/' + southeastOfConfRoom.giveFilename() + '.png" border="0"></td>
        </tr>
      </table>
    </td>
  </tr>
</table>';
}


/*
                   museum
                     |
                   skyway
  D                  |
 hw1   hw8--office  hw9
  |     |            |
 hw2   hw7  dream  stairs
  D     |     |      |
 hw3---hw4---hw5----hw6
  |     |     |      |
cell  break  bath   conf
*/

